// third_party/blink/public/mojom/loader/fetch_client_settings_object.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_FETCH_CLIENT_SETTINGS_OBJECT_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_FETCH_CLIENT_SETTINGS_OBJECT_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/loader/fetch_client_settings_object.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "services/network/public/mojom/referrer_policy.mojom-shared.h"


namespace blink::mojom {
class FetchClientSettingsObjectDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::FetchClientSettingsObjectDataView> {
  using Data = ::blink::mojom::internal::FetchClientSettingsObject_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class InsecureRequestsPolicy : int32_t {
  
  kDoNotUpgrade = 0,
  
  kUpgrade = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, InsecureRequestsPolicy value);
inline bool IsKnownEnumValue(InsecureRequestsPolicy value) {
  return internal::InsecureRequestsPolicy_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class FetchClientSettingsObjectDataView {
 public:
  FetchClientSettingsObjectDataView() = default;

  FetchClientSettingsObjectDataView(
      internal::FetchClientSettingsObject_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadReferrerPolicy(UserType* output) const {
    auto data_value = data_->referrer_policy;
    return mojo::internal::Deserialize<::network::mojom::ReferrerPolicy>(
        data_value, output);
  }
  ::network::mojom::ReferrerPolicy referrer_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ReferrerPolicy>(data_->referrer_policy));
  }
  inline void GetOutgoingReferrerDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutgoingReferrer(UserType* output) {
    
    auto* pointer = data_->outgoing_referrer.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadInsecureRequestsPolicy(UserType* output) const {
    auto data_value = data_->insecure_requests_policy;
    return mojo::internal::Deserialize<::blink::mojom::InsecureRequestsPolicy>(
        data_value, output);
  }
  InsecureRequestsPolicy insecure_requests_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::InsecureRequestsPolicy>(data_->insecure_requests_policy));
  }
 private:
  internal::FetchClientSettingsObject_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_FETCH_CLIENT_SETTINGS_OBJECT_MOJOM_DATA_VIEW_H_