// third_party/blink/public/mojom/loader/code_cache.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  BigBuffer as mojoBase_mojom_BigBuffer,
  BigBufferSpec as mojoBase_mojom_BigBufferSpec
} from '../../../../../mojo/public/mojom/base/big_buffer.mojom.m.js';

import {
  Time as mojoBase_mojom_Time,
  TimeSpec as mojoBase_mojom_TimeSpec
} from '../../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CodeCacheTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CodeCacheType = {
  
  kJavascript: 0,
  kWebAssembly: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class CodeCacheHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.CodeCacheHost', scope);
  }
}

/** @interface */
export class CodeCacheHostInterface {
  
  /**
   * @param { !CodeCacheType } cacheType
   * @param { !url_mojom_Url } url
   * @param { !mojoBase_mojom_Time } expectedResponseTime
   * @param { !mojoBase_mojom_BigBuffer } data
   */

  didGenerateCacheableMetadata(cacheType, url, expectedResponseTime, data) {}
  
  /**
   * @param { !CodeCacheType } cacheType
   * @param { !url_mojom_Url } url
   * @return {!Promise<{
        responseTime: !mojoBase_mojom_Time,
        data: !mojoBase_mojom_BigBuffer,
   *  }>}
   */

  fetchCachedCode(cacheType, url) {}
  
  /**
   * @param { !CodeCacheType } cacheType
   * @param { !url_mojom_Url } url
   */

  clearCodeCacheEntry(cacheType, url) {}
  
  /**
   * @param { !url_mojom_Url } url
   * @param { !mojoBase_mojom_Time } expectedResponseTime
   * @param { !mojoBase_mojom_BigBuffer } data
   * @param { !string } cacheStorageCacheName
   */

  didGenerateCacheableMetadataInCacheStorage(url, expectedResponseTime, data, cacheStorageCacheName) {}
}

/**
 * @implements { CodeCacheHostInterface }
 */
export class CodeCacheHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!CodeCacheHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CodeCacheHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!CodeCacheHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !CodeCacheType } cacheType
   * @param { !url_mojom_Url } url
   * @param { !mojoBase_mojom_Time } expectedResponseTime
   * @param { !mojoBase_mojom_BigBuffer } data
   */

  didGenerateCacheableMetadata(
      cacheType,
      url,
      expectedResponseTime,
      data) {
    this.proxy.sendMessage(
        0,
        CodeCacheHost_DidGenerateCacheableMetadata_ParamsSpec.$,
        null,
        [
          cacheType,
          url,
          expectedResponseTime,
          data
        ],
        false);
  }

  
  /**
   * @param { !CodeCacheType } cacheType
   * @param { !url_mojom_Url } url
   * @return {!Promise<{
        responseTime: !mojoBase_mojom_Time,
        data: !mojoBase_mojom_BigBuffer,
   *  }>}
   */

  fetchCachedCode(
      cacheType,
      url) {
    return this.proxy.sendMessage(
        1,
        CodeCacheHost_FetchCachedCode_ParamsSpec.$,
        CodeCacheHost_FetchCachedCode_ResponseParamsSpec.$,
        [
          cacheType,
          url
        ],
        false);
  }

  
  /**
   * @param { !CodeCacheType } cacheType
   * @param { !url_mojom_Url } url
   */

  clearCodeCacheEntry(
      cacheType,
      url) {
    this.proxy.sendMessage(
        2,
        CodeCacheHost_ClearCodeCacheEntry_ParamsSpec.$,
        null,
        [
          cacheType,
          url
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @param { !mojoBase_mojom_Time } expectedResponseTime
   * @param { !mojoBase_mojom_BigBuffer } data
   * @param { !string } cacheStorageCacheName
   */

  didGenerateCacheableMetadataInCacheStorage(
      url,
      expectedResponseTime,
      data,
      cacheStorageCacheName) {
    this.proxy.sendMessage(
        3,
        CodeCacheHost_DidGenerateCacheableMetadataInCacheStorage_ParamsSpec.$,
        null,
        [
          url,
          expectedResponseTime,
          data,
          cacheStorageCacheName
        ],
        false);
  }
}

/**
 * An object which receives request messages for the CodeCacheHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CodeCacheHostReceiver {
  /**
   * @param {!CodeCacheHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!CodeCacheHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CodeCacheHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CodeCacheHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CodeCacheHost_DidGenerateCacheableMetadata_ParamsSpec.$,
        null,
        impl.didGenerateCacheableMetadata.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        CodeCacheHost_FetchCachedCode_ParamsSpec.$,
        CodeCacheHost_FetchCachedCode_ResponseParamsSpec.$,
        impl.fetchCachedCode.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        CodeCacheHost_ClearCodeCacheEntry_ParamsSpec.$,
        null,
        impl.clearCodeCacheEntry.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        CodeCacheHost_DidGenerateCacheableMetadataInCacheStorage_ParamsSpec.$,
        null,
        impl.didGenerateCacheableMetadataInCacheStorage.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CodeCacheHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.CodeCacheHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!CodeCacheHostRemote}
   */
  static getRemote() {
    let remote = new CodeCacheHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the CodeCacheHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CodeCacheHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CodeCacheHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CodeCacheHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didGenerateCacheableMetadata =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CodeCacheHost_DidGenerateCacheableMetadata_ParamsSpec.$,
        null,
        this.didGenerateCacheableMetadata.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.fetchCachedCode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        CodeCacheHost_FetchCachedCode_ParamsSpec.$,
        CodeCacheHost_FetchCachedCode_ResponseParamsSpec.$,
        this.fetchCachedCode.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearCodeCacheEntry =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        CodeCacheHost_ClearCodeCacheEntry_ParamsSpec.$,
        null,
        this.clearCodeCacheEntry.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didGenerateCacheableMetadataInCacheStorage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        CodeCacheHost_DidGenerateCacheableMetadataInCacheStorage_ParamsSpec.$,
        null,
        this.didGenerateCacheableMetadataInCacheStorage.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CodeCacheHost_DidGenerateCacheableMetadata_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CodeCacheHost_FetchCachedCode_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CodeCacheHost_FetchCachedCode_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CodeCacheHost_ClearCodeCacheEntry_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CodeCacheHost_DidGenerateCacheableMetadataInCacheStorage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    CodeCacheHost_DidGenerateCacheableMetadata_ParamsSpec.$,
    'CodeCacheHost_DidGenerateCacheableMetadata_Params',
    [
      mojo.internal.StructField(
        'cacheType', 0,
        0,
        CodeCacheTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'expectedResponseTime', 16,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'data', 24,
        0,
        mojoBase_mojom_BigBufferSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class CodeCacheHost_DidGenerateCacheableMetadata_Params {
  constructor() {
    /** @type { !CodeCacheType } */
    this.cacheType;
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !mojoBase_mojom_Time } */
    this.expectedResponseTime;
    /** @type { !mojoBase_mojom_BigBuffer } */
    this.data;
  }
}



mojo.internal.Struct(
    CodeCacheHost_FetchCachedCode_ParamsSpec.$,
    'CodeCacheHost_FetchCachedCode_Params',
    [
      mojo.internal.StructField(
        'cacheType', 0,
        0,
        CodeCacheTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CodeCacheHost_FetchCachedCode_Params {
  constructor() {
    /** @type { !CodeCacheType } */
    this.cacheType;
    /** @type { !url_mojom_Url } */
    this.url;
  }
}



mojo.internal.Struct(
    CodeCacheHost_FetchCachedCode_ResponseParamsSpec.$,
    'CodeCacheHost_FetchCachedCode_ResponseParams',
    [
      mojo.internal.StructField(
        'responseTime', 0,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojoBase_mojom_BigBufferSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class CodeCacheHost_FetchCachedCode_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_Time } */
    this.responseTime;
    /** @type { !mojoBase_mojom_BigBuffer } */
    this.data;
  }
}



mojo.internal.Struct(
    CodeCacheHost_ClearCodeCacheEntry_ParamsSpec.$,
    'CodeCacheHost_ClearCodeCacheEntry_Params',
    [
      mojo.internal.StructField(
        'cacheType', 0,
        0,
        CodeCacheTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CodeCacheHost_ClearCodeCacheEntry_Params {
  constructor() {
    /** @type { !CodeCacheType } */
    this.cacheType;
    /** @type { !url_mojom_Url } */
    this.url;
  }
}



mojo.internal.Struct(
    CodeCacheHost_DidGenerateCacheableMetadataInCacheStorage_ParamsSpec.$,
    'CodeCacheHost_DidGenerateCacheableMetadataInCacheStorage_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'expectedResponseTime', 8,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'data', 16,
        0,
        mojoBase_mojom_BigBufferSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cacheStorageCacheName', 32,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class CodeCacheHost_DidGenerateCacheableMetadataInCacheStorage_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !mojoBase_mojom_Time } */
    this.expectedResponseTime;
    /** @type { !mojoBase_mojom_BigBuffer } */
    this.data;
    /** @type { !string } */
    this.cacheStorageCacheName;
  }
}

