// third_party/blink/public/mojom/keyboard_lock/keyboard_lock.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_KEYBOARD_LOCK_KEYBOARD_LOCK_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_KEYBOARD_LOCK_KEYBOARD_LOCK_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/keyboard_lock/keyboard_lock.mojom-shared-internal.h"


namespace blink::mojom {
class GetKeyboardLayoutMapResultDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::GetKeyboardLayoutMapResultDataView> {
  using Data = ::blink::mojom::internal::GetKeyboardLayoutMapResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class KeyboardLockRequestResult : int32_t {
  
  kSuccess = 0,
  
  kFrameDetachedError = 1,
  
  kNoValidKeyCodesError = 2,
  
  kChildFrameError = 3,
  
  kRequestFailedError = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, KeyboardLockRequestResult value);
inline bool IsKnownEnumValue(KeyboardLockRequestResult value) {
  return internal::KeyboardLockRequestResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class GetKeyboardLayoutMapStatus : int32_t {
  
  kSuccess = 0,
  
  kFail = 1,
  
  kDenied = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, GetKeyboardLayoutMapStatus value);
inline bool IsKnownEnumValue(GetKeyboardLayoutMapStatus value) {
  return internal::GetKeyboardLayoutMapStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class KeyboardLockServiceInterfaceBase {};

using KeyboardLockServicePtrDataView =
    mojo::InterfacePtrDataView<KeyboardLockServiceInterfaceBase>;
using KeyboardLockServiceRequestDataView =
    mojo::InterfaceRequestDataView<KeyboardLockServiceInterfaceBase>;
using KeyboardLockServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<KeyboardLockServiceInterfaceBase>;
using KeyboardLockServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<KeyboardLockServiceInterfaceBase>;


class GetKeyboardLayoutMapResultDataView {
 public:
  GetKeyboardLayoutMapResultDataView() = default;

  GetKeyboardLayoutMapResultDataView(
      internal::GetKeyboardLayoutMapResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::blink::mojom::GetKeyboardLayoutMapStatus>(
        data_value, output);
  }
  GetKeyboardLayoutMapStatus status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::GetKeyboardLayoutMapStatus>(data_->status));
  }
  inline void GetLayoutMapDataView(
      mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLayoutMap(UserType* output) {
    
    auto* pointer = data_->layout_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::GetKeyboardLayoutMapResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_KEYBOARD_LOCK_KEYBOARD_LOCK_MOJOM_DATA_VIEW_H_