// third_party/blink/public/mojom/interest_group/ad_display_size.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/interest_group/ad_display_size.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }



  function AdSize(values) {
    this.initDefaults_();
    this.initFields_(values);
  }

  AdSize.LengthUnit = {};
  AdSize.LengthUnit.kInvalid = 0;
  AdSize.LengthUnit.kPixels = 1;
  AdSize.LengthUnit.kScreenWidth = 2;
  AdSize.LengthUnit.kScreenHeight = 3;
  AdSize.LengthUnit.MIN_VALUE = 0;
  AdSize.LengthUnit.MAX_VALUE = 3;
  AdSize.LengthUnit.DEFAULT_VALUE = 0;

  AdSize.LengthUnit.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  AdSize.LengthUnit.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  AdSize.LengthUnit.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  AdSize.prototype.initDefaults_ = function() {
    this.width = 0;
    this.widthUnits = 0;
    this.heightUnits = 0;
    this.height = 0;
  };
  AdSize.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AdSize.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate AdSize.widthUnits
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, AdSize.LengthUnit);
    if (err !== validator.validationError.NONE)
        return err;



    // validate AdSize.heightUnits
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, AdSize.LengthUnit);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AdSize.encodedSize = codec.kStructHeaderSize + 24;

  AdSize.decode = function(decoder) {
    var packed;
    var val = new AdSize();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.width =
        decoder.decodeStruct(codec.Double);
    val.widthUnits =
        decoder.decodeStruct(new codec.Enum(AdSize.LengthUnit));
    val.heightUnits =
        decoder.decodeStruct(new codec.Enum(AdSize.LengthUnit));
    val.height =
        decoder.decodeStruct(codec.Double);
    return val;
  };

  AdSize.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AdSize.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Double, val.width);
    encoder.encodeStruct(codec.Int32, val.widthUnits);
    encoder.encodeStruct(codec.Int32, val.heightUnits);
    encoder.encodeStruct(codec.Double, val.height);
  };
  function AdDescriptor(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AdDescriptor.prototype.initDefaults_ = function() {
    this.url = null;
    this.size = null;
  };
  AdDescriptor.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AdDescriptor.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AdDescriptor.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AdDescriptor.size
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, AdSize, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AdDescriptor.encodedSize = codec.kStructHeaderSize + 16;

  AdDescriptor.decode = function(decoder) {
    var packed;
    var val = new AdDescriptor();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.size =
        decoder.decodeStructPointer(AdSize);
    return val;
  };

  AdDescriptor.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AdDescriptor.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStructPointer(AdSize, val.size);
  };
  exports.AdSize = AdSize;
  exports.AdDescriptor = AdDescriptor;
})();