// third_party/blink/public/mojom/interest_group/ad_auction_service.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('blink.mojom.AdAuctionPerSellerRequest');
goog.require('blink.mojom.AdKeywordReplacement');
goog.require('blink.mojom.AdRequestConfig');
goog.require('blink.mojom.AuctionAdConfig');
goog.require('blink.mojom.AuctionAdConfigBuyerCurrencies');
goog.require('blink.mojom.AuctionAdConfigBuyerTimeouts');
goog.require('blink.mojom.AuctionDataConfig');
goog.require('blink.mojom.DirectFromSellerSignals');
goog.require('blink.mojom.FencedFrameConfig');
goog.require('blink.mojom.InterestGroup');
goog.require('url.mojom.Origin');
goog.require('url.mojom.Url');
goog.require('mojoBase.mojom.Uuid');
goog.require('mojoBase.mojom.BigBuffer');




goog.provide('blink.mojom.AuctionAdConfigField');
goog.provide('blink.mojom.AuctionAdConfigFieldSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.AuctionAdConfigFieldSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.AuctionAdConfigField = {
  
  kAuctionSignals: 0,
  kSellerSignals: 1,
  kSellerTKVSignals: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

goog.provide('blink.mojom.AuctionAdConfigBuyerTimeoutField');
goog.provide('blink.mojom.AuctionAdConfigBuyerTimeoutFieldSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.AuctionAdConfigBuyerTimeoutFieldSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.AuctionAdConfigBuyerTimeoutField = {
  
  kPerBuyerTimeouts: 0,
  kPerBuyerCumulativeTimeouts: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



goog.provide('blink.mojom.AbortableAdAuction');
goog.provide('blink.mojom.AbortableAdAuctionReceiver');
goog.provide('blink.mojom.AbortableAdAuctionCallbackRouter');
goog.provide('blink.mojom.AbortableAdAuctionInterface');
goog.provide('blink.mojom.AbortableAdAuctionRemote');
goog.provide('blink.mojom.AbortableAdAuctionPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.AbortableAdAuctionPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.AbortableAdAuction.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.AbortableAdAuctionInterface = class {
  
  /**
   * @param { !blink.mojom.AuctionAdConfigAuctionId } auction
   * @param { !blink.mojom.AuctionAdConfigField } field
   * @param { ?string } jsonValue
   */

  resolvedPromiseParam(auction, field, jsonValue) {}
  
  /**
   * @param { !blink.mojom.AuctionAdConfigAuctionId } auction
   * @param { ?Map<!url.mojom.Origin, !string> } perBuyerSignals
   */

  resolvedPerBuyerSignalsPromise(auction, perBuyerSignals) {}
  
  /**
   * @param { !blink.mojom.AuctionAdConfigAuctionId } auction
   * @param { !url.mojom.Origin } buyer
   * @param { ?string } jsonValue
   */

  resolvedBuyerTkvSignalsPromise(auction, buyer, jsonValue) {}
  
  /**
   * @param { !blink.mojom.AuctionAdConfigAuctionId } auction
   * @param { !blink.mojom.AuctionAdConfigBuyerTimeoutField } field
   * @param { !blink.mojom.AuctionAdConfigBuyerTimeouts } buyerTimeouts
   */

  resolvedBuyerTimeoutsPromise(auction, field, buyerTimeouts) {}
  
  /**
   * @param { !blink.mojom.AuctionAdConfigAuctionId } auction
   * @param { !blink.mojom.AuctionAdConfigBuyerCurrencies } perBuyerCurrencies
   */

  resolvedBuyerCurrenciesPromise(auction, perBuyerCurrencies) {}
  
  /**
   * @param { !blink.mojom.AuctionAdConfigAuctionId } auction
   * @param { ?blink.mojom.DirectFromSellerSignals } directFromSellerSignals
   */

  resolvedDirectFromSellerSignalsPromise(auction, directFromSellerSignals) {}
  
  /**
   * @param { !blink.mojom.AuctionAdConfigAuctionId } auction
   * @param { ?string } directFromSellerSignalsHeaderAdSlot
   */

  resolvedDirectFromSellerSignalsHeaderAdSlotPromise(auction, directFromSellerSignalsHeaderAdSlot) {}
  
  /**
   * @param { !blink.mojom.AuctionAdConfigAuctionId } auction
   * @param { !Array<!blink.mojom.AdKeywordReplacement> } deprecatedRenderUrlReplacements
   */

  resolvedDeprecatedRenderURLReplacementsPromise(auction, deprecatedRenderUrlReplacements) {}
  
  /**
   * @param { !blink.mojom.AuctionAdConfigAuctionId } auction
   * @param { !mojoBase.mojom.BigBuffer } result
   */

  resolvedAuctionAdResponsePromise(auction, result) {}
  
  /**
   * @param { !blink.mojom.AuctionAdConfigAuctionId } auction
   */

  resolvedAdditionalBids(auction) {}
  
  /**
   */

  abort() {}
};

/**
 * @export
 * @implements { blink.mojom.AbortableAdAuctionInterface }
 */
blink.mojom.AbortableAdAuctionRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.AbortableAdAuctionPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.AbortableAdAuctionPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.AbortableAdAuctionPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.AuctionAdConfigAuctionId } auction
   * @param { !blink.mojom.AuctionAdConfigField } field
   * @param { ?string } jsonValue
   */

  resolvedPromiseParam(
      auction,
      field,
      jsonValue) {
    this.proxy.sendMessage(
        0,
        blink.mojom.AbortableAdAuction_ResolvedPromiseParam_ParamsSpec.$,
        null,
        [
          auction,
          field,
          jsonValue
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.AuctionAdConfigAuctionId } auction
   * @param { ?Map<!url.mojom.Origin, !string> } perBuyerSignals
   */

  resolvedPerBuyerSignalsPromise(
      auction,
      perBuyerSignals) {
    this.proxy.sendMessage(
        1,
        blink.mojom.AbortableAdAuction_ResolvedPerBuyerSignalsPromise_ParamsSpec.$,
        null,
        [
          auction,
          perBuyerSignals
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.AuctionAdConfigAuctionId } auction
   * @param { !url.mojom.Origin } buyer
   * @param { ?string } jsonValue
   */

  resolvedBuyerTkvSignalsPromise(
      auction,
      buyer,
      jsonValue) {
    this.proxy.sendMessage(
        2,
        blink.mojom.AbortableAdAuction_ResolvedBuyerTkvSignalsPromise_ParamsSpec.$,
        null,
        [
          auction,
          buyer,
          jsonValue
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.AuctionAdConfigAuctionId } auction
   * @param { !blink.mojom.AuctionAdConfigBuyerTimeoutField } field
   * @param { !blink.mojom.AuctionAdConfigBuyerTimeouts } buyerTimeouts
   */

  resolvedBuyerTimeoutsPromise(
      auction,
      field,
      buyerTimeouts) {
    this.proxy.sendMessage(
        3,
        blink.mojom.AbortableAdAuction_ResolvedBuyerTimeoutsPromise_ParamsSpec.$,
        null,
        [
          auction,
          field,
          buyerTimeouts
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.AuctionAdConfigAuctionId } auction
   * @param { !blink.mojom.AuctionAdConfigBuyerCurrencies } perBuyerCurrencies
   */

  resolvedBuyerCurrenciesPromise(
      auction,
      perBuyerCurrencies) {
    this.proxy.sendMessage(
        4,
        blink.mojom.AbortableAdAuction_ResolvedBuyerCurrenciesPromise_ParamsSpec.$,
        null,
        [
          auction,
          perBuyerCurrencies
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.AuctionAdConfigAuctionId } auction
   * @param { ?blink.mojom.DirectFromSellerSignals } directFromSellerSignals
   */

  resolvedDirectFromSellerSignalsPromise(
      auction,
      directFromSellerSignals) {
    this.proxy.sendMessage(
        5,
        blink.mojom.AbortableAdAuction_ResolvedDirectFromSellerSignalsPromise_ParamsSpec.$,
        null,
        [
          auction,
          directFromSellerSignals
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.AuctionAdConfigAuctionId } auction
   * @param { ?string } directFromSellerSignalsHeaderAdSlot
   */

  resolvedDirectFromSellerSignalsHeaderAdSlotPromise(
      auction,
      directFromSellerSignalsHeaderAdSlot) {
    this.proxy.sendMessage(
        6,
        blink.mojom.AbortableAdAuction_ResolvedDirectFromSellerSignalsHeaderAdSlotPromise_ParamsSpec.$,
        null,
        [
          auction,
          directFromSellerSignalsHeaderAdSlot
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.AuctionAdConfigAuctionId } auction
   * @param { !Array<!blink.mojom.AdKeywordReplacement> } deprecatedRenderUrlReplacements
   */

  resolvedDeprecatedRenderURLReplacementsPromise(
      auction,
      deprecatedRenderUrlReplacements) {
    this.proxy.sendMessage(
        7,
        blink.mojom.AbortableAdAuction_ResolvedDeprecatedRenderURLReplacementsPromise_ParamsSpec.$,
        null,
        [
          auction,
          deprecatedRenderUrlReplacements
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.AuctionAdConfigAuctionId } auction
   * @param { !mojoBase.mojom.BigBuffer } result
   */

  resolvedAuctionAdResponsePromise(
      auction,
      result) {
    this.proxy.sendMessage(
        8,
        blink.mojom.AbortableAdAuction_ResolvedAuctionAdResponsePromise_ParamsSpec.$,
        null,
        [
          auction,
          result
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.AuctionAdConfigAuctionId } auction
   */

  resolvedAdditionalBids(
      auction) {
    this.proxy.sendMessage(
        9,
        blink.mojom.AbortableAdAuction_ResolvedAdditionalBids_ParamsSpec.$,
        null,
        [
          auction
        ],
        false);
  }

  
  /**
   */

  abort() {
    this.proxy.sendMessage(
        10,
        blink.mojom.AbortableAdAuction_Abort_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AbortableAdAuction
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.AbortableAdAuctionReceiver = class {
  /**
   * @param {!blink.mojom.AbortableAdAuctionInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.AbortableAdAuctionRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.AbortableAdAuctionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AbortableAdAuctionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AbortableAdAuction_ResolvedPromiseParam_ParamsSpec.$,
        null,
        impl.resolvedPromiseParam.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.AbortableAdAuction_ResolvedPerBuyerSignalsPromise_ParamsSpec.$,
        null,
        impl.resolvedPerBuyerSignalsPromise.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.AbortableAdAuction_ResolvedBuyerTkvSignalsPromise_ParamsSpec.$,
        null,
        impl.resolvedBuyerTkvSignalsPromise.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.AbortableAdAuction_ResolvedBuyerTimeoutsPromise_ParamsSpec.$,
        null,
        impl.resolvedBuyerTimeoutsPromise.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.AbortableAdAuction_ResolvedBuyerCurrenciesPromise_ParamsSpec.$,
        null,
        impl.resolvedBuyerCurrenciesPromise.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.AbortableAdAuction_ResolvedDirectFromSellerSignalsPromise_ParamsSpec.$,
        null,
        impl.resolvedDirectFromSellerSignalsPromise.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.AbortableAdAuction_ResolvedDirectFromSellerSignalsHeaderAdSlotPromise_ParamsSpec.$,
        null,
        impl.resolvedDirectFromSellerSignalsHeaderAdSlotPromise.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        blink.mojom.AbortableAdAuction_ResolvedDeprecatedRenderURLReplacementsPromise_ParamsSpec.$,
        null,
        impl.resolvedDeprecatedRenderURLReplacementsPromise.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        blink.mojom.AbortableAdAuction_ResolvedAuctionAdResponsePromise_ParamsSpec.$,
        null,
        impl.resolvedAuctionAdResponsePromise.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        blink.mojom.AbortableAdAuction_ResolvedAdditionalBids_ParamsSpec.$,
        null,
        impl.resolvedAdditionalBids.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        blink.mojom.AbortableAdAuction_Abort_ParamsSpec.$,
        null,
        impl.abort.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.AbortableAdAuction = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AbortableAdAuction";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.AbortableAdAuctionRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.AbortableAdAuctionRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AbortableAdAuction
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.AbortableAdAuctionCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.AbortableAdAuctionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AbortableAdAuctionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resolvedPromiseParam =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AbortableAdAuction_ResolvedPromiseParam_ParamsSpec.$,
        null,
        this.resolvedPromiseParam.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resolvedPerBuyerSignalsPromise =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.AbortableAdAuction_ResolvedPerBuyerSignalsPromise_ParamsSpec.$,
        null,
        this.resolvedPerBuyerSignalsPromise.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resolvedBuyerTkvSignalsPromise =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.AbortableAdAuction_ResolvedBuyerTkvSignalsPromise_ParamsSpec.$,
        null,
        this.resolvedBuyerTkvSignalsPromise.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resolvedBuyerTimeoutsPromise =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.AbortableAdAuction_ResolvedBuyerTimeoutsPromise_ParamsSpec.$,
        null,
        this.resolvedBuyerTimeoutsPromise.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resolvedBuyerCurrenciesPromise =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.AbortableAdAuction_ResolvedBuyerCurrenciesPromise_ParamsSpec.$,
        null,
        this.resolvedBuyerCurrenciesPromise.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resolvedDirectFromSellerSignalsPromise =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.AbortableAdAuction_ResolvedDirectFromSellerSignalsPromise_ParamsSpec.$,
        null,
        this.resolvedDirectFromSellerSignalsPromise.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resolvedDirectFromSellerSignalsHeaderAdSlotPromise =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.AbortableAdAuction_ResolvedDirectFromSellerSignalsHeaderAdSlotPromise_ParamsSpec.$,
        null,
        this.resolvedDirectFromSellerSignalsHeaderAdSlotPromise.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resolvedDeprecatedRenderURLReplacementsPromise =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        blink.mojom.AbortableAdAuction_ResolvedDeprecatedRenderURLReplacementsPromise_ParamsSpec.$,
        null,
        this.resolvedDeprecatedRenderURLReplacementsPromise.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resolvedAuctionAdResponsePromise =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        blink.mojom.AbortableAdAuction_ResolvedAuctionAdResponsePromise_ParamsSpec.$,
        null,
        this.resolvedAuctionAdResponsePromise.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resolvedAdditionalBids =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        blink.mojom.AbortableAdAuction_ResolvedAdditionalBids_ParamsSpec.$,
        null,
        this.resolvedAdditionalBids.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.abort =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        blink.mojom.AbortableAdAuction_Abort_ParamsSpec.$,
        null,
        this.abort.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.AdAuctionService');
goog.provide('blink.mojom.AdAuctionServiceReceiver');
goog.provide('blink.mojom.AdAuctionServiceCallbackRouter');
goog.provide('blink.mojom.AdAuctionServiceInterface');
goog.provide('blink.mojom.AdAuctionServiceRemote');
goog.provide('blink.mojom.AdAuctionServicePendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.AdAuctionServicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.AdAuctionService.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.AdAuctionServiceInterface = class {
  
  /**
   * @param { !blink.mojom.AdRequestConfig } config
   * @return {!Promise<{
        adsGuid: ?string,
   *  }>}
   */

  createAdRequest(config) {}
  
  /**
   * @param { !string } adsGuid
   * @param { !blink.mojom.AuctionAdConfig } config
   * @return {!Promise<{
        adDisplayUrl: ?url.mojom.Url,
   *  }>}
   */

  finalizeAd(adsGuid, config) {}
  
  /**
   * @param { !blink.mojom.AuctionAdConfig } config
   * @param { ?blink.mojom.AbortableAdAuctionPendingReceiver } abortReceiver
   * @return {!Promise<{
        abortedByScript: !boolean,
        config: ?blink.mojom.FencedFrameConfig,
   *  }>}
   */

  runAdAuction(config, abortReceiver) {}
  
  /**
   * @param { !blink.mojom.InterestGroup } group
   * @return {!Promise<{
        failedWellKnownCheck: !boolean,
   *  }>}
   */

  joinInterestGroup(group) {}
  
  /**
   * @param { !url.mojom.Origin } owner
   * @param { !string } name
   * @return {!Promise<{
        failedWellKnownCheck: !boolean,
   *  }>}
   */

  leaveInterestGroup(owner, name) {}
  
  /**
   */

  leaveInterestGroupForDocument() {}
  
  /**
   * @param { !url.mojom.Origin } owner
   * @param { !Array<!string> } interestGroupsToKeep
   * @return {!Promise<{
        failedWellKnownCheck: !boolean,
   *  }>}
   */

  clearOriginJoinedInterestGroups(owner, interestGroupsToKeep) {}
  
  /**
   */

  updateAdInterestGroups() {}
  
  /**
   * @param { !url.mojom.Url } uuidUrl
   * @param { !boolean } sendReports
   * @return {!Promise<{
        decodedUrl: ?url.mojom.Url,
   *  }>}
   */

  deprecatedGetURLFromURN(uuidUrl, sendReports) {}
  
  /**
   * @param { !url.mojom.Url } uuidUrl
   * @param { !Array<!blink.mojom.AdKeywordReplacement> } replacements
   * @return {!Promise}
   */

  deprecatedReplaceInURN(uuidUrl, replacements) {}
  
  /**
   * @param { !Map<!url.mojom.Origin, ?url.mojom.Origin> } sellers
   * @param { !blink.mojom.AuctionDataConfig } config
   * @return {!Promise<{
        requests: !Array<!blink.mojom.AdAuctionPerSellerRequest>,
        requestId: ?mojoBase.mojom.Uuid,
   *  }>}
   */

  getInterestGroupAdAuctionData(sellers, config) {}
};

/**
 * @export
 * @implements { blink.mojom.AdAuctionServiceInterface }
 */
blink.mojom.AdAuctionServiceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.AdAuctionServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.AdAuctionServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.AdAuctionServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.AdRequestConfig } config
   * @return {!Promise<{
        adsGuid: ?string,
   *  }>}
   */

  createAdRequest(
      config) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.AdAuctionService_CreateAdRequest_ParamsSpec.$,
        blink.mojom.AdAuctionService_CreateAdRequest_ResponseParamsSpec.$,
        [
          config
        ],
        false);
  }

  
  /**
   * @param { !string } adsGuid
   * @param { !blink.mojom.AuctionAdConfig } config
   * @return {!Promise<{
        adDisplayUrl: ?url.mojom.Url,
   *  }>}
   */

  finalizeAd(
      adsGuid,
      config) {
    return this.proxy.sendMessage(
        1,
        blink.mojom.AdAuctionService_FinalizeAd_ParamsSpec.$,
        blink.mojom.AdAuctionService_FinalizeAd_ResponseParamsSpec.$,
        [
          adsGuid,
          config
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.AuctionAdConfig } config
   * @param { ?blink.mojom.AbortableAdAuctionPendingReceiver } abortReceiver
   * @return {!Promise<{
        abortedByScript: !boolean,
        config: ?blink.mojom.FencedFrameConfig,
   *  }>}
   */

  runAdAuction(
      config,
      abortReceiver) {
    return this.proxy.sendMessage(
        2,
        blink.mojom.AdAuctionService_RunAdAuction_ParamsSpec.$,
        blink.mojom.AdAuctionService_RunAdAuction_ResponseParamsSpec.$,
        [
          config,
          abortReceiver
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.InterestGroup } group
   * @return {!Promise<{
        failedWellKnownCheck: !boolean,
   *  }>}
   */

  joinInterestGroup(
      group) {
    return this.proxy.sendMessage(
        3,
        blink.mojom.AdAuctionService_JoinInterestGroup_ParamsSpec.$,
        blink.mojom.AdAuctionService_JoinInterestGroup_ResponseParamsSpec.$,
        [
          group
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Origin } owner
   * @param { !string } name
   * @return {!Promise<{
        failedWellKnownCheck: !boolean,
   *  }>}
   */

  leaveInterestGroup(
      owner,
      name) {
    return this.proxy.sendMessage(
        4,
        blink.mojom.AdAuctionService_LeaveInterestGroup_ParamsSpec.$,
        blink.mojom.AdAuctionService_LeaveInterestGroup_ResponseParamsSpec.$,
        [
          owner,
          name
        ],
        false);
  }

  
  /**
   */

  leaveInterestGroupForDocument() {
    this.proxy.sendMessage(
        5,
        blink.mojom.AdAuctionService_LeaveInterestGroupForDocument_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Origin } owner
   * @param { !Array<!string> } interestGroupsToKeep
   * @return {!Promise<{
        failedWellKnownCheck: !boolean,
   *  }>}
   */

  clearOriginJoinedInterestGroups(
      owner,
      interestGroupsToKeep) {
    return this.proxy.sendMessage(
        6,
        blink.mojom.AdAuctionService_ClearOriginJoinedInterestGroups_ParamsSpec.$,
        blink.mojom.AdAuctionService_ClearOriginJoinedInterestGroups_ResponseParamsSpec.$,
        [
          owner,
          interestGroupsToKeep
        ],
        false);
  }

  
  /**
   */

  updateAdInterestGroups() {
    this.proxy.sendMessage(
        7,
        blink.mojom.AdAuctionService_UpdateAdInterestGroups_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } uuidUrl
   * @param { !boolean } sendReports
   * @return {!Promise<{
        decodedUrl: ?url.mojom.Url,
   *  }>}
   */

  deprecatedGetURLFromURN(
      uuidUrl,
      sendReports) {
    return this.proxy.sendMessage(
        8,
        blink.mojom.AdAuctionService_DeprecatedGetURLFromURN_ParamsSpec.$,
        blink.mojom.AdAuctionService_DeprecatedGetURLFromURN_ResponseParamsSpec.$,
        [
          uuidUrl,
          sendReports
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } uuidUrl
   * @param { !Array<!blink.mojom.AdKeywordReplacement> } replacements
   * @return {!Promise}
   */

  deprecatedReplaceInURN(
      uuidUrl,
      replacements) {
    return this.proxy.sendMessage(
        9,
        blink.mojom.AdAuctionService_DeprecatedReplaceInURN_ParamsSpec.$,
        blink.mojom.AdAuctionService_DeprecatedReplaceInURN_ResponseParamsSpec.$,
        [
          uuidUrl,
          replacements
        ],
        false);
  }

  
  /**
   * @param { !Map<!url.mojom.Origin, ?url.mojom.Origin> } sellers
   * @param { !blink.mojom.AuctionDataConfig } config
   * @return {!Promise<{
        requests: !Array<!blink.mojom.AdAuctionPerSellerRequest>,
        requestId: ?mojoBase.mojom.Uuid,
   *  }>}
   */

  getInterestGroupAdAuctionData(
      sellers,
      config) {
    return this.proxy.sendMessage(
        10,
        blink.mojom.AdAuctionService_GetInterestGroupAdAuctionData_ParamsSpec.$,
        blink.mojom.AdAuctionService_GetInterestGroupAdAuctionData_ResponseParamsSpec.$,
        [
          sellers,
          config
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AdAuctionService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.AdAuctionServiceReceiver = class {
  /**
   * @param {!blink.mojom.AdAuctionServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.AdAuctionServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.AdAuctionServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AdAuctionServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AdAuctionService_CreateAdRequest_ParamsSpec.$,
        blink.mojom.AdAuctionService_CreateAdRequest_ResponseParamsSpec.$,
        impl.createAdRequest.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.AdAuctionService_FinalizeAd_ParamsSpec.$,
        blink.mojom.AdAuctionService_FinalizeAd_ResponseParamsSpec.$,
        impl.finalizeAd.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.AdAuctionService_RunAdAuction_ParamsSpec.$,
        blink.mojom.AdAuctionService_RunAdAuction_ResponseParamsSpec.$,
        impl.runAdAuction.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.AdAuctionService_JoinInterestGroup_ParamsSpec.$,
        blink.mojom.AdAuctionService_JoinInterestGroup_ResponseParamsSpec.$,
        impl.joinInterestGroup.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.AdAuctionService_LeaveInterestGroup_ParamsSpec.$,
        blink.mojom.AdAuctionService_LeaveInterestGroup_ResponseParamsSpec.$,
        impl.leaveInterestGroup.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.AdAuctionService_LeaveInterestGroupForDocument_ParamsSpec.$,
        null,
        impl.leaveInterestGroupForDocument.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.AdAuctionService_ClearOriginJoinedInterestGroups_ParamsSpec.$,
        blink.mojom.AdAuctionService_ClearOriginJoinedInterestGroups_ResponseParamsSpec.$,
        impl.clearOriginJoinedInterestGroups.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        blink.mojom.AdAuctionService_UpdateAdInterestGroups_ParamsSpec.$,
        null,
        impl.updateAdInterestGroups.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        blink.mojom.AdAuctionService_DeprecatedGetURLFromURN_ParamsSpec.$,
        blink.mojom.AdAuctionService_DeprecatedGetURLFromURN_ResponseParamsSpec.$,
        impl.deprecatedGetURLFromURN.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        blink.mojom.AdAuctionService_DeprecatedReplaceInURN_ParamsSpec.$,
        blink.mojom.AdAuctionService_DeprecatedReplaceInURN_ResponseParamsSpec.$,
        impl.deprecatedReplaceInURN.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        blink.mojom.AdAuctionService_GetInterestGroupAdAuctionData_ParamsSpec.$,
        blink.mojom.AdAuctionService_GetInterestGroupAdAuctionData_ResponseParamsSpec.$,
        impl.getInterestGroupAdAuctionData.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.AdAuctionService = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AdAuctionService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.AdAuctionServiceRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.AdAuctionServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AdAuctionService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.AdAuctionServiceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.AdAuctionServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AdAuctionServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createAdRequest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AdAuctionService_CreateAdRequest_ParamsSpec.$,
        blink.mojom.AdAuctionService_CreateAdRequest_ResponseParamsSpec.$,
        this.createAdRequest.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.finalizeAd =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.AdAuctionService_FinalizeAd_ParamsSpec.$,
        blink.mojom.AdAuctionService_FinalizeAd_ResponseParamsSpec.$,
        this.finalizeAd.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.runAdAuction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.AdAuctionService_RunAdAuction_ParamsSpec.$,
        blink.mojom.AdAuctionService_RunAdAuction_ResponseParamsSpec.$,
        this.runAdAuction.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.joinInterestGroup =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.AdAuctionService_JoinInterestGroup_ParamsSpec.$,
        blink.mojom.AdAuctionService_JoinInterestGroup_ResponseParamsSpec.$,
        this.joinInterestGroup.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.leaveInterestGroup =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.AdAuctionService_LeaveInterestGroup_ParamsSpec.$,
        blink.mojom.AdAuctionService_LeaveInterestGroup_ResponseParamsSpec.$,
        this.leaveInterestGroup.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.leaveInterestGroupForDocument =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.AdAuctionService_LeaveInterestGroupForDocument_ParamsSpec.$,
        null,
        this.leaveInterestGroupForDocument.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearOriginJoinedInterestGroups =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.AdAuctionService_ClearOriginJoinedInterestGroups_ParamsSpec.$,
        blink.mojom.AdAuctionService_ClearOriginJoinedInterestGroups_ResponseParamsSpec.$,
        this.clearOriginJoinedInterestGroups.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateAdInterestGroups =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        blink.mojom.AdAuctionService_UpdateAdInterestGroups_ParamsSpec.$,
        null,
        this.updateAdInterestGroups.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deprecatedGetURLFromURN =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        blink.mojom.AdAuctionService_DeprecatedGetURLFromURN_ParamsSpec.$,
        blink.mojom.AdAuctionService_DeprecatedGetURLFromURN_ResponseParamsSpec.$,
        this.deprecatedGetURLFromURN.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deprecatedReplaceInURN =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        blink.mojom.AdAuctionService_DeprecatedReplaceInURN_ParamsSpec.$,
        blink.mojom.AdAuctionService_DeprecatedReplaceInURN_ResponseParamsSpec.$,
        this.deprecatedReplaceInURN.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getInterestGroupAdAuctionData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        blink.mojom.AdAuctionService_GetInterestGroupAdAuctionData_ParamsSpec.$,
        blink.mojom.AdAuctionService_GetInterestGroupAdAuctionData_ResponseParamsSpec.$,
        this.getInterestGroupAdAuctionData.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.AbortableAdAuction_ResolvedPromiseParam_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AbortableAdAuction_ResolvedPromiseParam_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AbortableAdAuction_ResolvedPerBuyerSignalsPromise_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AbortableAdAuction_ResolvedPerBuyerSignalsPromise_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AbortableAdAuction_ResolvedBuyerTkvSignalsPromise_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AbortableAdAuction_ResolvedBuyerTkvSignalsPromise_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AbortableAdAuction_ResolvedBuyerTimeoutsPromise_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AbortableAdAuction_ResolvedBuyerTimeoutsPromise_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AbortableAdAuction_ResolvedBuyerCurrenciesPromise_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AbortableAdAuction_ResolvedBuyerCurrenciesPromise_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AbortableAdAuction_ResolvedDirectFromSellerSignalsPromise_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AbortableAdAuction_ResolvedDirectFromSellerSignalsPromise_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AbortableAdAuction_ResolvedDirectFromSellerSignalsHeaderAdSlotPromise_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AbortableAdAuction_ResolvedDirectFromSellerSignalsHeaderAdSlotPromise_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AbortableAdAuction_ResolvedDeprecatedRenderURLReplacementsPromise_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AbortableAdAuction_ResolvedDeprecatedRenderURLReplacementsPromise_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AbortableAdAuction_ResolvedAuctionAdResponsePromise_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AbortableAdAuction_ResolvedAuctionAdResponsePromise_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AbortableAdAuction_ResolvedAdditionalBids_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AbortableAdAuction_ResolvedAdditionalBids_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AbortableAdAuction_Abort_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AbortableAdAuction_Abort_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AdAuctionService_CreateAdRequest_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AdAuctionService_CreateAdRequest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AdAuctionService_CreateAdRequest_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AdAuctionService_CreateAdRequest_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AdAuctionService_FinalizeAd_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AdAuctionService_FinalizeAd_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AdAuctionService_FinalizeAd_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AdAuctionService_FinalizeAd_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AdAuctionService_RunAdAuction_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AdAuctionService_RunAdAuction_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AdAuctionService_RunAdAuction_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AdAuctionService_RunAdAuction_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AdAuctionService_JoinInterestGroup_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AdAuctionService_JoinInterestGroup_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AdAuctionService_JoinInterestGroup_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AdAuctionService_JoinInterestGroup_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AdAuctionService_LeaveInterestGroup_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AdAuctionService_LeaveInterestGroup_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AdAuctionService_LeaveInterestGroup_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AdAuctionService_LeaveInterestGroup_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AdAuctionService_LeaveInterestGroupForDocument_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AdAuctionService_LeaveInterestGroupForDocument_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AdAuctionService_ClearOriginJoinedInterestGroups_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AdAuctionService_ClearOriginJoinedInterestGroups_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AdAuctionService_ClearOriginJoinedInterestGroups_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AdAuctionService_ClearOriginJoinedInterestGroups_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AdAuctionService_UpdateAdInterestGroups_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AdAuctionService_UpdateAdInterestGroups_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AdAuctionService_DeprecatedGetURLFromURN_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AdAuctionService_DeprecatedGetURLFromURN_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AdAuctionService_DeprecatedGetURLFromURN_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AdAuctionService_DeprecatedGetURLFromURN_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AdAuctionService_DeprecatedReplaceInURN_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AdAuctionService_DeprecatedReplaceInURN_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AdAuctionService_DeprecatedReplaceInURN_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AdAuctionService_DeprecatedReplaceInURN_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AdAuctionService_GetInterestGroupAdAuctionData_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AdAuctionService_GetInterestGroupAdAuctionData_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AdAuctionService_GetInterestGroupAdAuctionData_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AdAuctionService_GetInterestGroupAdAuctionData_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AuctionAdConfigAuctionIdSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.AuctionAdConfigAuctionIdSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.AbortableAdAuction_ResolvedPromiseParam_ParamsSpec.$,
    'AbortableAdAuction_ResolvedPromiseParam_Params',
    [
      mojo.internal.StructField(
        'auction', 0,
        0,
        blink.mojom.AuctionAdConfigAuctionIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'field', 16,
        0,
        blink.mojom.AuctionAdConfigFieldSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'jsonValue', 24,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.AbortableAdAuction_ResolvedPromiseParam_Params');

/** @record */
blink.mojom.AbortableAdAuction_ResolvedPromiseParam_Params = class {
  constructor() {
    /** @export { !blink.mojom.AuctionAdConfigAuctionId } */
    this.auction;
    /** @export { !blink.mojom.AuctionAdConfigField } */
    this.field;
    /** @export { (string|undefined) } */
    this.jsonValue;
  }
};



mojo.internal.Struct(
    blink.mojom.AbortableAdAuction_ResolvedPerBuyerSignalsPromise_ParamsSpec.$,
    'AbortableAdAuction_ResolvedPerBuyerSignalsPromise_Params',
    [
      mojo.internal.StructField(
        'auction', 0,
        0,
        blink.mojom.AuctionAdConfigAuctionIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'perBuyerSignals', 16,
        0,
        mojo.internal.Map(url.mojom.OriginSpec.$, mojo.internal.String, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.AbortableAdAuction_ResolvedPerBuyerSignalsPromise_Params');

/** @record */
blink.mojom.AbortableAdAuction_ResolvedPerBuyerSignalsPromise_Params = class {
  constructor() {
    /** @export { !blink.mojom.AuctionAdConfigAuctionId } */
    this.auction;
    /** @export { (Map<!url.mojom.Origin, !string>|undefined) } */
    this.perBuyerSignals;
  }
};



mojo.internal.Struct(
    blink.mojom.AbortableAdAuction_ResolvedBuyerTkvSignalsPromise_ParamsSpec.$,
    'AbortableAdAuction_ResolvedBuyerTkvSignalsPromise_Params',
    [
      mojo.internal.StructField(
        'auction', 0,
        0,
        blink.mojom.AuctionAdConfigAuctionIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'buyer', 16,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'jsonValue', 24,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.AbortableAdAuction_ResolvedBuyerTkvSignalsPromise_Params');

/** @record */
blink.mojom.AbortableAdAuction_ResolvedBuyerTkvSignalsPromise_Params = class {
  constructor() {
    /** @export { !blink.mojom.AuctionAdConfigAuctionId } */
    this.auction;
    /** @export { !url.mojom.Origin } */
    this.buyer;
    /** @export { (string|undefined) } */
    this.jsonValue;
  }
};



mojo.internal.Struct(
    blink.mojom.AbortableAdAuction_ResolvedBuyerTimeoutsPromise_ParamsSpec.$,
    'AbortableAdAuction_ResolvedBuyerTimeoutsPromise_Params',
    [
      mojo.internal.StructField(
        'auction', 0,
        0,
        blink.mojom.AuctionAdConfigAuctionIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'field', 16,
        0,
        blink.mojom.AuctionAdConfigBuyerTimeoutFieldSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'buyerTimeouts', 24,
        0,
        blink.mojom.AuctionAdConfigBuyerTimeoutsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.AbortableAdAuction_ResolvedBuyerTimeoutsPromise_Params');

/** @record */
blink.mojom.AbortableAdAuction_ResolvedBuyerTimeoutsPromise_Params = class {
  constructor() {
    /** @export { !blink.mojom.AuctionAdConfigAuctionId } */
    this.auction;
    /** @export { !blink.mojom.AuctionAdConfigBuyerTimeoutField } */
    this.field;
    /** @export { !blink.mojom.AuctionAdConfigBuyerTimeouts } */
    this.buyerTimeouts;
  }
};



mojo.internal.Struct(
    blink.mojom.AbortableAdAuction_ResolvedBuyerCurrenciesPromise_ParamsSpec.$,
    'AbortableAdAuction_ResolvedBuyerCurrenciesPromise_Params',
    [
      mojo.internal.StructField(
        'auction', 0,
        0,
        blink.mojom.AuctionAdConfigAuctionIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'perBuyerCurrencies', 16,
        0,
        blink.mojom.AuctionAdConfigBuyerCurrenciesSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.AbortableAdAuction_ResolvedBuyerCurrenciesPromise_Params');

/** @record */
blink.mojom.AbortableAdAuction_ResolvedBuyerCurrenciesPromise_Params = class {
  constructor() {
    /** @export { !blink.mojom.AuctionAdConfigAuctionId } */
    this.auction;
    /** @export { !blink.mojom.AuctionAdConfigBuyerCurrencies } */
    this.perBuyerCurrencies;
  }
};



mojo.internal.Struct(
    blink.mojom.AbortableAdAuction_ResolvedDirectFromSellerSignalsPromise_ParamsSpec.$,
    'AbortableAdAuction_ResolvedDirectFromSellerSignalsPromise_Params',
    [
      mojo.internal.StructField(
        'auction', 0,
        0,
        blink.mojom.AuctionAdConfigAuctionIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'directFromSellerSignals', 16,
        0,
        blink.mojom.DirectFromSellerSignalsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.AbortableAdAuction_ResolvedDirectFromSellerSignalsPromise_Params');

/** @record */
blink.mojom.AbortableAdAuction_ResolvedDirectFromSellerSignalsPromise_Params = class {
  constructor() {
    /** @export { !blink.mojom.AuctionAdConfigAuctionId } */
    this.auction;
    /** @export { (blink.mojom.DirectFromSellerSignals|undefined) } */
    this.directFromSellerSignals;
  }
};



mojo.internal.Struct(
    blink.mojom.AbortableAdAuction_ResolvedDirectFromSellerSignalsHeaderAdSlotPromise_ParamsSpec.$,
    'AbortableAdAuction_ResolvedDirectFromSellerSignalsHeaderAdSlotPromise_Params',
    [
      mojo.internal.StructField(
        'auction', 0,
        0,
        blink.mojom.AuctionAdConfigAuctionIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'directFromSellerSignalsHeaderAdSlot', 16,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.AbortableAdAuction_ResolvedDirectFromSellerSignalsHeaderAdSlotPromise_Params');

/** @record */
blink.mojom.AbortableAdAuction_ResolvedDirectFromSellerSignalsHeaderAdSlotPromise_Params = class {
  constructor() {
    /** @export { !blink.mojom.AuctionAdConfigAuctionId } */
    this.auction;
    /** @export { (string|undefined) } */
    this.directFromSellerSignalsHeaderAdSlot;
  }
};



mojo.internal.Struct(
    blink.mojom.AbortableAdAuction_ResolvedDeprecatedRenderURLReplacementsPromise_ParamsSpec.$,
    'AbortableAdAuction_ResolvedDeprecatedRenderURLReplacementsPromise_Params',
    [
      mojo.internal.StructField(
        'auction', 0,
        0,
        blink.mojom.AuctionAdConfigAuctionIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'deprecatedRenderUrlReplacements', 16,
        0,
        mojo.internal.Array(blink.mojom.AdKeywordReplacementSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.AbortableAdAuction_ResolvedDeprecatedRenderURLReplacementsPromise_Params');

/** @record */
blink.mojom.AbortableAdAuction_ResolvedDeprecatedRenderURLReplacementsPromise_Params = class {
  constructor() {
    /** @export { !blink.mojom.AuctionAdConfigAuctionId } */
    this.auction;
    /** @export { !Array<!blink.mojom.AdKeywordReplacement> } */
    this.deprecatedRenderUrlReplacements;
  }
};



mojo.internal.Struct(
    blink.mojom.AbortableAdAuction_ResolvedAuctionAdResponsePromise_ParamsSpec.$,
    'AbortableAdAuction_ResolvedAuctionAdResponsePromise_Params',
    [
      mojo.internal.StructField(
        'auction', 0,
        0,
        blink.mojom.AuctionAdConfigAuctionIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'result', 16,
        0,
        mojoBase.mojom.BigBufferSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.AbortableAdAuction_ResolvedAuctionAdResponsePromise_Params');

/** @record */
blink.mojom.AbortableAdAuction_ResolvedAuctionAdResponsePromise_Params = class {
  constructor() {
    /** @export { !blink.mojom.AuctionAdConfigAuctionId } */
    this.auction;
    /** @export { !mojoBase.mojom.BigBuffer } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.AbortableAdAuction_ResolvedAdditionalBids_ParamsSpec.$,
    'AbortableAdAuction_ResolvedAdditionalBids_Params',
    [
      mojo.internal.StructField(
        'auction', 0,
        0,
        blink.mojom.AuctionAdConfigAuctionIdSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AbortableAdAuction_ResolvedAdditionalBids_Params');

/** @record */
blink.mojom.AbortableAdAuction_ResolvedAdditionalBids_Params = class {
  constructor() {
    /** @export { !blink.mojom.AuctionAdConfigAuctionId } */
    this.auction;
  }
};



mojo.internal.Struct(
    blink.mojom.AbortableAdAuction_Abort_ParamsSpec.$,
    'AbortableAdAuction_Abort_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.AbortableAdAuction_Abort_Params');

/** @record */
blink.mojom.AbortableAdAuction_Abort_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.AdAuctionService_CreateAdRequest_ParamsSpec.$,
    'AdAuctionService_CreateAdRequest_Params',
    [
      mojo.internal.StructField(
        'config', 0,
        0,
        blink.mojom.AdRequestConfigSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AdAuctionService_CreateAdRequest_Params');

/** @record */
blink.mojom.AdAuctionService_CreateAdRequest_Params = class {
  constructor() {
    /** @export { !blink.mojom.AdRequestConfig } */
    this.config;
  }
};



mojo.internal.Struct(
    blink.mojom.AdAuctionService_CreateAdRequest_ResponseParamsSpec.$,
    'AdAuctionService_CreateAdRequest_ResponseParams',
    [
      mojo.internal.StructField(
        'adsGuid', 0,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AdAuctionService_CreateAdRequest_ResponseParams');

/** @record */
blink.mojom.AdAuctionService_CreateAdRequest_ResponseParams = class {
  constructor() {
    /** @export { (string|undefined) } */
    this.adsGuid;
  }
};



mojo.internal.Struct(
    blink.mojom.AdAuctionService_FinalizeAd_ParamsSpec.$,
    'AdAuctionService_FinalizeAd_Params',
    [
      mojo.internal.StructField(
        'adsGuid', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'config', 8,
        0,
        blink.mojom.AuctionAdConfigSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AdAuctionService_FinalizeAd_Params');

/** @record */
blink.mojom.AdAuctionService_FinalizeAd_Params = class {
  constructor() {
    /** @export { !string } */
    this.adsGuid;
    /** @export { !blink.mojom.AuctionAdConfig } */
    this.config;
  }
};



mojo.internal.Struct(
    blink.mojom.AdAuctionService_FinalizeAd_ResponseParamsSpec.$,
    'AdAuctionService_FinalizeAd_ResponseParams',
    [
      mojo.internal.StructField(
        'adDisplayUrl', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AdAuctionService_FinalizeAd_ResponseParams');

/** @record */
blink.mojom.AdAuctionService_FinalizeAd_ResponseParams = class {
  constructor() {
    /** @export { (url.mojom.Url|undefined) } */
    this.adDisplayUrl;
  }
};



mojo.internal.Struct(
    blink.mojom.AdAuctionService_RunAdAuction_ParamsSpec.$,
    'AdAuctionService_RunAdAuction_Params',
    [
      mojo.internal.StructField(
        'config', 0,
        0,
        blink.mojom.AuctionAdConfigSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'abortReceiver', 8,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.AbortableAdAuctionPendingReceiver),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AdAuctionService_RunAdAuction_Params');

/** @record */
blink.mojom.AdAuctionService_RunAdAuction_Params = class {
  constructor() {
    /** @export { !blink.mojom.AuctionAdConfig } */
    this.config;
    /** @export { (blink.mojom.AbortableAdAuctionPendingReceiver|undefined) } */
    this.abortReceiver;
  }
};



mojo.internal.Struct(
    blink.mojom.AdAuctionService_RunAdAuction_ResponseParamsSpec.$,
    'AdAuctionService_RunAdAuction_ResponseParams',
    [
      mojo.internal.StructField(
        'abortedByScript', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'config', 8,
        0,
        blink.mojom.FencedFrameConfigSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AdAuctionService_RunAdAuction_ResponseParams');

/** @record */
blink.mojom.AdAuctionService_RunAdAuction_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.abortedByScript;
    /** @export { (blink.mojom.FencedFrameConfig|undefined) } */
    this.config;
  }
};



mojo.internal.Struct(
    blink.mojom.AdAuctionService_JoinInterestGroup_ParamsSpec.$,
    'AdAuctionService_JoinInterestGroup_Params',
    [
      mojo.internal.StructField(
        'group', 0,
        0,
        blink.mojom.InterestGroupSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AdAuctionService_JoinInterestGroup_Params');

/** @record */
blink.mojom.AdAuctionService_JoinInterestGroup_Params = class {
  constructor() {
    /** @export { !blink.mojom.InterestGroup } */
    this.group;
  }
};



mojo.internal.Struct(
    blink.mojom.AdAuctionService_JoinInterestGroup_ResponseParamsSpec.$,
    'AdAuctionService_JoinInterestGroup_ResponseParams',
    [
      mojo.internal.StructField(
        'failedWellKnownCheck', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AdAuctionService_JoinInterestGroup_ResponseParams');

/** @record */
blink.mojom.AdAuctionService_JoinInterestGroup_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.failedWellKnownCheck;
  }
};



mojo.internal.Struct(
    blink.mojom.AdAuctionService_LeaveInterestGroup_ParamsSpec.$,
    'AdAuctionService_LeaveInterestGroup_Params',
    [
      mojo.internal.StructField(
        'owner', 0,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'name', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AdAuctionService_LeaveInterestGroup_Params');

/** @record */
blink.mojom.AdAuctionService_LeaveInterestGroup_Params = class {
  constructor() {
    /** @export { !url.mojom.Origin } */
    this.owner;
    /** @export { !string } */
    this.name;
  }
};



mojo.internal.Struct(
    blink.mojom.AdAuctionService_LeaveInterestGroup_ResponseParamsSpec.$,
    'AdAuctionService_LeaveInterestGroup_ResponseParams',
    [
      mojo.internal.StructField(
        'failedWellKnownCheck', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AdAuctionService_LeaveInterestGroup_ResponseParams');

/** @record */
blink.mojom.AdAuctionService_LeaveInterestGroup_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.failedWellKnownCheck;
  }
};



mojo.internal.Struct(
    blink.mojom.AdAuctionService_LeaveInterestGroupForDocument_ParamsSpec.$,
    'AdAuctionService_LeaveInterestGroupForDocument_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.AdAuctionService_LeaveInterestGroupForDocument_Params');

/** @record */
blink.mojom.AdAuctionService_LeaveInterestGroupForDocument_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.AdAuctionService_ClearOriginJoinedInterestGroups_ParamsSpec.$,
    'AdAuctionService_ClearOriginJoinedInterestGroups_Params',
    [
      mojo.internal.StructField(
        'owner', 0,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'interestGroupsToKeep', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AdAuctionService_ClearOriginJoinedInterestGroups_Params');

/** @record */
blink.mojom.AdAuctionService_ClearOriginJoinedInterestGroups_Params = class {
  constructor() {
    /** @export { !url.mojom.Origin } */
    this.owner;
    /** @export { !Array<!string> } */
    this.interestGroupsToKeep;
  }
};



mojo.internal.Struct(
    blink.mojom.AdAuctionService_ClearOriginJoinedInterestGroups_ResponseParamsSpec.$,
    'AdAuctionService_ClearOriginJoinedInterestGroups_ResponseParams',
    [
      mojo.internal.StructField(
        'failedWellKnownCheck', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AdAuctionService_ClearOriginJoinedInterestGroups_ResponseParams');

/** @record */
blink.mojom.AdAuctionService_ClearOriginJoinedInterestGroups_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.failedWellKnownCheck;
  }
};



mojo.internal.Struct(
    blink.mojom.AdAuctionService_UpdateAdInterestGroups_ParamsSpec.$,
    'AdAuctionService_UpdateAdInterestGroups_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.AdAuctionService_UpdateAdInterestGroups_Params');

/** @record */
blink.mojom.AdAuctionService_UpdateAdInterestGroups_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.AdAuctionService_DeprecatedGetURLFromURN_ParamsSpec.$,
    'AdAuctionService_DeprecatedGetURLFromURN_Params',
    [
      mojo.internal.StructField(
        'uuidUrl', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sendReports', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AdAuctionService_DeprecatedGetURLFromURN_Params');

/** @record */
blink.mojom.AdAuctionService_DeprecatedGetURLFromURN_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.uuidUrl;
    /** @export { !boolean } */
    this.sendReports;
  }
};



mojo.internal.Struct(
    blink.mojom.AdAuctionService_DeprecatedGetURLFromURN_ResponseParamsSpec.$,
    'AdAuctionService_DeprecatedGetURLFromURN_ResponseParams',
    [
      mojo.internal.StructField(
        'decodedUrl', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.AdAuctionService_DeprecatedGetURLFromURN_ResponseParams');

/** @record */
blink.mojom.AdAuctionService_DeprecatedGetURLFromURN_ResponseParams = class {
  constructor() {
    /** @export { (url.mojom.Url|undefined) } */
    this.decodedUrl;
  }
};



mojo.internal.Struct(
    blink.mojom.AdAuctionService_DeprecatedReplaceInURN_ParamsSpec.$,
    'AdAuctionService_DeprecatedReplaceInURN_Params',
    [
      mojo.internal.StructField(
        'uuidUrl', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'replacements', 8,
        0,
        mojo.internal.Array(blink.mojom.AdKeywordReplacementSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AdAuctionService_DeprecatedReplaceInURN_Params');

/** @record */
blink.mojom.AdAuctionService_DeprecatedReplaceInURN_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.uuidUrl;
    /** @export { !Array<!blink.mojom.AdKeywordReplacement> } */
    this.replacements;
  }
};



mojo.internal.Struct(
    blink.mojom.AdAuctionService_DeprecatedReplaceInURN_ResponseParamsSpec.$,
    'AdAuctionService_DeprecatedReplaceInURN_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.AdAuctionService_DeprecatedReplaceInURN_ResponseParams');

/** @record */
blink.mojom.AdAuctionService_DeprecatedReplaceInURN_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.AdAuctionService_GetInterestGroupAdAuctionData_ParamsSpec.$,
    'AdAuctionService_GetInterestGroupAdAuctionData_Params',
    [
      mojo.internal.StructField(
        'sellers', 0,
        0,
        mojo.internal.Map(url.mojom.OriginSpec.$, url.mojom.OriginSpec.$, true),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'config', 8,
        0,
        blink.mojom.AuctionDataConfigSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AdAuctionService_GetInterestGroupAdAuctionData_Params');

/** @record */
blink.mojom.AdAuctionService_GetInterestGroupAdAuctionData_Params = class {
  constructor() {
    /** @export { !Map<!url.mojom.Origin, ?url.mojom.Origin> } */
    this.sellers;
    /** @export { !blink.mojom.AuctionDataConfig } */
    this.config;
  }
};



mojo.internal.Struct(
    blink.mojom.AdAuctionService_GetInterestGroupAdAuctionData_ResponseParamsSpec.$,
    'AdAuctionService_GetInterestGroupAdAuctionData_ResponseParams',
    [
      mojo.internal.StructField(
        'requests', 0,
        0,
        mojo.internal.Array(blink.mojom.AdAuctionPerSellerRequestSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requestId', 8,
        0,
        mojoBase.mojom.UuidSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AdAuctionService_GetInterestGroupAdAuctionData_ResponseParams');

/** @record */
blink.mojom.AdAuctionService_GetInterestGroupAdAuctionData_ResponseParams = class {
  constructor() {
    /** @export { !Array<!blink.mojom.AdAuctionPerSellerRequest> } */
    this.requests;
    /** @export { (mojoBase.mojom.Uuid|undefined) } */
    this.requestId;
  }
};

goog.provide('blink.mojom.AuctionAdConfigAuctionId');


mojo.internal.Union(
    blink.mojom.AuctionAdConfigAuctionIdSpec.$, 'AuctionAdConfigAuctionId',
    {
      'mainAuction': {
        'ordinal': 0,
        'type': mojo.internal.Uint32,
      },
      'componentAuction': {
        'ordinal': 1,
        'type': mojo.internal.Uint32,
      },
    });

/**
 * @typedef { {
 *   mainAuction: (!number|undefined),
 *   componentAuction: (!number|undefined),
 * } }
 */
blink.mojom.AuctionAdConfigAuctionId;
