// third_party/blink/public/mojom/interest_group/ad_auction_service.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INTEREST_GROUP_AD_AUCTION_SERVICE_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INTEREST_GROUP_AD_AUCTION_SERVICE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/interest_group/ad_auction_service.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/interest_group/ad_auction_service.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/interest_group/ad_auction_service.mojom-blink-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/fenced_frame/fenced_frame_config.mojom-blink.h"
#include "third_party/blink/public/mojom/parakeet/ad_request.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/interest_group/interest_group_types.mojom-blink-forward.h"
#include "mojo/public/mojom/base/big_buffer.mojom-blink.h"
#include "mojo/public/mojom/base/time.mojom-blink-forward.h"
#include "mojo/public/mojom/base/uuid.mojom-blink.h"
#include "url/mojom/origin.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class AbortableAdAuctionProxy;

template <typename ImplRefTraits>
class AbortableAdAuctionStub;

class AbortableAdAuctionRequestValidator;


class PLATFORM_EXPORT AbortableAdAuction
    : public AbortableAdAuctionInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.AbortableAdAuction";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AbortableAdAuctionInterfaceBase;
  using Proxy_ = AbortableAdAuctionProxy;

  template <typename ImplRefTraits>
  using Stub_ = AbortableAdAuctionStub<ImplRefTraits>;

  using RequestValidator_ = AbortableAdAuctionRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kResolvedPromiseParamMinVersion = 0,
    kResolvedPerBuyerSignalsPromiseMinVersion = 0,
    kResolvedBuyerTkvSignalsPromiseMinVersion = 0,
    kResolvedBuyerTimeoutsPromiseMinVersion = 0,
    kResolvedBuyerCurrenciesPromiseMinVersion = 0,
    kResolvedDirectFromSellerSignalsPromiseMinVersion = 0,
    kResolvedDirectFromSellerSignalsHeaderAdSlotPromiseMinVersion = 0,
    kResolvedDeprecatedRenderURLReplacementsPromiseMinVersion = 0,
    kResolvedAuctionAdResponsePromiseMinVersion = 0,
    kResolvedAdditionalBidsMinVersion = 0,
    kAbortMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ResolvedPromiseParam_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ResolvedPerBuyerSignalsPromise_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ResolvedBuyerTkvSignalsPromise_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ResolvedBuyerTimeoutsPromise_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ResolvedBuyerCurrenciesPromise_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ResolvedDirectFromSellerSignalsPromise_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ResolvedDirectFromSellerSignalsHeaderAdSlotPromise_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ResolvedDeprecatedRenderURLReplacementsPromise_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ResolvedAuctionAdResponsePromise_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ResolvedAdditionalBids_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Abort_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AbortableAdAuction() = default;

  virtual void ResolvedPromiseParam(AuctionAdConfigAuctionIdPtr auction, AuctionAdConfigField field, const ::blink::String& json_value) = 0;

  virtual void ResolvedPerBuyerSignalsPromise(AuctionAdConfigAuctionIdPtr auction, const std::optional<::blink::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, ::blink::String>>& per_buyer_signals) = 0;

  virtual void ResolvedBuyerTkvSignalsPromise(AuctionAdConfigAuctionIdPtr auction, const ::scoped_refptr<const ::blink::SecurityOrigin>& buyer, const ::blink::String& json_value) = 0;

  virtual void ResolvedBuyerTimeoutsPromise(AuctionAdConfigAuctionIdPtr auction, AuctionAdConfigBuyerTimeoutField field, ::blink::mojom::blink::AuctionAdConfigBuyerTimeoutsPtr buyer_timeouts) = 0;

  virtual void ResolvedBuyerCurrenciesPromise(AuctionAdConfigAuctionIdPtr auction, ::blink::mojom::blink::AuctionAdConfigBuyerCurrenciesPtr per_buyer_currencies) = 0;

  virtual void ResolvedDirectFromSellerSignalsPromise(AuctionAdConfigAuctionIdPtr auction, ::blink::mojom::blink::DirectFromSellerSignalsPtr direct_from_seller_signals) = 0;

  virtual void ResolvedDirectFromSellerSignalsHeaderAdSlotPromise(AuctionAdConfigAuctionIdPtr auction, const ::blink::String& direct_from_seller_signals_header_ad_slot) = 0;

  virtual void ResolvedDeprecatedRenderURLReplacementsPromise(AuctionAdConfigAuctionIdPtr auction, ::blink::Vector<::blink::mojom::blink::AdKeywordReplacementPtr> deprecated_render_url_replacements) = 0;

  virtual void ResolvedAuctionAdResponsePromise(AuctionAdConfigAuctionIdPtr auction, ::mojo_base::BigBuffer result) = 0;

  virtual void ResolvedAdditionalBids(AuctionAdConfigAuctionIdPtr auction) = 0;

  virtual void Abort() = 0;
};

class AdAuctionServiceProxy;

template <typename ImplRefTraits>
class AdAuctionServiceStub;

class AdAuctionServiceRequestValidator;
class AdAuctionServiceResponseValidator;


class PLATFORM_EXPORT AdAuctionService
    : public AdAuctionServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.AdAuctionService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AdAuctionServiceInterfaceBase;
  using Proxy_ = AdAuctionServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = AdAuctionServiceStub<ImplRefTraits>;

  using RequestValidator_ = AdAuctionServiceRequestValidator;
  using ResponseValidator_ = AdAuctionServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateAdRequestMinVersion = 0,
    kFinalizeAdMinVersion = 0,
    kRunAdAuctionMinVersion = 0,
    kJoinInterestGroupMinVersion = 0,
    kLeaveInterestGroupMinVersion = 0,
    kLeaveInterestGroupForDocumentMinVersion = 0,
    kClearOriginJoinedInterestGroupsMinVersion = 0,
    kUpdateAdInterestGroupsMinVersion = 0,
    kDeprecatedGetURLFromURNMinVersion = 0,
    kDeprecatedReplaceInURNMinVersion = 0,
    kGetInterestGroupAdAuctionDataMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateAdRequest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FinalizeAd_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RunAdAuction_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct JoinInterestGroup_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LeaveInterestGroup_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LeaveInterestGroupForDocument_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearOriginJoinedInterestGroups_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateAdInterestGroups_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeprecatedGetURLFromURN_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeprecatedReplaceInURN_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetInterestGroupAdAuctionData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AdAuctionService() = default;

  using CreateAdRequestCallback = base::OnceCallback<void(const ::blink::String&)>;
  using CreateAdRequestMojoCallback = base::OnceCallback<void(const ::blink::String&)>;

  virtual void CreateAdRequest(::blink::mojom::blink::AdRequestConfigPtr config, CreateAdRequestCallback callback) = 0;

  using FinalizeAdCallback = base::OnceCallback<void(const std::optional<::blink::KURL>&)>;
  using FinalizeAdMojoCallback = base::OnceCallback<void(const std::optional<::blink::KURL>&)>;

  virtual void FinalizeAd(const ::blink::String& ads_guid, ::blink::mojom::blink::AuctionAdConfigPtr config, FinalizeAdCallback callback) = 0;

  using RunAdAuctionCallback = base::OnceCallback<void(bool, const std::optional<::blink::FencedFrame::RedactedFencedFrameConfig>&)>;
  using RunAdAuctionMojoCallback = base::OnceCallback<void(bool, const std::optional<::blink::FencedFrame::RedactedFencedFrameConfig>&)>;

  virtual void RunAdAuction(::blink::mojom::blink::AuctionAdConfigPtr config, ::mojo::PendingReceiver<AbortableAdAuction> abort_receiver, RunAdAuctionCallback callback) = 0;

  using JoinInterestGroupCallback = base::OnceCallback<void(bool)>;
  using JoinInterestGroupMojoCallback = base::OnceCallback<void(bool)>;

  virtual void JoinInterestGroup(::blink::mojom::blink::InterestGroupPtr group, JoinInterestGroupCallback callback) = 0;

  using LeaveInterestGroupCallback = base::OnceCallback<void(bool)>;
  using LeaveInterestGroupMojoCallback = base::OnceCallback<void(bool)>;

  virtual void LeaveInterestGroup(const ::scoped_refptr<const ::blink::SecurityOrigin>& owner, const ::blink::String& name, LeaveInterestGroupCallback callback) = 0;

  virtual void LeaveInterestGroupForDocument() = 0;

  using ClearOriginJoinedInterestGroupsCallback = base::OnceCallback<void(bool)>;
  using ClearOriginJoinedInterestGroupsMojoCallback = base::OnceCallback<void(bool)>;

  virtual void ClearOriginJoinedInterestGroups(const ::scoped_refptr<const ::blink::SecurityOrigin>& owner, const ::blink::Vector<::blink::String>& interest_groups_to_keep, ClearOriginJoinedInterestGroupsCallback callback) = 0;

  virtual void UpdateAdInterestGroups() = 0;

  using DeprecatedGetURLFromURNCallback = base::OnceCallback<void(const std::optional<::blink::KURL>&)>;
  using DeprecatedGetURLFromURNMojoCallback = base::OnceCallback<void(const std::optional<::blink::KURL>&)>;

  virtual void DeprecatedGetURLFromURN(const ::blink::KURL& uuid_url, bool send_reports, DeprecatedGetURLFromURNCallback callback) = 0;

  using DeprecatedReplaceInURNCallback = base::OnceCallback<void()>;
  using DeprecatedReplaceInURNMojoCallback = base::OnceCallback<void()>;

  virtual void DeprecatedReplaceInURN(const ::blink::KURL& uuid_url, ::blink::Vector<::blink::mojom::blink::AdKeywordReplacementPtr> replacements, DeprecatedReplaceInURNCallback callback) = 0;

  using GetInterestGroupAdAuctionDataCallback = base::OnceCallback<void(::blink::Vector<::blink::mojom::blink::AdAuctionPerSellerRequestPtr>, const std::optional<::base::Uuid>&)>;
  using GetInterestGroupAdAuctionDataMojoCallback = base::OnceCallback<void(::blink::Vector<::blink::mojom::blink::AdAuctionPerSellerRequestPtr>, const std::optional<::base::Uuid>&)>;

  virtual void GetInterestGroupAdAuctionData(const ::blink::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, ::scoped_refptr<const ::blink::SecurityOrigin>>& sellers, ::blink::mojom::blink::AuctionDataConfigPtr config, GetInterestGroupAdAuctionDataCallback callback) = 0;
};



class PLATFORM_EXPORT AbortableAdAuctionProxy
    : public AbortableAdAuction {
 public:
  using InterfaceType = AbortableAdAuction;

  explicit AbortableAdAuctionProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ResolvedPromiseParam(AuctionAdConfigAuctionIdPtr auction, AuctionAdConfigField field, const ::blink::String& json_value) final;
  
  void ResolvedPerBuyerSignalsPromise(AuctionAdConfigAuctionIdPtr auction, const std::optional<::blink::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, ::blink::String>>& per_buyer_signals) final;
  
  void ResolvedBuyerTkvSignalsPromise(AuctionAdConfigAuctionIdPtr auction, const ::scoped_refptr<const ::blink::SecurityOrigin>& buyer, const ::blink::String& json_value) final;
  
  void ResolvedBuyerTimeoutsPromise(AuctionAdConfigAuctionIdPtr auction, AuctionAdConfigBuyerTimeoutField field, ::blink::mojom::blink::AuctionAdConfigBuyerTimeoutsPtr buyer_timeouts) final;
  
  void ResolvedBuyerCurrenciesPromise(AuctionAdConfigAuctionIdPtr auction, ::blink::mojom::blink::AuctionAdConfigBuyerCurrenciesPtr per_buyer_currencies) final;
  
  void ResolvedDirectFromSellerSignalsPromise(AuctionAdConfigAuctionIdPtr auction, ::blink::mojom::blink::DirectFromSellerSignalsPtr direct_from_seller_signals) final;
  
  void ResolvedDirectFromSellerSignalsHeaderAdSlotPromise(AuctionAdConfigAuctionIdPtr auction, const ::blink::String& direct_from_seller_signals_header_ad_slot) final;
  
  void ResolvedDeprecatedRenderURLReplacementsPromise(AuctionAdConfigAuctionIdPtr auction, ::blink::Vector<::blink::mojom::blink::AdKeywordReplacementPtr> deprecated_render_url_replacements) final;
  
  void ResolvedAuctionAdResponsePromise(AuctionAdConfigAuctionIdPtr auction, ::mojo_base::BigBuffer result) final;
  
  void ResolvedAdditionalBids(AuctionAdConfigAuctionIdPtr auction) final;
  
  void Abort() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT AdAuctionServiceProxy
    : public AdAuctionService {
 public:
  using InterfaceType = AdAuctionService;

  explicit AdAuctionServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateAdRequest(::blink::mojom::blink::AdRequestConfigPtr config, CreateAdRequestCallback callback) final;
  
  void FinalizeAd(const ::blink::String& ads_guid, ::blink::mojom::blink::AuctionAdConfigPtr config, FinalizeAdCallback callback) final;
  
  void RunAdAuction(::blink::mojom::blink::AuctionAdConfigPtr config, ::mojo::PendingReceiver<AbortableAdAuction> abort_receiver, RunAdAuctionCallback callback) final;
  
  void JoinInterestGroup(::blink::mojom::blink::InterestGroupPtr group, JoinInterestGroupCallback callback) final;
  
  void LeaveInterestGroup(const ::scoped_refptr<const ::blink::SecurityOrigin>& owner, const ::blink::String& name, LeaveInterestGroupCallback callback) final;
  
  void LeaveInterestGroupForDocument() final;
  
  void ClearOriginJoinedInterestGroups(const ::scoped_refptr<const ::blink::SecurityOrigin>& owner, const ::blink::Vector<::blink::String>& interest_groups_to_keep, ClearOriginJoinedInterestGroupsCallback callback) final;
  
  void UpdateAdInterestGroups() final;
  
  void DeprecatedGetURLFromURN(const ::blink::KURL& uuid_url, bool send_reports, DeprecatedGetURLFromURNCallback callback) final;
  
  void DeprecatedReplaceInURN(const ::blink::KURL& uuid_url, ::blink::Vector<::blink::mojom::blink::AdKeywordReplacementPtr> replacements, DeprecatedReplaceInURNCallback callback) final;
  
  void GetInterestGroupAdAuctionData(const ::blink::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, ::scoped_refptr<const ::blink::SecurityOrigin>>& sellers, ::blink::mojom::blink::AuctionDataConfigPtr config, GetInterestGroupAdAuctionDataCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT AbortableAdAuctionStubDispatch {
 public:
  static bool Accept(AbortableAdAuction* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AbortableAdAuction* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AbortableAdAuction>>
class AbortableAdAuctionStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AbortableAdAuctionStub() = default;
  ~AbortableAdAuctionStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AbortableAdAuctionStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AbortableAdAuctionStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT AdAuctionServiceStubDispatch {
 public:
  static bool Accept(AdAuctionService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AdAuctionService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AdAuctionService>>
class AdAuctionServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AdAuctionServiceStub() = default;
  ~AdAuctionServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AdAuctionServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AdAuctionServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT AbortableAdAuctionRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT AdAuctionServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT AdAuctionServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class PLATFORM_EXPORT AuctionAdConfigAuctionId {
 public:
  using DataView = AuctionAdConfigAuctionIdDataView;
  using Data_ = internal::AuctionAdConfigAuctionId_Data;
  using Tag = Data_::AuctionAdConfigAuctionId_Tag;

  template <typename... Args>
  static AuctionAdConfigAuctionIdPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |main_auction|.
  static AuctionAdConfigAuctionIdPtr NewMainAuction(
      uint32_t value);
  // Construct an instance holding |component_auction|.
  static AuctionAdConfigAuctionIdPtr NewComponentAuction(
      uint32_t value);

  template <typename U>
  static AuctionAdConfigAuctionIdPtr From(const U& u) {
    return mojo::TypeConverter<AuctionAdConfigAuctionIdPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AuctionAdConfigAuctionId>::Convert(*this);
  }
  ~AuctionAdConfigAuctionId();


  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = AuctionAdConfigAuctionIdPtr>
  AuctionAdConfigAuctionIdPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, AuctionAdConfigAuctionId>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, AuctionAdConfigAuctionId>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }

  bool is_main_auction() const { return tag_ == Tag::kMainAuction; }
  uint32_t get_main_auction() const {
    CHECK(tag_ == Tag::kMainAuction);
    return data_.main_auction;
  }
  void set_main_auction(uint32_t main_auction);

  bool is_component_auction() const { return tag_ == Tag::kComponentAuction; }
  uint32_t get_component_auction() const {
    CHECK(tag_ == Tag::kComponentAuction);
    return data_.component_auction;
  }
  void set_component_auction(uint32_t component_auction);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AuctionAdConfigAuctionId::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<AuctionAdConfigAuctionId::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kMainAuction)>,
        uint32_t value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kComponentAuction)>,
        uint32_t value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    uint32_t main_auction;
    uint32_t component_auction;
  };

  AuctionAdConfigAuctionId(
      std::in_place_index_t<static_cast<size_t>(Tag::kMainAuction)>,
      uint32_t value);
  AuctionAdConfigAuctionId(
      std::in_place_index_t<static_cast<size_t>(Tag::kComponentAuction)>,
      uint32_t value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};

template <typename UnionPtrType>
AuctionAdConfigAuctionIdPtr AuctionAdConfigAuctionId::Clone() const {
  switch (tag_) {
    case Tag::kMainAuction:
      return NewMainAuction(
          mojo::Clone(data_.main_auction));
    case Tag::kComponentAuction:
      return NewComponentAuction(
          mojo::Clone(data_.component_auction));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, AuctionAdConfigAuctionId>::value>::type*>
bool AuctionAdConfigAuctionId::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kMainAuction:
      return mojo::Equals(data_.main_auction, other.data_.main_auction);
    case Tag::kComponentAuction:
      return mojo::Equals(data_.component_auction, other.data_.component_auction);
  }

  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT UnionTraits<::blink::mojom::blink::AuctionAdConfigAuctionId::DataView,
                                        ::blink::mojom::blink::AuctionAdConfigAuctionIdPtr> {
  static bool IsNull(const ::blink::mojom::blink::AuctionAdConfigAuctionIdPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AuctionAdConfigAuctionIdPtr* output) { output->reset(); }

  static ::blink::mojom::blink::AuctionAdConfigAuctionId::Tag GetTag(const ::blink::mojom::blink::AuctionAdConfigAuctionIdPtr& input) {
    return input->which();
  }

  static  uint32_t main_auction(const ::blink::mojom::blink::AuctionAdConfigAuctionIdPtr& input) {
    return input->get_main_auction();
  }

  static  uint32_t component_auction(const ::blink::mojom::blink::AuctionAdConfigAuctionIdPtr& input) {
    return input->get_component_auction();
  }

  static bool Read(::blink::mojom::blink::AuctionAdConfigAuctionId::DataView input, ::blink::mojom::blink::AuctionAdConfigAuctionIdPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_INTEREST_GROUP_AD_AUCTION_SERVICE_MOJOM_BLINK_H_