// third_party/blink/public/mojom/interest_group/ad_auction_service.mojom-blink-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INTEREST_GROUP_AD_AUCTION_SERVICE_MOJOM_BLINK_TEST_UTILS_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INTEREST_GROUP_AD_AUCTION_SERVICE_MOJOM_BLINK_TEST_UTILS_H_

#include "third_party/blink/public/mojom/interest_group/ad_auction_service.mojom-blink.h"
#include "third_party/blink/renderer/platform/platform_export.h"


namespace blink::mojom::blink {


class PLATFORM_EXPORT AbortableAdAuctionInterceptorForTesting : public AbortableAdAuction {
  virtual AbortableAdAuction* GetForwardingInterface() = 0;
  void ResolvedPromiseParam(AuctionAdConfigAuctionIdPtr auction, AuctionAdConfigField field, const ::blink::String& json_value) override;
  void ResolvedPerBuyerSignalsPromise(AuctionAdConfigAuctionIdPtr auction, const std::optional<::blink::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, ::blink::String>>& per_buyer_signals) override;
  void ResolvedBuyerTkvSignalsPromise(AuctionAdConfigAuctionIdPtr auction, const ::scoped_refptr<const ::blink::SecurityOrigin>& buyer, const ::blink::String& json_value) override;
  void ResolvedBuyerTimeoutsPromise(AuctionAdConfigAuctionIdPtr auction, AuctionAdConfigBuyerTimeoutField field, ::blink::mojom::blink::AuctionAdConfigBuyerTimeoutsPtr buyer_timeouts) override;
  void ResolvedBuyerCurrenciesPromise(AuctionAdConfigAuctionIdPtr auction, ::blink::mojom::blink::AuctionAdConfigBuyerCurrenciesPtr per_buyer_currencies) override;
  void ResolvedDirectFromSellerSignalsPromise(AuctionAdConfigAuctionIdPtr auction, ::blink::mojom::blink::DirectFromSellerSignalsPtr direct_from_seller_signals) override;
  void ResolvedDirectFromSellerSignalsHeaderAdSlotPromise(AuctionAdConfigAuctionIdPtr auction, const ::blink::String& direct_from_seller_signals_header_ad_slot) override;
  void ResolvedDeprecatedRenderURLReplacementsPromise(AuctionAdConfigAuctionIdPtr auction, ::blink::Vector<::blink::mojom::blink::AdKeywordReplacementPtr> deprecated_render_url_replacements) override;
  void ResolvedAuctionAdResponsePromise(AuctionAdConfigAuctionIdPtr auction, ::mojo_base::BigBuffer result) override;
  void ResolvedAdditionalBids(AuctionAdConfigAuctionIdPtr auction) override;
  void Abort() override;
};
class PLATFORM_EXPORT AbortableAdAuctionAsyncWaiter {
 public:
  explicit AbortableAdAuctionAsyncWaiter(AbortableAdAuction* proxy);

  AbortableAdAuctionAsyncWaiter(const AbortableAdAuctionAsyncWaiter&) = delete;
  AbortableAdAuctionAsyncWaiter& operator=(const AbortableAdAuctionAsyncWaiter&) = delete;

  ~AbortableAdAuctionAsyncWaiter();

 private:
  AbortableAdAuction* const proxy_;
};


class PLATFORM_EXPORT AdAuctionServiceInterceptorForTesting : public AdAuctionService {
  virtual AdAuctionService* GetForwardingInterface() = 0;
  void CreateAdRequest(::blink::mojom::blink::AdRequestConfigPtr config, CreateAdRequestCallback callback) override;
  void FinalizeAd(const ::blink::String& ads_guid, ::blink::mojom::blink::AuctionAdConfigPtr config, FinalizeAdCallback callback) override;
  void RunAdAuction(::blink::mojom::blink::AuctionAdConfigPtr config, ::mojo::PendingReceiver<AbortableAdAuction> abort_receiver, RunAdAuctionCallback callback) override;
  void JoinInterestGroup(::blink::mojom::blink::InterestGroupPtr group, JoinInterestGroupCallback callback) override;
  void LeaveInterestGroup(const ::scoped_refptr<const ::blink::SecurityOrigin>& owner, const ::blink::String& name, LeaveInterestGroupCallback callback) override;
  void LeaveInterestGroupForDocument() override;
  void ClearOriginJoinedInterestGroups(const ::scoped_refptr<const ::blink::SecurityOrigin>& owner, const ::blink::Vector<::blink::String>& interest_groups_to_keep, ClearOriginJoinedInterestGroupsCallback callback) override;
  void UpdateAdInterestGroups() override;
  void DeprecatedGetURLFromURN(const ::blink::KURL& uuid_url, bool send_reports, DeprecatedGetURLFromURNCallback callback) override;
  void DeprecatedReplaceInURN(const ::blink::KURL& uuid_url, ::blink::Vector<::blink::mojom::blink::AdKeywordReplacementPtr> replacements, DeprecatedReplaceInURNCallback callback) override;
  void GetInterestGroupAdAuctionData(const ::blink::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, ::scoped_refptr<const ::blink::SecurityOrigin>>& sellers, ::blink::mojom::blink::AuctionDataConfigPtr config, GetInterestGroupAdAuctionDataCallback callback) override;
};
class PLATFORM_EXPORT AdAuctionServiceAsyncWaiter {
 public:
  explicit AdAuctionServiceAsyncWaiter(AdAuctionService* proxy);

  AdAuctionServiceAsyncWaiter(const AdAuctionServiceAsyncWaiter&) = delete;
  AdAuctionServiceAsyncWaiter& operator=(const AdAuctionServiceAsyncWaiter&) = delete;

  ~AdAuctionServiceAsyncWaiter();
  void CreateAdRequest(
      ::blink::mojom::blink::AdRequestConfigPtr config, ::blink::String* out_ads_guid);
  ::blink::String CreateAdRequest(::blink::mojom::blink::AdRequestConfigPtr config);
  void FinalizeAd(
      const ::blink::String& ads_guid, ::blink::mojom::blink::AuctionAdConfigPtr config, std::optional<::blink::KURL>* out_ad_display_url);
  std::optional<::blink::KURL> FinalizeAd(const ::blink::String& ads_guid, ::blink::mojom::blink::AuctionAdConfigPtr config);
  void RunAdAuction(
      ::blink::mojom::blink::AuctionAdConfigPtr config, ::mojo::PendingReceiver<AbortableAdAuction> abort_receiver, bool* out_aborted_by_script, std::optional<::blink::FencedFrame::RedactedFencedFrameConfig>* out_config);
  
  void JoinInterestGroup(
      ::blink::mojom::blink::InterestGroupPtr group, bool* out_failed_well_known_check);
  bool JoinInterestGroup(::blink::mojom::blink::InterestGroupPtr group);
  void LeaveInterestGroup(
      const ::scoped_refptr<const ::blink::SecurityOrigin>& owner, const ::blink::String& name, bool* out_failed_well_known_check);
  bool LeaveInterestGroup(const ::scoped_refptr<const ::blink::SecurityOrigin>& owner, const ::blink::String& name);
  void ClearOriginJoinedInterestGroups(
      const ::scoped_refptr<const ::blink::SecurityOrigin>& owner, const ::blink::Vector<::blink::String>& interest_groups_to_keep, bool* out_failed_well_known_check);
  bool ClearOriginJoinedInterestGroups(const ::scoped_refptr<const ::blink::SecurityOrigin>& owner, const ::blink::Vector<::blink::String>& interest_groups_to_keep);
  void DeprecatedGetURLFromURN(
      const ::blink::KURL& uuid_url, bool send_reports, std::optional<::blink::KURL>* out_decoded_url);
  std::optional<::blink::KURL> DeprecatedGetURLFromURN(const ::blink::KURL& uuid_url, bool send_reports);
  void DeprecatedReplaceInURN(
      const ::blink::KURL& uuid_url, ::blink::Vector<::blink::mojom::blink::AdKeywordReplacementPtr> replacements);
  
  void GetInterestGroupAdAuctionData(
      const ::blink::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, ::scoped_refptr<const ::blink::SecurityOrigin>>& sellers, ::blink::mojom::blink::AuctionDataConfigPtr config, ::blink::Vector<::blink::mojom::blink::AdAuctionPerSellerRequestPtr>* out_requests, std::optional<::base::Uuid>* out_request_id);
  

 private:
  AdAuctionService* const proxy_;
};




}  // blink::mojom::blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_INTEREST_GROUP_AD_AUCTION_SERVICE_MOJOM_BLINK_TEST_UTILS_H_