// third_party/blink/public/mojom/input/text_input_host.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  Rect as gfx_mojom_Rect,
  RectSpec as gfx_mojom_RectSpec
} from '../../../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class TextInputHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.TextInputHost', scope);
  }
}

/** @interface */
export class TextInputHostInterface {
  
  /**
   * @param { !number } index
   */

  gotCharacterIndexAtPoint(index) {}
  
  /**
   * @param { !gfx_mojom_Rect } rect
   */

  gotFirstRectForRange(rect) {}
}

/**
 * @implements { TextInputHostInterface }
 */
export class TextInputHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!TextInputHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          TextInputHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!TextInputHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } index
   */

  gotCharacterIndexAtPoint(
      index) {
    this.proxy.sendMessage(
        0,
        TextInputHost_GotCharacterIndexAtPoint_ParamsSpec.$,
        null,
        [
          index
        ],
        false);
  }

  
  /**
   * @param { !gfx_mojom_Rect } rect
   */

  gotFirstRectForRange(
      rect) {
    this.proxy.sendMessage(
        1,
        TextInputHost_GotFirstRectForRange_ParamsSpec.$,
        null,
        [
          rect
        ],
        false);
  }
}

/**
 * An object which receives request messages for the TextInputHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class TextInputHostReceiver {
  /**
   * @param {!TextInputHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!TextInputHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        TextInputHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TextInputHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        TextInputHost_GotCharacterIndexAtPoint_ParamsSpec.$,
        null,
        impl.gotCharacterIndexAtPoint.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        TextInputHost_GotFirstRectForRange_ParamsSpec.$,
        null,
        impl.gotFirstRectForRange.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class TextInputHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.TextInputHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!TextInputHostRemote}
   */
  static getRemote() {
    let remote = new TextInputHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the TextInputHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class TextInputHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      TextInputHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TextInputHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.gotCharacterIndexAtPoint =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        TextInputHost_GotCharacterIndexAtPoint_ParamsSpec.$,
        null,
        this.gotCharacterIndexAtPoint.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.gotFirstRectForRange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        TextInputHost_GotFirstRectForRange_ParamsSpec.$,
        null,
        this.gotFirstRectForRange.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextInputHost_GotCharacterIndexAtPoint_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextInputHost_GotFirstRectForRange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    TextInputHost_GotCharacterIndexAtPoint_ParamsSpec.$,
    'TextInputHost_GotCharacterIndexAtPoint_Params',
    [
      mojo.internal.StructField(
        'index', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TextInputHost_GotCharacterIndexAtPoint_Params {
  constructor() {
    /** @type { !number } */
    this.index;
  }
}



mojo.internal.Struct(
    TextInputHost_GotFirstRectForRange_ParamsSpec.$,
    'TextInputHost_GotFirstRectForRange_Params',
    [
      mojo.internal.StructField(
        'rect', 0,
        0,
        gfx_mojom_RectSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TextInputHost_GotFirstRectForRange_Params {
  constructor() {
    /** @type { !gfx_mojom_Rect } */
    this.rect;
  }
}

