// third_party/blink/public/mojom/input/input_host.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/input/input_host.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/input/input_host.mojom-params-data.h"
#include "third_party/blink/public/mojom/input/input_host.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/input/input_host.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/input/input_host.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
SpellCheckSuggestion::SpellCheckSuggestion()
    : suggestion() {}

SpellCheckSuggestion::SpellCheckSuggestion(
    const ::blink::String& suggestion_in)
    : suggestion(std::move(suggestion_in)) {}

SpellCheckSuggestion::~SpellCheckSuggestion() = default;
size_t SpellCheckSuggestion::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->suggestion);
  return seed;
}

void SpellCheckSuggestion::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "suggestion"), this->suggestion,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SpellCheckSuggestion::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TextSuggestion::TextSuggestion()
    : marker_tag(),
      suggestion_index(),
      prefix(),
      suggestion(),
      suffix() {}

TextSuggestion::TextSuggestion(
    int32_t marker_tag_in,
    int32_t suggestion_index_in,
    const ::blink::String& prefix_in,
    const ::blink::String& suggestion_in,
    const ::blink::String& suffix_in)
    : marker_tag(std::move(marker_tag_in)),
      suggestion_index(std::move(suggestion_index_in)),
      prefix(std::move(prefix_in)),
      suggestion(std::move(suggestion_in)),
      suffix(std::move(suffix_in)) {}

TextSuggestion::~TextSuggestion() = default;
size_t TextSuggestion::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->marker_tag);
  seed = mojo::internal::WTFHash(seed, this->suggestion_index);
  seed = mojo::internal::WTFHash(seed, this->prefix);
  seed = mojo::internal::WTFHash(seed, this->suggestion);
  seed = mojo::internal::WTFHash(seed, this->suffix);
  return seed;
}

void TextSuggestion::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "marker_tag"), this->marker_tag,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "suggestion_index"), this->suggestion_index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prefix"), this->prefix,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "suggestion"), this->suggestion,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "suffix"), this->suffix,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TextSuggestion::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

TextSuggestionHost::IPCStableHashFunction TextSuggestionHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::TextSuggestionHost>(message.name())) {
    case messages::TextSuggestionHost::kStartSuggestionMenuTimer: {
      return &TextSuggestionHost::StartSuggestionMenuTimer_Sym::IPCStableHash;
    }
    case messages::TextSuggestionHost::kShowSpellCheckSuggestionMenu: {
      return &TextSuggestionHost::ShowSpellCheckSuggestionMenu_Sym::IPCStableHash;
    }
    case messages::TextSuggestionHost::kShowTextSuggestionMenu: {
      return &TextSuggestionHost::ShowTextSuggestionMenu_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* TextSuggestionHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::TextSuggestionHost>(message.name())) {
      case messages::TextSuggestionHost::kStartSuggestionMenuTimer:
            return "Receive blink::mojom::TextSuggestionHost::StartSuggestionMenuTimer";
      case messages::TextSuggestionHost::kShowSpellCheckSuggestionMenu:
            return "Receive blink::mojom::TextSuggestionHost::ShowSpellCheckSuggestionMenu";
      case messages::TextSuggestionHost::kShowTextSuggestionMenu:
            return "Receive blink::mojom::TextSuggestionHost::ShowTextSuggestionMenu";
    }
  } else {
    switch (static_cast<messages::TextSuggestionHost>(message.name())) {
      case messages::TextSuggestionHost::kStartSuggestionMenuTimer:
            return "Receive reply blink::mojom::TextSuggestionHost::StartSuggestionMenuTimer";
      case messages::TextSuggestionHost::kShowSpellCheckSuggestionMenu:
            return "Receive reply blink::mojom::TextSuggestionHost::ShowSpellCheckSuggestionMenu";
      case messages::TextSuggestionHost::kShowTextSuggestionMenu:
            return "Receive reply blink::mojom::TextSuggestionHost::ShowTextSuggestionMenu";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t TextSuggestionHost::StartSuggestionMenuTimer_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x33ca666f;  // IPCStableHash for blink::mojom::TextSuggestionHost::StartSuggestionMenuTimer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TextSuggestionHost::ShowSpellCheckSuggestionMenu_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdee33808;  // IPCStableHash for blink::mojom::TextSuggestionHost::ShowSpellCheckSuggestionMenu
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TextSuggestionHost::ShowTextSuggestionMenu_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x62bc7732;  // IPCStableHash for blink::mojom::TextSuggestionHost::ShowTextSuggestionMenu
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

TextSuggestionHostProxy::TextSuggestionHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TextSuggestionHostProxy::StartSuggestionMenuTimer(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::TextSuggestionHost::StartSuggestionMenuTimer");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextSuggestionHost::kStartSuggestionMenuTimer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::TextSuggestionHost_StartSuggestionMenuTimer_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextSuggestionHost::Name_);
  message.set_method_name("StartSuggestionMenuTimer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void TextSuggestionHostProxy::ShowSpellCheckSuggestionMenu(
    double in_caret_x, double in_caret_y, const ::blink::String& in_marked_text, ::blink::Vector<SpellCheckSuggestionPtr> in_suggestions) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::TextSuggestionHost::ShowSpellCheckSuggestionMenu", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("caret_x"), in_caret_x,
                        "<value of type double>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("caret_y"), in_caret_y,
                        "<value of type double>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("marked_text"), in_marked_text,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("suggestions"), in_suggestions,
                        "<value of type ::blink::Vector<SpellCheckSuggestionPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextSuggestionHost::kShowSpellCheckSuggestionMenu), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::TextSuggestionHost_ShowSpellCheckSuggestionMenu_Params_Data> params(
          message);
  params.Allocate();

  params->caret_x = in_caret_x;

  params->caret_y = in_caret_y;
  mojo::internal::MessageFragment<
      typename decltype(params->marked_text)::BaseType> marked_text_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_marked_text,
    marked_text_fragment);

  params->marked_text.Set(
      marked_text_fragment.is_null() ? nullptr : marked_text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->marked_text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null marked_text in TextSuggestionHost.ShowSpellCheckSuggestionMenu request");
  mojo::internal::MessageFragment<
      typename decltype(params->suggestions)::BaseType>
      suggestions_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& suggestions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SpellCheckSuggestionDataView>>(
    in_suggestions,
    suggestions_fragment,
    &suggestions_validate_params);

  params->suggestions.Set(
      suggestions_fragment.is_null() ? nullptr : suggestions_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->suggestions.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null suggestions in TextSuggestionHost.ShowSpellCheckSuggestionMenu request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextSuggestionHost::Name_);
  message.set_method_name("ShowSpellCheckSuggestionMenu");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void TextSuggestionHostProxy::ShowTextSuggestionMenu(
    double in_caret_x, double in_caret_y, const ::blink::String& in_marked_text, ::blink::Vector<TextSuggestionPtr> in_suggestions) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::TextSuggestionHost::ShowTextSuggestionMenu", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("caret_x"), in_caret_x,
                        "<value of type double>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("caret_y"), in_caret_y,
                        "<value of type double>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("marked_text"), in_marked_text,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("suggestions"), in_suggestions,
                        "<value of type ::blink::Vector<TextSuggestionPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextSuggestionHost::kShowTextSuggestionMenu), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::TextSuggestionHost_ShowTextSuggestionMenu_Params_Data> params(
          message);
  params.Allocate();

  params->caret_x = in_caret_x;

  params->caret_y = in_caret_y;
  mojo::internal::MessageFragment<
      typename decltype(params->marked_text)::BaseType> marked_text_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_marked_text,
    marked_text_fragment);

  params->marked_text.Set(
      marked_text_fragment.is_null() ? nullptr : marked_text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->marked_text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null marked_text in TextSuggestionHost.ShowTextSuggestionMenu request");
  mojo::internal::MessageFragment<
      typename decltype(params->suggestions)::BaseType>
      suggestions_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& suggestions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::TextSuggestionDataView>>(
    in_suggestions,
    suggestions_fragment,
    &suggestions_validate_params);

  params->suggestions.Set(
      suggestions_fragment.is_null() ? nullptr : suggestions_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->suggestions.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null suggestions in TextSuggestionHost.ShowTextSuggestionMenu request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextSuggestionHost::Name_);
  message.set_method_name("ShowTextSuggestionMenu");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool TextSuggestionHostStubDispatch::Accept(
    TextSuggestionHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::TextSuggestionHost>(message->header()->name)) {
    case messages::TextSuggestionHost::kStartSuggestionMenuTimer: {
      DCHECK(message->is_serialized());
      internal::TextSuggestionHost_StartSuggestionMenuTimer_Params_Data* params =
          reinterpret_cast<internal::TextSuggestionHost_StartSuggestionMenuTimer_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TextSuggestionHost.0
      bool success = true;
      TextSuggestionHost_StartSuggestionMenuTimer_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextSuggestionHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartSuggestionMenuTimer(        );
      return true;
    }
    case messages::TextSuggestionHost::kShowSpellCheckSuggestionMenu: {
      DCHECK(message->is_serialized());
      internal::TextSuggestionHost_ShowSpellCheckSuggestionMenu_Params_Data* params =
          reinterpret_cast<internal::TextSuggestionHost_ShowSpellCheckSuggestionMenu_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TextSuggestionHost.1
      bool success = true;
      double p_caret_x{};
      double p_caret_y{};
      ::blink::String p_marked_text{};
      ::blink::Vector<SpellCheckSuggestionPtr> p_suggestions{};
      TextSuggestionHost_ShowSpellCheckSuggestionMenu_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_caret_x = input_data_view.caret_x();
      if (success)
        p_caret_y = input_data_view.caret_y();
      if (success && !input_data_view.ReadMarkedText(&p_marked_text))
        success = false;
      if (success && !input_data_view.ReadSuggestions(&p_suggestions))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextSuggestionHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowSpellCheckSuggestionMenu(        
        std::move(p_caret_x), 
        std::move(p_caret_y), 
        std::move(p_marked_text), 
        std::move(p_suggestions));
      return true;
    }
    case messages::TextSuggestionHost::kShowTextSuggestionMenu: {
      DCHECK(message->is_serialized());
      internal::TextSuggestionHost_ShowTextSuggestionMenu_Params_Data* params =
          reinterpret_cast<internal::TextSuggestionHost_ShowTextSuggestionMenu_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TextSuggestionHost.2
      bool success = true;
      double p_caret_x{};
      double p_caret_y{};
      ::blink::String p_marked_text{};
      ::blink::Vector<TextSuggestionPtr> p_suggestions{};
      TextSuggestionHost_ShowTextSuggestionMenu_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_caret_x = input_data_view.caret_x();
      if (success)
        p_caret_y = input_data_view.caret_y();
      if (success && !input_data_view.ReadMarkedText(&p_marked_text))
        success = false;
      if (success && !input_data_view.ReadSuggestions(&p_suggestions))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextSuggestionHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowTextSuggestionMenu(        
        std::move(p_caret_x), 
        std::move(p_caret_y), 
        std::move(p_marked_text), 
        std::move(p_suggestions));
      return true;
    }
  }
  return false;
}

// static
bool TextSuggestionHostStubDispatch::AcceptWithResponder(
    TextSuggestionHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::TextSuggestionHost>(message->header()->name)) {
    case messages::TextSuggestionHost::kStartSuggestionMenuTimer: {
      break;
    }
    case messages::TextSuggestionHost::kShowSpellCheckSuggestionMenu: {
      break;
    }
    case messages::TextSuggestionHost::kShowTextSuggestionMenu: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kTextSuggestionHostValidationInfo[] = {
    { &internal::TextSuggestionHost_StartSuggestionMenuTimer_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::TextSuggestionHost_ShowSpellCheckSuggestionMenu_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::TextSuggestionHost_ShowTextSuggestionMenu_Params_Data::Validate,
     nullptr /* no response */},
};

bool TextSuggestionHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::TextSuggestionHost::Name_,
    kTextSuggestionHostValidationInfo);
}



}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::SpellCheckSuggestion::DataView, ::blink::mojom::blink::SpellCheckSuggestionPtr>::Read(
    ::blink::mojom::blink::SpellCheckSuggestion::DataView input,
    ::blink::mojom::blink::SpellCheckSuggestionPtr* output) {
  bool success = true;
  ::blink::mojom::blink::SpellCheckSuggestionPtr result(::blink::mojom::blink::SpellCheckSuggestion::New());
  
      if (success && !input.ReadSuggestion(&result->suggestion))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::TextSuggestion::DataView, ::blink::mojom::blink::TextSuggestionPtr>::Read(
    ::blink::mojom::blink::TextSuggestion::DataView input,
    ::blink::mojom::blink::TextSuggestionPtr* output) {
  bool success = true;
  ::blink::mojom::blink::TextSuggestionPtr result(::blink::mojom::blink::TextSuggestion::New());
  
      if (success)
        result->marker_tag = input.marker_tag();
      if (success)
        result->suggestion_index = input.suggestion_index();
      if (success && !input.ReadPrefix(&result->prefix))
        success = false;
      if (success && !input.ReadSuggestion(&result->suggestion))
        success = false;
      if (success && !input.ReadSuffix(&result->suffix))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void TextSuggestionHostInterceptorForTesting::StartSuggestionMenuTimer() {
  GetForwardingInterface()->StartSuggestionMenuTimer();
}
void TextSuggestionHostInterceptorForTesting::ShowSpellCheckSuggestionMenu(double caret_x, double caret_y, const ::blink::String& marked_text, ::blink::Vector<SpellCheckSuggestionPtr> suggestions) {
  GetForwardingInterface()->ShowSpellCheckSuggestionMenu(
    std::move(caret_x)
    , 
    std::move(caret_y)
    , 
    std::move(marked_text)
    , 
    std::move(suggestions)
    );
}
void TextSuggestionHostInterceptorForTesting::ShowTextSuggestionMenu(double caret_x, double caret_y, const ::blink::String& marked_text, ::blink::Vector<TextSuggestionPtr> suggestions) {
  GetForwardingInterface()->ShowTextSuggestionMenu(
    std::move(caret_x)
    , 
    std::move(caret_y)
    , 
    std::move(marked_text)
    , 
    std::move(suggestions)
    );
}
TextSuggestionHostAsyncWaiter::TextSuggestionHostAsyncWaiter(
    TextSuggestionHost* proxy) : proxy_(proxy) {}

TextSuggestionHostAsyncWaiter::~TextSuggestionHostAsyncWaiter() = default;







}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif