// third_party/blink/public/mojom/input/input_handler.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/input/input_handler.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/input/input_handler.mojom-params-data.h"
#include "third_party/blink/public/mojom/input/input_handler.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/input/input_handler.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/input/input_handler.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
KeyData::KeyData()
    : dom_key(),
      dom_code(),
      windows_key_code(),
      native_key_code(),
      is_system_key(),
      is_browser_shortcut(),
      text(),
      unmodified_text() {}

KeyData::KeyData(
    int32_t dom_key_in,
    int32_t dom_code_in,
    int32_t windows_key_code_in,
    int32_t native_key_code_in,
    bool is_system_key_in,
    bool is_browser_shortcut_in,
    const ::blink::String& text_in,
    const ::blink::String& unmodified_text_in)
    : dom_key(std::move(dom_key_in)),
      dom_code(std::move(dom_code_in)),
      windows_key_code(std::move(windows_key_code_in)),
      native_key_code(std::move(native_key_code_in)),
      is_system_key(std::move(is_system_key_in)),
      is_browser_shortcut(std::move(is_browser_shortcut_in)),
      text(std::move(text_in)),
      unmodified_text(std::move(unmodified_text_in)) {}

KeyData::~KeyData() = default;

void KeyData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dom_key"), this->dom_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dom_code"), this->dom_code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "windows_key_code"), this->windows_key_code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "native_key_code"), this->native_key_code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_system_key"), this->is_system_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_browser_shortcut"), this->is_browser_shortcut,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text"), this->text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "unmodified_text"), this->unmodified_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool KeyData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PointerData::PointerData()
    : pointer_id(),
      force(),
      tilt_x(),
      tilt_y(),
      tangential_pressure(),
      twist(),
      button(),
      pointer_type(),
      movement_x(),
      movement_y(),
      is_raw_movement_event(),
      widget_position(),
      screen_position(),
      mouse_data(),
      device_id() {}

PointerData::PointerData(
    int32_t pointer_id_in,
    float force_in,
    double tilt_x_in,
    double tilt_y_in,
    float tangential_pressure_in,
    int32_t twist_in,
    ::blink::mojom::blink::Button button_in,
    ::ui::EventPointerType pointer_type_in,
    int32_t movement_x_in,
    int32_t movement_y_in,
    bool is_raw_movement_event_in,
    const ::gfx::PointF& widget_position_in,
    const ::gfx::PointF& screen_position_in,
    MouseDataPtr mouse_data_in,
    int32_t device_id_in)
    : pointer_id(std::move(pointer_id_in)),
      force(std::move(force_in)),
      tilt_x(std::move(tilt_x_in)),
      tilt_y(std::move(tilt_y_in)),
      tangential_pressure(std::move(tangential_pressure_in)),
      twist(std::move(twist_in)),
      button(std::move(button_in)),
      pointer_type(std::move(pointer_type_in)),
      movement_x(std::move(movement_x_in)),
      movement_y(std::move(movement_y_in)),
      is_raw_movement_event(std::move(is_raw_movement_event_in)),
      widget_position(std::move(widget_position_in)),
      screen_position(std::move(screen_position_in)),
      mouse_data(std::move(mouse_data_in)),
      device_id(std::move(device_id_in)) {}

PointerData::~PointerData() = default;

void PointerData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pointer_id"), this->pointer_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "force"), this->force,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tilt_x"), this->tilt_x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tilt_y"), this->tilt_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tangential_pressure"), this->tangential_pressure,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "twist"), this->twist,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "button"), this->button,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::blink::Button>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pointer_type"), this->pointer_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ui::EventPointerType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "movement_x"), this->movement_x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "movement_y"), this->movement_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_raw_movement_event"), this->is_raw_movement_event,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "widget_position"), this->widget_position,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "screen_position"), this->screen_position,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mouse_data"), this->mouse_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type MouseDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_id"), this->device_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PointerData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WheelData::WheelData()
    : delta_x(),
      delta_y(),
      wheel_ticks_x(),
      wheel_ticks_y(),
      acceleration_ratio_x(),
      acceleration_ratio_y(),
      phase(),
      momentum_phase(),
      cancelable(),
      event_action(),
      delta_units(),
      rails_mode() {}

WheelData::WheelData(
    float delta_x_in,
    float delta_y_in,
    float wheel_ticks_x_in,
    float wheel_ticks_y_in,
    float acceleration_ratio_x_in,
    float acceleration_ratio_y_in,
    uint8_t phase_in,
    uint8_t momentum_phase_in,
    ::blink::mojom::blink::DispatchType cancelable_in,
    uint8_t event_action_in,
    uint8_t delta_units_in,
    int32_t rails_mode_in)
    : delta_x(std::move(delta_x_in)),
      delta_y(std::move(delta_y_in)),
      wheel_ticks_x(std::move(wheel_ticks_x_in)),
      wheel_ticks_y(std::move(wheel_ticks_y_in)),
      acceleration_ratio_x(std::move(acceleration_ratio_x_in)),
      acceleration_ratio_y(std::move(acceleration_ratio_y_in)),
      phase(std::move(phase_in)),
      momentum_phase(std::move(momentum_phase_in)),
      cancelable(std::move(cancelable_in)),
      event_action(std::move(event_action_in)),
      delta_units(std::move(delta_units_in)),
      rails_mode(std::move(rails_mode_in)) {}

WheelData::~WheelData() = default;
size_t WheelData::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->delta_x);
  seed = mojo::internal::WTFHash(seed, this->delta_y);
  seed = mojo::internal::WTFHash(seed, this->wheel_ticks_x);
  seed = mojo::internal::WTFHash(seed, this->wheel_ticks_y);
  seed = mojo::internal::WTFHash(seed, this->acceleration_ratio_x);
  seed = mojo::internal::WTFHash(seed, this->acceleration_ratio_y);
  seed = mojo::internal::WTFHash(seed, this->phase);
  seed = mojo::internal::WTFHash(seed, this->momentum_phase);
  seed = mojo::internal::WTFHash(seed, this->cancelable);
  seed = mojo::internal::WTFHash(seed, this->event_action);
  seed = mojo::internal::WTFHash(seed, this->delta_units);
  seed = mojo::internal::WTFHash(seed, this->rails_mode);
  return seed;
}

void WheelData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "delta_x"), this->delta_x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "delta_y"), this->delta_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wheel_ticks_x"), this->wheel_ticks_x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wheel_ticks_y"), this->wheel_ticks_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "acceleration_ratio_x"), this->acceleration_ratio_x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "acceleration_ratio_y"), this->acceleration_ratio_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "phase"), this->phase,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "momentum_phase"), this->momentum_phase,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cancelable"), this->cancelable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::blink::DispatchType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "event_action"), this->event_action,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "delta_units"), this->delta_units,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rails_mode"), this->rails_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WheelData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MouseData::MouseData()
    : click_count(),
      wheel_data() {}

MouseData::MouseData(
    int32_t click_count_in,
    WheelDataPtr wheel_data_in)
    : click_count(std::move(click_count_in)),
      wheel_data(std::move(wheel_data_in)) {}

MouseData::~MouseData() = default;

void MouseData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "click_count"), this->click_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wheel_data"), this->wheel_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WheelDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MouseData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ScrollData::ScrollData()
    : delta_x(),
      delta_y(),
      delta_units(),
      target_viewport(),
      inertial_phase(),
      synthetic(),
      pointer_count(),
      cursor_control() {}

ScrollData::ScrollData(
    float delta_x_in,
    float delta_y_in,
    ::ui::ScrollGranularity delta_units_in,
    bool target_viewport_in,
    ::blink::mojom::blink::InertialPhaseState inertial_phase_in,
    bool synthetic_in,
    int32_t pointer_count_in,
    bool cursor_control_in)
    : delta_x(std::move(delta_x_in)),
      delta_y(std::move(delta_y_in)),
      delta_units(std::move(delta_units_in)),
      target_viewport(std::move(target_viewport_in)),
      inertial_phase(std::move(inertial_phase_in)),
      synthetic(std::move(synthetic_in)),
      pointer_count(std::move(pointer_count_in)),
      cursor_control(std::move(cursor_control_in)) {}

ScrollData::~ScrollData() = default;

void ScrollData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "delta_x"), this->delta_x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "delta_y"), this->delta_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "delta_units"), this->delta_units,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ui::ScrollGranularity>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_viewport"), this->target_viewport,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "inertial_phase"), this->inertial_phase,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::blink::InertialPhaseState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "synthetic"), this->synthetic,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pointer_count"), this->pointer_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cursor_control"), this->cursor_control,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ScrollData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PinchBeginData::PinchBeginData()
    : needs_wheel_event() {}

PinchBeginData::PinchBeginData(
    bool needs_wheel_event_in)
    : needs_wheel_event(std::move(needs_wheel_event_in)) {}

PinchBeginData::~PinchBeginData() = default;
size_t PinchBeginData::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->needs_wheel_event);
  return seed;
}

void PinchBeginData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "needs_wheel_event"), this->needs_wheel_event,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PinchBeginData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PinchUpdateData::PinchUpdateData()
    : scale(),
      zoom_disabled(),
      needs_wheel_event() {}

PinchUpdateData::PinchUpdateData(
    float scale_in,
    bool zoom_disabled_in,
    bool needs_wheel_event_in)
    : scale(std::move(scale_in)),
      zoom_disabled(std::move(zoom_disabled_in)),
      needs_wheel_event(std::move(needs_wheel_event_in)) {}

PinchUpdateData::~PinchUpdateData() = default;
size_t PinchUpdateData::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->scale);
  seed = mojo::internal::WTFHash(seed, this->zoom_disabled);
  seed = mojo::internal::WTFHash(seed, this->needs_wheel_event);
  return seed;
}

void PinchUpdateData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scale"), this->scale,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "zoom_disabled"), this->zoom_disabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "needs_wheel_event"), this->needs_wheel_event,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PinchUpdateData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PinchEndData::PinchEndData()
    : needs_wheel_event() {}

PinchEndData::PinchEndData(
    bool needs_wheel_event_in)
    : needs_wheel_event(std::move(needs_wheel_event_in)) {}

PinchEndData::~PinchEndData() = default;
size_t PinchEndData::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->needs_wheel_event);
  return seed;
}

void PinchEndData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "needs_wheel_event"), this->needs_wheel_event,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PinchEndData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FlingData::FlingData()
    : velocity_x(),
      velocity_y(),
      target_viewport(),
      prevent_boosting() {}

FlingData::FlingData(
    float velocity_x_in,
    float velocity_y_in,
    bool target_viewport_in,
    bool prevent_boosting_in)
    : velocity_x(std::move(velocity_x_in)),
      velocity_y(std::move(velocity_y_in)),
      target_viewport(std::move(target_viewport_in)),
      prevent_boosting(std::move(prevent_boosting_in)) {}

FlingData::~FlingData() = default;
size_t FlingData::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->velocity_x);
  seed = mojo::internal::WTFHash(seed, this->velocity_y);
  seed = mojo::internal::WTFHash(seed, this->target_viewport);
  seed = mojo::internal::WTFHash(seed, this->prevent_boosting);
  return seed;
}

void FlingData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "velocity_x"), this->velocity_x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "velocity_y"), this->velocity_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_viewport"), this->target_viewport,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prevent_boosting"), this->prevent_boosting,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FlingData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TapData::TapData()
    : tap_count(),
      needs_wheel_event() {}

TapData::TapData(
    int32_t tap_count_in,
    bool needs_wheel_event_in)
    : tap_count(std::move(tap_count_in)),
      needs_wheel_event(std::move(needs_wheel_event_in)) {}

TapData::~TapData() = default;
size_t TapData::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->tap_count);
  seed = mojo::internal::WTFHash(seed, this->needs_wheel_event);
  return seed;
}

void TapData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tap_count"), this->tap_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "needs_wheel_event"), this->needs_wheel_event,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TapData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TapDownData::TapDownData()
    : tap_down_count() {}

TapDownData::TapDownData(
    int32_t tap_down_count_in)
    : tap_down_count(std::move(tap_down_count_in)) {}

TapDownData::~TapDownData() = default;
size_t TapDownData::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->tap_down_count);
  return seed;
}

void TapDownData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tap_down_count"), this->tap_down_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TapDownData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GestureData::GestureData()
    : screen_position(),
      widget_position(),
      source_device(),
      is_source_touch_event_set_blocking(),
      primary_pointer_type(),
      primary_unique_touch_event_id(),
      unique_touch_event_id(),
      contact_size(),
      scroll_data(),
      pinch_begin_data(),
      pinch_update_data(),
      pinch_end_data(),
      tap_data(),
      tap_down_data(),
      fling_data() {}

GestureData::GestureData(
    const ::gfx::PointF& screen_position_in,
    const ::gfx::PointF& widget_position_in,
    ::blink::mojom::blink::GestureDevice source_device_in,
    bool is_source_touch_event_set_blocking_in,
    ::ui::EventPointerType primary_pointer_type_in,
    int32_t primary_unique_touch_event_id_in,
    int32_t unique_touch_event_id_in,
    const std::optional<::gfx::Size>& contact_size_in,
    ScrollDataPtr scroll_data_in,
    PinchBeginDataPtr pinch_begin_data_in,
    PinchUpdateDataPtr pinch_update_data_in,
    PinchEndDataPtr pinch_end_data_in,
    TapDataPtr tap_data_in,
    TapDownDataPtr tap_down_data_in,
    FlingDataPtr fling_data_in)
    : screen_position(std::move(screen_position_in)),
      widget_position(std::move(widget_position_in)),
      source_device(std::move(source_device_in)),
      is_source_touch_event_set_blocking(std::move(is_source_touch_event_set_blocking_in)),
      primary_pointer_type(std::move(primary_pointer_type_in)),
      primary_unique_touch_event_id(std::move(primary_unique_touch_event_id_in)),
      unique_touch_event_id(std::move(unique_touch_event_id_in)),
      contact_size(std::move(contact_size_in)),
      scroll_data(std::move(scroll_data_in)),
      pinch_begin_data(std::move(pinch_begin_data_in)),
      pinch_update_data(std::move(pinch_update_data_in)),
      pinch_end_data(std::move(pinch_end_data_in)),
      tap_data(std::move(tap_data_in)),
      tap_down_data(std::move(tap_down_data_in)),
      fling_data(std::move(fling_data_in)) {}

GestureData::~GestureData() = default;

void GestureData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "screen_position"), this->screen_position,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "widget_position"), this->widget_position,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_device"), this->source_device,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::blink::GestureDevice>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_source_touch_event_set_blocking"), this->is_source_touch_event_set_blocking,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary_pointer_type"), this->primary_pointer_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ui::EventPointerType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary_unique_touch_event_id"), this->primary_unique_touch_event_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "unique_touch_event_id"), this->unique_touch_event_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "contact_size"), this->contact_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::Size>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scroll_data"), this->scroll_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ScrollDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pinch_begin_data"), this->pinch_begin_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PinchBeginDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pinch_update_data"), this->pinch_update_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PinchUpdateDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pinch_end_data"), this->pinch_end_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PinchEndDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tap_data"), this->tap_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TapDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tap_down_data"), this->tap_down_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TapDownDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fling_data"), this->fling_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type FlingDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GestureData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TouchPoint::TouchPoint()
    : state(),
      radius_x(),
      radius_y(),
      rotation_angle(),
      pointer_data() {}

TouchPoint::TouchPoint(
    ::blink::mojom::blink::TouchState state_in,
    float radius_x_in,
    float radius_y_in,
    float rotation_angle_in,
    PointerDataPtr pointer_data_in)
    : state(std::move(state_in)),
      radius_x(std::move(radius_x_in)),
      radius_y(std::move(radius_y_in)),
      rotation_angle(std::move(rotation_angle_in)),
      pointer_data(std::move(pointer_data_in)) {}

TouchPoint::~TouchPoint() = default;

void TouchPoint::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "state"), this->state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::blink::TouchState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "radius_x"), this->radius_x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "radius_y"), this->radius_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rotation_angle"), this->rotation_angle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pointer_data"), this->pointer_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PointerDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TouchPoint::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TouchData::TouchData()
    : cancelable(),
      moved_beyond_slop_region(),
      touch_start_or_first_move(),
      hovering(),
      unique_touch_event_id(),
      touches() {}

TouchData::TouchData(
    ::blink::mojom::blink::DispatchType cancelable_in,
    bool moved_beyond_slop_region_in,
    bool touch_start_or_first_move_in,
    bool hovering_in,
    uint32_t unique_touch_event_id_in,
    ::blink::Vector<TouchPointPtr> touches_in)
    : cancelable(std::move(cancelable_in)),
      moved_beyond_slop_region(std::move(moved_beyond_slop_region_in)),
      touch_start_or_first_move(std::move(touch_start_or_first_move_in)),
      hovering(std::move(hovering_in)),
      unique_touch_event_id(std::move(unique_touch_event_id_in)),
      touches(std::move(touches_in)) {}

TouchData::~TouchData() = default;

void TouchData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cancelable"), this->cancelable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::blink::DispatchType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "moved_beyond_slop_region"), this->moved_beyond_slop_region,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "touch_start_or_first_move"), this->touch_start_or_first_move,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hovering"), this->hovering,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "unique_touch_event_id"), this->unique_touch_event_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "touches"), this->touches,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<TouchPointPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TouchData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Event::Event()
    : type(),
      modifiers(),
      timestamp(),
      latency(),
      event_latency_metadata(),
      key_data(),
      pointer_data(),
      gesture_data(),
      touch_data(),
      input_source() {}

Event::Event(
    ::blink::mojom::blink::EventType type_in,
    int32_t modifiers_in,
    ::base::TimeTicks timestamp_in,
    const ::ui::LatencyInfo& latency_in,
    ::ui::mojom::blink::EventLatencyMetadataPtr event_latency_metadata_in,
    KeyDataPtr key_data_in,
    PointerDataPtr pointer_data_in,
    GestureDataPtr gesture_data_in,
    TouchDataPtr touch_data_in,
    ::blink::mojom::blink::InputSource input_source_in)
    : type(std::move(type_in)),
      modifiers(std::move(modifiers_in)),
      timestamp(std::move(timestamp_in)),
      latency(std::move(latency_in)),
      event_latency_metadata(std::move(event_latency_metadata_in)),
      key_data(std::move(key_data_in)),
      pointer_data(std::move(pointer_data_in)),
      gesture_data(std::move(gesture_data_in)),
      touch_data(std::move(touch_data_in)),
      input_source(std::move(input_source_in)) {}

Event::~Event() = default;

void Event::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::blink::EventType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "modifiers"), this->modifiers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timestamp"), this->timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "latency"), this->latency,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::ui::LatencyInfo&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "event_latency_metadata"), this->event_latency_metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ui::mojom::blink::EventLatencyMetadataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key_data"), this->key_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type KeyDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pointer_data"), this->pointer_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PointerDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gesture_data"), this->gesture_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type GestureDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "touch_data"), this->touch_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TouchDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_source"), this->input_source,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::blink::InputSource>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Event::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DidOverscrollParams::DidOverscrollParams()
    : accumulated_overscroll(),
      latest_overscroll_delta(),
      current_fling_velocity(),
      causal_event_viewport_point(),
      overscroll_behavior(),
      source_device() {}

DidOverscrollParams::DidOverscrollParams(
    const ::gfx::Vector2dF& accumulated_overscroll_in,
    const ::gfx::Vector2dF& latest_overscroll_delta_in,
    const ::gfx::Vector2dF& current_fling_velocity_in,
    const ::gfx::PointF& causal_event_viewport_point_in,
    const ::cc::OverscrollBehavior& overscroll_behavior_in,
    ::blink::mojom::blink::GestureDevice source_device_in)
    : accumulated_overscroll(std::move(accumulated_overscroll_in)),
      latest_overscroll_delta(std::move(latest_overscroll_delta_in)),
      current_fling_velocity(std::move(current_fling_velocity_in)),
      causal_event_viewport_point(std::move(causal_event_viewport_point_in)),
      overscroll_behavior(std::move(overscroll_behavior_in)),
      source_device(std::move(source_device_in)) {}

DidOverscrollParams::~DidOverscrollParams() = default;

void DidOverscrollParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "accumulated_overscroll"), this->accumulated_overscroll,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Vector2dF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "latest_overscroll_delta"), this->latest_overscroll_delta,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Vector2dF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "current_fling_velocity"), this->current_fling_velocity,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Vector2dF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "causal_event_viewport_point"), this->causal_event_viewport_point,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "overscroll_behavior"), this->overscroll_behavior,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::cc::OverscrollBehavior&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_device"), this->source_device,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::blink::GestureDevice>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DidOverscrollParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TouchActionOptional::TouchActionOptional()
    : touch_action() {}

TouchActionOptional::TouchActionOptional(
    ::cc::TouchAction touch_action_in)
    : touch_action(std::move(touch_action_in)) {}

TouchActionOptional::~TouchActionOptional() = default;

void TouchActionOptional::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "touch_action"), this->touch_action,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::cc::TouchAction>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TouchActionOptional::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
EditCommand::EditCommand()
    : name(),
      value() {}

EditCommand::EditCommand(
    const ::blink::String& name_in,
    const ::blink::String& value_in)
    : name(std::move(name_in)),
      value(std::move(value_in)) {}

EditCommand::~EditCommand() = default;
size_t EditCommand::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->name);
  seed = mojo::internal::WTFHash(seed, this->value);
  return seed;
}

void EditCommand::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool EditCommand::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SelectAroundCaretResult::SelectAroundCaretResult()
    : extended_start_adjust(),
      extended_end_adjust(),
      word_start_adjust(),
      word_end_adjust() {}

SelectAroundCaretResult::SelectAroundCaretResult(
    int32_t extended_start_adjust_in,
    int32_t extended_end_adjust_in,
    int32_t word_start_adjust_in,
    int32_t word_end_adjust_in)
    : extended_start_adjust(std::move(extended_start_adjust_in)),
      extended_end_adjust(std::move(extended_end_adjust_in)),
      word_start_adjust(std::move(word_start_adjust_in)),
      word_end_adjust(std::move(word_end_adjust_in)) {}

SelectAroundCaretResult::~SelectAroundCaretResult() = default;
size_t SelectAroundCaretResult::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->extended_start_adjust);
  seed = mojo::internal::WTFHash(seed, this->extended_end_adjust);
  seed = mojo::internal::WTFHash(seed, this->word_start_adjust);
  seed = mojo::internal::WTFHash(seed, this->word_end_adjust);
  return seed;
}

void SelectAroundCaretResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "extended_start_adjust"), this->extended_start_adjust,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "extended_end_adjust"), this->extended_end_adjust,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "word_start_adjust"), this->word_start_adjust,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "word_end_adjust"), this->word_end_adjust,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SelectAroundCaretResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

WidgetInputHandlerHost::IPCStableHashFunction WidgetInputHandlerHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WidgetInputHandlerHost>(message.name())) {
    case messages::WidgetInputHandlerHost::kSetTouchActionFromMain: {
      return &WidgetInputHandlerHost::SetTouchActionFromMain_Sym::IPCStableHash;
    }
    case messages::WidgetInputHandlerHost::kSetPanAction: {
      return &WidgetInputHandlerHost::SetPanAction_Sym::IPCStableHash;
    }
    case messages::WidgetInputHandlerHost::kDidOverscroll: {
      return &WidgetInputHandlerHost::DidOverscroll_Sym::IPCStableHash;
    }
    case messages::WidgetInputHandlerHost::kDidStartScrollingViewport: {
      return &WidgetInputHandlerHost::DidStartScrollingViewport_Sym::IPCStableHash;
    }
    case messages::WidgetInputHandlerHost::kImeCancelComposition: {
      return &WidgetInputHandlerHost::ImeCancelComposition_Sym::IPCStableHash;
    }
    case messages::WidgetInputHandlerHost::kImeCompositionRangeChanged: {
      return &WidgetInputHandlerHost::ImeCompositionRangeChanged_Sym::IPCStableHash;
    }
    case messages::WidgetInputHandlerHost::kSetMouseCapture: {
      return &WidgetInputHandlerHost::SetMouseCapture_Sym::IPCStableHash;
    }
    case messages::WidgetInputHandlerHost::kSetAutoscrollSelectionActiveInMainFrame: {
      return &WidgetInputHandlerHost::SetAutoscrollSelectionActiveInMainFrame_Sym::IPCStableHash;
    }
    case messages::WidgetInputHandlerHost::kRequestMouseLock: {
      return &WidgetInputHandlerHost::RequestMouseLock_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WidgetInputHandlerHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WidgetInputHandlerHost>(message.name())) {
      case messages::WidgetInputHandlerHost::kSetTouchActionFromMain:
            return "Receive blink::mojom::WidgetInputHandlerHost::SetTouchActionFromMain";
      case messages::WidgetInputHandlerHost::kSetPanAction:
            return "Receive blink::mojom::WidgetInputHandlerHost::SetPanAction";
      case messages::WidgetInputHandlerHost::kDidOverscroll:
            return "Receive blink::mojom::WidgetInputHandlerHost::DidOverscroll";
      case messages::WidgetInputHandlerHost::kDidStartScrollingViewport:
            return "Receive blink::mojom::WidgetInputHandlerHost::DidStartScrollingViewport";
      case messages::WidgetInputHandlerHost::kImeCancelComposition:
            return "Receive blink::mojom::WidgetInputHandlerHost::ImeCancelComposition";
      case messages::WidgetInputHandlerHost::kImeCompositionRangeChanged:
            return "Receive blink::mojom::WidgetInputHandlerHost::ImeCompositionRangeChanged";
      case messages::WidgetInputHandlerHost::kSetMouseCapture:
            return "Receive blink::mojom::WidgetInputHandlerHost::SetMouseCapture";
      case messages::WidgetInputHandlerHost::kSetAutoscrollSelectionActiveInMainFrame:
            return "Receive blink::mojom::WidgetInputHandlerHost::SetAutoscrollSelectionActiveInMainFrame";
      case messages::WidgetInputHandlerHost::kRequestMouseLock:
            return "Receive blink::mojom::WidgetInputHandlerHost::RequestMouseLock";
    }
  } else {
    switch (static_cast<messages::WidgetInputHandlerHost>(message.name())) {
      case messages::WidgetInputHandlerHost::kSetTouchActionFromMain:
            return "Receive reply blink::mojom::WidgetInputHandlerHost::SetTouchActionFromMain";
      case messages::WidgetInputHandlerHost::kSetPanAction:
            return "Receive reply blink::mojom::WidgetInputHandlerHost::SetPanAction";
      case messages::WidgetInputHandlerHost::kDidOverscroll:
            return "Receive reply blink::mojom::WidgetInputHandlerHost::DidOverscroll";
      case messages::WidgetInputHandlerHost::kDidStartScrollingViewport:
            return "Receive reply blink::mojom::WidgetInputHandlerHost::DidStartScrollingViewport";
      case messages::WidgetInputHandlerHost::kImeCancelComposition:
            return "Receive reply blink::mojom::WidgetInputHandlerHost::ImeCancelComposition";
      case messages::WidgetInputHandlerHost::kImeCompositionRangeChanged:
            return "Receive reply blink::mojom::WidgetInputHandlerHost::ImeCompositionRangeChanged";
      case messages::WidgetInputHandlerHost::kSetMouseCapture:
            return "Receive reply blink::mojom::WidgetInputHandlerHost::SetMouseCapture";
      case messages::WidgetInputHandlerHost::kSetAutoscrollSelectionActiveInMainFrame:
            return "Receive reply blink::mojom::WidgetInputHandlerHost::SetAutoscrollSelectionActiveInMainFrame";
      case messages::WidgetInputHandlerHost::kRequestMouseLock:
            return "Receive reply blink::mojom::WidgetInputHandlerHost::RequestMouseLock";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WidgetInputHandlerHost::SetTouchActionFromMain_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe9031078;  // IPCStableHash for blink::mojom::WidgetInputHandlerHost::SetTouchActionFromMain
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WidgetInputHandlerHost::SetPanAction_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x65997e2e;  // IPCStableHash for blink::mojom::WidgetInputHandlerHost::SetPanAction
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WidgetInputHandlerHost::DidOverscroll_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2257af40;  // IPCStableHash for blink::mojom::WidgetInputHandlerHost::DidOverscroll
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WidgetInputHandlerHost::DidStartScrollingViewport_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x92005928;  // IPCStableHash for blink::mojom::WidgetInputHandlerHost::DidStartScrollingViewport
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WidgetInputHandlerHost::ImeCancelComposition_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbb2ca32e;  // IPCStableHash for blink::mojom::WidgetInputHandlerHost::ImeCancelComposition
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WidgetInputHandlerHost::ImeCompositionRangeChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xffffbf60;  // IPCStableHash for blink::mojom::WidgetInputHandlerHost::ImeCompositionRangeChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WidgetInputHandlerHost::SetMouseCapture_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1d4d361a;  // IPCStableHash for blink::mojom::WidgetInputHandlerHost::SetMouseCapture
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WidgetInputHandlerHost::SetAutoscrollSelectionActiveInMainFrame_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7431b145;  // IPCStableHash for blink::mojom::WidgetInputHandlerHost::SetAutoscrollSelectionActiveInMainFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WidgetInputHandlerHost::RequestMouseLock_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x91327ce8;  // IPCStableHash for blink::mojom::WidgetInputHandlerHost::RequestMouseLock
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class WidgetInputHandlerHost_RequestMouseLock_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WidgetInputHandlerHost_RequestMouseLock_ForwardToCallback(
      WidgetInputHandlerHost::RequestMouseLockCallback callback
      ) : callback_(std::move(callback)) {
  }

  WidgetInputHandlerHost_RequestMouseLock_ForwardToCallback(const WidgetInputHandlerHost_RequestMouseLock_ForwardToCallback&) = delete;
  WidgetInputHandlerHost_RequestMouseLock_ForwardToCallback& operator=(const WidgetInputHandlerHost_RequestMouseLock_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WidgetInputHandlerHost::RequestMouseLockCallback callback_;
};

WidgetInputHandlerHostProxy::WidgetInputHandlerHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WidgetInputHandlerHostProxy::SetTouchActionFromMain(
    ::cc::TouchAction in_touch_action) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WidgetInputHandlerHost::SetTouchActionFromMain", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("touch_action"), in_touch_action,
                        "<value of type ::cc::TouchAction>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WidgetInputHandlerHost::kSetTouchActionFromMain), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandlerHost_SetTouchActionFromMain_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::cc::mojom::TouchAction>(
    in_touch_action,
    &params->touch_action);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandlerHost::Name_);
  message.set_method_name("SetTouchActionFromMain");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WidgetInputHandlerHostProxy::SetPanAction(
    PanAction in_pan_action) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WidgetInputHandlerHost::SetPanAction", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pan_action"), in_pan_action,
                        "<value of type PanAction>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WidgetInputHandlerHost::kSetPanAction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandlerHost_SetPanAction_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::PanAction>(
    in_pan_action,
    &params->pan_action);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandlerHost::Name_);
  message.set_method_name("SetPanAction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WidgetInputHandlerHostProxy::DidOverscroll(
    DidOverscrollParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WidgetInputHandlerHost::DidOverscroll", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type DidOverscrollParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WidgetInputHandlerHost::kDidOverscroll), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandlerHost_DidOverscroll_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::DidOverscrollParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in WidgetInputHandlerHost.DidOverscroll request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandlerHost::Name_);
  message.set_method_name("DidOverscroll");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WidgetInputHandlerHostProxy::DidStartScrollingViewport(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::WidgetInputHandlerHost::DidStartScrollingViewport");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WidgetInputHandlerHost::kDidStartScrollingViewport), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandlerHost_DidStartScrollingViewport_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandlerHost::Name_);
  message.set_method_name("DidStartScrollingViewport");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WidgetInputHandlerHostProxy::ImeCancelComposition(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::WidgetInputHandlerHost::ImeCancelComposition");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WidgetInputHandlerHost::kImeCancelComposition), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandlerHost_ImeCancelComposition_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandlerHost::Name_);
  message.set_method_name("ImeCancelComposition");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WidgetInputHandlerHostProxy::ImeCompositionRangeChanged(
    const ::gfx::Range& in_range, const std::optional<::blink::Vector<::gfx::Rect>>& in_character_bounds) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WidgetInputHandlerHost::ImeCompositionRangeChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("range"), in_range,
                        "<value of type const ::gfx::Range&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("character_bounds"), in_character_bounds,
                        "<value of type const std::optional<::blink::Vector<::gfx::Rect>>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WidgetInputHandlerHost::kImeCompositionRangeChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandlerHost_ImeCompositionRangeChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->range)::BaseType> range_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RangeDataView>(
    in_range,
    range_fragment);

  params->range.Set(
      range_fragment.is_null() ? nullptr : range_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->range.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null range in WidgetInputHandlerHost.ImeCompositionRangeChanged request");
  mojo::internal::MessageFragment<
      typename decltype(params->character_bounds)::BaseType>
      character_bounds_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& character_bounds_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::RectDataView>>(
    in_character_bounds,
    character_bounds_fragment,
    &character_bounds_validate_params);

  params->character_bounds.Set(
      character_bounds_fragment.is_null() ? nullptr : character_bounds_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandlerHost::Name_);
  message.set_method_name("ImeCompositionRangeChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WidgetInputHandlerHostProxy::SetMouseCapture(
    bool in_capture) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WidgetInputHandlerHost::SetMouseCapture", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("capture"), in_capture,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WidgetInputHandlerHost::kSetMouseCapture), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandlerHost_SetMouseCapture_Params_Data> params(
          message);
  params.Allocate();

  params->capture = in_capture;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandlerHost::Name_);
  message.set_method_name("SetMouseCapture");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WidgetInputHandlerHostProxy::SetAutoscrollSelectionActiveInMainFrame(
    bool in_autoscroll_selection) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WidgetInputHandlerHost::SetAutoscrollSelectionActiveInMainFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("autoscroll_selection"), in_autoscroll_selection,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WidgetInputHandlerHost::kSetAutoscrollSelectionActiveInMainFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_Params_Data> params(
          message);
  params.Allocate();

  params->autoscroll_selection = in_autoscroll_selection;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandlerHost::Name_);
  message.set_method_name("SetAutoscrollSelectionActiveInMainFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WidgetInputHandlerHostProxy::RequestMouseLock(
    bool in_from_user_gesture, bool in_unadjusted_movement, RequestMouseLockCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WidgetInputHandlerHost::RequestMouseLock", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("from_user_gesture"), in_from_user_gesture,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("unadjusted_movement"), in_unadjusted_movement,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WidgetInputHandlerHost::kRequestMouseLock), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandlerHost_RequestMouseLock_Params_Data> params(
          message);
  params.Allocate();

  params->from_user_gesture = in_from_user_gesture;

  params->unadjusted_movement = in_unadjusted_movement;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandlerHost::Name_);
  message.set_method_name("RequestMouseLock");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WidgetInputHandlerHost_RequestMouseLock_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class WidgetInputHandlerHost_RequestMouseLock_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WidgetInputHandlerHost::RequestMouseLockCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WidgetInputHandlerHost_RequestMouseLock_ProxyToResponder> proxy(
        new WidgetInputHandlerHost_RequestMouseLock_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WidgetInputHandlerHost_RequestMouseLock_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WidgetInputHandlerHost_RequestMouseLock_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WidgetInputHandlerHost_RequestMouseLock_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WidgetInputHandlerHost::RequestMouseLockCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::PointerLockResult in_result, ::mojo::PendingRemote<::blink::mojom::blink::PointerLockContext> in_context);
};

bool WidgetInputHandlerHost_RequestMouseLock_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WidgetInputHandlerHost_RequestMouseLock_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WidgetInputHandlerHost_RequestMouseLock_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WidgetInputHandlerHost.8
  bool success = true;
  ::blink::mojom::blink::PointerLockResult p_result{};
  ::mojo::PendingRemote<::blink::mojom::blink::PointerLockContext> p_context{};
  WidgetInputHandlerHost_RequestMouseLock_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success) {
    p_context =
        input_data_view.TakeContext<decltype(p_context)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WidgetInputHandlerHost::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_context));
  }
  return true;
}

void WidgetInputHandlerHost_RequestMouseLock_ProxyToResponder::Run(
    ::blink::mojom::blink::PointerLockResult in_result, ::mojo::PendingRemote<::blink::mojom::blink::PointerLockContext> in_context) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::WidgetInputHandlerHost::RequestMouseLock", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::blink::PointerLockResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("context"), in_context,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::blink::PointerLockContext>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WidgetInputHandlerHost::kRequestMouseLock), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandlerHost_RequestMouseLock_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::PointerLockResult>(
    in_result,
    &params->result);

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::PointerLockContextInterfaceBase>>(
    in_context,
    &params->context,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandlerHost::Name_);
  message.set_method_name("RequestMouseLock");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WidgetInputHandlerHostStubDispatch::Accept(
    WidgetInputHandlerHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WidgetInputHandlerHost>(message->header()->name)) {
    case messages::WidgetInputHandlerHost::kSetTouchActionFromMain: {
      DCHECK(message->is_serialized());
      internal::WidgetInputHandlerHost_SetTouchActionFromMain_Params_Data* params =
          reinterpret_cast<internal::WidgetInputHandlerHost_SetTouchActionFromMain_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WidgetInputHandlerHost.0
      bool success = true;
      ::cc::TouchAction p_touch_action{};
      WidgetInputHandlerHost_SetTouchActionFromMain_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTouchAction(&p_touch_action))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandlerHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTouchActionFromMain(        
        std::move(p_touch_action));
      return true;
    }
    case messages::WidgetInputHandlerHost::kSetPanAction: {
      DCHECK(message->is_serialized());
      internal::WidgetInputHandlerHost_SetPanAction_Params_Data* params =
          reinterpret_cast<internal::WidgetInputHandlerHost_SetPanAction_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WidgetInputHandlerHost.1
      bool success = true;
      PanAction p_pan_action{};
      WidgetInputHandlerHost_SetPanAction_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPanAction(&p_pan_action))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandlerHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPanAction(        
        std::move(p_pan_action));
      return true;
    }
    case messages::WidgetInputHandlerHost::kDidOverscroll: {
      DCHECK(message->is_serialized());
      internal::WidgetInputHandlerHost_DidOverscroll_Params_Data* params =
          reinterpret_cast<internal::WidgetInputHandlerHost_DidOverscroll_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WidgetInputHandlerHost.2
      bool success = true;
      DidOverscrollParamsPtr p_params{};
      WidgetInputHandlerHost_DidOverscroll_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandlerHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidOverscroll(        
        std::move(p_params));
      return true;
    }
    case messages::WidgetInputHandlerHost::kDidStartScrollingViewport: {
      DCHECK(message->is_serialized());
      internal::WidgetInputHandlerHost_DidStartScrollingViewport_Params_Data* params =
          reinterpret_cast<internal::WidgetInputHandlerHost_DidStartScrollingViewport_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WidgetInputHandlerHost.3
      bool success = true;
      WidgetInputHandlerHost_DidStartScrollingViewport_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandlerHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidStartScrollingViewport(        );
      return true;
    }
    case messages::WidgetInputHandlerHost::kImeCancelComposition: {
      DCHECK(message->is_serialized());
      internal::WidgetInputHandlerHost_ImeCancelComposition_Params_Data* params =
          reinterpret_cast<internal::WidgetInputHandlerHost_ImeCancelComposition_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WidgetInputHandlerHost.4
      bool success = true;
      WidgetInputHandlerHost_ImeCancelComposition_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandlerHost::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ImeCancelComposition(        );
      return true;
    }
    case messages::WidgetInputHandlerHost::kImeCompositionRangeChanged: {
      DCHECK(message->is_serialized());
      internal::WidgetInputHandlerHost_ImeCompositionRangeChanged_Params_Data* params =
          reinterpret_cast<internal::WidgetInputHandlerHost_ImeCompositionRangeChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WidgetInputHandlerHost.5
      bool success = true;
      ::gfx::Range p_range{};
      std::optional<::blink::Vector<::gfx::Rect>> p_character_bounds{};
      WidgetInputHandlerHost_ImeCompositionRangeChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRange(&p_range))
        success = false;
      if (success && !input_data_view.ReadCharacterBounds(&p_character_bounds))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandlerHost::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ImeCompositionRangeChanged(        
        std::move(p_range), 
        std::move(p_character_bounds));
      return true;
    }
    case messages::WidgetInputHandlerHost::kSetMouseCapture: {
      DCHECK(message->is_serialized());
      internal::WidgetInputHandlerHost_SetMouseCapture_Params_Data* params =
          reinterpret_cast<internal::WidgetInputHandlerHost_SetMouseCapture_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WidgetInputHandlerHost.6
      bool success = true;
      bool p_capture{};
      WidgetInputHandlerHost_SetMouseCapture_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_capture = input_data_view.capture();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandlerHost::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetMouseCapture(        
        std::move(p_capture));
      return true;
    }
    case messages::WidgetInputHandlerHost::kSetAutoscrollSelectionActiveInMainFrame: {
      DCHECK(message->is_serialized());
      internal::WidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_Params_Data* params =
          reinterpret_cast<internal::WidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WidgetInputHandlerHost.7
      bool success = true;
      bool p_autoscroll_selection{};
      WidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_autoscroll_selection = input_data_view.autoscroll_selection();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandlerHost::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetAutoscrollSelectionActiveInMainFrame(        
        std::move(p_autoscroll_selection));
      return true;
    }
    case messages::WidgetInputHandlerHost::kRequestMouseLock: {
      break;
    }
  }
  return false;
}

// static
bool WidgetInputHandlerHostStubDispatch::AcceptWithResponder(
    WidgetInputHandlerHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WidgetInputHandlerHost>(message->header()->name)) {
    case messages::WidgetInputHandlerHost::kSetTouchActionFromMain: {
      break;
    }
    case messages::WidgetInputHandlerHost::kSetPanAction: {
      break;
    }
    case messages::WidgetInputHandlerHost::kDidOverscroll: {
      break;
    }
    case messages::WidgetInputHandlerHost::kDidStartScrollingViewport: {
      break;
    }
    case messages::WidgetInputHandlerHost::kImeCancelComposition: {
      break;
    }
    case messages::WidgetInputHandlerHost::kImeCompositionRangeChanged: {
      break;
    }
    case messages::WidgetInputHandlerHost::kSetMouseCapture: {
      break;
    }
    case messages::WidgetInputHandlerHost::kSetAutoscrollSelectionActiveInMainFrame: {
      break;
    }
    case messages::WidgetInputHandlerHost::kRequestMouseLock: {
      internal::WidgetInputHandlerHost_RequestMouseLock_Params_Data* params =
          reinterpret_cast<
              internal::WidgetInputHandlerHost_RequestMouseLock_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WidgetInputHandlerHost.8
      bool success = true;
      bool p_from_user_gesture{};
      bool p_unadjusted_movement{};
      WidgetInputHandlerHost_RequestMouseLock_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_from_user_gesture = input_data_view.from_user_gesture();
      if (success)
        p_unadjusted_movement = input_data_view.unadjusted_movement();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandlerHost::Name_, 8, false);
        return false;
      }
      auto callback =
          WidgetInputHandlerHost_RequestMouseLock_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestMouseLock(        
        std::move(p_from_user_gesture), 
        std::move(p_unadjusted_movement), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWidgetInputHandlerHostValidationInfo[] = {
    { &internal::WidgetInputHandlerHost_SetTouchActionFromMain_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WidgetInputHandlerHost_SetPanAction_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WidgetInputHandlerHost_DidOverscroll_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WidgetInputHandlerHost_DidStartScrollingViewport_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WidgetInputHandlerHost_ImeCancelComposition_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WidgetInputHandlerHost_ImeCompositionRangeChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WidgetInputHandlerHost_SetMouseCapture_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WidgetInputHandlerHost_SetAutoscrollSelectionActiveInMainFrame_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WidgetInputHandlerHost_RequestMouseLock_Params_Data::Validate,
     &internal::WidgetInputHandlerHost_RequestMouseLock_ResponseParams_Data::Validate},
};

bool WidgetInputHandlerHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::WidgetInputHandlerHost::Name_,
    kWidgetInputHandlerHostValidationInfo);
}

bool WidgetInputHandlerHostResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::WidgetInputHandlerHost::Name_,
    kWidgetInputHandlerHostValidationInfo);
}
// The declaration includes the definition on other builds.

FrameWidgetInputHandler::IPCStableHashFunction FrameWidgetInputHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FrameWidgetInputHandler>(message.name())) {
    case messages::FrameWidgetInputHandler::kAddImeTextSpansToExistingText: {
      return &FrameWidgetInputHandler::AddImeTextSpansToExistingText_Sym::IPCStableHash;
    }
    case messages::FrameWidgetInputHandler::kClearImeTextSpansByType: {
      return &FrameWidgetInputHandler::ClearImeTextSpansByType_Sym::IPCStableHash;
    }
    case messages::FrameWidgetInputHandler::kSetCompositionFromExistingText: {
      return &FrameWidgetInputHandler::SetCompositionFromExistingText_Sym::IPCStableHash;
    }
    case messages::FrameWidgetInputHandler::kExtendSelectionAndDelete: {
      return &FrameWidgetInputHandler::ExtendSelectionAndDelete_Sym::IPCStableHash;
    }
    case messages::FrameWidgetInputHandler::kExtendSelectionAndReplace: {
      return &FrameWidgetInputHandler::ExtendSelectionAndReplace_Sym::IPCStableHash;
    }
    case messages::FrameWidgetInputHandler::kDeleteSurroundingText: {
      return &FrameWidgetInputHandler::DeleteSurroundingText_Sym::IPCStableHash;
    }
    case messages::FrameWidgetInputHandler::kDeleteSurroundingTextInCodePoints: {
      return &FrameWidgetInputHandler::DeleteSurroundingTextInCodePoints_Sym::IPCStableHash;
    }
    case messages::FrameWidgetInputHandler::kSetEditableSelectionOffsets: {
      return &FrameWidgetInputHandler::SetEditableSelectionOffsets_Sym::IPCStableHash;
    }
    case messages::FrameWidgetInputHandler::kHandleStylusWritingGestureAction: {
      return &FrameWidgetInputHandler::HandleStylusWritingGestureAction_Sym::IPCStableHash;
    }
    case messages::FrameWidgetInputHandler::kExecuteEditCommand: {
      return &FrameWidgetInputHandler::ExecuteEditCommand_Sym::IPCStableHash;
    }
    case messages::FrameWidgetInputHandler::kUndo: {
      return &FrameWidgetInputHandler::Undo_Sym::IPCStableHash;
    }
    case messages::FrameWidgetInputHandler::kRedo: {
      return &FrameWidgetInputHandler::Redo_Sym::IPCStableHash;
    }
    case messages::FrameWidgetInputHandler::kCut: {
      return &FrameWidgetInputHandler::Cut_Sym::IPCStableHash;
    }
    case messages::FrameWidgetInputHandler::kCopy: {
      return &FrameWidgetInputHandler::Copy_Sym::IPCStableHash;
    }
    case messages::FrameWidgetInputHandler::kCopyToFindPboard: {
      return &FrameWidgetInputHandler::CopyToFindPboard_Sym::IPCStableHash;
    }
    case messages::FrameWidgetInputHandler::kCenterSelection: {
      return &FrameWidgetInputHandler::CenterSelection_Sym::IPCStableHash;
    }
    case messages::FrameWidgetInputHandler::kPaste: {
      return &FrameWidgetInputHandler::Paste_Sym::IPCStableHash;
    }
    case messages::FrameWidgetInputHandler::kPasteAndMatchStyle: {
      return &FrameWidgetInputHandler::PasteAndMatchStyle_Sym::IPCStableHash;
    }
    case messages::FrameWidgetInputHandler::kDelete: {
      return &FrameWidgetInputHandler::Delete_Sym::IPCStableHash;
    }
    case messages::FrameWidgetInputHandler::kSelectAll: {
      return &FrameWidgetInputHandler::SelectAll_Sym::IPCStableHash;
    }
    case messages::FrameWidgetInputHandler::kCollapseSelection: {
      return &FrameWidgetInputHandler::CollapseSelection_Sym::IPCStableHash;
    }
    case messages::FrameWidgetInputHandler::kCopyWithConfirmation: {
      return &FrameWidgetInputHandler::CopyWithConfirmation_Sym::IPCStableHash;
    }
    case messages::FrameWidgetInputHandler::kPasteWithConfirmation: {
      return &FrameWidgetInputHandler::PasteWithConfirmation_Sym::IPCStableHash;
    }
    case messages::FrameWidgetInputHandler::kReplace: {
      return &FrameWidgetInputHandler::Replace_Sym::IPCStableHash;
    }
    case messages::FrameWidgetInputHandler::kReplaceMisspelling: {
      return &FrameWidgetInputHandler::ReplaceMisspelling_Sym::IPCStableHash;
    }
    case messages::FrameWidgetInputHandler::kSelectRange: {
      return &FrameWidgetInputHandler::SelectRange_Sym::IPCStableHash;
    }
    case messages::FrameWidgetInputHandler::kAdjustSelectionByCharacterOffset: {
      return &FrameWidgetInputHandler::AdjustSelectionByCharacterOffset_Sym::IPCStableHash;
    }
    case messages::FrameWidgetInputHandler::kSelectAroundCaret: {
      return &FrameWidgetInputHandler::SelectAroundCaret_Sym::IPCStableHash;
    }
    case messages::FrameWidgetInputHandler::kMoveRangeSelectionExtent: {
      return &FrameWidgetInputHandler::MoveRangeSelectionExtent_Sym::IPCStableHash;
    }
    case messages::FrameWidgetInputHandler::kScrollFocusedEditableNodeIntoView: {
      return &FrameWidgetInputHandler::ScrollFocusedEditableNodeIntoView_Sym::IPCStableHash;
    }
    case messages::FrameWidgetInputHandler::kWaitForPageScaleAnimationForTesting: {
      return &FrameWidgetInputHandler::WaitForPageScaleAnimationForTesting_Sym::IPCStableHash;
    }
    case messages::FrameWidgetInputHandler::kMoveCaret: {
      return &FrameWidgetInputHandler::MoveCaret_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FrameWidgetInputHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FrameWidgetInputHandler>(message.name())) {
      case messages::FrameWidgetInputHandler::kAddImeTextSpansToExistingText:
            return "Receive blink::mojom::FrameWidgetInputHandler::AddImeTextSpansToExistingText";
      case messages::FrameWidgetInputHandler::kClearImeTextSpansByType:
            return "Receive blink::mojom::FrameWidgetInputHandler::ClearImeTextSpansByType";
      case messages::FrameWidgetInputHandler::kSetCompositionFromExistingText:
            return "Receive blink::mojom::FrameWidgetInputHandler::SetCompositionFromExistingText";
      case messages::FrameWidgetInputHandler::kExtendSelectionAndDelete:
            return "Receive blink::mojom::FrameWidgetInputHandler::ExtendSelectionAndDelete";
      case messages::FrameWidgetInputHandler::kExtendSelectionAndReplace:
            return "Receive blink::mojom::FrameWidgetInputHandler::ExtendSelectionAndReplace";
      case messages::FrameWidgetInputHandler::kDeleteSurroundingText:
            return "Receive blink::mojom::FrameWidgetInputHandler::DeleteSurroundingText";
      case messages::FrameWidgetInputHandler::kDeleteSurroundingTextInCodePoints:
            return "Receive blink::mojom::FrameWidgetInputHandler::DeleteSurroundingTextInCodePoints";
      case messages::FrameWidgetInputHandler::kSetEditableSelectionOffsets:
            return "Receive blink::mojom::FrameWidgetInputHandler::SetEditableSelectionOffsets";
      case messages::FrameWidgetInputHandler::kHandleStylusWritingGestureAction:
            return "Receive blink::mojom::FrameWidgetInputHandler::HandleStylusWritingGestureAction";
      case messages::FrameWidgetInputHandler::kExecuteEditCommand:
            return "Receive blink::mojom::FrameWidgetInputHandler::ExecuteEditCommand";
      case messages::FrameWidgetInputHandler::kUndo:
            return "Receive blink::mojom::FrameWidgetInputHandler::Undo";
      case messages::FrameWidgetInputHandler::kRedo:
            return "Receive blink::mojom::FrameWidgetInputHandler::Redo";
      case messages::FrameWidgetInputHandler::kCut:
            return "Receive blink::mojom::FrameWidgetInputHandler::Cut";
      case messages::FrameWidgetInputHandler::kCopy:
            return "Receive blink::mojom::FrameWidgetInputHandler::Copy";
      case messages::FrameWidgetInputHandler::kCopyToFindPboard:
            return "Receive blink::mojom::FrameWidgetInputHandler::CopyToFindPboard";
      case messages::FrameWidgetInputHandler::kCenterSelection:
            return "Receive blink::mojom::FrameWidgetInputHandler::CenterSelection";
      case messages::FrameWidgetInputHandler::kPaste:
            return "Receive blink::mojom::FrameWidgetInputHandler::Paste";
      case messages::FrameWidgetInputHandler::kPasteAndMatchStyle:
            return "Receive blink::mojom::FrameWidgetInputHandler::PasteAndMatchStyle";
      case messages::FrameWidgetInputHandler::kDelete:
            return "Receive blink::mojom::FrameWidgetInputHandler::Delete";
      case messages::FrameWidgetInputHandler::kSelectAll:
            return "Receive blink::mojom::FrameWidgetInputHandler::SelectAll";
      case messages::FrameWidgetInputHandler::kCollapseSelection:
            return "Receive blink::mojom::FrameWidgetInputHandler::CollapseSelection";
      case messages::FrameWidgetInputHandler::kCopyWithConfirmation:
            return "Receive blink::mojom::FrameWidgetInputHandler::CopyWithConfirmation";
      case messages::FrameWidgetInputHandler::kPasteWithConfirmation:
            return "Receive blink::mojom::FrameWidgetInputHandler::PasteWithConfirmation";
      case messages::FrameWidgetInputHandler::kReplace:
            return "Receive blink::mojom::FrameWidgetInputHandler::Replace";
      case messages::FrameWidgetInputHandler::kReplaceMisspelling:
            return "Receive blink::mojom::FrameWidgetInputHandler::ReplaceMisspelling";
      case messages::FrameWidgetInputHandler::kSelectRange:
            return "Receive blink::mojom::FrameWidgetInputHandler::SelectRange";
      case messages::FrameWidgetInputHandler::kAdjustSelectionByCharacterOffset:
            return "Receive blink::mojom::FrameWidgetInputHandler::AdjustSelectionByCharacterOffset";
      case messages::FrameWidgetInputHandler::kSelectAroundCaret:
            return "Receive blink::mojom::FrameWidgetInputHandler::SelectAroundCaret";
      case messages::FrameWidgetInputHandler::kMoveRangeSelectionExtent:
            return "Receive blink::mojom::FrameWidgetInputHandler::MoveRangeSelectionExtent";
      case messages::FrameWidgetInputHandler::kScrollFocusedEditableNodeIntoView:
            return "Receive blink::mojom::FrameWidgetInputHandler::ScrollFocusedEditableNodeIntoView";
      case messages::FrameWidgetInputHandler::kWaitForPageScaleAnimationForTesting:
            return "Receive blink::mojom::FrameWidgetInputHandler::WaitForPageScaleAnimationForTesting";
      case messages::FrameWidgetInputHandler::kMoveCaret:
            return "Receive blink::mojom::FrameWidgetInputHandler::MoveCaret";
    }
  } else {
    switch (static_cast<messages::FrameWidgetInputHandler>(message.name())) {
      case messages::FrameWidgetInputHandler::kAddImeTextSpansToExistingText:
            return "Receive reply blink::mojom::FrameWidgetInputHandler::AddImeTextSpansToExistingText";
      case messages::FrameWidgetInputHandler::kClearImeTextSpansByType:
            return "Receive reply blink::mojom::FrameWidgetInputHandler::ClearImeTextSpansByType";
      case messages::FrameWidgetInputHandler::kSetCompositionFromExistingText:
            return "Receive reply blink::mojom::FrameWidgetInputHandler::SetCompositionFromExistingText";
      case messages::FrameWidgetInputHandler::kExtendSelectionAndDelete:
            return "Receive reply blink::mojom::FrameWidgetInputHandler::ExtendSelectionAndDelete";
      case messages::FrameWidgetInputHandler::kExtendSelectionAndReplace:
            return "Receive reply blink::mojom::FrameWidgetInputHandler::ExtendSelectionAndReplace";
      case messages::FrameWidgetInputHandler::kDeleteSurroundingText:
            return "Receive reply blink::mojom::FrameWidgetInputHandler::DeleteSurroundingText";
      case messages::FrameWidgetInputHandler::kDeleteSurroundingTextInCodePoints:
            return "Receive reply blink::mojom::FrameWidgetInputHandler::DeleteSurroundingTextInCodePoints";
      case messages::FrameWidgetInputHandler::kSetEditableSelectionOffsets:
            return "Receive reply blink::mojom::FrameWidgetInputHandler::SetEditableSelectionOffsets";
      case messages::FrameWidgetInputHandler::kHandleStylusWritingGestureAction:
            return "Receive reply blink::mojom::FrameWidgetInputHandler::HandleStylusWritingGestureAction";
      case messages::FrameWidgetInputHandler::kExecuteEditCommand:
            return "Receive reply blink::mojom::FrameWidgetInputHandler::ExecuteEditCommand";
      case messages::FrameWidgetInputHandler::kUndo:
            return "Receive reply blink::mojom::FrameWidgetInputHandler::Undo";
      case messages::FrameWidgetInputHandler::kRedo:
            return "Receive reply blink::mojom::FrameWidgetInputHandler::Redo";
      case messages::FrameWidgetInputHandler::kCut:
            return "Receive reply blink::mojom::FrameWidgetInputHandler::Cut";
      case messages::FrameWidgetInputHandler::kCopy:
            return "Receive reply blink::mojom::FrameWidgetInputHandler::Copy";
      case messages::FrameWidgetInputHandler::kCopyToFindPboard:
            return "Receive reply blink::mojom::FrameWidgetInputHandler::CopyToFindPboard";
      case messages::FrameWidgetInputHandler::kCenterSelection:
            return "Receive reply blink::mojom::FrameWidgetInputHandler::CenterSelection";
      case messages::FrameWidgetInputHandler::kPaste:
            return "Receive reply blink::mojom::FrameWidgetInputHandler::Paste";
      case messages::FrameWidgetInputHandler::kPasteAndMatchStyle:
            return "Receive reply blink::mojom::FrameWidgetInputHandler::PasteAndMatchStyle";
      case messages::FrameWidgetInputHandler::kDelete:
            return "Receive reply blink::mojom::FrameWidgetInputHandler::Delete";
      case messages::FrameWidgetInputHandler::kSelectAll:
            return "Receive reply blink::mojom::FrameWidgetInputHandler::SelectAll";
      case messages::FrameWidgetInputHandler::kCollapseSelection:
            return "Receive reply blink::mojom::FrameWidgetInputHandler::CollapseSelection";
      case messages::FrameWidgetInputHandler::kCopyWithConfirmation:
            return "Receive reply blink::mojom::FrameWidgetInputHandler::CopyWithConfirmation";
      case messages::FrameWidgetInputHandler::kPasteWithConfirmation:
            return "Receive reply blink::mojom::FrameWidgetInputHandler::PasteWithConfirmation";
      case messages::FrameWidgetInputHandler::kReplace:
            return "Receive reply blink::mojom::FrameWidgetInputHandler::Replace";
      case messages::FrameWidgetInputHandler::kReplaceMisspelling:
            return "Receive reply blink::mojom::FrameWidgetInputHandler::ReplaceMisspelling";
      case messages::FrameWidgetInputHandler::kSelectRange:
            return "Receive reply blink::mojom::FrameWidgetInputHandler::SelectRange";
      case messages::FrameWidgetInputHandler::kAdjustSelectionByCharacterOffset:
            return "Receive reply blink::mojom::FrameWidgetInputHandler::AdjustSelectionByCharacterOffset";
      case messages::FrameWidgetInputHandler::kSelectAroundCaret:
            return "Receive reply blink::mojom::FrameWidgetInputHandler::SelectAroundCaret";
      case messages::FrameWidgetInputHandler::kMoveRangeSelectionExtent:
            return "Receive reply blink::mojom::FrameWidgetInputHandler::MoveRangeSelectionExtent";
      case messages::FrameWidgetInputHandler::kScrollFocusedEditableNodeIntoView:
            return "Receive reply blink::mojom::FrameWidgetInputHandler::ScrollFocusedEditableNodeIntoView";
      case messages::FrameWidgetInputHandler::kWaitForPageScaleAnimationForTesting:
            return "Receive reply blink::mojom::FrameWidgetInputHandler::WaitForPageScaleAnimationForTesting";
      case messages::FrameWidgetInputHandler::kMoveCaret:
            return "Receive reply blink::mojom::FrameWidgetInputHandler::MoveCaret";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FrameWidgetInputHandler::AddImeTextSpansToExistingText_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd1555538;  // IPCStableHash for blink::mojom::FrameWidgetInputHandler::AddImeTextSpansToExistingText
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidgetInputHandler::ClearImeTextSpansByType_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5aa284ee;  // IPCStableHash for blink::mojom::FrameWidgetInputHandler::ClearImeTextSpansByType
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidgetInputHandler::SetCompositionFromExistingText_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc8bd9f65;  // IPCStableHash for blink::mojom::FrameWidgetInputHandler::SetCompositionFromExistingText
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidgetInputHandler::ExtendSelectionAndDelete_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf662d6b3;  // IPCStableHash for blink::mojom::FrameWidgetInputHandler::ExtendSelectionAndDelete
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidgetInputHandler::ExtendSelectionAndReplace_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xacca4ed1;  // IPCStableHash for blink::mojom::FrameWidgetInputHandler::ExtendSelectionAndReplace
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidgetInputHandler::DeleteSurroundingText_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc79b59e8;  // IPCStableHash for blink::mojom::FrameWidgetInputHandler::DeleteSurroundingText
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidgetInputHandler::DeleteSurroundingTextInCodePoints_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfc2e93a4;  // IPCStableHash for blink::mojom::FrameWidgetInputHandler::DeleteSurroundingTextInCodePoints
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidgetInputHandler::SetEditableSelectionOffsets_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb3ecf440;  // IPCStableHash for blink::mojom::FrameWidgetInputHandler::SetEditableSelectionOffsets
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidgetInputHandler::HandleStylusWritingGestureAction_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x09bdac61;  // IPCStableHash for blink::mojom::FrameWidgetInputHandler::HandleStylusWritingGestureAction
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidgetInputHandler::ExecuteEditCommand_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf3b29faa;  // IPCStableHash for blink::mojom::FrameWidgetInputHandler::ExecuteEditCommand
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidgetInputHandler::Undo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x16136c6d;  // IPCStableHash for blink::mojom::FrameWidgetInputHandler::Undo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidgetInputHandler::Redo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6565f416;  // IPCStableHash for blink::mojom::FrameWidgetInputHandler::Redo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidgetInputHandler::Cut_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd07ac35f;  // IPCStableHash for blink::mojom::FrameWidgetInputHandler::Cut
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidgetInputHandler::Copy_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc82265a5;  // IPCStableHash for blink::mojom::FrameWidgetInputHandler::Copy
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidgetInputHandler::CopyToFindPboard_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5d53d93c;  // IPCStableHash for blink::mojom::FrameWidgetInputHandler::CopyToFindPboard
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidgetInputHandler::CenterSelection_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1ea189fc;  // IPCStableHash for blink::mojom::FrameWidgetInputHandler::CenterSelection
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidgetInputHandler::Paste_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3e3cfb19;  // IPCStableHash for blink::mojom::FrameWidgetInputHandler::Paste
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidgetInputHandler::PasteAndMatchStyle_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x71d20fd0;  // IPCStableHash for blink::mojom::FrameWidgetInputHandler::PasteAndMatchStyle
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidgetInputHandler::Delete_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5e6b2621;  // IPCStableHash for blink::mojom::FrameWidgetInputHandler::Delete
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidgetInputHandler::SelectAll_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8eae5651;  // IPCStableHash for blink::mojom::FrameWidgetInputHandler::SelectAll
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidgetInputHandler::CollapseSelection_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf4f92310;  // IPCStableHash for blink::mojom::FrameWidgetInputHandler::CollapseSelection
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidgetInputHandler::CopyWithConfirmation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcb31cfb2;  // IPCStableHash for blink::mojom::FrameWidgetInputHandler::CopyWithConfirmation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidgetInputHandler::PasteWithConfirmation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe90ce2a5;  // IPCStableHash for blink::mojom::FrameWidgetInputHandler::PasteWithConfirmation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidgetInputHandler::Replace_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x31764258;  // IPCStableHash for blink::mojom::FrameWidgetInputHandler::Replace
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidgetInputHandler::ReplaceMisspelling_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf5465c99;  // IPCStableHash for blink::mojom::FrameWidgetInputHandler::ReplaceMisspelling
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidgetInputHandler::SelectRange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe684e84f;  // IPCStableHash for blink::mojom::FrameWidgetInputHandler::SelectRange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidgetInputHandler::AdjustSelectionByCharacterOffset_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x197b83e6;  // IPCStableHash for blink::mojom::FrameWidgetInputHandler::AdjustSelectionByCharacterOffset
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidgetInputHandler::SelectAroundCaret_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x30bcdaa4;  // IPCStableHash for blink::mojom::FrameWidgetInputHandler::SelectAroundCaret
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidgetInputHandler::MoveRangeSelectionExtent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x95f77180;  // IPCStableHash for blink::mojom::FrameWidgetInputHandler::MoveRangeSelectionExtent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidgetInputHandler::ScrollFocusedEditableNodeIntoView_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x47d34021;  // IPCStableHash for blink::mojom::FrameWidgetInputHandler::ScrollFocusedEditableNodeIntoView
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidgetInputHandler::WaitForPageScaleAnimationForTesting_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x408349cb;  // IPCStableHash for blink::mojom::FrameWidgetInputHandler::WaitForPageScaleAnimationForTesting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameWidgetInputHandler::MoveCaret_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x64a4b52f;  // IPCStableHash for blink::mojom::FrameWidgetInputHandler::MoveCaret
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class FrameWidgetInputHandler_HandleStylusWritingGestureAction_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FrameWidgetInputHandler_HandleStylusWritingGestureAction_ForwardToCallback(
      FrameWidgetInputHandler::HandleStylusWritingGestureActionCallback callback
      ) : callback_(std::move(callback)) {
  }

  FrameWidgetInputHandler_HandleStylusWritingGestureAction_ForwardToCallback(const FrameWidgetInputHandler_HandleStylusWritingGestureAction_ForwardToCallback&) = delete;
  FrameWidgetInputHandler_HandleStylusWritingGestureAction_ForwardToCallback& operator=(const FrameWidgetInputHandler_HandleStylusWritingGestureAction_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FrameWidgetInputHandler::HandleStylusWritingGestureActionCallback callback_;
};

class FrameWidgetInputHandler_CopyWithConfirmation_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FrameWidgetInputHandler_CopyWithConfirmation_ForwardToCallback(
      FrameWidgetInputHandler::CopyWithConfirmationCallback callback
      ) : callback_(std::move(callback)) {
  }

  FrameWidgetInputHandler_CopyWithConfirmation_ForwardToCallback(const FrameWidgetInputHandler_CopyWithConfirmation_ForwardToCallback&) = delete;
  FrameWidgetInputHandler_CopyWithConfirmation_ForwardToCallback& operator=(const FrameWidgetInputHandler_CopyWithConfirmation_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FrameWidgetInputHandler::CopyWithConfirmationCallback callback_;
};

class FrameWidgetInputHandler_PasteWithConfirmation_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FrameWidgetInputHandler_PasteWithConfirmation_ForwardToCallback(
      FrameWidgetInputHandler::PasteWithConfirmationCallback callback
      ) : callback_(std::move(callback)) {
  }

  FrameWidgetInputHandler_PasteWithConfirmation_ForwardToCallback(const FrameWidgetInputHandler_PasteWithConfirmation_ForwardToCallback&) = delete;
  FrameWidgetInputHandler_PasteWithConfirmation_ForwardToCallback& operator=(const FrameWidgetInputHandler_PasteWithConfirmation_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FrameWidgetInputHandler::PasteWithConfirmationCallback callback_;
};

class FrameWidgetInputHandler_SelectAroundCaret_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FrameWidgetInputHandler_SelectAroundCaret_ForwardToCallback(
      FrameWidgetInputHandler::SelectAroundCaretCallback callback
      ) : callback_(std::move(callback)) {
  }

  FrameWidgetInputHandler_SelectAroundCaret_ForwardToCallback(const FrameWidgetInputHandler_SelectAroundCaret_ForwardToCallback&) = delete;
  FrameWidgetInputHandler_SelectAroundCaret_ForwardToCallback& operator=(const FrameWidgetInputHandler_SelectAroundCaret_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FrameWidgetInputHandler::SelectAroundCaretCallback callback_;
};

class FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ForwardToCallback(
      FrameWidgetInputHandler::WaitForPageScaleAnimationForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }

  FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ForwardToCallback(const FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ForwardToCallback&) = delete;
  FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ForwardToCallback& operator=(const FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FrameWidgetInputHandler::WaitForPageScaleAnimationForTestingCallback callback_;
};

FrameWidgetInputHandlerProxy::FrameWidgetInputHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FrameWidgetInputHandlerProxy::AddImeTextSpansToExistingText(
    uint32_t in_start, uint32_t in_end, const ::blink::Vector<::ui::ImeTextSpan>& in_ime_text_spans) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameWidgetInputHandler::AddImeTextSpansToExistingText", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("start"), in_start,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("end"), in_end,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ime_text_spans"), in_ime_text_spans,
                        "<value of type const ::blink::Vector<::ui::ImeTextSpan>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetInputHandler::kAddImeTextSpansToExistingText), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_AddImeTextSpansToExistingText_Params_Data> params(
          message);
  params.Allocate();

  params->start = in_start;

  params->end = in_end;
  mojo::internal::MessageFragment<
      typename decltype(params->ime_text_spans)::BaseType>
      ime_text_spans_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& ime_text_spans_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::ui::mojom::ImeTextSpanDataView>>(
    in_ime_text_spans,
    ime_text_spans_fragment,
    &ime_text_spans_validate_params);

  params->ime_text_spans.Set(
      ime_text_spans_fragment.is_null() ? nullptr : ime_text_spans_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->ime_text_spans.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null ime_text_spans in FrameWidgetInputHandler.AddImeTextSpansToExistingText request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("AddImeTextSpansToExistingText");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetInputHandlerProxy::ClearImeTextSpansByType(
    uint32_t in_start, uint32_t in_end, ::ui::ImeTextSpan::Type in_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameWidgetInputHandler::ClearImeTextSpansByType", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("start"), in_start,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("end"), in_end,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type ::ui::ImeTextSpan::Type>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetInputHandler::kClearImeTextSpansByType), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_ClearImeTextSpansByType_Params_Data> params(
          message);
  params.Allocate();

  params->start = in_start;

  params->end = in_end;

  
  mojo::internal::Serialize<::ui::mojom::ImeTextSpanType>(
    in_type,
    &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("ClearImeTextSpansByType");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetInputHandlerProxy::SetCompositionFromExistingText(
    int32_t in_start, int32_t in_end, const ::blink::Vector<::ui::ImeTextSpan>& in_ime_text_spans) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameWidgetInputHandler::SetCompositionFromExistingText", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("start"), in_start,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("end"), in_end,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ime_text_spans"), in_ime_text_spans,
                        "<value of type const ::blink::Vector<::ui::ImeTextSpan>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetInputHandler::kSetCompositionFromExistingText), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_SetCompositionFromExistingText_Params_Data> params(
          message);
  params.Allocate();

  params->start = in_start;

  params->end = in_end;
  mojo::internal::MessageFragment<
      typename decltype(params->ime_text_spans)::BaseType>
      ime_text_spans_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& ime_text_spans_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::ui::mojom::ImeTextSpanDataView>>(
    in_ime_text_spans,
    ime_text_spans_fragment,
    &ime_text_spans_validate_params);

  params->ime_text_spans.Set(
      ime_text_spans_fragment.is_null() ? nullptr : ime_text_spans_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->ime_text_spans.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null ime_text_spans in FrameWidgetInputHandler.SetCompositionFromExistingText request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("SetCompositionFromExistingText");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetInputHandlerProxy::ExtendSelectionAndDelete(
    int32_t in_before, int32_t in_after) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameWidgetInputHandler::ExtendSelectionAndDelete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("before"), in_before,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("after"), in_after,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetInputHandler::kExtendSelectionAndDelete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_ExtendSelectionAndDelete_Params_Data> params(
          message);
  params.Allocate();

  params->before = in_before;

  params->after = in_after;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("ExtendSelectionAndDelete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetInputHandlerProxy::ExtendSelectionAndReplace(
    uint32_t in_before, uint32_t in_after, const ::blink::String& in_replacement_text) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameWidgetInputHandler::ExtendSelectionAndReplace", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("before"), in_before,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("after"), in_after,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("replacement_text"), in_replacement_text,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetInputHandler::kExtendSelectionAndReplace), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_ExtendSelectionAndReplace_Params_Data> params(
          message);
  params.Allocate();

  params->before = in_before;

  params->after = in_after;
  mojo::internal::MessageFragment<
      typename decltype(params->replacement_text)::BaseType> replacement_text_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_replacement_text,
    replacement_text_fragment);

  params->replacement_text.Set(
      replacement_text_fragment.is_null() ? nullptr : replacement_text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->replacement_text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null replacement_text in FrameWidgetInputHandler.ExtendSelectionAndReplace request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("ExtendSelectionAndReplace");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetInputHandlerProxy::DeleteSurroundingText(
    int32_t in_before, int32_t in_after) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameWidgetInputHandler::DeleteSurroundingText", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("before"), in_before,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("after"), in_after,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetInputHandler::kDeleteSurroundingText), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_DeleteSurroundingText_Params_Data> params(
          message);
  params.Allocate();

  params->before = in_before;

  params->after = in_after;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("DeleteSurroundingText");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetInputHandlerProxy::DeleteSurroundingTextInCodePoints(
    int32_t in_before, int32_t in_after) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameWidgetInputHandler::DeleteSurroundingTextInCodePoints", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("before"), in_before,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("after"), in_after,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetInputHandler::kDeleteSurroundingTextInCodePoints), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_Params_Data> params(
          message);
  params.Allocate();

  params->before = in_before;

  params->after = in_after;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("DeleteSurroundingTextInCodePoints");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetInputHandlerProxy::SetEditableSelectionOffsets(
    int32_t in_start, int32_t in_end) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameWidgetInputHandler::SetEditableSelectionOffsets", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("start"), in_start,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("end"), in_end,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetInputHandler::kSetEditableSelectionOffsets), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_SetEditableSelectionOffsets_Params_Data> params(
          message);
  params.Allocate();

  params->start = in_start;

  params->end = in_end;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("SetEditableSelectionOffsets");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetInputHandlerProxy::HandleStylusWritingGestureAction(
    ::blink::mojom::blink::StylusWritingGestureDataPtr in_gesture_data, HandleStylusWritingGestureActionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameWidgetInputHandler::HandleStylusWritingGestureAction", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gesture_data"), in_gesture_data,
                        "<value of type ::blink::mojom::blink::StylusWritingGestureDataPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetInputHandler::kHandleStylusWritingGestureAction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_HandleStylusWritingGestureAction_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->gesture_data)::BaseType> gesture_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::StylusWritingGestureDataDataView>(
    in_gesture_data,
    gesture_data_fragment);

  params->gesture_data.Set(
      gesture_data_fragment.is_null() ? nullptr : gesture_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->gesture_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null gesture_data in FrameWidgetInputHandler.HandleStylusWritingGestureAction request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("HandleStylusWritingGestureAction");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameWidgetInputHandler_HandleStylusWritingGestureAction_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FrameWidgetInputHandlerProxy::ExecuteEditCommand(
    const ::blink::String& in_command, const ::blink::String& in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameWidgetInputHandler::ExecuteEditCommand", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("command"), in_command,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetInputHandler::kExecuteEditCommand), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_ExecuteEditCommand_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->command)::BaseType> command_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_command,
    command_fragment);

  params->command.Set(
      command_fragment.is_null() ? nullptr : command_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->command.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null command in FrameWidgetInputHandler.ExecuteEditCommand request");
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType> value_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_value,
    value_fragment);

  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("ExecuteEditCommand");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetInputHandlerProxy::Undo(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::FrameWidgetInputHandler::Undo");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetInputHandler::kUndo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_Undo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("Undo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetInputHandlerProxy::Redo(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::FrameWidgetInputHandler::Redo");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetInputHandler::kRedo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_Redo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("Redo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetInputHandlerProxy::Cut(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::FrameWidgetInputHandler::Cut");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetInputHandler::kCut), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_Cut_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("Cut");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetInputHandlerProxy::Copy(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::FrameWidgetInputHandler::Copy");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetInputHandler::kCopy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_Copy_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("Copy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetInputHandlerProxy::CopyToFindPboard(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::FrameWidgetInputHandler::CopyToFindPboard");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetInputHandler::kCopyToFindPboard), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_CopyToFindPboard_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("CopyToFindPboard");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetInputHandlerProxy::CenterSelection(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::FrameWidgetInputHandler::CenterSelection");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetInputHandler::kCenterSelection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_CenterSelection_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("CenterSelection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetInputHandlerProxy::Paste(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::FrameWidgetInputHandler::Paste");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetInputHandler::kPaste), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_Paste_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("Paste");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetInputHandlerProxy::PasteAndMatchStyle(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::FrameWidgetInputHandler::PasteAndMatchStyle");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetInputHandler::kPasteAndMatchStyle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_PasteAndMatchStyle_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("PasteAndMatchStyle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetInputHandlerProxy::Delete(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::FrameWidgetInputHandler::Delete");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetInputHandler::kDelete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_Delete_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("Delete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetInputHandlerProxy::SelectAll(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::FrameWidgetInputHandler::SelectAll");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetInputHandler::kSelectAll), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_SelectAll_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("SelectAll");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetInputHandlerProxy::CollapseSelection(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::FrameWidgetInputHandler::CollapseSelection");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetInputHandler::kCollapseSelection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_CollapseSelection_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("CollapseSelection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetInputHandlerProxy::CopyWithConfirmation(
    int32_t in_token, CopyWithConfirmationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameWidgetInputHandler::CopyWithConfirmation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetInputHandler::kCopyWithConfirmation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_CopyWithConfirmation_Params_Data> params(
          message);
  params.Allocate();

  params->token = in_token;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("CopyWithConfirmation");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameWidgetInputHandler_CopyWithConfirmation_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FrameWidgetInputHandlerProxy::PasteWithConfirmation(
    int32_t in_token, PasteWithConfirmationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameWidgetInputHandler::PasteWithConfirmation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetInputHandler::kPasteWithConfirmation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_PasteWithConfirmation_Params_Data> params(
          message);
  params.Allocate();

  params->token = in_token;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("PasteWithConfirmation");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameWidgetInputHandler_PasteWithConfirmation_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FrameWidgetInputHandlerProxy::Replace(
    const ::blink::String& in_word) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameWidgetInputHandler::Replace", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("word"), in_word,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetInputHandler::kReplace), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_Replace_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->word)::BaseType> word_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_word,
    word_fragment);

  params->word.Set(
      word_fragment.is_null() ? nullptr : word_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->word.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null word in FrameWidgetInputHandler.Replace request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("Replace");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetInputHandlerProxy::ReplaceMisspelling(
    const ::blink::String& in_word) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameWidgetInputHandler::ReplaceMisspelling", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("word"), in_word,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetInputHandler::kReplaceMisspelling), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_ReplaceMisspelling_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->word)::BaseType> word_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_word,
    word_fragment);

  params->word.Set(
      word_fragment.is_null() ? nullptr : word_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->word.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null word in FrameWidgetInputHandler.ReplaceMisspelling request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("ReplaceMisspelling");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetInputHandlerProxy::SelectRange(
    const ::gfx::Point& in_base, const ::gfx::Point& in_extent) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameWidgetInputHandler::SelectRange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("base"), in_base,
                        "<value of type const ::gfx::Point&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extent"), in_extent,
                        "<value of type const ::gfx::Point&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetInputHandler::kSelectRange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_SelectRange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->base)::BaseType> base_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
    in_base,
    base_fragment);

  params->base.Set(
      base_fragment.is_null() ? nullptr : base_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->base.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null base in FrameWidgetInputHandler.SelectRange request");
  mojo::internal::MessageFragment<
      typename decltype(params->extent)::BaseType> extent_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
    in_extent,
    extent_fragment);

  params->extent.Set(
      extent_fragment.is_null() ? nullptr : extent_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->extent.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null extent in FrameWidgetInputHandler.SelectRange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("SelectRange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetInputHandlerProxy::AdjustSelectionByCharacterOffset(
    int32_t in_start, int32_t in_end, ::blink::mojom::blink::SelectionMenuBehavior in_behavior) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameWidgetInputHandler::AdjustSelectionByCharacterOffset", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("start"), in_start,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("end"), in_end,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("behavior"), in_behavior,
                        "<value of type ::blink::mojom::blink::SelectionMenuBehavior>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetInputHandler::kAdjustSelectionByCharacterOffset), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_Params_Data> params(
          message);
  params.Allocate();

  params->start = in_start;

  params->end = in_end;

  
  mojo::internal::Serialize<::blink::mojom::SelectionMenuBehavior>(
    in_behavior,
    &params->behavior);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("AdjustSelectionByCharacterOffset");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetInputHandlerProxy::SelectAroundCaret(
    SelectionGranularity in_granularity, bool in_should_show_handle, bool in_should_show_context_menu, SelectAroundCaretCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameWidgetInputHandler::SelectAroundCaret", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("granularity"), in_granularity,
                        "<value of type SelectionGranularity>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("should_show_handle"), in_should_show_handle,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("should_show_context_menu"), in_should_show_context_menu,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetInputHandler::kSelectAroundCaret), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_SelectAroundCaret_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::SelectionGranularity>(
    in_granularity,
    &params->granularity);

  params->should_show_handle = in_should_show_handle;

  params->should_show_context_menu = in_should_show_context_menu;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("SelectAroundCaret");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameWidgetInputHandler_SelectAroundCaret_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FrameWidgetInputHandlerProxy::MoveRangeSelectionExtent(
    const ::gfx::Point& in_extent) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameWidgetInputHandler::MoveRangeSelectionExtent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extent"), in_extent,
                        "<value of type const ::gfx::Point&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetInputHandler::kMoveRangeSelectionExtent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_MoveRangeSelectionExtent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extent)::BaseType> extent_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
    in_extent,
    extent_fragment);

  params->extent.Set(
      extent_fragment.is_null() ? nullptr : extent_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->extent.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null extent in FrameWidgetInputHandler.MoveRangeSelectionExtent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("MoveRangeSelectionExtent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetInputHandlerProxy::ScrollFocusedEditableNodeIntoView(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::FrameWidgetInputHandler::ScrollFocusedEditableNodeIntoView");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetInputHandler::kScrollFocusedEditableNodeIntoView), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("ScrollFocusedEditableNodeIntoView");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameWidgetInputHandlerProxy::WaitForPageScaleAnimationForTesting(
    WaitForPageScaleAnimationForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::FrameWidgetInputHandler::WaitForPageScaleAnimationForTesting");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetInputHandler::kWaitForPageScaleAnimationForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("WaitForPageScaleAnimationForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FrameWidgetInputHandlerProxy::MoveCaret(
    const ::gfx::Point& in_point) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FrameWidgetInputHandler::MoveCaret", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("point"), in_point,
                        "<value of type const ::gfx::Point&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetInputHandler::kMoveCaret), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_MoveCaret_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->point)::BaseType> point_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
    in_point,
    point_fragment);

  params->point.Set(
      point_fragment.is_null() ? nullptr : point_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->point.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null point in FrameWidgetInputHandler.MoveCaret request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("MoveCaret");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class FrameWidgetInputHandler_HandleStylusWritingGestureAction_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FrameWidgetInputHandler::HandleStylusWritingGestureActionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FrameWidgetInputHandler_HandleStylusWritingGestureAction_ProxyToResponder> proxy(
        new FrameWidgetInputHandler_HandleStylusWritingGestureAction_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FrameWidgetInputHandler_HandleStylusWritingGestureAction_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FrameWidgetInputHandler_HandleStylusWritingGestureAction_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FrameWidgetInputHandler_HandleStylusWritingGestureAction_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FrameWidgetInputHandler::HandleStylusWritingGestureActionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::HandwritingGestureResult in_result);
};

bool FrameWidgetInputHandler_HandleStylusWritingGestureAction_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FrameWidgetInputHandler.8
  bool success = true;
  ::blink::mojom::blink::HandwritingGestureResult p_result{};
  FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameWidgetInputHandler::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void FrameWidgetInputHandler_HandleStylusWritingGestureAction_ProxyToResponder::Run(
    ::blink::mojom::blink::HandwritingGestureResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FrameWidgetInputHandler::HandleStylusWritingGestureAction", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::blink::HandwritingGestureResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetInputHandler::kHandleStylusWritingGestureAction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::HandwritingGestureResult>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("HandleStylusWritingGestureAction");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FrameWidgetInputHandler_CopyWithConfirmation_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FrameWidgetInputHandler::CopyWithConfirmationCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FrameWidgetInputHandler_CopyWithConfirmation_ProxyToResponder> proxy(
        new FrameWidgetInputHandler_CopyWithConfirmation_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FrameWidgetInputHandler_CopyWithConfirmation_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FrameWidgetInputHandler_CopyWithConfirmation_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FrameWidgetInputHandler_CopyWithConfirmation_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FrameWidgetInputHandler::CopyWithConfirmationCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_token);
};

bool FrameWidgetInputHandler_CopyWithConfirmation_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FrameWidgetInputHandler_CopyWithConfirmation_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FrameWidgetInputHandler_CopyWithConfirmation_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FrameWidgetInputHandler.21
  bool success = true;
  int32_t p_token{};
  FrameWidgetInputHandler_CopyWithConfirmation_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_token = input_data_view.token();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameWidgetInputHandler::Name_, 21, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_token));
  }
  return true;
}

void FrameWidgetInputHandler_CopyWithConfirmation_ProxyToResponder::Run(
    int32_t in_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FrameWidgetInputHandler::CopyWithConfirmation", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetInputHandler::kCopyWithConfirmation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_CopyWithConfirmation_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->token = in_token;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("CopyWithConfirmation");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FrameWidgetInputHandler_PasteWithConfirmation_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FrameWidgetInputHandler::PasteWithConfirmationCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FrameWidgetInputHandler_PasteWithConfirmation_ProxyToResponder> proxy(
        new FrameWidgetInputHandler_PasteWithConfirmation_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FrameWidgetInputHandler_PasteWithConfirmation_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FrameWidgetInputHandler_PasteWithConfirmation_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FrameWidgetInputHandler_PasteWithConfirmation_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FrameWidgetInputHandler::PasteWithConfirmationCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_token);
};

bool FrameWidgetInputHandler_PasteWithConfirmation_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FrameWidgetInputHandler_PasteWithConfirmation_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FrameWidgetInputHandler_PasteWithConfirmation_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FrameWidgetInputHandler.22
  bool success = true;
  int32_t p_token{};
  FrameWidgetInputHandler_PasteWithConfirmation_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_token = input_data_view.token();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameWidgetInputHandler::Name_, 22, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_token));
  }
  return true;
}

void FrameWidgetInputHandler_PasteWithConfirmation_ProxyToResponder::Run(
    int32_t in_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FrameWidgetInputHandler::PasteWithConfirmation", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetInputHandler::kPasteWithConfirmation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_PasteWithConfirmation_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->token = in_token;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("PasteWithConfirmation");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FrameWidgetInputHandler_SelectAroundCaret_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FrameWidgetInputHandler::SelectAroundCaretCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FrameWidgetInputHandler_SelectAroundCaret_ProxyToResponder> proxy(
        new FrameWidgetInputHandler_SelectAroundCaret_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FrameWidgetInputHandler_SelectAroundCaret_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FrameWidgetInputHandler_SelectAroundCaret_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FrameWidgetInputHandler_SelectAroundCaret_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FrameWidgetInputHandler::SelectAroundCaretCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      SelectAroundCaretResultPtr in_result);
};

bool FrameWidgetInputHandler_SelectAroundCaret_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FrameWidgetInputHandler_SelectAroundCaret_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FrameWidgetInputHandler_SelectAroundCaret_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FrameWidgetInputHandler.27
  bool success = true;
  SelectAroundCaretResultPtr p_result{};
  FrameWidgetInputHandler_SelectAroundCaret_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameWidgetInputHandler::Name_, 27, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void FrameWidgetInputHandler_SelectAroundCaret_ProxyToResponder::Run(
    SelectAroundCaretResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FrameWidgetInputHandler::SelectAroundCaret", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type SelectAroundCaretResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetInputHandler::kSelectAroundCaret), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_SelectAroundCaret_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::SelectAroundCaretResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("SelectAroundCaret");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FrameWidgetInputHandler::WaitForPageScaleAnimationForTestingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ProxyToResponder> proxy(
        new FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FrameWidgetInputHandler::WaitForPageScaleAnimationForTestingCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FrameWidgetInputHandler.30
  bool success = true;
  FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameWidgetInputHandler::Name_, 30, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::FrameWidgetInputHandler::WaitForPageScaleAnimationForTesting");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameWidgetInputHandler::kWaitForPageScaleAnimationForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetInputHandler::Name_);
  message.set_method_name("WaitForPageScaleAnimationForTesting");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool FrameWidgetInputHandlerStubDispatch::Accept(
    FrameWidgetInputHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FrameWidgetInputHandler>(message->header()->name)) {
    case messages::FrameWidgetInputHandler::kAddImeTextSpansToExistingText: {
      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_AddImeTextSpansToExistingText_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_AddImeTextSpansToExistingText_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidgetInputHandler.0
      bool success = true;
      uint32_t p_start{};
      uint32_t p_end{};
      ::blink::Vector<::ui::ImeTextSpan> p_ime_text_spans{};
      FrameWidgetInputHandler_AddImeTextSpansToExistingText_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_start = input_data_view.start();
      if (success)
        p_end = input_data_view.end();
      if (success && !input_data_view.ReadImeTextSpans(&p_ime_text_spans))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddImeTextSpansToExistingText(        
        std::move(p_start), 
        std::move(p_end), 
        std::move(p_ime_text_spans));
      return true;
    }
    case messages::FrameWidgetInputHandler::kClearImeTextSpansByType: {
      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_ClearImeTextSpansByType_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_ClearImeTextSpansByType_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidgetInputHandler.1
      bool success = true;
      uint32_t p_start{};
      uint32_t p_end{};
      ::ui::ImeTextSpan::Type p_type{};
      FrameWidgetInputHandler_ClearImeTextSpansByType_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_start = input_data_view.start();
      if (success)
        p_end = input_data_view.end();
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearImeTextSpansByType(        
        std::move(p_start), 
        std::move(p_end), 
        std::move(p_type));
      return true;
    }
    case messages::FrameWidgetInputHandler::kSetCompositionFromExistingText: {
      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_SetCompositionFromExistingText_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_SetCompositionFromExistingText_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidgetInputHandler.2
      bool success = true;
      int32_t p_start{};
      int32_t p_end{};
      ::blink::Vector<::ui::ImeTextSpan> p_ime_text_spans{};
      FrameWidgetInputHandler_SetCompositionFromExistingText_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_start = input_data_view.start();
      if (success)
        p_end = input_data_view.end();
      if (success && !input_data_view.ReadImeTextSpans(&p_ime_text_spans))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCompositionFromExistingText(        
        std::move(p_start), 
        std::move(p_end), 
        std::move(p_ime_text_spans));
      return true;
    }
    case messages::FrameWidgetInputHandler::kExtendSelectionAndDelete: {
      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_ExtendSelectionAndDelete_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_ExtendSelectionAndDelete_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidgetInputHandler.3
      bool success = true;
      int32_t p_before{};
      int32_t p_after{};
      FrameWidgetInputHandler_ExtendSelectionAndDelete_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_before = input_data_view.before();
      if (success)
        p_after = input_data_view.after();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExtendSelectionAndDelete(        
        std::move(p_before), 
        std::move(p_after));
      return true;
    }
    case messages::FrameWidgetInputHandler::kExtendSelectionAndReplace: {
      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_ExtendSelectionAndReplace_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_ExtendSelectionAndReplace_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidgetInputHandler.4
      bool success = true;
      uint32_t p_before{};
      uint32_t p_after{};
      ::blink::String p_replacement_text{};
      FrameWidgetInputHandler_ExtendSelectionAndReplace_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_before = input_data_view.before();
      if (success)
        p_after = input_data_view.after();
      if (success && !input_data_view.ReadReplacementText(&p_replacement_text))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExtendSelectionAndReplace(        
        std::move(p_before), 
        std::move(p_after), 
        std::move(p_replacement_text));
      return true;
    }
    case messages::FrameWidgetInputHandler::kDeleteSurroundingText: {
      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_DeleteSurroundingText_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_DeleteSurroundingText_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidgetInputHandler.5
      bool success = true;
      int32_t p_before{};
      int32_t p_after{};
      FrameWidgetInputHandler_DeleteSurroundingText_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_before = input_data_view.before();
      if (success)
        p_after = input_data_view.after();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteSurroundingText(        
        std::move(p_before), 
        std::move(p_after));
      return true;
    }
    case messages::FrameWidgetInputHandler::kDeleteSurroundingTextInCodePoints: {
      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidgetInputHandler.6
      bool success = true;
      int32_t p_before{};
      int32_t p_after{};
      FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_before = input_data_view.before();
      if (success)
        p_after = input_data_view.after();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteSurroundingTextInCodePoints(        
        std::move(p_before), 
        std::move(p_after));
      return true;
    }
    case messages::FrameWidgetInputHandler::kSetEditableSelectionOffsets: {
      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_SetEditableSelectionOffsets_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_SetEditableSelectionOffsets_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidgetInputHandler.7
      bool success = true;
      int32_t p_start{};
      int32_t p_end{};
      FrameWidgetInputHandler_SetEditableSelectionOffsets_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_start = input_data_view.start();
      if (success)
        p_end = input_data_view.end();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetEditableSelectionOffsets(        
        std::move(p_start), 
        std::move(p_end));
      return true;
    }
    case messages::FrameWidgetInputHandler::kHandleStylusWritingGestureAction: {
      break;
    }
    case messages::FrameWidgetInputHandler::kExecuteEditCommand: {
      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_ExecuteEditCommand_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_ExecuteEditCommand_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidgetInputHandler.9
      bool success = true;
      ::blink::String p_command{};
      ::blink::String p_value{};
      FrameWidgetInputHandler_ExecuteEditCommand_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCommand(&p_command))
        success = false;
      if (success && !input_data_view.ReadValue(&p_value))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExecuteEditCommand(        
        std::move(p_command), 
        std::move(p_value));
      return true;
    }
    case messages::FrameWidgetInputHandler::kUndo: {
      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_Undo_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_Undo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidgetInputHandler.10
      bool success = true;
      FrameWidgetInputHandler_Undo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Undo(        );
      return true;
    }
    case messages::FrameWidgetInputHandler::kRedo: {
      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_Redo_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_Redo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidgetInputHandler.11
      bool success = true;
      FrameWidgetInputHandler_Redo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Redo(        );
      return true;
    }
    case messages::FrameWidgetInputHandler::kCut: {
      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_Cut_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_Cut_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidgetInputHandler.12
      bool success = true;
      FrameWidgetInputHandler_Cut_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Cut(        );
      return true;
    }
    case messages::FrameWidgetInputHandler::kCopy: {
      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_Copy_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_Copy_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidgetInputHandler.13
      bool success = true;
      FrameWidgetInputHandler_Copy_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Copy(        );
      return true;
    }
    case messages::FrameWidgetInputHandler::kCopyToFindPboard: {
      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_CopyToFindPboard_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_CopyToFindPboard_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidgetInputHandler.14
      bool success = true;
      FrameWidgetInputHandler_CopyToFindPboard_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CopyToFindPboard(        );
      return true;
    }
    case messages::FrameWidgetInputHandler::kCenterSelection: {
      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_CenterSelection_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_CenterSelection_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidgetInputHandler.15
      bool success = true;
      FrameWidgetInputHandler_CenterSelection_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CenterSelection(        );
      return true;
    }
    case messages::FrameWidgetInputHandler::kPaste: {
      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_Paste_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_Paste_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidgetInputHandler.16
      bool success = true;
      FrameWidgetInputHandler_Paste_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Paste(        );
      return true;
    }
    case messages::FrameWidgetInputHandler::kPasteAndMatchStyle: {
      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_PasteAndMatchStyle_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_PasteAndMatchStyle_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidgetInputHandler.17
      bool success = true;
      FrameWidgetInputHandler_PasteAndMatchStyle_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PasteAndMatchStyle(        );
      return true;
    }
    case messages::FrameWidgetInputHandler::kDelete: {
      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_Delete_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_Delete_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidgetInputHandler.18
      bool success = true;
      FrameWidgetInputHandler_Delete_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Delete(        );
      return true;
    }
    case messages::FrameWidgetInputHandler::kSelectAll: {
      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_SelectAll_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_SelectAll_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidgetInputHandler.19
      bool success = true;
      FrameWidgetInputHandler_SelectAll_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SelectAll(        );
      return true;
    }
    case messages::FrameWidgetInputHandler::kCollapseSelection: {
      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_CollapseSelection_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_CollapseSelection_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidgetInputHandler.20
      bool success = true;
      FrameWidgetInputHandler_CollapseSelection_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 20, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CollapseSelection(        );
      return true;
    }
    case messages::FrameWidgetInputHandler::kCopyWithConfirmation: {
      break;
    }
    case messages::FrameWidgetInputHandler::kPasteWithConfirmation: {
      break;
    }
    case messages::FrameWidgetInputHandler::kReplace: {
      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_Replace_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_Replace_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidgetInputHandler.23
      bool success = true;
      ::blink::String p_word{};
      FrameWidgetInputHandler_Replace_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadWord(&p_word))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 23, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Replace(        
        std::move(p_word));
      return true;
    }
    case messages::FrameWidgetInputHandler::kReplaceMisspelling: {
      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_ReplaceMisspelling_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_ReplaceMisspelling_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidgetInputHandler.24
      bool success = true;
      ::blink::String p_word{};
      FrameWidgetInputHandler_ReplaceMisspelling_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadWord(&p_word))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 24, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReplaceMisspelling(        
        std::move(p_word));
      return true;
    }
    case messages::FrameWidgetInputHandler::kSelectRange: {
      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_SelectRange_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_SelectRange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidgetInputHandler.25
      bool success = true;
      ::gfx::Point p_base{};
      ::gfx::Point p_extent{};
      FrameWidgetInputHandler_SelectRange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBase(&p_base))
        success = false;
      if (success && !input_data_view.ReadExtent(&p_extent))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 25, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SelectRange(        
        std::move(p_base), 
        std::move(p_extent));
      return true;
    }
    case messages::FrameWidgetInputHandler::kAdjustSelectionByCharacterOffset: {
      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidgetInputHandler.26
      bool success = true;
      int32_t p_start{};
      int32_t p_end{};
      ::blink::mojom::blink::SelectionMenuBehavior p_behavior{};
      FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_start = input_data_view.start();
      if (success)
        p_end = input_data_view.end();
      if (success && !input_data_view.ReadBehavior(&p_behavior))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 26, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AdjustSelectionByCharacterOffset(        
        std::move(p_start), 
        std::move(p_end), 
        std::move(p_behavior));
      return true;
    }
    case messages::FrameWidgetInputHandler::kSelectAroundCaret: {
      break;
    }
    case messages::FrameWidgetInputHandler::kMoveRangeSelectionExtent: {
      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_MoveRangeSelectionExtent_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_MoveRangeSelectionExtent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidgetInputHandler.28
      bool success = true;
      ::gfx::Point p_extent{};
      FrameWidgetInputHandler_MoveRangeSelectionExtent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtent(&p_extent))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 28, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MoveRangeSelectionExtent(        
        std::move(p_extent));
      return true;
    }
    case messages::FrameWidgetInputHandler::kScrollFocusedEditableNodeIntoView: {
      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidgetInputHandler.29
      bool success = true;
      FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 29, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ScrollFocusedEditableNodeIntoView(        );
      return true;
    }
    case messages::FrameWidgetInputHandler::kWaitForPageScaleAnimationForTesting: {
      break;
    }
    case messages::FrameWidgetInputHandler::kMoveCaret: {
      DCHECK(message->is_serialized());
      internal::FrameWidgetInputHandler_MoveCaret_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetInputHandler_MoveCaret_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameWidgetInputHandler.31
      bool success = true;
      ::gfx::Point p_point{};
      FrameWidgetInputHandler_MoveCaret_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPoint(&p_point))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 31, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MoveCaret(        
        std::move(p_point));
      return true;
    }
  }
  return false;
}

// static
bool FrameWidgetInputHandlerStubDispatch::AcceptWithResponder(
    FrameWidgetInputHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FrameWidgetInputHandler>(message->header()->name)) {
    case messages::FrameWidgetInputHandler::kAddImeTextSpansToExistingText: {
      break;
    }
    case messages::FrameWidgetInputHandler::kClearImeTextSpansByType: {
      break;
    }
    case messages::FrameWidgetInputHandler::kSetCompositionFromExistingText: {
      break;
    }
    case messages::FrameWidgetInputHandler::kExtendSelectionAndDelete: {
      break;
    }
    case messages::FrameWidgetInputHandler::kExtendSelectionAndReplace: {
      break;
    }
    case messages::FrameWidgetInputHandler::kDeleteSurroundingText: {
      break;
    }
    case messages::FrameWidgetInputHandler::kDeleteSurroundingTextInCodePoints: {
      break;
    }
    case messages::FrameWidgetInputHandler::kSetEditableSelectionOffsets: {
      break;
    }
    case messages::FrameWidgetInputHandler::kHandleStylusWritingGestureAction: {
      internal::FrameWidgetInputHandler_HandleStylusWritingGestureAction_Params_Data* params =
          reinterpret_cast<
              internal::FrameWidgetInputHandler_HandleStylusWritingGestureAction_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FrameWidgetInputHandler.8
      bool success = true;
      ::blink::mojom::blink::StylusWritingGestureDataPtr p_gesture_data{};
      FrameWidgetInputHandler_HandleStylusWritingGestureAction_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGestureData(&p_gesture_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 8, false);
        return false;
      }
      auto callback =
          FrameWidgetInputHandler_HandleStylusWritingGestureAction_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HandleStylusWritingGestureAction(        
        std::move(p_gesture_data), std::move(callback));
      return true;
    }
    case messages::FrameWidgetInputHandler::kExecuteEditCommand: {
      break;
    }
    case messages::FrameWidgetInputHandler::kUndo: {
      break;
    }
    case messages::FrameWidgetInputHandler::kRedo: {
      break;
    }
    case messages::FrameWidgetInputHandler::kCut: {
      break;
    }
    case messages::FrameWidgetInputHandler::kCopy: {
      break;
    }
    case messages::FrameWidgetInputHandler::kCopyToFindPboard: {
      break;
    }
    case messages::FrameWidgetInputHandler::kCenterSelection: {
      break;
    }
    case messages::FrameWidgetInputHandler::kPaste: {
      break;
    }
    case messages::FrameWidgetInputHandler::kPasteAndMatchStyle: {
      break;
    }
    case messages::FrameWidgetInputHandler::kDelete: {
      break;
    }
    case messages::FrameWidgetInputHandler::kSelectAll: {
      break;
    }
    case messages::FrameWidgetInputHandler::kCollapseSelection: {
      break;
    }
    case messages::FrameWidgetInputHandler::kCopyWithConfirmation: {
      internal::FrameWidgetInputHandler_CopyWithConfirmation_Params_Data* params =
          reinterpret_cast<
              internal::FrameWidgetInputHandler_CopyWithConfirmation_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FrameWidgetInputHandler.21
      bool success = true;
      int32_t p_token{};
      FrameWidgetInputHandler_CopyWithConfirmation_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_token = input_data_view.token();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 21, false);
        return false;
      }
      auto callback =
          FrameWidgetInputHandler_CopyWithConfirmation_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CopyWithConfirmation(        
        std::move(p_token), std::move(callback));
      return true;
    }
    case messages::FrameWidgetInputHandler::kPasteWithConfirmation: {
      internal::FrameWidgetInputHandler_PasteWithConfirmation_Params_Data* params =
          reinterpret_cast<
              internal::FrameWidgetInputHandler_PasteWithConfirmation_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FrameWidgetInputHandler.22
      bool success = true;
      int32_t p_token{};
      FrameWidgetInputHandler_PasteWithConfirmation_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_token = input_data_view.token();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 22, false);
        return false;
      }
      auto callback =
          FrameWidgetInputHandler_PasteWithConfirmation_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PasteWithConfirmation(        
        std::move(p_token), std::move(callback));
      return true;
    }
    case messages::FrameWidgetInputHandler::kReplace: {
      break;
    }
    case messages::FrameWidgetInputHandler::kReplaceMisspelling: {
      break;
    }
    case messages::FrameWidgetInputHandler::kSelectRange: {
      break;
    }
    case messages::FrameWidgetInputHandler::kAdjustSelectionByCharacterOffset: {
      break;
    }
    case messages::FrameWidgetInputHandler::kSelectAroundCaret: {
      internal::FrameWidgetInputHandler_SelectAroundCaret_Params_Data* params =
          reinterpret_cast<
              internal::FrameWidgetInputHandler_SelectAroundCaret_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FrameWidgetInputHandler.27
      bool success = true;
      SelectionGranularity p_granularity{};
      bool p_should_show_handle{};
      bool p_should_show_context_menu{};
      FrameWidgetInputHandler_SelectAroundCaret_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGranularity(&p_granularity))
        success = false;
      if (success)
        p_should_show_handle = input_data_view.should_show_handle();
      if (success)
        p_should_show_context_menu = input_data_view.should_show_context_menu();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 27, false);
        return false;
      }
      auto callback =
          FrameWidgetInputHandler_SelectAroundCaret_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SelectAroundCaret(        
        std::move(p_granularity), 
        std::move(p_should_show_handle), 
        std::move(p_should_show_context_menu), std::move(callback));
      return true;
    }
    case messages::FrameWidgetInputHandler::kMoveRangeSelectionExtent: {
      break;
    }
    case messages::FrameWidgetInputHandler::kScrollFocusedEditableNodeIntoView: {
      break;
    }
    case messages::FrameWidgetInputHandler::kWaitForPageScaleAnimationForTesting: {
      internal::FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_Params_Data* params =
          reinterpret_cast<
              internal::FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FrameWidgetInputHandler.30
      bool success = true;
      FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetInputHandler::Name_, 30, false);
        return false;
      }
      auto callback =
          FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WaitForPageScaleAnimationForTesting(std::move(callback));
      return true;
    }
    case messages::FrameWidgetInputHandler::kMoveCaret: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFrameWidgetInputHandlerValidationInfo[] = {
    { &internal::FrameWidgetInputHandler_AddImeTextSpansToExistingText_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidgetInputHandler_ClearImeTextSpansByType_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidgetInputHandler_SetCompositionFromExistingText_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidgetInputHandler_ExtendSelectionAndDelete_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidgetInputHandler_ExtendSelectionAndReplace_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidgetInputHandler_DeleteSurroundingText_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidgetInputHandler_DeleteSurroundingTextInCodePoints_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidgetInputHandler_SetEditableSelectionOffsets_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidgetInputHandler_HandleStylusWritingGestureAction_Params_Data::Validate,
     &internal::FrameWidgetInputHandler_HandleStylusWritingGestureAction_ResponseParams_Data::Validate},
    { &internal::FrameWidgetInputHandler_ExecuteEditCommand_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidgetInputHandler_Undo_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidgetInputHandler_Redo_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidgetInputHandler_Cut_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidgetInputHandler_Copy_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidgetInputHandler_CopyToFindPboard_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidgetInputHandler_CenterSelection_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidgetInputHandler_Paste_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidgetInputHandler_PasteAndMatchStyle_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidgetInputHandler_Delete_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidgetInputHandler_SelectAll_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidgetInputHandler_CollapseSelection_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidgetInputHandler_CopyWithConfirmation_Params_Data::Validate,
     &internal::FrameWidgetInputHandler_CopyWithConfirmation_ResponseParams_Data::Validate},
    { &internal::FrameWidgetInputHandler_PasteWithConfirmation_Params_Data::Validate,
     &internal::FrameWidgetInputHandler_PasteWithConfirmation_ResponseParams_Data::Validate},
    { &internal::FrameWidgetInputHandler_Replace_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidgetInputHandler_ReplaceMisspelling_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidgetInputHandler_SelectRange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidgetInputHandler_AdjustSelectionByCharacterOffset_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidgetInputHandler_SelectAroundCaret_Params_Data::Validate,
     &internal::FrameWidgetInputHandler_SelectAroundCaret_ResponseParams_Data::Validate},
    { &internal::FrameWidgetInputHandler_MoveRangeSelectionExtent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidgetInputHandler_ScrollFocusedEditableNodeIntoView_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_Params_Data::Validate,
     &internal::FrameWidgetInputHandler_WaitForPageScaleAnimationForTesting_ResponseParams_Data::Validate},
    { &internal::FrameWidgetInputHandler_MoveCaret_Params_Data::Validate,
     nullptr /* no response */},
};

bool FrameWidgetInputHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::FrameWidgetInputHandler::Name_,
    kFrameWidgetInputHandlerValidationInfo);
}

bool FrameWidgetInputHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::FrameWidgetInputHandler::Name_,
    kFrameWidgetInputHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

WidgetInputHandler::IPCStableHashFunction WidgetInputHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WidgetInputHandler>(message.name())) {
    case messages::WidgetInputHandler::kSetFocus: {
      return &WidgetInputHandler::SetFocus_Sym::IPCStableHash;
    }
    case messages::WidgetInputHandler::kMouseCaptureLost: {
      return &WidgetInputHandler::MouseCaptureLost_Sym::IPCStableHash;
    }
    case messages::WidgetInputHandler::kSetEditCommandsForNextKeyEvent: {
      return &WidgetInputHandler::SetEditCommandsForNextKeyEvent_Sym::IPCStableHash;
    }
    case messages::WidgetInputHandler::kCursorVisibilityChanged: {
      return &WidgetInputHandler::CursorVisibilityChanged_Sym::IPCStableHash;
    }
    case messages::WidgetInputHandler::kImeSetComposition: {
      return &WidgetInputHandler::ImeSetComposition_Sym::IPCStableHash;
    }
    case messages::WidgetInputHandler::kImeCommitText: {
      return &WidgetInputHandler::ImeCommitText_Sym::IPCStableHash;
    }
    case messages::WidgetInputHandler::kImeFinishComposingText: {
      return &WidgetInputHandler::ImeFinishComposingText_Sym::IPCStableHash;
    }
    case messages::WidgetInputHandler::kRequestTextInputStateUpdate: {
      return &WidgetInputHandler::RequestTextInputStateUpdate_Sym::IPCStableHash;
    }
    case messages::WidgetInputHandler::kRequestCompositionUpdates: {
      return &WidgetInputHandler::RequestCompositionUpdates_Sym::IPCStableHash;
    }
    case messages::WidgetInputHandler::kDispatchEvent: {
      return &WidgetInputHandler::DispatchEvent_Sym::IPCStableHash;
    }
    case messages::WidgetInputHandler::kDispatchNonBlockingEvent: {
      return &WidgetInputHandler::DispatchNonBlockingEvent_Sym::IPCStableHash;
    }
    case messages::WidgetInputHandler::kWaitForInputProcessed: {
      return &WidgetInputHandler::WaitForInputProcessed_Sym::IPCStableHash;
    }
    case messages::WidgetInputHandler::kGetFrameWidgetInputHandler: {
      return &WidgetInputHandler::GetFrameWidgetInputHandler_Sym::IPCStableHash;
    }
    case messages::WidgetInputHandler::kUpdateBrowserControlsState: {
      return &WidgetInputHandler::UpdateBrowserControlsState_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WidgetInputHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WidgetInputHandler>(message.name())) {
      case messages::WidgetInputHandler::kSetFocus:
            return "Receive blink::mojom::WidgetInputHandler::SetFocus";
      case messages::WidgetInputHandler::kMouseCaptureLost:
            return "Receive blink::mojom::WidgetInputHandler::MouseCaptureLost";
      case messages::WidgetInputHandler::kSetEditCommandsForNextKeyEvent:
            return "Receive blink::mojom::WidgetInputHandler::SetEditCommandsForNextKeyEvent";
      case messages::WidgetInputHandler::kCursorVisibilityChanged:
            return "Receive blink::mojom::WidgetInputHandler::CursorVisibilityChanged";
      case messages::WidgetInputHandler::kImeSetComposition:
            return "Receive blink::mojom::WidgetInputHandler::ImeSetComposition";
      case messages::WidgetInputHandler::kImeCommitText:
            return "Receive blink::mojom::WidgetInputHandler::ImeCommitText";
      case messages::WidgetInputHandler::kImeFinishComposingText:
            return "Receive blink::mojom::WidgetInputHandler::ImeFinishComposingText";
      case messages::WidgetInputHandler::kRequestTextInputStateUpdate:
            return "Receive blink::mojom::WidgetInputHandler::RequestTextInputStateUpdate";
      case messages::WidgetInputHandler::kRequestCompositionUpdates:
            return "Receive blink::mojom::WidgetInputHandler::RequestCompositionUpdates";
      case messages::WidgetInputHandler::kDispatchEvent:
            return "Receive blink::mojom::WidgetInputHandler::DispatchEvent";
      case messages::WidgetInputHandler::kDispatchNonBlockingEvent:
            return "Receive blink::mojom::WidgetInputHandler::DispatchNonBlockingEvent";
      case messages::WidgetInputHandler::kWaitForInputProcessed:
            return "Receive blink::mojom::WidgetInputHandler::WaitForInputProcessed";
      case messages::WidgetInputHandler::kGetFrameWidgetInputHandler:
            return "Receive blink::mojom::WidgetInputHandler::GetFrameWidgetInputHandler";
      case messages::WidgetInputHandler::kUpdateBrowserControlsState:
            return "Receive blink::mojom::WidgetInputHandler::UpdateBrowserControlsState";
    }
  } else {
    switch (static_cast<messages::WidgetInputHandler>(message.name())) {
      case messages::WidgetInputHandler::kSetFocus:
            return "Receive reply blink::mojom::WidgetInputHandler::SetFocus";
      case messages::WidgetInputHandler::kMouseCaptureLost:
            return "Receive reply blink::mojom::WidgetInputHandler::MouseCaptureLost";
      case messages::WidgetInputHandler::kSetEditCommandsForNextKeyEvent:
            return "Receive reply blink::mojom::WidgetInputHandler::SetEditCommandsForNextKeyEvent";
      case messages::WidgetInputHandler::kCursorVisibilityChanged:
            return "Receive reply blink::mojom::WidgetInputHandler::CursorVisibilityChanged";
      case messages::WidgetInputHandler::kImeSetComposition:
            return "Receive reply blink::mojom::WidgetInputHandler::ImeSetComposition";
      case messages::WidgetInputHandler::kImeCommitText:
            return "Receive reply blink::mojom::WidgetInputHandler::ImeCommitText";
      case messages::WidgetInputHandler::kImeFinishComposingText:
            return "Receive reply blink::mojom::WidgetInputHandler::ImeFinishComposingText";
      case messages::WidgetInputHandler::kRequestTextInputStateUpdate:
            return "Receive reply blink::mojom::WidgetInputHandler::RequestTextInputStateUpdate";
      case messages::WidgetInputHandler::kRequestCompositionUpdates:
            return "Receive reply blink::mojom::WidgetInputHandler::RequestCompositionUpdates";
      case messages::WidgetInputHandler::kDispatchEvent:
            return "Receive reply blink::mojom::WidgetInputHandler::DispatchEvent";
      case messages::WidgetInputHandler::kDispatchNonBlockingEvent:
            return "Receive reply blink::mojom::WidgetInputHandler::DispatchNonBlockingEvent";
      case messages::WidgetInputHandler::kWaitForInputProcessed:
            return "Receive reply blink::mojom::WidgetInputHandler::WaitForInputProcessed";
      case messages::WidgetInputHandler::kGetFrameWidgetInputHandler:
            return "Receive reply blink::mojom::WidgetInputHandler::GetFrameWidgetInputHandler";
      case messages::WidgetInputHandler::kUpdateBrowserControlsState:
            return "Receive reply blink::mojom::WidgetInputHandler::UpdateBrowserControlsState";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WidgetInputHandler::SetFocus_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x011c5065;  // IPCStableHash for blink::mojom::WidgetInputHandler::SetFocus
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WidgetInputHandler::MouseCaptureLost_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf673fd08;  // IPCStableHash for blink::mojom::WidgetInputHandler::MouseCaptureLost
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WidgetInputHandler::SetEditCommandsForNextKeyEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x056869cb;  // IPCStableHash for blink::mojom::WidgetInputHandler::SetEditCommandsForNextKeyEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WidgetInputHandler::CursorVisibilityChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5283091e;  // IPCStableHash for blink::mojom::WidgetInputHandler::CursorVisibilityChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WidgetInputHandler::ImeSetComposition_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc38ab7c9;  // IPCStableHash for blink::mojom::WidgetInputHandler::ImeSetComposition
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WidgetInputHandler::ImeCommitText_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xeb1fdfb4;  // IPCStableHash for blink::mojom::WidgetInputHandler::ImeCommitText
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WidgetInputHandler::ImeFinishComposingText_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe6a211d7;  // IPCStableHash for blink::mojom::WidgetInputHandler::ImeFinishComposingText
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WidgetInputHandler::RequestTextInputStateUpdate_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1b690142;  // IPCStableHash for blink::mojom::WidgetInputHandler::RequestTextInputStateUpdate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WidgetInputHandler::RequestCompositionUpdates_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x44070967;  // IPCStableHash for blink::mojom::WidgetInputHandler::RequestCompositionUpdates
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WidgetInputHandler::DispatchEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x816641a4;  // IPCStableHash for blink::mojom::WidgetInputHandler::DispatchEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WidgetInputHandler::DispatchNonBlockingEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1479874f;  // IPCStableHash for blink::mojom::WidgetInputHandler::DispatchNonBlockingEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WidgetInputHandler::WaitForInputProcessed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb76020af;  // IPCStableHash for blink::mojom::WidgetInputHandler::WaitForInputProcessed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WidgetInputHandler::GetFrameWidgetInputHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xecfc3f96;  // IPCStableHash for blink::mojom::WidgetInputHandler::GetFrameWidgetInputHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WidgetInputHandler::UpdateBrowserControlsState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdcb984b1;  // IPCStableHash for blink::mojom::WidgetInputHandler::UpdateBrowserControlsState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class WidgetInputHandler_ImeSetComposition_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WidgetInputHandler_ImeSetComposition_ForwardToCallback(
      WidgetInputHandler::ImeSetCompositionCallback callback
      ) : callback_(std::move(callback)) {
  }

  WidgetInputHandler_ImeSetComposition_ForwardToCallback(const WidgetInputHandler_ImeSetComposition_ForwardToCallback&) = delete;
  WidgetInputHandler_ImeSetComposition_ForwardToCallback& operator=(const WidgetInputHandler_ImeSetComposition_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WidgetInputHandler::ImeSetCompositionCallback callback_;
};

class WidgetInputHandler_ImeCommitText_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WidgetInputHandler_ImeCommitText_ForwardToCallback(
      WidgetInputHandler::ImeCommitTextCallback callback
      ) : callback_(std::move(callback)) {
  }

  WidgetInputHandler_ImeCommitText_ForwardToCallback(const WidgetInputHandler_ImeCommitText_ForwardToCallback&) = delete;
  WidgetInputHandler_ImeCommitText_ForwardToCallback& operator=(const WidgetInputHandler_ImeCommitText_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WidgetInputHandler::ImeCommitTextCallback callback_;
};

class WidgetInputHandler_DispatchEvent_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WidgetInputHandler_DispatchEvent_ForwardToCallback(
      WidgetInputHandler::DispatchEventCallback callback
      ) : callback_(std::move(callback)) {
  }

  WidgetInputHandler_DispatchEvent_ForwardToCallback(const WidgetInputHandler_DispatchEvent_ForwardToCallback&) = delete;
  WidgetInputHandler_DispatchEvent_ForwardToCallback& operator=(const WidgetInputHandler_DispatchEvent_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WidgetInputHandler::DispatchEventCallback callback_;
};

class WidgetInputHandler_WaitForInputProcessed_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WidgetInputHandler_WaitForInputProcessed_ForwardToCallback(
      WidgetInputHandler::WaitForInputProcessedCallback callback
      ) : callback_(std::move(callback)) {
  }

  WidgetInputHandler_WaitForInputProcessed_ForwardToCallback(const WidgetInputHandler_WaitForInputProcessed_ForwardToCallback&) = delete;
  WidgetInputHandler_WaitForInputProcessed_ForwardToCallback& operator=(const WidgetInputHandler_WaitForInputProcessed_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WidgetInputHandler::WaitForInputProcessedCallback callback_;
};

WidgetInputHandlerProxy::WidgetInputHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WidgetInputHandlerProxy::SetFocus(
    FocusState in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WidgetInputHandler::SetFocus", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type FocusState>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WidgetInputHandler::kSetFocus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandler_SetFocus_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::FocusState>(
    in_state,
    &params->state);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandler::Name_);
  message.set_method_name("SetFocus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WidgetInputHandlerProxy::MouseCaptureLost(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::WidgetInputHandler::MouseCaptureLost");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WidgetInputHandler::kMouseCaptureLost), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandler_MouseCaptureLost_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandler::Name_);
  message.set_method_name("MouseCaptureLost");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WidgetInputHandlerProxy::SetEditCommandsForNextKeyEvent(
    ::blink::Vector<EditCommandPtr> in_commands) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WidgetInputHandler::SetEditCommandsForNextKeyEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("commands"), in_commands,
                        "<value of type ::blink::Vector<EditCommandPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WidgetInputHandler::kSetEditCommandsForNextKeyEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandler_SetEditCommandsForNextKeyEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->commands)::BaseType>
      commands_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& commands_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::EditCommandDataView>>(
    in_commands,
    commands_fragment,
    &commands_validate_params);

  params->commands.Set(
      commands_fragment.is_null() ? nullptr : commands_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->commands.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null commands in WidgetInputHandler.SetEditCommandsForNextKeyEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandler::Name_);
  message.set_method_name("SetEditCommandsForNextKeyEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WidgetInputHandlerProxy::CursorVisibilityChanged(
    bool in_visible) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WidgetInputHandler::CursorVisibilityChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visible"), in_visible,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WidgetInputHandler::kCursorVisibilityChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandler_CursorVisibilityChanged_Params_Data> params(
          message);
  params.Allocate();

  params->visible = in_visible;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandler::Name_);
  message.set_method_name("CursorVisibilityChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WidgetInputHandlerProxy::ImeSetComposition(
    const ::blink::String& in_text, const ::blink::Vector<::ui::ImeTextSpan>& in_ime_text_spans, const ::gfx::Range& in_range, int32_t in_start, int32_t in_end, ImeSetCompositionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WidgetInputHandler::ImeSetComposition", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ime_text_spans"), in_ime_text_spans,
                        "<value of type const ::blink::Vector<::ui::ImeTextSpan>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("range"), in_range,
                        "<value of type const ::gfx::Range&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("start"), in_start,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("end"), in_end,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WidgetInputHandler::kImeSetComposition), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandler_ImeSetComposition_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType> text_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_text,
    text_fragment);

  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null text in WidgetInputHandler.ImeSetComposition request");
  mojo::internal::MessageFragment<
      typename decltype(params->ime_text_spans)::BaseType>
      ime_text_spans_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& ime_text_spans_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::ui::mojom::ImeTextSpanDataView>>(
    in_ime_text_spans,
    ime_text_spans_fragment,
    &ime_text_spans_validate_params);

  params->ime_text_spans.Set(
      ime_text_spans_fragment.is_null() ? nullptr : ime_text_spans_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->ime_text_spans.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null ime_text_spans in WidgetInputHandler.ImeSetComposition request");
  mojo::internal::MessageFragment<
      typename decltype(params->range)::BaseType> range_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RangeDataView>(
    in_range,
    range_fragment);

  params->range.Set(
      range_fragment.is_null() ? nullptr : range_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->range.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null range in WidgetInputHandler.ImeSetComposition request");

  params->start = in_start;

  params->end = in_end;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandler::Name_);
  message.set_method_name("ImeSetComposition");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WidgetInputHandler_ImeSetComposition_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WidgetInputHandlerProxy::ImeCommitText(
    const ::blink::String& in_text, const ::blink::Vector<::ui::ImeTextSpan>& in_ime_text_spans, const ::gfx::Range& in_range, int32_t in_relative_cursor_position, ImeCommitTextCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WidgetInputHandler::ImeCommitText", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ime_text_spans"), in_ime_text_spans,
                        "<value of type const ::blink::Vector<::ui::ImeTextSpan>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("range"), in_range,
                        "<value of type const ::gfx::Range&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("relative_cursor_position"), in_relative_cursor_position,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WidgetInputHandler::kImeCommitText), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandler_ImeCommitText_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType> text_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_text,
    text_fragment);

  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null text in WidgetInputHandler.ImeCommitText request");
  mojo::internal::MessageFragment<
      typename decltype(params->ime_text_spans)::BaseType>
      ime_text_spans_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& ime_text_spans_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::ui::mojom::ImeTextSpanDataView>>(
    in_ime_text_spans,
    ime_text_spans_fragment,
    &ime_text_spans_validate_params);

  params->ime_text_spans.Set(
      ime_text_spans_fragment.is_null() ? nullptr : ime_text_spans_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->ime_text_spans.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null ime_text_spans in WidgetInputHandler.ImeCommitText request");
  mojo::internal::MessageFragment<
      typename decltype(params->range)::BaseType> range_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RangeDataView>(
    in_range,
    range_fragment);

  params->range.Set(
      range_fragment.is_null() ? nullptr : range_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->range.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null range in WidgetInputHandler.ImeCommitText request");

  params->relative_cursor_position = in_relative_cursor_position;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandler::Name_);
  message.set_method_name("ImeCommitText");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WidgetInputHandler_ImeCommitText_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WidgetInputHandlerProxy::ImeFinishComposingText(
    bool in_keep_selection) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WidgetInputHandler::ImeFinishComposingText", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("keep_selection"), in_keep_selection,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WidgetInputHandler::kImeFinishComposingText), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandler_ImeFinishComposingText_Params_Data> params(
          message);
  params.Allocate();

  params->keep_selection = in_keep_selection;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandler::Name_);
  message.set_method_name("ImeFinishComposingText");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WidgetInputHandlerProxy::RequestTextInputStateUpdate(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::WidgetInputHandler::RequestTextInputStateUpdate");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WidgetInputHandler::kRequestTextInputStateUpdate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandler_RequestTextInputStateUpdate_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandler::Name_);
  message.set_method_name("RequestTextInputStateUpdate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WidgetInputHandlerProxy::RequestCompositionUpdates(
    bool in_immediate_request, bool in_monitor_request) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WidgetInputHandler::RequestCompositionUpdates", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("immediate_request"), in_immediate_request,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("monitor_request"), in_monitor_request,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WidgetInputHandler::kRequestCompositionUpdates), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandler_RequestCompositionUpdates_Params_Data> params(
          message);
  params.Allocate();

  params->immediate_request = in_immediate_request;

  params->monitor_request = in_monitor_request;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandler::Name_);
  message.set_method_name("RequestCompositionUpdates");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WidgetInputHandlerProxy::DispatchEvent(
    ::std::unique_ptr<::blink::WebCoalescedInputEvent> in_event, std::optional<::std::unique_ptr<::blink::WebCoalescedInputEvent>> in_original_event_for_gesture, DispatchEventCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WidgetInputHandler::DispatchEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type ::std::unique_ptr<::blink::WebCoalescedInputEvent>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("original_event_for_gesture"), in_original_event_for_gesture,
                        "<value of type std::optional<::std::unique_ptr<::blink::WebCoalescedInputEvent>>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WidgetInputHandler::kDispatchEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandler_DispatchEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event)::BaseType> event_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::EventDataView>(
    in_event,
    event_fragment);

  params->event.Set(
      event_fragment.is_null() ? nullptr : event_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event in WidgetInputHandler.DispatchEvent request");
  mojo::internal::MessageFragment<
      typename decltype(params->original_event_for_gesture)::BaseType> original_event_for_gesture_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::EventDataView>(
    in_original_event_for_gesture,
    original_event_for_gesture_fragment);

  params->original_event_for_gesture.Set(
      original_event_for_gesture_fragment.is_null() ? nullptr : original_event_for_gesture_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandler::Name_);
  message.set_method_name("DispatchEvent");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WidgetInputHandler_DispatchEvent_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WidgetInputHandlerProxy::DispatchNonBlockingEvent(
    ::std::unique_ptr<::blink::WebCoalescedInputEvent> in_event) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WidgetInputHandler::DispatchNonBlockingEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type ::std::unique_ptr<::blink::WebCoalescedInputEvent>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WidgetInputHandler::kDispatchNonBlockingEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandler_DispatchNonBlockingEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event)::BaseType> event_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::EventDataView>(
    in_event,
    event_fragment);

  params->event.Set(
      event_fragment.is_null() ? nullptr : event_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event in WidgetInputHandler.DispatchNonBlockingEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandler::Name_);
  message.set_method_name("DispatchNonBlockingEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WidgetInputHandlerProxy::WaitForInputProcessed(
    WaitForInputProcessedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::WidgetInputHandler::WaitForInputProcessed");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WidgetInputHandler::kWaitForInputProcessed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandler_WaitForInputProcessed_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandler::Name_);
  message.set_method_name("WaitForInputProcessed");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WidgetInputHandler_WaitForInputProcessed_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WidgetInputHandlerProxy::GetFrameWidgetInputHandler(
    ::mojo::PendingAssociatedReceiver<FrameWidgetInputHandler> in_interface_request) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WidgetInputHandler::GetFrameWidgetInputHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("interface_request"), in_interface_request,
                        "<value of type ::mojo::PendingAssociatedReceiver<FrameWidgetInputHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WidgetInputHandler::kGetFrameWidgetInputHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandler_GetFrameWidgetInputHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::FrameWidgetInputHandlerAssociatedRequestDataView>(
    in_interface_request,
    &params->interface_request,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->interface_request)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid interface_request in WidgetInputHandler.GetFrameWidgetInputHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandler::Name_);
  message.set_method_name("GetFrameWidgetInputHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WidgetInputHandlerProxy::UpdateBrowserControlsState(
    ::cc::BrowserControlsState in_constraints, ::cc::BrowserControlsState in_current, bool in_animate, const std::optional<::cc::BrowserControlsOffsetTagModifications>& in_offset_tag_modifications) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WidgetInputHandler::UpdateBrowserControlsState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("constraints"), in_constraints,
                        "<value of type ::cc::BrowserControlsState>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("current"), in_current,
                        "<value of type ::cc::BrowserControlsState>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("animate"), in_animate,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("offset_tag_modifications"), in_offset_tag_modifications,
                        "<value of type const std::optional<::cc::BrowserControlsOffsetTagModifications>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WidgetInputHandler::kUpdateBrowserControlsState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandler_UpdateBrowserControlsState_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::cc::mojom::BrowserControlsState>(
    in_constraints,
    &params->constraints);

  
  mojo::internal::Serialize<::cc::mojom::BrowserControlsState>(
    in_current,
    &params->current);

  params->animate = in_animate;
  mojo::internal::MessageFragment<
      typename decltype(params->offset_tag_modifications)::BaseType> offset_tag_modifications_fragment(
          params.message());
  
  mojo::internal::Serialize<::cc::mojom::BrowserControlsOffsetTagModificationsDataView>(
    in_offset_tag_modifications,
    offset_tag_modifications_fragment);

  params->offset_tag_modifications.Set(
      offset_tag_modifications_fragment.is_null() ? nullptr : offset_tag_modifications_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandler::Name_);
  message.set_method_name("UpdateBrowserControlsState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class WidgetInputHandler_ImeSetComposition_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WidgetInputHandler::ImeSetCompositionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WidgetInputHandler_ImeSetComposition_ProxyToResponder> proxy(
        new WidgetInputHandler_ImeSetComposition_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WidgetInputHandler_ImeSetComposition_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WidgetInputHandler_ImeSetComposition_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WidgetInputHandler_ImeSetComposition_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WidgetInputHandler::ImeSetCompositionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool WidgetInputHandler_ImeSetComposition_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WidgetInputHandler_ImeSetComposition_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WidgetInputHandler_ImeSetComposition_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WidgetInputHandler.4
  bool success = true;
  WidgetInputHandler_ImeSetComposition_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WidgetInputHandler::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void WidgetInputHandler_ImeSetComposition_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::WidgetInputHandler::ImeSetComposition");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WidgetInputHandler::kImeSetComposition), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandler_ImeSetComposition_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandler::Name_);
  message.set_method_name("ImeSetComposition");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WidgetInputHandler_ImeCommitText_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WidgetInputHandler::ImeCommitTextCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WidgetInputHandler_ImeCommitText_ProxyToResponder> proxy(
        new WidgetInputHandler_ImeCommitText_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WidgetInputHandler_ImeCommitText_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WidgetInputHandler_ImeCommitText_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WidgetInputHandler_ImeCommitText_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WidgetInputHandler::ImeCommitTextCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool WidgetInputHandler_ImeCommitText_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WidgetInputHandler_ImeCommitText_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WidgetInputHandler_ImeCommitText_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WidgetInputHandler.5
  bool success = true;
  WidgetInputHandler_ImeCommitText_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WidgetInputHandler::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void WidgetInputHandler_ImeCommitText_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::WidgetInputHandler::ImeCommitText");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WidgetInputHandler::kImeCommitText), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandler_ImeCommitText_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandler::Name_);
  message.set_method_name("ImeCommitText");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WidgetInputHandler_DispatchEvent_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WidgetInputHandler::DispatchEventCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WidgetInputHandler_DispatchEvent_ProxyToResponder> proxy(
        new WidgetInputHandler_DispatchEvent_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WidgetInputHandler_DispatchEvent_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WidgetInputHandler_DispatchEvent_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WidgetInputHandler_DispatchEvent_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WidgetInputHandler::DispatchEventCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::InputEventResultSource in_source, const ::ui::LatencyInfo& in_updated_latency, ::blink::mojom::blink::InputEventResultState in_state, DidOverscrollParamsPtr in_overscroll, TouchActionOptionalPtr in_touch_action);
};

bool WidgetInputHandler_DispatchEvent_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WidgetInputHandler_DispatchEvent_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WidgetInputHandler_DispatchEvent_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WidgetInputHandler.9
  bool success = true;
  ::blink::mojom::blink::InputEventResultSource p_source{};
  ::ui::LatencyInfo p_updated_latency{};
  ::blink::mojom::blink::InputEventResultState p_state{};
  DidOverscrollParamsPtr p_overscroll{};
  TouchActionOptionalPtr p_touch_action{};
  WidgetInputHandler_DispatchEvent_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSource(&p_source))
    success = false;
  if (success && !input_data_view.ReadUpdatedLatency(&p_updated_latency))
    success = false;
  if (success && !input_data_view.ReadState(&p_state))
    success = false;
  if (success && !input_data_view.ReadOverscroll(&p_overscroll))
    success = false;
  if (success && !input_data_view.ReadTouchAction(&p_touch_action))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WidgetInputHandler::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_source), 
std::move(p_updated_latency), 
std::move(p_state), 
std::move(p_overscroll), 
std::move(p_touch_action));
  }
  return true;
}

void WidgetInputHandler_DispatchEvent_ProxyToResponder::Run(
    ::blink::mojom::blink::InputEventResultSource in_source, const ::ui::LatencyInfo& in_updated_latency, ::blink::mojom::blink::InputEventResultState in_state, DidOverscrollParamsPtr in_overscroll, TouchActionOptionalPtr in_touch_action) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::WidgetInputHandler::DispatchEvent", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type ::blink::mojom::blink::InputEventResultSource>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("updated_latency"), in_updated_latency,
                        "<value of type const ::ui::LatencyInfo&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type ::blink::mojom::blink::InputEventResultState>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("overscroll"), in_overscroll,
                        "<value of type DidOverscrollParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("touch_action"), in_touch_action,
                        "<value of type TouchActionOptionalPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WidgetInputHandler::kDispatchEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandler_DispatchEvent_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::InputEventResultSource>(
    in_source,
    &params->source);
  mojo::internal::MessageFragment<
      typename decltype(params->updated_latency)::BaseType> updated_latency_fragment(
          params.message());
  
  mojo::internal::Serialize<::ui::mojom::LatencyInfoDataView>(
    in_updated_latency,
    updated_latency_fragment);

  params->updated_latency.Set(
      updated_latency_fragment.is_null() ? nullptr : updated_latency_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->updated_latency.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null updated_latency in ");

  
  mojo::internal::Serialize<::blink::mojom::InputEventResultState>(
    in_state,
    &params->state);
  mojo::internal::MessageFragment<
      typename decltype(params->overscroll)::BaseType> overscroll_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::DidOverscrollParamsDataView>(
    in_overscroll,
    overscroll_fragment);

  params->overscroll.Set(
      overscroll_fragment.is_null() ? nullptr : overscroll_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->touch_action)::BaseType> touch_action_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::TouchActionOptionalDataView>(
    in_touch_action,
    touch_action_fragment);

  params->touch_action.Set(
      touch_action_fragment.is_null() ? nullptr : touch_action_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandler::Name_);
  message.set_method_name("DispatchEvent");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WidgetInputHandler_WaitForInputProcessed_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WidgetInputHandler::WaitForInputProcessedCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WidgetInputHandler_WaitForInputProcessed_ProxyToResponder> proxy(
        new WidgetInputHandler_WaitForInputProcessed_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WidgetInputHandler_WaitForInputProcessed_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WidgetInputHandler_WaitForInputProcessed_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WidgetInputHandler_WaitForInputProcessed_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WidgetInputHandler::WaitForInputProcessedCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool WidgetInputHandler_WaitForInputProcessed_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WidgetInputHandler_WaitForInputProcessed_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WidgetInputHandler_WaitForInputProcessed_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WidgetInputHandler.11
  bool success = true;
  WidgetInputHandler_WaitForInputProcessed_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WidgetInputHandler::Name_, 11, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void WidgetInputHandler_WaitForInputProcessed_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::WidgetInputHandler::WaitForInputProcessed");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WidgetInputHandler::kWaitForInputProcessed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WidgetInputHandler_WaitForInputProcessed_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetInputHandler::Name_);
  message.set_method_name("WaitForInputProcessed");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WidgetInputHandlerStubDispatch::Accept(
    WidgetInputHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WidgetInputHandler>(message->header()->name)) {
    case messages::WidgetInputHandler::kSetFocus: {
      DCHECK(message->is_serialized());
      internal::WidgetInputHandler_SetFocus_Params_Data* params =
          reinterpret_cast<internal::WidgetInputHandler_SetFocus_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WidgetInputHandler.0
      bool success = true;
      FocusState p_state{};
      WidgetInputHandler_SetFocus_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetFocus(        
        std::move(p_state));
      return true;
    }
    case messages::WidgetInputHandler::kMouseCaptureLost: {
      DCHECK(message->is_serialized());
      internal::WidgetInputHandler_MouseCaptureLost_Params_Data* params =
          reinterpret_cast<internal::WidgetInputHandler_MouseCaptureLost_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WidgetInputHandler.1
      bool success = true;
      WidgetInputHandler_MouseCaptureLost_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MouseCaptureLost(        );
      return true;
    }
    case messages::WidgetInputHandler::kSetEditCommandsForNextKeyEvent: {
      DCHECK(message->is_serialized());
      internal::WidgetInputHandler_SetEditCommandsForNextKeyEvent_Params_Data* params =
          reinterpret_cast<internal::WidgetInputHandler_SetEditCommandsForNextKeyEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WidgetInputHandler.2
      bool success = true;
      ::blink::Vector<EditCommandPtr> p_commands{};
      WidgetInputHandler_SetEditCommandsForNextKeyEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCommands(&p_commands))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetEditCommandsForNextKeyEvent(        
        std::move(p_commands));
      return true;
    }
    case messages::WidgetInputHandler::kCursorVisibilityChanged: {
      DCHECK(message->is_serialized());
      internal::WidgetInputHandler_CursorVisibilityChanged_Params_Data* params =
          reinterpret_cast<internal::WidgetInputHandler_CursorVisibilityChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WidgetInputHandler.3
      bool success = true;
      bool p_visible{};
      WidgetInputHandler_CursorVisibilityChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_visible = input_data_view.visible();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandler::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CursorVisibilityChanged(        
        std::move(p_visible));
      return true;
    }
    case messages::WidgetInputHandler::kImeSetComposition: {
      break;
    }
    case messages::WidgetInputHandler::kImeCommitText: {
      break;
    }
    case messages::WidgetInputHandler::kImeFinishComposingText: {
      DCHECK(message->is_serialized());
      internal::WidgetInputHandler_ImeFinishComposingText_Params_Data* params =
          reinterpret_cast<internal::WidgetInputHandler_ImeFinishComposingText_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WidgetInputHandler.6
      bool success = true;
      bool p_keep_selection{};
      WidgetInputHandler_ImeFinishComposingText_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_keep_selection = input_data_view.keep_selection();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandler::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ImeFinishComposingText(        
        std::move(p_keep_selection));
      return true;
    }
    case messages::WidgetInputHandler::kRequestTextInputStateUpdate: {
      DCHECK(message->is_serialized());
      internal::WidgetInputHandler_RequestTextInputStateUpdate_Params_Data* params =
          reinterpret_cast<internal::WidgetInputHandler_RequestTextInputStateUpdate_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WidgetInputHandler.7
      bool success = true;
      WidgetInputHandler_RequestTextInputStateUpdate_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandler::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestTextInputStateUpdate(        );
      return true;
    }
    case messages::WidgetInputHandler::kRequestCompositionUpdates: {
      DCHECK(message->is_serialized());
      internal::WidgetInputHandler_RequestCompositionUpdates_Params_Data* params =
          reinterpret_cast<internal::WidgetInputHandler_RequestCompositionUpdates_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WidgetInputHandler.8
      bool success = true;
      bool p_immediate_request{};
      bool p_monitor_request{};
      WidgetInputHandler_RequestCompositionUpdates_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_immediate_request = input_data_view.immediate_request();
      if (success)
        p_monitor_request = input_data_view.monitor_request();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandler::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestCompositionUpdates(        
        std::move(p_immediate_request), 
        std::move(p_monitor_request));
      return true;
    }
    case messages::WidgetInputHandler::kDispatchEvent: {
      break;
    }
    case messages::WidgetInputHandler::kDispatchNonBlockingEvent: {
      DCHECK(message->is_serialized());
      internal::WidgetInputHandler_DispatchNonBlockingEvent_Params_Data* params =
          reinterpret_cast<internal::WidgetInputHandler_DispatchNonBlockingEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WidgetInputHandler.10
      bool success = true;
      ::std::unique_ptr<::blink::WebCoalescedInputEvent> p_event{};
      WidgetInputHandler_DispatchNonBlockingEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandler::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchNonBlockingEvent(        
        std::move(p_event));
      return true;
    }
    case messages::WidgetInputHandler::kWaitForInputProcessed: {
      break;
    }
    case messages::WidgetInputHandler::kGetFrameWidgetInputHandler: {
      DCHECK(message->is_serialized());
      internal::WidgetInputHandler_GetFrameWidgetInputHandler_Params_Data* params =
          reinterpret_cast<internal::WidgetInputHandler_GetFrameWidgetInputHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WidgetInputHandler.12
      bool success = true;
      ::mojo::PendingAssociatedReceiver<FrameWidgetInputHandler> p_interface_request{};
      WidgetInputHandler_GetFrameWidgetInputHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_interface_request =
            input_data_view.TakeInterfaceRequest<decltype(p_interface_request)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandler::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetFrameWidgetInputHandler(        
        std::move(p_interface_request));
      return true;
    }
    case messages::WidgetInputHandler::kUpdateBrowserControlsState: {
      DCHECK(message->is_serialized());
      internal::WidgetInputHandler_UpdateBrowserControlsState_Params_Data* params =
          reinterpret_cast<internal::WidgetInputHandler_UpdateBrowserControlsState_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WidgetInputHandler.13
      bool success = true;
      ::cc::BrowserControlsState p_constraints{};
      ::cc::BrowserControlsState p_current{};
      bool p_animate{};
      std::optional<::cc::BrowserControlsOffsetTagModifications> p_offset_tag_modifications{};
      WidgetInputHandler_UpdateBrowserControlsState_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConstraints(&p_constraints))
        success = false;
      if (success && !input_data_view.ReadCurrent(&p_current))
        success = false;
      if (success)
        p_animate = input_data_view.animate();
      if (success && !input_data_view.ReadOffsetTagModifications(&p_offset_tag_modifications))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandler::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateBrowserControlsState(        
        std::move(p_constraints), 
        std::move(p_current), 
        std::move(p_animate), 
        std::move(p_offset_tag_modifications));
      return true;
    }
  }
  return false;
}

// static
bool WidgetInputHandlerStubDispatch::AcceptWithResponder(
    WidgetInputHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WidgetInputHandler>(message->header()->name)) {
    case messages::WidgetInputHandler::kSetFocus: {
      break;
    }
    case messages::WidgetInputHandler::kMouseCaptureLost: {
      break;
    }
    case messages::WidgetInputHandler::kSetEditCommandsForNextKeyEvent: {
      break;
    }
    case messages::WidgetInputHandler::kCursorVisibilityChanged: {
      break;
    }
    case messages::WidgetInputHandler::kImeSetComposition: {
      internal::WidgetInputHandler_ImeSetComposition_Params_Data* params =
          reinterpret_cast<
              internal::WidgetInputHandler_ImeSetComposition_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WidgetInputHandler.4
      bool success = true;
      ::blink::String p_text{};
      ::blink::Vector<::ui::ImeTextSpan> p_ime_text_spans{};
      ::gfx::Range p_range{};
      int32_t p_start{};
      int32_t p_end{};
      WidgetInputHandler_ImeSetComposition_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadText(&p_text))
        success = false;
      if (success && !input_data_view.ReadImeTextSpans(&p_ime_text_spans))
        success = false;
      if (success && !input_data_view.ReadRange(&p_range))
        success = false;
      if (success)
        p_start = input_data_view.start();
      if (success)
        p_end = input_data_view.end();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandler::Name_, 4, false);
        return false;
      }
      auto callback =
          WidgetInputHandler_ImeSetComposition_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ImeSetComposition(        
        std::move(p_text), 
        std::move(p_ime_text_spans), 
        std::move(p_range), 
        std::move(p_start), 
        std::move(p_end), std::move(callback));
      return true;
    }
    case messages::WidgetInputHandler::kImeCommitText: {
      internal::WidgetInputHandler_ImeCommitText_Params_Data* params =
          reinterpret_cast<
              internal::WidgetInputHandler_ImeCommitText_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WidgetInputHandler.5
      bool success = true;
      ::blink::String p_text{};
      ::blink::Vector<::ui::ImeTextSpan> p_ime_text_spans{};
      ::gfx::Range p_range{};
      int32_t p_relative_cursor_position{};
      WidgetInputHandler_ImeCommitText_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadText(&p_text))
        success = false;
      if (success && !input_data_view.ReadImeTextSpans(&p_ime_text_spans))
        success = false;
      if (success && !input_data_view.ReadRange(&p_range))
        success = false;
      if (success)
        p_relative_cursor_position = input_data_view.relative_cursor_position();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandler::Name_, 5, false);
        return false;
      }
      auto callback =
          WidgetInputHandler_ImeCommitText_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ImeCommitText(        
        std::move(p_text), 
        std::move(p_ime_text_spans), 
        std::move(p_range), 
        std::move(p_relative_cursor_position), std::move(callback));
      return true;
    }
    case messages::WidgetInputHandler::kImeFinishComposingText: {
      break;
    }
    case messages::WidgetInputHandler::kRequestTextInputStateUpdate: {
      break;
    }
    case messages::WidgetInputHandler::kRequestCompositionUpdates: {
      break;
    }
    case messages::WidgetInputHandler::kDispatchEvent: {
      internal::WidgetInputHandler_DispatchEvent_Params_Data* params =
          reinterpret_cast<
              internal::WidgetInputHandler_DispatchEvent_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WidgetInputHandler.9
      bool success = true;
      ::std::unique_ptr<::blink::WebCoalescedInputEvent> p_event{};
      std::optional<::std::unique_ptr<::blink::WebCoalescedInputEvent>> p_original_event_for_gesture{};
      WidgetInputHandler_DispatchEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (success && !input_data_view.ReadOriginalEventForGesture(&p_original_event_for_gesture))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandler::Name_, 9, false);
        return false;
      }
      auto callback =
          WidgetInputHandler_DispatchEvent_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchEvent(        
        std::move(p_event), 
        std::move(p_original_event_for_gesture), std::move(callback));
      return true;
    }
    case messages::WidgetInputHandler::kDispatchNonBlockingEvent: {
      break;
    }
    case messages::WidgetInputHandler::kWaitForInputProcessed: {
      internal::WidgetInputHandler_WaitForInputProcessed_Params_Data* params =
          reinterpret_cast<
              internal::WidgetInputHandler_WaitForInputProcessed_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WidgetInputHandler.11
      bool success = true;
      WidgetInputHandler_WaitForInputProcessed_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetInputHandler::Name_, 11, false);
        return false;
      }
      auto callback =
          WidgetInputHandler_WaitForInputProcessed_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WaitForInputProcessed(std::move(callback));
      return true;
    }
    case messages::WidgetInputHandler::kGetFrameWidgetInputHandler: {
      break;
    }
    case messages::WidgetInputHandler::kUpdateBrowserControlsState: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWidgetInputHandlerValidationInfo[] = {
    { &internal::WidgetInputHandler_SetFocus_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WidgetInputHandler_MouseCaptureLost_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WidgetInputHandler_SetEditCommandsForNextKeyEvent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WidgetInputHandler_CursorVisibilityChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WidgetInputHandler_ImeSetComposition_Params_Data::Validate,
     &internal::WidgetInputHandler_ImeSetComposition_ResponseParams_Data::Validate},
    { &internal::WidgetInputHandler_ImeCommitText_Params_Data::Validate,
     &internal::WidgetInputHandler_ImeCommitText_ResponseParams_Data::Validate},
    { &internal::WidgetInputHandler_ImeFinishComposingText_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WidgetInputHandler_RequestTextInputStateUpdate_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WidgetInputHandler_RequestCompositionUpdates_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WidgetInputHandler_DispatchEvent_Params_Data::Validate,
     &internal::WidgetInputHandler_DispatchEvent_ResponseParams_Data::Validate},
    { &internal::WidgetInputHandler_DispatchNonBlockingEvent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WidgetInputHandler_WaitForInputProcessed_Params_Data::Validate,
     &internal::WidgetInputHandler_WaitForInputProcessed_ResponseParams_Data::Validate},
    { &internal::WidgetInputHandler_GetFrameWidgetInputHandler_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WidgetInputHandler_UpdateBrowserControlsState_Params_Data::Validate,
     nullptr /* no response */},
};

bool WidgetInputHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::WidgetInputHandler::Name_,
    kWidgetInputHandlerValidationInfo);
}

bool WidgetInputHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::WidgetInputHandler::Name_,
    kWidgetInputHandlerValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::KeyData::DataView, ::blink::mojom::blink::KeyDataPtr>::Read(
    ::blink::mojom::blink::KeyData::DataView input,
    ::blink::mojom::blink::KeyDataPtr* output) {
  bool success = true;
  ::blink::mojom::blink::KeyDataPtr result(::blink::mojom::blink::KeyData::New());
  
      if (success)
        result->dom_key = input.dom_key();
      if (success)
        result->dom_code = input.dom_code();
      if (success)
        result->windows_key_code = input.windows_key_code();
      if (success)
        result->native_key_code = input.native_key_code();
      if (success)
        result->is_system_key = input.is_system_key();
      if (success)
        result->is_browser_shortcut = input.is_browser_shortcut();
      if (success && !input.ReadText(&result->text))
        success = false;
      if (success && !input.ReadUnmodifiedText(&result->unmodified_text))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::PointerData::DataView, ::blink::mojom::blink::PointerDataPtr>::Read(
    ::blink::mojom::blink::PointerData::DataView input,
    ::blink::mojom::blink::PointerDataPtr* output) {
  bool success = true;
  ::blink::mojom::blink::PointerDataPtr result(::blink::mojom::blink::PointerData::New());
  
      if (success)
        result->pointer_id = input.pointer_id();
      if (success)
        result->force = input.force();
      if (success)
        result->tilt_x = input.tilt_x();
      if (success)
        result->tilt_y = input.tilt_y();
      if (success)
        result->tangential_pressure = input.tangential_pressure();
      if (success)
        result->twist = input.twist();
      if (success && !input.ReadButton(&result->button))
        success = false;
      if (success && !input.ReadPointerType(&result->pointer_type))
        success = false;
      if (success)
        result->movement_x = input.movement_x();
      if (success)
        result->movement_y = input.movement_y();
      if (success)
        result->is_raw_movement_event = input.is_raw_movement_event();
      if (success && !input.ReadWidgetPosition(&result->widget_position))
        success = false;
      if (success && !input.ReadScreenPosition(&result->screen_position))
        success = false;
      if (success && !input.ReadMouseData(&result->mouse_data))
        success = false;
      if (success)
        result->device_id = input.device_id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::WheelData::DataView, ::blink::mojom::blink::WheelDataPtr>::Read(
    ::blink::mojom::blink::WheelData::DataView input,
    ::blink::mojom::blink::WheelDataPtr* output) {
  bool success = true;
  ::blink::mojom::blink::WheelDataPtr result(::blink::mojom::blink::WheelData::New());
  
      if (success)
        result->delta_x = input.delta_x();
      if (success)
        result->delta_y = input.delta_y();
      if (success)
        result->wheel_ticks_x = input.wheel_ticks_x();
      if (success)
        result->wheel_ticks_y = input.wheel_ticks_y();
      if (success)
        result->acceleration_ratio_x = input.acceleration_ratio_x();
      if (success)
        result->acceleration_ratio_y = input.acceleration_ratio_y();
      if (success)
        result->phase = input.phase();
      if (success)
        result->momentum_phase = input.momentum_phase();
      if (success && !input.ReadCancelable(&result->cancelable))
        success = false;
      if (success)
        result->event_action = input.event_action();
      if (success)
        result->delta_units = input.delta_units();
      if (success)
        result->rails_mode = input.rails_mode();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::MouseData::DataView, ::blink::mojom::blink::MouseDataPtr>::Read(
    ::blink::mojom::blink::MouseData::DataView input,
    ::blink::mojom::blink::MouseDataPtr* output) {
  bool success = true;
  ::blink::mojom::blink::MouseDataPtr result(::blink::mojom::blink::MouseData::New());
  
      if (success)
        result->click_count = input.click_count();
      if (success && !input.ReadWheelData(&result->wheel_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::ScrollData::DataView, ::blink::mojom::blink::ScrollDataPtr>::Read(
    ::blink::mojom::blink::ScrollData::DataView input,
    ::blink::mojom::blink::ScrollDataPtr* output) {
  bool success = true;
  ::blink::mojom::blink::ScrollDataPtr result(::blink::mojom::blink::ScrollData::New());
  
      if (success)
        result->delta_x = input.delta_x();
      if (success)
        result->delta_y = input.delta_y();
      if (success && !input.ReadDeltaUnits(&result->delta_units))
        success = false;
      if (success)
        result->target_viewport = input.target_viewport();
      if (success && !input.ReadInertialPhase(&result->inertial_phase))
        success = false;
      if (success)
        result->synthetic = input.synthetic();
      if (success)
        result->pointer_count = input.pointer_count();
      if (success)
        result->cursor_control = input.cursor_control();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::PinchBeginData::DataView, ::blink::mojom::blink::PinchBeginDataPtr>::Read(
    ::blink::mojom::blink::PinchBeginData::DataView input,
    ::blink::mojom::blink::PinchBeginDataPtr* output) {
  bool success = true;
  ::blink::mojom::blink::PinchBeginDataPtr result(::blink::mojom::blink::PinchBeginData::New());
  
      if (success)
        result->needs_wheel_event = input.needs_wheel_event();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::PinchUpdateData::DataView, ::blink::mojom::blink::PinchUpdateDataPtr>::Read(
    ::blink::mojom::blink::PinchUpdateData::DataView input,
    ::blink::mojom::blink::PinchUpdateDataPtr* output) {
  bool success = true;
  ::blink::mojom::blink::PinchUpdateDataPtr result(::blink::mojom::blink::PinchUpdateData::New());
  
      if (success)
        result->scale = input.scale();
      if (success)
        result->zoom_disabled = input.zoom_disabled();
      if (success)
        result->needs_wheel_event = input.needs_wheel_event();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::PinchEndData::DataView, ::blink::mojom::blink::PinchEndDataPtr>::Read(
    ::blink::mojom::blink::PinchEndData::DataView input,
    ::blink::mojom::blink::PinchEndDataPtr* output) {
  bool success = true;
  ::blink::mojom::blink::PinchEndDataPtr result(::blink::mojom::blink::PinchEndData::New());
  
      if (success)
        result->needs_wheel_event = input.needs_wheel_event();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::FlingData::DataView, ::blink::mojom::blink::FlingDataPtr>::Read(
    ::blink::mojom::blink::FlingData::DataView input,
    ::blink::mojom::blink::FlingDataPtr* output) {
  bool success = true;
  ::blink::mojom::blink::FlingDataPtr result(::blink::mojom::blink::FlingData::New());
  
      if (success)
        result->velocity_x = input.velocity_x();
      if (success)
        result->velocity_y = input.velocity_y();
      if (success)
        result->target_viewport = input.target_viewport();
      if (success)
        result->prevent_boosting = input.prevent_boosting();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::TapData::DataView, ::blink::mojom::blink::TapDataPtr>::Read(
    ::blink::mojom::blink::TapData::DataView input,
    ::blink::mojom::blink::TapDataPtr* output) {
  bool success = true;
  ::blink::mojom::blink::TapDataPtr result(::blink::mojom::blink::TapData::New());
  
      if (success)
        result->tap_count = input.tap_count();
      if (success)
        result->needs_wheel_event = input.needs_wheel_event();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::TapDownData::DataView, ::blink::mojom::blink::TapDownDataPtr>::Read(
    ::blink::mojom::blink::TapDownData::DataView input,
    ::blink::mojom::blink::TapDownDataPtr* output) {
  bool success = true;
  ::blink::mojom::blink::TapDownDataPtr result(::blink::mojom::blink::TapDownData::New());
  
      if (success)
        result->tap_down_count = input.tap_down_count();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::GestureData::DataView, ::blink::mojom::blink::GestureDataPtr>::Read(
    ::blink::mojom::blink::GestureData::DataView input,
    ::blink::mojom::blink::GestureDataPtr* output) {
  bool success = true;
  ::blink::mojom::blink::GestureDataPtr result(::blink::mojom::blink::GestureData::New());
  
      if (success && !input.ReadScreenPosition(&result->screen_position))
        success = false;
      if (success && !input.ReadWidgetPosition(&result->widget_position))
        success = false;
      if (success && !input.ReadSourceDevice(&result->source_device))
        success = false;
      if (success)
        result->is_source_touch_event_set_blocking = input.is_source_touch_event_set_blocking();
      if (success && !input.ReadPrimaryPointerType(&result->primary_pointer_type))
        success = false;
      if (success)
        result->primary_unique_touch_event_id = input.primary_unique_touch_event_id();
      if (success)
        result->unique_touch_event_id = input.unique_touch_event_id();
      if (success && !input.ReadContactSize(&result->contact_size))
        success = false;
      if (success && !input.ReadScrollData(&result->scroll_data))
        success = false;
      if (success && !input.ReadPinchBeginData(&result->pinch_begin_data))
        success = false;
      if (success && !input.ReadPinchUpdateData(&result->pinch_update_data))
        success = false;
      if (success && !input.ReadPinchEndData(&result->pinch_end_data))
        success = false;
      if (success && !input.ReadTapData(&result->tap_data))
        success = false;
      if (success && !input.ReadTapDownData(&result->tap_down_data))
        success = false;
      if (success && !input.ReadFlingData(&result->fling_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::TouchPoint::DataView, ::blink::mojom::blink::TouchPointPtr>::Read(
    ::blink::mojom::blink::TouchPoint::DataView input,
    ::blink::mojom::blink::TouchPointPtr* output) {
  bool success = true;
  ::blink::mojom::blink::TouchPointPtr result(::blink::mojom::blink::TouchPoint::New());
  
      if (success && !input.ReadState(&result->state))
        success = false;
      if (success)
        result->radius_x = input.radius_x();
      if (success)
        result->radius_y = input.radius_y();
      if (success)
        result->rotation_angle = input.rotation_angle();
      if (success && !input.ReadPointerData(&result->pointer_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::TouchData::DataView, ::blink::mojom::blink::TouchDataPtr>::Read(
    ::blink::mojom::blink::TouchData::DataView input,
    ::blink::mojom::blink::TouchDataPtr* output) {
  bool success = true;
  ::blink::mojom::blink::TouchDataPtr result(::blink::mojom::blink::TouchData::New());
  
      if (success && !input.ReadCancelable(&result->cancelable))
        success = false;
      if (success)
        result->moved_beyond_slop_region = input.moved_beyond_slop_region();
      if (success)
        result->touch_start_or_first_move = input.touch_start_or_first_move();
      if (success)
        result->hovering = input.hovering();
      if (success)
        result->unique_touch_event_id = input.unique_touch_event_id();
      if (success && !input.ReadTouches(&result->touches))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::Event::DataView, ::blink::mojom::blink::EventPtr>::Read(
    ::blink::mojom::blink::Event::DataView input,
    ::blink::mojom::blink::EventPtr* output) {
  bool success = true;
  ::blink::mojom::blink::EventPtr result(::blink::mojom::blink::Event::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success)
        result->modifiers = input.modifiers();
      if (success && !input.ReadTimestamp(&result->timestamp))
        success = false;
      if (success && !input.ReadLatency(&result->latency))
        success = false;
      if (success && !input.ReadEventLatencyMetadata(&result->event_latency_metadata))
        success = false;
      if (success && !input.ReadKeyData(&result->key_data))
        success = false;
      if (success && !input.ReadPointerData(&result->pointer_data))
        success = false;
      if (success && !input.ReadGestureData(&result->gesture_data))
        success = false;
      if (success && !input.ReadTouchData(&result->touch_data))
        success = false;
      if (success && !input.ReadInputSource(&result->input_source))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::DidOverscrollParams::DataView, ::blink::mojom::blink::DidOverscrollParamsPtr>::Read(
    ::blink::mojom::blink::DidOverscrollParams::DataView input,
    ::blink::mojom::blink::DidOverscrollParamsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::DidOverscrollParamsPtr result(::blink::mojom::blink::DidOverscrollParams::New());
  
      if (success && !input.ReadAccumulatedOverscroll(&result->accumulated_overscroll))
        success = false;
      if (success && !input.ReadLatestOverscrollDelta(&result->latest_overscroll_delta))
        success = false;
      if (success && !input.ReadCurrentFlingVelocity(&result->current_fling_velocity))
        success = false;
      if (success && !input.ReadCausalEventViewportPoint(&result->causal_event_viewport_point))
        success = false;
      if (success && !input.ReadOverscrollBehavior(&result->overscroll_behavior))
        success = false;
      if (success && !input.ReadSourceDevice(&result->source_device))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::TouchActionOptional::DataView, ::blink::mojom::blink::TouchActionOptionalPtr>::Read(
    ::blink::mojom::blink::TouchActionOptional::DataView input,
    ::blink::mojom::blink::TouchActionOptionalPtr* output) {
  bool success = true;
  ::blink::mojom::blink::TouchActionOptionalPtr result(::blink::mojom::blink::TouchActionOptional::New());
  
      if (success && !input.ReadTouchAction(&result->touch_action))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::EditCommand::DataView, ::blink::mojom::blink::EditCommandPtr>::Read(
    ::blink::mojom::blink::EditCommand::DataView input,
    ::blink::mojom::blink::EditCommandPtr* output) {
  bool success = true;
  ::blink::mojom::blink::EditCommandPtr result(::blink::mojom::blink::EditCommand::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::SelectAroundCaretResult::DataView, ::blink::mojom::blink::SelectAroundCaretResultPtr>::Read(
    ::blink::mojom::blink::SelectAroundCaretResult::DataView input,
    ::blink::mojom::blink::SelectAroundCaretResultPtr* output) {
  bool success = true;
  ::blink::mojom::blink::SelectAroundCaretResultPtr result(::blink::mojom::blink::SelectAroundCaretResult::New());
  
      if (success)
        result->extended_start_adjust = input.extended_start_adjust();
      if (success)
        result->extended_end_adjust = input.extended_end_adjust();
      if (success)
        result->word_start_adjust = input.word_start_adjust();
      if (success)
        result->word_end_adjust = input.word_end_adjust();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void WidgetInputHandlerHostInterceptorForTesting::SetTouchActionFromMain(::cc::TouchAction touch_action) {
  GetForwardingInterface()->SetTouchActionFromMain(
    std::move(touch_action)
    );
}
void WidgetInputHandlerHostInterceptorForTesting::SetPanAction(PanAction pan_action) {
  GetForwardingInterface()->SetPanAction(
    std::move(pan_action)
    );
}
void WidgetInputHandlerHostInterceptorForTesting::DidOverscroll(DidOverscrollParamsPtr params) {
  GetForwardingInterface()->DidOverscroll(
    std::move(params)
    );
}
void WidgetInputHandlerHostInterceptorForTesting::DidStartScrollingViewport() {
  GetForwardingInterface()->DidStartScrollingViewport();
}
void WidgetInputHandlerHostInterceptorForTesting::ImeCancelComposition() {
  GetForwardingInterface()->ImeCancelComposition();
}
void WidgetInputHandlerHostInterceptorForTesting::ImeCompositionRangeChanged(const ::gfx::Range& range, const std::optional<::blink::Vector<::gfx::Rect>>& character_bounds) {
  GetForwardingInterface()->ImeCompositionRangeChanged(
    std::move(range)
    , 
    std::move(character_bounds)
    );
}
void WidgetInputHandlerHostInterceptorForTesting::SetMouseCapture(bool capture) {
  GetForwardingInterface()->SetMouseCapture(
    std::move(capture)
    );
}
void WidgetInputHandlerHostInterceptorForTesting::SetAutoscrollSelectionActiveInMainFrame(bool autoscroll_selection) {
  GetForwardingInterface()->SetAutoscrollSelectionActiveInMainFrame(
    std::move(autoscroll_selection)
    );
}
void WidgetInputHandlerHostInterceptorForTesting::RequestMouseLock(bool from_user_gesture, bool unadjusted_movement, RequestMouseLockCallback callback) {
  GetForwardingInterface()->RequestMouseLock(
    std::move(from_user_gesture)
    , 
    std::move(unadjusted_movement)
    , std::move(callback));
}
WidgetInputHandlerHostAsyncWaiter::WidgetInputHandlerHostAsyncWaiter(
    WidgetInputHandlerHost* proxy) : proxy_(proxy) {}

WidgetInputHandlerHostAsyncWaiter::~WidgetInputHandlerHostAsyncWaiter() = default;


void WidgetInputHandlerHostAsyncWaiter::RequestMouseLock(
    bool from_user_gesture, bool unadjusted_movement, ::blink::mojom::blink::PointerLockResult* out_result, ::mojo::PendingRemote<::blink::mojom::blink::PointerLockContext>* out_context) {
  base::RunLoop loop;
  proxy_->RequestMouseLock(
      std::move(from_user_gesture),
      std::move(unadjusted_movement),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::PointerLockResult* out_result
,
             ::mojo::PendingRemote<::blink::mojom::blink::PointerLockContext>* out_context
,
             ::blink::mojom::blink::PointerLockResult result,
             ::mojo::PendingRemote<::blink::mojom::blink::PointerLockContext> context) {*out_result = std::move(result);*out_context = std::move(context);
            loop->Quit();
          },
          &loop,
          out_result,
          out_context));
  loop.Run();
}






void FrameWidgetInputHandlerInterceptorForTesting::AddImeTextSpansToExistingText(uint32_t start, uint32_t end, const ::blink::Vector<::ui::ImeTextSpan>& ime_text_spans) {
  GetForwardingInterface()->AddImeTextSpansToExistingText(
    std::move(start)
    , 
    std::move(end)
    , 
    std::move(ime_text_spans)
    );
}
void FrameWidgetInputHandlerInterceptorForTesting::ClearImeTextSpansByType(uint32_t start, uint32_t end, ::ui::ImeTextSpan::Type type) {
  GetForwardingInterface()->ClearImeTextSpansByType(
    std::move(start)
    , 
    std::move(end)
    , 
    std::move(type)
    );
}
void FrameWidgetInputHandlerInterceptorForTesting::SetCompositionFromExistingText(int32_t start, int32_t end, const ::blink::Vector<::ui::ImeTextSpan>& ime_text_spans) {
  GetForwardingInterface()->SetCompositionFromExistingText(
    std::move(start)
    , 
    std::move(end)
    , 
    std::move(ime_text_spans)
    );
}
void FrameWidgetInputHandlerInterceptorForTesting::ExtendSelectionAndDelete(int32_t before, int32_t after) {
  GetForwardingInterface()->ExtendSelectionAndDelete(
    std::move(before)
    , 
    std::move(after)
    );
}
void FrameWidgetInputHandlerInterceptorForTesting::ExtendSelectionAndReplace(uint32_t before, uint32_t after, const ::blink::String& replacement_text) {
  GetForwardingInterface()->ExtendSelectionAndReplace(
    std::move(before)
    , 
    std::move(after)
    , 
    std::move(replacement_text)
    );
}
void FrameWidgetInputHandlerInterceptorForTesting::DeleteSurroundingText(int32_t before, int32_t after) {
  GetForwardingInterface()->DeleteSurroundingText(
    std::move(before)
    , 
    std::move(after)
    );
}
void FrameWidgetInputHandlerInterceptorForTesting::DeleteSurroundingTextInCodePoints(int32_t before, int32_t after) {
  GetForwardingInterface()->DeleteSurroundingTextInCodePoints(
    std::move(before)
    , 
    std::move(after)
    );
}
void FrameWidgetInputHandlerInterceptorForTesting::SetEditableSelectionOffsets(int32_t start, int32_t end) {
  GetForwardingInterface()->SetEditableSelectionOffsets(
    std::move(start)
    , 
    std::move(end)
    );
}
void FrameWidgetInputHandlerInterceptorForTesting::HandleStylusWritingGestureAction(::blink::mojom::blink::StylusWritingGestureDataPtr gesture_data, HandleStylusWritingGestureActionCallback callback) {
  GetForwardingInterface()->HandleStylusWritingGestureAction(
    std::move(gesture_data)
    , std::move(callback));
}
void FrameWidgetInputHandlerInterceptorForTesting::ExecuteEditCommand(const ::blink::String& command, const ::blink::String& value) {
  GetForwardingInterface()->ExecuteEditCommand(
    std::move(command)
    , 
    std::move(value)
    );
}
void FrameWidgetInputHandlerInterceptorForTesting::Undo() {
  GetForwardingInterface()->Undo();
}
void FrameWidgetInputHandlerInterceptorForTesting::Redo() {
  GetForwardingInterface()->Redo();
}
void FrameWidgetInputHandlerInterceptorForTesting::Cut() {
  GetForwardingInterface()->Cut();
}
void FrameWidgetInputHandlerInterceptorForTesting::Copy() {
  GetForwardingInterface()->Copy();
}
void FrameWidgetInputHandlerInterceptorForTesting::CopyToFindPboard() {
  GetForwardingInterface()->CopyToFindPboard();
}
void FrameWidgetInputHandlerInterceptorForTesting::CenterSelection() {
  GetForwardingInterface()->CenterSelection();
}
void FrameWidgetInputHandlerInterceptorForTesting::Paste() {
  GetForwardingInterface()->Paste();
}
void FrameWidgetInputHandlerInterceptorForTesting::PasteAndMatchStyle() {
  GetForwardingInterface()->PasteAndMatchStyle();
}
void FrameWidgetInputHandlerInterceptorForTesting::Delete() {
  GetForwardingInterface()->Delete();
}
void FrameWidgetInputHandlerInterceptorForTesting::SelectAll() {
  GetForwardingInterface()->SelectAll();
}
void FrameWidgetInputHandlerInterceptorForTesting::CollapseSelection() {
  GetForwardingInterface()->CollapseSelection();
}
void FrameWidgetInputHandlerInterceptorForTesting::CopyWithConfirmation(int32_t token, CopyWithConfirmationCallback callback) {
  GetForwardingInterface()->CopyWithConfirmation(
    std::move(token)
    , std::move(callback));
}
void FrameWidgetInputHandlerInterceptorForTesting::PasteWithConfirmation(int32_t token, PasteWithConfirmationCallback callback) {
  GetForwardingInterface()->PasteWithConfirmation(
    std::move(token)
    , std::move(callback));
}
void FrameWidgetInputHandlerInterceptorForTesting::Replace(const ::blink::String& word) {
  GetForwardingInterface()->Replace(
    std::move(word)
    );
}
void FrameWidgetInputHandlerInterceptorForTesting::ReplaceMisspelling(const ::blink::String& word) {
  GetForwardingInterface()->ReplaceMisspelling(
    std::move(word)
    );
}
void FrameWidgetInputHandlerInterceptorForTesting::SelectRange(const ::gfx::Point& base, const ::gfx::Point& extent) {
  GetForwardingInterface()->SelectRange(
    std::move(base)
    , 
    std::move(extent)
    );
}
void FrameWidgetInputHandlerInterceptorForTesting::AdjustSelectionByCharacterOffset(int32_t start, int32_t end, ::blink::mojom::blink::SelectionMenuBehavior behavior) {
  GetForwardingInterface()->AdjustSelectionByCharacterOffset(
    std::move(start)
    , 
    std::move(end)
    , 
    std::move(behavior)
    );
}
void FrameWidgetInputHandlerInterceptorForTesting::SelectAroundCaret(SelectionGranularity granularity, bool should_show_handle, bool should_show_context_menu, SelectAroundCaretCallback callback) {
  GetForwardingInterface()->SelectAroundCaret(
    std::move(granularity)
    , 
    std::move(should_show_handle)
    , 
    std::move(should_show_context_menu)
    , std::move(callback));
}
void FrameWidgetInputHandlerInterceptorForTesting::MoveRangeSelectionExtent(const ::gfx::Point& extent) {
  GetForwardingInterface()->MoveRangeSelectionExtent(
    std::move(extent)
    );
}
void FrameWidgetInputHandlerInterceptorForTesting::ScrollFocusedEditableNodeIntoView() {
  GetForwardingInterface()->ScrollFocusedEditableNodeIntoView();
}
void FrameWidgetInputHandlerInterceptorForTesting::WaitForPageScaleAnimationForTesting(WaitForPageScaleAnimationForTestingCallback callback) {
  GetForwardingInterface()->WaitForPageScaleAnimationForTesting(std::move(callback));
}
void FrameWidgetInputHandlerInterceptorForTesting::MoveCaret(const ::gfx::Point& point) {
  GetForwardingInterface()->MoveCaret(
    std::move(point)
    );
}
FrameWidgetInputHandlerAsyncWaiter::FrameWidgetInputHandlerAsyncWaiter(
    FrameWidgetInputHandler* proxy) : proxy_(proxy) {}

FrameWidgetInputHandlerAsyncWaiter::~FrameWidgetInputHandlerAsyncWaiter() = default;


void FrameWidgetInputHandlerAsyncWaiter::HandleStylusWritingGestureAction(
    ::blink::mojom::blink::StylusWritingGestureDataPtr gesture_data, ::blink::mojom::blink::HandwritingGestureResult* out_result) {
  base::RunLoop loop;
  proxy_->HandleStylusWritingGestureAction(
      std::move(gesture_data),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::HandwritingGestureResult* out_result
,
             ::blink::mojom::blink::HandwritingGestureResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

::blink::mojom::blink::HandwritingGestureResult FrameWidgetInputHandlerAsyncWaiter::HandleStylusWritingGestureAction(
    ::blink::mojom::blink::StylusWritingGestureDataPtr gesture_data) {
  ::blink::mojom::blink::HandwritingGestureResult async_wait_result;
  HandleStylusWritingGestureAction(std::move(gesture_data),&async_wait_result);
  return async_wait_result;
}

void FrameWidgetInputHandlerAsyncWaiter::CopyWithConfirmation(
    int32_t token, int32_t* out_token) {
  base::RunLoop loop;
  proxy_->CopyWithConfirmation(
      std::move(token),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_token
,
             int32_t token) {*out_token = std::move(token);
            loop->Quit();
          },
          &loop,
          out_token));
  loop.Run();
}

int32_t FrameWidgetInputHandlerAsyncWaiter::CopyWithConfirmation(
    int32_t token) {
  int32_t async_wait_result;
  CopyWithConfirmation(std::move(token),&async_wait_result);
  return async_wait_result;
}

void FrameWidgetInputHandlerAsyncWaiter::PasteWithConfirmation(
    int32_t token, int32_t* out_token) {
  base::RunLoop loop;
  proxy_->PasteWithConfirmation(
      std::move(token),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_token
,
             int32_t token) {*out_token = std::move(token);
            loop->Quit();
          },
          &loop,
          out_token));
  loop.Run();
}

int32_t FrameWidgetInputHandlerAsyncWaiter::PasteWithConfirmation(
    int32_t token) {
  int32_t async_wait_result;
  PasteWithConfirmation(std::move(token),&async_wait_result);
  return async_wait_result;
}

void FrameWidgetInputHandlerAsyncWaiter::SelectAroundCaret(
    SelectionGranularity granularity, bool should_show_handle, bool should_show_context_menu, SelectAroundCaretResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->SelectAroundCaret(
      std::move(granularity),
      std::move(should_show_handle),
      std::move(should_show_context_menu),
      base::BindOnce(
          [](base::RunLoop* loop,
             SelectAroundCaretResultPtr* out_result
,
             SelectAroundCaretResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

SelectAroundCaretResultPtr FrameWidgetInputHandlerAsyncWaiter::SelectAroundCaret(
    SelectionGranularity granularity, bool should_show_handle, bool should_show_context_menu) {
  SelectAroundCaretResultPtr async_wait_result;
  SelectAroundCaret(std::move(granularity),std::move(should_show_handle),std::move(should_show_context_menu),&async_wait_result);
  return async_wait_result;
}

void FrameWidgetInputHandlerAsyncWaiter::WaitForPageScaleAnimationForTesting(
    ) {
  base::RunLoop loop;
  proxy_->WaitForPageScaleAnimationForTesting(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






void WidgetInputHandlerInterceptorForTesting::SetFocus(FocusState state) {
  GetForwardingInterface()->SetFocus(
    std::move(state)
    );
}
void WidgetInputHandlerInterceptorForTesting::MouseCaptureLost() {
  GetForwardingInterface()->MouseCaptureLost();
}
void WidgetInputHandlerInterceptorForTesting::SetEditCommandsForNextKeyEvent(::blink::Vector<EditCommandPtr> commands) {
  GetForwardingInterface()->SetEditCommandsForNextKeyEvent(
    std::move(commands)
    );
}
void WidgetInputHandlerInterceptorForTesting::CursorVisibilityChanged(bool visible) {
  GetForwardingInterface()->CursorVisibilityChanged(
    std::move(visible)
    );
}
void WidgetInputHandlerInterceptorForTesting::ImeSetComposition(const ::blink::String& text, const ::blink::Vector<::ui::ImeTextSpan>& ime_text_spans, const ::gfx::Range& range, int32_t start, int32_t end, ImeSetCompositionCallback callback) {
  GetForwardingInterface()->ImeSetComposition(
    std::move(text)
    , 
    std::move(ime_text_spans)
    , 
    std::move(range)
    , 
    std::move(start)
    , 
    std::move(end)
    , std::move(callback));
}
void WidgetInputHandlerInterceptorForTesting::ImeCommitText(const ::blink::String& text, const ::blink::Vector<::ui::ImeTextSpan>& ime_text_spans, const ::gfx::Range& range, int32_t relative_cursor_position, ImeCommitTextCallback callback) {
  GetForwardingInterface()->ImeCommitText(
    std::move(text)
    , 
    std::move(ime_text_spans)
    , 
    std::move(range)
    , 
    std::move(relative_cursor_position)
    , std::move(callback));
}
void WidgetInputHandlerInterceptorForTesting::ImeFinishComposingText(bool keep_selection) {
  GetForwardingInterface()->ImeFinishComposingText(
    std::move(keep_selection)
    );
}
void WidgetInputHandlerInterceptorForTesting::RequestTextInputStateUpdate() {
  GetForwardingInterface()->RequestTextInputStateUpdate();
}
void WidgetInputHandlerInterceptorForTesting::RequestCompositionUpdates(bool immediate_request, bool monitor_request) {
  GetForwardingInterface()->RequestCompositionUpdates(
    std::move(immediate_request)
    , 
    std::move(monitor_request)
    );
}
void WidgetInputHandlerInterceptorForTesting::DispatchEvent(::std::unique_ptr<::blink::WebCoalescedInputEvent> event, std::optional<::std::unique_ptr<::blink::WebCoalescedInputEvent>> original_event_for_gesture, DispatchEventCallback callback) {
  GetForwardingInterface()->DispatchEvent(
    std::move(event)
    , 
    std::move(original_event_for_gesture)
    , std::move(callback));
}
void WidgetInputHandlerInterceptorForTesting::DispatchNonBlockingEvent(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) {
  GetForwardingInterface()->DispatchNonBlockingEvent(
    std::move(event)
    );
}
void WidgetInputHandlerInterceptorForTesting::WaitForInputProcessed(WaitForInputProcessedCallback callback) {
  GetForwardingInterface()->WaitForInputProcessed(std::move(callback));
}
void WidgetInputHandlerInterceptorForTesting::GetFrameWidgetInputHandler(::mojo::PendingAssociatedReceiver<FrameWidgetInputHandler> interface_request) {
  GetForwardingInterface()->GetFrameWidgetInputHandler(
    std::move(interface_request)
    );
}
void WidgetInputHandlerInterceptorForTesting::UpdateBrowserControlsState(::cc::BrowserControlsState constraints, ::cc::BrowserControlsState current, bool animate, const std::optional<::cc::BrowserControlsOffsetTagModifications>& offset_tag_modifications) {
  GetForwardingInterface()->UpdateBrowserControlsState(
    std::move(constraints)
    , 
    std::move(current)
    , 
    std::move(animate)
    , 
    std::move(offset_tag_modifications)
    );
}
WidgetInputHandlerAsyncWaiter::WidgetInputHandlerAsyncWaiter(
    WidgetInputHandler* proxy) : proxy_(proxy) {}

WidgetInputHandlerAsyncWaiter::~WidgetInputHandlerAsyncWaiter() = default;


void WidgetInputHandlerAsyncWaiter::ImeSetComposition(
    const ::blink::String& text, const ::blink::Vector<::ui::ImeTextSpan>& ime_text_spans, const ::gfx::Range& range, int32_t start, int32_t end) {
  base::RunLoop loop;
  proxy_->ImeSetComposition(
      std::move(text),
      std::move(ime_text_spans),
      std::move(range),
      std::move(start),
      std::move(end),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void WidgetInputHandlerAsyncWaiter::ImeCommitText(
    const ::blink::String& text, const ::blink::Vector<::ui::ImeTextSpan>& ime_text_spans, const ::gfx::Range& range, int32_t relative_cursor_position) {
  base::RunLoop loop;
  proxy_->ImeCommitText(
      std::move(text),
      std::move(ime_text_spans),
      std::move(range),
      std::move(relative_cursor_position),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void WidgetInputHandlerAsyncWaiter::DispatchEvent(
    ::std::unique_ptr<::blink::WebCoalescedInputEvent> event, std::optional<::std::unique_ptr<::blink::WebCoalescedInputEvent>> original_event_for_gesture, ::blink::mojom::blink::InputEventResultSource* out_source, ::ui::LatencyInfo* out_updated_latency, ::blink::mojom::blink::InputEventResultState* out_state, DidOverscrollParamsPtr* out_overscroll, TouchActionOptionalPtr* out_touch_action) {
  base::RunLoop loop;
  proxy_->DispatchEvent(
      std::move(event),
      std::move(original_event_for_gesture),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::InputEventResultSource* out_source
,
             ::ui::LatencyInfo* out_updated_latency
,
             ::blink::mojom::blink::InputEventResultState* out_state
,
             DidOverscrollParamsPtr* out_overscroll
,
             TouchActionOptionalPtr* out_touch_action
,
             ::blink::mojom::blink::InputEventResultSource source,
             const ::ui::LatencyInfo& updated_latency,
             ::blink::mojom::blink::InputEventResultState state,
             DidOverscrollParamsPtr overscroll,
             TouchActionOptionalPtr touch_action) {*out_source = std::move(source);*out_updated_latency = std::move(updated_latency);*out_state = std::move(state);*out_overscroll = std::move(overscroll);*out_touch_action = std::move(touch_action);
            loop->Quit();
          },
          &loop,
          out_source,
          out_updated_latency,
          out_state,
          out_overscroll,
          out_touch_action));
  loop.Run();
}



void WidgetInputHandlerAsyncWaiter::WaitForInputProcessed(
    ) {
  base::RunLoop loop;
  proxy_->WaitForInputProcessed(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}








}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif