// third_party/blink/public/mojom/input/ime_host.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/input/ime_host.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/input/ime_host.mojom-params-data.h"
#include "third_party/blink/public/mojom/input/ime_host.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/input/ime_host.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/input/ime_host.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
EditorBoundsInfo::EditorBoundsInfo()
    : editor_bounds(),
      handwriting_bounds() {}

EditorBoundsInfo::EditorBoundsInfo(
    const ::gfx::RectF& editor_bounds_in,
    const ::gfx::RectF& handwriting_bounds_in)
    : editor_bounds(std::move(editor_bounds_in)),
      handwriting_bounds(std::move(handwriting_bounds_in)) {}

EditorBoundsInfo::~EditorBoundsInfo() = default;

void EditorBoundsInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "editor_bounds"), this->editor_bounds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::RectF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "handwriting_bounds"), this->handwriting_bounds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::RectF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool EditorBoundsInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TextAppearanceInfo::TextAppearanceInfo()
    : text_color() {}

TextAppearanceInfo::TextAppearanceInfo(
    ::SkColor text_color_in)
    : text_color(std::move(text_color_in)) {}

TextAppearanceInfo::~TextAppearanceInfo() = default;

void TextAppearanceInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text_color"), this->text_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::SkColor>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TextAppearanceInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
InputCursorAnchorInfo::InputCursorAnchorInfo()
    : character_bounds(),
      editor_bounds_info(),
      text_appearance_info(),
      visible_line_bounds(),
      requested() {}

InputCursorAnchorInfo::InputCursorAnchorInfo(
    ::blink::Vector<::gfx::Rect> character_bounds_in,
    EditorBoundsInfoPtr editor_bounds_info_in,
    TextAppearanceInfoPtr text_appearance_info_in,
    ::blink::Vector<::gfx::Rect> visible_line_bounds_in,
    bool requested_in)
    : character_bounds(std::move(character_bounds_in)),
      editor_bounds_info(std::move(editor_bounds_info_in)),
      text_appearance_info(std::move(text_appearance_info_in)),
      visible_line_bounds(std::move(visible_line_bounds_in)),
      requested(std::move(requested_in)) {}

InputCursorAnchorInfo::~InputCursorAnchorInfo() = default;

void InputCursorAnchorInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "character_bounds"), this->character_bounds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::gfx::Rect>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "editor_bounds_info"), this->editor_bounds_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type EditorBoundsInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text_appearance_info"), this->text_appearance_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TextAppearanceInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visible_line_bounds"), this->visible_line_bounds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::gfx::Rect>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "requested"), this->requested,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool InputCursorAnchorInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

ImeRenderWidgetHost::IPCStableHashFunction ImeRenderWidgetHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ImeRenderWidgetHost>(message.name())) {
    case messages::ImeRenderWidgetHost::kUpdateCursorAnchorInfo: {
      return &ImeRenderWidgetHost::UpdateCursorAnchorInfo_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ImeRenderWidgetHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ImeRenderWidgetHost>(message.name())) {
      case messages::ImeRenderWidgetHost::kUpdateCursorAnchorInfo:
            return "Receive blink::mojom::ImeRenderWidgetHost::UpdateCursorAnchorInfo";
    }
  } else {
    switch (static_cast<messages::ImeRenderWidgetHost>(message.name())) {
      case messages::ImeRenderWidgetHost::kUpdateCursorAnchorInfo:
            return "Receive reply blink::mojom::ImeRenderWidgetHost::UpdateCursorAnchorInfo";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ImeRenderWidgetHost::UpdateCursorAnchorInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd831835c;  // IPCStableHash for blink::mojom::ImeRenderWidgetHost::UpdateCursorAnchorInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ImeRenderWidgetHostProxy::ImeRenderWidgetHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ImeRenderWidgetHostProxy::UpdateCursorAnchorInfo(
    InputCursorAnchorInfoPtr in_cursor_anchor_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ImeRenderWidgetHost::UpdateCursorAnchorInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cursor_anchor_info"), in_cursor_anchor_info,
                        "<value of type InputCursorAnchorInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ImeRenderWidgetHost::kUpdateCursorAnchorInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ImeRenderWidgetHost_UpdateCursorAnchorInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->cursor_anchor_info)::BaseType> cursor_anchor_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::InputCursorAnchorInfoDataView>(
    in_cursor_anchor_info,
    cursor_anchor_info_fragment);

  params->cursor_anchor_info.Set(
      cursor_anchor_info_fragment.is_null() ? nullptr : cursor_anchor_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cursor_anchor_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cursor_anchor_info in ImeRenderWidgetHost.UpdateCursorAnchorInfo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ImeRenderWidgetHost::Name_);
  message.set_method_name("UpdateCursorAnchorInfo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ImeRenderWidgetHostStubDispatch::Accept(
    ImeRenderWidgetHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ImeRenderWidgetHost>(message->header()->name)) {
    case messages::ImeRenderWidgetHost::kUpdateCursorAnchorInfo: {
      DCHECK(message->is_serialized());
      internal::ImeRenderWidgetHost_UpdateCursorAnchorInfo_Params_Data* params =
          reinterpret_cast<internal::ImeRenderWidgetHost_UpdateCursorAnchorInfo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ImeRenderWidgetHost.0
      bool success = true;
      InputCursorAnchorInfoPtr p_cursor_anchor_info{};
      ImeRenderWidgetHost_UpdateCursorAnchorInfo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCursorAnchorInfo(&p_cursor_anchor_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ImeRenderWidgetHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateCursorAnchorInfo(        
        std::move(p_cursor_anchor_info));
      return true;
    }
  }
  return false;
}

// static
bool ImeRenderWidgetHostStubDispatch::AcceptWithResponder(
    ImeRenderWidgetHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ImeRenderWidgetHost>(message->header()->name)) {
    case messages::ImeRenderWidgetHost::kUpdateCursorAnchorInfo: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kImeRenderWidgetHostValidationInfo[] = {
    { &internal::ImeRenderWidgetHost_UpdateCursorAnchorInfo_Params_Data::Validate,
     nullptr /* no response */},
};

bool ImeRenderWidgetHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::ImeRenderWidgetHost::Name_,
    kImeRenderWidgetHostValidationInfo);
}



}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::EditorBoundsInfo::DataView, ::blink::mojom::blink::EditorBoundsInfoPtr>::Read(
    ::blink::mojom::blink::EditorBoundsInfo::DataView input,
    ::blink::mojom::blink::EditorBoundsInfoPtr* output) {
  bool success = true;
  ::blink::mojom::blink::EditorBoundsInfoPtr result(::blink::mojom::blink::EditorBoundsInfo::New());
  
      if (success && !input.ReadEditorBounds(&result->editor_bounds))
        success = false;
      if (success && !input.ReadHandwritingBounds(&result->handwriting_bounds))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::TextAppearanceInfo::DataView, ::blink::mojom::blink::TextAppearanceInfoPtr>::Read(
    ::blink::mojom::blink::TextAppearanceInfo::DataView input,
    ::blink::mojom::blink::TextAppearanceInfoPtr* output) {
  bool success = true;
  ::blink::mojom::blink::TextAppearanceInfoPtr result(::blink::mojom::blink::TextAppearanceInfo::New());
  
      if (success && !input.ReadTextColor(&result->text_color))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::InputCursorAnchorInfo::DataView, ::blink::mojom::blink::InputCursorAnchorInfoPtr>::Read(
    ::blink::mojom::blink::InputCursorAnchorInfo::DataView input,
    ::blink::mojom::blink::InputCursorAnchorInfoPtr* output) {
  bool success = true;
  ::blink::mojom::blink::InputCursorAnchorInfoPtr result(::blink::mojom::blink::InputCursorAnchorInfo::New());
  
      if (success && !input.ReadCharacterBounds(&result->character_bounds))
        success = false;
      if (success && !input.ReadEditorBoundsInfo(&result->editor_bounds_info))
        success = false;
      if (success && !input.ReadTextAppearanceInfo(&result->text_appearance_info))
        success = false;
      if (success && !input.ReadVisibleLineBounds(&result->visible_line_bounds))
        success = false;
      if (success)
        result->requested = input.requested();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void ImeRenderWidgetHostInterceptorForTesting::UpdateCursorAnchorInfo(InputCursorAnchorInfoPtr cursor_anchor_info) {
  GetForwardingInterface()->UpdateCursorAnchorInfo(
    std::move(cursor_anchor_info)
    );
}
ImeRenderWidgetHostAsyncWaiter::ImeRenderWidgetHostAsyncWaiter(
    ImeRenderWidgetHost* proxy) : proxy_(proxy) {}

ImeRenderWidgetHostAsyncWaiter::~ImeRenderWidgetHostAsyncWaiter() = default;







}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif