// third_party/blink/public/mojom/indexeddb/indexeddb.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INDEXEDDB_INDEXEDDB_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INDEXEDDB_INDEXEDDB_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/indexeddb/indexeddb.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/indexeddb/indexeddb.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/indexeddb/indexeddb.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-forward.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_transfer_token.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/indexeddb/indexeddb_key.h"
#include "third_party/blink/public/common/indexeddb/indexeddb_key_path.h"
#include "third_party/blink/public/common/indexeddb/indexeddb_key_range.h"
#include "third_party/blink/public/common/indexeddb/indexeddb_metadata.h"
#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class IDBFactoryClientProxy;

template <typename ImplRefTraits>
class IDBFactoryClientStub;

class IDBFactoryClientRequestValidator;


class BLINK_COMMON_EXPORT IDBFactoryClient
    : public IDBFactoryClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.IDBFactoryClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = IDBFactoryClientInterfaceBase;
  using Proxy_ = IDBFactoryClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = IDBFactoryClientStub<ImplRefTraits>;

  using RequestValidator_ = IDBFactoryClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kErrorMinVersion = 0,
    kBlockedMinVersion = 0,
    kUpgradeNeededMinVersion = 0,
    kOpenSuccessMinVersion = 0,
    kDeleteSuccessMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Error_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Blocked_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpgradeNeeded_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenSuccess_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteSuccess_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~IDBFactoryClient() = default;

  virtual void Error(IDBException code, const ::std::u16string& message) = 0;

  virtual void Blocked(int64_t existing_version) = 0;

  virtual void UpgradeNeeded(::mojo::PendingAssociatedRemote<IDBDatabase> pending_database, int64_t old_version, IDBDataLoss data_loss, const std::string& data_loss_message, const ::blink::IndexedDBDatabaseMetadata& db_metadata) = 0;

  virtual void OpenSuccess(::mojo::PendingAssociatedRemote<IDBDatabase> pending_database, const ::blink::IndexedDBDatabaseMetadata& metadata) = 0;

  virtual void DeleteSuccess(int64_t old_version) = 0;
};

class IDBDatabaseCallbacksProxy;

template <typename ImplRefTraits>
class IDBDatabaseCallbacksStub;

class IDBDatabaseCallbacksRequestValidator;


class BLINK_COMMON_EXPORT IDBDatabaseCallbacks
    : public IDBDatabaseCallbacksInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.IDBDatabaseCallbacks";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = IDBDatabaseCallbacksInterfaceBase;
  using Proxy_ = IDBDatabaseCallbacksProxy;

  template <typename ImplRefTraits>
  using Stub_ = IDBDatabaseCallbacksStub<ImplRefTraits>;

  using RequestValidator_ = IDBDatabaseCallbacksRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kForcedCloseMinVersion = 0,
    kVersionChangeMinVersion = 0,
    kAbortMinVersion = 0,
    kCompleteMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ForcedClose_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct VersionChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Abort_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Complete_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~IDBDatabaseCallbacks() = default;

  virtual void ForcedClose() = 0;

  virtual void VersionChange(int64_t old_version, int64_t new_version) = 0;

  virtual void Abort(int64_t transaction_id, IDBException code, const ::std::u16string& message) = 0;

  virtual void Complete(int64_t transaction_id) = 0;
};

class IDBCursorProxy;

template <typename ImplRefTraits>
class IDBCursorStub;

class IDBCursorRequestValidator;
class IDBCursorResponseValidator;


class BLINK_COMMON_EXPORT IDBCursor
    : public IDBCursorInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.IDBCursor";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = IDBCursorInterfaceBase;
  using Proxy_ = IDBCursorProxy;

  template <typename ImplRefTraits>
  using Stub_ = IDBCursorStub<ImplRefTraits>;

  using RequestValidator_ = IDBCursorRequestValidator;
  using ResponseValidator_ = IDBCursorResponseValidator;
  enum MethodMinVersions : uint32_t {
    kAdvanceMinVersion = 0,
    kContinueMinVersion = 0,
    kPrefetchMinVersion = 0,
    kPrefetchResetMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Advance_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Continue_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Prefetch_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PrefetchReset_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~IDBCursor() = default;

  using AdvanceCallback = base::OnceCallback<void(IDBCursorResultPtr)>;
  using AdvanceMojoCallback = base::OnceCallback<void(IDBCursorResultPtr)>;

  virtual void Advance(uint32_t count, AdvanceCallback callback) = 0;

  using ContinueCallback = base::OnceCallback<void(IDBCursorResultPtr)>;
  using ContinueMojoCallback = base::OnceCallback<void(IDBCursorResultPtr)>;

  virtual void Continue(::blink::IndexedDBKey key, ::blink::IndexedDBKey primary_key, ContinueCallback callback) = 0;

  using PrefetchCallback = base::OnceCallback<void(IDBCursorResultPtr)>;
  using PrefetchMojoCallback = base::OnceCallback<void(IDBCursorResultPtr)>;

  virtual void Prefetch(int32_t count, PrefetchCallback callback) = 0;

  virtual void PrefetchReset(int32_t used_prefetches) = 0;
};

class IDBTransactionProxy;

template <typename ImplRefTraits>
class IDBTransactionStub;

class IDBTransactionRequestValidator;
class IDBTransactionResponseValidator;


class BLINK_COMMON_EXPORT IDBTransaction
    : public IDBTransactionInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.IDBTransaction";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = IDBTransactionInterfaceBase;
  using Proxy_ = IDBTransactionProxy;

  template <typename ImplRefTraits>
  using Stub_ = IDBTransactionStub<ImplRefTraits>;

  using RequestValidator_ = IDBTransactionRequestValidator;
  using ResponseValidator_ = IDBTransactionResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateObjectStoreMinVersion = 0,
    kDeleteObjectStoreMinVersion = 0,
    kPutMinVersion = 0,
    kSetIndexKeysMinVersion = 0,
    kSetIndexKeysDoneMinVersion = 0,
    kCommitMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateObjectStore_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteObjectStore_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Put_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetIndexKeys_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetIndexKeysDone_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Commit_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~IDBTransaction() = default;

  virtual void CreateObjectStore(int64_t object_store_id, const ::std::u16string& name, const ::blink::IndexedDBKeyPath& key_path, bool auto_increment) = 0;

  virtual void DeleteObjectStore(int64_t object_store_id) = 0;

  using PutCallback = base::OnceCallback<void(IDBTransactionPutResultPtr)>;
  using PutMojoCallback = base::OnceCallback<void(IDBTransactionPutResultPtr)>;

  virtual void Put(int64_t object_store_id, IDBValuePtr value, ::blink::IndexedDBKey key, IDBPutMode mode, std::vector<::blink::IndexedDBIndexKeys> index_keys, PutCallback callback) = 0;

  virtual void SetIndexKeys(int64_t object_store_id, ::blink::IndexedDBKey primary_key, ::blink::IndexedDBIndexKeys index_keys) = 0;

  virtual void SetIndexKeysDone() = 0;

  virtual void Commit(int64_t num_errors_handled) = 0;
};

class IDBDatabaseGetAllResultSinkProxy;

template <typename ImplRefTraits>
class IDBDatabaseGetAllResultSinkStub;

class IDBDatabaseGetAllResultSinkRequestValidator;


class BLINK_COMMON_EXPORT IDBDatabaseGetAllResultSink
    : public IDBDatabaseGetAllResultSinkInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.IDBDatabaseGetAllResultSink";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = IDBDatabaseGetAllResultSinkInterfaceBase;
  using Proxy_ = IDBDatabaseGetAllResultSinkProxy;

  template <typename ImplRefTraits>
  using Stub_ = IDBDatabaseGetAllResultSinkStub<ImplRefTraits>;

  using RequestValidator_ = IDBDatabaseGetAllResultSinkRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kReceiveResultsMinVersion = 0,
    kOnErrorMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ReceiveResults_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnError_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~IDBDatabaseGetAllResultSink() = default;

  virtual void ReceiveResults(std::vector<IDBRecordPtr> records, bool done) = 0;

  virtual void OnError(IDBErrorPtr error) = 0;
};

class IDBDatabaseProxy;

template <typename ImplRefTraits>
class IDBDatabaseStub;

class IDBDatabaseRequestValidator;
class IDBDatabaseResponseValidator;


class BLINK_COMMON_EXPORT IDBDatabase
    : public IDBDatabaseInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.IDBDatabase";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = IDBDatabaseInterfaceBase;
  using Proxy_ = IDBDatabaseProxy;

  template <typename ImplRefTraits>
  using Stub_ = IDBDatabaseStub<ImplRefTraits>;

  using RequestValidator_ = IDBDatabaseRequestValidator;
  using ResponseValidator_ = IDBDatabaseResponseValidator;
  enum MethodMinVersions : uint32_t {
    kRenameObjectStoreMinVersion = 0,
    kCreateTransactionMinVersion = 0,
    kVersionChangeIgnoredMinVersion = 0,
    kGetMinVersion = 0,
    kGetAllMinVersion = 0,
    kOpenCursorMinVersion = 0,
    kCountMinVersion = 0,
    kDeleteRangeMinVersion = 0,
    kGetKeyGeneratorCurrentNumberMinVersion = 0,
    kClearMinVersion = 0,
    kCreateIndexMinVersion = 0,
    kDeleteIndexMinVersion = 0,
    kRenameIndexMinVersion = 0,
    kAbortMinVersion = 0,
    kDidBecomeInactiveMinVersion = 0,
    kUpdatePriorityMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct RenameObjectStore_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateTransaction_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct VersionChangeIgnored_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Get_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetAll_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenCursor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Count_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteRange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetKeyGeneratorCurrentNumber_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Clear_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateIndex_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteIndex_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RenameIndex_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Abort_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidBecomeInactive_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdatePriority_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~IDBDatabase() = default;

  virtual void RenameObjectStore(int64_t transaction_id, int64_t object_store_id, const ::std::u16string& new_name) = 0;

  virtual void CreateTransaction(::mojo::PendingAssociatedReceiver<IDBTransaction> transaction_receiver, int64_t transaction_id, const std::vector<int64_t>& object_store_ids, IDBTransactionMode mode, IDBTransactionDurability durability) = 0;

  virtual void VersionChangeIgnored() = 0;

  using GetCallback = base::OnceCallback<void(IDBDatabaseGetResultPtr)>;
  using GetMojoCallback = base::OnceCallback<void(IDBDatabaseGetResultPtr)>;

  virtual void Get(int64_t transaction_id, int64_t object_store_id, int64_t index_id, ::blink::IndexedDBKeyRange key_range, bool key_only, GetCallback callback) = 0;

  using GetAllCallback = base::OnceCallback<void(::mojo::PendingAssociatedReceiver<IDBDatabaseGetAllResultSink>)>;
  using GetAllMojoCallback = base::OnceCallback<void(::mojo::PendingAssociatedReceiver<IDBDatabaseGetAllResultSink>)>;

  virtual void GetAll(int64_t transaction_id, int64_t object_store_id, int64_t index_id, ::blink::IndexedDBKeyRange key_range, IDBGetAllResultType result_type, int64_t max_count, IDBCursorDirection direction, GetAllCallback callback) = 0;

  using OpenCursorCallback = base::OnceCallback<void(IDBDatabaseOpenCursorResultPtr)>;
  using OpenCursorMojoCallback = base::OnceCallback<void(IDBDatabaseOpenCursorResultPtr)>;

  virtual void OpenCursor(int64_t transaction_id, int64_t object_store_id, int64_t index_id, ::blink::IndexedDBKeyRange key_range, IDBCursorDirection direction, bool key_only, IDBTaskType task_type, OpenCursorCallback callback) = 0;

  using CountCallback = base::OnceCallback<void(bool, uint32_t)>;
  using CountMojoCallback = base::OnceCallback<void(bool, uint32_t)>;

  virtual void Count(int64_t transaction_id, int64_t object_store_id, int64_t index_id, ::blink::IndexedDBKeyRange key_range, CountCallback callback) = 0;

  using DeleteRangeCallback = base::OnceCallback<void(bool)>;
  using DeleteRangeMojoCallback = base::OnceCallback<void(bool)>;

  virtual void DeleteRange(int64_t transaction_id, int64_t object_store_id, ::blink::IndexedDBKeyRange key_range, DeleteRangeCallback callback) = 0;

  using GetKeyGeneratorCurrentNumberCallback = base::OnceCallback<void(int64_t, IDBErrorPtr)>;
  using GetKeyGeneratorCurrentNumberMojoCallback = base::OnceCallback<void(int64_t, IDBErrorPtr)>;

  virtual void GetKeyGeneratorCurrentNumber(int64_t transaction_id, int64_t object_store_id, GetKeyGeneratorCurrentNumberCallback callback) = 0;

  using ClearCallback = base::OnceCallback<void(bool)>;
  using ClearMojoCallback = base::OnceCallback<void(bool)>;

  virtual void Clear(int64_t transaction_id, int64_t object_store_id, ClearCallback callback) = 0;

  virtual void CreateIndex(int64_t transaction_id, int64_t object_store_id, const ::blink::IndexedDBIndexMetadata& index) = 0;

  virtual void DeleteIndex(int64_t transaction_id, int64_t object_store_id, int64_t index_id) = 0;

  virtual void RenameIndex(int64_t transaction_id, int64_t object_store_id, int64_t index_id, const ::std::u16string& new_name) = 0;

  virtual void Abort(int64_t transaction_id) = 0;

  virtual void DidBecomeInactive() = 0;

  virtual void UpdatePriority(int32_t new_priority) = 0;
};

class IDBFactoryProxy;

template <typename ImplRefTraits>
class IDBFactoryStub;

class IDBFactoryRequestValidator;
class IDBFactoryResponseValidator;


class BLINK_COMMON_EXPORT IDBFactory
    : public IDBFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.IDBFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = IDBFactoryInterfaceBase;
  using Proxy_ = IDBFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = IDBFactoryStub<ImplRefTraits>;

  using RequestValidator_ = IDBFactoryRequestValidator;
  using ResponseValidator_ = IDBFactoryResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetDatabaseInfoMinVersion = 0,
    kOpenMinVersion = 0,
    kDeleteDatabaseMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetDatabaseInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Open_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteDatabase_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~IDBFactory() = default;

  using GetDatabaseInfoCallback = base::OnceCallback<void(std::vector<IDBNameAndVersionPtr>, IDBErrorPtr)>;
  using GetDatabaseInfoMojoCallback = base::OnceCallback<void(std::vector<IDBNameAndVersionPtr>, IDBErrorPtr)>;

  virtual void GetDatabaseInfo(GetDatabaseInfoCallback callback) = 0;

  virtual void Open(::mojo::PendingAssociatedRemote<IDBFactoryClient> client, ::mojo::PendingAssociatedRemote<IDBDatabaseCallbacks> database_callbacks, const ::std::u16string& name, int64_t version, ::mojo::PendingAssociatedReceiver<IDBTransaction> version_change_transaction_receiver, int64_t transaction_id, int32_t priority) = 0;

  virtual void DeleteDatabase(::mojo::PendingAssociatedRemote<IDBFactoryClient> client, const ::std::u16string& name, bool force_close) = 0;
};



class BLINK_COMMON_EXPORT IDBFactoryClientProxy
    : public IDBFactoryClient {
 public:
  using InterfaceType = IDBFactoryClient;

  explicit IDBFactoryClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Error(IDBException code, const ::std::u16string& message) final;
  
  void Blocked(int64_t existing_version) final;
  
  void UpgradeNeeded(::mojo::PendingAssociatedRemote<IDBDatabase> pending_database, int64_t old_version, IDBDataLoss data_loss, const std::string& data_loss_message, const ::blink::IndexedDBDatabaseMetadata& db_metadata) final;
  
  void OpenSuccess(::mojo::PendingAssociatedRemote<IDBDatabase> pending_database, const ::blink::IndexedDBDatabaseMetadata& metadata) final;
  
  void DeleteSuccess(int64_t old_version) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT IDBDatabaseCallbacksProxy
    : public IDBDatabaseCallbacks {
 public:
  using InterfaceType = IDBDatabaseCallbacks;

  explicit IDBDatabaseCallbacksProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ForcedClose() final;
  
  void VersionChange(int64_t old_version, int64_t new_version) final;
  
  void Abort(int64_t transaction_id, IDBException code, const ::std::u16string& message) final;
  
  void Complete(int64_t transaction_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT IDBCursorProxy
    : public IDBCursor {
 public:
  using InterfaceType = IDBCursor;

  explicit IDBCursorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Advance(uint32_t count, AdvanceCallback callback) final;
  
  void Continue(::blink::IndexedDBKey key, ::blink::IndexedDBKey primary_key, ContinueCallback callback) final;
  
  void Prefetch(int32_t count, PrefetchCallback callback) final;
  
  void PrefetchReset(int32_t used_prefetches) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT IDBTransactionProxy
    : public IDBTransaction {
 public:
  using InterfaceType = IDBTransaction;

  explicit IDBTransactionProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateObjectStore(int64_t object_store_id, const ::std::u16string& name, const ::blink::IndexedDBKeyPath& key_path, bool auto_increment) final;
  
  void DeleteObjectStore(int64_t object_store_id) final;
  
  void Put(int64_t object_store_id, IDBValuePtr value, ::blink::IndexedDBKey key, IDBPutMode mode, std::vector<::blink::IndexedDBIndexKeys> index_keys, PutCallback callback) final;
  
  void SetIndexKeys(int64_t object_store_id, ::blink::IndexedDBKey primary_key, ::blink::IndexedDBIndexKeys index_keys) final;
  
  void SetIndexKeysDone() final;
  
  void Commit(int64_t num_errors_handled) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT IDBDatabaseGetAllResultSinkProxy
    : public IDBDatabaseGetAllResultSink {
 public:
  using InterfaceType = IDBDatabaseGetAllResultSink;

  explicit IDBDatabaseGetAllResultSinkProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ReceiveResults(std::vector<IDBRecordPtr> records, bool done) final;
  
  void OnError(IDBErrorPtr error) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT IDBDatabaseProxy
    : public IDBDatabase {
 public:
  using InterfaceType = IDBDatabase;

  explicit IDBDatabaseProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RenameObjectStore(int64_t transaction_id, int64_t object_store_id, const ::std::u16string& new_name) final;
  
  void CreateTransaction(::mojo::PendingAssociatedReceiver<IDBTransaction> transaction_receiver, int64_t transaction_id, const std::vector<int64_t>& object_store_ids, IDBTransactionMode mode, IDBTransactionDurability durability) final;
  
  void VersionChangeIgnored() final;
  
  void Get(int64_t transaction_id, int64_t object_store_id, int64_t index_id, ::blink::IndexedDBKeyRange key_range, bool key_only, GetCallback callback) final;
  
  void GetAll(int64_t transaction_id, int64_t object_store_id, int64_t index_id, ::blink::IndexedDBKeyRange key_range, IDBGetAllResultType result_type, int64_t max_count, IDBCursorDirection direction, GetAllCallback callback) final;
  
  void OpenCursor(int64_t transaction_id, int64_t object_store_id, int64_t index_id, ::blink::IndexedDBKeyRange key_range, IDBCursorDirection direction, bool key_only, IDBTaskType task_type, OpenCursorCallback callback) final;
  
  void Count(int64_t transaction_id, int64_t object_store_id, int64_t index_id, ::blink::IndexedDBKeyRange key_range, CountCallback callback) final;
  
  void DeleteRange(int64_t transaction_id, int64_t object_store_id, ::blink::IndexedDBKeyRange key_range, DeleteRangeCallback callback) final;
  
  void GetKeyGeneratorCurrentNumber(int64_t transaction_id, int64_t object_store_id, GetKeyGeneratorCurrentNumberCallback callback) final;
  
  void Clear(int64_t transaction_id, int64_t object_store_id, ClearCallback callback) final;
  
  void CreateIndex(int64_t transaction_id, int64_t object_store_id, const ::blink::IndexedDBIndexMetadata& index) final;
  
  void DeleteIndex(int64_t transaction_id, int64_t object_store_id, int64_t index_id) final;
  
  void RenameIndex(int64_t transaction_id, int64_t object_store_id, int64_t index_id, const ::std::u16string& new_name) final;
  
  void Abort(int64_t transaction_id) final;
  
  void DidBecomeInactive() final;
  
  void UpdatePriority(int32_t new_priority) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT IDBFactoryProxy
    : public IDBFactory {
 public:
  using InterfaceType = IDBFactory;

  explicit IDBFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetDatabaseInfo(GetDatabaseInfoCallback callback) final;
  
  void Open(::mojo::PendingAssociatedRemote<IDBFactoryClient> client, ::mojo::PendingAssociatedRemote<IDBDatabaseCallbacks> database_callbacks, const ::std::u16string& name, int64_t version, ::mojo::PendingAssociatedReceiver<IDBTransaction> version_change_transaction_receiver, int64_t transaction_id, int32_t priority) final;
  
  void DeleteDatabase(::mojo::PendingAssociatedRemote<IDBFactoryClient> client, const ::std::u16string& name, bool force_close) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT IDBFactoryClientStubDispatch {
 public:
  static bool Accept(IDBFactoryClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      IDBFactoryClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<IDBFactoryClient>>
class IDBFactoryClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  IDBFactoryClientStub() = default;
  ~IDBFactoryClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return IDBFactoryClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return IDBFactoryClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT IDBDatabaseCallbacksStubDispatch {
 public:
  static bool Accept(IDBDatabaseCallbacks* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      IDBDatabaseCallbacks* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<IDBDatabaseCallbacks>>
class IDBDatabaseCallbacksStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  IDBDatabaseCallbacksStub() = default;
  ~IDBDatabaseCallbacksStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return IDBDatabaseCallbacksStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return IDBDatabaseCallbacksStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT IDBCursorStubDispatch {
 public:
  static bool Accept(IDBCursor* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      IDBCursor* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<IDBCursor>>
class IDBCursorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  IDBCursorStub() = default;
  ~IDBCursorStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return IDBCursorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return IDBCursorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT IDBTransactionStubDispatch {
 public:
  static bool Accept(IDBTransaction* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      IDBTransaction* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<IDBTransaction>>
class IDBTransactionStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  IDBTransactionStub() = default;
  ~IDBTransactionStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return IDBTransactionStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return IDBTransactionStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT IDBDatabaseGetAllResultSinkStubDispatch {
 public:
  static bool Accept(IDBDatabaseGetAllResultSink* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      IDBDatabaseGetAllResultSink* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<IDBDatabaseGetAllResultSink>>
class IDBDatabaseGetAllResultSinkStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  IDBDatabaseGetAllResultSinkStub() = default;
  ~IDBDatabaseGetAllResultSinkStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return IDBDatabaseGetAllResultSinkStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return IDBDatabaseGetAllResultSinkStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT IDBDatabaseStubDispatch {
 public:
  static bool Accept(IDBDatabase* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      IDBDatabase* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<IDBDatabase>>
class IDBDatabaseStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  IDBDatabaseStub() = default;
  ~IDBDatabaseStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return IDBDatabaseStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return IDBDatabaseStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT IDBFactoryStubDispatch {
 public:
  static bool Accept(IDBFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      IDBFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<IDBFactory>>
class IDBFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  IDBFactoryStub() = default;
  ~IDBFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return IDBFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return IDBFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT IDBFactoryClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT IDBDatabaseCallbacksRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT IDBCursorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT IDBTransactionRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT IDBDatabaseGetAllResultSinkRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT IDBDatabaseRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT IDBFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT IDBCursorResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT IDBTransactionResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT IDBDatabaseResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT IDBFactoryResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};




















class BLINK_COMMON_EXPORT IDBKey {
 public:
  using DataView = IDBKeyDataView;
  using Data_ = internal::IDBKey_Data;
  using Tag = Data_::IDBKey_Tag;

  template <typename... Args>
  static IDBKeyPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |key_array|.
  static IDBKeyPtr NewKeyArray(
      std::vector<::blink::IndexedDBKey> value);
  // Construct an instance holding |binary|.
  static IDBKeyPtr NewBinary(
      std::vector<uint8_t> value);
  // Construct an instance holding |string|.
  static IDBKeyPtr NewString(
      const ::std::u16string& value);
  // Construct an instance holding |date|.
  static IDBKeyPtr NewDate(
      double value);
  // Construct an instance holding |number|.
  static IDBKeyPtr NewNumber(
      double value);
  // Construct an instance holding |other_none|.
  static IDBKeyPtr NewOtherNone(
      bool value);

  template <typename U>
  static IDBKeyPtr From(const U& u) {
    return mojo::TypeConverter<IDBKeyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IDBKey>::Convert(*this);
  }
  ~IDBKey();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  IDBKey(const IDBKey& other) = delete;
  IDBKey& operator=(const IDBKey& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = IDBKeyPtr>
  IDBKeyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, IDBKey>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, IDBKey>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_key_array() const { return tag_ == Tag::kKeyArray; }
  const std::vector<::blink::IndexedDBKey>& get_key_array() const {
    CHECK(tag_ == Tag::kKeyArray);
    return data_.key_array;
  }
  std::vector<::blink::IndexedDBKey>& get_key_array() {
    CHECK(tag_ == Tag::kKeyArray);
    return data_.key_array;
  }
  void set_key_array(std::vector<::blink::IndexedDBKey> key_array);

  bool is_binary() const { return tag_ == Tag::kBinary; }
  const std::vector<uint8_t>& get_binary() const {
    CHECK(tag_ == Tag::kBinary);
    return data_.binary;
  }
  std::vector<uint8_t>& get_binary() {
    CHECK(tag_ == Tag::kBinary);
    return data_.binary;
  }
  void set_binary(std::vector<uint8_t> binary);

  bool is_string() const { return tag_ == Tag::kString; }
  const ::std::u16string& get_string() const {
    CHECK(tag_ == Tag::kString);
    return data_.string;
  }
  ::std::u16string& get_string() {
    CHECK(tag_ == Tag::kString);
    return data_.string;
  }
  void set_string(const ::std::u16string& string);

  bool is_date() const { return tag_ == Tag::kDate; }
  double get_date() const {
    CHECK(tag_ == Tag::kDate);
    return data_.date;
  }
  void set_date(double date);

  bool is_number() const { return tag_ == Tag::kNumber; }
  double get_number() const {
    CHECK(tag_ == Tag::kNumber);
    return data_.number;
  }
  void set_number(double number);

  bool is_other_none() const { return tag_ == Tag::kOtherNone; }
  bool get_other_none() const {
    CHECK(tag_ == Tag::kOtherNone);
    return data_.other_none;
  }
  void set_other_none(bool other_none);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IDBKey::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<IDBKey::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kKeyArray)>,
        std::vector<::blink::IndexedDBKey> value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kBinary)>,
        std::vector<uint8_t> value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kString)>,
        const ::std::u16string& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kDate)>,
        double value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kNumber)>,
        double value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kOtherNone)>,
        bool value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    std::vector<::blink::IndexedDBKey> key_array;
    std::vector<uint8_t> binary;
    ::std::u16string string;
    double date;
    double number;
    bool other_none;
  };

  IDBKey(
      std::in_place_index_t<static_cast<size_t>(Tag::kKeyArray)>,
      std::vector<::blink::IndexedDBKey> value);
  IDBKey(
      std::in_place_index_t<static_cast<size_t>(Tag::kBinary)>,
      std::vector<uint8_t> value);
  IDBKey(
      std::in_place_index_t<static_cast<size_t>(Tag::kString)>,
      const ::std::u16string& value);
  IDBKey(
      std::in_place_index_t<static_cast<size_t>(Tag::kDate)>,
      double value);
  IDBKey(
      std::in_place_index_t<static_cast<size_t>(Tag::kNumber)>,
      double value);
  IDBKey(
      std::in_place_index_t<static_cast<size_t>(Tag::kOtherNone)>,
      bool value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class BLINK_COMMON_EXPORT IDBKeyPathData {
 public:
  using DataView = IDBKeyPathDataDataView;
  using Data_ = internal::IDBKeyPathData_Data;
  using Tag = Data_::IDBKeyPathData_Tag;

  template <typename... Args>
  static IDBKeyPathDataPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |string|.
  static IDBKeyPathDataPtr NewString(
      const ::std::u16string& value);
  // Construct an instance holding |string_array|.
  static IDBKeyPathDataPtr NewStringArray(
      std::vector<::std::u16string> value);

  template <typename U>
  static IDBKeyPathDataPtr From(const U& u) {
    return mojo::TypeConverter<IDBKeyPathDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IDBKeyPathData>::Convert(*this);
  }
  ~IDBKeyPathData();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  IDBKeyPathData(const IDBKeyPathData& other) = delete;
  IDBKeyPathData& operator=(const IDBKeyPathData& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = IDBKeyPathDataPtr>
  IDBKeyPathDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, IDBKeyPathData>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, IDBKeyPathData>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_string() const { return tag_ == Tag::kString; }
  const ::std::u16string& get_string() const {
    CHECK(tag_ == Tag::kString);
    return data_.string;
  }
  ::std::u16string& get_string() {
    CHECK(tag_ == Tag::kString);
    return data_.string;
  }
  void set_string(const ::std::u16string& string);

  bool is_string_array() const { return tag_ == Tag::kStringArray; }
  const std::vector<::std::u16string>& get_string_array() const {
    CHECK(tag_ == Tag::kStringArray);
    return data_.string_array;
  }
  std::vector<::std::u16string>& get_string_array() {
    CHECK(tag_ == Tag::kStringArray);
    return data_.string_array;
  }
  void set_string_array(std::vector<::std::u16string> string_array);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IDBKeyPathData::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<IDBKeyPathData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kString)>,
        const ::std::u16string& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kStringArray)>,
        std::vector<::std::u16string> value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::std::u16string string;
    std::vector<::std::u16string> string_array;
  };

  IDBKeyPathData(
      std::in_place_index_t<static_cast<size_t>(Tag::kString)>,
      const ::std::u16string& value);
  IDBKeyPathData(
      std::in_place_index_t<static_cast<size_t>(Tag::kStringArray)>,
      std::vector<::std::u16string> value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class BLINK_COMMON_EXPORT IDBExternalObject {
 public:
  using DataView = IDBExternalObjectDataView;
  using Data_ = internal::IDBExternalObject_Data;
  using Tag = Data_::IDBExternalObject_Tag;

  template <typename... Args>
  static IDBExternalObjectPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |blob_or_file|.
  static IDBExternalObjectPtr NewBlobOrFile(
      IDBBlobInfoPtr value);
  // Construct an instance holding |file_system_access_token|.
  static IDBExternalObjectPtr NewFileSystemAccessToken(
      ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> value);

  template <typename U>
  static IDBExternalObjectPtr From(const U& u) {
    return mojo::TypeConverter<IDBExternalObjectPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IDBExternalObject>::Convert(*this);
  }
  ~IDBExternalObject();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  IDBExternalObject(const IDBExternalObject& other) = delete;
  IDBExternalObject& operator=(const IDBExternalObject& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = IDBExternalObjectPtr>
  IDBExternalObjectPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, IDBExternalObject>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, IDBExternalObject>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_blob_or_file() const { return tag_ == Tag::kBlobOrFile; }
  const IDBBlobInfoPtr& get_blob_or_file() const {
    CHECK(tag_ == Tag::kBlobOrFile);
    return data_.blob_or_file;
  }
  IDBBlobInfoPtr& get_blob_or_file() {
    CHECK(tag_ == Tag::kBlobOrFile);
    return data_.blob_or_file;
  }
  void set_blob_or_file(IDBBlobInfoPtr blob_or_file);

  bool is_file_system_access_token() const { return tag_ == Tag::kFileSystemAccessToken; }
  const ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken>& get_file_system_access_token() const {
    CHECK(tag_ == Tag::kFileSystemAccessToken);
    return data_.file_system_access_token;
  }
  ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken>& get_file_system_access_token() {
    CHECK(tag_ == Tag::kFileSystemAccessToken);
    return data_.file_system_access_token;
  }
  void set_file_system_access_token(::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> file_system_access_token);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IDBExternalObject::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<IDBExternalObject::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kBlobOrFile)>,
        IDBBlobInfoPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFileSystemAccessToken)>,
        ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    IDBBlobInfoPtr blob_or_file;
    ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> file_system_access_token;
  };

  IDBExternalObject(
      std::in_place_index_t<static_cast<size_t>(Tag::kBlobOrFile)>,
      IDBBlobInfoPtr value);
  IDBExternalObject(
      std::in_place_index_t<static_cast<size_t>(Tag::kFileSystemAccessToken)>,
      ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class BLINK_COMMON_EXPORT IDBCursorResult {
 public:
  using DataView = IDBCursorResultDataView;
  using Data_ = internal::IDBCursorResult_Data;
  using Tag = Data_::IDBCursorResult_Tag;

  template <typename... Args>
  static IDBCursorResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |error_result|.
  static IDBCursorResultPtr NewErrorResult(
      IDBErrorPtr value);
  // Construct an instance holding |empty|.
  static IDBCursorResultPtr NewEmpty(
      bool value);
  // Construct an instance holding |values|.
  static IDBCursorResultPtr NewValues(
      IDBCursorValuePtr value);

  template <typename U>
  static IDBCursorResultPtr From(const U& u) {
    return mojo::TypeConverter<IDBCursorResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IDBCursorResult>::Convert(*this);
  }
  ~IDBCursorResult();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  IDBCursorResult(const IDBCursorResult& other) = delete;
  IDBCursorResult& operator=(const IDBCursorResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = IDBCursorResultPtr>
  IDBCursorResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, IDBCursorResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, IDBCursorResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_error_result() const { return tag_ == Tag::kErrorResult; }
  const IDBErrorPtr& get_error_result() const {
    CHECK(tag_ == Tag::kErrorResult);
    return data_.error_result;
  }
  IDBErrorPtr& get_error_result() {
    CHECK(tag_ == Tag::kErrorResult);
    return data_.error_result;
  }
  void set_error_result(IDBErrorPtr error_result);

  bool is_empty() const { return tag_ == Tag::kEmpty; }
  bool get_empty() const {
    CHECK(tag_ == Tag::kEmpty);
    return data_.empty;
  }
  void set_empty(bool empty);

  bool is_values() const { return tag_ == Tag::kValues; }
  const IDBCursorValuePtr& get_values() const {
    CHECK(tag_ == Tag::kValues);
    return data_.values;
  }
  IDBCursorValuePtr& get_values() {
    CHECK(tag_ == Tag::kValues);
    return data_.values;
  }
  void set_values(IDBCursorValuePtr values);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IDBCursorResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<IDBCursorResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kErrorResult)>,
        IDBErrorPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kEmpty)>,
        bool value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kValues)>,
        IDBCursorValuePtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    IDBErrorPtr error_result;
    bool empty;
    IDBCursorValuePtr values;
  };

  IDBCursorResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kErrorResult)>,
      IDBErrorPtr value);
  IDBCursorResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kEmpty)>,
      bool value);
  IDBCursorResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kValues)>,
      IDBCursorValuePtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class BLINK_COMMON_EXPORT IDBTransactionPutResult {
 public:
  using DataView = IDBTransactionPutResultDataView;
  using Data_ = internal::IDBTransactionPutResult_Data;
  using Tag = Data_::IDBTransactionPutResult_Tag;

  template <typename... Args>
  static IDBTransactionPutResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |error_result|.
  static IDBTransactionPutResultPtr NewErrorResult(
      IDBErrorPtr value);
  // Construct an instance holding |key|.
  static IDBTransactionPutResultPtr NewKey(
      ::blink::IndexedDBKey value);

  template <typename U>
  static IDBTransactionPutResultPtr From(const U& u) {
    return mojo::TypeConverter<IDBTransactionPutResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IDBTransactionPutResult>::Convert(*this);
  }
  ~IDBTransactionPutResult();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  IDBTransactionPutResult(const IDBTransactionPutResult& other) = delete;
  IDBTransactionPutResult& operator=(const IDBTransactionPutResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = IDBTransactionPutResultPtr>
  IDBTransactionPutResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, IDBTransactionPutResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, IDBTransactionPutResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_error_result() const { return tag_ == Tag::kErrorResult; }
  const IDBErrorPtr& get_error_result() const {
    CHECK(tag_ == Tag::kErrorResult);
    return data_.error_result;
  }
  IDBErrorPtr& get_error_result() {
    CHECK(tag_ == Tag::kErrorResult);
    return data_.error_result;
  }
  void set_error_result(IDBErrorPtr error_result);

  bool is_key() const { return tag_ == Tag::kKey; }
  const ::blink::IndexedDBKey& get_key() const {
    CHECK(tag_ == Tag::kKey);
    return data_.key;
  }
  ::blink::IndexedDBKey& get_key() {
    CHECK(tag_ == Tag::kKey);
    return data_.key;
  }
  void set_key(::blink::IndexedDBKey key);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IDBTransactionPutResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<IDBTransactionPutResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kErrorResult)>,
        IDBErrorPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kKey)>,
        ::blink::IndexedDBKey value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    IDBErrorPtr error_result;
    ::blink::IndexedDBKey key;
  };

  IDBTransactionPutResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kErrorResult)>,
      IDBErrorPtr value);
  IDBTransactionPutResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kKey)>,
      ::blink::IndexedDBKey value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class BLINK_COMMON_EXPORT IDBDatabaseGetResult {
 public:
  using DataView = IDBDatabaseGetResultDataView;
  using Data_ = internal::IDBDatabaseGetResult_Data;
  using Tag = Data_::IDBDatabaseGetResult_Tag;

  template <typename... Args>
  static IDBDatabaseGetResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |error_result|.
  static IDBDatabaseGetResultPtr NewErrorResult(
      IDBErrorPtr value);
  // Construct an instance holding |empty|.
  static IDBDatabaseGetResultPtr NewEmpty(
      bool value);
  // Construct an instance holding |key|.
  static IDBDatabaseGetResultPtr NewKey(
      ::blink::IndexedDBKey value);
  // Construct an instance holding |value|.
  static IDBDatabaseGetResultPtr NewValue(
      IDBReturnValuePtr value);

  template <typename U>
  static IDBDatabaseGetResultPtr From(const U& u) {
    return mojo::TypeConverter<IDBDatabaseGetResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IDBDatabaseGetResult>::Convert(*this);
  }
  ~IDBDatabaseGetResult();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  IDBDatabaseGetResult(const IDBDatabaseGetResult& other) = delete;
  IDBDatabaseGetResult& operator=(const IDBDatabaseGetResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = IDBDatabaseGetResultPtr>
  IDBDatabaseGetResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, IDBDatabaseGetResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, IDBDatabaseGetResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_error_result() const { return tag_ == Tag::kErrorResult; }
  const IDBErrorPtr& get_error_result() const {
    CHECK(tag_ == Tag::kErrorResult);
    return data_.error_result;
  }
  IDBErrorPtr& get_error_result() {
    CHECK(tag_ == Tag::kErrorResult);
    return data_.error_result;
  }
  void set_error_result(IDBErrorPtr error_result);

  bool is_empty() const { return tag_ == Tag::kEmpty; }
  bool get_empty() const {
    CHECK(tag_ == Tag::kEmpty);
    return data_.empty;
  }
  void set_empty(bool empty);

  bool is_key() const { return tag_ == Tag::kKey; }
  const ::blink::IndexedDBKey& get_key() const {
    CHECK(tag_ == Tag::kKey);
    return data_.key;
  }
  ::blink::IndexedDBKey& get_key() {
    CHECK(tag_ == Tag::kKey);
    return data_.key;
  }
  void set_key(::blink::IndexedDBKey key);

  bool is_value() const { return tag_ == Tag::kValue; }
  const IDBReturnValuePtr& get_value() const {
    CHECK(tag_ == Tag::kValue);
    return data_.value;
  }
  IDBReturnValuePtr& get_value() {
    CHECK(tag_ == Tag::kValue);
    return data_.value;
  }
  void set_value(IDBReturnValuePtr value);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IDBDatabaseGetResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<IDBDatabaseGetResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kErrorResult)>,
        IDBErrorPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kEmpty)>,
        bool value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kKey)>,
        ::blink::IndexedDBKey value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kValue)>,
        IDBReturnValuePtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    IDBErrorPtr error_result;
    bool empty;
    ::blink::IndexedDBKey key;
    IDBReturnValuePtr value;
  };

  IDBDatabaseGetResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kErrorResult)>,
      IDBErrorPtr value);
  IDBDatabaseGetResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kEmpty)>,
      bool value);
  IDBDatabaseGetResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kKey)>,
      ::blink::IndexedDBKey value);
  IDBDatabaseGetResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kValue)>,
      IDBReturnValuePtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class BLINK_COMMON_EXPORT IDBDatabaseOpenCursorResult {
 public:
  using DataView = IDBDatabaseOpenCursorResultDataView;
  using Data_ = internal::IDBDatabaseOpenCursorResult_Data;
  using Tag = Data_::IDBDatabaseOpenCursorResult_Tag;

  template <typename... Args>
  static IDBDatabaseOpenCursorResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |error_result|.
  static IDBDatabaseOpenCursorResultPtr NewErrorResult(
      IDBErrorPtr value);
  // Construct an instance holding |empty|.
  static IDBDatabaseOpenCursorResultPtr NewEmpty(
      bool value);
  // Construct an instance holding |value|.
  static IDBDatabaseOpenCursorResultPtr NewValue(
      IDBDatabaseOpenCursorValuePtr value);

  template <typename U>
  static IDBDatabaseOpenCursorResultPtr From(const U& u) {
    return mojo::TypeConverter<IDBDatabaseOpenCursorResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IDBDatabaseOpenCursorResult>::Convert(*this);
  }
  ~IDBDatabaseOpenCursorResult();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  IDBDatabaseOpenCursorResult(const IDBDatabaseOpenCursorResult& other) = delete;
  IDBDatabaseOpenCursorResult& operator=(const IDBDatabaseOpenCursorResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = IDBDatabaseOpenCursorResultPtr>
  IDBDatabaseOpenCursorResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, IDBDatabaseOpenCursorResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, IDBDatabaseOpenCursorResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_error_result() const { return tag_ == Tag::kErrorResult; }
  const IDBErrorPtr& get_error_result() const {
    CHECK(tag_ == Tag::kErrorResult);
    return data_.error_result;
  }
  IDBErrorPtr& get_error_result() {
    CHECK(tag_ == Tag::kErrorResult);
    return data_.error_result;
  }
  void set_error_result(IDBErrorPtr error_result);

  bool is_empty() const { return tag_ == Tag::kEmpty; }
  bool get_empty() const {
    CHECK(tag_ == Tag::kEmpty);
    return data_.empty;
  }
  void set_empty(bool empty);

  bool is_value() const { return tag_ == Tag::kValue; }
  const IDBDatabaseOpenCursorValuePtr& get_value() const {
    CHECK(tag_ == Tag::kValue);
    return data_.value;
  }
  IDBDatabaseOpenCursorValuePtr& get_value() {
    CHECK(tag_ == Tag::kValue);
    return data_.value;
  }
  void set_value(IDBDatabaseOpenCursorValuePtr value);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IDBDatabaseOpenCursorResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<IDBDatabaseOpenCursorResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kErrorResult)>,
        IDBErrorPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kEmpty)>,
        bool value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kValue)>,
        IDBDatabaseOpenCursorValuePtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    IDBErrorPtr error_result;
    bool empty;
    IDBDatabaseOpenCursorValuePtr value;
  };

  IDBDatabaseOpenCursorResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kErrorResult)>,
      IDBErrorPtr value);
  IDBDatabaseOpenCursorResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kEmpty)>,
      bool value);
  IDBDatabaseOpenCursorResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kValue)>,
      IDBDatabaseOpenCursorValuePtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class BLINK_COMMON_EXPORT IDBKeyPath {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IDBKeyPath, T>::value>;
  using DataView = IDBKeyPathDataView;
  using Data_ = internal::IDBKeyPath_Data;

  template <typename... Args>
  static IDBKeyPathPtr New(Args&&... args) {
    return IDBKeyPathPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IDBKeyPathPtr From(const U& u) {
    return mojo::TypeConverter<IDBKeyPathPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IDBKeyPath>::Convert(*this);
  }


  IDBKeyPath();

  explicit IDBKeyPath(
      IDBKeyPathDataPtr data);

IDBKeyPath(const IDBKeyPath&) = delete;
IDBKeyPath& operator=(const IDBKeyPath&) = delete;

  ~IDBKeyPath();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IDBKeyPathPtr>
  IDBKeyPathPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IDBKeyPath::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IDBKeyPath::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IDBKeyPath::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IDBKeyPath::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IDBKeyPath::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IDBKeyPath::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IDBKeyPath_UnserializedMessageContext<
            UserType, IDBKeyPath::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IDBKeyPath::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IDBKeyPath::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IDBKeyPath_UnserializedMessageContext<
            UserType, IDBKeyPath::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IDBKeyPath::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  IDBKeyPathDataPtr data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IDBKeyPath::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IDBKeyPath::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IDBKeyPath::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IDBKeyPath::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT IDBKeyRange {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IDBKeyRange, T>::value>;
  using DataView = IDBKeyRangeDataView;
  using Data_ = internal::IDBKeyRange_Data;

  template <typename... Args>
  static IDBKeyRangePtr New(Args&&... args) {
    return IDBKeyRangePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IDBKeyRangePtr From(const U& u) {
    return mojo::TypeConverter<IDBKeyRangePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IDBKeyRange>::Convert(*this);
  }


  IDBKeyRange();

  IDBKeyRange(
      ::blink::IndexedDBKey lower,
      ::blink::IndexedDBKey upper,
      bool lower_open,
      bool upper_open);

IDBKeyRange(const IDBKeyRange&) = delete;
IDBKeyRange& operator=(const IDBKeyRange&) = delete;

  ~IDBKeyRange();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IDBKeyRangePtr>
  IDBKeyRangePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IDBKeyRange::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IDBKeyRange::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IDBKeyRange::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IDBKeyRange::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IDBKeyRange::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IDBKeyRange::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IDBKeyRange_UnserializedMessageContext<
            UserType, IDBKeyRange::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IDBKeyRange::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IDBKeyRange::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IDBKeyRange_UnserializedMessageContext<
            UserType, IDBKeyRange::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IDBKeyRange::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::IndexedDBKey lower;
  
  ::blink::IndexedDBKey upper;
  
  bool lower_open;
  
  bool upper_open;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IDBKeyRange::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IDBKeyRange::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IDBKeyRange::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IDBKeyRange::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT IDBIndexMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IDBIndexMetadata, T>::value>;
  using DataView = IDBIndexMetadataDataView;
  using Data_ = internal::IDBIndexMetadata_Data;

  template <typename... Args>
  static IDBIndexMetadataPtr New(Args&&... args) {
    return IDBIndexMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IDBIndexMetadataPtr From(const U& u) {
    return mojo::TypeConverter<IDBIndexMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IDBIndexMetadata>::Convert(*this);
  }


  IDBIndexMetadata();

  IDBIndexMetadata(
      int64_t id,
      const ::std::u16string& name,
      const ::blink::IndexedDBKeyPath& key_path,
      bool unique,
      bool multi_entry);


  ~IDBIndexMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IDBIndexMetadataPtr>
  IDBIndexMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IDBIndexMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IDBIndexMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IDBIndexMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IDBIndexMetadata::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IDBIndexMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IDBIndexMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IDBIndexMetadata_UnserializedMessageContext<
            UserType, IDBIndexMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IDBIndexMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IDBIndexMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IDBIndexMetadata_UnserializedMessageContext<
            UserType, IDBIndexMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IDBIndexMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t id;
  
  ::std::u16string name;
  
  ::blink::IndexedDBKeyPath key_path;
  
  bool unique;
  
  bool multi_entry;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IDBIndexMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IDBIndexMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IDBIndexMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IDBIndexMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT IDBObjectStoreMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IDBObjectStoreMetadata, T>::value>;
  using DataView = IDBObjectStoreMetadataDataView;
  using Data_ = internal::IDBObjectStoreMetadata_Data;

  template <typename... Args>
  static IDBObjectStoreMetadataPtr New(Args&&... args) {
    return IDBObjectStoreMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IDBObjectStoreMetadataPtr From(const U& u) {
    return mojo::TypeConverter<IDBObjectStoreMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IDBObjectStoreMetadata>::Convert(*this);
  }


  IDBObjectStoreMetadata();

  IDBObjectStoreMetadata(
      int64_t id,
      const ::std::u16string& name,
      const ::blink::IndexedDBKeyPath& key_path,
      bool auto_increment,
      int64_t max_index_id,
      const base::flat_map<int64_t, ::blink::IndexedDBIndexMetadata>& indexes);


  ~IDBObjectStoreMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IDBObjectStoreMetadataPtr>
  IDBObjectStoreMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IDBObjectStoreMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IDBObjectStoreMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IDBObjectStoreMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IDBObjectStoreMetadata::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IDBObjectStoreMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IDBObjectStoreMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IDBObjectStoreMetadata_UnserializedMessageContext<
            UserType, IDBObjectStoreMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IDBObjectStoreMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IDBObjectStoreMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IDBObjectStoreMetadata_UnserializedMessageContext<
            UserType, IDBObjectStoreMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IDBObjectStoreMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t id;
  
  ::std::u16string name;
  
  ::blink::IndexedDBKeyPath key_path;
  
  bool auto_increment;
  
  int64_t max_index_id;
  
  base::flat_map<int64_t, ::blink::IndexedDBIndexMetadata> indexes;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IDBObjectStoreMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IDBObjectStoreMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IDBObjectStoreMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IDBObjectStoreMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT IDBDatabaseMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IDBDatabaseMetadata, T>::value>;
  using DataView = IDBDatabaseMetadataDataView;
  using Data_ = internal::IDBDatabaseMetadata_Data;

  template <typename... Args>
  static IDBDatabaseMetadataPtr New(Args&&... args) {
    return IDBDatabaseMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IDBDatabaseMetadataPtr From(const U& u) {
    return mojo::TypeConverter<IDBDatabaseMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IDBDatabaseMetadata>::Convert(*this);
  }


  IDBDatabaseMetadata();

  IDBDatabaseMetadata(
      const ::std::u16string& name,
      int64_t version,
      int64_t max_object_store_id,
      const base::flat_map<int64_t, ::blink::IndexedDBObjectStoreMetadata>& object_stores,
      bool was_cold_open,
      bool is_sqlite);


  ~IDBDatabaseMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IDBDatabaseMetadataPtr>
  IDBDatabaseMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IDBDatabaseMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IDBDatabaseMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IDBDatabaseMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IDBDatabaseMetadata::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IDBDatabaseMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IDBDatabaseMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IDBDatabaseMetadata_UnserializedMessageContext<
            UserType, IDBDatabaseMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IDBDatabaseMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IDBDatabaseMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IDBDatabaseMetadata_UnserializedMessageContext<
            UserType, IDBDatabaseMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IDBDatabaseMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string name;
  
  int64_t version;
  
  int64_t max_object_store_id;
  
  base::flat_map<int64_t, ::blink::IndexedDBObjectStoreMetadata> object_stores;
  
  bool was_cold_open;
  
  bool is_sqlite;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IDBDatabaseMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IDBDatabaseMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IDBDatabaseMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IDBDatabaseMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT IDBNameAndVersion {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IDBNameAndVersion, T>::value>;
  using DataView = IDBNameAndVersionDataView;
  using Data_ = internal::IDBNameAndVersion_Data;

  template <typename... Args>
  static IDBNameAndVersionPtr New(Args&&... args) {
    return IDBNameAndVersionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IDBNameAndVersionPtr From(const U& u) {
    return mojo::TypeConverter<IDBNameAndVersionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IDBNameAndVersion>::Convert(*this);
  }


  IDBNameAndVersion();

  IDBNameAndVersion(
      const ::std::u16string& name,
      int64_t version);


  ~IDBNameAndVersion();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IDBNameAndVersionPtr>
  IDBNameAndVersionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IDBNameAndVersion::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IDBNameAndVersion::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IDBNameAndVersion::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IDBNameAndVersion::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IDBNameAndVersion::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IDBNameAndVersion::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IDBNameAndVersion_UnserializedMessageContext<
            UserType, IDBNameAndVersion::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IDBNameAndVersion::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IDBNameAndVersion::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IDBNameAndVersion_UnserializedMessageContext<
            UserType, IDBNameAndVersion::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IDBNameAndVersion::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string name;
  
  int64_t version;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IDBNameAndVersion::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IDBNameAndVersion::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IDBNameAndVersion::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IDBNameAndVersion::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT IDBIndexKeys {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IDBIndexKeys, T>::value>;
  using DataView = IDBIndexKeysDataView;
  using Data_ = internal::IDBIndexKeys_Data;

  template <typename... Args>
  static IDBIndexKeysPtr New(Args&&... args) {
    return IDBIndexKeysPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IDBIndexKeysPtr From(const U& u) {
    return mojo::TypeConverter<IDBIndexKeysPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IDBIndexKeys>::Convert(*this);
  }


  IDBIndexKeys();

  IDBIndexKeys(
      int64_t index_id,
      std::vector<::blink::IndexedDBKey> index_keys);

IDBIndexKeys(const IDBIndexKeys&) = delete;
IDBIndexKeys& operator=(const IDBIndexKeys&) = delete;

  ~IDBIndexKeys();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IDBIndexKeysPtr>
  IDBIndexKeysPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IDBIndexKeys::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IDBIndexKeys::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IDBIndexKeys::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IDBIndexKeys::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IDBIndexKeys::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IDBIndexKeys::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IDBIndexKeys_UnserializedMessageContext<
            UserType, IDBIndexKeys::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IDBIndexKeys::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IDBIndexKeys::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IDBIndexKeys_UnserializedMessageContext<
            UserType, IDBIndexKeys::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IDBIndexKeys::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t index_id;
  
  std::vector<::blink::IndexedDBKey> index_keys;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IDBIndexKeys::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IDBIndexKeys::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IDBIndexKeys::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IDBIndexKeys::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT IDBFileInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IDBFileInfo, T>::value>;
  using DataView = IDBFileInfoDataView;
  using Data_ = internal::IDBFileInfo_Data;

  template <typename... Args>
  static IDBFileInfoPtr New(Args&&... args) {
    return IDBFileInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IDBFileInfoPtr From(const U& u) {
    return mojo::TypeConverter<IDBFileInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IDBFileInfo>::Convert(*this);
  }


  IDBFileInfo();

  IDBFileInfo(
      const ::std::u16string& name,
      ::base::Time last_modified);


  ~IDBFileInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IDBFileInfoPtr>
  IDBFileInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IDBFileInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IDBFileInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IDBFileInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IDBFileInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IDBFileInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IDBFileInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IDBFileInfo_UnserializedMessageContext<
            UserType, IDBFileInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IDBFileInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IDBFileInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IDBFileInfo_UnserializedMessageContext<
            UserType, IDBFileInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IDBFileInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string name;
  
  ::base::Time last_modified;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IDBFileInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IDBFileInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IDBFileInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IDBFileInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT IDBBlobInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IDBBlobInfo, T>::value>;
  using DataView = IDBBlobInfoDataView;
  using Data_ = internal::IDBBlobInfo_Data;

  template <typename... Args>
  static IDBBlobInfoPtr New(Args&&... args) {
    return IDBBlobInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IDBBlobInfoPtr From(const U& u) {
    return mojo::TypeConverter<IDBBlobInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IDBBlobInfo>::Convert(*this);
  }


  IDBBlobInfo();

  IDBBlobInfo(
      ::mojo::PendingRemote<::blink::mojom::Blob> blob,
      const ::std::u16string& mime_type,
      int64_t size,
      IDBFileInfoPtr file);

IDBBlobInfo(const IDBBlobInfo&) = delete;
IDBBlobInfo& operator=(const IDBBlobInfo&) = delete;

  ~IDBBlobInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IDBBlobInfoPtr>
  IDBBlobInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IDBBlobInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IDBBlobInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IDBBlobInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IDBBlobInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IDBBlobInfo_UnserializedMessageContext<
            UserType, IDBBlobInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IDBBlobInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IDBBlobInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IDBBlobInfo_UnserializedMessageContext<
            UserType, IDBBlobInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IDBBlobInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PendingRemote<::blink::mojom::Blob> blob;
  
  ::std::u16string mime_type;
  
  int64_t size;
  
  IDBFileInfoPtr file;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IDBBlobInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IDBBlobInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IDBBlobInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IDBBlobInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT IDBValue {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IDBValue, T>::value>;
  using DataView = IDBValueDataView;
  using Data_ = internal::IDBValue_Data;

  template <typename... Args>
  static IDBValuePtr New(Args&&... args) {
    return IDBValuePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IDBValuePtr From(const U& u) {
    return mojo::TypeConverter<IDBValuePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IDBValue>::Convert(*this);
  }


  IDBValue();

  IDBValue(
      std::vector<uint8_t> bits,
      std::vector<IDBExternalObjectPtr> external_objects);

IDBValue(const IDBValue&) = delete;
IDBValue& operator=(const IDBValue&) = delete;

  ~IDBValue();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IDBValuePtr>
  IDBValuePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IDBValue::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IDBValue::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IDBValue::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IDBValue::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IDBValue_UnserializedMessageContext<
            UserType, IDBValue::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IDBValue::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IDBValue::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IDBValue_UnserializedMessageContext<
            UserType, IDBValue::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IDBValue::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<uint8_t> bits;
  
  std::vector<IDBExternalObjectPtr> external_objects;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IDBValue::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IDBValue::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IDBValue::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IDBValue::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT IDBReturnValue {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IDBReturnValue, T>::value>;
  using DataView = IDBReturnValueDataView;
  using Data_ = internal::IDBReturnValue_Data;

  template <typename... Args>
  static IDBReturnValuePtr New(Args&&... args) {
    return IDBReturnValuePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IDBReturnValuePtr From(const U& u) {
    return mojo::TypeConverter<IDBReturnValuePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IDBReturnValue>::Convert(*this);
  }


  IDBReturnValue();

  IDBReturnValue(
      IDBValuePtr value,
      ::blink::IndexedDBKey primary_key,
      const ::blink::IndexedDBKeyPath& key_path);

IDBReturnValue(const IDBReturnValue&) = delete;
IDBReturnValue& operator=(const IDBReturnValue&) = delete;

  ~IDBReturnValue();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IDBReturnValuePtr>
  IDBReturnValuePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IDBReturnValue::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IDBReturnValue::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IDBReturnValue::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IDBReturnValue::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IDBReturnValue_UnserializedMessageContext<
            UserType, IDBReturnValue::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IDBReturnValue::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IDBReturnValue::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IDBReturnValue_UnserializedMessageContext<
            UserType, IDBReturnValue::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IDBReturnValue::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  IDBValuePtr value;
  
  ::blink::IndexedDBKey primary_key;
  
  ::blink::IndexedDBKeyPath key_path;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IDBReturnValue::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IDBReturnValue::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IDBReturnValue::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IDBReturnValue::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT IDBRecord {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IDBRecord, T>::value>;
  using DataView = IDBRecordDataView;
  using Data_ = internal::IDBRecord_Data;

  template <typename... Args>
  static IDBRecordPtr New(Args&&... args) {
    return IDBRecordPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IDBRecordPtr From(const U& u) {
    return mojo::TypeConverter<IDBRecordPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IDBRecord>::Convert(*this);
  }


  IDBRecord();

  IDBRecord(
      std::optional<::blink::IndexedDBKey> primary_key,
      IDBReturnValuePtr return_value,
      std::optional<::blink::IndexedDBKey> index_key);

IDBRecord(const IDBRecord&) = delete;
IDBRecord& operator=(const IDBRecord&) = delete;

  ~IDBRecord();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IDBRecordPtr>
  IDBRecordPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IDBRecord::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IDBRecord::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IDBRecord::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IDBRecord::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IDBRecord_UnserializedMessageContext<
            UserType, IDBRecord::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IDBRecord::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IDBRecord::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IDBRecord_UnserializedMessageContext<
            UserType, IDBRecord::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IDBRecord::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::blink::IndexedDBKey> primary_key;
  
  IDBReturnValuePtr return_value;
  
  std::optional<::blink::IndexedDBKey> index_key;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IDBRecord::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IDBRecord::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IDBRecord::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IDBRecord::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT IDBError {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IDBError, T>::value>;
  using DataView = IDBErrorDataView;
  using Data_ = internal::IDBError_Data;

  template <typename... Args>
  static IDBErrorPtr New(Args&&... args) {
    return IDBErrorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IDBErrorPtr From(const U& u) {
    return mojo::TypeConverter<IDBErrorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IDBError>::Convert(*this);
  }


  IDBError();

  IDBError(
      IDBException error_code,
      const ::std::u16string& error_message);


  ~IDBError();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IDBErrorPtr>
  IDBErrorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IDBError::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IDBError::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IDBError::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IDBError::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IDBError::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IDBError::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IDBError_UnserializedMessageContext<
            UserType, IDBError::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IDBError::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IDBError::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IDBError_UnserializedMessageContext<
            UserType, IDBError::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IDBError::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  IDBException error_code;
  
  ::std::u16string error_message;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IDBError::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IDBError::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IDBError::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IDBError::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT IDBCursorValue {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IDBCursorValue, T>::value>;
  using DataView = IDBCursorValueDataView;
  using Data_ = internal::IDBCursorValue_Data;

  template <typename... Args>
  static IDBCursorValuePtr New(Args&&... args) {
    return IDBCursorValuePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IDBCursorValuePtr From(const U& u) {
    return mojo::TypeConverter<IDBCursorValuePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IDBCursorValue>::Convert(*this);
  }


  IDBCursorValue();

  IDBCursorValue(
      std::vector<::blink::IndexedDBKey> keys,
      std::vector<::blink::IndexedDBKey> primary_keys,
      std::vector<IDBValuePtr> values);

IDBCursorValue(const IDBCursorValue&) = delete;
IDBCursorValue& operator=(const IDBCursorValue&) = delete;

  ~IDBCursorValue();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IDBCursorValuePtr>
  IDBCursorValuePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IDBCursorValue::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IDBCursorValue::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IDBCursorValue::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IDBCursorValue::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IDBCursorValue_UnserializedMessageContext<
            UserType, IDBCursorValue::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IDBCursorValue::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IDBCursorValue::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IDBCursorValue_UnserializedMessageContext<
            UserType, IDBCursorValue::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IDBCursorValue::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<::blink::IndexedDBKey> keys;
  
  std::vector<::blink::IndexedDBKey> primary_keys;
  
  std::vector<IDBValuePtr> values;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IDBCursorValue::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IDBCursorValue::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IDBCursorValue::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IDBCursorValue::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT IDBDatabaseOpenCursorValue {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IDBDatabaseOpenCursorValue, T>::value>;
  using DataView = IDBDatabaseOpenCursorValueDataView;
  using Data_ = internal::IDBDatabaseOpenCursorValue_Data;

  template <typename... Args>
  static IDBDatabaseOpenCursorValuePtr New(Args&&... args) {
    return IDBDatabaseOpenCursorValuePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IDBDatabaseOpenCursorValuePtr From(const U& u) {
    return mojo::TypeConverter<IDBDatabaseOpenCursorValuePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IDBDatabaseOpenCursorValue>::Convert(*this);
  }


  IDBDatabaseOpenCursorValue();

  IDBDatabaseOpenCursorValue(
      ::mojo::PendingAssociatedRemote<IDBCursor> cursor,
      ::blink::IndexedDBKey key,
      ::blink::IndexedDBKey primary_key,
      IDBValuePtr value);

IDBDatabaseOpenCursorValue(const IDBDatabaseOpenCursorValue&) = delete;
IDBDatabaseOpenCursorValue& operator=(const IDBDatabaseOpenCursorValue&) = delete;

  ~IDBDatabaseOpenCursorValue();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IDBDatabaseOpenCursorValuePtr>
  IDBDatabaseOpenCursorValuePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IDBDatabaseOpenCursorValue::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IDBDatabaseOpenCursorValue::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IDBDatabaseOpenCursorValue::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IDBDatabaseOpenCursorValue::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IDBDatabaseOpenCursorValue_UnserializedMessageContext<
            UserType, IDBDatabaseOpenCursorValue::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IDBDatabaseOpenCursorValue::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IDBDatabaseOpenCursorValue::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IDBDatabaseOpenCursorValue_UnserializedMessageContext<
            UserType, IDBDatabaseOpenCursorValue::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IDBDatabaseOpenCursorValue::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PendingAssociatedRemote<IDBCursor> cursor;
  
  ::blink::IndexedDBKey key;
  
  ::blink::IndexedDBKey primary_key;
  
  IDBValuePtr value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IDBDatabaseOpenCursorValue::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IDBDatabaseOpenCursorValue::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IDBDatabaseOpenCursorValue::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IDBDatabaseOpenCursorValue::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
IDBKeyPtr IDBKey::Clone() const {
  switch (tag_) {
    case Tag::kKeyArray:
      return NewKeyArray(
          mojo::Clone(data_.key_array));
    case Tag::kBinary:
      return NewBinary(
          mojo::Clone(data_.binary));
    case Tag::kString:
      return NewString(
          mojo::Clone(data_.string));
    case Tag::kDate:
      return NewDate(
          mojo::Clone(data_.date));
    case Tag::kNumber:
      return NewNumber(
          mojo::Clone(data_.number));
    case Tag::kOtherNone:
      return NewOtherNone(
          mojo::Clone(data_.other_none));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, IDBKey>::value>::type*>
bool IDBKey::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kKeyArray:
      return mojo::Equals(data_.key_array, other.data_.key_array);
    case Tag::kBinary:
      return mojo::Equals(data_.binary, other.data_.binary);
    case Tag::kString:
      return mojo::Equals(data_.string, other.data_.string);
    case Tag::kDate:
      return mojo::Equals(data_.date, other.data_.date);
    case Tag::kNumber:
      return mojo::Equals(data_.number, other.data_.number);
    case Tag::kOtherNone:
      return mojo::Equals(data_.other_none, other.data_.other_none);
  }

  return false;
}
template <typename UnionPtrType>
IDBKeyPathDataPtr IDBKeyPathData::Clone() const {
  switch (tag_) {
    case Tag::kString:
      return NewString(
          mojo::Clone(data_.string));
    case Tag::kStringArray:
      return NewStringArray(
          mojo::Clone(data_.string_array));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, IDBKeyPathData>::value>::type*>
bool IDBKeyPathData::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kString:
      return mojo::Equals(data_.string, other.data_.string);
    case Tag::kStringArray:
      return mojo::Equals(data_.string_array, other.data_.string_array);
  }

  return false;
}
template <typename UnionPtrType>
IDBExternalObjectPtr IDBExternalObject::Clone() const {
  switch (tag_) {
    case Tag::kBlobOrFile:
      return NewBlobOrFile(
          mojo::Clone(data_.blob_or_file));
    case Tag::kFileSystemAccessToken:
      return NewFileSystemAccessToken(
          mojo::Clone(data_.file_system_access_token));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, IDBExternalObject>::value>::type*>
bool IDBExternalObject::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kBlobOrFile:
      return mojo::Equals(data_.blob_or_file, other.data_.blob_or_file);
    case Tag::kFileSystemAccessToken:
      return mojo::Equals(data_.file_system_access_token, other.data_.file_system_access_token);
  }

  return false;
}
template <typename UnionPtrType>
IDBCursorResultPtr IDBCursorResult::Clone() const {
  switch (tag_) {
    case Tag::kErrorResult:
      return NewErrorResult(
          mojo::Clone(data_.error_result));
    case Tag::kEmpty:
      return NewEmpty(
          mojo::Clone(data_.empty));
    case Tag::kValues:
      return NewValues(
          mojo::Clone(data_.values));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, IDBCursorResult>::value>::type*>
bool IDBCursorResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kErrorResult:
      return mojo::Equals(data_.error_result, other.data_.error_result);
    case Tag::kEmpty:
      return mojo::Equals(data_.empty, other.data_.empty);
    case Tag::kValues:
      return mojo::Equals(data_.values, other.data_.values);
  }

  return false;
}
template <typename UnionPtrType>
IDBTransactionPutResultPtr IDBTransactionPutResult::Clone() const {
  switch (tag_) {
    case Tag::kErrorResult:
      return NewErrorResult(
          mojo::Clone(data_.error_result));
    case Tag::kKey:
      return NewKey(
          mojo::Clone(data_.key));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, IDBTransactionPutResult>::value>::type*>
bool IDBTransactionPutResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kErrorResult:
      return mojo::Equals(data_.error_result, other.data_.error_result);
    case Tag::kKey:
      return mojo::Equals(data_.key, other.data_.key);
  }

  return false;
}
template <typename UnionPtrType>
IDBDatabaseGetResultPtr IDBDatabaseGetResult::Clone() const {
  switch (tag_) {
    case Tag::kErrorResult:
      return NewErrorResult(
          mojo::Clone(data_.error_result));
    case Tag::kEmpty:
      return NewEmpty(
          mojo::Clone(data_.empty));
    case Tag::kKey:
      return NewKey(
          mojo::Clone(data_.key));
    case Tag::kValue:
      return NewValue(
          mojo::Clone(data_.value));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, IDBDatabaseGetResult>::value>::type*>
bool IDBDatabaseGetResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kErrorResult:
      return mojo::Equals(data_.error_result, other.data_.error_result);
    case Tag::kEmpty:
      return mojo::Equals(data_.empty, other.data_.empty);
    case Tag::kKey:
      return mojo::Equals(data_.key, other.data_.key);
    case Tag::kValue:
      return mojo::Equals(data_.value, other.data_.value);
  }

  return false;
}
template <typename UnionPtrType>
IDBDatabaseOpenCursorResultPtr IDBDatabaseOpenCursorResult::Clone() const {
  switch (tag_) {
    case Tag::kErrorResult:
      return NewErrorResult(
          mojo::Clone(data_.error_result));
    case Tag::kEmpty:
      return NewEmpty(
          mojo::Clone(data_.empty));
    case Tag::kValue:
      return NewValue(
          mojo::Clone(data_.value));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, IDBDatabaseOpenCursorResult>::value>::type*>
bool IDBDatabaseOpenCursorResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kErrorResult:
      return mojo::Equals(data_.error_result, other.data_.error_result);
    case Tag::kEmpty:
      return mojo::Equals(data_.empty, other.data_.empty);
    case Tag::kValue:
      return mojo::Equals(data_.value, other.data_.value);
  }

  return false;
}
template <typename StructPtrType>
IDBKeyPathPtr IDBKeyPath::Clone() const {
  return New(
      mojo::Clone(data)
  );
}

template <typename T, IDBKeyPath::EnableIfSame<T>*>
bool IDBKeyPath::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, IDBKeyPath::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  return false;
}
template <typename StructPtrType>
IDBKeyRangePtr IDBKeyRange::Clone() const {
  return New(
      mojo::Clone(lower),
      mojo::Clone(upper),
      mojo::Clone(lower_open),
      mojo::Clone(upper_open)
  );
}

template <typename T, IDBKeyRange::EnableIfSame<T>*>
bool IDBKeyRange::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->lower, other_struct.lower))
    return false;
  if (!mojo::Equals(this->upper, other_struct.upper))
    return false;
  if (!mojo::Equals(this->lower_open, other_struct.lower_open))
    return false;
  if (!mojo::Equals(this->upper_open, other_struct.upper_open))
    return false;
  return true;
}

template <typename T, IDBKeyRange::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.lower < rhs.lower)
    return true;
  if (rhs.lower < lhs.lower)
    return false;
  if (lhs.upper < rhs.upper)
    return true;
  if (rhs.upper < lhs.upper)
    return false;
  if (lhs.lower_open < rhs.lower_open)
    return true;
  if (rhs.lower_open < lhs.lower_open)
    return false;
  if (lhs.upper_open < rhs.upper_open)
    return true;
  if (rhs.upper_open < lhs.upper_open)
    return false;
  return false;
}
template <typename StructPtrType>
IDBIndexMetadataPtr IDBIndexMetadata::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(name),
      mojo::Clone(key_path),
      mojo::Clone(unique),
      mojo::Clone(multi_entry)
  );
}

template <typename T, IDBIndexMetadata::EnableIfSame<T>*>
bool IDBIndexMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->key_path, other_struct.key_path))
    return false;
  if (!mojo::Equals(this->unique, other_struct.unique))
    return false;
  if (!mojo::Equals(this->multi_entry, other_struct.multi_entry))
    return false;
  return true;
}

template <typename T, IDBIndexMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.key_path < rhs.key_path)
    return true;
  if (rhs.key_path < lhs.key_path)
    return false;
  if (lhs.unique < rhs.unique)
    return true;
  if (rhs.unique < lhs.unique)
    return false;
  if (lhs.multi_entry < rhs.multi_entry)
    return true;
  if (rhs.multi_entry < lhs.multi_entry)
    return false;
  return false;
}
template <typename StructPtrType>
IDBObjectStoreMetadataPtr IDBObjectStoreMetadata::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(name),
      mojo::Clone(key_path),
      mojo::Clone(auto_increment),
      mojo::Clone(max_index_id),
      mojo::Clone(indexes)
  );
}

template <typename T, IDBObjectStoreMetadata::EnableIfSame<T>*>
bool IDBObjectStoreMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->key_path, other_struct.key_path))
    return false;
  if (!mojo::Equals(this->auto_increment, other_struct.auto_increment))
    return false;
  if (!mojo::Equals(this->max_index_id, other_struct.max_index_id))
    return false;
  if (!mojo::Equals(this->indexes, other_struct.indexes))
    return false;
  return true;
}

template <typename T, IDBObjectStoreMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.key_path < rhs.key_path)
    return true;
  if (rhs.key_path < lhs.key_path)
    return false;
  if (lhs.auto_increment < rhs.auto_increment)
    return true;
  if (rhs.auto_increment < lhs.auto_increment)
    return false;
  if (lhs.max_index_id < rhs.max_index_id)
    return true;
  if (rhs.max_index_id < lhs.max_index_id)
    return false;
  if (lhs.indexes < rhs.indexes)
    return true;
  if (rhs.indexes < lhs.indexes)
    return false;
  return false;
}
template <typename StructPtrType>
IDBDatabaseMetadataPtr IDBDatabaseMetadata::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(version),
      mojo::Clone(max_object_store_id),
      mojo::Clone(object_stores),
      mojo::Clone(was_cold_open),
      mojo::Clone(is_sqlite)
  );
}

template <typename T, IDBDatabaseMetadata::EnableIfSame<T>*>
bool IDBDatabaseMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->version, other_struct.version))
    return false;
  if (!mojo::Equals(this->max_object_store_id, other_struct.max_object_store_id))
    return false;
  if (!mojo::Equals(this->object_stores, other_struct.object_stores))
    return false;
  if (!mojo::Equals(this->was_cold_open, other_struct.was_cold_open))
    return false;
  if (!mojo::Equals(this->is_sqlite, other_struct.is_sqlite))
    return false;
  return true;
}

template <typename T, IDBDatabaseMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.version < rhs.version)
    return true;
  if (rhs.version < lhs.version)
    return false;
  if (lhs.max_object_store_id < rhs.max_object_store_id)
    return true;
  if (rhs.max_object_store_id < lhs.max_object_store_id)
    return false;
  if (lhs.object_stores < rhs.object_stores)
    return true;
  if (rhs.object_stores < lhs.object_stores)
    return false;
  if (lhs.was_cold_open < rhs.was_cold_open)
    return true;
  if (rhs.was_cold_open < lhs.was_cold_open)
    return false;
  if (lhs.is_sqlite < rhs.is_sqlite)
    return true;
  if (rhs.is_sqlite < lhs.is_sqlite)
    return false;
  return false;
}
template <typename StructPtrType>
IDBNameAndVersionPtr IDBNameAndVersion::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(version)
  );
}

template <typename T, IDBNameAndVersion::EnableIfSame<T>*>
bool IDBNameAndVersion::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->version, other_struct.version))
    return false;
  return true;
}

template <typename T, IDBNameAndVersion::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.version < rhs.version)
    return true;
  if (rhs.version < lhs.version)
    return false;
  return false;
}
template <typename StructPtrType>
IDBIndexKeysPtr IDBIndexKeys::Clone() const {
  return New(
      mojo::Clone(index_id),
      mojo::Clone(index_keys)
  );
}

template <typename T, IDBIndexKeys::EnableIfSame<T>*>
bool IDBIndexKeys::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->index_id, other_struct.index_id))
    return false;
  if (!mojo::Equals(this->index_keys, other_struct.index_keys))
    return false;
  return true;
}

template <typename T, IDBIndexKeys::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.index_id < rhs.index_id)
    return true;
  if (rhs.index_id < lhs.index_id)
    return false;
  if (lhs.index_keys < rhs.index_keys)
    return true;
  if (rhs.index_keys < lhs.index_keys)
    return false;
  return false;
}
template <typename StructPtrType>
IDBFileInfoPtr IDBFileInfo::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(last_modified)
  );
}

template <typename T, IDBFileInfo::EnableIfSame<T>*>
bool IDBFileInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->last_modified, other_struct.last_modified))
    return false;
  return true;
}

template <typename T, IDBFileInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.last_modified < rhs.last_modified)
    return true;
  if (rhs.last_modified < lhs.last_modified)
    return false;
  return false;
}
template <typename StructPtrType>
IDBBlobInfoPtr IDBBlobInfo::Clone() const {
  return New(
      mojo::Clone(blob),
      mojo::Clone(mime_type),
      mojo::Clone(size),
      mojo::Clone(file)
  );
}

template <typename T, IDBBlobInfo::EnableIfSame<T>*>
bool IDBBlobInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->blob, other_struct.blob))
    return false;
  if (!mojo::Equals(this->mime_type, other_struct.mime_type))
    return false;
  if (!mojo::Equals(this->size, other_struct.size))
    return false;
  if (!mojo::Equals(this->file, other_struct.file))
    return false;
  return true;
}

template <typename T, IDBBlobInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.blob < rhs.blob)
    return true;
  if (rhs.blob < lhs.blob)
    return false;
  if (lhs.mime_type < rhs.mime_type)
    return true;
  if (rhs.mime_type < lhs.mime_type)
    return false;
  if (lhs.size < rhs.size)
    return true;
  if (rhs.size < lhs.size)
    return false;
  if (lhs.file < rhs.file)
    return true;
  if (rhs.file < lhs.file)
    return false;
  return false;
}
template <typename StructPtrType>
IDBValuePtr IDBValue::Clone() const {
  return New(
      mojo::Clone(bits),
      mojo::Clone(external_objects)
  );
}

template <typename T, IDBValue::EnableIfSame<T>*>
bool IDBValue::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->bits, other_struct.bits))
    return false;
  if (!mojo::Equals(this->external_objects, other_struct.external_objects))
    return false;
  return true;
}

template <typename T, IDBValue::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.bits < rhs.bits)
    return true;
  if (rhs.bits < lhs.bits)
    return false;
  if (lhs.external_objects < rhs.external_objects)
    return true;
  if (rhs.external_objects < lhs.external_objects)
    return false;
  return false;
}
template <typename StructPtrType>
IDBReturnValuePtr IDBReturnValue::Clone() const {
  return New(
      mojo::Clone(value),
      mojo::Clone(primary_key),
      mojo::Clone(key_path)
  );
}

template <typename T, IDBReturnValue::EnableIfSame<T>*>
bool IDBReturnValue::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  if (!mojo::Equals(this->primary_key, other_struct.primary_key))
    return false;
  if (!mojo::Equals(this->key_path, other_struct.key_path))
    return false;
  return true;
}

template <typename T, IDBReturnValue::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  if (lhs.primary_key < rhs.primary_key)
    return true;
  if (rhs.primary_key < lhs.primary_key)
    return false;
  if (lhs.key_path < rhs.key_path)
    return true;
  if (rhs.key_path < lhs.key_path)
    return false;
  return false;
}
template <typename StructPtrType>
IDBRecordPtr IDBRecord::Clone() const {
  return New(
      mojo::Clone(primary_key),
      mojo::Clone(return_value),
      mojo::Clone(index_key)
  );
}

template <typename T, IDBRecord::EnableIfSame<T>*>
bool IDBRecord::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->primary_key, other_struct.primary_key))
    return false;
  if (!mojo::Equals(this->return_value, other_struct.return_value))
    return false;
  if (!mojo::Equals(this->index_key, other_struct.index_key))
    return false;
  return true;
}

template <typename T, IDBRecord::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.primary_key < rhs.primary_key)
    return true;
  if (rhs.primary_key < lhs.primary_key)
    return false;
  if (lhs.return_value < rhs.return_value)
    return true;
  if (rhs.return_value < lhs.return_value)
    return false;
  if (lhs.index_key < rhs.index_key)
    return true;
  if (rhs.index_key < lhs.index_key)
    return false;
  return false;
}
template <typename StructPtrType>
IDBErrorPtr IDBError::Clone() const {
  return New(
      mojo::Clone(error_code),
      mojo::Clone(error_message)
  );
}

template <typename T, IDBError::EnableIfSame<T>*>
bool IDBError::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->error_code, other_struct.error_code))
    return false;
  if (!mojo::Equals(this->error_message, other_struct.error_message))
    return false;
  return true;
}

template <typename T, IDBError::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.error_code < rhs.error_code)
    return true;
  if (rhs.error_code < lhs.error_code)
    return false;
  if (lhs.error_message < rhs.error_message)
    return true;
  if (rhs.error_message < lhs.error_message)
    return false;
  return false;
}
template <typename StructPtrType>
IDBCursorValuePtr IDBCursorValue::Clone() const {
  return New(
      mojo::Clone(keys),
      mojo::Clone(primary_keys),
      mojo::Clone(values)
  );
}

template <typename T, IDBCursorValue::EnableIfSame<T>*>
bool IDBCursorValue::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->keys, other_struct.keys))
    return false;
  if (!mojo::Equals(this->primary_keys, other_struct.primary_keys))
    return false;
  if (!mojo::Equals(this->values, other_struct.values))
    return false;
  return true;
}

template <typename T, IDBCursorValue::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.keys < rhs.keys)
    return true;
  if (rhs.keys < lhs.keys)
    return false;
  if (lhs.primary_keys < rhs.primary_keys)
    return true;
  if (rhs.primary_keys < lhs.primary_keys)
    return false;
  if (lhs.values < rhs.values)
    return true;
  if (rhs.values < lhs.values)
    return false;
  return false;
}
template <typename StructPtrType>
IDBDatabaseOpenCursorValuePtr IDBDatabaseOpenCursorValue::Clone() const {
  return New(
      mojo::Clone(cursor),
      mojo::Clone(key),
      mojo::Clone(primary_key),
      mojo::Clone(value)
  );
}

template <typename T, IDBDatabaseOpenCursorValue::EnableIfSame<T>*>
bool IDBDatabaseOpenCursorValue::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->cursor, other_struct.cursor))
    return false;
  if (!mojo::Equals(this->key, other_struct.key))
    return false;
  if (!mojo::Equals(this->primary_key, other_struct.primary_key))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, IDBDatabaseOpenCursorValue::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.cursor < rhs.cursor)
    return true;
  if (rhs.cursor < lhs.cursor)
    return false;
  if (lhs.key < rhs.key)
    return true;
  if (rhs.key < lhs.key)
    return false;
  if (lhs.primary_key < rhs.primary_key)
    return true;
  if (rhs.primary_key < lhs.primary_key)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::IDBKeyPath::DataView,
                                         ::blink::mojom::IDBKeyPathPtr> {
  static bool IsNull(const ::blink::mojom::IDBKeyPathPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::IDBKeyPathPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::IDBKeyPath::data)& data(
      const ::blink::mojom::IDBKeyPathPtr& input) {
    return input->data;
  }

  static bool Read(::blink::mojom::IDBKeyPath::DataView input, ::blink::mojom::IDBKeyPathPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::IDBKeyRange::DataView,
                                         ::blink::mojom::IDBKeyRangePtr> {
  static bool IsNull(const ::blink::mojom::IDBKeyRangePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::IDBKeyRangePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::IDBKeyRange::lower)& lower(
      const ::blink::mojom::IDBKeyRangePtr& input) {
    return input->lower;
  }

  static const decltype(::blink::mojom::IDBKeyRange::upper)& upper(
      const ::blink::mojom::IDBKeyRangePtr& input) {
    return input->upper;
  }

  static decltype(::blink::mojom::IDBKeyRange::lower_open) lower_open(
      const ::blink::mojom::IDBKeyRangePtr& input) {
    return input->lower_open;
  }

  static decltype(::blink::mojom::IDBKeyRange::upper_open) upper_open(
      const ::blink::mojom::IDBKeyRangePtr& input) {
    return input->upper_open;
  }

  static bool Read(::blink::mojom::IDBKeyRange::DataView input, ::blink::mojom::IDBKeyRangePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::IDBIndexMetadata::DataView,
                                         ::blink::mojom::IDBIndexMetadataPtr> {
  static bool IsNull(const ::blink::mojom::IDBIndexMetadataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::IDBIndexMetadataPtr* output) { output->reset(); }

  static decltype(::blink::mojom::IDBIndexMetadata::id) id(
      const ::blink::mojom::IDBIndexMetadataPtr& input) {
    return input->id;
  }

  static const decltype(::blink::mojom::IDBIndexMetadata::name)& name(
      const ::blink::mojom::IDBIndexMetadataPtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::IDBIndexMetadata::key_path)& key_path(
      const ::blink::mojom::IDBIndexMetadataPtr& input) {
    return input->key_path;
  }

  static decltype(::blink::mojom::IDBIndexMetadata::unique) unique(
      const ::blink::mojom::IDBIndexMetadataPtr& input) {
    return input->unique;
  }

  static decltype(::blink::mojom::IDBIndexMetadata::multi_entry) multi_entry(
      const ::blink::mojom::IDBIndexMetadataPtr& input) {
    return input->multi_entry;
  }

  static bool Read(::blink::mojom::IDBIndexMetadata::DataView input, ::blink::mojom::IDBIndexMetadataPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::IDBObjectStoreMetadata::DataView,
                                         ::blink::mojom::IDBObjectStoreMetadataPtr> {
  static bool IsNull(const ::blink::mojom::IDBObjectStoreMetadataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::IDBObjectStoreMetadataPtr* output) { output->reset(); }

  static decltype(::blink::mojom::IDBObjectStoreMetadata::id) id(
      const ::blink::mojom::IDBObjectStoreMetadataPtr& input) {
    return input->id;
  }

  static const decltype(::blink::mojom::IDBObjectStoreMetadata::name)& name(
      const ::blink::mojom::IDBObjectStoreMetadataPtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::IDBObjectStoreMetadata::key_path)& key_path(
      const ::blink::mojom::IDBObjectStoreMetadataPtr& input) {
    return input->key_path;
  }

  static decltype(::blink::mojom::IDBObjectStoreMetadata::auto_increment) auto_increment(
      const ::blink::mojom::IDBObjectStoreMetadataPtr& input) {
    return input->auto_increment;
  }

  static decltype(::blink::mojom::IDBObjectStoreMetadata::max_index_id) max_index_id(
      const ::blink::mojom::IDBObjectStoreMetadataPtr& input) {
    return input->max_index_id;
  }

  static const decltype(::blink::mojom::IDBObjectStoreMetadata::indexes)& indexes(
      const ::blink::mojom::IDBObjectStoreMetadataPtr& input) {
    return input->indexes;
  }

  static bool Read(::blink::mojom::IDBObjectStoreMetadata::DataView input, ::blink::mojom::IDBObjectStoreMetadataPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::IDBDatabaseMetadata::DataView,
                                         ::blink::mojom::IDBDatabaseMetadataPtr> {
  static bool IsNull(const ::blink::mojom::IDBDatabaseMetadataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::IDBDatabaseMetadataPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::IDBDatabaseMetadata::name)& name(
      const ::blink::mojom::IDBDatabaseMetadataPtr& input) {
    return input->name;
  }

  static decltype(::blink::mojom::IDBDatabaseMetadata::version) version(
      const ::blink::mojom::IDBDatabaseMetadataPtr& input) {
    return input->version;
  }

  static decltype(::blink::mojom::IDBDatabaseMetadata::max_object_store_id) max_object_store_id(
      const ::blink::mojom::IDBDatabaseMetadataPtr& input) {
    return input->max_object_store_id;
  }

  static const decltype(::blink::mojom::IDBDatabaseMetadata::object_stores)& object_stores(
      const ::blink::mojom::IDBDatabaseMetadataPtr& input) {
    return input->object_stores;
  }

  static decltype(::blink::mojom::IDBDatabaseMetadata::was_cold_open) was_cold_open(
      const ::blink::mojom::IDBDatabaseMetadataPtr& input) {
    return input->was_cold_open;
  }

  static decltype(::blink::mojom::IDBDatabaseMetadata::is_sqlite) is_sqlite(
      const ::blink::mojom::IDBDatabaseMetadataPtr& input) {
    return input->is_sqlite;
  }

  static bool Read(::blink::mojom::IDBDatabaseMetadata::DataView input, ::blink::mojom::IDBDatabaseMetadataPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::IDBNameAndVersion::DataView,
                                         ::blink::mojom::IDBNameAndVersionPtr> {
  static bool IsNull(const ::blink::mojom::IDBNameAndVersionPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::IDBNameAndVersionPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::IDBNameAndVersion::name)& name(
      const ::blink::mojom::IDBNameAndVersionPtr& input) {
    return input->name;
  }

  static decltype(::blink::mojom::IDBNameAndVersion::version) version(
      const ::blink::mojom::IDBNameAndVersionPtr& input) {
    return input->version;
  }

  static bool Read(::blink::mojom::IDBNameAndVersion::DataView input, ::blink::mojom::IDBNameAndVersionPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::IDBIndexKeys::DataView,
                                         ::blink::mojom::IDBIndexKeysPtr> {
  static bool IsNull(const ::blink::mojom::IDBIndexKeysPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::IDBIndexKeysPtr* output) { output->reset(); }

  static decltype(::blink::mojom::IDBIndexKeys::index_id) index_id(
      const ::blink::mojom::IDBIndexKeysPtr& input) {
    return input->index_id;
  }

  static const decltype(::blink::mojom::IDBIndexKeys::index_keys)& index_keys(
      const ::blink::mojom::IDBIndexKeysPtr& input) {
    return input->index_keys;
  }

  static bool Read(::blink::mojom::IDBIndexKeys::DataView input, ::blink::mojom::IDBIndexKeysPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::IDBFileInfo::DataView,
                                         ::blink::mojom::IDBFileInfoPtr> {
  static bool IsNull(const ::blink::mojom::IDBFileInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::IDBFileInfoPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::IDBFileInfo::name)& name(
      const ::blink::mojom::IDBFileInfoPtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::IDBFileInfo::last_modified)& last_modified(
      const ::blink::mojom::IDBFileInfoPtr& input) {
    return input->last_modified;
  }

  static bool Read(::blink::mojom::IDBFileInfo::DataView input, ::blink::mojom::IDBFileInfoPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::IDBBlobInfo::DataView,
                                         ::blink::mojom::IDBBlobInfoPtr> {
  static bool IsNull(const ::blink::mojom::IDBBlobInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::IDBBlobInfoPtr* output) { output->reset(); }

  static  decltype(::blink::mojom::IDBBlobInfo::blob)& blob(
       ::blink::mojom::IDBBlobInfoPtr& input) {
    return input->blob;
  }

  static const decltype(::blink::mojom::IDBBlobInfo::mime_type)& mime_type(
      const ::blink::mojom::IDBBlobInfoPtr& input) {
    return input->mime_type;
  }

  static decltype(::blink::mojom::IDBBlobInfo::size) size(
      const ::blink::mojom::IDBBlobInfoPtr& input) {
    return input->size;
  }

  static const decltype(::blink::mojom::IDBBlobInfo::file)& file(
      const ::blink::mojom::IDBBlobInfoPtr& input) {
    return input->file;
  }

  static bool Read(::blink::mojom::IDBBlobInfo::DataView input, ::blink::mojom::IDBBlobInfoPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::IDBValue::DataView,
                                         ::blink::mojom::IDBValuePtr> {
  static bool IsNull(const ::blink::mojom::IDBValuePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::IDBValuePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::IDBValue::bits)& bits(
      const ::blink::mojom::IDBValuePtr& input) {
    return input->bits;
  }

  static  decltype(::blink::mojom::IDBValue::external_objects)& external_objects(
       ::blink::mojom::IDBValuePtr& input) {
    return input->external_objects;
  }

  static bool Read(::blink::mojom::IDBValue::DataView input, ::blink::mojom::IDBValuePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::IDBReturnValue::DataView,
                                         ::blink::mojom::IDBReturnValuePtr> {
  static bool IsNull(const ::blink::mojom::IDBReturnValuePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::IDBReturnValuePtr* output) { output->reset(); }

  static  decltype(::blink::mojom::IDBReturnValue::value)& value(
       ::blink::mojom::IDBReturnValuePtr& input) {
    return input->value;
  }

  static const decltype(::blink::mojom::IDBReturnValue::primary_key)& primary_key(
      const ::blink::mojom::IDBReturnValuePtr& input) {
    return input->primary_key;
  }

  static const decltype(::blink::mojom::IDBReturnValue::key_path)& key_path(
      const ::blink::mojom::IDBReturnValuePtr& input) {
    return input->key_path;
  }

  static bool Read(::blink::mojom::IDBReturnValue::DataView input, ::blink::mojom::IDBReturnValuePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::IDBRecord::DataView,
                                         ::blink::mojom::IDBRecordPtr> {
  static bool IsNull(const ::blink::mojom::IDBRecordPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::IDBRecordPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::IDBRecord::primary_key)& primary_key(
      const ::blink::mojom::IDBRecordPtr& input) {
    return input->primary_key;
  }

  static  decltype(::blink::mojom::IDBRecord::return_value)& return_value(
       ::blink::mojom::IDBRecordPtr& input) {
    return input->return_value;
  }

  static const decltype(::blink::mojom::IDBRecord::index_key)& index_key(
      const ::blink::mojom::IDBRecordPtr& input) {
    return input->index_key;
  }

  static bool Read(::blink::mojom::IDBRecord::DataView input, ::blink::mojom::IDBRecordPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::IDBError::DataView,
                                         ::blink::mojom::IDBErrorPtr> {
  static bool IsNull(const ::blink::mojom::IDBErrorPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::IDBErrorPtr* output) { output->reset(); }

  static decltype(::blink::mojom::IDBError::error_code) error_code(
      const ::blink::mojom::IDBErrorPtr& input) {
    return input->error_code;
  }

  static const decltype(::blink::mojom::IDBError::error_message)& error_message(
      const ::blink::mojom::IDBErrorPtr& input) {
    return input->error_message;
  }

  static bool Read(::blink::mojom::IDBError::DataView input, ::blink::mojom::IDBErrorPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::IDBCursorValue::DataView,
                                         ::blink::mojom::IDBCursorValuePtr> {
  static bool IsNull(const ::blink::mojom::IDBCursorValuePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::IDBCursorValuePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::IDBCursorValue::keys)& keys(
      const ::blink::mojom::IDBCursorValuePtr& input) {
    return input->keys;
  }

  static const decltype(::blink::mojom::IDBCursorValue::primary_keys)& primary_keys(
      const ::blink::mojom::IDBCursorValuePtr& input) {
    return input->primary_keys;
  }

  static  decltype(::blink::mojom::IDBCursorValue::values)& values(
       ::blink::mojom::IDBCursorValuePtr& input) {
    return input->values;
  }

  static bool Read(::blink::mojom::IDBCursorValue::DataView input, ::blink::mojom::IDBCursorValuePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::IDBDatabaseOpenCursorValue::DataView,
                                         ::blink::mojom::IDBDatabaseOpenCursorValuePtr> {
  static bool IsNull(const ::blink::mojom::IDBDatabaseOpenCursorValuePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::IDBDatabaseOpenCursorValuePtr* output) { output->reset(); }

  static  decltype(::blink::mojom::IDBDatabaseOpenCursorValue::cursor)& cursor(
       ::blink::mojom::IDBDatabaseOpenCursorValuePtr& input) {
    return input->cursor;
  }

  static const decltype(::blink::mojom::IDBDatabaseOpenCursorValue::key)& key(
      const ::blink::mojom::IDBDatabaseOpenCursorValuePtr& input) {
    return input->key;
  }

  static const decltype(::blink::mojom::IDBDatabaseOpenCursorValue::primary_key)& primary_key(
      const ::blink::mojom::IDBDatabaseOpenCursorValuePtr& input) {
    return input->primary_key;
  }

  static  decltype(::blink::mojom::IDBDatabaseOpenCursorValue::value)& value(
       ::blink::mojom::IDBDatabaseOpenCursorValuePtr& input) {
    return input->value;
  }

  static bool Read(::blink::mojom::IDBDatabaseOpenCursorValue::DataView input, ::blink::mojom::IDBDatabaseOpenCursorValuePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::IDBKey::DataView,
                                        ::blink::mojom::IDBKeyPtr> {
  static bool IsNull(const ::blink::mojom::IDBKeyPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::IDBKeyPtr* output) { output->reset(); }

  static ::blink::mojom::IDBKey::Tag GetTag(const ::blink::mojom::IDBKeyPtr& input) {
    return input->which();
  }

  static const std::vector<::blink::IndexedDBKey>& key_array(const ::blink::mojom::IDBKeyPtr& input) {
    return input->get_key_array();
  }

  static const std::vector<uint8_t>& binary(const ::blink::mojom::IDBKeyPtr& input) {
    return input->get_binary();
  }

  static const ::std::u16string& string(const ::blink::mojom::IDBKeyPtr& input) {
    return input->get_string();
  }

  static  double date(const ::blink::mojom::IDBKeyPtr& input) {
    return input->get_date();
  }

  static  double number(const ::blink::mojom::IDBKeyPtr& input) {
    return input->get_number();
  }

  static  bool other_none(const ::blink::mojom::IDBKeyPtr& input) {
    return input->get_other_none();
  }

  static bool Read(::blink::mojom::IDBKey::DataView input, ::blink::mojom::IDBKeyPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::IDBKeyPathData::DataView,
                                        ::blink::mojom::IDBKeyPathDataPtr> {
  static bool IsNull(const ::blink::mojom::IDBKeyPathDataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::IDBKeyPathDataPtr* output) { output->reset(); }

  static ::blink::mojom::IDBKeyPathData::Tag GetTag(const ::blink::mojom::IDBKeyPathDataPtr& input) {
    return input->which();
  }

  static const ::std::u16string& string(const ::blink::mojom::IDBKeyPathDataPtr& input) {
    return input->get_string();
  }

  static const std::vector<::std::u16string>& string_array(const ::blink::mojom::IDBKeyPathDataPtr& input) {
    return input->get_string_array();
  }

  static bool Read(::blink::mojom::IDBKeyPathData::DataView input, ::blink::mojom::IDBKeyPathDataPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::IDBExternalObject::DataView,
                                        ::blink::mojom::IDBExternalObjectPtr> {
  static bool IsNull(const ::blink::mojom::IDBExternalObjectPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::IDBExternalObjectPtr* output) { output->reset(); }

  static ::blink::mojom::IDBExternalObject::Tag GetTag(const ::blink::mojom::IDBExternalObjectPtr& input) {
    return input->which();
  }

  static  ::blink::mojom::IDBBlobInfoPtr& blob_or_file( ::blink::mojom::IDBExternalObjectPtr& input) {
    return input->get_blob_or_file();
  }

  static  ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken>& file_system_access_token( ::blink::mojom::IDBExternalObjectPtr& input) {
    return input->get_file_system_access_token();
  }

  static bool Read(::blink::mojom::IDBExternalObject::DataView input, ::blink::mojom::IDBExternalObjectPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::IDBCursorResult::DataView,
                                        ::blink::mojom::IDBCursorResultPtr> {
  static bool IsNull(const ::blink::mojom::IDBCursorResultPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::IDBCursorResultPtr* output) { output->reset(); }

  static ::blink::mojom::IDBCursorResult::Tag GetTag(const ::blink::mojom::IDBCursorResultPtr& input) {
    return input->which();
  }

  static const ::blink::mojom::IDBErrorPtr& error_result(const ::blink::mojom::IDBCursorResultPtr& input) {
    return input->get_error_result();
  }

  static  bool empty(const ::blink::mojom::IDBCursorResultPtr& input) {
    return input->get_empty();
  }

  static  ::blink::mojom::IDBCursorValuePtr& values( ::blink::mojom::IDBCursorResultPtr& input) {
    return input->get_values();
  }

  static bool Read(::blink::mojom::IDBCursorResult::DataView input, ::blink::mojom::IDBCursorResultPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::IDBTransactionPutResult::DataView,
                                        ::blink::mojom::IDBTransactionPutResultPtr> {
  static bool IsNull(const ::blink::mojom::IDBTransactionPutResultPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::IDBTransactionPutResultPtr* output) { output->reset(); }

  static ::blink::mojom::IDBTransactionPutResult::Tag GetTag(const ::blink::mojom::IDBTransactionPutResultPtr& input) {
    return input->which();
  }

  static const ::blink::mojom::IDBErrorPtr& error_result(const ::blink::mojom::IDBTransactionPutResultPtr& input) {
    return input->get_error_result();
  }

  static const ::blink::IndexedDBKey& key(const ::blink::mojom::IDBTransactionPutResultPtr& input) {
    return input->get_key();
  }

  static bool Read(::blink::mojom::IDBTransactionPutResult::DataView input, ::blink::mojom::IDBTransactionPutResultPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::IDBDatabaseGetResult::DataView,
                                        ::blink::mojom::IDBDatabaseGetResultPtr> {
  static bool IsNull(const ::blink::mojom::IDBDatabaseGetResultPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::IDBDatabaseGetResultPtr* output) { output->reset(); }

  static ::blink::mojom::IDBDatabaseGetResult::Tag GetTag(const ::blink::mojom::IDBDatabaseGetResultPtr& input) {
    return input->which();
  }

  static const ::blink::mojom::IDBErrorPtr& error_result(const ::blink::mojom::IDBDatabaseGetResultPtr& input) {
    return input->get_error_result();
  }

  static  bool empty(const ::blink::mojom::IDBDatabaseGetResultPtr& input) {
    return input->get_empty();
  }

  static const ::blink::IndexedDBKey& key(const ::blink::mojom::IDBDatabaseGetResultPtr& input) {
    return input->get_key();
  }

  static  ::blink::mojom::IDBReturnValuePtr& value( ::blink::mojom::IDBDatabaseGetResultPtr& input) {
    return input->get_value();
  }

  static bool Read(::blink::mojom::IDBDatabaseGetResult::DataView input, ::blink::mojom::IDBDatabaseGetResultPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::IDBDatabaseOpenCursorResult::DataView,
                                        ::blink::mojom::IDBDatabaseOpenCursorResultPtr> {
  static bool IsNull(const ::blink::mojom::IDBDatabaseOpenCursorResultPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::IDBDatabaseOpenCursorResultPtr* output) { output->reset(); }

  static ::blink::mojom::IDBDatabaseOpenCursorResult::Tag GetTag(const ::blink::mojom::IDBDatabaseOpenCursorResultPtr& input) {
    return input->which();
  }

  static const ::blink::mojom::IDBErrorPtr& error_result(const ::blink::mojom::IDBDatabaseOpenCursorResultPtr& input) {
    return input->get_error_result();
  }

  static  bool empty(const ::blink::mojom::IDBDatabaseOpenCursorResultPtr& input) {
    return input->get_empty();
  }

  static  ::blink::mojom::IDBDatabaseOpenCursorValuePtr& value( ::blink::mojom::IDBDatabaseOpenCursorResultPtr& input) {
    return input->get_value();
  }

  static bool Read(::blink::mojom::IDBDatabaseOpenCursorResult::DataView input, ::blink::mojom::IDBDatabaseOpenCursorResultPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_INDEXEDDB_INDEXEDDB_MOJOM_H_