// third_party/blink/public/mojom/indexeddb/indexeddb.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/indexeddb/indexeddb.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/indexeddb/indexeddb.mojom-params-data.h"
#include "third_party/blink/public/mojom/indexeddb/indexeddb.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/indexeddb/indexeddb.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/indexeddb/indexeddb.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"
#include "third_party/blink/renderer/modules/indexeddb/indexed_db_blink_mojom_traits.h"


namespace blink::mojom::blink {
IDBKeyPath::IDBKeyPath()
    : data() {}

IDBKeyPath::IDBKeyPath(
    IDBKeyPathDataPtr data_in)
    : data(std::move(data_in)) {}

IDBKeyPath::~IDBKeyPath() = default;

void IDBKeyPath::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type IDBKeyPathDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool IDBKeyPath::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IDBKeyRange::IDBKeyRange()
    : lower(),
      upper(),
      lower_open(),
      upper_open() {}

IDBKeyRange::IDBKeyRange(
    ::std::unique_ptr<::blink::IDBKey> lower_in,
    ::std::unique_ptr<::blink::IDBKey> upper_in,
    bool lower_open_in,
    bool upper_open_in)
    : lower(std::move(lower_in)),
      upper(std::move(upper_in)),
      lower_open(std::move(lower_open_in)),
      upper_open(std::move(upper_open_in)) {}

IDBKeyRange::~IDBKeyRange() = default;

void IDBKeyRange::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "lower"), this->lower,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::std::unique_ptr<::blink::IDBKey>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "upper"), this->upper,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::std::unique_ptr<::blink::IDBKey>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "lower_open"), this->lower_open,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "upper_open"), this->upper_open,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool IDBKeyRange::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IDBIndexMetadata::IDBIndexMetadata()
    : id(),
      name(),
      key_path(),
      unique(),
      multi_entry() {}

IDBIndexMetadata::IDBIndexMetadata(
    int64_t id_in,
    const ::blink::String& name_in,
    const ::blink::IDBKeyPath& key_path_in,
    bool unique_in,
    bool multi_entry_in)
    : id(std::move(id_in)),
      name(std::move(name_in)),
      key_path(std::move(key_path_in)),
      unique(std::move(unique_in)),
      multi_entry(std::move(multi_entry_in)) {}

IDBIndexMetadata::~IDBIndexMetadata() = default;

void IDBIndexMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key_path"), this->key_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::IDBKeyPath&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "unique"), this->unique,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "multi_entry"), this->multi_entry,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool IDBIndexMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IDBObjectStoreMetadata::IDBObjectStoreMetadata()
    : id(),
      name(),
      key_path(),
      auto_increment(),
      max_index_id(),
      indexes() {}

IDBObjectStoreMetadata::IDBObjectStoreMetadata(
    int64_t id_in,
    const ::blink::String& name_in,
    const ::blink::IDBKeyPath& key_path_in,
    bool auto_increment_in,
    int64_t max_index_id_in,
    const ::blink::HashMap<int64_t, ::scoped_refptr<::blink::IDBIndexMetadata>>& indexes_in)
    : id(std::move(id_in)),
      name(std::move(name_in)),
      key_path(std::move(key_path_in)),
      auto_increment(std::move(auto_increment_in)),
      max_index_id(std::move(max_index_id_in)),
      indexes(std::move(indexes_in)) {}

IDBObjectStoreMetadata::~IDBObjectStoreMetadata() = default;

void IDBObjectStoreMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key_path"), this->key_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::IDBKeyPath&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "auto_increment"), this->auto_increment,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_index_id"), this->max_index_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "indexes"), this->indexes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::HashMap<int64_t, ::scoped_refptr<::blink::IDBIndexMetadata>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool IDBObjectStoreMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IDBDatabaseMetadata::IDBDatabaseMetadata()
    : name(),
      version(),
      max_object_store_id(),
      object_stores(),
      was_cold_open(),
      is_sqlite() {}

IDBDatabaseMetadata::IDBDatabaseMetadata(
    const ::blink::String& name_in,
    int64_t version_in,
    int64_t max_object_store_id_in,
    const ::blink::HashMap<int64_t, ::scoped_refptr<::blink::IDBObjectStoreMetadata>>& object_stores_in,
    bool was_cold_open_in,
    bool is_sqlite_in)
    : name(std::move(name_in)),
      version(std::move(version_in)),
      max_object_store_id(std::move(max_object_store_id_in)),
      object_stores(std::move(object_stores_in)),
      was_cold_open(std::move(was_cold_open_in)),
      is_sqlite(std::move(is_sqlite_in)) {}

IDBDatabaseMetadata::~IDBDatabaseMetadata() = default;

void IDBDatabaseMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version"), this->version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_object_store_id"), this->max_object_store_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "object_stores"), this->object_stores,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::HashMap<int64_t, ::scoped_refptr<::blink::IDBObjectStoreMetadata>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "was_cold_open"), this->was_cold_open,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_sqlite"), this->is_sqlite,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool IDBDatabaseMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IDBNameAndVersion::IDBNameAndVersion()
    : name(),
      version() {}

IDBNameAndVersion::IDBNameAndVersion(
    const ::blink::String& name_in,
    int64_t version_in)
    : name(std::move(name_in)),
      version(std::move(version_in)) {}

IDBNameAndVersion::~IDBNameAndVersion() = default;

void IDBNameAndVersion::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version"), this->version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool IDBNameAndVersion::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IDBIndexKeys::IDBIndexKeys()
    : index_id(),
      index_keys() {}

IDBIndexKeys::IDBIndexKeys(
    int64_t index_id_in,
    ::blink::Vector<::std::unique_ptr<::blink::IDBKey>> index_keys_in)
    : index_id(std::move(index_id_in)),
      index_keys(std::move(index_keys_in)) {}

IDBIndexKeys::~IDBIndexKeys() = default;

void IDBIndexKeys::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "index_id"), this->index_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "index_keys"), this->index_keys,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<::std::unique_ptr<::blink::IDBKey>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool IDBIndexKeys::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IDBFileInfo::IDBFileInfo()
    : name(),
      last_modified() {}

IDBFileInfo::IDBFileInfo(
    const ::blink::String& name_in,
    ::base::Time last_modified_in)
    : name(std::move(name_in)),
      last_modified(std::move(last_modified_in)) {}

IDBFileInfo::~IDBFileInfo() = default;

void IDBFileInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_modified"), this->last_modified,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool IDBFileInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IDBBlobInfo::IDBBlobInfo()
    : blob(),
      mime_type(),
      size(),
      file() {}

IDBBlobInfo::IDBBlobInfo(
    ::mojo::PendingRemote<::blink::mojom::blink::Blob> blob_in,
    const ::blink::String& mime_type_in,
    int64_t size_in,
    IDBFileInfoPtr file_in)
    : blob(std::move(blob_in)),
      mime_type(std::move(mime_type_in)),
      size(std::move(size_in)),
      file(std::move(file_in)) {}

IDBBlobInfo::~IDBBlobInfo() = default;

void IDBBlobInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blob"), this->blob,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::blink::mojom::blink::Blob>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mime_type"), this->mime_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size"), this->size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file"), this->file,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type IDBFileInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool IDBBlobInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IDBValue::IDBValue()
    : bits(),
      external_objects() {}

IDBValue::IDBValue(
    ::blink::Vector<uint8_t> bits_in,
    ::blink::Vector<IDBExternalObjectPtr> external_objects_in)
    : bits(std::move(bits_in)),
      external_objects(std::move(external_objects_in)) {}

IDBValue::~IDBValue() = default;

void IDBValue::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bits"), this->bits,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "external_objects"), this->external_objects,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<IDBExternalObjectPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool IDBValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IDBReturnValue::IDBReturnValue()
    : value(),
      primary_key(),
      key_path() {}

IDBReturnValue::IDBReturnValue(
    ::std::unique_ptr<::blink::IDBValue> value_in,
    ::std::unique_ptr<::blink::IDBKey> primary_key_in,
    const ::blink::IDBKeyPath& key_path_in)
    : value(std::move(value_in)),
      primary_key(std::move(primary_key_in)),
      key_path(std::move(key_path_in)) {}

IDBReturnValue::~IDBReturnValue() = default;

void IDBReturnValue::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::std::unique_ptr<::blink::IDBValue>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary_key"), this->primary_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::std::unique_ptr<::blink::IDBKey>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key_path"), this->key_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::IDBKeyPath&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool IDBReturnValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IDBRecord::IDBRecord()
    : primary_key(),
      return_value(),
      index_key() {}

IDBRecord::IDBRecord(
    std::optional<::std::unique_ptr<::blink::IDBKey>> primary_key_in,
    IDBReturnValuePtr return_value_in,
    std::optional<::std::unique_ptr<::blink::IDBKey>> index_key_in)
    : primary_key(std::move(primary_key_in)),
      return_value(std::move(return_value_in)),
      index_key(std::move(index_key_in)) {}

IDBRecord::~IDBRecord() = default;

void IDBRecord::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary_key"), this->primary_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::std::unique_ptr<::blink::IDBKey>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "return_value"), this->return_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type IDBReturnValuePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "index_key"), this->index_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::std::unique_ptr<::blink::IDBKey>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool IDBRecord::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IDBError::IDBError()
    : error_code(),
      error_message() {}

IDBError::IDBError(
    IDBException error_code_in,
    const ::blink::String& error_message_in)
    : error_code(std::move(error_code_in)),
      error_message(std::move(error_message_in)) {}

IDBError::~IDBError() = default;

void IDBError::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "error_code"), this->error_code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type IDBException>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "error_message"), this->error_message,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool IDBError::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IDBCursorValue::IDBCursorValue()
    : keys(),
      primary_keys(),
      values() {}

IDBCursorValue::IDBCursorValue(
    ::blink::Vector<::std::unique_ptr<::blink::IDBKey>> keys_in,
    ::blink::Vector<::std::unique_ptr<::blink::IDBKey>> primary_keys_in,
    ::blink::Vector<::std::unique_ptr<::blink::IDBValue>> values_in)
    : keys(std::move(keys_in)),
      primary_keys(std::move(primary_keys_in)),
      values(std::move(values_in)) {}

IDBCursorValue::~IDBCursorValue() = default;

void IDBCursorValue::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "keys"), this->keys,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<::std::unique_ptr<::blink::IDBKey>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary_keys"), this->primary_keys,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<::std::unique_ptr<::blink::IDBKey>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "values"), this->values,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<::std::unique_ptr<::blink::IDBValue>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool IDBCursorValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IDBDatabaseOpenCursorValue::IDBDatabaseOpenCursorValue()
    : cursor(),
      key(),
      primary_key(),
      value() {}

IDBDatabaseOpenCursorValue::IDBDatabaseOpenCursorValue(
    ::mojo::PendingAssociatedRemote<IDBCursor> cursor_in,
    ::std::unique_ptr<::blink::IDBKey> key_in,
    ::std::unique_ptr<::blink::IDBKey> primary_key_in,
    std::optional<::std::unique_ptr<::blink::IDBValue>> value_in)
    : cursor(std::move(cursor_in)),
      key(std::move(key_in)),
      primary_key(std::move(primary_key_in)),
      value(std::move(value_in)) {}

IDBDatabaseOpenCursorValue::~IDBDatabaseOpenCursorValue() = default;

void IDBDatabaseOpenCursorValue::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cursor"), this->cursor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedRemote<IDBCursor>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key"), this->key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::std::unique_ptr<::blink::IDBKey>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary_key"), this->primary_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::std::unique_ptr<::blink::IDBKey>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::std::unique_ptr<::blink::IDBValue>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool IDBDatabaseOpenCursorValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IDBKeyPtr
IDBKey::NewKeyArray(
    ::blink::Vector<::std::unique_ptr<::blink::IDBKey>> value) {
  return IDBKeyPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kKeyArray)>,
      std::move(value));
}

IDBKeyPtr
IDBKey::NewBinary(
    ::blink::Vector<uint8_t> value) {
  return IDBKeyPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kBinary)>,
      std::move(value));
}

IDBKeyPtr
IDBKey::NewString(
    const ::blink::String& value) {
  return IDBKeyPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kString)>,
      std::move(value));
}

IDBKeyPtr
IDBKey::NewDate(
    double value) {
  return IDBKeyPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kDate)>,
      std::move(value));
}

IDBKeyPtr
IDBKey::NewNumber(
    double value) {
  return IDBKeyPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kNumber)>,
      std::move(value));
}

IDBKeyPtr
IDBKey::NewOtherNone(
    bool value) {
  return IDBKeyPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kOtherNone)>,
      std::move(value));
}

IDBKey::IDBKey(
    std::in_place_index_t<static_cast<size_t>(Tag::kKeyArray)>,
    ::blink::Vector<::std::unique_ptr<::blink::IDBKey>> value)
    : tag_(Tag::kKeyArray),
      data_(std::in_place_index<static_cast<size_t>(Tag::kKeyArray)>,
            std::move(value)) {}

IDBKey::IDBKey(
    std::in_place_index_t<static_cast<size_t>(Tag::kBinary)>,
    ::blink::Vector<uint8_t> value)
    : tag_(Tag::kBinary),
      data_(std::in_place_index<static_cast<size_t>(Tag::kBinary)>,
            std::move(value)) {}

IDBKey::IDBKey(
    std::in_place_index_t<static_cast<size_t>(Tag::kString)>,
    const ::blink::String& value)
    : tag_(Tag::kString),
      data_(std::in_place_index<static_cast<size_t>(Tag::kString)>,
            std::move(value)) {}

IDBKey::IDBKey(
    std::in_place_index_t<static_cast<size_t>(Tag::kDate)>,
    double value)
    : tag_(Tag::kDate),
      data_(std::in_place_index<static_cast<size_t>(Tag::kDate)>,
            std::move(value)) {}

IDBKey::IDBKey(
    std::in_place_index_t<static_cast<size_t>(Tag::kNumber)>,
    double value)
    : tag_(Tag::kNumber),
      data_(std::in_place_index<static_cast<size_t>(Tag::kNumber)>,
            std::move(value)) {}

IDBKey::IDBKey(
    std::in_place_index_t<static_cast<size_t>(Tag::kOtherNone)>,
    bool value)
    : tag_(Tag::kOtherNone),
      data_(std::in_place_index<static_cast<size_t>(Tag::kOtherNone)>,
            std::move(value)) {}
IDBKey::~IDBKey() {
  DestroyActive();
}

void IDBKey::set_key_array(::blink::Vector<::std::unique_ptr<::blink::IDBKey>> key_array) {
  if (tag_ == Tag::kKeyArray) {
    data_.key_array = std::move(key_array);
  } else {
    DestroyActive();
    tag_ = Tag::kKeyArray;
    new (&data_.key_array) ::blink::Vector<::std::unique_ptr<::blink::IDBKey>>(
        std::move(key_array));
  }
}

void IDBKey::set_binary(::blink::Vector<uint8_t> binary) {
  if (tag_ == Tag::kBinary) {
    data_.binary = std::move(binary);
  } else {
    DestroyActive();
    tag_ = Tag::kBinary;
    new (&data_.binary) ::blink::Vector<uint8_t>(
        std::move(binary));
  }
}

void IDBKey::set_string(const ::blink::String& string) {
  if (tag_ == Tag::kString) {
    data_.string = std::move(string);
  } else {
    DestroyActive();
    tag_ = Tag::kString;
    new (&data_.string) ::blink::String(
        std::move(string));
  }
}

void IDBKey::set_date(double date) {
  if (tag_ != Tag::kDate) {
    DestroyActive();
    tag_ = Tag::kDate;
  }
  data_.date = date;
}

void IDBKey::set_number(double number) {
  if (tag_ != Tag::kNumber) {
    DestroyActive();
    tag_ = Tag::kNumber;
  }
  data_.number = number;
}

void IDBKey::set_other_none(bool other_none) {
  if (tag_ != Tag::kOtherNone) {
    DestroyActive();
    tag_ = Tag::kOtherNone;
  }
  data_.other_none = other_none;
}


IDBKey::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kKeyArray)>,
    ::blink::Vector<::std::unique_ptr<::blink::IDBKey>> value)
    : key_array(std::move(value)) {}

IDBKey::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kBinary)>,
    ::blink::Vector<uint8_t> value)
    : binary(std::move(value)) {}

IDBKey::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kString)>,
    const ::blink::String& value)
    : string(std::move(value)) {}

IDBKey::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kDate)>,
    double value)
    : date(std::move(value)) {}

IDBKey::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kNumber)>,
    double value)
    : number(std::move(value)) {}

IDBKey::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kOtherNone)>,
    bool value)
    : other_none(std::move(value)) {}

void IDBKey::DestroyActive() {
  switch (tag_) {

    case Tag::kKeyArray:
      std::destroy_at(&data_.key_array);
      break;
    case Tag::kBinary:
      std::destroy_at(&data_.binary);
      break;
    case Tag::kString:
      std::destroy_at(&data_.string);
      break;
    case Tag::kDate:
      std::destroy_at(&data_.date);
      break;
    case Tag::kNumber:
      std::destroy_at(&data_.number);
      break;
    case Tag::kOtherNone:
      std::destroy_at(&data_.other_none);
      break;
  }
}

bool IDBKey::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
IDBKeyPathDataPtr
IDBKeyPathData::NewString(
    const ::blink::String& value) {
  return IDBKeyPathDataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kString)>,
      std::move(value));
}

IDBKeyPathDataPtr
IDBKeyPathData::NewStringArray(
    ::blink::Vector<::blink::String> value) {
  return IDBKeyPathDataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kStringArray)>,
      std::move(value));
}

IDBKeyPathData::IDBKeyPathData(
    std::in_place_index_t<static_cast<size_t>(Tag::kString)>,
    const ::blink::String& value)
    : tag_(Tag::kString),
      data_(std::in_place_index<static_cast<size_t>(Tag::kString)>,
            std::move(value)) {}

IDBKeyPathData::IDBKeyPathData(
    std::in_place_index_t<static_cast<size_t>(Tag::kStringArray)>,
    ::blink::Vector<::blink::String> value)
    : tag_(Tag::kStringArray),
      data_(std::in_place_index<static_cast<size_t>(Tag::kStringArray)>,
            std::move(value)) {}
IDBKeyPathData::~IDBKeyPathData() {
  DestroyActive();
}

void IDBKeyPathData::set_string(const ::blink::String& string) {
  if (tag_ == Tag::kString) {
    data_.string = std::move(string);
  } else {
    DestroyActive();
    tag_ = Tag::kString;
    new (&data_.string) ::blink::String(
        std::move(string));
  }
}

void IDBKeyPathData::set_string_array(::blink::Vector<::blink::String> string_array) {
  if (tag_ == Tag::kStringArray) {
    data_.string_array = std::move(string_array);
  } else {
    DestroyActive();
    tag_ = Tag::kStringArray;
    new (&data_.string_array) ::blink::Vector<::blink::String>(
        std::move(string_array));
  }
}


IDBKeyPathData::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kString)>,
    const ::blink::String& value)
    : string(std::move(value)) {}

IDBKeyPathData::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kStringArray)>,
    ::blink::Vector<::blink::String> value)
    : string_array(std::move(value)) {}

void IDBKeyPathData::DestroyActive() {
  switch (tag_) {

    case Tag::kString:
      std::destroy_at(&data_.string);
      break;
    case Tag::kStringArray:
      std::destroy_at(&data_.string_array);
      break;
  }
}

bool IDBKeyPathData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
IDBExternalObjectPtr
IDBExternalObject::NewBlobOrFile(
    IDBBlobInfoPtr value) {
  return IDBExternalObjectPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kBlobOrFile)>,
      std::move(value));
}

IDBExternalObjectPtr
IDBExternalObject::NewFileSystemAccessToken(
    ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessTransferToken> value) {
  return IDBExternalObjectPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFileSystemAccessToken)>,
      std::move(value));
}

IDBExternalObject::IDBExternalObject(
    std::in_place_index_t<static_cast<size_t>(Tag::kBlobOrFile)>,
    IDBBlobInfoPtr value)
    : tag_(Tag::kBlobOrFile),
      data_(std::in_place_index<static_cast<size_t>(Tag::kBlobOrFile)>,
            std::move(value)) {}

IDBExternalObject::IDBExternalObject(
    std::in_place_index_t<static_cast<size_t>(Tag::kFileSystemAccessToken)>,
    ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessTransferToken> value)
    : tag_(Tag::kFileSystemAccessToken),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFileSystemAccessToken)>,
            std::move(value)) {}
IDBExternalObject::~IDBExternalObject() {
  DestroyActive();
}

void IDBExternalObject::set_blob_or_file(IDBBlobInfoPtr blob_or_file) {
  if (tag_ == Tag::kBlobOrFile) {
    data_.blob_or_file = std::move(blob_or_file);
  } else {
    DestroyActive();
    tag_ = Tag::kBlobOrFile;
    new (&data_.blob_or_file) IDBBlobInfoPtr(
        std::move(blob_or_file));
  }
}

void IDBExternalObject::set_file_system_access_token(::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessTransferToken> file_system_access_token) {
  if (tag_ == Tag::kFileSystemAccessToken) {
    data_.file_system_access_token = std::move(file_system_access_token);
  } else {
    DestroyActive();
    tag_ = Tag::kFileSystemAccessToken;
    new (&data_.file_system_access_token) ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessTransferToken>(
        std::move(file_system_access_token));
  }
}


IDBExternalObject::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kBlobOrFile)>,
    IDBBlobInfoPtr value)
    : blob_or_file(std::move(value)) {}

IDBExternalObject::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFileSystemAccessToken)>,
    ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessTransferToken> value)
    : file_system_access_token(std::move(value)) {}

void IDBExternalObject::DestroyActive() {
  switch (tag_) {

    case Tag::kBlobOrFile:
      std::destroy_at(&data_.blob_or_file);
      break;
    case Tag::kFileSystemAccessToken:
      std::destroy_at(&data_.file_system_access_token);
      break;
  }
}

bool IDBExternalObject::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
IDBCursorResultPtr
IDBCursorResult::NewErrorResult(
    IDBErrorPtr value) {
  return IDBCursorResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kErrorResult)>,
      std::move(value));
}

IDBCursorResultPtr
IDBCursorResult::NewEmpty(
    bool value) {
  return IDBCursorResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kEmpty)>,
      std::move(value));
}

IDBCursorResultPtr
IDBCursorResult::NewValues(
    IDBCursorValuePtr value) {
  return IDBCursorResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kValues)>,
      std::move(value));
}

IDBCursorResult::IDBCursorResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kErrorResult)>,
    IDBErrorPtr value)
    : tag_(Tag::kErrorResult),
      data_(std::in_place_index<static_cast<size_t>(Tag::kErrorResult)>,
            std::move(value)) {}

IDBCursorResult::IDBCursorResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kEmpty)>,
    bool value)
    : tag_(Tag::kEmpty),
      data_(std::in_place_index<static_cast<size_t>(Tag::kEmpty)>,
            std::move(value)) {}

IDBCursorResult::IDBCursorResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kValues)>,
    IDBCursorValuePtr value)
    : tag_(Tag::kValues),
      data_(std::in_place_index<static_cast<size_t>(Tag::kValues)>,
            std::move(value)) {}
IDBCursorResult::~IDBCursorResult() {
  DestroyActive();
}

void IDBCursorResult::set_error_result(IDBErrorPtr error_result) {
  if (tag_ == Tag::kErrorResult) {
    data_.error_result = std::move(error_result);
  } else {
    DestroyActive();
    tag_ = Tag::kErrorResult;
    new (&data_.error_result) IDBErrorPtr(
        std::move(error_result));
  }
}

void IDBCursorResult::set_empty(bool empty) {
  if (tag_ != Tag::kEmpty) {
    DestroyActive();
    tag_ = Tag::kEmpty;
  }
  data_.empty = empty;
}

void IDBCursorResult::set_values(IDBCursorValuePtr values) {
  if (tag_ == Tag::kValues) {
    data_.values = std::move(values);
  } else {
    DestroyActive();
    tag_ = Tag::kValues;
    new (&data_.values) IDBCursorValuePtr(
        std::move(values));
  }
}


IDBCursorResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kErrorResult)>,
    IDBErrorPtr value)
    : error_result(std::move(value)) {}

IDBCursorResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kEmpty)>,
    bool value)
    : empty(std::move(value)) {}

IDBCursorResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kValues)>,
    IDBCursorValuePtr value)
    : values(std::move(value)) {}

void IDBCursorResult::DestroyActive() {
  switch (tag_) {

    case Tag::kErrorResult:
      std::destroy_at(&data_.error_result);
      break;
    case Tag::kEmpty:
      std::destroy_at(&data_.empty);
      break;
    case Tag::kValues:
      std::destroy_at(&data_.values);
      break;
  }
}

bool IDBCursorResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
IDBTransactionPutResultPtr
IDBTransactionPutResult::NewErrorResult(
    IDBErrorPtr value) {
  return IDBTransactionPutResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kErrorResult)>,
      std::move(value));
}

IDBTransactionPutResultPtr
IDBTransactionPutResult::NewKey(
    ::std::unique_ptr<::blink::IDBKey> value) {
  return IDBTransactionPutResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kKey)>,
      std::move(value));
}

IDBTransactionPutResult::IDBTransactionPutResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kErrorResult)>,
    IDBErrorPtr value)
    : tag_(Tag::kErrorResult),
      data_(std::in_place_index<static_cast<size_t>(Tag::kErrorResult)>,
            std::move(value)) {}

IDBTransactionPutResult::IDBTransactionPutResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kKey)>,
    ::std::unique_ptr<::blink::IDBKey> value)
    : tag_(Tag::kKey),
      data_(std::in_place_index<static_cast<size_t>(Tag::kKey)>,
            std::move(value)) {}
IDBTransactionPutResult::~IDBTransactionPutResult() {
  DestroyActive();
}

void IDBTransactionPutResult::set_error_result(IDBErrorPtr error_result) {
  if (tag_ == Tag::kErrorResult) {
    data_.error_result = std::move(error_result);
  } else {
    DestroyActive();
    tag_ = Tag::kErrorResult;
    new (&data_.error_result) IDBErrorPtr(
        std::move(error_result));
  }
}

void IDBTransactionPutResult::set_key(::std::unique_ptr<::blink::IDBKey> key) {
  if (tag_ == Tag::kKey) {
    data_.key = std::move(key);
  } else {
    DestroyActive();
    tag_ = Tag::kKey;
    new (&data_.key) ::std::unique_ptr<::blink::IDBKey>(
        std::move(key));
  }
}


IDBTransactionPutResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kErrorResult)>,
    IDBErrorPtr value)
    : error_result(std::move(value)) {}

IDBTransactionPutResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kKey)>,
    ::std::unique_ptr<::blink::IDBKey> value)
    : key(std::move(value)) {}

void IDBTransactionPutResult::DestroyActive() {
  switch (tag_) {

    case Tag::kErrorResult:
      std::destroy_at(&data_.error_result);
      break;
    case Tag::kKey:
      std::destroy_at(&data_.key);
      break;
  }
}

bool IDBTransactionPutResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
IDBDatabaseGetResultPtr
IDBDatabaseGetResult::NewErrorResult(
    IDBErrorPtr value) {
  return IDBDatabaseGetResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kErrorResult)>,
      std::move(value));
}

IDBDatabaseGetResultPtr
IDBDatabaseGetResult::NewEmpty(
    bool value) {
  return IDBDatabaseGetResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kEmpty)>,
      std::move(value));
}

IDBDatabaseGetResultPtr
IDBDatabaseGetResult::NewKey(
    ::std::unique_ptr<::blink::IDBKey> value) {
  return IDBDatabaseGetResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kKey)>,
      std::move(value));
}

IDBDatabaseGetResultPtr
IDBDatabaseGetResult::NewValue(
    IDBReturnValuePtr value) {
  return IDBDatabaseGetResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kValue)>,
      std::move(value));
}

IDBDatabaseGetResult::IDBDatabaseGetResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kErrorResult)>,
    IDBErrorPtr value)
    : tag_(Tag::kErrorResult),
      data_(std::in_place_index<static_cast<size_t>(Tag::kErrorResult)>,
            std::move(value)) {}

IDBDatabaseGetResult::IDBDatabaseGetResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kEmpty)>,
    bool value)
    : tag_(Tag::kEmpty),
      data_(std::in_place_index<static_cast<size_t>(Tag::kEmpty)>,
            std::move(value)) {}

IDBDatabaseGetResult::IDBDatabaseGetResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kKey)>,
    ::std::unique_ptr<::blink::IDBKey> value)
    : tag_(Tag::kKey),
      data_(std::in_place_index<static_cast<size_t>(Tag::kKey)>,
            std::move(value)) {}

IDBDatabaseGetResult::IDBDatabaseGetResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kValue)>,
    IDBReturnValuePtr value)
    : tag_(Tag::kValue),
      data_(std::in_place_index<static_cast<size_t>(Tag::kValue)>,
            std::move(value)) {}
IDBDatabaseGetResult::~IDBDatabaseGetResult() {
  DestroyActive();
}

void IDBDatabaseGetResult::set_error_result(IDBErrorPtr error_result) {
  if (tag_ == Tag::kErrorResult) {
    data_.error_result = std::move(error_result);
  } else {
    DestroyActive();
    tag_ = Tag::kErrorResult;
    new (&data_.error_result) IDBErrorPtr(
        std::move(error_result));
  }
}

void IDBDatabaseGetResult::set_empty(bool empty) {
  if (tag_ != Tag::kEmpty) {
    DestroyActive();
    tag_ = Tag::kEmpty;
  }
  data_.empty = empty;
}

void IDBDatabaseGetResult::set_key(::std::unique_ptr<::blink::IDBKey> key) {
  if (tag_ == Tag::kKey) {
    data_.key = std::move(key);
  } else {
    DestroyActive();
    tag_ = Tag::kKey;
    new (&data_.key) ::std::unique_ptr<::blink::IDBKey>(
        std::move(key));
  }
}

void IDBDatabaseGetResult::set_value(IDBReturnValuePtr value) {
  if (tag_ == Tag::kValue) {
    data_.value = std::move(value);
  } else {
    DestroyActive();
    tag_ = Tag::kValue;
    new (&data_.value) IDBReturnValuePtr(
        std::move(value));
  }
}


IDBDatabaseGetResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kErrorResult)>,
    IDBErrorPtr value)
    : error_result(std::move(value)) {}

IDBDatabaseGetResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kEmpty)>,
    bool value)
    : empty(std::move(value)) {}

IDBDatabaseGetResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kKey)>,
    ::std::unique_ptr<::blink::IDBKey> value)
    : key(std::move(value)) {}

IDBDatabaseGetResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kValue)>,
    IDBReturnValuePtr value)
    : value(std::move(value)) {}

void IDBDatabaseGetResult::DestroyActive() {
  switch (tag_) {

    case Tag::kErrorResult:
      std::destroy_at(&data_.error_result);
      break;
    case Tag::kEmpty:
      std::destroy_at(&data_.empty);
      break;
    case Tag::kKey:
      std::destroy_at(&data_.key);
      break;
    case Tag::kValue:
      std::destroy_at(&data_.value);
      break;
  }
}

bool IDBDatabaseGetResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
IDBDatabaseOpenCursorResultPtr
IDBDatabaseOpenCursorResult::NewErrorResult(
    IDBErrorPtr value) {
  return IDBDatabaseOpenCursorResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kErrorResult)>,
      std::move(value));
}

IDBDatabaseOpenCursorResultPtr
IDBDatabaseOpenCursorResult::NewEmpty(
    bool value) {
  return IDBDatabaseOpenCursorResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kEmpty)>,
      std::move(value));
}

IDBDatabaseOpenCursorResultPtr
IDBDatabaseOpenCursorResult::NewValue(
    IDBDatabaseOpenCursorValuePtr value) {
  return IDBDatabaseOpenCursorResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kValue)>,
      std::move(value));
}

IDBDatabaseOpenCursorResult::IDBDatabaseOpenCursorResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kErrorResult)>,
    IDBErrorPtr value)
    : tag_(Tag::kErrorResult),
      data_(std::in_place_index<static_cast<size_t>(Tag::kErrorResult)>,
            std::move(value)) {}

IDBDatabaseOpenCursorResult::IDBDatabaseOpenCursorResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kEmpty)>,
    bool value)
    : tag_(Tag::kEmpty),
      data_(std::in_place_index<static_cast<size_t>(Tag::kEmpty)>,
            std::move(value)) {}

IDBDatabaseOpenCursorResult::IDBDatabaseOpenCursorResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kValue)>,
    IDBDatabaseOpenCursorValuePtr value)
    : tag_(Tag::kValue),
      data_(std::in_place_index<static_cast<size_t>(Tag::kValue)>,
            std::move(value)) {}
IDBDatabaseOpenCursorResult::~IDBDatabaseOpenCursorResult() {
  DestroyActive();
}

void IDBDatabaseOpenCursorResult::set_error_result(IDBErrorPtr error_result) {
  if (tag_ == Tag::kErrorResult) {
    data_.error_result = std::move(error_result);
  } else {
    DestroyActive();
    tag_ = Tag::kErrorResult;
    new (&data_.error_result) IDBErrorPtr(
        std::move(error_result));
  }
}

void IDBDatabaseOpenCursorResult::set_empty(bool empty) {
  if (tag_ != Tag::kEmpty) {
    DestroyActive();
    tag_ = Tag::kEmpty;
  }
  data_.empty = empty;
}

void IDBDatabaseOpenCursorResult::set_value(IDBDatabaseOpenCursorValuePtr value) {
  if (tag_ == Tag::kValue) {
    data_.value = std::move(value);
  } else {
    DestroyActive();
    tag_ = Tag::kValue;
    new (&data_.value) IDBDatabaseOpenCursorValuePtr(
        std::move(value));
  }
}


IDBDatabaseOpenCursorResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kErrorResult)>,
    IDBErrorPtr value)
    : error_result(std::move(value)) {}

IDBDatabaseOpenCursorResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kEmpty)>,
    bool value)
    : empty(std::move(value)) {}

IDBDatabaseOpenCursorResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kValue)>,
    IDBDatabaseOpenCursorValuePtr value)
    : value(std::move(value)) {}

void IDBDatabaseOpenCursorResult::DestroyActive() {
  switch (tag_) {

    case Tag::kErrorResult:
      std::destroy_at(&data_.error_result);
      break;
    case Tag::kEmpty:
      std::destroy_at(&data_.empty);
      break;
    case Tag::kValue:
      std::destroy_at(&data_.value);
      break;
  }
}

bool IDBDatabaseOpenCursorResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

IDBFactoryClient::IPCStableHashFunction IDBFactoryClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::IDBFactoryClient>(message.name())) {
    case messages::IDBFactoryClient::kError: {
      return &IDBFactoryClient::Error_Sym::IPCStableHash;
    }
    case messages::IDBFactoryClient::kBlocked: {
      return &IDBFactoryClient::Blocked_Sym::IPCStableHash;
    }
    case messages::IDBFactoryClient::kUpgradeNeeded: {
      return &IDBFactoryClient::UpgradeNeeded_Sym::IPCStableHash;
    }
    case messages::IDBFactoryClient::kOpenSuccess: {
      return &IDBFactoryClient::OpenSuccess_Sym::IPCStableHash;
    }
    case messages::IDBFactoryClient::kDeleteSuccess: {
      return &IDBFactoryClient::DeleteSuccess_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* IDBFactoryClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::IDBFactoryClient>(message.name())) {
      case messages::IDBFactoryClient::kError:
            return "Receive blink::mojom::IDBFactoryClient::Error";
      case messages::IDBFactoryClient::kBlocked:
            return "Receive blink::mojom::IDBFactoryClient::Blocked";
      case messages::IDBFactoryClient::kUpgradeNeeded:
            return "Receive blink::mojom::IDBFactoryClient::UpgradeNeeded";
      case messages::IDBFactoryClient::kOpenSuccess:
            return "Receive blink::mojom::IDBFactoryClient::OpenSuccess";
      case messages::IDBFactoryClient::kDeleteSuccess:
            return "Receive blink::mojom::IDBFactoryClient::DeleteSuccess";
    }
  } else {
    switch (static_cast<messages::IDBFactoryClient>(message.name())) {
      case messages::IDBFactoryClient::kError:
            return "Receive reply blink::mojom::IDBFactoryClient::Error";
      case messages::IDBFactoryClient::kBlocked:
            return "Receive reply blink::mojom::IDBFactoryClient::Blocked";
      case messages::IDBFactoryClient::kUpgradeNeeded:
            return "Receive reply blink::mojom::IDBFactoryClient::UpgradeNeeded";
      case messages::IDBFactoryClient::kOpenSuccess:
            return "Receive reply blink::mojom::IDBFactoryClient::OpenSuccess";
      case messages::IDBFactoryClient::kDeleteSuccess:
            return "Receive reply blink::mojom::IDBFactoryClient::DeleteSuccess";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t IDBFactoryClient::Error_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8e8be3fa;  // IPCStableHash for blink::mojom::IDBFactoryClient::Error
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IDBFactoryClient::Blocked_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8e2f0ffd;  // IPCStableHash for blink::mojom::IDBFactoryClient::Blocked
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IDBFactoryClient::UpgradeNeeded_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc90ba4e8;  // IPCStableHash for blink::mojom::IDBFactoryClient::UpgradeNeeded
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IDBFactoryClient::OpenSuccess_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x003d1cc5;  // IPCStableHash for blink::mojom::IDBFactoryClient::OpenSuccess
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IDBFactoryClient::DeleteSuccess_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x15b29e92;  // IPCStableHash for blink::mojom::IDBFactoryClient::DeleteSuccess
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

IDBFactoryClientProxy::IDBFactoryClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void IDBFactoryClientProxy::Error(
    IDBException in_code, const ::blink::String& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::IDBFactoryClient::Error", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("code"), in_code,
                        "<value of type IDBException>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBFactoryClient::kError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBFactoryClient_Error_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::IDBException>(
    in_code,
    &params->code);
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in IDBFactoryClient.Error request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBFactoryClient::Name_);
  message.set_method_name("Error");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void IDBFactoryClientProxy::Blocked(
    int64_t in_existing_version) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::IDBFactoryClient::Blocked", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("existing_version"), in_existing_version,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBFactoryClient::kBlocked), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBFactoryClient_Blocked_Params_Data> params(
          message);
  params.Allocate();

  params->existing_version = in_existing_version;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBFactoryClient::Name_);
  message.set_method_name("Blocked");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void IDBFactoryClientProxy::UpgradeNeeded(
    ::mojo::PendingAssociatedRemote<IDBDatabase> in_pending_database, int64_t in_old_version, IDBDataLoss in_data_loss, const ::blink::String& in_data_loss_message, const ::blink::IDBDatabaseMetadata& in_db_metadata) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::IDBFactoryClient::UpgradeNeeded", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pending_database"), in_pending_database,
                        "<value of type ::mojo::PendingAssociatedRemote<IDBDatabase>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("old_version"), in_old_version,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data_loss"), in_data_loss,
                        "<value of type IDBDataLoss>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data_loss_message"), in_data_loss_message,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("db_metadata"), in_db_metadata,
                        "<value of type const ::blink::IDBDatabaseMetadata&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBFactoryClient::kUpgradeNeeded), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBFactoryClient_UpgradeNeeded_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::IDBDatabaseAssociatedPtrInfoDataView>(
    in_pending_database,
    &params->pending_database,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->pending_database)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid pending_database in IDBFactoryClient.UpgradeNeeded request");

  params->old_version = in_old_version;

  
  mojo::internal::Serialize<::blink::mojom::IDBDataLoss>(
    in_data_loss,
    &params->data_loss);
  mojo::internal::MessageFragment<
      typename decltype(params->data_loss_message)::BaseType> data_loss_message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_data_loss_message,
    data_loss_message_fragment);

  params->data_loss_message.Set(
      data_loss_message_fragment.is_null() ? nullptr : data_loss_message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data_loss_message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data_loss_message in IDBFactoryClient.UpgradeNeeded request");
  mojo::internal::MessageFragment<
      typename decltype(params->db_metadata)::BaseType> db_metadata_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::IDBDatabaseMetadataDataView>(
    in_db_metadata,
    db_metadata_fragment);

  params->db_metadata.Set(
      db_metadata_fragment.is_null() ? nullptr : db_metadata_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->db_metadata.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null db_metadata in IDBFactoryClient.UpgradeNeeded request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBFactoryClient::Name_);
  message.set_method_name("UpgradeNeeded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void IDBFactoryClientProxy::OpenSuccess(
    ::mojo::PendingAssociatedRemote<IDBDatabase> in_pending_database, const ::blink::IDBDatabaseMetadata& in_metadata) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::IDBFactoryClient::OpenSuccess", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pending_database"), in_pending_database,
                        "<value of type ::mojo::PendingAssociatedRemote<IDBDatabase>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("metadata"), in_metadata,
                        "<value of type const ::blink::IDBDatabaseMetadata&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBFactoryClient::kOpenSuccess), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBFactoryClient_OpenSuccess_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::IDBDatabaseAssociatedPtrInfoDataView>(
    in_pending_database,
    &params->pending_database,
    &params.message());
  mojo::internal::MessageFragment<
      typename decltype(params->metadata)::BaseType> metadata_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::IDBDatabaseMetadataDataView>(
    in_metadata,
    metadata_fragment);

  params->metadata.Set(
      metadata_fragment.is_null() ? nullptr : metadata_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->metadata.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null metadata in IDBFactoryClient.OpenSuccess request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBFactoryClient::Name_);
  message.set_method_name("OpenSuccess");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void IDBFactoryClientProxy::DeleteSuccess(
    int64_t in_old_version) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::IDBFactoryClient::DeleteSuccess", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("old_version"), in_old_version,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBFactoryClient::kDeleteSuccess), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBFactoryClient_DeleteSuccess_Params_Data> params(
          message);
  params.Allocate();

  params->old_version = in_old_version;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBFactoryClient::Name_);
  message.set_method_name("DeleteSuccess");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool IDBFactoryClientStubDispatch::Accept(
    IDBFactoryClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::IDBFactoryClient>(message->header()->name)) {
    case messages::IDBFactoryClient::kError: {
      DCHECK(message->is_serialized());
      internal::IDBFactoryClient_Error_Params_Data* params =
          reinterpret_cast<internal::IDBFactoryClient_Error_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IDBFactoryClient.0
      bool success = true;
      IDBException p_code{};
      ::blink::String p_message{};
      IDBFactoryClient_Error_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCode(&p_code))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBFactoryClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Error(        
        std::move(p_code), 
        std::move(p_message));
      return true;
    }
    case messages::IDBFactoryClient::kBlocked: {
      DCHECK(message->is_serialized());
      internal::IDBFactoryClient_Blocked_Params_Data* params =
          reinterpret_cast<internal::IDBFactoryClient_Blocked_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IDBFactoryClient.1
      bool success = true;
      int64_t p_existing_version{};
      IDBFactoryClient_Blocked_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_existing_version = input_data_view.existing_version();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBFactoryClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Blocked(        
        std::move(p_existing_version));
      return true;
    }
    case messages::IDBFactoryClient::kUpgradeNeeded: {
      DCHECK(message->is_serialized());
      internal::IDBFactoryClient_UpgradeNeeded_Params_Data* params =
          reinterpret_cast<internal::IDBFactoryClient_UpgradeNeeded_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IDBFactoryClient.2
      bool success = true;
      ::mojo::PendingAssociatedRemote<IDBDatabase> p_pending_database{};
      int64_t p_old_version{};
      IDBDataLoss p_data_loss{};
      ::blink::String p_data_loss_message{};
      ::blink::IDBDatabaseMetadata p_db_metadata{};
      IDBFactoryClient_UpgradeNeeded_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_pending_database =
            input_data_view.TakePendingDatabase<decltype(p_pending_database)>();
      }
      if (success)
        p_old_version = input_data_view.old_version();
      if (success && !input_data_view.ReadDataLoss(&p_data_loss))
        success = false;
      if (success && !input_data_view.ReadDataLossMessage(&p_data_loss_message))
        success = false;
      if (success && !input_data_view.ReadDbMetadata(&p_db_metadata))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBFactoryClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpgradeNeeded(        
        std::move(p_pending_database), 
        std::move(p_old_version), 
        std::move(p_data_loss), 
        std::move(p_data_loss_message), 
        std::move(p_db_metadata));
      return true;
    }
    case messages::IDBFactoryClient::kOpenSuccess: {
      DCHECK(message->is_serialized());
      internal::IDBFactoryClient_OpenSuccess_Params_Data* params =
          reinterpret_cast<internal::IDBFactoryClient_OpenSuccess_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IDBFactoryClient.3
      bool success = true;
      ::mojo::PendingAssociatedRemote<IDBDatabase> p_pending_database{};
      ::blink::IDBDatabaseMetadata p_metadata{};
      IDBFactoryClient_OpenSuccess_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_pending_database =
            input_data_view.TakePendingDatabase<decltype(p_pending_database)>();
      }
      if (success && !input_data_view.ReadMetadata(&p_metadata))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBFactoryClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenSuccess(        
        std::move(p_pending_database), 
        std::move(p_metadata));
      return true;
    }
    case messages::IDBFactoryClient::kDeleteSuccess: {
      DCHECK(message->is_serialized());
      internal::IDBFactoryClient_DeleteSuccess_Params_Data* params =
          reinterpret_cast<internal::IDBFactoryClient_DeleteSuccess_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IDBFactoryClient.4
      bool success = true;
      int64_t p_old_version{};
      IDBFactoryClient_DeleteSuccess_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_old_version = input_data_view.old_version();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBFactoryClient::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteSuccess(        
        std::move(p_old_version));
      return true;
    }
  }
  return false;
}

// static
bool IDBFactoryClientStubDispatch::AcceptWithResponder(
    IDBFactoryClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::IDBFactoryClient>(message->header()->name)) {
    case messages::IDBFactoryClient::kError: {
      break;
    }
    case messages::IDBFactoryClient::kBlocked: {
      break;
    }
    case messages::IDBFactoryClient::kUpgradeNeeded: {
      break;
    }
    case messages::IDBFactoryClient::kOpenSuccess: {
      break;
    }
    case messages::IDBFactoryClient::kDeleteSuccess: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kIDBFactoryClientValidationInfo[] = {
    { &internal::IDBFactoryClient_Error_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::IDBFactoryClient_Blocked_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::IDBFactoryClient_UpgradeNeeded_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::IDBFactoryClient_OpenSuccess_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::IDBFactoryClient_DeleteSuccess_Params_Data::Validate,
     nullptr /* no response */},
};

bool IDBFactoryClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::IDBFactoryClient::Name_,
    kIDBFactoryClientValidationInfo);
}

// The declaration includes the definition on other builds.

IDBDatabaseCallbacks::IPCStableHashFunction IDBDatabaseCallbacks::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::IDBDatabaseCallbacks>(message.name())) {
    case messages::IDBDatabaseCallbacks::kForcedClose: {
      return &IDBDatabaseCallbacks::ForcedClose_Sym::IPCStableHash;
    }
    case messages::IDBDatabaseCallbacks::kVersionChange: {
      return &IDBDatabaseCallbacks::VersionChange_Sym::IPCStableHash;
    }
    case messages::IDBDatabaseCallbacks::kAbort: {
      return &IDBDatabaseCallbacks::Abort_Sym::IPCStableHash;
    }
    case messages::IDBDatabaseCallbacks::kComplete: {
      return &IDBDatabaseCallbacks::Complete_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* IDBDatabaseCallbacks::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::IDBDatabaseCallbacks>(message.name())) {
      case messages::IDBDatabaseCallbacks::kForcedClose:
            return "Receive blink::mojom::IDBDatabaseCallbacks::ForcedClose";
      case messages::IDBDatabaseCallbacks::kVersionChange:
            return "Receive blink::mojom::IDBDatabaseCallbacks::VersionChange";
      case messages::IDBDatabaseCallbacks::kAbort:
            return "Receive blink::mojom::IDBDatabaseCallbacks::Abort";
      case messages::IDBDatabaseCallbacks::kComplete:
            return "Receive blink::mojom::IDBDatabaseCallbacks::Complete";
    }
  } else {
    switch (static_cast<messages::IDBDatabaseCallbacks>(message.name())) {
      case messages::IDBDatabaseCallbacks::kForcedClose:
            return "Receive reply blink::mojom::IDBDatabaseCallbacks::ForcedClose";
      case messages::IDBDatabaseCallbacks::kVersionChange:
            return "Receive reply blink::mojom::IDBDatabaseCallbacks::VersionChange";
      case messages::IDBDatabaseCallbacks::kAbort:
            return "Receive reply blink::mojom::IDBDatabaseCallbacks::Abort";
      case messages::IDBDatabaseCallbacks::kComplete:
            return "Receive reply blink::mojom::IDBDatabaseCallbacks::Complete";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t IDBDatabaseCallbacks::ForcedClose_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8420bd92;  // IPCStableHash for blink::mojom::IDBDatabaseCallbacks::ForcedClose
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IDBDatabaseCallbacks::VersionChange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xee4119f9;  // IPCStableHash for blink::mojom::IDBDatabaseCallbacks::VersionChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IDBDatabaseCallbacks::Abort_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x743ed357;  // IPCStableHash for blink::mojom::IDBDatabaseCallbacks::Abort
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IDBDatabaseCallbacks::Complete_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb331efb9;  // IPCStableHash for blink::mojom::IDBDatabaseCallbacks::Complete
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

IDBDatabaseCallbacksProxy::IDBDatabaseCallbacksProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void IDBDatabaseCallbacksProxy::ForcedClose(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::IDBDatabaseCallbacks::ForcedClose");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBDatabaseCallbacks::kForcedClose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBDatabaseCallbacks_ForcedClose_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabaseCallbacks::Name_);
  message.set_method_name("ForcedClose");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void IDBDatabaseCallbacksProxy::VersionChange(
    int64_t in_old_version, int64_t in_new_version) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::IDBDatabaseCallbacks::VersionChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("old_version"), in_old_version,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_version"), in_new_version,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBDatabaseCallbacks::kVersionChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBDatabaseCallbacks_VersionChange_Params_Data> params(
          message);
  params.Allocate();

  params->old_version = in_old_version;

  params->new_version = in_new_version;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabaseCallbacks::Name_);
  message.set_method_name("VersionChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void IDBDatabaseCallbacksProxy::Abort(
    int64_t in_transaction_id, IDBException in_code, const ::blink::String& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::IDBDatabaseCallbacks::Abort", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("transaction_id"), in_transaction_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("code"), in_code,
                        "<value of type IDBException>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBDatabaseCallbacks::kAbort), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBDatabaseCallbacks_Abort_Params_Data> params(
          message);
  params.Allocate();

  params->transaction_id = in_transaction_id;

  
  mojo::internal::Serialize<::blink::mojom::IDBException>(
    in_code,
    &params->code);
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in IDBDatabaseCallbacks.Abort request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabaseCallbacks::Name_);
  message.set_method_name("Abort");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void IDBDatabaseCallbacksProxy::Complete(
    int64_t in_transaction_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::IDBDatabaseCallbacks::Complete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("transaction_id"), in_transaction_id,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBDatabaseCallbacks::kComplete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBDatabaseCallbacks_Complete_Params_Data> params(
          message);
  params.Allocate();

  params->transaction_id = in_transaction_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabaseCallbacks::Name_);
  message.set_method_name("Complete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool IDBDatabaseCallbacksStubDispatch::Accept(
    IDBDatabaseCallbacks* impl,
    mojo::Message* message) {
  switch (static_cast<messages::IDBDatabaseCallbacks>(message->header()->name)) {
    case messages::IDBDatabaseCallbacks::kForcedClose: {
      DCHECK(message->is_serialized());
      internal::IDBDatabaseCallbacks_ForcedClose_Params_Data* params =
          reinterpret_cast<internal::IDBDatabaseCallbacks_ForcedClose_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IDBDatabaseCallbacks.0
      bool success = true;
      IDBDatabaseCallbacks_ForcedClose_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabaseCallbacks::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ForcedClose(        );
      return true;
    }
    case messages::IDBDatabaseCallbacks::kVersionChange: {
      DCHECK(message->is_serialized());
      internal::IDBDatabaseCallbacks_VersionChange_Params_Data* params =
          reinterpret_cast<internal::IDBDatabaseCallbacks_VersionChange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IDBDatabaseCallbacks.1
      bool success = true;
      int64_t p_old_version{};
      int64_t p_new_version{};
      IDBDatabaseCallbacks_VersionChange_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_old_version = input_data_view.old_version();
      if (success)
        p_new_version = input_data_view.new_version();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabaseCallbacks::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->VersionChange(        
        std::move(p_old_version), 
        std::move(p_new_version));
      return true;
    }
    case messages::IDBDatabaseCallbacks::kAbort: {
      DCHECK(message->is_serialized());
      internal::IDBDatabaseCallbacks_Abort_Params_Data* params =
          reinterpret_cast<internal::IDBDatabaseCallbacks_Abort_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IDBDatabaseCallbacks.2
      bool success = true;
      int64_t p_transaction_id{};
      IDBException p_code{};
      ::blink::String p_message{};
      IDBDatabaseCallbacks_Abort_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_transaction_id = input_data_view.transaction_id();
      if (success && !input_data_view.ReadCode(&p_code))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabaseCallbacks::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Abort(        
        std::move(p_transaction_id), 
        std::move(p_code), 
        std::move(p_message));
      return true;
    }
    case messages::IDBDatabaseCallbacks::kComplete: {
      DCHECK(message->is_serialized());
      internal::IDBDatabaseCallbacks_Complete_Params_Data* params =
          reinterpret_cast<internal::IDBDatabaseCallbacks_Complete_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IDBDatabaseCallbacks.3
      bool success = true;
      int64_t p_transaction_id{};
      IDBDatabaseCallbacks_Complete_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_transaction_id = input_data_view.transaction_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabaseCallbacks::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Complete(        
        std::move(p_transaction_id));
      return true;
    }
  }
  return false;
}

// static
bool IDBDatabaseCallbacksStubDispatch::AcceptWithResponder(
    IDBDatabaseCallbacks* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::IDBDatabaseCallbacks>(message->header()->name)) {
    case messages::IDBDatabaseCallbacks::kForcedClose: {
      break;
    }
    case messages::IDBDatabaseCallbacks::kVersionChange: {
      break;
    }
    case messages::IDBDatabaseCallbacks::kAbort: {
      break;
    }
    case messages::IDBDatabaseCallbacks::kComplete: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kIDBDatabaseCallbacksValidationInfo[] = {
    { &internal::IDBDatabaseCallbacks_ForcedClose_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::IDBDatabaseCallbacks_VersionChange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::IDBDatabaseCallbacks_Abort_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::IDBDatabaseCallbacks_Complete_Params_Data::Validate,
     nullptr /* no response */},
};

bool IDBDatabaseCallbacksRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::IDBDatabaseCallbacks::Name_,
    kIDBDatabaseCallbacksValidationInfo);
}

// The declaration includes the definition on other builds.

IDBCursor::IPCStableHashFunction IDBCursor::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::IDBCursor>(message.name())) {
    case messages::IDBCursor::kAdvance: {
      return &IDBCursor::Advance_Sym::IPCStableHash;
    }
    case messages::IDBCursor::kContinue: {
      return &IDBCursor::Continue_Sym::IPCStableHash;
    }
    case messages::IDBCursor::kPrefetch: {
      return &IDBCursor::Prefetch_Sym::IPCStableHash;
    }
    case messages::IDBCursor::kPrefetchReset: {
      return &IDBCursor::PrefetchReset_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* IDBCursor::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::IDBCursor>(message.name())) {
      case messages::IDBCursor::kAdvance:
            return "Receive blink::mojom::IDBCursor::Advance";
      case messages::IDBCursor::kContinue:
            return "Receive blink::mojom::IDBCursor::Continue";
      case messages::IDBCursor::kPrefetch:
            return "Receive blink::mojom::IDBCursor::Prefetch";
      case messages::IDBCursor::kPrefetchReset:
            return "Receive blink::mojom::IDBCursor::PrefetchReset";
    }
  } else {
    switch (static_cast<messages::IDBCursor>(message.name())) {
      case messages::IDBCursor::kAdvance:
            return "Receive reply blink::mojom::IDBCursor::Advance";
      case messages::IDBCursor::kContinue:
            return "Receive reply blink::mojom::IDBCursor::Continue";
      case messages::IDBCursor::kPrefetch:
            return "Receive reply blink::mojom::IDBCursor::Prefetch";
      case messages::IDBCursor::kPrefetchReset:
            return "Receive reply blink::mojom::IDBCursor::PrefetchReset";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t IDBCursor::Advance_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9f9f531c;  // IPCStableHash for blink::mojom::IDBCursor::Advance
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IDBCursor::Continue_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbc747607;  // IPCStableHash for blink::mojom::IDBCursor::Continue
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IDBCursor::Prefetch_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7e5cf48f;  // IPCStableHash for blink::mojom::IDBCursor::Prefetch
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IDBCursor::PrefetchReset_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb1cbd99b;  // IPCStableHash for blink::mojom::IDBCursor::PrefetchReset
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class IDBCursor_Advance_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IDBCursor_Advance_ForwardToCallback(
      IDBCursor::AdvanceCallback callback
      ) : callback_(std::move(callback)) {
  }

  IDBCursor_Advance_ForwardToCallback(const IDBCursor_Advance_ForwardToCallback&) = delete;
  IDBCursor_Advance_ForwardToCallback& operator=(const IDBCursor_Advance_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  IDBCursor::AdvanceCallback callback_;
};

class IDBCursor_Continue_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IDBCursor_Continue_ForwardToCallback(
      IDBCursor::ContinueCallback callback
      ) : callback_(std::move(callback)) {
  }

  IDBCursor_Continue_ForwardToCallback(const IDBCursor_Continue_ForwardToCallback&) = delete;
  IDBCursor_Continue_ForwardToCallback& operator=(const IDBCursor_Continue_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  IDBCursor::ContinueCallback callback_;
};

class IDBCursor_Prefetch_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IDBCursor_Prefetch_ForwardToCallback(
      IDBCursor::PrefetchCallback callback
      ) : callback_(std::move(callback)) {
  }

  IDBCursor_Prefetch_ForwardToCallback(const IDBCursor_Prefetch_ForwardToCallback&) = delete;
  IDBCursor_Prefetch_ForwardToCallback& operator=(const IDBCursor_Prefetch_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  IDBCursor::PrefetchCallback callback_;
};

IDBCursorProxy::IDBCursorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void IDBCursorProxy::Advance(
    uint32_t in_count, AdvanceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::IDBCursor::Advance", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("count"), in_count,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBCursor::kAdvance), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBCursor_Advance_Params_Data> params(
          message);
  params.Allocate();

  params->count = in_count;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBCursor::Name_);
  message.set_method_name("Advance");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IDBCursor_Advance_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void IDBCursorProxy::Continue(
    ::std::unique_ptr<::blink::IDBKey> in_key, ::std::unique_ptr<::blink::IDBKey> in_primary_key, ContinueCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::IDBCursor::Continue", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type ::std::unique_ptr<::blink::IDBKey>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("primary_key"), in_primary_key,
                        "<value of type ::std::unique_ptr<::blink::IDBKey>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBCursor::kContinue), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBCursor_Continue_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->key)>
      key_fragment(params.message());
  key_fragment.Claim(&params->key);
  
  mojo::internal::Serialize<::blink::mojom::IDBKeyDataView>(
    in_key,
    key_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key in IDBCursor.Continue request");
  mojo::internal::MessageFragment<decltype(params->primary_key)>
      primary_key_fragment(params.message());
  primary_key_fragment.Claim(&params->primary_key);
  
  mojo::internal::Serialize<::blink::mojom::IDBKeyDataView>(
    in_primary_key,
    primary_key_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->primary_key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null primary_key in IDBCursor.Continue request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBCursor::Name_);
  message.set_method_name("Continue");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IDBCursor_Continue_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void IDBCursorProxy::Prefetch(
    int32_t in_count, PrefetchCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::IDBCursor::Prefetch", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("count"), in_count,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBCursor::kPrefetch), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBCursor_Prefetch_Params_Data> params(
          message);
  params.Allocate();

  params->count = in_count;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBCursor::Name_);
  message.set_method_name("Prefetch");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IDBCursor_Prefetch_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void IDBCursorProxy::PrefetchReset(
    int32_t in_used_prefetches) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::IDBCursor::PrefetchReset", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("used_prefetches"), in_used_prefetches,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBCursor::kPrefetchReset), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBCursor_PrefetchReset_Params_Data> params(
          message);
  params.Allocate();

  params->used_prefetches = in_used_prefetches;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBCursor::Name_);
  message.set_method_name("PrefetchReset");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class IDBCursor_Advance_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static IDBCursor::AdvanceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<IDBCursor_Advance_ProxyToResponder> proxy(
        new IDBCursor_Advance_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&IDBCursor_Advance_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IDBCursor_Advance_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  IDBCursor_Advance_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "IDBCursor::AdvanceCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      IDBCursorResultPtr in_result);
};

bool IDBCursor_Advance_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::IDBCursor_Advance_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IDBCursor_Advance_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for IDBCursor.0
  bool success = true;
  IDBCursorResultPtr p_result{};
  IDBCursor_Advance_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IDBCursor::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void IDBCursor_Advance_ProxyToResponder::Run(
    IDBCursorResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::IDBCursor::Advance", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type IDBCursorResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBCursor::kAdvance), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBCursor_Advance_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::blink::mojom::IDBCursorResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBCursor::Name_);
  message.set_method_name("Advance");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IDBCursor_Continue_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static IDBCursor::ContinueCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<IDBCursor_Continue_ProxyToResponder> proxy(
        new IDBCursor_Continue_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&IDBCursor_Continue_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IDBCursor_Continue_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  IDBCursor_Continue_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "IDBCursor::ContinueCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      IDBCursorResultPtr in_result);
};

bool IDBCursor_Continue_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::IDBCursor_Continue_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IDBCursor_Continue_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for IDBCursor.1
  bool success = true;
  IDBCursorResultPtr p_result{};
  IDBCursor_Continue_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IDBCursor::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void IDBCursor_Continue_ProxyToResponder::Run(
    IDBCursorResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::IDBCursor::Continue", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type IDBCursorResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBCursor::kContinue), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBCursor_Continue_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::blink::mojom::IDBCursorResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBCursor::Name_);
  message.set_method_name("Continue");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IDBCursor_Prefetch_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static IDBCursor::PrefetchCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<IDBCursor_Prefetch_ProxyToResponder> proxy(
        new IDBCursor_Prefetch_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&IDBCursor_Prefetch_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IDBCursor_Prefetch_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  IDBCursor_Prefetch_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "IDBCursor::PrefetchCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      IDBCursorResultPtr in_result);
};

bool IDBCursor_Prefetch_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::IDBCursor_Prefetch_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IDBCursor_Prefetch_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for IDBCursor.2
  bool success = true;
  IDBCursorResultPtr p_result{};
  IDBCursor_Prefetch_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IDBCursor::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void IDBCursor_Prefetch_ProxyToResponder::Run(
    IDBCursorResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::IDBCursor::Prefetch", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type IDBCursorResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBCursor::kPrefetch), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBCursor_Prefetch_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::blink::mojom::IDBCursorResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBCursor::Name_);
  message.set_method_name("Prefetch");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool IDBCursorStubDispatch::Accept(
    IDBCursor* impl,
    mojo::Message* message) {
  switch (static_cast<messages::IDBCursor>(message->header()->name)) {
    case messages::IDBCursor::kAdvance: {
      break;
    }
    case messages::IDBCursor::kContinue: {
      break;
    }
    case messages::IDBCursor::kPrefetch: {
      break;
    }
    case messages::IDBCursor::kPrefetchReset: {
      DCHECK(message->is_serialized());
      internal::IDBCursor_PrefetchReset_Params_Data* params =
          reinterpret_cast<internal::IDBCursor_PrefetchReset_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IDBCursor.3
      bool success = true;
      int32_t p_used_prefetches{};
      IDBCursor_PrefetchReset_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_used_prefetches = input_data_view.used_prefetches();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBCursor::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PrefetchReset(        
        std::move(p_used_prefetches));
      return true;
    }
  }
  return false;
}

// static
bool IDBCursorStubDispatch::AcceptWithResponder(
    IDBCursor* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::IDBCursor>(message->header()->name)) {
    case messages::IDBCursor::kAdvance: {
      internal::IDBCursor_Advance_Params_Data* params =
          reinterpret_cast<
              internal::IDBCursor_Advance_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for IDBCursor.0
      bool success = true;
      uint32_t p_count{};
      IDBCursor_Advance_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_count = input_data_view.count();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBCursor::Name_, 0, false);
        return false;
      }
      auto callback =
          IDBCursor_Advance_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Advance(        
        std::move(p_count), std::move(callback));
      return true;
    }
    case messages::IDBCursor::kContinue: {
      internal::IDBCursor_Continue_Params_Data* params =
          reinterpret_cast<
              internal::IDBCursor_Continue_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for IDBCursor.1
      bool success = true;
      ::std::unique_ptr<::blink::IDBKey> p_key{};
      ::std::unique_ptr<::blink::IDBKey> p_primary_key{};
      IDBCursor_Continue_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (success && !input_data_view.ReadPrimaryKey(&p_primary_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBCursor::Name_, 1, false);
        return false;
      }
      auto callback =
          IDBCursor_Continue_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Continue(        
        std::move(p_key), 
        std::move(p_primary_key), std::move(callback));
      return true;
    }
    case messages::IDBCursor::kPrefetch: {
      internal::IDBCursor_Prefetch_Params_Data* params =
          reinterpret_cast<
              internal::IDBCursor_Prefetch_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for IDBCursor.2
      bool success = true;
      int32_t p_count{};
      IDBCursor_Prefetch_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_count = input_data_view.count();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBCursor::Name_, 2, false);
        return false;
      }
      auto callback =
          IDBCursor_Prefetch_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Prefetch(        
        std::move(p_count), std::move(callback));
      return true;
    }
    case messages::IDBCursor::kPrefetchReset: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kIDBCursorValidationInfo[] = {
    { &internal::IDBCursor_Advance_Params_Data::Validate,
     &internal::IDBCursor_Advance_ResponseParams_Data::Validate},
    { &internal::IDBCursor_Continue_Params_Data::Validate,
     &internal::IDBCursor_Continue_ResponseParams_Data::Validate},
    { &internal::IDBCursor_Prefetch_Params_Data::Validate,
     &internal::IDBCursor_Prefetch_ResponseParams_Data::Validate},
    { &internal::IDBCursor_PrefetchReset_Params_Data::Validate,
     nullptr /* no response */},
};

bool IDBCursorRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::IDBCursor::Name_,
    kIDBCursorValidationInfo);
}

bool IDBCursorResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::IDBCursor::Name_,
    kIDBCursorValidationInfo);
}
// The declaration includes the definition on other builds.

IDBTransaction::IPCStableHashFunction IDBTransaction::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::IDBTransaction>(message.name())) {
    case messages::IDBTransaction::kCreateObjectStore: {
      return &IDBTransaction::CreateObjectStore_Sym::IPCStableHash;
    }
    case messages::IDBTransaction::kDeleteObjectStore: {
      return &IDBTransaction::DeleteObjectStore_Sym::IPCStableHash;
    }
    case messages::IDBTransaction::kPut: {
      return &IDBTransaction::Put_Sym::IPCStableHash;
    }
    case messages::IDBTransaction::kSetIndexKeys: {
      return &IDBTransaction::SetIndexKeys_Sym::IPCStableHash;
    }
    case messages::IDBTransaction::kSetIndexKeysDone: {
      return &IDBTransaction::SetIndexKeysDone_Sym::IPCStableHash;
    }
    case messages::IDBTransaction::kCommit: {
      return &IDBTransaction::Commit_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* IDBTransaction::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::IDBTransaction>(message.name())) {
      case messages::IDBTransaction::kCreateObjectStore:
            return "Receive blink::mojom::IDBTransaction::CreateObjectStore";
      case messages::IDBTransaction::kDeleteObjectStore:
            return "Receive blink::mojom::IDBTransaction::DeleteObjectStore";
      case messages::IDBTransaction::kPut:
            return "Receive blink::mojom::IDBTransaction::Put";
      case messages::IDBTransaction::kSetIndexKeys:
            return "Receive blink::mojom::IDBTransaction::SetIndexKeys";
      case messages::IDBTransaction::kSetIndexKeysDone:
            return "Receive blink::mojom::IDBTransaction::SetIndexKeysDone";
      case messages::IDBTransaction::kCommit:
            return "Receive blink::mojom::IDBTransaction::Commit";
    }
  } else {
    switch (static_cast<messages::IDBTransaction>(message.name())) {
      case messages::IDBTransaction::kCreateObjectStore:
            return "Receive reply blink::mojom::IDBTransaction::CreateObjectStore";
      case messages::IDBTransaction::kDeleteObjectStore:
            return "Receive reply blink::mojom::IDBTransaction::DeleteObjectStore";
      case messages::IDBTransaction::kPut:
            return "Receive reply blink::mojom::IDBTransaction::Put";
      case messages::IDBTransaction::kSetIndexKeys:
            return "Receive reply blink::mojom::IDBTransaction::SetIndexKeys";
      case messages::IDBTransaction::kSetIndexKeysDone:
            return "Receive reply blink::mojom::IDBTransaction::SetIndexKeysDone";
      case messages::IDBTransaction::kCommit:
            return "Receive reply blink::mojom::IDBTransaction::Commit";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t IDBTransaction::CreateObjectStore_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x03171a1f;  // IPCStableHash for blink::mojom::IDBTransaction::CreateObjectStore
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IDBTransaction::DeleteObjectStore_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xaf00bc7d;  // IPCStableHash for blink::mojom::IDBTransaction::DeleteObjectStore
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IDBTransaction::Put_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdeb0e7b7;  // IPCStableHash for blink::mojom::IDBTransaction::Put
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IDBTransaction::SetIndexKeys_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8287258d;  // IPCStableHash for blink::mojom::IDBTransaction::SetIndexKeys
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IDBTransaction::SetIndexKeysDone_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x82d8f224;  // IPCStableHash for blink::mojom::IDBTransaction::SetIndexKeysDone
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IDBTransaction::Commit_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x944fdcc5;  // IPCStableHash for blink::mojom::IDBTransaction::Commit
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class IDBTransaction_Put_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IDBTransaction_Put_ForwardToCallback(
      IDBTransaction::PutCallback callback
      ) : callback_(std::move(callback)) {
  }

  IDBTransaction_Put_ForwardToCallback(const IDBTransaction_Put_ForwardToCallback&) = delete;
  IDBTransaction_Put_ForwardToCallback& operator=(const IDBTransaction_Put_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  IDBTransaction::PutCallback callback_;
};

IDBTransactionProxy::IDBTransactionProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void IDBTransactionProxy::CreateObjectStore(
    int64_t in_object_store_id, const ::blink::String& in_name, const ::blink::IDBKeyPath& in_key_path, bool in_auto_increment) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::IDBTransaction::CreateObjectStore", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("object_store_id"), in_object_store_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key_path"), in_key_path,
                        "<value of type const ::blink::IDBKeyPath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("auto_increment"), in_auto_increment,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBTransaction::kCreateObjectStore), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBTransaction_CreateObjectStore_Params_Data> params(
          message);
  params.Allocate();

  params->object_store_id = in_object_store_id;
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in IDBTransaction.CreateObjectStore request");
  mojo::internal::MessageFragment<
      typename decltype(params->key_path)::BaseType> key_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::IDBKeyPathDataView>(
    in_key_path,
    key_path_fragment);

  params->key_path.Set(
      key_path_fragment.is_null() ? nullptr : key_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key_path in IDBTransaction.CreateObjectStore request");

  params->auto_increment = in_auto_increment;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBTransaction::Name_);
  message.set_method_name("CreateObjectStore");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void IDBTransactionProxy::DeleteObjectStore(
    int64_t in_object_store_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::IDBTransaction::DeleteObjectStore", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("object_store_id"), in_object_store_id,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBTransaction::kDeleteObjectStore), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBTransaction_DeleteObjectStore_Params_Data> params(
          message);
  params.Allocate();

  params->object_store_id = in_object_store_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBTransaction::Name_);
  message.set_method_name("DeleteObjectStore");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void IDBTransactionProxy::Put(
    int64_t in_object_store_id, ::std::unique_ptr<::blink::IDBValue> in_value, ::std::unique_ptr<::blink::IDBKey> in_key, IDBPutMode in_mode, ::blink::Vector<::blink::IDBIndexKeys> in_index_keys, PutCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::IDBTransaction::Put", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("object_store_id"), in_object_store_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type ::std::unique_ptr<::blink::IDBValue>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key"), in_key,
                        "<value of type ::std::unique_ptr<::blink::IDBKey>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mode"), in_mode,
                        "<value of type IDBPutMode>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index_keys"), in_index_keys,
                        "<value of type ::blink::Vector<::blink::IDBIndexKeys>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBTransaction::kPut), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBTransaction_Put_Params_Data> params(
          message);
  params.Allocate();

  params->object_store_id = in_object_store_id;
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType> value_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::IDBValueDataView>(
    in_value,
    value_fragment);

  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->value.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null value in IDBTransaction.Put request");
  mojo::internal::MessageFragment<decltype(params->key)>
      key_fragment(params.message());
  key_fragment.Claim(&params->key);
  
  mojo::internal::Serialize<::blink::mojom::IDBKeyDataView>(
    in_key,
    key_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key in IDBTransaction.Put request");

  
  mojo::internal::Serialize<::blink::mojom::IDBPutMode>(
    in_mode,
    &params->mode);
  mojo::internal::MessageFragment<
      typename decltype(params->index_keys)::BaseType>
      index_keys_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& index_keys_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::IDBIndexKeysDataView>>(
    in_index_keys,
    index_keys_fragment,
    &index_keys_validate_params);

  params->index_keys.Set(
      index_keys_fragment.is_null() ? nullptr : index_keys_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->index_keys.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null index_keys in IDBTransaction.Put request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBTransaction::Name_);
  message.set_method_name("Put");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IDBTransaction_Put_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void IDBTransactionProxy::SetIndexKeys(
    int64_t in_object_store_id, ::std::unique_ptr<::blink::IDBKey> in_primary_key, ::blink::IDBIndexKeys in_index_keys) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::IDBTransaction::SetIndexKeys", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("object_store_id"), in_object_store_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("primary_key"), in_primary_key,
                        "<value of type ::std::unique_ptr<::blink::IDBKey>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index_keys"), in_index_keys,
                        "<value of type ::blink::IDBIndexKeys>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBTransaction::kSetIndexKeys), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBTransaction_SetIndexKeys_Params_Data> params(
          message);
  params.Allocate();

  params->object_store_id = in_object_store_id;
  mojo::internal::MessageFragment<decltype(params->primary_key)>
      primary_key_fragment(params.message());
  primary_key_fragment.Claim(&params->primary_key);
  
  mojo::internal::Serialize<::blink::mojom::IDBKeyDataView>(
    in_primary_key,
    primary_key_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->primary_key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null primary_key in IDBTransaction.SetIndexKeys request");
  mojo::internal::MessageFragment<
      typename decltype(params->index_keys)::BaseType> index_keys_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::IDBIndexKeysDataView>(
    in_index_keys,
    index_keys_fragment);

  params->index_keys.Set(
      index_keys_fragment.is_null() ? nullptr : index_keys_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->index_keys.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null index_keys in IDBTransaction.SetIndexKeys request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBTransaction::Name_);
  message.set_method_name("SetIndexKeys");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void IDBTransactionProxy::SetIndexKeysDone(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::IDBTransaction::SetIndexKeysDone");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBTransaction::kSetIndexKeysDone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBTransaction_SetIndexKeysDone_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBTransaction::Name_);
  message.set_method_name("SetIndexKeysDone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void IDBTransactionProxy::Commit(
    int64_t in_num_errors_handled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::IDBTransaction::Commit", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("num_errors_handled"), in_num_errors_handled,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBTransaction::kCommit), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBTransaction_Commit_Params_Data> params(
          message);
  params.Allocate();

  params->num_errors_handled = in_num_errors_handled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBTransaction::Name_);
  message.set_method_name("Commit");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class IDBTransaction_Put_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static IDBTransaction::PutCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<IDBTransaction_Put_ProxyToResponder> proxy(
        new IDBTransaction_Put_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&IDBTransaction_Put_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IDBTransaction_Put_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  IDBTransaction_Put_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "IDBTransaction::PutCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      IDBTransactionPutResultPtr in_result);
};

bool IDBTransaction_Put_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::IDBTransaction_Put_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IDBTransaction_Put_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for IDBTransaction.2
  bool success = true;
  IDBTransactionPutResultPtr p_result{};
  IDBTransaction_Put_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IDBTransaction::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void IDBTransaction_Put_ProxyToResponder::Run(
    IDBTransactionPutResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::IDBTransaction::Put", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type IDBTransactionPutResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBTransaction::kPut), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBTransaction_Put_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::blink::mojom::IDBTransactionPutResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBTransaction::Name_);
  message.set_method_name("Put");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool IDBTransactionStubDispatch::Accept(
    IDBTransaction* impl,
    mojo::Message* message) {
  switch (static_cast<messages::IDBTransaction>(message->header()->name)) {
    case messages::IDBTransaction::kCreateObjectStore: {
      DCHECK(message->is_serialized());
      internal::IDBTransaction_CreateObjectStore_Params_Data* params =
          reinterpret_cast<internal::IDBTransaction_CreateObjectStore_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IDBTransaction.0
      bool success = true;
      int64_t p_object_store_id{};
      ::blink::String p_name{};
      ::blink::IDBKeyPath p_key_path{};
      bool p_auto_increment{};
      IDBTransaction_CreateObjectStore_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_object_store_id = input_data_view.object_store_id();
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success && !input_data_view.ReadKeyPath(&p_key_path))
        success = false;
      if (success)
        p_auto_increment = input_data_view.auto_increment();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBTransaction::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateObjectStore(        
        std::move(p_object_store_id), 
        std::move(p_name), 
        std::move(p_key_path), 
        std::move(p_auto_increment));
      return true;
    }
    case messages::IDBTransaction::kDeleteObjectStore: {
      DCHECK(message->is_serialized());
      internal::IDBTransaction_DeleteObjectStore_Params_Data* params =
          reinterpret_cast<internal::IDBTransaction_DeleteObjectStore_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IDBTransaction.1
      bool success = true;
      int64_t p_object_store_id{};
      IDBTransaction_DeleteObjectStore_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_object_store_id = input_data_view.object_store_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBTransaction::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteObjectStore(        
        std::move(p_object_store_id));
      return true;
    }
    case messages::IDBTransaction::kPut: {
      break;
    }
    case messages::IDBTransaction::kSetIndexKeys: {
      DCHECK(message->is_serialized());
      internal::IDBTransaction_SetIndexKeys_Params_Data* params =
          reinterpret_cast<internal::IDBTransaction_SetIndexKeys_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IDBTransaction.3
      bool success = true;
      int64_t p_object_store_id{};
      ::std::unique_ptr<::blink::IDBKey> p_primary_key{};
      ::blink::IDBIndexKeys p_index_keys{};
      IDBTransaction_SetIndexKeys_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_object_store_id = input_data_view.object_store_id();
      if (success && !input_data_view.ReadPrimaryKey(&p_primary_key))
        success = false;
      if (success && !input_data_view.ReadIndexKeys(&p_index_keys))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBTransaction::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetIndexKeys(        
        std::move(p_object_store_id), 
        std::move(p_primary_key), 
        std::move(p_index_keys));
      return true;
    }
    case messages::IDBTransaction::kSetIndexKeysDone: {
      DCHECK(message->is_serialized());
      internal::IDBTransaction_SetIndexKeysDone_Params_Data* params =
          reinterpret_cast<internal::IDBTransaction_SetIndexKeysDone_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IDBTransaction.4
      bool success = true;
      IDBTransaction_SetIndexKeysDone_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBTransaction::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetIndexKeysDone(        );
      return true;
    }
    case messages::IDBTransaction::kCommit: {
      DCHECK(message->is_serialized());
      internal::IDBTransaction_Commit_Params_Data* params =
          reinterpret_cast<internal::IDBTransaction_Commit_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IDBTransaction.5
      bool success = true;
      int64_t p_num_errors_handled{};
      IDBTransaction_Commit_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_num_errors_handled = input_data_view.num_errors_handled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBTransaction::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Commit(        
        std::move(p_num_errors_handled));
      return true;
    }
  }
  return false;
}

// static
bool IDBTransactionStubDispatch::AcceptWithResponder(
    IDBTransaction* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::IDBTransaction>(message->header()->name)) {
    case messages::IDBTransaction::kCreateObjectStore: {
      break;
    }
    case messages::IDBTransaction::kDeleteObjectStore: {
      break;
    }
    case messages::IDBTransaction::kPut: {
      internal::IDBTransaction_Put_Params_Data* params =
          reinterpret_cast<
              internal::IDBTransaction_Put_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for IDBTransaction.2
      bool success = true;
      int64_t p_object_store_id{};
      ::std::unique_ptr<::blink::IDBValue> p_value{};
      ::std::unique_ptr<::blink::IDBKey> p_key{};
      IDBPutMode p_mode{};
      ::blink::Vector<::blink::IDBIndexKeys> p_index_keys{};
      IDBTransaction_Put_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_object_store_id = input_data_view.object_store_id();
      if (success && !input_data_view.ReadValue(&p_value))
        success = false;
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (success && !input_data_view.ReadMode(&p_mode))
        success = false;
      if (success && !input_data_view.ReadIndexKeys(&p_index_keys))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBTransaction::Name_, 2, false);
        return false;
      }
      auto callback =
          IDBTransaction_Put_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Put(        
        std::move(p_object_store_id), 
        std::move(p_value), 
        std::move(p_key), 
        std::move(p_mode), 
        std::move(p_index_keys), std::move(callback));
      return true;
    }
    case messages::IDBTransaction::kSetIndexKeys: {
      break;
    }
    case messages::IDBTransaction::kSetIndexKeysDone: {
      break;
    }
    case messages::IDBTransaction::kCommit: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kIDBTransactionValidationInfo[] = {
    { &internal::IDBTransaction_CreateObjectStore_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::IDBTransaction_DeleteObjectStore_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::IDBTransaction_Put_Params_Data::Validate,
     &internal::IDBTransaction_Put_ResponseParams_Data::Validate},
    { &internal::IDBTransaction_SetIndexKeys_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::IDBTransaction_SetIndexKeysDone_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::IDBTransaction_Commit_Params_Data::Validate,
     nullptr /* no response */},
};

bool IDBTransactionRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::IDBTransaction::Name_,
    kIDBTransactionValidationInfo);
}

bool IDBTransactionResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::IDBTransaction::Name_,
    kIDBTransactionValidationInfo);
}
// The declaration includes the definition on other builds.

IDBDatabaseGetAllResultSink::IPCStableHashFunction IDBDatabaseGetAllResultSink::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::IDBDatabaseGetAllResultSink>(message.name())) {
    case messages::IDBDatabaseGetAllResultSink::kReceiveResults: {
      return &IDBDatabaseGetAllResultSink::ReceiveResults_Sym::IPCStableHash;
    }
    case messages::IDBDatabaseGetAllResultSink::kOnError: {
      return &IDBDatabaseGetAllResultSink::OnError_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* IDBDatabaseGetAllResultSink::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::IDBDatabaseGetAllResultSink>(message.name())) {
      case messages::IDBDatabaseGetAllResultSink::kReceiveResults:
            return "Receive blink::mojom::IDBDatabaseGetAllResultSink::ReceiveResults";
      case messages::IDBDatabaseGetAllResultSink::kOnError:
            return "Receive blink::mojom::IDBDatabaseGetAllResultSink::OnError";
    }
  } else {
    switch (static_cast<messages::IDBDatabaseGetAllResultSink>(message.name())) {
      case messages::IDBDatabaseGetAllResultSink::kReceiveResults:
            return "Receive reply blink::mojom::IDBDatabaseGetAllResultSink::ReceiveResults";
      case messages::IDBDatabaseGetAllResultSink::kOnError:
            return "Receive reply blink::mojom::IDBDatabaseGetAllResultSink::OnError";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t IDBDatabaseGetAllResultSink::ReceiveResults_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x037f386e;  // IPCStableHash for blink::mojom::IDBDatabaseGetAllResultSink::ReceiveResults
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IDBDatabaseGetAllResultSink::OnError_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1f7ff244;  // IPCStableHash for blink::mojom::IDBDatabaseGetAllResultSink::OnError
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

IDBDatabaseGetAllResultSinkProxy::IDBDatabaseGetAllResultSinkProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void IDBDatabaseGetAllResultSinkProxy::ReceiveResults(
    ::blink::Vector<IDBRecordPtr> in_records, bool in_done) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::IDBDatabaseGetAllResultSink::ReceiveResults", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("records"), in_records,
                        "<value of type ::blink::Vector<IDBRecordPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("done"), in_done,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBDatabaseGetAllResultSink::kReceiveResults), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBDatabaseGetAllResultSink_ReceiveResults_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->records)::BaseType>
      records_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& records_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::IDBRecordDataView>>(
    in_records,
    records_fragment,
    &records_validate_params);

  params->records.Set(
      records_fragment.is_null() ? nullptr : records_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->records.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null records in IDBDatabaseGetAllResultSink.ReceiveResults request");

  params->done = in_done;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabaseGetAllResultSink::Name_);
  message.set_method_name("ReceiveResults");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void IDBDatabaseGetAllResultSinkProxy::OnError(
    IDBErrorPtr in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::IDBDatabaseGetAllResultSink::OnError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type IDBErrorPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBDatabaseGetAllResultSink::kOnError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBDatabaseGetAllResultSink_OnError_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::IDBErrorDataView>(
    in_error,
    error_fragment);

  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->error.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null error in IDBDatabaseGetAllResultSink.OnError request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabaseGetAllResultSink::Name_);
  message.set_method_name("OnError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool IDBDatabaseGetAllResultSinkStubDispatch::Accept(
    IDBDatabaseGetAllResultSink* impl,
    mojo::Message* message) {
  switch (static_cast<messages::IDBDatabaseGetAllResultSink>(message->header()->name)) {
    case messages::IDBDatabaseGetAllResultSink::kReceiveResults: {
      DCHECK(message->is_serialized());
      internal::IDBDatabaseGetAllResultSink_ReceiveResults_Params_Data* params =
          reinterpret_cast<internal::IDBDatabaseGetAllResultSink_ReceiveResults_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IDBDatabaseGetAllResultSink.0
      bool success = true;
      ::blink::Vector<IDBRecordPtr> p_records{};
      bool p_done{};
      IDBDatabaseGetAllResultSink_ReceiveResults_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRecords(&p_records))
        success = false;
      if (success)
        p_done = input_data_view.done();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabaseGetAllResultSink::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReceiveResults(        
        std::move(p_records), 
        std::move(p_done));
      return true;
    }
    case messages::IDBDatabaseGetAllResultSink::kOnError: {
      DCHECK(message->is_serialized());
      internal::IDBDatabaseGetAllResultSink_OnError_Params_Data* params =
          reinterpret_cast<internal::IDBDatabaseGetAllResultSink_OnError_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IDBDatabaseGetAllResultSink.1
      bool success = true;
      IDBErrorPtr p_error{};
      IDBDatabaseGetAllResultSink_OnError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadError(&p_error))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabaseGetAllResultSink::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnError(        
        std::move(p_error));
      return true;
    }
  }
  return false;
}

// static
bool IDBDatabaseGetAllResultSinkStubDispatch::AcceptWithResponder(
    IDBDatabaseGetAllResultSink* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::IDBDatabaseGetAllResultSink>(message->header()->name)) {
    case messages::IDBDatabaseGetAllResultSink::kReceiveResults: {
      break;
    }
    case messages::IDBDatabaseGetAllResultSink::kOnError: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kIDBDatabaseGetAllResultSinkValidationInfo[] = {
    { &internal::IDBDatabaseGetAllResultSink_ReceiveResults_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::IDBDatabaseGetAllResultSink_OnError_Params_Data::Validate,
     nullptr /* no response */},
};

bool IDBDatabaseGetAllResultSinkRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::IDBDatabaseGetAllResultSink::Name_,
    kIDBDatabaseGetAllResultSinkValidationInfo);
}

// The declaration includes the definition on other builds.

IDBDatabase::IPCStableHashFunction IDBDatabase::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::IDBDatabase>(message.name())) {
    case messages::IDBDatabase::kRenameObjectStore: {
      return &IDBDatabase::RenameObjectStore_Sym::IPCStableHash;
    }
    case messages::IDBDatabase::kCreateTransaction: {
      return &IDBDatabase::CreateTransaction_Sym::IPCStableHash;
    }
    case messages::IDBDatabase::kVersionChangeIgnored: {
      return &IDBDatabase::VersionChangeIgnored_Sym::IPCStableHash;
    }
    case messages::IDBDatabase::kGet: {
      return &IDBDatabase::Get_Sym::IPCStableHash;
    }
    case messages::IDBDatabase::kGetAll: {
      return &IDBDatabase::GetAll_Sym::IPCStableHash;
    }
    case messages::IDBDatabase::kOpenCursor: {
      return &IDBDatabase::OpenCursor_Sym::IPCStableHash;
    }
    case messages::IDBDatabase::kCount: {
      return &IDBDatabase::Count_Sym::IPCStableHash;
    }
    case messages::IDBDatabase::kDeleteRange: {
      return &IDBDatabase::DeleteRange_Sym::IPCStableHash;
    }
    case messages::IDBDatabase::kGetKeyGeneratorCurrentNumber: {
      return &IDBDatabase::GetKeyGeneratorCurrentNumber_Sym::IPCStableHash;
    }
    case messages::IDBDatabase::kClear: {
      return &IDBDatabase::Clear_Sym::IPCStableHash;
    }
    case messages::IDBDatabase::kCreateIndex: {
      return &IDBDatabase::CreateIndex_Sym::IPCStableHash;
    }
    case messages::IDBDatabase::kDeleteIndex: {
      return &IDBDatabase::DeleteIndex_Sym::IPCStableHash;
    }
    case messages::IDBDatabase::kRenameIndex: {
      return &IDBDatabase::RenameIndex_Sym::IPCStableHash;
    }
    case messages::IDBDatabase::kAbort: {
      return &IDBDatabase::Abort_Sym::IPCStableHash;
    }
    case messages::IDBDatabase::kDidBecomeInactive: {
      return &IDBDatabase::DidBecomeInactive_Sym::IPCStableHash;
    }
    case messages::IDBDatabase::kUpdatePriority: {
      return &IDBDatabase::UpdatePriority_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* IDBDatabase::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::IDBDatabase>(message.name())) {
      case messages::IDBDatabase::kRenameObjectStore:
            return "Receive blink::mojom::IDBDatabase::RenameObjectStore";
      case messages::IDBDatabase::kCreateTransaction:
            return "Receive blink::mojom::IDBDatabase::CreateTransaction";
      case messages::IDBDatabase::kVersionChangeIgnored:
            return "Receive blink::mojom::IDBDatabase::VersionChangeIgnored";
      case messages::IDBDatabase::kGet:
            return "Receive blink::mojom::IDBDatabase::Get";
      case messages::IDBDatabase::kGetAll:
            return "Receive blink::mojom::IDBDatabase::GetAll";
      case messages::IDBDatabase::kOpenCursor:
            return "Receive blink::mojom::IDBDatabase::OpenCursor";
      case messages::IDBDatabase::kCount:
            return "Receive blink::mojom::IDBDatabase::Count";
      case messages::IDBDatabase::kDeleteRange:
            return "Receive blink::mojom::IDBDatabase::DeleteRange";
      case messages::IDBDatabase::kGetKeyGeneratorCurrentNumber:
            return "Receive blink::mojom::IDBDatabase::GetKeyGeneratorCurrentNumber";
      case messages::IDBDatabase::kClear:
            return "Receive blink::mojom::IDBDatabase::Clear";
      case messages::IDBDatabase::kCreateIndex:
            return "Receive blink::mojom::IDBDatabase::CreateIndex";
      case messages::IDBDatabase::kDeleteIndex:
            return "Receive blink::mojom::IDBDatabase::DeleteIndex";
      case messages::IDBDatabase::kRenameIndex:
            return "Receive blink::mojom::IDBDatabase::RenameIndex";
      case messages::IDBDatabase::kAbort:
            return "Receive blink::mojom::IDBDatabase::Abort";
      case messages::IDBDatabase::kDidBecomeInactive:
            return "Receive blink::mojom::IDBDatabase::DidBecomeInactive";
      case messages::IDBDatabase::kUpdatePriority:
            return "Receive blink::mojom::IDBDatabase::UpdatePriority";
    }
  } else {
    switch (static_cast<messages::IDBDatabase>(message.name())) {
      case messages::IDBDatabase::kRenameObjectStore:
            return "Receive reply blink::mojom::IDBDatabase::RenameObjectStore";
      case messages::IDBDatabase::kCreateTransaction:
            return "Receive reply blink::mojom::IDBDatabase::CreateTransaction";
      case messages::IDBDatabase::kVersionChangeIgnored:
            return "Receive reply blink::mojom::IDBDatabase::VersionChangeIgnored";
      case messages::IDBDatabase::kGet:
            return "Receive reply blink::mojom::IDBDatabase::Get";
      case messages::IDBDatabase::kGetAll:
            return "Receive reply blink::mojom::IDBDatabase::GetAll";
      case messages::IDBDatabase::kOpenCursor:
            return "Receive reply blink::mojom::IDBDatabase::OpenCursor";
      case messages::IDBDatabase::kCount:
            return "Receive reply blink::mojom::IDBDatabase::Count";
      case messages::IDBDatabase::kDeleteRange:
            return "Receive reply blink::mojom::IDBDatabase::DeleteRange";
      case messages::IDBDatabase::kGetKeyGeneratorCurrentNumber:
            return "Receive reply blink::mojom::IDBDatabase::GetKeyGeneratorCurrentNumber";
      case messages::IDBDatabase::kClear:
            return "Receive reply blink::mojom::IDBDatabase::Clear";
      case messages::IDBDatabase::kCreateIndex:
            return "Receive reply blink::mojom::IDBDatabase::CreateIndex";
      case messages::IDBDatabase::kDeleteIndex:
            return "Receive reply blink::mojom::IDBDatabase::DeleteIndex";
      case messages::IDBDatabase::kRenameIndex:
            return "Receive reply blink::mojom::IDBDatabase::RenameIndex";
      case messages::IDBDatabase::kAbort:
            return "Receive reply blink::mojom::IDBDatabase::Abort";
      case messages::IDBDatabase::kDidBecomeInactive:
            return "Receive reply blink::mojom::IDBDatabase::DidBecomeInactive";
      case messages::IDBDatabase::kUpdatePriority:
            return "Receive reply blink::mojom::IDBDatabase::UpdatePriority";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t IDBDatabase::RenameObjectStore_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x32107642;  // IPCStableHash for blink::mojom::IDBDatabase::RenameObjectStore
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IDBDatabase::CreateTransaction_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x17d978c2;  // IPCStableHash for blink::mojom::IDBDatabase::CreateTransaction
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IDBDatabase::VersionChangeIgnored_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfbfdcd15;  // IPCStableHash for blink::mojom::IDBDatabase::VersionChangeIgnored
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IDBDatabase::Get_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa5150d3e;  // IPCStableHash for blink::mojom::IDBDatabase::Get
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IDBDatabase::GetAll_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa6a429f5;  // IPCStableHash for blink::mojom::IDBDatabase::GetAll
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IDBDatabase::OpenCursor_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x20ff63ca;  // IPCStableHash for blink::mojom::IDBDatabase::OpenCursor
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IDBDatabase::Count_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc3f6e0e1;  // IPCStableHash for blink::mojom::IDBDatabase::Count
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IDBDatabase::DeleteRange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa3b3773b;  // IPCStableHash for blink::mojom::IDBDatabase::DeleteRange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IDBDatabase::GetKeyGeneratorCurrentNumber_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x23a58007;  // IPCStableHash for blink::mojom::IDBDatabase::GetKeyGeneratorCurrentNumber
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IDBDatabase::Clear_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x515baaa4;  // IPCStableHash for blink::mojom::IDBDatabase::Clear
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IDBDatabase::CreateIndex_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3bf4d0e0;  // IPCStableHash for blink::mojom::IDBDatabase::CreateIndex
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IDBDatabase::DeleteIndex_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa2e0bf20;  // IPCStableHash for blink::mojom::IDBDatabase::DeleteIndex
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IDBDatabase::RenameIndex_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x976d3942;  // IPCStableHash for blink::mojom::IDBDatabase::RenameIndex
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IDBDatabase::Abort_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1ba4e9c3;  // IPCStableHash for blink::mojom::IDBDatabase::Abort
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IDBDatabase::DidBecomeInactive_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4a75de29;  // IPCStableHash for blink::mojom::IDBDatabase::DidBecomeInactive
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IDBDatabase::UpdatePriority_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7cd3a35a;  // IPCStableHash for blink::mojom::IDBDatabase::UpdatePriority
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class IDBDatabase_Get_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IDBDatabase_Get_ForwardToCallback(
      IDBDatabase::GetCallback callback
      ) : callback_(std::move(callback)) {
  }

  IDBDatabase_Get_ForwardToCallback(const IDBDatabase_Get_ForwardToCallback&) = delete;
  IDBDatabase_Get_ForwardToCallback& operator=(const IDBDatabase_Get_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  IDBDatabase::GetCallback callback_;
};

class IDBDatabase_GetAll_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IDBDatabase_GetAll_ForwardToCallback(
      IDBDatabase::GetAllCallback callback
      ) : callback_(std::move(callback)) {
  }

  IDBDatabase_GetAll_ForwardToCallback(const IDBDatabase_GetAll_ForwardToCallback&) = delete;
  IDBDatabase_GetAll_ForwardToCallback& operator=(const IDBDatabase_GetAll_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  IDBDatabase::GetAllCallback callback_;
};

class IDBDatabase_OpenCursor_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IDBDatabase_OpenCursor_ForwardToCallback(
      IDBDatabase::OpenCursorCallback callback
      ) : callback_(std::move(callback)) {
  }

  IDBDatabase_OpenCursor_ForwardToCallback(const IDBDatabase_OpenCursor_ForwardToCallback&) = delete;
  IDBDatabase_OpenCursor_ForwardToCallback& operator=(const IDBDatabase_OpenCursor_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  IDBDatabase::OpenCursorCallback callback_;
};

class IDBDatabase_Count_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IDBDatabase_Count_ForwardToCallback(
      IDBDatabase::CountCallback callback
      ) : callback_(std::move(callback)) {
  }

  IDBDatabase_Count_ForwardToCallback(const IDBDatabase_Count_ForwardToCallback&) = delete;
  IDBDatabase_Count_ForwardToCallback& operator=(const IDBDatabase_Count_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  IDBDatabase::CountCallback callback_;
};

class IDBDatabase_DeleteRange_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IDBDatabase_DeleteRange_ForwardToCallback(
      IDBDatabase::DeleteRangeCallback callback
      ) : callback_(std::move(callback)) {
  }

  IDBDatabase_DeleteRange_ForwardToCallback(const IDBDatabase_DeleteRange_ForwardToCallback&) = delete;
  IDBDatabase_DeleteRange_ForwardToCallback& operator=(const IDBDatabase_DeleteRange_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  IDBDatabase::DeleteRangeCallback callback_;
};

class IDBDatabase_GetKeyGeneratorCurrentNumber_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IDBDatabase_GetKeyGeneratorCurrentNumber_ForwardToCallback(
      IDBDatabase::GetKeyGeneratorCurrentNumberCallback callback
      ) : callback_(std::move(callback)) {
  }

  IDBDatabase_GetKeyGeneratorCurrentNumber_ForwardToCallback(const IDBDatabase_GetKeyGeneratorCurrentNumber_ForwardToCallback&) = delete;
  IDBDatabase_GetKeyGeneratorCurrentNumber_ForwardToCallback& operator=(const IDBDatabase_GetKeyGeneratorCurrentNumber_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  IDBDatabase::GetKeyGeneratorCurrentNumberCallback callback_;
};

class IDBDatabase_Clear_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IDBDatabase_Clear_ForwardToCallback(
      IDBDatabase::ClearCallback callback
      ) : callback_(std::move(callback)) {
  }

  IDBDatabase_Clear_ForwardToCallback(const IDBDatabase_Clear_ForwardToCallback&) = delete;
  IDBDatabase_Clear_ForwardToCallback& operator=(const IDBDatabase_Clear_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  IDBDatabase::ClearCallback callback_;
};

IDBDatabaseProxy::IDBDatabaseProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void IDBDatabaseProxy::RenameObjectStore(
    int64_t in_transaction_id, int64_t in_object_store_id, const ::blink::String& in_new_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::IDBDatabase::RenameObjectStore", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("transaction_id"), in_transaction_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("object_store_id"), in_object_store_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_name"), in_new_name,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBDatabase::kRenameObjectStore), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBDatabase_RenameObjectStore_Params_Data> params(
          message);
  params.Allocate();

  params->transaction_id = in_transaction_id;

  params->object_store_id = in_object_store_id;
  mojo::internal::MessageFragment<
      typename decltype(params->new_name)::BaseType> new_name_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_new_name,
    new_name_fragment);

  params->new_name.Set(
      new_name_fragment.is_null() ? nullptr : new_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->new_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null new_name in IDBDatabase.RenameObjectStore request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("RenameObjectStore");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void IDBDatabaseProxy::CreateTransaction(
    ::mojo::PendingAssociatedReceiver<IDBTransaction> in_transaction_receiver, int64_t in_transaction_id, const ::blink::Vector<int64_t>& in_object_store_ids, IDBTransactionMode in_mode, IDBTransactionDurability in_durability) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::IDBDatabase::CreateTransaction", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("transaction_receiver"), in_transaction_receiver,
                        "<value of type ::mojo::PendingAssociatedReceiver<IDBTransaction>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("transaction_id"), in_transaction_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("object_store_ids"), in_object_store_ids,
                        "<value of type const ::blink::Vector<int64_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mode"), in_mode,
                        "<value of type IDBTransactionMode>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("durability"), in_durability,
                        "<value of type IDBTransactionDurability>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBDatabase::kCreateTransaction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBDatabase_CreateTransaction_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::IDBTransactionAssociatedRequestDataView>(
    in_transaction_receiver,
    &params->transaction_receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->transaction_receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid transaction_receiver in IDBDatabase.CreateTransaction request");

  params->transaction_id = in_transaction_id;
  mojo::internal::MessageFragment<
      typename decltype(params->object_store_ids)::BaseType>
      object_store_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& object_store_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<int64_t>>(
    in_object_store_ids,
    object_store_ids_fragment,
    &object_store_ids_validate_params);

  params->object_store_ids.Set(
      object_store_ids_fragment.is_null() ? nullptr : object_store_ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->object_store_ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null object_store_ids in IDBDatabase.CreateTransaction request");

  
  mojo::internal::Serialize<::blink::mojom::IDBTransactionMode>(
    in_mode,
    &params->mode);

  
  mojo::internal::Serialize<::blink::mojom::IDBTransactionDurability>(
    in_durability,
    &params->durability);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("CreateTransaction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void IDBDatabaseProxy::VersionChangeIgnored(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::IDBDatabase::VersionChangeIgnored");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBDatabase::kVersionChangeIgnored), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBDatabase_VersionChangeIgnored_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("VersionChangeIgnored");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void IDBDatabaseProxy::Get(
    int64_t in_transaction_id, int64_t in_object_store_id, int64_t in_index_id, IDBKeyRangePtr in_key_range, bool in_key_only, GetCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::IDBDatabase::Get", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("transaction_id"), in_transaction_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("object_store_id"), in_object_store_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index_id"), in_index_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key_range"), in_key_range,
                        "<value of type IDBKeyRangePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key_only"), in_key_only,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBDatabase::kGet), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBDatabase_Get_Params_Data> params(
          message);
  params.Allocate();

  params->transaction_id = in_transaction_id;

  params->object_store_id = in_object_store_id;

  params->index_id = in_index_id;
  mojo::internal::MessageFragment<
      typename decltype(params->key_range)::BaseType> key_range_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::IDBKeyRangeDataView>(
    in_key_range,
    key_range_fragment);

  params->key_range.Set(
      key_range_fragment.is_null() ? nullptr : key_range_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key_range.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key_range in IDBDatabase.Get request");

  params->key_only = in_key_only;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("Get");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IDBDatabase_Get_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void IDBDatabaseProxy::GetAll(
    int64_t in_transaction_id, int64_t in_object_store_id, int64_t in_index_id, IDBKeyRangePtr in_key_range, IDBGetAllResultType in_result_type, int64_t in_max_count, IDBCursorDirection in_direction, GetAllCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::IDBDatabase::GetAll", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("transaction_id"), in_transaction_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("object_store_id"), in_object_store_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index_id"), in_index_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key_range"), in_key_range,
                        "<value of type IDBKeyRangePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result_type"), in_result_type,
                        "<value of type IDBGetAllResultType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("max_count"), in_max_count,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("direction"), in_direction,
                        "<value of type IDBCursorDirection>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBDatabase::kGetAll), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBDatabase_GetAll_Params_Data> params(
          message);
  params.Allocate();

  params->transaction_id = in_transaction_id;

  params->object_store_id = in_object_store_id;

  params->index_id = in_index_id;
  mojo::internal::MessageFragment<
      typename decltype(params->key_range)::BaseType> key_range_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::IDBKeyRangeDataView>(
    in_key_range,
    key_range_fragment);

  params->key_range.Set(
      key_range_fragment.is_null() ? nullptr : key_range_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key_range.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key_range in IDBDatabase.GetAll request");

  
  mojo::internal::Serialize<::blink::mojom::IDBGetAllResultType>(
    in_result_type,
    &params->result_type);

  params->max_count = in_max_count;

  
  mojo::internal::Serialize<::blink::mojom::IDBCursorDirection>(
    in_direction,
    &params->direction);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("GetAll");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IDBDatabase_GetAll_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void IDBDatabaseProxy::OpenCursor(
    int64_t in_transaction_id, int64_t in_object_store_id, int64_t in_index_id, IDBKeyRangePtr in_key_range, IDBCursorDirection in_direction, bool in_key_only, IDBTaskType in_task_type, OpenCursorCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::IDBDatabase::OpenCursor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("transaction_id"), in_transaction_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("object_store_id"), in_object_store_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index_id"), in_index_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key_range"), in_key_range,
                        "<value of type IDBKeyRangePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("direction"), in_direction,
                        "<value of type IDBCursorDirection>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key_only"), in_key_only,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("task_type"), in_task_type,
                        "<value of type IDBTaskType>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBDatabase::kOpenCursor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBDatabase_OpenCursor_Params_Data> params(
          message);
  params.Allocate();

  params->transaction_id = in_transaction_id;

  params->object_store_id = in_object_store_id;

  params->index_id = in_index_id;
  mojo::internal::MessageFragment<
      typename decltype(params->key_range)::BaseType> key_range_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::IDBKeyRangeDataView>(
    in_key_range,
    key_range_fragment);

  params->key_range.Set(
      key_range_fragment.is_null() ? nullptr : key_range_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key_range.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key_range in IDBDatabase.OpenCursor request");

  
  mojo::internal::Serialize<::blink::mojom::IDBCursorDirection>(
    in_direction,
    &params->direction);

  params->key_only = in_key_only;

  
  mojo::internal::Serialize<::blink::mojom::IDBTaskType>(
    in_task_type,
    &params->task_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("OpenCursor");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IDBDatabase_OpenCursor_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void IDBDatabaseProxy::Count(
    int64_t in_transaction_id, int64_t in_object_store_id, int64_t in_index_id, IDBKeyRangePtr in_key_range, CountCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::IDBDatabase::Count", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("transaction_id"), in_transaction_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("object_store_id"), in_object_store_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index_id"), in_index_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key_range"), in_key_range,
                        "<value of type IDBKeyRangePtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBDatabase::kCount), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBDatabase_Count_Params_Data> params(
          message);
  params.Allocate();

  params->transaction_id = in_transaction_id;

  params->object_store_id = in_object_store_id;

  params->index_id = in_index_id;
  mojo::internal::MessageFragment<
      typename decltype(params->key_range)::BaseType> key_range_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::IDBKeyRangeDataView>(
    in_key_range,
    key_range_fragment);

  params->key_range.Set(
      key_range_fragment.is_null() ? nullptr : key_range_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key_range.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key_range in IDBDatabase.Count request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("Count");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IDBDatabase_Count_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void IDBDatabaseProxy::DeleteRange(
    int64_t in_transaction_id, int64_t in_object_store_id, IDBKeyRangePtr in_key_range, DeleteRangeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::IDBDatabase::DeleteRange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("transaction_id"), in_transaction_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("object_store_id"), in_object_store_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key_range"), in_key_range,
                        "<value of type IDBKeyRangePtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBDatabase::kDeleteRange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBDatabase_DeleteRange_Params_Data> params(
          message);
  params.Allocate();

  params->transaction_id = in_transaction_id;

  params->object_store_id = in_object_store_id;
  mojo::internal::MessageFragment<
      typename decltype(params->key_range)::BaseType> key_range_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::IDBKeyRangeDataView>(
    in_key_range,
    key_range_fragment);

  params->key_range.Set(
      key_range_fragment.is_null() ? nullptr : key_range_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key_range.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key_range in IDBDatabase.DeleteRange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("DeleteRange");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IDBDatabase_DeleteRange_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void IDBDatabaseProxy::GetKeyGeneratorCurrentNumber(
    int64_t in_transaction_id, int64_t in_object_store_id, GetKeyGeneratorCurrentNumberCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::IDBDatabase::GetKeyGeneratorCurrentNumber", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("transaction_id"), in_transaction_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("object_store_id"), in_object_store_id,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBDatabase::kGetKeyGeneratorCurrentNumber), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBDatabase_GetKeyGeneratorCurrentNumber_Params_Data> params(
          message);
  params.Allocate();

  params->transaction_id = in_transaction_id;

  params->object_store_id = in_object_store_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("GetKeyGeneratorCurrentNumber");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IDBDatabase_GetKeyGeneratorCurrentNumber_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void IDBDatabaseProxy::Clear(
    int64_t in_transaction_id, int64_t in_object_store_id, ClearCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::IDBDatabase::Clear", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("transaction_id"), in_transaction_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("object_store_id"), in_object_store_id,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBDatabase::kClear), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBDatabase_Clear_Params_Data> params(
          message);
  params.Allocate();

  params->transaction_id = in_transaction_id;

  params->object_store_id = in_object_store_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("Clear");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IDBDatabase_Clear_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void IDBDatabaseProxy::CreateIndex(
    int64_t in_transaction_id, int64_t in_object_store_id, const ::scoped_refptr<::blink::IDBIndexMetadata>& in_index) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::IDBDatabase::CreateIndex", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("transaction_id"), in_transaction_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("object_store_id"), in_object_store_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index"), in_index,
                        "<value of type const ::scoped_refptr<::blink::IDBIndexMetadata>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBDatabase::kCreateIndex), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBDatabase_CreateIndex_Params_Data> params(
          message);
  params.Allocate();

  params->transaction_id = in_transaction_id;

  params->object_store_id = in_object_store_id;
  mojo::internal::MessageFragment<
      typename decltype(params->index)::BaseType> index_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::IDBIndexMetadataDataView>(
    in_index,
    index_fragment);

  params->index.Set(
      index_fragment.is_null() ? nullptr : index_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->index.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null index in IDBDatabase.CreateIndex request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("CreateIndex");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void IDBDatabaseProxy::DeleteIndex(
    int64_t in_transaction_id, int64_t in_object_store_id, int64_t in_index_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::IDBDatabase::DeleteIndex", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("transaction_id"), in_transaction_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("object_store_id"), in_object_store_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index_id"), in_index_id,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBDatabase::kDeleteIndex), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBDatabase_DeleteIndex_Params_Data> params(
          message);
  params.Allocate();

  params->transaction_id = in_transaction_id;

  params->object_store_id = in_object_store_id;

  params->index_id = in_index_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("DeleteIndex");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void IDBDatabaseProxy::RenameIndex(
    int64_t in_transaction_id, int64_t in_object_store_id, int64_t in_index_id, const ::blink::String& in_new_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::IDBDatabase::RenameIndex", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("transaction_id"), in_transaction_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("object_store_id"), in_object_store_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index_id"), in_index_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_name"), in_new_name,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBDatabase::kRenameIndex), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBDatabase_RenameIndex_Params_Data> params(
          message);
  params.Allocate();

  params->transaction_id = in_transaction_id;

  params->object_store_id = in_object_store_id;

  params->index_id = in_index_id;
  mojo::internal::MessageFragment<
      typename decltype(params->new_name)::BaseType> new_name_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_new_name,
    new_name_fragment);

  params->new_name.Set(
      new_name_fragment.is_null() ? nullptr : new_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->new_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null new_name in IDBDatabase.RenameIndex request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("RenameIndex");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void IDBDatabaseProxy::Abort(
    int64_t in_transaction_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::IDBDatabase::Abort", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("transaction_id"), in_transaction_id,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBDatabase::kAbort), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBDatabase_Abort_Params_Data> params(
          message);
  params.Allocate();

  params->transaction_id = in_transaction_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("Abort");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void IDBDatabaseProxy::DidBecomeInactive(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::IDBDatabase::DidBecomeInactive");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBDatabase::kDidBecomeInactive), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBDatabase_DidBecomeInactive_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("DidBecomeInactive");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void IDBDatabaseProxy::UpdatePriority(
    int32_t in_new_priority) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::IDBDatabase::UpdatePriority", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_priority"), in_new_priority,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBDatabase::kUpdatePriority), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBDatabase_UpdatePriority_Params_Data> params(
          message);
  params.Allocate();

  params->new_priority = in_new_priority;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("UpdatePriority");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class IDBDatabase_Get_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static IDBDatabase::GetCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<IDBDatabase_Get_ProxyToResponder> proxy(
        new IDBDatabase_Get_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&IDBDatabase_Get_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IDBDatabase_Get_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  IDBDatabase_Get_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "IDBDatabase::GetCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      IDBDatabaseGetResultPtr in_result);
};

bool IDBDatabase_Get_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::IDBDatabase_Get_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IDBDatabase_Get_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for IDBDatabase.3
  bool success = true;
  IDBDatabaseGetResultPtr p_result{};
  IDBDatabase_Get_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IDBDatabase::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void IDBDatabase_Get_ProxyToResponder::Run(
    IDBDatabaseGetResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::IDBDatabase::Get", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type IDBDatabaseGetResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBDatabase::kGet), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBDatabase_Get_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::blink::mojom::IDBDatabaseGetResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("Get");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IDBDatabase_GetAll_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static IDBDatabase::GetAllCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<IDBDatabase_GetAll_ProxyToResponder> proxy(
        new IDBDatabase_GetAll_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&IDBDatabase_GetAll_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IDBDatabase_GetAll_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  IDBDatabase_GetAll_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "IDBDatabase::GetAllCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingAssociatedReceiver<IDBDatabaseGetAllResultSink> in_receiver);
};

bool IDBDatabase_GetAll_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::IDBDatabase_GetAll_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IDBDatabase_GetAll_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for IDBDatabase.4
  bool success = true;
  ::mojo::PendingAssociatedReceiver<IDBDatabaseGetAllResultSink> p_receiver{};
  IDBDatabase_GetAll_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_receiver =
        input_data_view.TakeReceiver<decltype(p_receiver)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IDBDatabase::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_receiver));
  }
  return true;
}

void IDBDatabase_GetAll_ProxyToResponder::Run(
    ::mojo::PendingAssociatedReceiver<IDBDatabaseGetAllResultSink> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::IDBDatabase::GetAll", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingAssociatedReceiver<IDBDatabaseGetAllResultSink>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBDatabase::kGetAll), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBDatabase_GetAll_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::IDBDatabaseGetAllResultSinkAssociatedRequestDataView>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid receiver in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("GetAll");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IDBDatabase_OpenCursor_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static IDBDatabase::OpenCursorCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<IDBDatabase_OpenCursor_ProxyToResponder> proxy(
        new IDBDatabase_OpenCursor_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&IDBDatabase_OpenCursor_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IDBDatabase_OpenCursor_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  IDBDatabase_OpenCursor_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "IDBDatabase::OpenCursorCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      IDBDatabaseOpenCursorResultPtr in_result);
};

bool IDBDatabase_OpenCursor_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::IDBDatabase_OpenCursor_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IDBDatabase_OpenCursor_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for IDBDatabase.5
  bool success = true;
  IDBDatabaseOpenCursorResultPtr p_result{};
  IDBDatabase_OpenCursor_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IDBDatabase::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void IDBDatabase_OpenCursor_ProxyToResponder::Run(
    IDBDatabaseOpenCursorResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::IDBDatabase::OpenCursor", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type IDBDatabaseOpenCursorResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBDatabase::kOpenCursor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBDatabase_OpenCursor_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::blink::mojom::IDBDatabaseOpenCursorResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("OpenCursor");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IDBDatabase_Count_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static IDBDatabase::CountCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<IDBDatabase_Count_ProxyToResponder> proxy(
        new IDBDatabase_Count_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&IDBDatabase_Count_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IDBDatabase_Count_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  IDBDatabase_Count_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "IDBDatabase::CountCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, uint32_t in_count);
};

bool IDBDatabase_Count_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::IDBDatabase_Count_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IDBDatabase_Count_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for IDBDatabase.6
  bool success = true;
  bool p_success{};
  uint32_t p_count{};
  IDBDatabase_Count_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success)
    p_count = input_data_view.count();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IDBDatabase::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_count));
  }
  return true;
}

void IDBDatabase_Count_ProxyToResponder::Run(
    bool in_success, uint32_t in_count) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::IDBDatabase::Count", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("count"), in_count,
                        "<value of type uint32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBDatabase::kCount), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBDatabase_Count_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

  params->count = in_count;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("Count");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IDBDatabase_DeleteRange_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static IDBDatabase::DeleteRangeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<IDBDatabase_DeleteRange_ProxyToResponder> proxy(
        new IDBDatabase_DeleteRange_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&IDBDatabase_DeleteRange_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IDBDatabase_DeleteRange_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  IDBDatabase_DeleteRange_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "IDBDatabase::DeleteRangeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool IDBDatabase_DeleteRange_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::IDBDatabase_DeleteRange_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IDBDatabase_DeleteRange_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for IDBDatabase.7
  bool success = true;
  bool p_success{};
  IDBDatabase_DeleteRange_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IDBDatabase::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void IDBDatabase_DeleteRange_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::IDBDatabase::DeleteRange", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBDatabase::kDeleteRange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBDatabase_DeleteRange_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("DeleteRange");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IDBDatabase_GetKeyGeneratorCurrentNumber_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static IDBDatabase::GetKeyGeneratorCurrentNumberCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<IDBDatabase_GetKeyGeneratorCurrentNumber_ProxyToResponder> proxy(
        new IDBDatabase_GetKeyGeneratorCurrentNumber_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&IDBDatabase_GetKeyGeneratorCurrentNumber_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IDBDatabase_GetKeyGeneratorCurrentNumber_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  IDBDatabase_GetKeyGeneratorCurrentNumber_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "IDBDatabase::GetKeyGeneratorCurrentNumberCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int64_t in_result, IDBErrorPtr in_error);
};

bool IDBDatabase_GetKeyGeneratorCurrentNumber_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for IDBDatabase.8
  bool success = true;
  int64_t p_result{};
  IDBErrorPtr p_error{};
  IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IDBDatabase::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_error));
  }
  return true;
}

void IDBDatabase_GetKeyGeneratorCurrentNumber_ProxyToResponder::Run(
    int64_t in_result, IDBErrorPtr in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::IDBDatabase::GetKeyGeneratorCurrentNumber", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type IDBErrorPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBDatabase::kGetKeyGeneratorCurrentNumber), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::IDBErrorDataView>(
    in_error,
    error_fragment);

  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("GetKeyGeneratorCurrentNumber");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IDBDatabase_Clear_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static IDBDatabase::ClearCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<IDBDatabase_Clear_ProxyToResponder> proxy(
        new IDBDatabase_Clear_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&IDBDatabase_Clear_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IDBDatabase_Clear_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  IDBDatabase_Clear_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "IDBDatabase::ClearCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool IDBDatabase_Clear_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::IDBDatabase_Clear_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IDBDatabase_Clear_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for IDBDatabase.9
  bool success = true;
  bool p_success{};
  IDBDatabase_Clear_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IDBDatabase::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void IDBDatabase_Clear_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::IDBDatabase::Clear", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBDatabase::kClear), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBDatabase_Clear_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBDatabase::Name_);
  message.set_method_name("Clear");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool IDBDatabaseStubDispatch::Accept(
    IDBDatabase* impl,
    mojo::Message* message) {
  switch (static_cast<messages::IDBDatabase>(message->header()->name)) {
    case messages::IDBDatabase::kRenameObjectStore: {
      DCHECK(message->is_serialized());
      internal::IDBDatabase_RenameObjectStore_Params_Data* params =
          reinterpret_cast<internal::IDBDatabase_RenameObjectStore_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IDBDatabase.0
      bool success = true;
      int64_t p_transaction_id{};
      int64_t p_object_store_id{};
      ::blink::String p_new_name{};
      IDBDatabase_RenameObjectStore_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_transaction_id = input_data_view.transaction_id();
      if (success)
        p_object_store_id = input_data_view.object_store_id();
      if (success && !input_data_view.ReadNewName(&p_new_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabase::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RenameObjectStore(        
        std::move(p_transaction_id), 
        std::move(p_object_store_id), 
        std::move(p_new_name));
      return true;
    }
    case messages::IDBDatabase::kCreateTransaction: {
      DCHECK(message->is_serialized());
      internal::IDBDatabase_CreateTransaction_Params_Data* params =
          reinterpret_cast<internal::IDBDatabase_CreateTransaction_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IDBDatabase.1
      bool success = true;
      ::mojo::PendingAssociatedReceiver<IDBTransaction> p_transaction_receiver{};
      int64_t p_transaction_id{};
      ::blink::Vector<int64_t> p_object_store_ids{};
      IDBTransactionMode p_mode{};
      IDBTransactionDurability p_durability{};
      IDBDatabase_CreateTransaction_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_transaction_receiver =
            input_data_view.TakeTransactionReceiver<decltype(p_transaction_receiver)>();
      }
      if (success)
        p_transaction_id = input_data_view.transaction_id();
      if (success && !input_data_view.ReadObjectStoreIds(&p_object_store_ids))
        success = false;
      if (success && !input_data_view.ReadMode(&p_mode))
        success = false;
      if (success && !input_data_view.ReadDurability(&p_durability))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabase::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateTransaction(        
        std::move(p_transaction_receiver), 
        std::move(p_transaction_id), 
        std::move(p_object_store_ids), 
        std::move(p_mode), 
        std::move(p_durability));
      return true;
    }
    case messages::IDBDatabase::kVersionChangeIgnored: {
      DCHECK(message->is_serialized());
      internal::IDBDatabase_VersionChangeIgnored_Params_Data* params =
          reinterpret_cast<internal::IDBDatabase_VersionChangeIgnored_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IDBDatabase.2
      bool success = true;
      IDBDatabase_VersionChangeIgnored_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabase::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->VersionChangeIgnored(        );
      return true;
    }
    case messages::IDBDatabase::kGet: {
      break;
    }
    case messages::IDBDatabase::kGetAll: {
      break;
    }
    case messages::IDBDatabase::kOpenCursor: {
      break;
    }
    case messages::IDBDatabase::kCount: {
      break;
    }
    case messages::IDBDatabase::kDeleteRange: {
      break;
    }
    case messages::IDBDatabase::kGetKeyGeneratorCurrentNumber: {
      break;
    }
    case messages::IDBDatabase::kClear: {
      break;
    }
    case messages::IDBDatabase::kCreateIndex: {
      DCHECK(message->is_serialized());
      internal::IDBDatabase_CreateIndex_Params_Data* params =
          reinterpret_cast<internal::IDBDatabase_CreateIndex_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IDBDatabase.10
      bool success = true;
      int64_t p_transaction_id{};
      int64_t p_object_store_id{};
      ::scoped_refptr<::blink::IDBIndexMetadata> p_index{};
      IDBDatabase_CreateIndex_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_transaction_id = input_data_view.transaction_id();
      if (success)
        p_object_store_id = input_data_view.object_store_id();
      if (success && !input_data_view.ReadIndex(&p_index))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabase::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateIndex(        
        std::move(p_transaction_id), 
        std::move(p_object_store_id), 
        std::move(p_index));
      return true;
    }
    case messages::IDBDatabase::kDeleteIndex: {
      DCHECK(message->is_serialized());
      internal::IDBDatabase_DeleteIndex_Params_Data* params =
          reinterpret_cast<internal::IDBDatabase_DeleteIndex_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IDBDatabase.11
      bool success = true;
      int64_t p_transaction_id{};
      int64_t p_object_store_id{};
      int64_t p_index_id{};
      IDBDatabase_DeleteIndex_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_transaction_id = input_data_view.transaction_id();
      if (success)
        p_object_store_id = input_data_view.object_store_id();
      if (success)
        p_index_id = input_data_view.index_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabase::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteIndex(        
        std::move(p_transaction_id), 
        std::move(p_object_store_id), 
        std::move(p_index_id));
      return true;
    }
    case messages::IDBDatabase::kRenameIndex: {
      DCHECK(message->is_serialized());
      internal::IDBDatabase_RenameIndex_Params_Data* params =
          reinterpret_cast<internal::IDBDatabase_RenameIndex_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IDBDatabase.12
      bool success = true;
      int64_t p_transaction_id{};
      int64_t p_object_store_id{};
      int64_t p_index_id{};
      ::blink::String p_new_name{};
      IDBDatabase_RenameIndex_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_transaction_id = input_data_view.transaction_id();
      if (success)
        p_object_store_id = input_data_view.object_store_id();
      if (success)
        p_index_id = input_data_view.index_id();
      if (success && !input_data_view.ReadNewName(&p_new_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabase::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RenameIndex(        
        std::move(p_transaction_id), 
        std::move(p_object_store_id), 
        std::move(p_index_id), 
        std::move(p_new_name));
      return true;
    }
    case messages::IDBDatabase::kAbort: {
      DCHECK(message->is_serialized());
      internal::IDBDatabase_Abort_Params_Data* params =
          reinterpret_cast<internal::IDBDatabase_Abort_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IDBDatabase.13
      bool success = true;
      int64_t p_transaction_id{};
      IDBDatabase_Abort_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_transaction_id = input_data_view.transaction_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabase::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Abort(        
        std::move(p_transaction_id));
      return true;
    }
    case messages::IDBDatabase::kDidBecomeInactive: {
      DCHECK(message->is_serialized());
      internal::IDBDatabase_DidBecomeInactive_Params_Data* params =
          reinterpret_cast<internal::IDBDatabase_DidBecomeInactive_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IDBDatabase.14
      bool success = true;
      IDBDatabase_DidBecomeInactive_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabase::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidBecomeInactive(        );
      return true;
    }
    case messages::IDBDatabase::kUpdatePriority: {
      DCHECK(message->is_serialized());
      internal::IDBDatabase_UpdatePriority_Params_Data* params =
          reinterpret_cast<internal::IDBDatabase_UpdatePriority_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IDBDatabase.15
      bool success = true;
      int32_t p_new_priority{};
      IDBDatabase_UpdatePriority_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_new_priority = input_data_view.new_priority();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabase::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdatePriority(        
        std::move(p_new_priority));
      return true;
    }
  }
  return false;
}

// static
bool IDBDatabaseStubDispatch::AcceptWithResponder(
    IDBDatabase* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::IDBDatabase>(message->header()->name)) {
    case messages::IDBDatabase::kRenameObjectStore: {
      break;
    }
    case messages::IDBDatabase::kCreateTransaction: {
      break;
    }
    case messages::IDBDatabase::kVersionChangeIgnored: {
      break;
    }
    case messages::IDBDatabase::kGet: {
      internal::IDBDatabase_Get_Params_Data* params =
          reinterpret_cast<
              internal::IDBDatabase_Get_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for IDBDatabase.3
      bool success = true;
      int64_t p_transaction_id{};
      int64_t p_object_store_id{};
      int64_t p_index_id{};
      IDBKeyRangePtr p_key_range{};
      bool p_key_only{};
      IDBDatabase_Get_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_transaction_id = input_data_view.transaction_id();
      if (success)
        p_object_store_id = input_data_view.object_store_id();
      if (success)
        p_index_id = input_data_view.index_id();
      if (success && !input_data_view.ReadKeyRange(&p_key_range))
        success = false;
      if (success)
        p_key_only = input_data_view.key_only();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabase::Name_, 3, false);
        return false;
      }
      auto callback =
          IDBDatabase_Get_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Get(        
        std::move(p_transaction_id), 
        std::move(p_object_store_id), 
        std::move(p_index_id), 
        std::move(p_key_range), 
        std::move(p_key_only), std::move(callback));
      return true;
    }
    case messages::IDBDatabase::kGetAll: {
      internal::IDBDatabase_GetAll_Params_Data* params =
          reinterpret_cast<
              internal::IDBDatabase_GetAll_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for IDBDatabase.4
      bool success = true;
      int64_t p_transaction_id{};
      int64_t p_object_store_id{};
      int64_t p_index_id{};
      IDBKeyRangePtr p_key_range{};
      IDBGetAllResultType p_result_type{};
      int64_t p_max_count{};
      IDBCursorDirection p_direction{};
      IDBDatabase_GetAll_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_transaction_id = input_data_view.transaction_id();
      if (success)
        p_object_store_id = input_data_view.object_store_id();
      if (success)
        p_index_id = input_data_view.index_id();
      if (success && !input_data_view.ReadKeyRange(&p_key_range))
        success = false;
      if (success && !input_data_view.ReadResultType(&p_result_type))
        success = false;
      if (success)
        p_max_count = input_data_view.max_count();
      if (success && !input_data_view.ReadDirection(&p_direction))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabase::Name_, 4, false);
        return false;
      }
      auto callback =
          IDBDatabase_GetAll_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAll(        
        std::move(p_transaction_id), 
        std::move(p_object_store_id), 
        std::move(p_index_id), 
        std::move(p_key_range), 
        std::move(p_result_type), 
        std::move(p_max_count), 
        std::move(p_direction), std::move(callback));
      return true;
    }
    case messages::IDBDatabase::kOpenCursor: {
      internal::IDBDatabase_OpenCursor_Params_Data* params =
          reinterpret_cast<
              internal::IDBDatabase_OpenCursor_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for IDBDatabase.5
      bool success = true;
      int64_t p_transaction_id{};
      int64_t p_object_store_id{};
      int64_t p_index_id{};
      IDBKeyRangePtr p_key_range{};
      IDBCursorDirection p_direction{};
      bool p_key_only{};
      IDBTaskType p_task_type{};
      IDBDatabase_OpenCursor_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_transaction_id = input_data_view.transaction_id();
      if (success)
        p_object_store_id = input_data_view.object_store_id();
      if (success)
        p_index_id = input_data_view.index_id();
      if (success && !input_data_view.ReadKeyRange(&p_key_range))
        success = false;
      if (success && !input_data_view.ReadDirection(&p_direction))
        success = false;
      if (success)
        p_key_only = input_data_view.key_only();
      if (success && !input_data_view.ReadTaskType(&p_task_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabase::Name_, 5, false);
        return false;
      }
      auto callback =
          IDBDatabase_OpenCursor_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenCursor(        
        std::move(p_transaction_id), 
        std::move(p_object_store_id), 
        std::move(p_index_id), 
        std::move(p_key_range), 
        std::move(p_direction), 
        std::move(p_key_only), 
        std::move(p_task_type), std::move(callback));
      return true;
    }
    case messages::IDBDatabase::kCount: {
      internal::IDBDatabase_Count_Params_Data* params =
          reinterpret_cast<
              internal::IDBDatabase_Count_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for IDBDatabase.6
      bool success = true;
      int64_t p_transaction_id{};
      int64_t p_object_store_id{};
      int64_t p_index_id{};
      IDBKeyRangePtr p_key_range{};
      IDBDatabase_Count_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_transaction_id = input_data_view.transaction_id();
      if (success)
        p_object_store_id = input_data_view.object_store_id();
      if (success)
        p_index_id = input_data_view.index_id();
      if (success && !input_data_view.ReadKeyRange(&p_key_range))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabase::Name_, 6, false);
        return false;
      }
      auto callback =
          IDBDatabase_Count_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Count(        
        std::move(p_transaction_id), 
        std::move(p_object_store_id), 
        std::move(p_index_id), 
        std::move(p_key_range), std::move(callback));
      return true;
    }
    case messages::IDBDatabase::kDeleteRange: {
      internal::IDBDatabase_DeleteRange_Params_Data* params =
          reinterpret_cast<
              internal::IDBDatabase_DeleteRange_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for IDBDatabase.7
      bool success = true;
      int64_t p_transaction_id{};
      int64_t p_object_store_id{};
      IDBKeyRangePtr p_key_range{};
      IDBDatabase_DeleteRange_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_transaction_id = input_data_view.transaction_id();
      if (success)
        p_object_store_id = input_data_view.object_store_id();
      if (success && !input_data_view.ReadKeyRange(&p_key_range))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabase::Name_, 7, false);
        return false;
      }
      auto callback =
          IDBDatabase_DeleteRange_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteRange(        
        std::move(p_transaction_id), 
        std::move(p_object_store_id), 
        std::move(p_key_range), std::move(callback));
      return true;
    }
    case messages::IDBDatabase::kGetKeyGeneratorCurrentNumber: {
      internal::IDBDatabase_GetKeyGeneratorCurrentNumber_Params_Data* params =
          reinterpret_cast<
              internal::IDBDatabase_GetKeyGeneratorCurrentNumber_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for IDBDatabase.8
      bool success = true;
      int64_t p_transaction_id{};
      int64_t p_object_store_id{};
      IDBDatabase_GetKeyGeneratorCurrentNumber_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_transaction_id = input_data_view.transaction_id();
      if (success)
        p_object_store_id = input_data_view.object_store_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabase::Name_, 8, false);
        return false;
      }
      auto callback =
          IDBDatabase_GetKeyGeneratorCurrentNumber_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetKeyGeneratorCurrentNumber(        
        std::move(p_transaction_id), 
        std::move(p_object_store_id), std::move(callback));
      return true;
    }
    case messages::IDBDatabase::kClear: {
      internal::IDBDatabase_Clear_Params_Data* params =
          reinterpret_cast<
              internal::IDBDatabase_Clear_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for IDBDatabase.9
      bool success = true;
      int64_t p_transaction_id{};
      int64_t p_object_store_id{};
      IDBDatabase_Clear_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_transaction_id = input_data_view.transaction_id();
      if (success)
        p_object_store_id = input_data_view.object_store_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBDatabase::Name_, 9, false);
        return false;
      }
      auto callback =
          IDBDatabase_Clear_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clear(        
        std::move(p_transaction_id), 
        std::move(p_object_store_id), std::move(callback));
      return true;
    }
    case messages::IDBDatabase::kCreateIndex: {
      break;
    }
    case messages::IDBDatabase::kDeleteIndex: {
      break;
    }
    case messages::IDBDatabase::kRenameIndex: {
      break;
    }
    case messages::IDBDatabase::kAbort: {
      break;
    }
    case messages::IDBDatabase::kDidBecomeInactive: {
      break;
    }
    case messages::IDBDatabase::kUpdatePriority: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kIDBDatabaseValidationInfo[] = {
    { &internal::IDBDatabase_RenameObjectStore_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::IDBDatabase_CreateTransaction_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::IDBDatabase_VersionChangeIgnored_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::IDBDatabase_Get_Params_Data::Validate,
     &internal::IDBDatabase_Get_ResponseParams_Data::Validate},
    { &internal::IDBDatabase_GetAll_Params_Data::Validate,
     &internal::IDBDatabase_GetAll_ResponseParams_Data::Validate},
    { &internal::IDBDatabase_OpenCursor_Params_Data::Validate,
     &internal::IDBDatabase_OpenCursor_ResponseParams_Data::Validate},
    { &internal::IDBDatabase_Count_Params_Data::Validate,
     &internal::IDBDatabase_Count_ResponseParams_Data::Validate},
    { &internal::IDBDatabase_DeleteRange_Params_Data::Validate,
     &internal::IDBDatabase_DeleteRange_ResponseParams_Data::Validate},
    { &internal::IDBDatabase_GetKeyGeneratorCurrentNumber_Params_Data::Validate,
     &internal::IDBDatabase_GetKeyGeneratorCurrentNumber_ResponseParams_Data::Validate},
    { &internal::IDBDatabase_Clear_Params_Data::Validate,
     &internal::IDBDatabase_Clear_ResponseParams_Data::Validate},
    { &internal::IDBDatabase_CreateIndex_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::IDBDatabase_DeleteIndex_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::IDBDatabase_RenameIndex_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::IDBDatabase_Abort_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::IDBDatabase_DidBecomeInactive_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::IDBDatabase_UpdatePriority_Params_Data::Validate,
     nullptr /* no response */},
};

bool IDBDatabaseRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::IDBDatabase::Name_,
    kIDBDatabaseValidationInfo);
}

bool IDBDatabaseResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::IDBDatabase::Name_,
    kIDBDatabaseValidationInfo);
}
// The declaration includes the definition on other builds.

IDBFactory::IPCStableHashFunction IDBFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::IDBFactory>(message.name())) {
    case messages::IDBFactory::kGetDatabaseInfo: {
      return &IDBFactory::GetDatabaseInfo_Sym::IPCStableHash;
    }
    case messages::IDBFactory::kOpen: {
      return &IDBFactory::Open_Sym::IPCStableHash;
    }
    case messages::IDBFactory::kDeleteDatabase: {
      return &IDBFactory::DeleteDatabase_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* IDBFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::IDBFactory>(message.name())) {
      case messages::IDBFactory::kGetDatabaseInfo:
            return "Receive blink::mojom::IDBFactory::GetDatabaseInfo";
      case messages::IDBFactory::kOpen:
            return "Receive blink::mojom::IDBFactory::Open";
      case messages::IDBFactory::kDeleteDatabase:
            return "Receive blink::mojom::IDBFactory::DeleteDatabase";
    }
  } else {
    switch (static_cast<messages::IDBFactory>(message.name())) {
      case messages::IDBFactory::kGetDatabaseInfo:
            return "Receive reply blink::mojom::IDBFactory::GetDatabaseInfo";
      case messages::IDBFactory::kOpen:
            return "Receive reply blink::mojom::IDBFactory::Open";
      case messages::IDBFactory::kDeleteDatabase:
            return "Receive reply blink::mojom::IDBFactory::DeleteDatabase";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t IDBFactory::GetDatabaseInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf50b50c7;  // IPCStableHash for blink::mojom::IDBFactory::GetDatabaseInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IDBFactory::Open_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x52afa8e7;  // IPCStableHash for blink::mojom::IDBFactory::Open
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IDBFactory::DeleteDatabase_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc447a90a;  // IPCStableHash for blink::mojom::IDBFactory::DeleteDatabase
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class IDBFactory_GetDatabaseInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IDBFactory_GetDatabaseInfo_ForwardToCallback(
      IDBFactory::GetDatabaseInfoCallback callback
      ) : callback_(std::move(callback)) {
  }

  IDBFactory_GetDatabaseInfo_ForwardToCallback(const IDBFactory_GetDatabaseInfo_ForwardToCallback&) = delete;
  IDBFactory_GetDatabaseInfo_ForwardToCallback& operator=(const IDBFactory_GetDatabaseInfo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  IDBFactory::GetDatabaseInfoCallback callback_;
};

IDBFactoryProxy::IDBFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void IDBFactoryProxy::GetDatabaseInfo(
    GetDatabaseInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::IDBFactory::GetDatabaseInfo");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBFactory::kGetDatabaseInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBFactory_GetDatabaseInfo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBFactory::Name_);
  message.set_method_name("GetDatabaseInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IDBFactory_GetDatabaseInfo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void IDBFactoryProxy::Open(
    ::mojo::PendingAssociatedRemote<IDBFactoryClient> in_client, ::mojo::PendingAssociatedRemote<IDBDatabaseCallbacks> in_database_callbacks, const ::blink::String& in_name, int64_t in_version, ::mojo::PendingAssociatedReceiver<IDBTransaction> in_version_change_transaction_receiver, int64_t in_transaction_id, int32_t in_priority) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::IDBFactory::Open", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<IDBFactoryClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("database_callbacks"), in_database_callbacks,
                        "<value of type ::mojo::PendingAssociatedRemote<IDBDatabaseCallbacks>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("version"), in_version,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("version_change_transaction_receiver"), in_version_change_transaction_receiver,
                        "<value of type ::mojo::PendingAssociatedReceiver<IDBTransaction>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("transaction_id"), in_transaction_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("priority"), in_priority,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBFactory::kOpen), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBFactory_Open_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::IDBFactoryClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in IDBFactory.Open request");

  
  mojo::internal::Serialize<::blink::mojom::IDBDatabaseCallbacksAssociatedPtrInfoDataView>(
    in_database_callbacks,
    &params->database_callbacks,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->database_callbacks)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid database_callbacks in IDBFactory.Open request");
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in IDBFactory.Open request");

  params->version = in_version;

  
  mojo::internal::Serialize<::blink::mojom::IDBTransactionAssociatedRequestDataView>(
    in_version_change_transaction_receiver,
    &params->version_change_transaction_receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->version_change_transaction_receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid version_change_transaction_receiver in IDBFactory.Open request");

  params->transaction_id = in_transaction_id;

  params->priority = in_priority;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBFactory::Name_);
  message.set_method_name("Open");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void IDBFactoryProxy::DeleteDatabase(
    ::mojo::PendingAssociatedRemote<IDBFactoryClient> in_client, const ::blink::String& in_name, bool in_force_close) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::IDBFactory::DeleteDatabase", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<IDBFactoryClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("force_close"), in_force_close,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBFactory::kDeleteDatabase), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBFactory_DeleteDatabase_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::IDBFactoryClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in IDBFactory.DeleteDatabase request");
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in IDBFactory.DeleteDatabase request");

  params->force_close = in_force_close;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBFactory::Name_);
  message.set_method_name("DeleteDatabase");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class IDBFactory_GetDatabaseInfo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static IDBFactory::GetDatabaseInfoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<IDBFactory_GetDatabaseInfo_ProxyToResponder> proxy(
        new IDBFactory_GetDatabaseInfo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&IDBFactory_GetDatabaseInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IDBFactory_GetDatabaseInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  IDBFactory_GetDatabaseInfo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "IDBFactory::GetDatabaseInfoCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::Vector<IDBNameAndVersionPtr> in_names_and_versions, IDBErrorPtr in_error);
};

bool IDBFactory_GetDatabaseInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::IDBFactory_GetDatabaseInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IDBFactory_GetDatabaseInfo_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for IDBFactory.0
  bool success = true;
  ::blink::Vector<IDBNameAndVersionPtr> p_names_and_versions{};
  IDBErrorPtr p_error{};
  IDBFactory_GetDatabaseInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadNamesAndVersions(&p_names_and_versions))
    success = false;
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IDBFactory::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_names_and_versions), 
std::move(p_error));
  }
  return true;
}

void IDBFactory_GetDatabaseInfo_ProxyToResponder::Run(
    ::blink::Vector<IDBNameAndVersionPtr> in_names_and_versions, IDBErrorPtr in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::IDBFactory::GetDatabaseInfo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("names_and_versions"), in_names_and_versions,
                        "<value of type ::blink::Vector<IDBNameAndVersionPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type IDBErrorPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IDBFactory::kGetDatabaseInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::IDBFactory_GetDatabaseInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->names_and_versions)::BaseType>
      names_and_versions_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& names_and_versions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::IDBNameAndVersionDataView>>(
    in_names_and_versions,
    names_and_versions_fragment,
    &names_and_versions_validate_params);

  params->names_and_versions.Set(
      names_and_versions_fragment.is_null() ? nullptr : names_and_versions_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->names_and_versions.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null names_and_versions in ");
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::IDBErrorDataView>(
    in_error,
    error_fragment);

  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->error.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null error in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IDBFactory::Name_);
  message.set_method_name("GetDatabaseInfo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool IDBFactoryStubDispatch::Accept(
    IDBFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::IDBFactory>(message->header()->name)) {
    case messages::IDBFactory::kGetDatabaseInfo: {
      break;
    }
    case messages::IDBFactory::kOpen: {
      DCHECK(message->is_serialized());
      internal::IDBFactory_Open_Params_Data* params =
          reinterpret_cast<internal::IDBFactory_Open_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IDBFactory.1
      bool success = true;
      ::mojo::PendingAssociatedRemote<IDBFactoryClient> p_client{};
      ::mojo::PendingAssociatedRemote<IDBDatabaseCallbacks> p_database_callbacks{};
      ::blink::String p_name{};
      int64_t p_version{};
      ::mojo::PendingAssociatedReceiver<IDBTransaction> p_version_change_transaction_receiver{};
      int64_t p_transaction_id{};
      int32_t p_priority{};
      IDBFactory_Open_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success) {
        p_database_callbacks =
            input_data_view.TakeDatabaseCallbacks<decltype(p_database_callbacks)>();
      }
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success)
        p_version = input_data_view.version();
      if (success) {
        p_version_change_transaction_receiver =
            input_data_view.TakeVersionChangeTransactionReceiver<decltype(p_version_change_transaction_receiver)>();
      }
      if (success)
        p_transaction_id = input_data_view.transaction_id();
      if (success)
        p_priority = input_data_view.priority();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBFactory::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Open(        
        std::move(p_client), 
        std::move(p_database_callbacks), 
        std::move(p_name), 
        std::move(p_version), 
        std::move(p_version_change_transaction_receiver), 
        std::move(p_transaction_id), 
        std::move(p_priority));
      return true;
    }
    case messages::IDBFactory::kDeleteDatabase: {
      DCHECK(message->is_serialized());
      internal::IDBFactory_DeleteDatabase_Params_Data* params =
          reinterpret_cast<internal::IDBFactory_DeleteDatabase_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IDBFactory.2
      bool success = true;
      ::mojo::PendingAssociatedRemote<IDBFactoryClient> p_client{};
      ::blink::String p_name{};
      bool p_force_close{};
      IDBFactory_DeleteDatabase_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success)
        p_force_close = input_data_view.force_close();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBFactory::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteDatabase(        
        std::move(p_client), 
        std::move(p_name), 
        std::move(p_force_close));
      return true;
    }
  }
  return false;
}

// static
bool IDBFactoryStubDispatch::AcceptWithResponder(
    IDBFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::IDBFactory>(message->header()->name)) {
    case messages::IDBFactory::kGetDatabaseInfo: {
      internal::IDBFactory_GetDatabaseInfo_Params_Data* params =
          reinterpret_cast<
              internal::IDBFactory_GetDatabaseInfo_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for IDBFactory.0
      bool success = true;
      IDBFactory_GetDatabaseInfo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IDBFactory::Name_, 0, false);
        return false;
      }
      auto callback =
          IDBFactory_GetDatabaseInfo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDatabaseInfo(std::move(callback));
      return true;
    }
    case messages::IDBFactory::kOpen: {
      break;
    }
    case messages::IDBFactory::kDeleteDatabase: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kIDBFactoryValidationInfo[] = {
    { &internal::IDBFactory_GetDatabaseInfo_Params_Data::Validate,
     &internal::IDBFactory_GetDatabaseInfo_ResponseParams_Data::Validate},
    { &internal::IDBFactory_Open_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::IDBFactory_DeleteDatabase_Params_Data::Validate,
     nullptr /* no response */},
};

bool IDBFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::IDBFactory::Name_,
    kIDBFactoryValidationInfo);
}

bool IDBFactoryResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::IDBFactory::Name_,
    kIDBFactoryValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::IDBKeyPath::DataView, ::blink::mojom::blink::IDBKeyPathPtr>::Read(
    ::blink::mojom::blink::IDBKeyPath::DataView input,
    ::blink::mojom::blink::IDBKeyPathPtr* output) {
  bool success = true;
  ::blink::mojom::blink::IDBKeyPathPtr result(::blink::mojom::blink::IDBKeyPath::New());
  
      if (success && !input.ReadData(&result->data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::IDBKeyRange::DataView, ::blink::mojom::blink::IDBKeyRangePtr>::Read(
    ::blink::mojom::blink::IDBKeyRange::DataView input,
    ::blink::mojom::blink::IDBKeyRangePtr* output) {
  bool success = true;
  ::blink::mojom::blink::IDBKeyRangePtr result(::blink::mojom::blink::IDBKeyRange::New());
  
      if (success && !input.ReadLower(&result->lower))
        success = false;
      if (success && !input.ReadUpper(&result->upper))
        success = false;
      if (success)
        result->lower_open = input.lower_open();
      if (success)
        result->upper_open = input.upper_open();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::IDBIndexMetadata::DataView, ::blink::mojom::blink::IDBIndexMetadataPtr>::Read(
    ::blink::mojom::blink::IDBIndexMetadata::DataView input,
    ::blink::mojom::blink::IDBIndexMetadataPtr* output) {
  bool success = true;
  ::blink::mojom::blink::IDBIndexMetadataPtr result(::blink::mojom::blink::IDBIndexMetadata::New());
  
      if (success)
        result->id = input.id();
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadKeyPath(&result->key_path))
        success = false;
      if (success)
        result->unique = input.unique();
      if (success)
        result->multi_entry = input.multi_entry();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::IDBObjectStoreMetadata::DataView, ::blink::mojom::blink::IDBObjectStoreMetadataPtr>::Read(
    ::blink::mojom::blink::IDBObjectStoreMetadata::DataView input,
    ::blink::mojom::blink::IDBObjectStoreMetadataPtr* output) {
  bool success = true;
  ::blink::mojom::blink::IDBObjectStoreMetadataPtr result(::blink::mojom::blink::IDBObjectStoreMetadata::New());
  
      if (success)
        result->id = input.id();
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadKeyPath(&result->key_path))
        success = false;
      if (success)
        result->auto_increment = input.auto_increment();
      if (success)
        result->max_index_id = input.max_index_id();
      if (success && !input.ReadIndexes(&result->indexes))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::IDBDatabaseMetadata::DataView, ::blink::mojom::blink::IDBDatabaseMetadataPtr>::Read(
    ::blink::mojom::blink::IDBDatabaseMetadata::DataView input,
    ::blink::mojom::blink::IDBDatabaseMetadataPtr* output) {
  bool success = true;
  ::blink::mojom::blink::IDBDatabaseMetadataPtr result(::blink::mojom::blink::IDBDatabaseMetadata::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success)
        result->version = input.version();
      if (success)
        result->max_object_store_id = input.max_object_store_id();
      if (success && !input.ReadObjectStores(&result->object_stores))
        success = false;
      if (success)
        result->was_cold_open = input.was_cold_open();
      if (success)
        result->is_sqlite = input.is_sqlite();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::IDBNameAndVersion::DataView, ::blink::mojom::blink::IDBNameAndVersionPtr>::Read(
    ::blink::mojom::blink::IDBNameAndVersion::DataView input,
    ::blink::mojom::blink::IDBNameAndVersionPtr* output) {
  bool success = true;
  ::blink::mojom::blink::IDBNameAndVersionPtr result(::blink::mojom::blink::IDBNameAndVersion::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success)
        result->version = input.version();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::IDBIndexKeys::DataView, ::blink::mojom::blink::IDBIndexKeysPtr>::Read(
    ::blink::mojom::blink::IDBIndexKeys::DataView input,
    ::blink::mojom::blink::IDBIndexKeysPtr* output) {
  bool success = true;
  ::blink::mojom::blink::IDBIndexKeysPtr result(::blink::mojom::blink::IDBIndexKeys::New());
  
      if (success)
        result->index_id = input.index_id();
      if (success && !input.ReadIndexKeys(&result->index_keys))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::IDBFileInfo::DataView, ::blink::mojom::blink::IDBFileInfoPtr>::Read(
    ::blink::mojom::blink::IDBFileInfo::DataView input,
    ::blink::mojom::blink::IDBFileInfoPtr* output) {
  bool success = true;
  ::blink::mojom::blink::IDBFileInfoPtr result(::blink::mojom::blink::IDBFileInfo::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadLastModified(&result->last_modified))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::IDBBlobInfo::DataView, ::blink::mojom::blink::IDBBlobInfoPtr>::Read(
    ::blink::mojom::blink::IDBBlobInfo::DataView input,
    ::blink::mojom::blink::IDBBlobInfoPtr* output) {
  bool success = true;
  ::blink::mojom::blink::IDBBlobInfoPtr result(::blink::mojom::blink::IDBBlobInfo::New());
  
      if (success) {
        result->blob =
            input.TakeBlob<decltype(result->blob)>();
      }
      if (success && !input.ReadMimeType(&result->mime_type))
        success = false;
      if (success)
        result->size = input.size();
      if (success && !input.ReadFile(&result->file))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::IDBValue::DataView, ::blink::mojom::blink::IDBValuePtr>::Read(
    ::blink::mojom::blink::IDBValue::DataView input,
    ::blink::mojom::blink::IDBValuePtr* output) {
  bool success = true;
  ::blink::mojom::blink::IDBValuePtr result(::blink::mojom::blink::IDBValue::New());
  
      if (success && !input.ReadBits(&result->bits))
        success = false;
      if (success && !input.ReadExternalObjects(&result->external_objects))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::IDBReturnValue::DataView, ::blink::mojom::blink::IDBReturnValuePtr>::Read(
    ::blink::mojom::blink::IDBReturnValue::DataView input,
    ::blink::mojom::blink::IDBReturnValuePtr* output) {
  bool success = true;
  ::blink::mojom::blink::IDBReturnValuePtr result(::blink::mojom::blink::IDBReturnValue::New());
  
      if (success && !input.ReadValue(&result->value))
        success = false;
      if (success && !input.ReadPrimaryKey(&result->primary_key))
        success = false;
      if (success && !input.ReadKeyPath(&result->key_path))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::IDBRecord::DataView, ::blink::mojom::blink::IDBRecordPtr>::Read(
    ::blink::mojom::blink::IDBRecord::DataView input,
    ::blink::mojom::blink::IDBRecordPtr* output) {
  bool success = true;
  ::blink::mojom::blink::IDBRecordPtr result(::blink::mojom::blink::IDBRecord::New());
  
      if (success && !input.ReadPrimaryKey(&result->primary_key))
        success = false;
      if (success && !input.ReadReturnValue(&result->return_value))
        success = false;
      if (success && !input.ReadIndexKey(&result->index_key))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::IDBError::DataView, ::blink::mojom::blink::IDBErrorPtr>::Read(
    ::blink::mojom::blink::IDBError::DataView input,
    ::blink::mojom::blink::IDBErrorPtr* output) {
  bool success = true;
  ::blink::mojom::blink::IDBErrorPtr result(::blink::mojom::blink::IDBError::New());
  
      if (success && !input.ReadErrorCode(&result->error_code))
        success = false;
      if (success && !input.ReadErrorMessage(&result->error_message))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::IDBCursorValue::DataView, ::blink::mojom::blink::IDBCursorValuePtr>::Read(
    ::blink::mojom::blink::IDBCursorValue::DataView input,
    ::blink::mojom::blink::IDBCursorValuePtr* output) {
  bool success = true;
  ::blink::mojom::blink::IDBCursorValuePtr result(::blink::mojom::blink::IDBCursorValue::New());
  
      if (success && !input.ReadKeys(&result->keys))
        success = false;
      if (success && !input.ReadPrimaryKeys(&result->primary_keys))
        success = false;
      if (success && !input.ReadValues(&result->values))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::IDBDatabaseOpenCursorValue::DataView, ::blink::mojom::blink::IDBDatabaseOpenCursorValuePtr>::Read(
    ::blink::mojom::blink::IDBDatabaseOpenCursorValue::DataView input,
    ::blink::mojom::blink::IDBDatabaseOpenCursorValuePtr* output) {
  bool success = true;
  ::blink::mojom::blink::IDBDatabaseOpenCursorValuePtr result(::blink::mojom::blink::IDBDatabaseOpenCursorValue::New());
  
      if (success) {
        result->cursor =
            input.TakeCursor<decltype(result->cursor)>();
      }
      if (success && !input.ReadKey(&result->key))
        success = false;
      if (success && !input.ReadPrimaryKey(&result->primary_key))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::blink::IDBKey::DataView, ::blink::mojom::blink::IDBKeyPtr>::Read(
    ::blink::mojom::blink::IDBKey::DataView input,
    ::blink::mojom::blink::IDBKeyPtr* output) {
  using UnionType = ::blink::mojom::blink::IDBKey;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kKeyArray: {
      ::blink::Vector<::std::unique_ptr<::blink::IDBKey>> result_key_array{};
      if (!input.ReadKeyArray(&result_key_array))
        return false;

      *output = UnionType::NewKeyArray(
          std::move(result_key_array));
      break;
    }
    case Tag::kBinary: {
      ::blink::Vector<uint8_t> result_binary{};
      if (!input.ReadBinary(&result_binary))
        return false;

      *output = UnionType::NewBinary(
          std::move(result_binary));
      break;
    }
    case Tag::kString: {
      ::blink::String result_string{};
      if (!input.ReadString(&result_string))
        return false;

      *output = UnionType::NewString(
          std::move(result_string));
      break;
    }
    case Tag::kDate: {
      *output = UnionType::NewDate(input.date());
      break;
    }
    case Tag::kNumber: {
      *output = UnionType::NewNumber(input.number());
      break;
    }
    case Tag::kOtherNone: {
      *output = UnionType::NewOtherNone(input.other_none());
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::blink::mojom::blink::IDBKeyPathData::DataView, ::blink::mojom::blink::IDBKeyPathDataPtr>::Read(
    ::blink::mojom::blink::IDBKeyPathData::DataView input,
    ::blink::mojom::blink::IDBKeyPathDataPtr* output) {
  using UnionType = ::blink::mojom::blink::IDBKeyPathData;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kString: {
      ::blink::String result_string{};
      if (!input.ReadString(&result_string))
        return false;

      *output = UnionType::NewString(
          std::move(result_string));
      break;
    }
    case Tag::kStringArray: {
      ::blink::Vector<::blink::String> result_string_array{};
      if (!input.ReadStringArray(&result_string_array))
        return false;

      *output = UnionType::NewStringArray(
          std::move(result_string_array));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::blink::mojom::blink::IDBExternalObject::DataView, ::blink::mojom::blink::IDBExternalObjectPtr>::Read(
    ::blink::mojom::blink::IDBExternalObject::DataView input,
    ::blink::mojom::blink::IDBExternalObjectPtr* output) {
  using UnionType = ::blink::mojom::blink::IDBExternalObject;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kBlobOrFile: {
      ::blink::mojom::blink::IDBBlobInfoPtr result_blob_or_file{};
      if (!input.ReadBlobOrFile(&result_blob_or_file))
        return false;

      *output = UnionType::NewBlobOrFile(
          std::move(result_blob_or_file));
      break;
    }
    case Tag::kFileSystemAccessToken: {
      *output = UnionType::NewFileSystemAccessToken(
          input.TakeFileSystemAccessToken<::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessTransferToken>>());
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::blink::mojom::blink::IDBCursorResult::DataView, ::blink::mojom::blink::IDBCursorResultPtr>::Read(
    ::blink::mojom::blink::IDBCursorResult::DataView input,
    ::blink::mojom::blink::IDBCursorResultPtr* output) {
  using UnionType = ::blink::mojom::blink::IDBCursorResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kErrorResult: {
      ::blink::mojom::blink::IDBErrorPtr result_error_result{};
      if (!input.ReadErrorResult(&result_error_result))
        return false;

      *output = UnionType::NewErrorResult(
          std::move(result_error_result));
      break;
    }
    case Tag::kEmpty: {
      *output = UnionType::NewEmpty(input.empty());
      break;
    }
    case Tag::kValues: {
      ::blink::mojom::blink::IDBCursorValuePtr result_values{};
      if (!input.ReadValues(&result_values))
        return false;

      *output = UnionType::NewValues(
          std::move(result_values));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::blink::mojom::blink::IDBTransactionPutResult::DataView, ::blink::mojom::blink::IDBTransactionPutResultPtr>::Read(
    ::blink::mojom::blink::IDBTransactionPutResult::DataView input,
    ::blink::mojom::blink::IDBTransactionPutResultPtr* output) {
  using UnionType = ::blink::mojom::blink::IDBTransactionPutResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kErrorResult: {
      ::blink::mojom::blink::IDBErrorPtr result_error_result{};
      if (!input.ReadErrorResult(&result_error_result))
        return false;

      *output = UnionType::NewErrorResult(
          std::move(result_error_result));
      break;
    }
    case Tag::kKey: {
      ::std::unique_ptr<::blink::IDBKey> result_key{};
      if (!input.ReadKey(&result_key))
        return false;

      *output = UnionType::NewKey(
          std::move(result_key));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::blink::mojom::blink::IDBDatabaseGetResult::DataView, ::blink::mojom::blink::IDBDatabaseGetResultPtr>::Read(
    ::blink::mojom::blink::IDBDatabaseGetResult::DataView input,
    ::blink::mojom::blink::IDBDatabaseGetResultPtr* output) {
  using UnionType = ::blink::mojom::blink::IDBDatabaseGetResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kErrorResult: {
      ::blink::mojom::blink::IDBErrorPtr result_error_result{};
      if (!input.ReadErrorResult(&result_error_result))
        return false;

      *output = UnionType::NewErrorResult(
          std::move(result_error_result));
      break;
    }
    case Tag::kEmpty: {
      *output = UnionType::NewEmpty(input.empty());
      break;
    }
    case Tag::kKey: {
      ::std::unique_ptr<::blink::IDBKey> result_key{};
      if (!input.ReadKey(&result_key))
        return false;

      *output = UnionType::NewKey(
          std::move(result_key));
      break;
    }
    case Tag::kValue: {
      ::blink::mojom::blink::IDBReturnValuePtr result_value{};
      if (!input.ReadValue(&result_value))
        return false;

      *output = UnionType::NewValue(
          std::move(result_value));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::blink::mojom::blink::IDBDatabaseOpenCursorResult::DataView, ::blink::mojom::blink::IDBDatabaseOpenCursorResultPtr>::Read(
    ::blink::mojom::blink::IDBDatabaseOpenCursorResult::DataView input,
    ::blink::mojom::blink::IDBDatabaseOpenCursorResultPtr* output) {
  using UnionType = ::blink::mojom::blink::IDBDatabaseOpenCursorResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kErrorResult: {
      ::blink::mojom::blink::IDBErrorPtr result_error_result{};
      if (!input.ReadErrorResult(&result_error_result))
        return false;

      *output = UnionType::NewErrorResult(
          std::move(result_error_result));
      break;
    }
    case Tag::kEmpty: {
      *output = UnionType::NewEmpty(input.empty());
      break;
    }
    case Tag::kValue: {
      ::blink::mojom::blink::IDBDatabaseOpenCursorValuePtr result_value{};
      if (!input.ReadValue(&result_value))
        return false;

      *output = UnionType::NewValue(
          std::move(result_value));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void IDBFactoryClientInterceptorForTesting::Error(IDBException code, const ::blink::String& message) {
  GetForwardingInterface()->Error(
    std::move(code)
    , 
    std::move(message)
    );
}
void IDBFactoryClientInterceptorForTesting::Blocked(int64_t existing_version) {
  GetForwardingInterface()->Blocked(
    std::move(existing_version)
    );
}
void IDBFactoryClientInterceptorForTesting::UpgradeNeeded(::mojo::PendingAssociatedRemote<IDBDatabase> pending_database, int64_t old_version, IDBDataLoss data_loss, const ::blink::String& data_loss_message, const ::blink::IDBDatabaseMetadata& db_metadata) {
  GetForwardingInterface()->UpgradeNeeded(
    std::move(pending_database)
    , 
    std::move(old_version)
    , 
    std::move(data_loss)
    , 
    std::move(data_loss_message)
    , 
    std::move(db_metadata)
    );
}
void IDBFactoryClientInterceptorForTesting::OpenSuccess(::mojo::PendingAssociatedRemote<IDBDatabase> pending_database, const ::blink::IDBDatabaseMetadata& metadata) {
  GetForwardingInterface()->OpenSuccess(
    std::move(pending_database)
    , 
    std::move(metadata)
    );
}
void IDBFactoryClientInterceptorForTesting::DeleteSuccess(int64_t old_version) {
  GetForwardingInterface()->DeleteSuccess(
    std::move(old_version)
    );
}
IDBFactoryClientAsyncWaiter::IDBFactoryClientAsyncWaiter(
    IDBFactoryClient* proxy) : proxy_(proxy) {}

IDBFactoryClientAsyncWaiter::~IDBFactoryClientAsyncWaiter() = default;





void IDBDatabaseCallbacksInterceptorForTesting::ForcedClose() {
  GetForwardingInterface()->ForcedClose();
}
void IDBDatabaseCallbacksInterceptorForTesting::VersionChange(int64_t old_version, int64_t new_version) {
  GetForwardingInterface()->VersionChange(
    std::move(old_version)
    , 
    std::move(new_version)
    );
}
void IDBDatabaseCallbacksInterceptorForTesting::Abort(int64_t transaction_id, IDBException code, const ::blink::String& message) {
  GetForwardingInterface()->Abort(
    std::move(transaction_id)
    , 
    std::move(code)
    , 
    std::move(message)
    );
}
void IDBDatabaseCallbacksInterceptorForTesting::Complete(int64_t transaction_id) {
  GetForwardingInterface()->Complete(
    std::move(transaction_id)
    );
}
IDBDatabaseCallbacksAsyncWaiter::IDBDatabaseCallbacksAsyncWaiter(
    IDBDatabaseCallbacks* proxy) : proxy_(proxy) {}

IDBDatabaseCallbacksAsyncWaiter::~IDBDatabaseCallbacksAsyncWaiter() = default;





void IDBCursorInterceptorForTesting::Advance(uint32_t count, AdvanceCallback callback) {
  GetForwardingInterface()->Advance(
    std::move(count)
    , std::move(callback));
}
void IDBCursorInterceptorForTesting::Continue(::std::unique_ptr<::blink::IDBKey> key, ::std::unique_ptr<::blink::IDBKey> primary_key, ContinueCallback callback) {
  GetForwardingInterface()->Continue(
    std::move(key)
    , 
    std::move(primary_key)
    , std::move(callback));
}
void IDBCursorInterceptorForTesting::Prefetch(int32_t count, PrefetchCallback callback) {
  GetForwardingInterface()->Prefetch(
    std::move(count)
    , std::move(callback));
}
void IDBCursorInterceptorForTesting::PrefetchReset(int32_t used_prefetches) {
  GetForwardingInterface()->PrefetchReset(
    std::move(used_prefetches)
    );
}
IDBCursorAsyncWaiter::IDBCursorAsyncWaiter(
    IDBCursor* proxy) : proxy_(proxy) {}

IDBCursorAsyncWaiter::~IDBCursorAsyncWaiter() = default;


void IDBCursorAsyncWaiter::Advance(
    uint32_t count, IDBCursorResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->Advance(
      std::move(count),
      base::BindOnce(
          [](base::RunLoop* loop,
             IDBCursorResultPtr* out_result
,
             IDBCursorResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

IDBCursorResultPtr IDBCursorAsyncWaiter::Advance(
    uint32_t count) {
  IDBCursorResultPtr async_wait_result;
  Advance(std::move(count),&async_wait_result);
  return async_wait_result;
}

void IDBCursorAsyncWaiter::Continue(
    ::std::unique_ptr<::blink::IDBKey> key, ::std::unique_ptr<::blink::IDBKey> primary_key, IDBCursorResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->Continue(
      std::move(key),
      std::move(primary_key),
      base::BindOnce(
          [](base::RunLoop* loop,
             IDBCursorResultPtr* out_result
,
             IDBCursorResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

IDBCursorResultPtr IDBCursorAsyncWaiter::Continue(
    ::std::unique_ptr<::blink::IDBKey> key, ::std::unique_ptr<::blink::IDBKey> primary_key) {
  IDBCursorResultPtr async_wait_result;
  Continue(std::move(key),std::move(primary_key),&async_wait_result);
  return async_wait_result;
}

void IDBCursorAsyncWaiter::Prefetch(
    int32_t count, IDBCursorResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->Prefetch(
      std::move(count),
      base::BindOnce(
          [](base::RunLoop* loop,
             IDBCursorResultPtr* out_result
,
             IDBCursorResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

IDBCursorResultPtr IDBCursorAsyncWaiter::Prefetch(
    int32_t count) {
  IDBCursorResultPtr async_wait_result;
  Prefetch(std::move(count),&async_wait_result);
  return async_wait_result;
}




void IDBTransactionInterceptorForTesting::CreateObjectStore(int64_t object_store_id, const ::blink::String& name, const ::blink::IDBKeyPath& key_path, bool auto_increment) {
  GetForwardingInterface()->CreateObjectStore(
    std::move(object_store_id)
    , 
    std::move(name)
    , 
    std::move(key_path)
    , 
    std::move(auto_increment)
    );
}
void IDBTransactionInterceptorForTesting::DeleteObjectStore(int64_t object_store_id) {
  GetForwardingInterface()->DeleteObjectStore(
    std::move(object_store_id)
    );
}
void IDBTransactionInterceptorForTesting::Put(int64_t object_store_id, ::std::unique_ptr<::blink::IDBValue> value, ::std::unique_ptr<::blink::IDBKey> key, IDBPutMode mode, ::blink::Vector<::blink::IDBIndexKeys> index_keys, PutCallback callback) {
  GetForwardingInterface()->Put(
    std::move(object_store_id)
    , 
    std::move(value)
    , 
    std::move(key)
    , 
    std::move(mode)
    , 
    std::move(index_keys)
    , std::move(callback));
}
void IDBTransactionInterceptorForTesting::SetIndexKeys(int64_t object_store_id, ::std::unique_ptr<::blink::IDBKey> primary_key, ::blink::IDBIndexKeys index_keys) {
  GetForwardingInterface()->SetIndexKeys(
    std::move(object_store_id)
    , 
    std::move(primary_key)
    , 
    std::move(index_keys)
    );
}
void IDBTransactionInterceptorForTesting::SetIndexKeysDone() {
  GetForwardingInterface()->SetIndexKeysDone();
}
void IDBTransactionInterceptorForTesting::Commit(int64_t num_errors_handled) {
  GetForwardingInterface()->Commit(
    std::move(num_errors_handled)
    );
}
IDBTransactionAsyncWaiter::IDBTransactionAsyncWaiter(
    IDBTransaction* proxy) : proxy_(proxy) {}

IDBTransactionAsyncWaiter::~IDBTransactionAsyncWaiter() = default;


void IDBTransactionAsyncWaiter::Put(
    int64_t object_store_id, ::std::unique_ptr<::blink::IDBValue> value, ::std::unique_ptr<::blink::IDBKey> key, IDBPutMode mode, ::blink::Vector<::blink::IDBIndexKeys> index_keys, IDBTransactionPutResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->Put(
      std::move(object_store_id),
      std::move(value),
      std::move(key),
      std::move(mode),
      std::move(index_keys),
      base::BindOnce(
          [](base::RunLoop* loop,
             IDBTransactionPutResultPtr* out_result
,
             IDBTransactionPutResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

IDBTransactionPutResultPtr IDBTransactionAsyncWaiter::Put(
    int64_t object_store_id, ::std::unique_ptr<::blink::IDBValue> value, ::std::unique_ptr<::blink::IDBKey> key, IDBPutMode mode, ::blink::Vector<::blink::IDBIndexKeys> index_keys) {
  IDBTransactionPutResultPtr async_wait_result;
  Put(std::move(object_store_id),std::move(value),std::move(key),std::move(mode),std::move(index_keys),&async_wait_result);
  return async_wait_result;
}




void IDBDatabaseGetAllResultSinkInterceptorForTesting::ReceiveResults(::blink::Vector<IDBRecordPtr> records, bool done) {
  GetForwardingInterface()->ReceiveResults(
    std::move(records)
    , 
    std::move(done)
    );
}
void IDBDatabaseGetAllResultSinkInterceptorForTesting::OnError(IDBErrorPtr error) {
  GetForwardingInterface()->OnError(
    std::move(error)
    );
}
IDBDatabaseGetAllResultSinkAsyncWaiter::IDBDatabaseGetAllResultSinkAsyncWaiter(
    IDBDatabaseGetAllResultSink* proxy) : proxy_(proxy) {}

IDBDatabaseGetAllResultSinkAsyncWaiter::~IDBDatabaseGetAllResultSinkAsyncWaiter() = default;





void IDBDatabaseInterceptorForTesting::RenameObjectStore(int64_t transaction_id, int64_t object_store_id, const ::blink::String& new_name) {
  GetForwardingInterface()->RenameObjectStore(
    std::move(transaction_id)
    , 
    std::move(object_store_id)
    , 
    std::move(new_name)
    );
}
void IDBDatabaseInterceptorForTesting::CreateTransaction(::mojo::PendingAssociatedReceiver<IDBTransaction> transaction_receiver, int64_t transaction_id, const ::blink::Vector<int64_t>& object_store_ids, IDBTransactionMode mode, IDBTransactionDurability durability) {
  GetForwardingInterface()->CreateTransaction(
    std::move(transaction_receiver)
    , 
    std::move(transaction_id)
    , 
    std::move(object_store_ids)
    , 
    std::move(mode)
    , 
    std::move(durability)
    );
}
void IDBDatabaseInterceptorForTesting::VersionChangeIgnored() {
  GetForwardingInterface()->VersionChangeIgnored();
}
void IDBDatabaseInterceptorForTesting::Get(int64_t transaction_id, int64_t object_store_id, int64_t index_id, IDBKeyRangePtr key_range, bool key_only, GetCallback callback) {
  GetForwardingInterface()->Get(
    std::move(transaction_id)
    , 
    std::move(object_store_id)
    , 
    std::move(index_id)
    , 
    std::move(key_range)
    , 
    std::move(key_only)
    , std::move(callback));
}
void IDBDatabaseInterceptorForTesting::GetAll(int64_t transaction_id, int64_t object_store_id, int64_t index_id, IDBKeyRangePtr key_range, IDBGetAllResultType result_type, int64_t max_count, IDBCursorDirection direction, GetAllCallback callback) {
  GetForwardingInterface()->GetAll(
    std::move(transaction_id)
    , 
    std::move(object_store_id)
    , 
    std::move(index_id)
    , 
    std::move(key_range)
    , 
    std::move(result_type)
    , 
    std::move(max_count)
    , 
    std::move(direction)
    , std::move(callback));
}
void IDBDatabaseInterceptorForTesting::OpenCursor(int64_t transaction_id, int64_t object_store_id, int64_t index_id, IDBKeyRangePtr key_range, IDBCursorDirection direction, bool key_only, IDBTaskType task_type, OpenCursorCallback callback) {
  GetForwardingInterface()->OpenCursor(
    std::move(transaction_id)
    , 
    std::move(object_store_id)
    , 
    std::move(index_id)
    , 
    std::move(key_range)
    , 
    std::move(direction)
    , 
    std::move(key_only)
    , 
    std::move(task_type)
    , std::move(callback));
}
void IDBDatabaseInterceptorForTesting::Count(int64_t transaction_id, int64_t object_store_id, int64_t index_id, IDBKeyRangePtr key_range, CountCallback callback) {
  GetForwardingInterface()->Count(
    std::move(transaction_id)
    , 
    std::move(object_store_id)
    , 
    std::move(index_id)
    , 
    std::move(key_range)
    , std::move(callback));
}
void IDBDatabaseInterceptorForTesting::DeleteRange(int64_t transaction_id, int64_t object_store_id, IDBKeyRangePtr key_range, DeleteRangeCallback callback) {
  GetForwardingInterface()->DeleteRange(
    std::move(transaction_id)
    , 
    std::move(object_store_id)
    , 
    std::move(key_range)
    , std::move(callback));
}
void IDBDatabaseInterceptorForTesting::GetKeyGeneratorCurrentNumber(int64_t transaction_id, int64_t object_store_id, GetKeyGeneratorCurrentNumberCallback callback) {
  GetForwardingInterface()->GetKeyGeneratorCurrentNumber(
    std::move(transaction_id)
    , 
    std::move(object_store_id)
    , std::move(callback));
}
void IDBDatabaseInterceptorForTesting::Clear(int64_t transaction_id, int64_t object_store_id, ClearCallback callback) {
  GetForwardingInterface()->Clear(
    std::move(transaction_id)
    , 
    std::move(object_store_id)
    , std::move(callback));
}
void IDBDatabaseInterceptorForTesting::CreateIndex(int64_t transaction_id, int64_t object_store_id, const ::scoped_refptr<::blink::IDBIndexMetadata>& index) {
  GetForwardingInterface()->CreateIndex(
    std::move(transaction_id)
    , 
    std::move(object_store_id)
    , 
    std::move(index)
    );
}
void IDBDatabaseInterceptorForTesting::DeleteIndex(int64_t transaction_id, int64_t object_store_id, int64_t index_id) {
  GetForwardingInterface()->DeleteIndex(
    std::move(transaction_id)
    , 
    std::move(object_store_id)
    , 
    std::move(index_id)
    );
}
void IDBDatabaseInterceptorForTesting::RenameIndex(int64_t transaction_id, int64_t object_store_id, int64_t index_id, const ::blink::String& new_name) {
  GetForwardingInterface()->RenameIndex(
    std::move(transaction_id)
    , 
    std::move(object_store_id)
    , 
    std::move(index_id)
    , 
    std::move(new_name)
    );
}
void IDBDatabaseInterceptorForTesting::Abort(int64_t transaction_id) {
  GetForwardingInterface()->Abort(
    std::move(transaction_id)
    );
}
void IDBDatabaseInterceptorForTesting::DidBecomeInactive() {
  GetForwardingInterface()->DidBecomeInactive();
}
void IDBDatabaseInterceptorForTesting::UpdatePriority(int32_t new_priority) {
  GetForwardingInterface()->UpdatePriority(
    std::move(new_priority)
    );
}
IDBDatabaseAsyncWaiter::IDBDatabaseAsyncWaiter(
    IDBDatabase* proxy) : proxy_(proxy) {}

IDBDatabaseAsyncWaiter::~IDBDatabaseAsyncWaiter() = default;


void IDBDatabaseAsyncWaiter::Get(
    int64_t transaction_id, int64_t object_store_id, int64_t index_id, IDBKeyRangePtr key_range, bool key_only, IDBDatabaseGetResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->Get(
      std::move(transaction_id),
      std::move(object_store_id),
      std::move(index_id),
      std::move(key_range),
      std::move(key_only),
      base::BindOnce(
          [](base::RunLoop* loop,
             IDBDatabaseGetResultPtr* out_result
,
             IDBDatabaseGetResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

IDBDatabaseGetResultPtr IDBDatabaseAsyncWaiter::Get(
    int64_t transaction_id, int64_t object_store_id, int64_t index_id, IDBKeyRangePtr key_range, bool key_only) {
  IDBDatabaseGetResultPtr async_wait_result;
  Get(std::move(transaction_id),std::move(object_store_id),std::move(index_id),std::move(key_range),std::move(key_only),&async_wait_result);
  return async_wait_result;
}

void IDBDatabaseAsyncWaiter::GetAll(
    int64_t transaction_id, int64_t object_store_id, int64_t index_id, IDBKeyRangePtr key_range, IDBGetAllResultType result_type, int64_t max_count, IDBCursorDirection direction, ::mojo::PendingAssociatedReceiver<IDBDatabaseGetAllResultSink>* out_receiver) {
  base::RunLoop loop;
  proxy_->GetAll(
      std::move(transaction_id),
      std::move(object_store_id),
      std::move(index_id),
      std::move(key_range),
      std::move(result_type),
      std::move(max_count),
      std::move(direction),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::PendingAssociatedReceiver<IDBDatabaseGetAllResultSink>* out_receiver
,
             ::mojo::PendingAssociatedReceiver<IDBDatabaseGetAllResultSink> receiver) {*out_receiver = std::move(receiver);
            loop->Quit();
          },
          &loop,
          out_receiver));
  loop.Run();
}

::mojo::PendingAssociatedReceiver<IDBDatabaseGetAllResultSink> IDBDatabaseAsyncWaiter::GetAll(
    int64_t transaction_id, int64_t object_store_id, int64_t index_id, IDBKeyRangePtr key_range, IDBGetAllResultType result_type, int64_t max_count, IDBCursorDirection direction) {
  ::mojo::PendingAssociatedReceiver<IDBDatabaseGetAllResultSink> async_wait_result;
  GetAll(std::move(transaction_id),std::move(object_store_id),std::move(index_id),std::move(key_range),std::move(result_type),std::move(max_count),std::move(direction),&async_wait_result);
  return async_wait_result;
}

void IDBDatabaseAsyncWaiter::OpenCursor(
    int64_t transaction_id, int64_t object_store_id, int64_t index_id, IDBKeyRangePtr key_range, IDBCursorDirection direction, bool key_only, IDBTaskType task_type, IDBDatabaseOpenCursorResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->OpenCursor(
      std::move(transaction_id),
      std::move(object_store_id),
      std::move(index_id),
      std::move(key_range),
      std::move(direction),
      std::move(key_only),
      std::move(task_type),
      base::BindOnce(
          [](base::RunLoop* loop,
             IDBDatabaseOpenCursorResultPtr* out_result
,
             IDBDatabaseOpenCursorResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

IDBDatabaseOpenCursorResultPtr IDBDatabaseAsyncWaiter::OpenCursor(
    int64_t transaction_id, int64_t object_store_id, int64_t index_id, IDBKeyRangePtr key_range, IDBCursorDirection direction, bool key_only, IDBTaskType task_type) {
  IDBDatabaseOpenCursorResultPtr async_wait_result;
  OpenCursor(std::move(transaction_id),std::move(object_store_id),std::move(index_id),std::move(key_range),std::move(direction),std::move(key_only),std::move(task_type),&async_wait_result);
  return async_wait_result;
}

void IDBDatabaseAsyncWaiter::Count(
    int64_t transaction_id, int64_t object_store_id, int64_t index_id, IDBKeyRangePtr key_range, bool* out_success, uint32_t* out_count) {
  base::RunLoop loop;
  proxy_->Count(
      std::move(transaction_id),
      std::move(object_store_id),
      std::move(index_id),
      std::move(key_range),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             uint32_t* out_count
,
             bool success,
             uint32_t count) {*out_success = std::move(success);*out_count = std::move(count);
            loop->Quit();
          },
          &loop,
          out_success,
          out_count));
  loop.Run();
}



void IDBDatabaseAsyncWaiter::DeleteRange(
    int64_t transaction_id, int64_t object_store_id, IDBKeyRangePtr key_range, bool* out_success) {
  base::RunLoop loop;
  proxy_->DeleteRange(
      std::move(transaction_id),
      std::move(object_store_id),
      std::move(key_range),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool IDBDatabaseAsyncWaiter::DeleteRange(
    int64_t transaction_id, int64_t object_store_id, IDBKeyRangePtr key_range) {
  bool async_wait_result;
  DeleteRange(std::move(transaction_id),std::move(object_store_id),std::move(key_range),&async_wait_result);
  return async_wait_result;
}

void IDBDatabaseAsyncWaiter::GetKeyGeneratorCurrentNumber(
    int64_t transaction_id, int64_t object_store_id, int64_t* out_result, IDBErrorPtr* out_error) {
  base::RunLoop loop;
  proxy_->GetKeyGeneratorCurrentNumber(
      std::move(transaction_id),
      std::move(object_store_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             int64_t* out_result
,
             IDBErrorPtr* out_error
,
             int64_t result,
             IDBErrorPtr error) {*out_result = std::move(result);*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_result,
          out_error));
  loop.Run();
}



void IDBDatabaseAsyncWaiter::Clear(
    int64_t transaction_id, int64_t object_store_id, bool* out_success) {
  base::RunLoop loop;
  proxy_->Clear(
      std::move(transaction_id),
      std::move(object_store_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool IDBDatabaseAsyncWaiter::Clear(
    int64_t transaction_id, int64_t object_store_id) {
  bool async_wait_result;
  Clear(std::move(transaction_id),std::move(object_store_id),&async_wait_result);
  return async_wait_result;
}




void IDBFactoryInterceptorForTesting::GetDatabaseInfo(GetDatabaseInfoCallback callback) {
  GetForwardingInterface()->GetDatabaseInfo(std::move(callback));
}
void IDBFactoryInterceptorForTesting::Open(::mojo::PendingAssociatedRemote<IDBFactoryClient> client, ::mojo::PendingAssociatedRemote<IDBDatabaseCallbacks> database_callbacks, const ::blink::String& name, int64_t version, ::mojo::PendingAssociatedReceiver<IDBTransaction> version_change_transaction_receiver, int64_t transaction_id, int32_t priority) {
  GetForwardingInterface()->Open(
    std::move(client)
    , 
    std::move(database_callbacks)
    , 
    std::move(name)
    , 
    std::move(version)
    , 
    std::move(version_change_transaction_receiver)
    , 
    std::move(transaction_id)
    , 
    std::move(priority)
    );
}
void IDBFactoryInterceptorForTesting::DeleteDatabase(::mojo::PendingAssociatedRemote<IDBFactoryClient> client, const ::blink::String& name, bool force_close) {
  GetForwardingInterface()->DeleteDatabase(
    std::move(client)
    , 
    std::move(name)
    , 
    std::move(force_close)
    );
}
IDBFactoryAsyncWaiter::IDBFactoryAsyncWaiter(
    IDBFactory* proxy) : proxy_(proxy) {}

IDBFactoryAsyncWaiter::~IDBFactoryAsyncWaiter() = default;


void IDBFactoryAsyncWaiter::GetDatabaseInfo(
    ::blink::Vector<IDBNameAndVersionPtr>* out_names_and_versions, IDBErrorPtr* out_error) {
  base::RunLoop loop;
  proxy_->GetDatabaseInfo(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::Vector<IDBNameAndVersionPtr>* out_names_and_versions
,
             IDBErrorPtr* out_error
,
             ::blink::Vector<IDBNameAndVersionPtr> names_and_versions,
             IDBErrorPtr error) {*out_names_and_versions = std::move(names_and_versions);*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_names_and_versions,
          out_error));
  loop.Run();
}








}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif