// third_party/blink/public/mojom/hid/hid.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_HID_HID_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_HID_HID_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/hid/hid.mojom-shared-internal.h"
#include "services/device/public/mojom/hid.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/hid/hid.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::VendorAndProductDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::VendorAndProductDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::VendorAndProduct_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->vendor = Traits::vendor(input);

    fragment->product = Traits::product(input);
  }

  static bool Deserialize(::blink::mojom::internal::VendorAndProduct_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::VendorAndProductDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::HidDeviceFilterDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::HidDeviceFilterDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::HidDeviceFilter_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::device_ids(input)) in_device_ids = Traits::device_ids(input);
    mojo::internal::MessageFragment<decltype(fragment->device_ids)>
        device_ids_fragment(fragment.message());
    device_ids_fragment.Claim(&fragment->device_ids);
    
    mojo::internal::Serialize<::blink::mojom::DeviceIdFilterDataView>(
      in_device_ids,
      device_ids_fragment,
      true);

    decltype(Traits::usage(input)) in_usage = Traits::usage(input);
    mojo::internal::MessageFragment<decltype(fragment->usage)>
        usage_fragment(fragment.message());
    usage_fragment.Claim(&fragment->usage);
    
    mojo::internal::Serialize<::blink::mojom::UsageFilterDataView>(
      in_usage,
      usage_fragment,
      true);
  }

  static bool Deserialize(::blink::mojom::internal::HidDeviceFilter_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::HidDeviceFilterDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DeviceIdFilterDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::DeviceIdFilterDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::DeviceIdFilter_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::DeviceIdFilterDataView::Tag::kVendor: {
    decltype(Traits::vendor(input))
    in_vendor = Traits::vendor(input);
    fragment->data.f_vendor = in_vendor;
    break;
  }
  case ::blink::mojom::DeviceIdFilterDataView::Tag::kVendorAndProduct: {
    decltype(Traits::vendor_and_product(input))
    in_vendor_and_product = Traits::vendor_and_product(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_vendor_and_product)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::VendorAndProductDataView>(
  in_vendor_and_product,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null vendor_and_product in DeviceIdFilter union");
    fragment->data.f_vendor_and_product.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::blink::mojom::internal::DeviceIdFilter_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DeviceIdFilterDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::UsageFilterDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::UsageFilterDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::UsageFilter_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::UsageFilterDataView::Tag::kPage: {
    decltype(Traits::page(input))
    in_page = Traits::page(input);
    fragment->data.f_page = in_page;
    break;
  }
  case ::blink::mojom::UsageFilterDataView::Tag::kUsageAndPage: {
    decltype(Traits::usage_and_page(input))
    in_usage_and_page = Traits::usage_and_page(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_usage_and_page)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::device::mojom::HidUsageAndPageDataView>(
  in_usage_and_page,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null usage_and_page in UsageFilter union");
    fragment->data.f_usage_and_page.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::blink::mojom::internal::UsageFilter_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::UsageFilterDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {



inline void HidDeviceFilterDataView::GetDeviceIdsDataView(
    DeviceIdFilterDataView* output) {
  auto pointer = &data_->device_ids;
  *output = DeviceIdFilterDataView(pointer, message_);
}
inline void HidDeviceFilterDataView::GetUsageDataView(
    UsageFilterDataView* output) {
  auto pointer = &data_->usage;
  *output = UsageFilterDataView(pointer, message_);
}


inline void DeviceIdFilterDataView::GetVendorAndProductDataView(
    VendorAndProductDataView* output) const {
  CHECK(is_vendor_and_product());
  *output = VendorAndProductDataView(data_->data.f_vendor_and_product.Get(), message_);
}

inline void UsageFilterDataView::GetUsageAndPageDataView(
    ::device::mojom::HidUsageAndPageDataView* output) const {
  CHECK(is_usage_and_page());
  *output = ::device::mojom::HidUsageAndPageDataView(data_->data.f_usage_and_page.Get(), message_);
}


}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_HID_HID_MOJOM_SHARED_H_