// third_party/blink/public/mojom/handwriting/handwriting.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/handwriting/handwriting.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('handwriting.mojom');
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }


  var HandwritingRecognitionType = {};
  HandwritingRecognitionType.kText = 0;
  HandwritingRecognitionType.MIN_VALUE = 0;
  HandwritingRecognitionType.MAX_VALUE = 0;

  HandwritingRecognitionType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
      return true;
    }
    return false;
  };

  HandwritingRecognitionType.toKnownEnumValue = function(value) {
    return value;
  };

  HandwritingRecognitionType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var HandwritingInputType = {};
  HandwritingInputType.kMouse = 0;
  HandwritingInputType.kStylus = 1;
  HandwritingInputType.kTouch = 2;
  HandwritingInputType.MIN_VALUE = 0;
  HandwritingInputType.MAX_VALUE = 2;

  HandwritingInputType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  HandwritingInputType.toKnownEnumValue = function(value) {
    return value;
  };

  HandwritingInputType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var CreateHandwritingRecognizerResult = {};
  CreateHandwritingRecognizerResult.kOk = 0;
  CreateHandwritingRecognizerResult.kError = 1;
  CreateHandwritingRecognizerResult.kNotSupported = 2;
  CreateHandwritingRecognizerResult.MIN_VALUE = 0;
  CreateHandwritingRecognizerResult.MAX_VALUE = 2;

  CreateHandwritingRecognizerResult.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  CreateHandwritingRecognizerResult.toKnownEnumValue = function(value) {
    return value;
  };

  CreateHandwritingRecognizerResult.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function HandwritingPoint(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HandwritingPoint.prototype.initDefaults_ = function() {
    this.location = null;
    this.t = null;
  };
  HandwritingPoint.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HandwritingPoint.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HandwritingPoint.location
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.PointF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HandwritingPoint.t
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.TimeDelta, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HandwritingPoint.encodedSize = codec.kStructHeaderSize + 16;

  HandwritingPoint.decode = function(decoder) {
    var packed;
    var val = new HandwritingPoint();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.location =
        decoder.decodeStructPointer(geometry$.PointF);
    val.t =
        decoder.decodeStructPointer(time$.TimeDelta);
    return val;
  };

  HandwritingPoint.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HandwritingPoint.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.PointF, val.location);
    encoder.encodeStructPointer(time$.TimeDelta, val.t);
  };
  function HandwritingStroke(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HandwritingStroke.prototype.initDefaults_ = function() {
    this.points = null;
  };
  HandwritingStroke.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HandwritingStroke.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HandwritingStroke.points
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(HandwritingPoint), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HandwritingStroke.encodedSize = codec.kStructHeaderSize + 8;

  HandwritingStroke.decode = function(decoder) {
    var packed;
    var val = new HandwritingStroke();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.points =
        decoder.decodeArrayPointer(new codec.PointerTo(HandwritingPoint));
    return val;
  };

  HandwritingStroke.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HandwritingStroke.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(HandwritingPoint), val.points);
  };
  function HandwritingDrawingSegment(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HandwritingDrawingSegment.prototype.initDefaults_ = function() {
    this.strokeIndex = 0;
    this.beginPointIndex = 0;
    this.endPointIndex = 0;
  };
  HandwritingDrawingSegment.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HandwritingDrawingSegment.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  HandwritingDrawingSegment.encodedSize = codec.kStructHeaderSize + 16;

  HandwritingDrawingSegment.decode = function(decoder) {
    var packed;
    var val = new HandwritingDrawingSegment();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.strokeIndex =
        decoder.decodeStruct(codec.Uint32);
    val.beginPointIndex =
        decoder.decodeStruct(codec.Uint32);
    val.endPointIndex =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  HandwritingDrawingSegment.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HandwritingDrawingSegment.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.strokeIndex);
    encoder.encodeStruct(codec.Uint32, val.beginPointIndex);
    encoder.encodeStruct(codec.Uint32, val.endPointIndex);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function HandwritingSegment(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HandwritingSegment.prototype.initDefaults_ = function() {
    this.grapheme = null;
    this.beginIndex = 0;
    this.endIndex = 0;
    this.drawingSegments = null;
  };
  HandwritingSegment.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HandwritingSegment.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HandwritingSegment.grapheme
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;




    // validate HandwritingSegment.drawingSegments
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(HandwritingDrawingSegment), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HandwritingSegment.encodedSize = codec.kStructHeaderSize + 24;

  HandwritingSegment.decode = function(decoder) {
    var packed;
    var val = new HandwritingSegment();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.grapheme =
        decoder.decodeStruct(codec.String);
    val.beginIndex =
        decoder.decodeStruct(codec.Uint32);
    val.endIndex =
        decoder.decodeStruct(codec.Uint32);
    val.drawingSegments =
        decoder.decodeArrayPointer(new codec.PointerTo(HandwritingDrawingSegment));
    return val;
  };

  HandwritingSegment.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HandwritingSegment.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.grapheme);
    encoder.encodeStruct(codec.Uint32, val.beginIndex);
    encoder.encodeStruct(codec.Uint32, val.endIndex);
    encoder.encodeArrayPointer(new codec.PointerTo(HandwritingDrawingSegment), val.drawingSegments);
  };
  function HandwritingPrediction(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HandwritingPrediction.prototype.initDefaults_ = function() {
    this.text = null;
    this.segmentationResult = null;
  };
  HandwritingPrediction.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HandwritingPrediction.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HandwritingPrediction.text
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate HandwritingPrediction.segmentationResult
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(HandwritingSegment), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HandwritingPrediction.encodedSize = codec.kStructHeaderSize + 16;

  HandwritingPrediction.decode = function(decoder) {
    var packed;
    var val = new HandwritingPrediction();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.text =
        decoder.decodeStruct(codec.String);
    val.segmentationResult =
        decoder.decodeArrayPointer(new codec.PointerTo(HandwritingSegment));
    return val;
  };

  HandwritingPrediction.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HandwritingPrediction.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.text);
    encoder.encodeArrayPointer(new codec.PointerTo(HandwritingSegment), val.segmentationResult);
  };
  function HandwritingHints(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HandwritingHints.prototype.initDefaults_ = function() {
    this.recognitionType = null;
    this.inputType = null;
    this.textContext = null;
    this.alternatives = 0;
  };
  HandwritingHints.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HandwritingHints.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HandwritingHints.recognitionType
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate HandwritingHints.inputType
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate HandwritingHints.textContext
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, true)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  HandwritingHints.encodedSize = codec.kStructHeaderSize + 32;

  HandwritingHints.decode = function(decoder) {
    var packed;
    var val = new HandwritingHints();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.recognitionType =
        decoder.decodeStruct(codec.String);
    val.inputType =
        decoder.decodeStruct(codec.String);
    val.textContext =
        decoder.decodeStruct(codec.String);
    val.alternatives =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  HandwritingHints.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HandwritingHints.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.recognitionType);
    encoder.encodeStruct(codec.String, val.inputType);
    encoder.encodeStruct(codec.String, val.textContext);
    encoder.encodeStruct(codec.Uint32, val.alternatives);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function HandwritingHintsQueryResult(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HandwritingHintsQueryResult.prototype.initDefaults_ = function() {
    this.recognitionType = null;
    this.inputType = null;
    this.textContext = false;
    this.alternatives = false;
  };
  HandwritingHintsQueryResult.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HandwritingHintsQueryResult.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HandwritingHintsQueryResult.recognitionType
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 4, new codec.Enum(HandwritingRecognitionType), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HandwritingHintsQueryResult.inputType
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 4, new codec.Enum(HandwritingInputType), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  HandwritingHintsQueryResult.encodedSize = codec.kStructHeaderSize + 24;

  HandwritingHintsQueryResult.decode = function(decoder) {
    var packed;
    var val = new HandwritingHintsQueryResult();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.recognitionType =
        decoder.decodeArrayPointer(new codec.Enum(HandwritingRecognitionType));
    val.inputType =
        decoder.decodeArrayPointer(new codec.Enum(HandwritingInputType));
    packed = decoder.readUint8();
    val.textContext = (packed >> 0) & 1 ? true : false;
    val.alternatives = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  HandwritingHintsQueryResult.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HandwritingHintsQueryResult.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.Enum(HandwritingRecognitionType), val.recognitionType);
    encoder.encodeArrayPointer(new codec.Enum(HandwritingInputType), val.inputType);
    packed = 0;
    packed |= (val.textContext & 1) << 0
    packed |= (val.alternatives & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function QueryHandwritingRecognizerResult(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  QueryHandwritingRecognizerResult.prototype.initDefaults_ = function() {
    this.textAlternatives = false;
    this.textSegmentation = false;
    this.hints = null;
  };
  QueryHandwritingRecognizerResult.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  QueryHandwritingRecognizerResult.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate QueryHandwritingRecognizerResult.hints
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, HandwritingHintsQueryResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  QueryHandwritingRecognizerResult.encodedSize = codec.kStructHeaderSize + 16;

  QueryHandwritingRecognizerResult.decode = function(decoder) {
    var packed;
    var val = new QueryHandwritingRecognizerResult();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.textAlternatives = (packed >> 0) & 1 ? true : false;
    val.textSegmentation = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.hints =
        decoder.decodeStructPointer(HandwritingHintsQueryResult);
    return val;
  };

  QueryHandwritingRecognizerResult.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(QueryHandwritingRecognizerResult.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.textAlternatives & 1) << 0
    packed |= (val.textSegmentation & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(HandwritingHintsQueryResult, val.hints);
  };
  function HandwritingModelConstraint(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HandwritingModelConstraint.prototype.initDefaults_ = function() {
    this.languages = null;
  };
  HandwritingModelConstraint.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HandwritingModelConstraint.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HandwritingModelConstraint.languages
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HandwritingModelConstraint.encodedSize = codec.kStructHeaderSize + 8;

  HandwritingModelConstraint.decode = function(decoder) {
    var packed;
    var val = new HandwritingModelConstraint();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.languages =
        decoder.decodeArrayPointer(codec.String);
    return val;
  };

  HandwritingModelConstraint.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HandwritingModelConstraint.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.String, val.languages);
  };
  function HandwritingRecognizer_GetPrediction_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HandwritingRecognizer_GetPrediction_Params.prototype.initDefaults_ = function() {
    this.strokes = null;
    this.hints = null;
  };
  HandwritingRecognizer_GetPrediction_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HandwritingRecognizer_GetPrediction_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HandwritingRecognizer_GetPrediction_Params.strokes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(HandwritingStroke), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HandwritingRecognizer_GetPrediction_Params.hints
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, HandwritingHints, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HandwritingRecognizer_GetPrediction_Params.encodedSize = codec.kStructHeaderSize + 16;

  HandwritingRecognizer_GetPrediction_Params.decode = function(decoder) {
    var packed;
    var val = new HandwritingRecognizer_GetPrediction_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.strokes =
        decoder.decodeArrayPointer(new codec.PointerTo(HandwritingStroke));
    val.hints =
        decoder.decodeStructPointer(HandwritingHints);
    return val;
  };

  HandwritingRecognizer_GetPrediction_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HandwritingRecognizer_GetPrediction_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(HandwritingStroke), val.strokes);
    encoder.encodeStructPointer(HandwritingHints, val.hints);
  };
  function HandwritingRecognizer_GetPrediction_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HandwritingRecognizer_GetPrediction_ResponseParams.prototype.initDefaults_ = function() {
    this.prediction = null;
  };
  HandwritingRecognizer_GetPrediction_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HandwritingRecognizer_GetPrediction_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HandwritingRecognizer_GetPrediction_ResponseParams.prediction
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(HandwritingPrediction), true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HandwritingRecognizer_GetPrediction_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  HandwritingRecognizer_GetPrediction_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new HandwritingRecognizer_GetPrediction_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.prediction =
        decoder.decodeArrayPointer(new codec.PointerTo(HandwritingPrediction));
    return val;
  };

  HandwritingRecognizer_GetPrediction_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HandwritingRecognizer_GetPrediction_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(HandwritingPrediction), val.prediction);
  };
  function HandwritingRecognitionService_CreateHandwritingRecognizer_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HandwritingRecognitionService_CreateHandwritingRecognizer_Params.prototype.initDefaults_ = function() {
    this.constraint = null;
  };
  HandwritingRecognitionService_CreateHandwritingRecognizer_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HandwritingRecognitionService_CreateHandwritingRecognizer_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HandwritingRecognitionService_CreateHandwritingRecognizer_Params.constraint
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, HandwritingModelConstraint, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HandwritingRecognitionService_CreateHandwritingRecognizer_Params.encodedSize = codec.kStructHeaderSize + 8;

  HandwritingRecognitionService_CreateHandwritingRecognizer_Params.decode = function(decoder) {
    var packed;
    var val = new HandwritingRecognitionService_CreateHandwritingRecognizer_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.constraint =
        decoder.decodeStructPointer(HandwritingModelConstraint);
    return val;
  };

  HandwritingRecognitionService_CreateHandwritingRecognizer_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HandwritingRecognitionService_CreateHandwritingRecognizer_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(HandwritingModelConstraint, val.constraint);
  };
  function HandwritingRecognitionService_CreateHandwritingRecognizer_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HandwritingRecognitionService_CreateHandwritingRecognizer_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
    this.handwritingRecognizer = new HandwritingRecognizerPtr();
  };
  HandwritingRecognitionService_CreateHandwritingRecognizer_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HandwritingRecognitionService_CreateHandwritingRecognizer_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HandwritingRecognitionService_CreateHandwritingRecognizer_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, CreateHandwritingRecognizerResult);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HandwritingRecognitionService_CreateHandwritingRecognizer_ResponseParams.handwritingRecognizer
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 4, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HandwritingRecognitionService_CreateHandwritingRecognizer_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  HandwritingRecognitionService_CreateHandwritingRecognizer_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new HandwritingRecognitionService_CreateHandwritingRecognizer_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(CreateHandwritingRecognizerResult));
    val.handwritingRecognizer =
        decoder.decodeStruct(new codec.NullableInterface(HandwritingRecognizerPtr));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  HandwritingRecognitionService_CreateHandwritingRecognizer_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HandwritingRecognitionService_CreateHandwritingRecognizer_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.encodeStruct(new codec.NullableInterface(HandwritingRecognizerPtr), val.handwritingRecognizer);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function HandwritingRecognitionService_QueryHandwritingRecognizer_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HandwritingRecognitionService_QueryHandwritingRecognizer_Params.prototype.initDefaults_ = function() {
    this.constraint = null;
  };
  HandwritingRecognitionService_QueryHandwritingRecognizer_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HandwritingRecognitionService_QueryHandwritingRecognizer_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HandwritingRecognitionService_QueryHandwritingRecognizer_Params.constraint
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, HandwritingModelConstraint, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HandwritingRecognitionService_QueryHandwritingRecognizer_Params.encodedSize = codec.kStructHeaderSize + 8;

  HandwritingRecognitionService_QueryHandwritingRecognizer_Params.decode = function(decoder) {
    var packed;
    var val = new HandwritingRecognitionService_QueryHandwritingRecognizer_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.constraint =
        decoder.decodeStructPointer(HandwritingModelConstraint);
    return val;
  };

  HandwritingRecognitionService_QueryHandwritingRecognizer_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HandwritingRecognitionService_QueryHandwritingRecognizer_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(HandwritingModelConstraint, val.constraint);
  };
  function HandwritingRecognitionService_QueryHandwritingRecognizer_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HandwritingRecognitionService_QueryHandwritingRecognizer_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  HandwritingRecognitionService_QueryHandwritingRecognizer_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HandwritingRecognitionService_QueryHandwritingRecognizer_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HandwritingRecognitionService_QueryHandwritingRecognizer_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, QueryHandwritingRecognizerResult, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HandwritingRecognitionService_QueryHandwritingRecognizer_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  HandwritingRecognitionService_QueryHandwritingRecognizer_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new HandwritingRecognitionService_QueryHandwritingRecognizer_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(QueryHandwritingRecognizerResult);
    return val;
  };

  HandwritingRecognitionService_QueryHandwritingRecognizer_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HandwritingRecognitionService_QueryHandwritingRecognizer_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(QueryHandwritingRecognizerResult, val.result);
  };
  var kHandwritingRecognizer_GetPrediction_Name = 0;

  function HandwritingRecognizerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(HandwritingRecognizer,
                                                   handleOrPtrInfo);
  }

  function HandwritingRecognizerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        HandwritingRecognizer, associatedInterfacePtrInfo);
  }

  HandwritingRecognizerAssociatedPtr.prototype =
      Object.create(HandwritingRecognizerPtr.prototype);
  HandwritingRecognizerAssociatedPtr.prototype.constructor =
      HandwritingRecognizerAssociatedPtr;

  function HandwritingRecognizerProxy(receiver) {
    this.receiver_ = receiver;
  }
  HandwritingRecognizerPtr.prototype.getPrediction = function() {
    return HandwritingRecognizerProxy.prototype.getPrediction
        .apply(this.ptr.getProxy(), arguments);
  };

  HandwritingRecognizerProxy.prototype.getPrediction = function(strokes, hints) {
    var params_ = new HandwritingRecognizer_GetPrediction_Params();
    params_.strokes = strokes;
    params_.hints = hints;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kHandwritingRecognizer_GetPrediction_Name,
          codec.align(HandwritingRecognizer_GetPrediction_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(HandwritingRecognizer_GetPrediction_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(HandwritingRecognizer_GetPrediction_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function HandwritingRecognizerStub(delegate) {
    this.delegate_ = delegate;
  }
  HandwritingRecognizerStub.prototype.getPrediction = function(strokes, hints) {
    return this.delegate_ && this.delegate_.getPrediction && this.delegate_.getPrediction(strokes, hints);
  }

  HandwritingRecognizerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  HandwritingRecognizerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kHandwritingRecognizer_GetPrediction_Name:
      var params = reader.decodeStruct(HandwritingRecognizer_GetPrediction_Params);
      this.getPrediction(params.strokes, params.hints).then(function(response) {
        var responseParams =
            new HandwritingRecognizer_GetPrediction_ResponseParams();
        responseParams.prediction = response.prediction;
        var builder = new codec.MessageV1Builder(
            kHandwritingRecognizer_GetPrediction_Name,
            codec.align(HandwritingRecognizer_GetPrediction_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(HandwritingRecognizer_GetPrediction_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateHandwritingRecognizerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kHandwritingRecognizer_GetPrediction_Name:
        if (message.expectsResponse())
          paramsClass = HandwritingRecognizer_GetPrediction_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateHandwritingRecognizerResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kHandwritingRecognizer_GetPrediction_Name:
        if (message.isResponse())
          paramsClass = HandwritingRecognizer_GetPrediction_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var HandwritingRecognizer = {
    name: 'handwriting.mojom.HandwritingRecognizer',
    kVersion: 0,
    ptrClass: HandwritingRecognizerPtr,
    proxyClass: HandwritingRecognizerProxy,
    stubClass: HandwritingRecognizerStub,
    validateRequest: validateHandwritingRecognizerRequest,
    validateResponse: validateHandwritingRecognizerResponse,
  };
  HandwritingRecognizerStub.prototype.validator = validateHandwritingRecognizerRequest;
  HandwritingRecognizerProxy.prototype.validator = validateHandwritingRecognizerResponse;
  var kHandwritingRecognitionService_CreateHandwritingRecognizer_Name = 0;
  var kHandwritingRecognitionService_QueryHandwritingRecognizer_Name = 1;

  function HandwritingRecognitionServicePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(HandwritingRecognitionService,
                                                   handleOrPtrInfo);
  }

  function HandwritingRecognitionServiceAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        HandwritingRecognitionService, associatedInterfacePtrInfo);
  }

  HandwritingRecognitionServiceAssociatedPtr.prototype =
      Object.create(HandwritingRecognitionServicePtr.prototype);
  HandwritingRecognitionServiceAssociatedPtr.prototype.constructor =
      HandwritingRecognitionServiceAssociatedPtr;

  function HandwritingRecognitionServiceProxy(receiver) {
    this.receiver_ = receiver;
  }
  HandwritingRecognitionServicePtr.prototype.createHandwritingRecognizer = function() {
    return HandwritingRecognitionServiceProxy.prototype.createHandwritingRecognizer
        .apply(this.ptr.getProxy(), arguments);
  };

  HandwritingRecognitionServiceProxy.prototype.createHandwritingRecognizer = function(constraint) {
    var params_ = new HandwritingRecognitionService_CreateHandwritingRecognizer_Params();
    params_.constraint = constraint;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kHandwritingRecognitionService_CreateHandwritingRecognizer_Name,
          codec.align(HandwritingRecognitionService_CreateHandwritingRecognizer_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(HandwritingRecognitionService_CreateHandwritingRecognizer_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(HandwritingRecognitionService_CreateHandwritingRecognizer_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  HandwritingRecognitionServicePtr.prototype.queryHandwritingRecognizer = function() {
    return HandwritingRecognitionServiceProxy.prototype.queryHandwritingRecognizer
        .apply(this.ptr.getProxy(), arguments);
  };

  HandwritingRecognitionServiceProxy.prototype.queryHandwritingRecognizer = function(constraint) {
    var params_ = new HandwritingRecognitionService_QueryHandwritingRecognizer_Params();
    params_.constraint = constraint;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kHandwritingRecognitionService_QueryHandwritingRecognizer_Name,
          codec.align(HandwritingRecognitionService_QueryHandwritingRecognizer_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(HandwritingRecognitionService_QueryHandwritingRecognizer_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(HandwritingRecognitionService_QueryHandwritingRecognizer_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function HandwritingRecognitionServiceStub(delegate) {
    this.delegate_ = delegate;
  }
  HandwritingRecognitionServiceStub.prototype.createHandwritingRecognizer = function(constraint) {
    return this.delegate_ && this.delegate_.createHandwritingRecognizer && this.delegate_.createHandwritingRecognizer(constraint);
  }
  HandwritingRecognitionServiceStub.prototype.queryHandwritingRecognizer = function(constraint) {
    return this.delegate_ && this.delegate_.queryHandwritingRecognizer && this.delegate_.queryHandwritingRecognizer(constraint);
  }

  HandwritingRecognitionServiceStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  HandwritingRecognitionServiceStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kHandwritingRecognitionService_CreateHandwritingRecognizer_Name:
      var params = reader.decodeStruct(HandwritingRecognitionService_CreateHandwritingRecognizer_Params);
      this.createHandwritingRecognizer(params.constraint).then(function(response) {
        var responseParams =
            new HandwritingRecognitionService_CreateHandwritingRecognizer_ResponseParams();
        responseParams.result = response.result;
        responseParams.handwritingRecognizer = response.handwritingRecognizer;
        var builder = new codec.MessageV1Builder(
            kHandwritingRecognitionService_CreateHandwritingRecognizer_Name,
            codec.align(HandwritingRecognitionService_CreateHandwritingRecognizer_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(HandwritingRecognitionService_CreateHandwritingRecognizer_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kHandwritingRecognitionService_QueryHandwritingRecognizer_Name:
      var params = reader.decodeStruct(HandwritingRecognitionService_QueryHandwritingRecognizer_Params);
      this.queryHandwritingRecognizer(params.constraint).then(function(response) {
        var responseParams =
            new HandwritingRecognitionService_QueryHandwritingRecognizer_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kHandwritingRecognitionService_QueryHandwritingRecognizer_Name,
            codec.align(HandwritingRecognitionService_QueryHandwritingRecognizer_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(HandwritingRecognitionService_QueryHandwritingRecognizer_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateHandwritingRecognitionServiceRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kHandwritingRecognitionService_CreateHandwritingRecognizer_Name:
        if (message.expectsResponse())
          paramsClass = HandwritingRecognitionService_CreateHandwritingRecognizer_Params;
      break;
      case kHandwritingRecognitionService_QueryHandwritingRecognizer_Name:
        if (message.expectsResponse())
          paramsClass = HandwritingRecognitionService_QueryHandwritingRecognizer_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateHandwritingRecognitionServiceResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kHandwritingRecognitionService_CreateHandwritingRecognizer_Name:
        if (message.isResponse())
          paramsClass = HandwritingRecognitionService_CreateHandwritingRecognizer_ResponseParams;
        break;
      case kHandwritingRecognitionService_QueryHandwritingRecognizer_Name:
        if (message.isResponse())
          paramsClass = HandwritingRecognitionService_QueryHandwritingRecognizer_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var HandwritingRecognitionService = {
    name: 'handwriting.mojom.HandwritingRecognitionService',
    kVersion: 0,
    ptrClass: HandwritingRecognitionServicePtr,
    proxyClass: HandwritingRecognitionServiceProxy,
    stubClass: HandwritingRecognitionServiceStub,
    validateRequest: validateHandwritingRecognitionServiceRequest,
    validateResponse: validateHandwritingRecognitionServiceResponse,
  };
  HandwritingRecognitionServiceStub.prototype.validator = validateHandwritingRecognitionServiceRequest;
  HandwritingRecognitionServiceProxy.prototype.validator = validateHandwritingRecognitionServiceResponse;
  exports.HandwritingRecognitionType = HandwritingRecognitionType;
  exports.HandwritingInputType = HandwritingInputType;
  exports.CreateHandwritingRecognizerResult = CreateHandwritingRecognizerResult;
  exports.HandwritingPoint = HandwritingPoint;
  exports.HandwritingStroke = HandwritingStroke;
  exports.HandwritingDrawingSegment = HandwritingDrawingSegment;
  exports.HandwritingSegment = HandwritingSegment;
  exports.HandwritingPrediction = HandwritingPrediction;
  exports.HandwritingHints = HandwritingHints;
  exports.HandwritingHintsQueryResult = HandwritingHintsQueryResult;
  exports.QueryHandwritingRecognizerResult = QueryHandwritingRecognizerResult;
  exports.HandwritingModelConstraint = HandwritingModelConstraint;
  exports.HandwritingRecognizer = HandwritingRecognizer;
  exports.HandwritingRecognizerPtr = HandwritingRecognizerPtr;
  exports.HandwritingRecognizerAssociatedPtr = HandwritingRecognizerAssociatedPtr;
  exports.HandwritingRecognitionService = HandwritingRecognitionService;
  exports.HandwritingRecognitionServicePtr = HandwritingRecognitionServicePtr;
  exports.HandwritingRecognitionServiceAssociatedPtr = HandwritingRecognitionServiceAssociatedPtr;
})();