// third_party/blink/public/mojom/handwriting/handwriting.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_HANDWRITING_HANDWRITING_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_HANDWRITING_HANDWRITING_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/handwriting/handwriting.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/handwriting/handwriting.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/handwriting/handwriting.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace handwriting::mojom::blink {

class HandwritingRecognizerProxy;

template <typename ImplRefTraits>
class HandwritingRecognizerStub;

class HandwritingRecognizerRequestValidator;
class HandwritingRecognizerResponseValidator;


class PLATFORM_EXPORT HandwritingRecognizer
    : public HandwritingRecognizerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "handwriting.mojom.HandwritingRecognizer";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = HandwritingRecognizerInterfaceBase;
  using Proxy_ = HandwritingRecognizerProxy;

  template <typename ImplRefTraits>
  using Stub_ = HandwritingRecognizerStub<ImplRefTraits>;

  using RequestValidator_ = HandwritingRecognizerRequestValidator;
  using ResponseValidator_ = HandwritingRecognizerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetPredictionMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetPrediction_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~HandwritingRecognizer() = default;

  using GetPredictionCallback = base::OnceCallback<void(std::optional<::blink::Vector<HandwritingPredictionPtr>>)>;
  using GetPredictionMojoCallback = base::OnceCallback<void(std::optional<::blink::Vector<HandwritingPredictionPtr>>)>;

  virtual void GetPrediction(::blink::Vector<HandwritingStrokePtr> strokes, HandwritingHintsPtr hints, GetPredictionCallback callback) = 0;
};

class HandwritingRecognitionServiceProxy;

template <typename ImplRefTraits>
class HandwritingRecognitionServiceStub;

class HandwritingRecognitionServiceRequestValidator;
class HandwritingRecognitionServiceResponseValidator;


class PLATFORM_EXPORT HandwritingRecognitionService
    : public HandwritingRecognitionServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "handwriting.mojom.HandwritingRecognitionService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = HandwritingRecognitionServiceInterfaceBase;
  using Proxy_ = HandwritingRecognitionServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = HandwritingRecognitionServiceStub<ImplRefTraits>;

  using RequestValidator_ = HandwritingRecognitionServiceRequestValidator;
  using ResponseValidator_ = HandwritingRecognitionServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateHandwritingRecognizerMinVersion = 0,
    kQueryHandwritingRecognizerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateHandwritingRecognizer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct QueryHandwritingRecognizer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~HandwritingRecognitionService() = default;

  using CreateHandwritingRecognizerCallback = base::OnceCallback<void(CreateHandwritingRecognizerResult, ::mojo::PendingRemote<HandwritingRecognizer>)>;
  using CreateHandwritingRecognizerMojoCallback = base::OnceCallback<void(CreateHandwritingRecognizerResult, ::mojo::PendingRemote<HandwritingRecognizer>)>;

  virtual void CreateHandwritingRecognizer(HandwritingModelConstraintPtr constraint, CreateHandwritingRecognizerCallback callback) = 0;

  using QueryHandwritingRecognizerCallback = base::OnceCallback<void(QueryHandwritingRecognizerResultPtr)>;
  using QueryHandwritingRecognizerMojoCallback = base::OnceCallback<void(QueryHandwritingRecognizerResultPtr)>;

  virtual void QueryHandwritingRecognizer(HandwritingModelConstraintPtr constraint, QueryHandwritingRecognizerCallback callback) = 0;
};



class PLATFORM_EXPORT HandwritingRecognizerProxy
    : public HandwritingRecognizer {
 public:
  using InterfaceType = HandwritingRecognizer;

  explicit HandwritingRecognizerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetPrediction(::blink::Vector<HandwritingStrokePtr> strokes, HandwritingHintsPtr hints, GetPredictionCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT HandwritingRecognitionServiceProxy
    : public HandwritingRecognitionService {
 public:
  using InterfaceType = HandwritingRecognitionService;

  explicit HandwritingRecognitionServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateHandwritingRecognizer(HandwritingModelConstraintPtr constraint, CreateHandwritingRecognizerCallback callback) final;
  
  void QueryHandwritingRecognizer(HandwritingModelConstraintPtr constraint, QueryHandwritingRecognizerCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT HandwritingRecognizerStubDispatch {
 public:
  static bool Accept(HandwritingRecognizer* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      HandwritingRecognizer* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<HandwritingRecognizer>>
class HandwritingRecognizerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  HandwritingRecognizerStub() = default;
  ~HandwritingRecognizerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HandwritingRecognizerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HandwritingRecognizerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT HandwritingRecognitionServiceStubDispatch {
 public:
  static bool Accept(HandwritingRecognitionService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      HandwritingRecognitionService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<HandwritingRecognitionService>>
class HandwritingRecognitionServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  HandwritingRecognitionServiceStub() = default;
  ~HandwritingRecognitionServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HandwritingRecognitionServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HandwritingRecognitionServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT HandwritingRecognizerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT HandwritingRecognitionServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT HandwritingRecognizerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT HandwritingRecognitionServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};







class PLATFORM_EXPORT HandwritingDrawingSegment {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HandwritingDrawingSegment, T>::value>;
  using DataView = HandwritingDrawingSegmentDataView;
  using Data_ = internal::HandwritingDrawingSegment_Data;

  template <typename... Args>
  static HandwritingDrawingSegmentPtr New(Args&&... args) {
    return HandwritingDrawingSegmentPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HandwritingDrawingSegmentPtr From(const U& u) {
    return mojo::TypeConverter<HandwritingDrawingSegmentPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HandwritingDrawingSegment>::Convert(*this);
  }


  HandwritingDrawingSegment();

  HandwritingDrawingSegment(
      uint32_t stroke_index,
      uint32_t begin_point_index,
      uint32_t end_point_index);


  ~HandwritingDrawingSegment();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HandwritingDrawingSegmentPtr>
  HandwritingDrawingSegmentPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HandwritingDrawingSegment::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HandwritingDrawingSegment::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HandwritingDrawingSegment::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HandwritingDrawingSegment::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HandwritingDrawingSegment::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HandwritingDrawingSegment::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HandwritingDrawingSegment_UnserializedMessageContext<
            UserType, HandwritingDrawingSegment::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HandwritingDrawingSegment::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HandwritingDrawingSegment::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HandwritingDrawingSegment_UnserializedMessageContext<
            UserType, HandwritingDrawingSegment::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HandwritingDrawingSegment::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t stroke_index;
  
  uint32_t begin_point_index;
  
  uint32_t end_point_index;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HandwritingDrawingSegment::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HandwritingDrawingSegment::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HandwritingDrawingSegment::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HandwritingDrawingSegment::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class PLATFORM_EXPORT HandwritingHints {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HandwritingHints, T>::value>;
  using DataView = HandwritingHintsDataView;
  using Data_ = internal::HandwritingHints_Data;

  template <typename... Args>
  static HandwritingHintsPtr New(Args&&... args) {
    return HandwritingHintsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HandwritingHintsPtr From(const U& u) {
    return mojo::TypeConverter<HandwritingHintsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HandwritingHints>::Convert(*this);
  }


  HandwritingHints();

  HandwritingHints(
      const ::blink::String& recognition_type,
      const ::blink::String& input_type,
      const ::blink::String& text_context,
      uint32_t alternatives);


  ~HandwritingHints();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HandwritingHintsPtr>
  HandwritingHintsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HandwritingHints::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HandwritingHints::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HandwritingHints::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HandwritingHints::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HandwritingHints::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HandwritingHints::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HandwritingHints_UnserializedMessageContext<
            UserType, HandwritingHints::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HandwritingHints::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HandwritingHints::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HandwritingHints_UnserializedMessageContext<
            UserType, HandwritingHints::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HandwritingHints::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String recognition_type;
  
  ::blink::String input_type;
  
  ::blink::String text_context;
  
  uint32_t alternatives;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HandwritingHints::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HandwritingHints::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HandwritingHints::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HandwritingHints::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class PLATFORM_EXPORT HandwritingPoint {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HandwritingPoint, T>::value>;
  using DataView = HandwritingPointDataView;
  using Data_ = internal::HandwritingPoint_Data;

  template <typename... Args>
  static HandwritingPointPtr New(Args&&... args) {
    return HandwritingPointPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HandwritingPointPtr From(const U& u) {
    return mojo::TypeConverter<HandwritingPointPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HandwritingPoint>::Convert(*this);
  }


  HandwritingPoint();

  HandwritingPoint(
      const ::gfx::PointF& location,
      std::optional<::base::TimeDelta> t);


  ~HandwritingPoint();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HandwritingPointPtr>
  HandwritingPointPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HandwritingPoint::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HandwritingPoint::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HandwritingPoint::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HandwritingPoint::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HandwritingPoint::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HandwritingPoint::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HandwritingPoint_UnserializedMessageContext<
            UserType, HandwritingPoint::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HandwritingPoint::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HandwritingPoint::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HandwritingPoint_UnserializedMessageContext<
            UserType, HandwritingPoint::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HandwritingPoint::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::PointF location;
  
  std::optional<::base::TimeDelta> t;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HandwritingPoint::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HandwritingPoint::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HandwritingPoint::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HandwritingPoint::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT HandwritingStroke {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HandwritingStroke, T>::value>;
  using DataView = HandwritingStrokeDataView;
  using Data_ = internal::HandwritingStroke_Data;

  template <typename... Args>
  static HandwritingStrokePtr New(Args&&... args) {
    return HandwritingStrokePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HandwritingStrokePtr From(const U& u) {
    return mojo::TypeConverter<HandwritingStrokePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HandwritingStroke>::Convert(*this);
  }


  HandwritingStroke();

  explicit HandwritingStroke(
      ::blink::Vector<HandwritingPointPtr> points);

HandwritingStroke(const HandwritingStroke&) = delete;
HandwritingStroke& operator=(const HandwritingStroke&) = delete;

  ~HandwritingStroke();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HandwritingStrokePtr>
  HandwritingStrokePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HandwritingStroke::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HandwritingStroke::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HandwritingStroke::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HandwritingStroke::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HandwritingStroke::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HandwritingStroke::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HandwritingStroke_UnserializedMessageContext<
            UserType, HandwritingStroke::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HandwritingStroke::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HandwritingStroke::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HandwritingStroke_UnserializedMessageContext<
            UserType, HandwritingStroke::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HandwritingStroke::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<HandwritingPointPtr> points;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HandwritingStroke::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HandwritingStroke::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HandwritingStroke::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HandwritingStroke::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class PLATFORM_EXPORT HandwritingSegment {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HandwritingSegment, T>::value>;
  using DataView = HandwritingSegmentDataView;
  using Data_ = internal::HandwritingSegment_Data;

  template <typename... Args>
  static HandwritingSegmentPtr New(Args&&... args) {
    return HandwritingSegmentPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HandwritingSegmentPtr From(const U& u) {
    return mojo::TypeConverter<HandwritingSegmentPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HandwritingSegment>::Convert(*this);
  }


  HandwritingSegment();

  HandwritingSegment(
      const ::blink::String& grapheme,
      uint32_t begin_index,
      uint32_t end_index,
      ::blink::Vector<HandwritingDrawingSegmentPtr> drawing_segments);

HandwritingSegment(const HandwritingSegment&) = delete;
HandwritingSegment& operator=(const HandwritingSegment&) = delete;

  ~HandwritingSegment();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HandwritingSegmentPtr>
  HandwritingSegmentPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HandwritingSegment::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HandwritingSegment::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HandwritingSegment::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HandwritingSegment::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HandwritingSegment::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HandwritingSegment::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HandwritingSegment_UnserializedMessageContext<
            UserType, HandwritingSegment::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HandwritingSegment::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HandwritingSegment::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HandwritingSegment_UnserializedMessageContext<
            UserType, HandwritingSegment::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HandwritingSegment::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String grapheme;
  
  uint32_t begin_index;
  
  uint32_t end_index;
  
  ::blink::Vector<HandwritingDrawingSegmentPtr> drawing_segments;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HandwritingSegment::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HandwritingSegment::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HandwritingSegment::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HandwritingSegment::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT HandwritingPrediction {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HandwritingPrediction, T>::value>;
  using DataView = HandwritingPredictionDataView;
  using Data_ = internal::HandwritingPrediction_Data;

  template <typename... Args>
  static HandwritingPredictionPtr New(Args&&... args) {
    return HandwritingPredictionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HandwritingPredictionPtr From(const U& u) {
    return mojo::TypeConverter<HandwritingPredictionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HandwritingPrediction>::Convert(*this);
  }


  HandwritingPrediction();

  HandwritingPrediction(
      const ::blink::String& text,
      ::blink::Vector<HandwritingSegmentPtr> segmentation_result);

HandwritingPrediction(const HandwritingPrediction&) = delete;
HandwritingPrediction& operator=(const HandwritingPrediction&) = delete;

  ~HandwritingPrediction();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HandwritingPredictionPtr>
  HandwritingPredictionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HandwritingPrediction::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HandwritingPrediction::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HandwritingPrediction::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HandwritingPrediction::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HandwritingPrediction::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HandwritingPrediction::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HandwritingPrediction_UnserializedMessageContext<
            UserType, HandwritingPrediction::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HandwritingPrediction::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HandwritingPrediction::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HandwritingPrediction_UnserializedMessageContext<
            UserType, HandwritingPrediction::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HandwritingPrediction::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String text;
  
  ::blink::Vector<HandwritingSegmentPtr> segmentation_result;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HandwritingPrediction::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HandwritingPrediction::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HandwritingPrediction::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HandwritingPrediction::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class PLATFORM_EXPORT HandwritingHintsQueryResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HandwritingHintsQueryResult, T>::value>;
  using DataView = HandwritingHintsQueryResultDataView;
  using Data_ = internal::HandwritingHintsQueryResult_Data;

  template <typename... Args>
  static HandwritingHintsQueryResultPtr New(Args&&... args) {
    return HandwritingHintsQueryResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HandwritingHintsQueryResultPtr From(const U& u) {
    return mojo::TypeConverter<HandwritingHintsQueryResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HandwritingHintsQueryResult>::Convert(*this);
  }


  HandwritingHintsQueryResult();

  HandwritingHintsQueryResult(
      ::blink::Vector<HandwritingRecognitionType> recognition_type,
      ::blink::Vector<HandwritingInputType> input_type,
      bool text_context,
      bool alternatives);


  ~HandwritingHintsQueryResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HandwritingHintsQueryResultPtr>
  HandwritingHintsQueryResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HandwritingHintsQueryResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HandwritingHintsQueryResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HandwritingHintsQueryResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HandwritingHintsQueryResult::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HandwritingHintsQueryResult::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HandwritingHintsQueryResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HandwritingHintsQueryResult_UnserializedMessageContext<
            UserType, HandwritingHintsQueryResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HandwritingHintsQueryResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HandwritingHintsQueryResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HandwritingHintsQueryResult_UnserializedMessageContext<
            UserType, HandwritingHintsQueryResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HandwritingHintsQueryResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<HandwritingRecognitionType> recognition_type;
  
  ::blink::Vector<HandwritingInputType> input_type;
  
  bool text_context;
  
  bool alternatives;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HandwritingHintsQueryResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HandwritingHintsQueryResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HandwritingHintsQueryResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HandwritingHintsQueryResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT QueryHandwritingRecognizerResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<QueryHandwritingRecognizerResult, T>::value>;
  using DataView = QueryHandwritingRecognizerResultDataView;
  using Data_ = internal::QueryHandwritingRecognizerResult_Data;

  template <typename... Args>
  static QueryHandwritingRecognizerResultPtr New(Args&&... args) {
    return QueryHandwritingRecognizerResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static QueryHandwritingRecognizerResultPtr From(const U& u) {
    return mojo::TypeConverter<QueryHandwritingRecognizerResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, QueryHandwritingRecognizerResult>::Convert(*this);
  }


  QueryHandwritingRecognizerResult();

  QueryHandwritingRecognizerResult(
      bool text_alternatives,
      bool text_segmentation,
      HandwritingHintsQueryResultPtr hints);

QueryHandwritingRecognizerResult(const QueryHandwritingRecognizerResult&) = delete;
QueryHandwritingRecognizerResult& operator=(const QueryHandwritingRecognizerResult&) = delete;

  ~QueryHandwritingRecognizerResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = QueryHandwritingRecognizerResultPtr>
  QueryHandwritingRecognizerResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, QueryHandwritingRecognizerResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, QueryHandwritingRecognizerResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, QueryHandwritingRecognizerResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        QueryHandwritingRecognizerResult::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        QueryHandwritingRecognizerResult::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        QueryHandwritingRecognizerResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::QueryHandwritingRecognizerResult_UnserializedMessageContext<
            UserType, QueryHandwritingRecognizerResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<QueryHandwritingRecognizerResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return QueryHandwritingRecognizerResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::QueryHandwritingRecognizerResult_UnserializedMessageContext<
            UserType, QueryHandwritingRecognizerResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<QueryHandwritingRecognizerResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool text_alternatives;
  
  bool text_segmentation;
  
  HandwritingHintsQueryResultPtr hints;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, QueryHandwritingRecognizerResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, QueryHandwritingRecognizerResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, QueryHandwritingRecognizerResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, QueryHandwritingRecognizerResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT HandwritingModelConstraint {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HandwritingModelConstraint, T>::value>;
  using DataView = HandwritingModelConstraintDataView;
  using Data_ = internal::HandwritingModelConstraint_Data;

  template <typename... Args>
  static HandwritingModelConstraintPtr New(Args&&... args) {
    return HandwritingModelConstraintPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HandwritingModelConstraintPtr From(const U& u) {
    return mojo::TypeConverter<HandwritingModelConstraintPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HandwritingModelConstraint>::Convert(*this);
  }


  HandwritingModelConstraint();

  explicit HandwritingModelConstraint(
      ::blink::Vector<::blink::String> languages);


  ~HandwritingModelConstraint();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HandwritingModelConstraintPtr>
  HandwritingModelConstraintPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HandwritingModelConstraint::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HandwritingModelConstraint::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HandwritingModelConstraint::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HandwritingModelConstraint::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HandwritingModelConstraint::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HandwritingModelConstraint::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HandwritingModelConstraint_UnserializedMessageContext<
            UserType, HandwritingModelConstraint::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HandwritingModelConstraint::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HandwritingModelConstraint::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HandwritingModelConstraint_UnserializedMessageContext<
            UserType, HandwritingModelConstraint::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HandwritingModelConstraint::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<::blink::String> languages;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HandwritingModelConstraint::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HandwritingModelConstraint::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HandwritingModelConstraint::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HandwritingModelConstraint::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
HandwritingPointPtr HandwritingPoint::Clone() const {
  return New(
      mojo::Clone(location),
      mojo::Clone(t)
  );
}

template <typename T, HandwritingPoint::EnableIfSame<T>*>
bool HandwritingPoint::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->location, other_struct.location))
    return false;
  if (!mojo::Equals(this->t, other_struct.t))
    return false;
  return true;
}

template <typename T, HandwritingPoint::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.location < rhs.location)
    return true;
  if (rhs.location < lhs.location)
    return false;
  if (lhs.t < rhs.t)
    return true;
  if (rhs.t < lhs.t)
    return false;
  return false;
}
template <typename StructPtrType>
HandwritingStrokePtr HandwritingStroke::Clone() const {
  return New(
      mojo::Clone(points)
  );
}

template <typename T, HandwritingStroke::EnableIfSame<T>*>
bool HandwritingStroke::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->points, other_struct.points))
    return false;
  return true;
}

template <typename T, HandwritingStroke::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.points < rhs.points)
    return true;
  if (rhs.points < lhs.points)
    return false;
  return false;
}
template <typename StructPtrType>
HandwritingDrawingSegmentPtr HandwritingDrawingSegment::Clone() const {
  return New(
      mojo::Clone(stroke_index),
      mojo::Clone(begin_point_index),
      mojo::Clone(end_point_index)
  );
}

template <typename T, HandwritingDrawingSegment::EnableIfSame<T>*>
bool HandwritingDrawingSegment::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->stroke_index, other_struct.stroke_index))
    return false;
  if (!mojo::Equals(this->begin_point_index, other_struct.begin_point_index))
    return false;
  if (!mojo::Equals(this->end_point_index, other_struct.end_point_index))
    return false;
  return true;
}

template <typename T, HandwritingDrawingSegment::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.stroke_index < rhs.stroke_index)
    return true;
  if (rhs.stroke_index < lhs.stroke_index)
    return false;
  if (lhs.begin_point_index < rhs.begin_point_index)
    return true;
  if (rhs.begin_point_index < lhs.begin_point_index)
    return false;
  if (lhs.end_point_index < rhs.end_point_index)
    return true;
  if (rhs.end_point_index < lhs.end_point_index)
    return false;
  return false;
}
template <typename StructPtrType>
HandwritingSegmentPtr HandwritingSegment::Clone() const {
  return New(
      mojo::Clone(grapheme),
      mojo::Clone(begin_index),
      mojo::Clone(end_index),
      mojo::Clone(drawing_segments)
  );
}

template <typename T, HandwritingSegment::EnableIfSame<T>*>
bool HandwritingSegment::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->grapheme, other_struct.grapheme))
    return false;
  if (!mojo::Equals(this->begin_index, other_struct.begin_index))
    return false;
  if (!mojo::Equals(this->end_index, other_struct.end_index))
    return false;
  if (!mojo::Equals(this->drawing_segments, other_struct.drawing_segments))
    return false;
  return true;
}

template <typename T, HandwritingSegment::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.grapheme < rhs.grapheme)
    return true;
  if (rhs.grapheme < lhs.grapheme)
    return false;
  if (lhs.begin_index < rhs.begin_index)
    return true;
  if (rhs.begin_index < lhs.begin_index)
    return false;
  if (lhs.end_index < rhs.end_index)
    return true;
  if (rhs.end_index < lhs.end_index)
    return false;
  if (lhs.drawing_segments < rhs.drawing_segments)
    return true;
  if (rhs.drawing_segments < lhs.drawing_segments)
    return false;
  return false;
}
template <typename StructPtrType>
HandwritingPredictionPtr HandwritingPrediction::Clone() const {
  return New(
      mojo::Clone(text),
      mojo::Clone(segmentation_result)
  );
}

template <typename T, HandwritingPrediction::EnableIfSame<T>*>
bool HandwritingPrediction::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->text, other_struct.text))
    return false;
  if (!mojo::Equals(this->segmentation_result, other_struct.segmentation_result))
    return false;
  return true;
}

template <typename T, HandwritingPrediction::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.text < rhs.text)
    return true;
  if (rhs.text < lhs.text)
    return false;
  if (lhs.segmentation_result < rhs.segmentation_result)
    return true;
  if (rhs.segmentation_result < lhs.segmentation_result)
    return false;
  return false;
}
template <typename StructPtrType>
HandwritingHintsPtr HandwritingHints::Clone() const {
  return New(
      mojo::Clone(recognition_type),
      mojo::Clone(input_type),
      mojo::Clone(text_context),
      mojo::Clone(alternatives)
  );
}

template <typename T, HandwritingHints::EnableIfSame<T>*>
bool HandwritingHints::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->recognition_type, other_struct.recognition_type))
    return false;
  if (!mojo::Equals(this->input_type, other_struct.input_type))
    return false;
  if (!mojo::Equals(this->text_context, other_struct.text_context))
    return false;
  if (!mojo::Equals(this->alternatives, other_struct.alternatives))
    return false;
  return true;
}

template <typename T, HandwritingHints::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.recognition_type < rhs.recognition_type)
    return true;
  if (rhs.recognition_type < lhs.recognition_type)
    return false;
  if (lhs.input_type < rhs.input_type)
    return true;
  if (rhs.input_type < lhs.input_type)
    return false;
  if (lhs.text_context < rhs.text_context)
    return true;
  if (rhs.text_context < lhs.text_context)
    return false;
  if (lhs.alternatives < rhs.alternatives)
    return true;
  if (rhs.alternatives < lhs.alternatives)
    return false;
  return false;
}
template <typename StructPtrType>
HandwritingHintsQueryResultPtr HandwritingHintsQueryResult::Clone() const {
  return New(
      mojo::Clone(recognition_type),
      mojo::Clone(input_type),
      mojo::Clone(text_context),
      mojo::Clone(alternatives)
  );
}

template <typename T, HandwritingHintsQueryResult::EnableIfSame<T>*>
bool HandwritingHintsQueryResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->recognition_type, other_struct.recognition_type))
    return false;
  if (!mojo::Equals(this->input_type, other_struct.input_type))
    return false;
  if (!mojo::Equals(this->text_context, other_struct.text_context))
    return false;
  if (!mojo::Equals(this->alternatives, other_struct.alternatives))
    return false;
  return true;
}

template <typename T, HandwritingHintsQueryResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.recognition_type < rhs.recognition_type)
    return true;
  if (rhs.recognition_type < lhs.recognition_type)
    return false;
  if (lhs.input_type < rhs.input_type)
    return true;
  if (rhs.input_type < lhs.input_type)
    return false;
  if (lhs.text_context < rhs.text_context)
    return true;
  if (rhs.text_context < lhs.text_context)
    return false;
  if (lhs.alternatives < rhs.alternatives)
    return true;
  if (rhs.alternatives < lhs.alternatives)
    return false;
  return false;
}
template <typename StructPtrType>
QueryHandwritingRecognizerResultPtr QueryHandwritingRecognizerResult::Clone() const {
  return New(
      mojo::Clone(text_alternatives),
      mojo::Clone(text_segmentation),
      mojo::Clone(hints)
  );
}

template <typename T, QueryHandwritingRecognizerResult::EnableIfSame<T>*>
bool QueryHandwritingRecognizerResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->text_alternatives, other_struct.text_alternatives))
    return false;
  if (!mojo::Equals(this->text_segmentation, other_struct.text_segmentation))
    return false;
  if (!mojo::Equals(this->hints, other_struct.hints))
    return false;
  return true;
}

template <typename T, QueryHandwritingRecognizerResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.text_alternatives < rhs.text_alternatives)
    return true;
  if (rhs.text_alternatives < lhs.text_alternatives)
    return false;
  if (lhs.text_segmentation < rhs.text_segmentation)
    return true;
  if (rhs.text_segmentation < lhs.text_segmentation)
    return false;
  if (lhs.hints < rhs.hints)
    return true;
  if (rhs.hints < lhs.hints)
    return false;
  return false;
}
template <typename StructPtrType>
HandwritingModelConstraintPtr HandwritingModelConstraint::Clone() const {
  return New(
      mojo::Clone(languages)
  );
}

template <typename T, HandwritingModelConstraint::EnableIfSame<T>*>
bool HandwritingModelConstraint::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->languages, other_struct.languages))
    return false;
  return true;
}

template <typename T, HandwritingModelConstraint::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.languages < rhs.languages)
    return true;
  if (rhs.languages < lhs.languages)
    return false;
  return false;
}


}  // handwriting::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::handwriting::mojom::blink::HandwritingPoint::DataView,
                                         ::handwriting::mojom::blink::HandwritingPointPtr> {
  static bool IsNull(const ::handwriting::mojom::blink::HandwritingPointPtr& input) { return !input; }
  static void SetToNull(::handwriting::mojom::blink::HandwritingPointPtr* output) { output->reset(); }

  static const decltype(::handwriting::mojom::blink::HandwritingPoint::location)& location(
      const ::handwriting::mojom::blink::HandwritingPointPtr& input) {
    return input->location;
  }

  static const decltype(::handwriting::mojom::blink::HandwritingPoint::t)& t(
      const ::handwriting::mojom::blink::HandwritingPointPtr& input) {
    return input->t;
  }

  static bool Read(::handwriting::mojom::blink::HandwritingPoint::DataView input, ::handwriting::mojom::blink::HandwritingPointPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::handwriting::mojom::blink::HandwritingStroke::DataView,
                                         ::handwriting::mojom::blink::HandwritingStrokePtr> {
  static bool IsNull(const ::handwriting::mojom::blink::HandwritingStrokePtr& input) { return !input; }
  static void SetToNull(::handwriting::mojom::blink::HandwritingStrokePtr* output) { output->reset(); }

  static const decltype(::handwriting::mojom::blink::HandwritingStroke::points)& points(
      const ::handwriting::mojom::blink::HandwritingStrokePtr& input) {
    return input->points;
  }

  static bool Read(::handwriting::mojom::blink::HandwritingStroke::DataView input, ::handwriting::mojom::blink::HandwritingStrokePtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::handwriting::mojom::blink::HandwritingDrawingSegment::DataView,
                                         ::handwriting::mojom::blink::HandwritingDrawingSegmentPtr> {
  static bool IsNull(const ::handwriting::mojom::blink::HandwritingDrawingSegmentPtr& input) { return !input; }
  static void SetToNull(::handwriting::mojom::blink::HandwritingDrawingSegmentPtr* output) { output->reset(); }

  static decltype(::handwriting::mojom::blink::HandwritingDrawingSegment::stroke_index) stroke_index(
      const ::handwriting::mojom::blink::HandwritingDrawingSegmentPtr& input) {
    return input->stroke_index;
  }

  static decltype(::handwriting::mojom::blink::HandwritingDrawingSegment::begin_point_index) begin_point_index(
      const ::handwriting::mojom::blink::HandwritingDrawingSegmentPtr& input) {
    return input->begin_point_index;
  }

  static decltype(::handwriting::mojom::blink::HandwritingDrawingSegment::end_point_index) end_point_index(
      const ::handwriting::mojom::blink::HandwritingDrawingSegmentPtr& input) {
    return input->end_point_index;
  }

  static bool Read(::handwriting::mojom::blink::HandwritingDrawingSegment::DataView input, ::handwriting::mojom::blink::HandwritingDrawingSegmentPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::handwriting::mojom::blink::HandwritingSegment::DataView,
                                         ::handwriting::mojom::blink::HandwritingSegmentPtr> {
  static bool IsNull(const ::handwriting::mojom::blink::HandwritingSegmentPtr& input) { return !input; }
  static void SetToNull(::handwriting::mojom::blink::HandwritingSegmentPtr* output) { output->reset(); }

  static const decltype(::handwriting::mojom::blink::HandwritingSegment::grapheme)& grapheme(
      const ::handwriting::mojom::blink::HandwritingSegmentPtr& input) {
    return input->grapheme;
  }

  static decltype(::handwriting::mojom::blink::HandwritingSegment::begin_index) begin_index(
      const ::handwriting::mojom::blink::HandwritingSegmentPtr& input) {
    return input->begin_index;
  }

  static decltype(::handwriting::mojom::blink::HandwritingSegment::end_index) end_index(
      const ::handwriting::mojom::blink::HandwritingSegmentPtr& input) {
    return input->end_index;
  }

  static const decltype(::handwriting::mojom::blink::HandwritingSegment::drawing_segments)& drawing_segments(
      const ::handwriting::mojom::blink::HandwritingSegmentPtr& input) {
    return input->drawing_segments;
  }

  static bool Read(::handwriting::mojom::blink::HandwritingSegment::DataView input, ::handwriting::mojom::blink::HandwritingSegmentPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::handwriting::mojom::blink::HandwritingPrediction::DataView,
                                         ::handwriting::mojom::blink::HandwritingPredictionPtr> {
  static bool IsNull(const ::handwriting::mojom::blink::HandwritingPredictionPtr& input) { return !input; }
  static void SetToNull(::handwriting::mojom::blink::HandwritingPredictionPtr* output) { output->reset(); }

  static const decltype(::handwriting::mojom::blink::HandwritingPrediction::text)& text(
      const ::handwriting::mojom::blink::HandwritingPredictionPtr& input) {
    return input->text;
  }

  static const decltype(::handwriting::mojom::blink::HandwritingPrediction::segmentation_result)& segmentation_result(
      const ::handwriting::mojom::blink::HandwritingPredictionPtr& input) {
    return input->segmentation_result;
  }

  static bool Read(::handwriting::mojom::blink::HandwritingPrediction::DataView input, ::handwriting::mojom::blink::HandwritingPredictionPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::handwriting::mojom::blink::HandwritingHints::DataView,
                                         ::handwriting::mojom::blink::HandwritingHintsPtr> {
  static bool IsNull(const ::handwriting::mojom::blink::HandwritingHintsPtr& input) { return !input; }
  static void SetToNull(::handwriting::mojom::blink::HandwritingHintsPtr* output) { output->reset(); }

  static const decltype(::handwriting::mojom::blink::HandwritingHints::recognition_type)& recognition_type(
      const ::handwriting::mojom::blink::HandwritingHintsPtr& input) {
    return input->recognition_type;
  }

  static const decltype(::handwriting::mojom::blink::HandwritingHints::input_type)& input_type(
      const ::handwriting::mojom::blink::HandwritingHintsPtr& input) {
    return input->input_type;
  }

  static const decltype(::handwriting::mojom::blink::HandwritingHints::text_context)& text_context(
      const ::handwriting::mojom::blink::HandwritingHintsPtr& input) {
    return input->text_context;
  }

  static decltype(::handwriting::mojom::blink::HandwritingHints::alternatives) alternatives(
      const ::handwriting::mojom::blink::HandwritingHintsPtr& input) {
    return input->alternatives;
  }

  static bool Read(::handwriting::mojom::blink::HandwritingHints::DataView input, ::handwriting::mojom::blink::HandwritingHintsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::handwriting::mojom::blink::HandwritingHintsQueryResult::DataView,
                                         ::handwriting::mojom::blink::HandwritingHintsQueryResultPtr> {
  static bool IsNull(const ::handwriting::mojom::blink::HandwritingHintsQueryResultPtr& input) { return !input; }
  static void SetToNull(::handwriting::mojom::blink::HandwritingHintsQueryResultPtr* output) { output->reset(); }

  static const decltype(::handwriting::mojom::blink::HandwritingHintsQueryResult::recognition_type)& recognition_type(
      const ::handwriting::mojom::blink::HandwritingHintsQueryResultPtr& input) {
    return input->recognition_type;
  }

  static const decltype(::handwriting::mojom::blink::HandwritingHintsQueryResult::input_type)& input_type(
      const ::handwriting::mojom::blink::HandwritingHintsQueryResultPtr& input) {
    return input->input_type;
  }

  static decltype(::handwriting::mojom::blink::HandwritingHintsQueryResult::text_context) text_context(
      const ::handwriting::mojom::blink::HandwritingHintsQueryResultPtr& input) {
    return input->text_context;
  }

  static decltype(::handwriting::mojom::blink::HandwritingHintsQueryResult::alternatives) alternatives(
      const ::handwriting::mojom::blink::HandwritingHintsQueryResultPtr& input) {
    return input->alternatives;
  }

  static bool Read(::handwriting::mojom::blink::HandwritingHintsQueryResult::DataView input, ::handwriting::mojom::blink::HandwritingHintsQueryResultPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::handwriting::mojom::blink::QueryHandwritingRecognizerResult::DataView,
                                         ::handwriting::mojom::blink::QueryHandwritingRecognizerResultPtr> {
  static bool IsNull(const ::handwriting::mojom::blink::QueryHandwritingRecognizerResultPtr& input) { return !input; }
  static void SetToNull(::handwriting::mojom::blink::QueryHandwritingRecognizerResultPtr* output) { output->reset(); }

  static decltype(::handwriting::mojom::blink::QueryHandwritingRecognizerResult::text_alternatives) text_alternatives(
      const ::handwriting::mojom::blink::QueryHandwritingRecognizerResultPtr& input) {
    return input->text_alternatives;
  }

  static decltype(::handwriting::mojom::blink::QueryHandwritingRecognizerResult::text_segmentation) text_segmentation(
      const ::handwriting::mojom::blink::QueryHandwritingRecognizerResultPtr& input) {
    return input->text_segmentation;
  }

  static const decltype(::handwriting::mojom::blink::QueryHandwritingRecognizerResult::hints)& hints(
      const ::handwriting::mojom::blink::QueryHandwritingRecognizerResultPtr& input) {
    return input->hints;
  }

  static bool Read(::handwriting::mojom::blink::QueryHandwritingRecognizerResult::DataView input, ::handwriting::mojom::blink::QueryHandwritingRecognizerResultPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::handwriting::mojom::blink::HandwritingModelConstraint::DataView,
                                         ::handwriting::mojom::blink::HandwritingModelConstraintPtr> {
  static bool IsNull(const ::handwriting::mojom::blink::HandwritingModelConstraintPtr& input) { return !input; }
  static void SetToNull(::handwriting::mojom::blink::HandwritingModelConstraintPtr* output) { output->reset(); }

  static const decltype(::handwriting::mojom::blink::HandwritingModelConstraint::languages)& languages(
      const ::handwriting::mojom::blink::HandwritingModelConstraintPtr& input) {
    return input->languages;
  }

  static bool Read(::handwriting::mojom::blink::HandwritingModelConstraint::DataView input, ::handwriting::mojom::blink::HandwritingModelConstraintPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_HANDWRITING_HANDWRITING_MOJOM_BLINK_H_