// third_party/blink/public/mojom/gpu/gpu.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('url.mojom.Url');






goog.provide('blink.mojom.GpuDataManager');
goog.provide('blink.mojom.GpuDataManagerReceiver');
goog.provide('blink.mojom.GpuDataManagerCallbackRouter');
goog.provide('blink.mojom.GpuDataManagerInterface');
goog.provide('blink.mojom.GpuDataManagerRemote');
goog.provide('blink.mojom.GpuDataManagerPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.GpuDataManagerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.GpuDataManager.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.GpuDataManagerInterface = class {
  
  /**
   * @param { !url.mojom.Url } url
   * @return {!Promise<{
        blocked: !boolean,
   *  }>}
   */

  are3DAPIsBlockedForUrl(url) {}
};

/**
 * @export
 * @implements { blink.mojom.GpuDataManagerInterface }
 */
blink.mojom.GpuDataManagerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.GpuDataManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.GpuDataManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.GpuDataManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @return {!Promise<{
        blocked: !boolean,
   *  }>}
   */

  are3DAPIsBlockedForUrl(
      url) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.GpuDataManager_Are3DAPIsBlockedForUrl_ParamsSpec.$,
        blink.mojom.GpuDataManager_Are3DAPIsBlockedForUrl_ResponseParamsSpec.$,
        [
          url
        ],
        false);
  }
};

/**
 * An object which receives request messages for the GpuDataManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.GpuDataManagerReceiver = class {
  /**
   * @param {!blink.mojom.GpuDataManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.GpuDataManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.GpuDataManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.GpuDataManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.GpuDataManager_Are3DAPIsBlockedForUrl_ParamsSpec.$,
        blink.mojom.GpuDataManager_Are3DAPIsBlockedForUrl_ResponseParamsSpec.$,
        impl.are3DAPIsBlockedForUrl.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.GpuDataManager = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.GpuDataManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.GpuDataManagerRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.GpuDataManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the GpuDataManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.GpuDataManagerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.GpuDataManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.GpuDataManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.are3DAPIsBlockedForUrl =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.GpuDataManager_Are3DAPIsBlockedForUrl_ParamsSpec.$,
        blink.mojom.GpuDataManager_Are3DAPIsBlockedForUrl_ResponseParamsSpec.$,
        this.are3DAPIsBlockedForUrl.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.GpuDataManager_Are3DAPIsBlockedForUrl_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.GpuDataManager_Are3DAPIsBlockedForUrl_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.GpuDataManager_Are3DAPIsBlockedForUrl_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.GpuDataManager_Are3DAPIsBlockedForUrl_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.GpuDataManager_Are3DAPIsBlockedForUrl_ParamsSpec.$,
    'GpuDataManager_Are3DAPIsBlockedForUrl_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.GpuDataManager_Are3DAPIsBlockedForUrl_Params');

/** @record */
blink.mojom.GpuDataManager_Are3DAPIsBlockedForUrl_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
  }
};



mojo.internal.Struct(
    blink.mojom.GpuDataManager_Are3DAPIsBlockedForUrl_ResponseParamsSpec.$,
    'GpuDataManager_Are3DAPIsBlockedForUrl_ResponseParams',
    [
      mojo.internal.StructField(
        'blocked', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.GpuDataManager_Are3DAPIsBlockedForUrl_ResponseParams');

/** @record */
blink.mojom.GpuDataManager_Are3DAPIsBlockedForUrl_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.blocked;
  }
};

