// third_party/blink/public/mojom/frame/viewport_intersection_state.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_VIEWPORT_INTERSECTION_STATE_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_VIEWPORT_INTERSECTION_STATE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/frame/viewport_intersection_state.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/transform.mojom-shared.h"


namespace blink::mojom {
class ViewportIntersectionStateDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::ViewportIntersectionStateDataView> {
  using Data = ::blink::mojom::internal::ViewportIntersectionState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class FrameOcclusionState : int32_t {
  
  kUnknown = 0,
  
  kPossiblyOccluded = 1,
  
  kGuaranteedNotOccluded = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, FrameOcclusionState value);
inline bool IsKnownEnumValue(FrameOcclusionState value) {
  return internal::FrameOcclusionState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class ViewportIntersectionStateDataView {
 public:
  ViewportIntersectionStateDataView() = default;

  ViewportIntersectionStateDataView(
      internal::ViewportIntersectionState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetViewportIntersectionDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViewportIntersection(UserType* output) {
    
    auto* pointer = data_->viewport_intersection.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetMainFrameIntersectionDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMainFrameIntersection(UserType* output) {
    
    auto* pointer = data_->main_frame_intersection.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetCompositorVisibleRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCompositorVisibleRect(UserType* output) {
    
    auto* pointer = data_->compositor_visible_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadOcclusionState(UserType* output) const {
    auto data_value = data_->occlusion_state;
    return mojo::internal::Deserialize<::blink::mojom::FrameOcclusionState>(
        data_value, output);
  }
  FrameOcclusionState occlusion_state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::FrameOcclusionState>(data_->occlusion_state));
  }
  inline void GetOutermostMainFrameSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutermostMainFrameSize(UserType* output) {
    
    auto* pointer = data_->outermost_main_frame_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetOutermostMainFrameScrollPositionDataView(
      ::gfx::mojom::PointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutermostMainFrameScrollPosition(UserType* output) {
    
    auto* pointer = data_->outermost_main_frame_scroll_position.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointDataView>(
        pointer, output, message_);
  }
  inline void GetMainFrameTransformDataView(
      ::gfx::mojom::TransformDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMainFrameTransform(UserType* output) {
    
    auto* pointer = data_->main_frame_transform.Get();
    return mojo::internal::Deserialize<::gfx::mojom::TransformDataView>(
        pointer, output, message_);
  }
 private:
  internal::ViewportIntersectionState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_VIEWPORT_INTERSECTION_STATE_MOJOM_DATA_VIEW_H_