// third_party/blink/public/mojom/frame/view_transition_state.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/frame/view_transition_state.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var view_transition_element_resource_id$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/view_transition_element_resource_id.mojom', '../../../../../services/viz/public/mojom/compositing/view_transition_element_resource_id.mojom.js');
  }
  var tokens$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/tokens/tokens.mojom', '../tokens/tokens.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }
  var transform$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/mojom/transform.mojom', '../../../../../ui/gfx/mojom/transform.mojom.js');
  }


  var ViewTransitionPropertyId = {};
  ViewTransitionPropertyId.kBackdropFilter = 0;
  ViewTransitionPropertyId.kBorderRadius = 1;
  ViewTransitionPropertyId.kBorderWidth = 2;
  ViewTransitionPropertyId.kColorScheme = 3;
  ViewTransitionPropertyId.kCornerShape = 4;
  ViewTransitionPropertyId.kMixBlendMode = 5;
  ViewTransitionPropertyId.kTextOrientation = 6;
  ViewTransitionPropertyId.kWritingMode = 7;
  ViewTransitionPropertyId.MIN_VALUE = 0;
  ViewTransitionPropertyId.MAX_VALUE = 7;

  ViewTransitionPropertyId.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
      return true;
    }
    return false;
  };

  ViewTransitionPropertyId.toKnownEnumValue = function(value) {
    return value;
  };

  ViewTransitionPropertyId.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var ViewTransitionElementBoxSizing = {};
  ViewTransitionElementBoxSizing.kBorderBox = 0;
  ViewTransitionElementBoxSizing.kContentBox = 1;
  ViewTransitionElementBoxSizing.MIN_VALUE = 0;
  ViewTransitionElementBoxSizing.MAX_VALUE = 1;

  ViewTransitionElementBoxSizing.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  ViewTransitionElementBoxSizing.toKnownEnumValue = function(value) {
    return value;
  };

  ViewTransitionElementBoxSizing.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function ViewTransitionElementLayeredBoxProperties(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ViewTransitionElementLayeredBoxProperties.prototype.initDefaults_ = function() {
    this.contentBox = null;
    this.paddingBox = null;
    this.boxSizing = 0;
  };
  ViewTransitionElementLayeredBoxProperties.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ViewTransitionElementLayeredBoxProperties.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ViewTransitionElementLayeredBoxProperties.contentBox
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.RectF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ViewTransitionElementLayeredBoxProperties.paddingBox
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.RectF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ViewTransitionElementLayeredBoxProperties.boxSizing
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, ViewTransitionElementBoxSizing);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ViewTransitionElementLayeredBoxProperties.encodedSize = codec.kStructHeaderSize + 24;

  ViewTransitionElementLayeredBoxProperties.decode = function(decoder) {
    var packed;
    var val = new ViewTransitionElementLayeredBoxProperties();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.contentBox =
        decoder.decodeStructPointer(geometry$.RectF);
    val.paddingBox =
        decoder.decodeStructPointer(geometry$.RectF);
    val.boxSizing =
        decoder.decodeStruct(new codec.Enum(ViewTransitionElementBoxSizing));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ViewTransitionElementLayeredBoxProperties.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ViewTransitionElementLayeredBoxProperties.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.RectF, val.contentBox);
    encoder.encodeStructPointer(geometry$.RectF, val.paddingBox);
    encoder.encodeStruct(codec.Int32, val.boxSizing);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ViewTransitionElement(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ViewTransitionElement.prototype.initDefaults_ = function() {
    this.tagName = null;
    this.borderBoxRectInEnclosingLayerCssSpace = null;
    this.viewportMatrix = null;
    this.overflowRectInLayoutSpace = null;
    this.capturedRectInLayoutSpace = null;
    this.snapshotId = null;
    this.paintOrder = 0;
    this.capturedCssProperties = null;
    this.groupChildrenCssProperties = null;
    this.borderOffset = null;
    this.classList = null;
    this.containingGroupName = null;
    this.layeredBoxProperties = null;
  };
  ViewTransitionElement.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ViewTransitionElement.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 112}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ViewTransitionElement.tagName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ViewTransitionElement.borderBoxRectInEnclosingLayerCssSpace
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.RectF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ViewTransitionElement.viewportMatrix
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, transform$.Transform, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ViewTransitionElement.overflowRectInLayoutSpace
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, geometry$.RectF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ViewTransitionElement.capturedRectInLayoutSpace
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, geometry$.RectF, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ViewTransitionElement.snapshotId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, view_transition_element_resource_id$.ViewTransitionElementResourceId, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate ViewTransitionElement.capturedCssProperties
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 56, false, new codec.Enum(ViewTransitionPropertyId), codec.String, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ViewTransitionElement.groupChildrenCssProperties
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 64, false, new codec.Enum(ViewTransitionPropertyId), codec.String, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ViewTransitionElement.borderOffset
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 72, geometry$.Vector2d, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ViewTransitionElement.classList
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 80, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ViewTransitionElement.containingGroupName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 88, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ViewTransitionElement.layeredBoxProperties
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 96, ViewTransitionElementLayeredBoxProperties, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ViewTransitionElement.encodedSize = codec.kStructHeaderSize + 104;

  ViewTransitionElement.decode = function(decoder) {
    var packed;
    var val = new ViewTransitionElement();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.tagName =
        decoder.decodeStruct(codec.String);
    val.borderBoxRectInEnclosingLayerCssSpace =
        decoder.decodeStructPointer(geometry$.RectF);
    val.viewportMatrix =
        decoder.decodeStructPointer(transform$.Transform);
    val.overflowRectInLayoutSpace =
        decoder.decodeStructPointer(geometry$.RectF);
    val.capturedRectInLayoutSpace =
        decoder.decodeStructPointer(geometry$.RectF);
    val.snapshotId =
        decoder.decodeStructPointer(view_transition_element_resource_id$.ViewTransitionElementResourceId);
    val.paintOrder =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.capturedCssProperties =
        decoder.decodeMapPointer(new codec.Enum(ViewTransitionPropertyId), codec.String);
    val.groupChildrenCssProperties =
        decoder.decodeMapPointer(new codec.Enum(ViewTransitionPropertyId), codec.String);
    val.borderOffset =
        decoder.decodeStructPointer(geometry$.Vector2d);
    val.classList =
        decoder.decodeArrayPointer(codec.String);
    val.containingGroupName =
        decoder.decodeStruct(codec.String);
    val.layeredBoxProperties =
        decoder.decodeStructPointer(ViewTransitionElementLayeredBoxProperties);
    return val;
  };

  ViewTransitionElement.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ViewTransitionElement.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.tagName);
    encoder.encodeStructPointer(geometry$.RectF, val.borderBoxRectInEnclosingLayerCssSpace);
    encoder.encodeStructPointer(transform$.Transform, val.viewportMatrix);
    encoder.encodeStructPointer(geometry$.RectF, val.overflowRectInLayoutSpace);
    encoder.encodeStructPointer(geometry$.RectF, val.capturedRectInLayoutSpace);
    encoder.encodeStructPointer(view_transition_element_resource_id$.ViewTransitionElementResourceId, val.snapshotId);
    encoder.encodeStruct(codec.Int32, val.paintOrder);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeMapPointer(new codec.Enum(ViewTransitionPropertyId), codec.String, val.capturedCssProperties);
    encoder.encodeMapPointer(new codec.Enum(ViewTransitionPropertyId), codec.String, val.groupChildrenCssProperties);
    encoder.encodeStructPointer(geometry$.Vector2d, val.borderOffset);
    encoder.encodeArrayPointer(codec.String, val.classList);
    encoder.encodeStruct(codec.String, val.containingGroupName);
    encoder.encodeStructPointer(ViewTransitionElementLayeredBoxProperties, val.layeredBoxProperties);
  };
  function ViewTransitionState(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ViewTransitionState.prototype.initDefaults_ = function() {
    this.elements = null;
    this.transitionToken = null;
    this.snapshotRootSizeAtCapture = null;
    this.devicePixelRatio = 0;
    this.nextElementResourceId = 0;
    this.subframeSnapshotId = null;
    this.idToAutoNameMap = null;
  };
  ViewTransitionState.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ViewTransitionState.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ViewTransitionState.elements
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(ViewTransitionElement), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ViewTransitionState.transitionToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, tokens$.ViewTransitionToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ViewTransitionState.snapshotRootSizeAtCapture
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;




    // validate ViewTransitionState.subframeSnapshotId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, view_transition_element_resource_id$.ViewTransitionElementResourceId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ViewTransitionState.idToAutoNameMap
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 40, false, codec.String, codec.String, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ViewTransitionState.encodedSize = codec.kStructHeaderSize + 48;

  ViewTransitionState.decode = function(decoder) {
    var packed;
    var val = new ViewTransitionState();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.elements =
        decoder.decodeArrayPointer(new codec.PointerTo(ViewTransitionElement));
    val.transitionToken =
        decoder.decodeStructPointer(tokens$.ViewTransitionToken);
    val.snapshotRootSizeAtCapture =
        decoder.decodeStructPointer(geometry$.Size);
    val.devicePixelRatio =
        decoder.decodeStruct(codec.Float);
    val.nextElementResourceId =
        decoder.decodeStruct(codec.Uint32);
    val.subframeSnapshotId =
        decoder.decodeStructPointer(view_transition_element_resource_id$.ViewTransitionElementResourceId);
    val.idToAutoNameMap =
        decoder.decodeMapPointer(codec.String, codec.String);
    return val;
  };

  ViewTransitionState.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ViewTransitionState.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(ViewTransitionElement), val.elements);
    encoder.encodeStructPointer(tokens$.ViewTransitionToken, val.transitionToken);
    encoder.encodeStructPointer(geometry$.Size, val.snapshotRootSizeAtCapture);
    encoder.encodeStruct(codec.Float, val.devicePixelRatio);
    encoder.encodeStruct(codec.Uint32, val.nextElementResourceId);
    encoder.encodeStructPointer(view_transition_element_resource_id$.ViewTransitionElementResourceId, val.subframeSnapshotId);
    encoder.encodeMapPointer(codec.String, codec.String, val.idToAutoNameMap);
  };
  exports.ViewTransitionPropertyId = ViewTransitionPropertyId;
  exports.ViewTransitionElementBoxSizing = ViewTransitionElementBoxSizing;
  exports.ViewTransitionElementLayeredBoxProperties = ViewTransitionElementLayeredBoxProperties;
  exports.ViewTransitionElement = ViewTransitionElement;
  exports.ViewTransitionState = ViewTransitionState;
})();