// third_party/blink/public/mojom/frame/view_transition_state.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_VIEW_TRANSITION_STATE_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_VIEW_TRANSITION_STATE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/frame/view_transition_state.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/frame/view_transition_state.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/frame/view_transition_state.mojom-forward.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/view_transition_element_resource_id.mojom.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/mojom/transform.mojom.h"
#include <string>
#include <vector>




#include "third_party/blink/public/common/frame/view_transition_state.h"
#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {










class BLINK_COMMON_EXPORT ViewTransitionElementLayeredBoxProperties {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ViewTransitionElementLayeredBoxProperties, T>::value>;
  using DataView = ViewTransitionElementLayeredBoxPropertiesDataView;
  using Data_ = internal::ViewTransitionElementLayeredBoxProperties_Data;

  template <typename... Args>
  static ViewTransitionElementLayeredBoxPropertiesPtr New(Args&&... args) {
    return ViewTransitionElementLayeredBoxPropertiesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ViewTransitionElementLayeredBoxPropertiesPtr From(const U& u) {
    return mojo::TypeConverter<ViewTransitionElementLayeredBoxPropertiesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ViewTransitionElementLayeredBoxProperties>::Convert(*this);
  }


  ViewTransitionElementLayeredBoxProperties();

  ViewTransitionElementLayeredBoxProperties(
      const ::gfx::RectF& content_box,
      const ::gfx::RectF& padding_box,
      ViewTransitionElementBoxSizing box_sizing);


  ~ViewTransitionElementLayeredBoxProperties();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ViewTransitionElementLayeredBoxPropertiesPtr>
  ViewTransitionElementLayeredBoxPropertiesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ViewTransitionElementLayeredBoxProperties::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ViewTransitionElementLayeredBoxProperties::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ViewTransitionElementLayeredBoxProperties::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ViewTransitionElementLayeredBoxProperties::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ViewTransitionElementLayeredBoxProperties::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ViewTransitionElementLayeredBoxProperties::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ViewTransitionElementLayeredBoxProperties_UnserializedMessageContext<
            UserType, ViewTransitionElementLayeredBoxProperties::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ViewTransitionElementLayeredBoxProperties::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ViewTransitionElementLayeredBoxProperties::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ViewTransitionElementLayeredBoxProperties_UnserializedMessageContext<
            UserType, ViewTransitionElementLayeredBoxProperties::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ViewTransitionElementLayeredBoxProperties::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::RectF content_box;
  
  ::gfx::RectF padding_box;
  
  ViewTransitionElementBoxSizing box_sizing;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ViewTransitionElementLayeredBoxProperties::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ViewTransitionElementLayeredBoxProperties::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ViewTransitionElementLayeredBoxProperties::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ViewTransitionElementLayeredBoxProperties::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT ViewTransitionElement {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ViewTransitionElement, T>::value>;
  using DataView = ViewTransitionElementDataView;
  using Data_ = internal::ViewTransitionElement_Data;

  template <typename... Args>
  static ViewTransitionElementPtr New(Args&&... args) {
    return ViewTransitionElementPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ViewTransitionElementPtr From(const U& u) {
    return mojo::TypeConverter<ViewTransitionElementPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ViewTransitionElement>::Convert(*this);
  }


  ViewTransitionElement();

  ViewTransitionElement(
      const std::string& tag_name,
      const ::gfx::RectF& border_box_rect_in_enclosing_layer_css_space,
      const ::gfx::Transform& viewport_matrix,
      const ::gfx::RectF& overflow_rect_in_layout_space,
      const std::optional<::gfx::RectF>& captured_rect_in_layout_space,
      const ::viz::ViewTransitionElementResourceId& snapshot_id,
      int32_t paint_order,
      const base::flat_map<ViewTransitionPropertyId, std::string>& captured_css_properties,
      const base::flat_map<ViewTransitionPropertyId, std::string>& group_children_css_properties,
      const ::gfx::Vector2d& border_offset,
      std::vector<std::string> class_list,
      const std::string& containing_group_name,
      ViewTransitionElementLayeredBoxPropertiesPtr layered_box_properties);

ViewTransitionElement(const ViewTransitionElement&) = delete;
ViewTransitionElement& operator=(const ViewTransitionElement&) = delete;

  ~ViewTransitionElement();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ViewTransitionElementPtr>
  ViewTransitionElementPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ViewTransitionElement::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ViewTransitionElement::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ViewTransitionElement::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ViewTransitionElement::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ViewTransitionElement::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ViewTransitionElement::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ViewTransitionElement_UnserializedMessageContext<
            UserType, ViewTransitionElement::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ViewTransitionElement::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ViewTransitionElement::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ViewTransitionElement_UnserializedMessageContext<
            UserType, ViewTransitionElement::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ViewTransitionElement::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string tag_name;
  
  ::gfx::RectF border_box_rect_in_enclosing_layer_css_space;
  
  ::gfx::Transform viewport_matrix;
  
  ::gfx::RectF overflow_rect_in_layout_space;
  
  std::optional<::gfx::RectF> captured_rect_in_layout_space;
  
  ::viz::ViewTransitionElementResourceId snapshot_id;
  
  int32_t paint_order;
  
  base::flat_map<ViewTransitionPropertyId, std::string> captured_css_properties;
  
  base::flat_map<ViewTransitionPropertyId, std::string> group_children_css_properties;
  
  ::gfx::Vector2d border_offset;
  
  std::vector<std::string> class_list;
  
  std::string containing_group_name;
  
  ViewTransitionElementLayeredBoxPropertiesPtr layered_box_properties;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ViewTransitionElement::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ViewTransitionElement::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ViewTransitionElement::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ViewTransitionElement::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT ViewTransitionState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ViewTransitionState, T>::value>;
  using DataView = ViewTransitionStateDataView;
  using Data_ = internal::ViewTransitionState_Data;

  template <typename... Args>
  static ViewTransitionStatePtr New(Args&&... args) {
    return ViewTransitionStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ViewTransitionStatePtr From(const U& u) {
    return mojo::TypeConverter<ViewTransitionStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ViewTransitionState>::Convert(*this);
  }


  ViewTransitionState();

  ViewTransitionState(
      std::vector<::blink::ViewTransitionElement> elements,
      const ::blink::ViewTransitionToken& transition_token,
      const ::gfx::Size& snapshot_root_size_at_capture,
      float device_pixel_ratio,
      uint32_t next_element_resource_id,
      const ::viz::ViewTransitionElementResourceId& subframe_snapshot_id,
      const base::flat_map<std::string, std::string>& id_to_auto_name_map);


  ~ViewTransitionState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ViewTransitionStatePtr>
  ViewTransitionStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ViewTransitionState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ViewTransitionState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ViewTransitionState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ViewTransitionState::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ViewTransitionState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ViewTransitionState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ViewTransitionState_UnserializedMessageContext<
            UserType, ViewTransitionState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ViewTransitionState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ViewTransitionState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ViewTransitionState_UnserializedMessageContext<
            UserType, ViewTransitionState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ViewTransitionState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<::blink::ViewTransitionElement> elements;
  
  ::blink::ViewTransitionToken transition_token;
  
  ::gfx::Size snapshot_root_size_at_capture;
  
  float device_pixel_ratio;
  
  uint32_t next_element_resource_id;
  
  ::viz::ViewTransitionElementResourceId subframe_snapshot_id;
  
  base::flat_map<std::string, std::string> id_to_auto_name_map;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ViewTransitionState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ViewTransitionState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ViewTransitionState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ViewTransitionState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ViewTransitionElementLayeredBoxPropertiesPtr ViewTransitionElementLayeredBoxProperties::Clone() const {
  return New(
      mojo::Clone(content_box),
      mojo::Clone(padding_box),
      mojo::Clone(box_sizing)
  );
}

template <typename T, ViewTransitionElementLayeredBoxProperties::EnableIfSame<T>*>
bool ViewTransitionElementLayeredBoxProperties::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->content_box, other_struct.content_box))
    return false;
  if (!mojo::Equals(this->padding_box, other_struct.padding_box))
    return false;
  if (!mojo::Equals(this->box_sizing, other_struct.box_sizing))
    return false;
  return true;
}

template <typename T, ViewTransitionElementLayeredBoxProperties::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.content_box < rhs.content_box)
    return true;
  if (rhs.content_box < lhs.content_box)
    return false;
  if (lhs.padding_box < rhs.padding_box)
    return true;
  if (rhs.padding_box < lhs.padding_box)
    return false;
  if (lhs.box_sizing < rhs.box_sizing)
    return true;
  if (rhs.box_sizing < lhs.box_sizing)
    return false;
  return false;
}
template <typename StructPtrType>
ViewTransitionElementPtr ViewTransitionElement::Clone() const {
  return New(
      mojo::Clone(tag_name),
      mojo::Clone(border_box_rect_in_enclosing_layer_css_space),
      mojo::Clone(viewport_matrix),
      mojo::Clone(overflow_rect_in_layout_space),
      mojo::Clone(captured_rect_in_layout_space),
      mojo::Clone(snapshot_id),
      mojo::Clone(paint_order),
      mojo::Clone(captured_css_properties),
      mojo::Clone(group_children_css_properties),
      mojo::Clone(border_offset),
      mojo::Clone(class_list),
      mojo::Clone(containing_group_name),
      mojo::Clone(layered_box_properties)
  );
}

template <typename T, ViewTransitionElement::EnableIfSame<T>*>
bool ViewTransitionElement::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->tag_name, other_struct.tag_name))
    return false;
  if (!mojo::Equals(this->border_box_rect_in_enclosing_layer_css_space, other_struct.border_box_rect_in_enclosing_layer_css_space))
    return false;
  if (!mojo::Equals(this->viewport_matrix, other_struct.viewport_matrix))
    return false;
  if (!mojo::Equals(this->overflow_rect_in_layout_space, other_struct.overflow_rect_in_layout_space))
    return false;
  if (!mojo::Equals(this->captured_rect_in_layout_space, other_struct.captured_rect_in_layout_space))
    return false;
  if (!mojo::Equals(this->snapshot_id, other_struct.snapshot_id))
    return false;
  if (!mojo::Equals(this->paint_order, other_struct.paint_order))
    return false;
  if (!mojo::Equals(this->captured_css_properties, other_struct.captured_css_properties))
    return false;
  if (!mojo::Equals(this->group_children_css_properties, other_struct.group_children_css_properties))
    return false;
  if (!mojo::Equals(this->border_offset, other_struct.border_offset))
    return false;
  if (!mojo::Equals(this->class_list, other_struct.class_list))
    return false;
  if (!mojo::Equals(this->containing_group_name, other_struct.containing_group_name))
    return false;
  if (!mojo::Equals(this->layered_box_properties, other_struct.layered_box_properties))
    return false;
  return true;
}

template <typename T, ViewTransitionElement::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.tag_name < rhs.tag_name)
    return true;
  if (rhs.tag_name < lhs.tag_name)
    return false;
  if (lhs.border_box_rect_in_enclosing_layer_css_space < rhs.border_box_rect_in_enclosing_layer_css_space)
    return true;
  if (rhs.border_box_rect_in_enclosing_layer_css_space < lhs.border_box_rect_in_enclosing_layer_css_space)
    return false;
  if (lhs.viewport_matrix < rhs.viewport_matrix)
    return true;
  if (rhs.viewport_matrix < lhs.viewport_matrix)
    return false;
  if (lhs.overflow_rect_in_layout_space < rhs.overflow_rect_in_layout_space)
    return true;
  if (rhs.overflow_rect_in_layout_space < lhs.overflow_rect_in_layout_space)
    return false;
  if (lhs.captured_rect_in_layout_space < rhs.captured_rect_in_layout_space)
    return true;
  if (rhs.captured_rect_in_layout_space < lhs.captured_rect_in_layout_space)
    return false;
  if (lhs.snapshot_id < rhs.snapshot_id)
    return true;
  if (rhs.snapshot_id < lhs.snapshot_id)
    return false;
  if (lhs.paint_order < rhs.paint_order)
    return true;
  if (rhs.paint_order < lhs.paint_order)
    return false;
  if (lhs.captured_css_properties < rhs.captured_css_properties)
    return true;
  if (rhs.captured_css_properties < lhs.captured_css_properties)
    return false;
  if (lhs.group_children_css_properties < rhs.group_children_css_properties)
    return true;
  if (rhs.group_children_css_properties < lhs.group_children_css_properties)
    return false;
  if (lhs.border_offset < rhs.border_offset)
    return true;
  if (rhs.border_offset < lhs.border_offset)
    return false;
  if (lhs.class_list < rhs.class_list)
    return true;
  if (rhs.class_list < lhs.class_list)
    return false;
  if (lhs.containing_group_name < rhs.containing_group_name)
    return true;
  if (rhs.containing_group_name < lhs.containing_group_name)
    return false;
  if (lhs.layered_box_properties < rhs.layered_box_properties)
    return true;
  if (rhs.layered_box_properties < lhs.layered_box_properties)
    return false;
  return false;
}
template <typename StructPtrType>
ViewTransitionStatePtr ViewTransitionState::Clone() const {
  return New(
      mojo::Clone(elements),
      mojo::Clone(transition_token),
      mojo::Clone(snapshot_root_size_at_capture),
      mojo::Clone(device_pixel_ratio),
      mojo::Clone(next_element_resource_id),
      mojo::Clone(subframe_snapshot_id),
      mojo::Clone(id_to_auto_name_map)
  );
}

template <typename T, ViewTransitionState::EnableIfSame<T>*>
bool ViewTransitionState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->elements, other_struct.elements))
    return false;
  if (!mojo::Equals(this->transition_token, other_struct.transition_token))
    return false;
  if (!mojo::Equals(this->snapshot_root_size_at_capture, other_struct.snapshot_root_size_at_capture))
    return false;
  if (!mojo::Equals(this->device_pixel_ratio, other_struct.device_pixel_ratio))
    return false;
  if (!mojo::Equals(this->next_element_resource_id, other_struct.next_element_resource_id))
    return false;
  if (!mojo::Equals(this->subframe_snapshot_id, other_struct.subframe_snapshot_id))
    return false;
  if (!mojo::Equals(this->id_to_auto_name_map, other_struct.id_to_auto_name_map))
    return false;
  return true;
}

template <typename T, ViewTransitionState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.elements < rhs.elements)
    return true;
  if (rhs.elements < lhs.elements)
    return false;
  if (lhs.transition_token < rhs.transition_token)
    return true;
  if (rhs.transition_token < lhs.transition_token)
    return false;
  if (lhs.snapshot_root_size_at_capture < rhs.snapshot_root_size_at_capture)
    return true;
  if (rhs.snapshot_root_size_at_capture < lhs.snapshot_root_size_at_capture)
    return false;
  if (lhs.device_pixel_ratio < rhs.device_pixel_ratio)
    return true;
  if (rhs.device_pixel_ratio < lhs.device_pixel_ratio)
    return false;
  if (lhs.next_element_resource_id < rhs.next_element_resource_id)
    return true;
  if (rhs.next_element_resource_id < lhs.next_element_resource_id)
    return false;
  if (lhs.subframe_snapshot_id < rhs.subframe_snapshot_id)
    return true;
  if (rhs.subframe_snapshot_id < lhs.subframe_snapshot_id)
    return false;
  if (lhs.id_to_auto_name_map < rhs.id_to_auto_name_map)
    return true;
  if (rhs.id_to_auto_name_map < lhs.id_to_auto_name_map)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ViewTransitionElementLayeredBoxProperties::DataView,
                                         ::blink::mojom::ViewTransitionElementLayeredBoxPropertiesPtr> {
  static bool IsNull(const ::blink::mojom::ViewTransitionElementLayeredBoxPropertiesPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ViewTransitionElementLayeredBoxPropertiesPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ViewTransitionElementLayeredBoxProperties::content_box)& content_box(
      const ::blink::mojom::ViewTransitionElementLayeredBoxPropertiesPtr& input) {
    return input->content_box;
  }

  static const decltype(::blink::mojom::ViewTransitionElementLayeredBoxProperties::padding_box)& padding_box(
      const ::blink::mojom::ViewTransitionElementLayeredBoxPropertiesPtr& input) {
    return input->padding_box;
  }

  static decltype(::blink::mojom::ViewTransitionElementLayeredBoxProperties::box_sizing) box_sizing(
      const ::blink::mojom::ViewTransitionElementLayeredBoxPropertiesPtr& input) {
    return input->box_sizing;
  }

  static bool Read(::blink::mojom::ViewTransitionElementLayeredBoxProperties::DataView input, ::blink::mojom::ViewTransitionElementLayeredBoxPropertiesPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ViewTransitionElement::DataView,
                                         ::blink::mojom::ViewTransitionElementPtr> {
  static bool IsNull(const ::blink::mojom::ViewTransitionElementPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ViewTransitionElementPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ViewTransitionElement::tag_name)& tag_name(
      const ::blink::mojom::ViewTransitionElementPtr& input) {
    return input->tag_name;
  }

  static const decltype(::blink::mojom::ViewTransitionElement::border_box_rect_in_enclosing_layer_css_space)& border_box_rect_in_enclosing_layer_css_space(
      const ::blink::mojom::ViewTransitionElementPtr& input) {
    return input->border_box_rect_in_enclosing_layer_css_space;
  }

  static const decltype(::blink::mojom::ViewTransitionElement::viewport_matrix)& viewport_matrix(
      const ::blink::mojom::ViewTransitionElementPtr& input) {
    return input->viewport_matrix;
  }

  static const decltype(::blink::mojom::ViewTransitionElement::overflow_rect_in_layout_space)& overflow_rect_in_layout_space(
      const ::blink::mojom::ViewTransitionElementPtr& input) {
    return input->overflow_rect_in_layout_space;
  }

  static const decltype(::blink::mojom::ViewTransitionElement::captured_rect_in_layout_space)& captured_rect_in_layout_space(
      const ::blink::mojom::ViewTransitionElementPtr& input) {
    return input->captured_rect_in_layout_space;
  }

  static const decltype(::blink::mojom::ViewTransitionElement::snapshot_id)& snapshot_id(
      const ::blink::mojom::ViewTransitionElementPtr& input) {
    return input->snapshot_id;
  }

  static decltype(::blink::mojom::ViewTransitionElement::paint_order) paint_order(
      const ::blink::mojom::ViewTransitionElementPtr& input) {
    return input->paint_order;
  }

  static const decltype(::blink::mojom::ViewTransitionElement::captured_css_properties)& captured_css_properties(
      const ::blink::mojom::ViewTransitionElementPtr& input) {
    return input->captured_css_properties;
  }

  static const decltype(::blink::mojom::ViewTransitionElement::group_children_css_properties)& group_children_css_properties(
      const ::blink::mojom::ViewTransitionElementPtr& input) {
    return input->group_children_css_properties;
  }

  static const decltype(::blink::mojom::ViewTransitionElement::border_offset)& border_offset(
      const ::blink::mojom::ViewTransitionElementPtr& input) {
    return input->border_offset;
  }

  static const decltype(::blink::mojom::ViewTransitionElement::class_list)& class_list(
      const ::blink::mojom::ViewTransitionElementPtr& input) {
    return input->class_list;
  }

  static const decltype(::blink::mojom::ViewTransitionElement::containing_group_name)& containing_group_name(
      const ::blink::mojom::ViewTransitionElementPtr& input) {
    return input->containing_group_name;
  }

  static const decltype(::blink::mojom::ViewTransitionElement::layered_box_properties)& layered_box_properties(
      const ::blink::mojom::ViewTransitionElementPtr& input) {
    return input->layered_box_properties;
  }

  static bool Read(::blink::mojom::ViewTransitionElement::DataView input, ::blink::mojom::ViewTransitionElementPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ViewTransitionState::DataView,
                                         ::blink::mojom::ViewTransitionStatePtr> {
  static bool IsNull(const ::blink::mojom::ViewTransitionStatePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ViewTransitionStatePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::ViewTransitionState::elements)& elements(
      const ::blink::mojom::ViewTransitionStatePtr& input) {
    return input->elements;
  }

  static const decltype(::blink::mojom::ViewTransitionState::transition_token)& transition_token(
      const ::blink::mojom::ViewTransitionStatePtr& input) {
    return input->transition_token;
  }

  static const decltype(::blink::mojom::ViewTransitionState::snapshot_root_size_at_capture)& snapshot_root_size_at_capture(
      const ::blink::mojom::ViewTransitionStatePtr& input) {
    return input->snapshot_root_size_at_capture;
  }

  static decltype(::blink::mojom::ViewTransitionState::device_pixel_ratio) device_pixel_ratio(
      const ::blink::mojom::ViewTransitionStatePtr& input) {
    return input->device_pixel_ratio;
  }

  static decltype(::blink::mojom::ViewTransitionState::next_element_resource_id) next_element_resource_id(
      const ::blink::mojom::ViewTransitionStatePtr& input) {
    return input->next_element_resource_id;
  }

  static const decltype(::blink::mojom::ViewTransitionState::subframe_snapshot_id)& subframe_snapshot_id(
      const ::blink::mojom::ViewTransitionStatePtr& input) {
    return input->subframe_snapshot_id;
  }

  static const decltype(::blink::mojom::ViewTransitionState::id_to_auto_name_map)& id_to_auto_name_map(
      const ::blink::mojom::ViewTransitionStatePtr& input) {
    return input->id_to_auto_name_map;
  }

  static bool Read(::blink::mojom::ViewTransitionState::DataView input, ::blink::mojom::ViewTransitionStatePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_VIEW_TRANSITION_STATE_MOJOM_H_