// third_party/blink/public/mojom/frame/remote_frame.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_REMOTE_FRAME_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_REMOTE_FRAME_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/frame/remote_frame.mojom-shared-internal.h"
#include "cc/mojom/render_frame_metadata.mojom-shared.h"
#include "cc/mojom/touch_action.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/source_location.mojom-shared.h"
#include "services/network/public/mojom/storage_access_api.mojom-shared.h"
#include "services/network/public/mojom/url_request.mojom-shared.h"
#include "services/network/public/mojom/web_sandbox_flags.mojom-shared.h"
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/blob_url_store.mojom-shared.h"
#include "third_party/blink/public/mojom/conversions/conversions.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/frame_owner_properties.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/frame_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/navigation/navigation_initiator_activation_and_ad_status.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/frame_replication_state.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/frame_visual_properties.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/fullscreen.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/intrinsic_sizing_info.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/lifecycle.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/policy_container.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/text_autosizer_page_info.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/tree_scope_type.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/triggering_event_info.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/user_activation_notification_type.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/user_activation_update_types.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/viewport_intersection_state.mojom-shared.h"
#include "third_party/blink/public/mojom/input/focus_type.mojom-shared.h"
#include "third_party/blink/public/mojom/input/scroll_direction.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/referrer.mojom-shared.h"
#include "third_party/blink/public/mojom/messaging/transferable_message.mojom-shared.h"
#include "third_party/blink/public/mojom/navigation/navigation_policy.mojom-shared.h"
#include "services/network/public/mojom/permissions_policy/permissions_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-shared.h"
#include "third_party/blink/public/mojom/security_context/insecure_request_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/timing/resource_timing.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"
#include "ui/base/mojom/window_open_disposition.mojom-shared.h"
#include "ui/events/mojom/scroll_granularity.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace blink::mojom {
class RemoteMainFrameInterfacesDataView;

class RemoteFrameInterfacesFromRendererDataView;

class RemoteFrameInterfacesFromBrowserDataView;

class CreateRemoteChildParamsDataView;

class OpenURLParamsDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::RemoteMainFrameInterfacesDataView> {
  using Data = ::blink::mojom::internal::RemoteMainFrameInterfaces_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::RemoteFrameInterfacesFromRendererDataView> {
  using Data = ::blink::mojom::internal::RemoteFrameInterfacesFromRenderer_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::RemoteFrameInterfacesFromBrowserDataView> {
  using Data = ::blink::mojom::internal::RemoteFrameInterfacesFromBrowser_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::CreateRemoteChildParamsDataView> {
  using Data = ::blink::mojom::internal::CreateRemoteChildParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::OpenURLParamsDataView> {
  using Data = ::blink::mojom::internal::OpenURLParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {
// Interface base classes. They are used for type safety check.
class NavigationStateKeepAliveHandleInterfaceBase {};

using NavigationStateKeepAliveHandlePtrDataView =
    mojo::InterfacePtrDataView<NavigationStateKeepAliveHandleInterfaceBase>;
using NavigationStateKeepAliveHandleRequestDataView =
    mojo::InterfaceRequestDataView<NavigationStateKeepAliveHandleInterfaceBase>;
using NavigationStateKeepAliveHandleAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<NavigationStateKeepAliveHandleInterfaceBase>;
using NavigationStateKeepAliveHandleAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<NavigationStateKeepAliveHandleInterfaceBase>;
class RemoteFrameHostInterfaceBase {};

using RemoteFrameHostPtrDataView =
    mojo::InterfacePtrDataView<RemoteFrameHostInterfaceBase>;
using RemoteFrameHostRequestDataView =
    mojo::InterfaceRequestDataView<RemoteFrameHostInterfaceBase>;
using RemoteFrameHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RemoteFrameHostInterfaceBase>;
using RemoteFrameHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RemoteFrameHostInterfaceBase>;
class RemoteFrameInterfaceBase {};

using RemoteFramePtrDataView =
    mojo::InterfacePtrDataView<RemoteFrameInterfaceBase>;
using RemoteFrameRequestDataView =
    mojo::InterfaceRequestDataView<RemoteFrameInterfaceBase>;
using RemoteFrameAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RemoteFrameInterfaceBase>;
using RemoteFrameAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RemoteFrameInterfaceBase>;
class RemoteMainFrameInterfaceBase {};

using RemoteMainFramePtrDataView =
    mojo::InterfacePtrDataView<RemoteMainFrameInterfaceBase>;
using RemoteMainFrameRequestDataView =
    mojo::InterfaceRequestDataView<RemoteMainFrameInterfaceBase>;
using RemoteMainFrameAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RemoteMainFrameInterfaceBase>;
using RemoteMainFrameAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RemoteMainFrameInterfaceBase>;
class RemoteMainFrameHostInterfaceBase {};

using RemoteMainFrameHostPtrDataView =
    mojo::InterfacePtrDataView<RemoteMainFrameHostInterfaceBase>;
using RemoteMainFrameHostRequestDataView =
    mojo::InterfaceRequestDataView<RemoteMainFrameHostInterfaceBase>;
using RemoteMainFrameHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RemoteMainFrameHostInterfaceBase>;
using RemoteMainFrameHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RemoteMainFrameHostInterfaceBase>;


class RemoteMainFrameInterfacesDataView {
 public:
  RemoteMainFrameInterfacesDataView() = default;

  RemoteMainFrameInterfacesDataView(
      internal::RemoteMainFrameInterfaces_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeMainFrameHost() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::RemoteMainFrameHostAssociatedPtrInfoDataView>(
            &data_->main_frame_host, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeMainFrame() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::RemoteMainFrameAssociatedRequestDataView>(
            &data_->main_frame, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::RemoteMainFrameInterfaces_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RemoteFrameInterfacesFromRendererDataView {
 public:
  RemoteFrameInterfacesFromRendererDataView() = default;

  RemoteFrameInterfacesFromRendererDataView(
      internal::RemoteFrameInterfacesFromRenderer_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeFrame() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::RemoteFrameAssociatedPtrInfoDataView>(
            &data_->frame, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeFrameHostReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::RemoteFrameHostAssociatedRequestDataView>(
            &data_->frame_host_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::RemoteFrameInterfacesFromRenderer_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RemoteFrameInterfacesFromBrowserDataView {
 public:
  RemoteFrameInterfacesFromBrowserDataView() = default;

  RemoteFrameInterfacesFromBrowserDataView(
      internal::RemoteFrameInterfacesFromBrowser_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeFrameReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::RemoteFrameAssociatedRequestDataView>(
            &data_->frame_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeFrameHost() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::RemoteFrameHostAssociatedPtrInfoDataView>(
            &data_->frame_host, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::RemoteFrameInterfacesFromBrowser_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CreateRemoteChildParamsDataView {
 public:
  CreateRemoteChildParamsDataView() = default;

  CreateRemoteChildParamsDataView(
      internal::CreateRemoteChildParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTokenDataView(
      ::blink::mojom::RemoteFrameTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadToken(UserType* output) {
    
    auto* pointer = data_->token.Get();
    return mojo::internal::Deserialize<::blink::mojom::RemoteFrameTokenDataView>(
        pointer, output, message_);
  }
  inline void GetOpenerFrameTokenDataView(
      ::blink::mojom::FrameTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOpenerFrameToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::FrameTokenDataView, UserType>(),
    "Attempting to read the optional `opener_frame_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadOpenerFrameToken` instead "
    "of `ReadOpenerFrameToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->opener_frame_token.is_null() ? &data_->opener_frame_token : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::FrameTokenDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTreeScopeType(UserType* output) const {
    auto data_value = data_->tree_scope_type;
    return mojo::internal::Deserialize<::blink::mojom::TreeScopeType>(
        data_value, output);
  }
  ::blink::mojom::TreeScopeType tree_scope_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::TreeScopeType>(data_->tree_scope_type));
  }
  inline void GetReplicationStateDataView(
      ::blink::mojom::FrameReplicationStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReplicationState(UserType* output) {
    
    auto* pointer = data_->replication_state.Get();
    return mojo::internal::Deserialize<::blink::mojom::FrameReplicationStateDataView>(
        pointer, output, message_);
  }
  inline void GetOwnerPropertiesDataView(
      ::blink::mojom::FrameOwnerPropertiesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOwnerProperties(UserType* output) {
    
    auto* pointer = data_->owner_properties.Get();
    return mojo::internal::Deserialize<::blink::mojom::FrameOwnerPropertiesDataView>(
        pointer, output, message_);
  }
  bool is_loading() const {
    return data_->is_loading;
  }
  inline void GetDevtoolsFrameTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolsFrameToken(UserType* output) {
    
    auto* pointer = data_->devtools_frame_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetFrameInterfacesDataView(
      RemoteFrameInterfacesFromBrowserDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameInterfaces(UserType* output) {
    
    auto* pointer = data_->frame_interfaces.Get();
    return mojo::internal::Deserialize<::blink::mojom::RemoteFrameInterfacesFromBrowserDataView>(
        pointer, output, message_);
  }
  inline void GetChildParamsDataView(
      mojo::ArrayDataView<CreateRemoteChildParamsDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChildParams(UserType* output) {
    
    auto* pointer = data_->child_params.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::CreateRemoteChildParamsDataView>>(
        pointer, output, message_);
  }
 private:
  internal::CreateRemoteChildParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class OpenURLParamsDataView {
 public:
  OpenURLParamsDataView() = default;

  OpenURLParamsDataView(
      internal::OpenURLParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetInitiatorOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitiatorOrigin(UserType* output) {
    
    auto* pointer = data_->initiator_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetInitiatorBaseUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitiatorBaseUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `initiator_base_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInitiatorBaseUrl` instead "
    "of `ReadInitiatorBaseUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->initiator_base_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetActualNavigationStartDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadActualNavigationStart(UserType* output) {
    
    auto* pointer = data_->actual_navigation_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetInitiatorFrameTokenDataView(
      ::blink::mojom::LocalFrameTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitiatorFrameToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::LocalFrameTokenDataView, UserType>(),
    "Attempting to read the optional `initiator_frame_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInitiatorFrameToken` instead "
    "of `ReadInitiatorFrameToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->initiator_frame_token.Get();
    return mojo::internal::Deserialize<::blink::mojom::LocalFrameTokenDataView>(
        pointer, output, message_);
  }
  inline void GetPostBodyDataView(
      ::network::mojom::URLRequestBodyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPostBody(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::URLRequestBodyDataView, UserType>(),
    "Attempting to read the optional `post_body` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPostBody` instead "
    "of `ReadPostBody if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->post_body.Get();
    return mojo::internal::Deserialize<::network::mojom::URLRequestBodyDataView>(
        pointer, output, message_);
  }
  inline void GetExtraHeadersDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtraHeaders(UserType* output) {
    
    auto* pointer = data_->extra_headers.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetReferrerDataView(
      ::blink::mojom::ReferrerDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReferrer(UserType* output) {
    
    auto* pointer = data_->referrer.Get();
    return mojo::internal::Deserialize<::blink::mojom::ReferrerDataView>(
        pointer, output, message_);
  }
  bool is_form_submission() const {
    return data_->is_form_submission;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDisposition(UserType* output) const {
    auto data_value = data_->disposition;
    return mojo::internal::Deserialize<::ui::mojom::WindowOpenDisposition>(
        data_value, output);
  }
  ::ui::mojom::WindowOpenDisposition disposition() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::WindowOpenDisposition>(data_->disposition));
  }
  bool should_replace_current_entry() const {
    return data_->should_replace_current_entry;
  }
  bool user_gesture() const {
    return data_->user_gesture;
  }
  bool is_unfenced_top_navigation() const {
    return data_->is_unfenced_top_navigation;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTriggeringEventInfo(UserType* output) const {
    auto data_value = data_->triggering_event_info;
    return mojo::internal::Deserialize<::blink::mojom::TriggeringEventInfo>(
        data_value, output);
  }
  ::blink::mojom::TriggeringEventInfo triggering_event_info() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::TriggeringEventInfo>(data_->triggering_event_info));
  }
  template <typename UserType>
  UserType TakeBlobUrlToken() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::BlobURLTokenInterfaceBase>>(
            &data_->blob_url_token, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetHrefTranslateDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHrefTranslate(UserType* output) {
    
    auto* pointer = data_->href_translate.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetImpressionDataView(
      ::blink::mojom::ImpressionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImpression(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ImpressionDataView, UserType>(),
    "Attempting to read the optional `impression` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadImpression` instead "
    "of `ReadImpression if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->impression.Get();
    return mojo::internal::Deserialize<::blink::mojom::ImpressionDataView>(
        pointer, output, message_);
  }
  inline void GetDownloadPolicyDataView(
      ::blink::mojom::NavigationDownloadPolicyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDownloadPolicy(UserType* output) {
    
    auto* pointer = data_->download_policy.Get();
    return mojo::internal::Deserialize<::blink::mojom::NavigationDownloadPolicyDataView>(
        pointer, output, message_);
  }
  inline void GetSourceLocationDataView(
      ::network::mojom::SourceLocationDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSourceLocation(UserType* output) {
    
    auto* pointer = data_->source_location.Get();
    return mojo::internal::Deserialize<::network::mojom::SourceLocationDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeInitiatorNavigationStateKeepAliveHandle() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::NavigationStateKeepAliveHandleInterfaceBase>>(
            &data_->initiator_navigation_state_keep_alive_handle, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadInitiatorActivationAndAdStatus(UserType* output) const {
    auto data_value = data_->initiator_activation_and_ad_status;
    return mojo::internal::Deserialize<::blink::mojom::NavigationInitiatorActivationAndAdStatus>(
        data_value, output);
  }
  ::blink::mojom::NavigationInitiatorActivationAndAdStatus initiator_activation_and_ad_status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::NavigationInitiatorActivationAndAdStatus>(data_->initiator_activation_and_ad_status));
  }
  bool is_container_initiated() const {
    return data_->is_container_initiated;
  }
  bool has_rel_opener() const {
    return data_->has_rel_opener;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadStorageAccessApiStatus(UserType* output) const {
    auto data_value = data_->storage_access_api_status;
    return mojo::internal::Deserialize<::network::mojom::StorageAccessApiStatus>(
        data_value, output);
  }
  ::network::mojom::StorageAccessApiStatus storage_access_api_status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::StorageAccessApiStatus>(data_->storage_access_api_status));
  }
 private:
  internal::OpenURLParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_REMOTE_FRAME_MOJOM_DATA_VIEW_H_