// third_party/blink/public/mojom/frame/policy_container.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/frame/policy_container.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/frame/policy_container.mojom-params-data.h"
#include "third_party/blink/public/mojom/frame/policy_container.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/frame/policy_container.mojom-import-headers.h"
#include "third_party/blink/public/mojom/frame/policy_container.mojom-test-utils.h"


namespace blink::mojom {
PolicyContainerPolicies::PolicyContainerPolicies()
    : connection_allowlists(),
      cross_origin_embedder_policy(),
      integrity_policy(),
      integrity_policy_report_only(),
      referrer_policy(::network::mojom::ReferrerPolicy::kDefault),
      content_security_policies(),
      is_credentialless(false),
      sandbox_flags(::network::mojom::WebSandboxFlags::kNone),
      ip_address_space(::network::mojom::IPAddressSpace::kUnknown),
      can_navigate_top_without_user_gesture(true),
      cross_origin_isolation_enabled_by_dip(false) {}

PolicyContainerPolicies::PolicyContainerPolicies(
    const ::network::ConnectionAllowlists& connection_allowlists_in,
    const ::network::CrossOriginEmbedderPolicy& cross_origin_embedder_policy_in,
    const ::network::IntegrityPolicy& integrity_policy_in,
    const ::network::IntegrityPolicy& integrity_policy_report_only_in,
    ::network::mojom::ReferrerPolicy referrer_policy_in,
    std::vector<::network::mojom::ContentSecurityPolicyPtr> content_security_policies_in,
    bool is_credentialless_in,
    ::network::mojom::WebSandboxFlags sandbox_flags_in,
    ::network::mojom::IPAddressSpace ip_address_space_in,
    bool can_navigate_top_without_user_gesture_in,
    bool cross_origin_isolation_enabled_by_dip_in)
    : connection_allowlists(std::move(connection_allowlists_in)),
      cross_origin_embedder_policy(std::move(cross_origin_embedder_policy_in)),
      integrity_policy(std::move(integrity_policy_in)),
      integrity_policy_report_only(std::move(integrity_policy_report_only_in)),
      referrer_policy(std::move(referrer_policy_in)),
      content_security_policies(std::move(content_security_policies_in)),
      is_credentialless(std::move(is_credentialless_in)),
      sandbox_flags(std::move(sandbox_flags_in)),
      ip_address_space(std::move(ip_address_space_in)),
      can_navigate_top_without_user_gesture(std::move(can_navigate_top_without_user_gesture_in)),
      cross_origin_isolation_enabled_by_dip(std::move(cross_origin_isolation_enabled_by_dip_in)) {}

PolicyContainerPolicies::~PolicyContainerPolicies() = default;

void PolicyContainerPolicies::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "connection_allowlists"), this->connection_allowlists,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::network::ConnectionAllowlists&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cross_origin_embedder_policy"), this->cross_origin_embedder_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::network::CrossOriginEmbedderPolicy&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "integrity_policy"), this->integrity_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::network::IntegrityPolicy&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "integrity_policy_report_only"), this->integrity_policy_report_only,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::network::IntegrityPolicy&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "referrer_policy"), this->referrer_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::ReferrerPolicy>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content_security_policies"), this->content_security_policies,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<::network::mojom::ContentSecurityPolicyPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_credentialless"), this->is_credentialless,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sandbox_flags"), this->sandbox_flags,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::WebSandboxFlags>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ip_address_space"), this->ip_address_space,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::IPAddressSpace>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "can_navigate_top_without_user_gesture"), this->can_navigate_top_without_user_gesture,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cross_origin_isolation_enabled_by_dip"), this->cross_origin_isolation_enabled_by_dip,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PolicyContainerPolicies::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PolicyContainer::PolicyContainer()
    : policies(),
      remote() {}

PolicyContainer::PolicyContainer(
    PolicyContainerPoliciesPtr policies_in,
    ::mojo::PendingAssociatedRemote<PolicyContainerHost> remote_in)
    : policies(std::move(policies_in)),
      remote(std::move(remote_in)) {}

PolicyContainer::~PolicyContainer() = default;

void PolicyContainer::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "policies"), this->policies,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PolicyContainerPoliciesPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "remote"), this->remote,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedRemote<PolicyContainerHost>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PolicyContainer::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PolicyContainerBindParams::PolicyContainerBindParams()
    : receiver() {}

PolicyContainerBindParams::PolicyContainerBindParams(
    ::mojo::PendingAssociatedReceiver<PolicyContainerHost> receiver_in)
    : receiver(std::move(receiver_in)) {}

PolicyContainerBindParams::~PolicyContainerBindParams() = default;

void PolicyContainerBindParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "receiver"), this->receiver,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedReceiver<PolicyContainerHost>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PolicyContainerBindParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

PolicyContainerHost::IPCStableHashFunction PolicyContainerHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PolicyContainerHost>(message.name())) {
    case messages::PolicyContainerHost::kSetReferrerPolicy: {
      return &PolicyContainerHost::SetReferrerPolicy_Sym::IPCStableHash;
    }
    case messages::PolicyContainerHost::kAddContentSecurityPolicies: {
      return &PolicyContainerHost::AddContentSecurityPolicies_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PolicyContainerHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PolicyContainerHost>(message.name())) {
      case messages::PolicyContainerHost::kSetReferrerPolicy:
            return "Receive blink::mojom::PolicyContainerHost::SetReferrerPolicy";
      case messages::PolicyContainerHost::kAddContentSecurityPolicies:
            return "Receive blink::mojom::PolicyContainerHost::AddContentSecurityPolicies";
    }
  } else {
    switch (static_cast<messages::PolicyContainerHost>(message.name())) {
      case messages::PolicyContainerHost::kSetReferrerPolicy:
            return "Receive reply blink::mojom::PolicyContainerHost::SetReferrerPolicy";
      case messages::PolicyContainerHost::kAddContentSecurityPolicies:
            return "Receive reply blink::mojom::PolicyContainerHost::AddContentSecurityPolicies";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PolicyContainerHost::SetReferrerPolicy_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x61ea72cc;  // IPCStableHash for blink::mojom::PolicyContainerHost::SetReferrerPolicy
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PolicyContainerHost::AddContentSecurityPolicies_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x46dd5e36;  // IPCStableHash for blink::mojom::PolicyContainerHost::AddContentSecurityPolicies
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PolicyContainerHostProxy::PolicyContainerHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PolicyContainerHostProxy::SetReferrerPolicy(
    ::network::mojom::ReferrerPolicy in_referrer_policy) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PolicyContainerHost::SetReferrerPolicy", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("referrer_policy"), in_referrer_policy,
                        "<value of type ::network::mojom::ReferrerPolicy>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PolicyContainerHost::kSetReferrerPolicy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PolicyContainerHost_SetReferrerPolicy_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::network::mojom::ReferrerPolicy>(
    in_referrer_policy,
    &params->referrer_policy);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PolicyContainerHost::Name_);
  message.set_method_name("SetReferrerPolicy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PolicyContainerHostProxy::AddContentSecurityPolicies(
    std::vector<::network::mojom::ContentSecurityPolicyPtr> in_content_security_policies) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PolicyContainerHost::AddContentSecurityPolicies", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("content_security_policies"), in_content_security_policies,
                        "<value of type std::vector<::network::mojom::ContentSecurityPolicyPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PolicyContainerHost::kAddContentSecurityPolicies), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PolicyContainerHost_AddContentSecurityPolicies_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->content_security_policies)::BaseType>
      content_security_policies_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& content_security_policies_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::ContentSecurityPolicyDataView>>(
    in_content_security_policies,
    content_security_policies_fragment,
    &content_security_policies_validate_params);

  params->content_security_policies.Set(
      content_security_policies_fragment.is_null() ? nullptr : content_security_policies_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->content_security_policies.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null content_security_policies in PolicyContainerHost.AddContentSecurityPolicies request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PolicyContainerHost::Name_);
  message.set_method_name("AddContentSecurityPolicies");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PolicyContainerHostStubDispatch::Accept(
    PolicyContainerHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PolicyContainerHost>(message->header()->name)) {
    case messages::PolicyContainerHost::kSetReferrerPolicy: {
      DCHECK(message->is_serialized());
      internal::PolicyContainerHost_SetReferrerPolicy_Params_Data* params =
          reinterpret_cast<internal::PolicyContainerHost_SetReferrerPolicy_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PolicyContainerHost.0
      bool success = true;
      ::network::mojom::ReferrerPolicy p_referrer_policy{};
      PolicyContainerHost_SetReferrerPolicy_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReferrerPolicy(&p_referrer_policy))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PolicyContainerHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetReferrerPolicy(        
        std::move(p_referrer_policy));
      return true;
    }
    case messages::PolicyContainerHost::kAddContentSecurityPolicies: {
      DCHECK(message->is_serialized());
      internal::PolicyContainerHost_AddContentSecurityPolicies_Params_Data* params =
          reinterpret_cast<internal::PolicyContainerHost_AddContentSecurityPolicies_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PolicyContainerHost.1
      bool success = true;
      std::vector<::network::mojom::ContentSecurityPolicyPtr> p_content_security_policies{};
      PolicyContainerHost_AddContentSecurityPolicies_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadContentSecurityPolicies(&p_content_security_policies))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PolicyContainerHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddContentSecurityPolicies(        
        std::move(p_content_security_policies));
      return true;
    }
  }
  return false;
}

// static
bool PolicyContainerHostStubDispatch::AcceptWithResponder(
    PolicyContainerHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PolicyContainerHost>(message->header()->name)) {
    case messages::PolicyContainerHost::kSetReferrerPolicy: {
      break;
    }
    case messages::PolicyContainerHost::kAddContentSecurityPolicies: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPolicyContainerHostValidationInfo[] = {
    { &internal::PolicyContainerHost_SetReferrerPolicy_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PolicyContainerHost_AddContentSecurityPolicies_Params_Data::Validate,
     nullptr /* no response */},
};

bool PolicyContainerHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::PolicyContainerHost::Name_,
    kPolicyContainerHostValidationInfo);
}



}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::PolicyContainerPolicies::DataView, ::blink::mojom::PolicyContainerPoliciesPtr>::Read(
    ::blink::mojom::PolicyContainerPolicies::DataView input,
    ::blink::mojom::PolicyContainerPoliciesPtr* output) {
  bool success = true;
  ::blink::mojom::PolicyContainerPoliciesPtr result(::blink::mojom::PolicyContainerPolicies::New());
  
      if (success && !input.ReadConnectionAllowlists(&result->connection_allowlists))
        success = false;
      if (success && !input.ReadCrossOriginEmbedderPolicy(&result->cross_origin_embedder_policy))
        success = false;
      if (success && !input.ReadIntegrityPolicy(&result->integrity_policy))
        success = false;
      if (success && !input.ReadIntegrityPolicyReportOnly(&result->integrity_policy_report_only))
        success = false;
      if (success && !input.ReadReferrerPolicy(&result->referrer_policy))
        success = false;
      if (success && !input.ReadContentSecurityPolicies(&result->content_security_policies))
        success = false;
      if (success)
        result->is_credentialless = input.is_credentialless();
      if (success && !input.ReadSandboxFlags(&result->sandbox_flags))
        success = false;
      if (success && !input.ReadIpAddressSpace(&result->ip_address_space))
        success = false;
      if (success)
        result->can_navigate_top_without_user_gesture = input.can_navigate_top_without_user_gesture();
      if (success)
        result->cross_origin_isolation_enabled_by_dip = input.cross_origin_isolation_enabled_by_dip();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::PolicyContainer::DataView, ::blink::mojom::PolicyContainerPtr>::Read(
    ::blink::mojom::PolicyContainer::DataView input,
    ::blink::mojom::PolicyContainerPtr* output) {
  bool success = true;
  ::blink::mojom::PolicyContainerPtr result(::blink::mojom::PolicyContainer::New());
  
      if (success && !input.ReadPolicies(&result->policies))
        success = false;
      if (success) {
        result->remote =
            input.TakeRemote<decltype(result->remote)>();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::PolicyContainerBindParams::DataView, ::blink::mojom::PolicyContainerBindParamsPtr>::Read(
    ::blink::mojom::PolicyContainerBindParams::DataView input,
    ::blink::mojom::PolicyContainerBindParamsPtr* output) {
  bool success = true;
  ::blink::mojom::PolicyContainerBindParamsPtr result(::blink::mojom::PolicyContainerBindParams::New());
  
      if (success) {
        result->receiver =
            input.TakeReceiver<decltype(result->receiver)>();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void PolicyContainerHostInterceptorForTesting::SetReferrerPolicy(::network::mojom::ReferrerPolicy referrer_policy) {
  GetForwardingInterface()->SetReferrerPolicy(
    std::move(referrer_policy)
    );
}
void PolicyContainerHostInterceptorForTesting::AddContentSecurityPolicies(std::vector<::network::mojom::ContentSecurityPolicyPtr> content_security_policies) {
  GetForwardingInterface()->AddContentSecurityPolicies(
    std::move(content_security_policies)
    );
}
PolicyContainerHostAsyncWaiter::PolicyContainerHostAsyncWaiter(
    PolicyContainerHost* proxy) : proxy_(proxy) {}

PolicyContainerHostAsyncWaiter::~PolicyContainerHostAsyncWaiter() = default;







}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif