// third_party/blink/public/mojom/frame/policy_container.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/frame/policy_container.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/frame/policy_container.mojom-params-data.h"
namespace blink {
namespace mojom {

namespace internal {


// static
bool PolicyContainerPolicies_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PolicyContainerPolicies_Data* object =
      static_cast<const PolicyContainerPolicies_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->connection_allowlists, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->connection_allowlists, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cross_origin_embedder_policy, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cross_origin_embedder_policy, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->integrity_policy, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->integrity_policy, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->integrity_policy_report_only, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->integrity_policy_report_only, validation_context))
    return false;


  if (!::network::mojom::internal::ReferrerPolicy_Data
        ::Validate(object->referrer_policy, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->content_security_policies, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& content_security_policies_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->content_security_policies, validation_context,
                                         &content_security_policies_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::WebSandboxFlags_Data
        ::Validate(object->sandbox_flags, validation_context))
    return false;


  if (!::network::mojom::internal::IPAddressSpace_Data
        ::Validate(object->ip_address_space, validation_context))
    return false;

  return true;
}

PolicyContainerPolicies_Data::PolicyContainerPolicies_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PolicyContainer_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PolicyContainer_Data* object =
      static_cast<const PolicyContainer_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->policies, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->policies, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->remote, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->remote,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PolicyContainer_Data::PolicyContainer_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PolicyContainerBindParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PolicyContainerBindParams_Data* object =
      static_cast<const PolicyContainerBindParams_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PolicyContainerBindParams_Data::PolicyContainerBindParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PolicyContainerHost_SetReferrerPolicy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PolicyContainerHost_SetReferrerPolicy_Params_Data* object =
      static_cast<const PolicyContainerHost_SetReferrerPolicy_Params_Data*>(data);


  if (!::network::mojom::internal::ReferrerPolicy_Data
        ::Validate(object->referrer_policy, validation_context))
    return false;

  return true;
}

PolicyContainerHost_SetReferrerPolicy_Params_Data::PolicyContainerHost_SetReferrerPolicy_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PolicyContainerHost_AddContentSecurityPolicies_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PolicyContainerHost_AddContentSecurityPolicies_Params_Data* object =
      static_cast<const PolicyContainerHost_AddContentSecurityPolicies_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->content_security_policies, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& content_security_policies_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->content_security_policies, validation_context,
                                         &content_security_policies_validate_params)) {
    return false;
  }

  return true;
}

PolicyContainerHost_AddContentSecurityPolicies_Params_Data::PolicyContainerHost_AddContentSecurityPolicies_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink