// third_party/blink/public/mojom/frame/policy_container.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_POLICY_CONTAINER_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_POLICY_CONTAINER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/frame/policy_container.mojom-shared-internal.h"
#include "services/network/public/mojom/connection_allowlist.mojom-shared.h"
#include "services/network/public/mojom/content_security_policy.mojom-shared.h"
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-shared.h"
#include "services/network/public/mojom/integrity_policy.mojom-shared.h"
#include "services/network/public/mojom/ip_address_space.mojom-shared.h"
#include "services/network/public/mojom/referrer_policy.mojom-shared.h"
#include "services/network/public/mojom/web_sandbox_flags.mojom-shared.h"


namespace blink::mojom {
class PolicyContainerPoliciesDataView;

class PolicyContainerDataView;

class PolicyContainerBindParamsDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::PolicyContainerPoliciesDataView> {
  using Data = ::blink::mojom::internal::PolicyContainerPolicies_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PolicyContainerDataView> {
  using Data = ::blink::mojom::internal::PolicyContainer_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PolicyContainerBindParamsDataView> {
  using Data = ::blink::mojom::internal::PolicyContainerBindParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {
// Interface base classes. They are used for type safety check.
class PolicyContainerHostInterfaceBase {};

using PolicyContainerHostPtrDataView =
    mojo::InterfacePtrDataView<PolicyContainerHostInterfaceBase>;
using PolicyContainerHostRequestDataView =
    mojo::InterfaceRequestDataView<PolicyContainerHostInterfaceBase>;
using PolicyContainerHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PolicyContainerHostInterfaceBase>;
using PolicyContainerHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PolicyContainerHostInterfaceBase>;


class PolicyContainerPoliciesDataView {
 public:
  PolicyContainerPoliciesDataView() = default;

  PolicyContainerPoliciesDataView(
      internal::PolicyContainerPolicies_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetConnectionAllowlistsDataView(
      ::network::mojom::ConnectionAllowlistsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConnectionAllowlists(UserType* output) {
    
    auto* pointer = data_->connection_allowlists.Get();
    return mojo::internal::Deserialize<::network::mojom::ConnectionAllowlistsDataView>(
        pointer, output, message_);
  }
  inline void GetCrossOriginEmbedderPolicyDataView(
      ::network::mojom::CrossOriginEmbedderPolicyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCrossOriginEmbedderPolicy(UserType* output) {
    
    auto* pointer = data_->cross_origin_embedder_policy.Get();
    return mojo::internal::Deserialize<::network::mojom::CrossOriginEmbedderPolicyDataView>(
        pointer, output, message_);
  }
  inline void GetIntegrityPolicyDataView(
      ::network::mojom::IntegrityPolicyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIntegrityPolicy(UserType* output) {
    
    auto* pointer = data_->integrity_policy.Get();
    return mojo::internal::Deserialize<::network::mojom::IntegrityPolicyDataView>(
        pointer, output, message_);
  }
  inline void GetIntegrityPolicyReportOnlyDataView(
      ::network::mojom::IntegrityPolicyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIntegrityPolicyReportOnly(UserType* output) {
    
    auto* pointer = data_->integrity_policy_report_only.Get();
    return mojo::internal::Deserialize<::network::mojom::IntegrityPolicyDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadReferrerPolicy(UserType* output) const {
    auto data_value = data_->referrer_policy;
    return mojo::internal::Deserialize<::network::mojom::ReferrerPolicy>(
        data_value, output);
  }
  ::network::mojom::ReferrerPolicy referrer_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ReferrerPolicy>(data_->referrer_policy));
  }
  inline void GetContentSecurityPoliciesDataView(
      mojo::ArrayDataView<::network::mojom::ContentSecurityPolicyDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentSecurityPolicies(UserType* output) {
    
    auto* pointer = data_->content_security_policies.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::ContentSecurityPolicyDataView>>(
        pointer, output, message_);
  }
  bool is_credentialless() const {
    return data_->is_credentialless;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSandboxFlags(UserType* output) const {
    auto data_value = data_->sandbox_flags;
    return mojo::internal::Deserialize<::network::mojom::WebSandboxFlags>(
        data_value, output);
  }
  ::network::mojom::WebSandboxFlags sandbox_flags() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::WebSandboxFlags>(data_->sandbox_flags));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadIpAddressSpace(UserType* output) const {
    auto data_value = data_->ip_address_space;
    return mojo::internal::Deserialize<::network::mojom::IPAddressSpace>(
        data_value, output);
  }
  ::network::mojom::IPAddressSpace ip_address_space() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::IPAddressSpace>(data_->ip_address_space));
  }
  bool can_navigate_top_without_user_gesture() const {
    return data_->can_navigate_top_without_user_gesture;
  }
  bool cross_origin_isolation_enabled_by_dip() const {
    return data_->cross_origin_isolation_enabled_by_dip;
  }
 private:
  internal::PolicyContainerPolicies_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PolicyContainerDataView {
 public:
  PolicyContainerDataView() = default;

  PolicyContainerDataView(
      internal::PolicyContainer_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPoliciesDataView(
      PolicyContainerPoliciesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPolicies(UserType* output) {
    
    auto* pointer = data_->policies.Get();
    return mojo::internal::Deserialize<::blink::mojom::PolicyContainerPoliciesDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeRemote() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::PolicyContainerHostAssociatedPtrInfoDataView>(
            &data_->remote, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::PolicyContainer_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PolicyContainerBindParamsDataView {
 public:
  PolicyContainerBindParamsDataView() = default;

  PolicyContainerBindParamsDataView(
      internal::PolicyContainerBindParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::PolicyContainerHostAssociatedRequestDataView>(
            &data_->receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::PolicyContainerBindParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_POLICY_CONTAINER_MOJOM_DATA_VIEW_H_