// third_party/blink/public/mojom/frame/frame_policy.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_POLICY_MOJOM_SEND_VALIDATION_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_POLICY_MOJOM_SEND_VALIDATION_H_

#include "third_party/blink/public/mojom/frame/frame_policy.mojom-shared-internal.h"
#include "services/network/public/mojom/web_sandbox_flags.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/deferred_fetch_policy.mojom-shared.h"
#include "services/network/public/mojom/permissions_policy/permissions_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/permissions_policy/document_policy_feature.mojom-shared.h"
#include "third_party/blink/public/mojom/permissions_policy/policy_value.mojom-shared.h"

#include "third_party/blink/public/mojom/frame/frame_policy.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::FramePolicyDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FramePolicyDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::FramePolicy_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::network::mojom::WebSandboxFlags>(
        Traits::sandbox_flags(input),
        &fragment->sandbox_flags);

      decltype(Traits::container_policy(input)) in_container_policy = Traits::container_policy(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->container_policy)::BaseType>
          container_policy_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& container_policy_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::ParsedPermissionsPolicyDeclarationDataView>, send_validation>(
        in_container_policy,
        container_policy_fragment,
        &container_policy_validate_params);

      fragment->container_policy.Set(
          container_policy_fragment.is_null() ? nullptr : container_policy_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->container_policy.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null container_policy in FramePolicy struct");

      decltype(Traits::required_document_policy(input)) in_required_document_policy = Traits::required_document_policy(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->required_document_policy)::BaseType>
          required_document_policy_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& required_document_policy_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::DocumentPolicyFeature_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<::blink::mojom::DocumentPolicyFeature, ::blink::mojom::PolicyValueDataView>, send_validation>(
        in_required_document_policy,
        required_document_policy_fragment,
        &required_document_policy_validate_params);

      fragment->required_document_policy.Set(
          required_document_policy_fragment.is_null() ? nullptr : required_document_policy_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->required_document_policy.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null required_document_policy in FramePolicy struct");

      
      mojo::internal::Serialize<::blink::mojom::DeferredFetchPolicy>(
        Traits::deferred_fetch_policy(input),
        &fragment->deferred_fetch_policy);
  }
};

}  // namespace mojo::internal

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_POLICY_MOJOM_SEND_VALIDATION_H_