// third_party/blink/public/mojom/frame/frame_policy.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_POLICY_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_POLICY_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/frame/frame_policy.mojom-shared-internal.h"
#include "services/network/public/mojom/web_sandbox_flags.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/deferred_fetch_policy.mojom-shared.h"
#include "services/network/public/mojom/permissions_policy/permissions_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/permissions_policy/document_policy_feature.mojom-shared.h"
#include "third_party/blink/public/mojom/permissions_policy/policy_value.mojom-shared.h"


namespace blink::mojom {
class FramePolicyDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::FramePolicyDataView> {
  using Data = ::blink::mojom::internal::FramePolicy_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


class FramePolicyDataView {
 public:
  FramePolicyDataView() = default;

  FramePolicyDataView(
      internal::FramePolicy_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadSandboxFlags(UserType* output) const {
    auto data_value = data_->sandbox_flags;
    return mojo::internal::Deserialize<::network::mojom::WebSandboxFlags>(
        data_value, output);
  }
  ::network::mojom::WebSandboxFlags sandbox_flags() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::WebSandboxFlags>(data_->sandbox_flags));
  }
  inline void GetContainerPolicyDataView(
      mojo::ArrayDataView<::network::mojom::ParsedPermissionsPolicyDeclarationDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContainerPolicy(UserType* output) {
    
    auto* pointer = data_->container_policy.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::ParsedPermissionsPolicyDeclarationDataView>>(
        pointer, output, message_);
  }
  inline void GetRequiredDocumentPolicyDataView(
      mojo::MapDataView<::blink::mojom::DocumentPolicyFeature, ::blink::mojom::PolicyValueDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequiredDocumentPolicy(UserType* output) {
    
    auto* pointer = data_->required_document_policy.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::blink::mojom::DocumentPolicyFeature, ::blink::mojom::PolicyValueDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDeferredFetchPolicy(UserType* output) const {
    auto data_value = data_->deferred_fetch_policy;
    return mojo::internal::Deserialize<::blink::mojom::DeferredFetchPolicy>(
        data_value, output);
  }
  ::blink::mojom::DeferredFetchPolicy deferred_fetch_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::DeferredFetchPolicy>(data_->deferred_fetch_policy));
  }
 private:
  internal::FramePolicy_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_POLICY_MOJOM_DATA_VIEW_H_