// third_party/blink/public/mojom/frame/frame_owner_properties.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/frame/frame_owner_properties.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var scrollbar_mode$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/scroll/scrollbar_mode.mojom', '../scroll/scrollbar_mode.mojom.js');
  }
  var color_scheme$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/frame/color_scheme.mojom', 'color_scheme.mojom.js');
  }
  var preferred_color_scheme$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/css/preferred_color_scheme.mojom', '../css/preferred_color_scheme.mojom.js');
  }



  function FrameOwnerProperties(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameOwnerProperties.prototype.initDefaults_ = function() {
    this.name = null;
    this.scrollbarMode = 0;
    this.marginWidth = 0;
    this.marginHeight = 0;
    this.allowFullscreen = false;
    this.allowPaymentRequest = false;
    this.isDisplayNone = false;
    this.colorScheme = color_scheme$.ColorScheme.kLight;
    this.preferredColorScheme = preferred_color_scheme$.PreferredColorScheme.kLight;
  };
  FrameOwnerProperties.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameOwnerProperties.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameOwnerProperties.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameOwnerProperties.scrollbarMode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, scrollbar_mode$.ScrollbarMode);
    if (err !== validator.validationError.NONE)
        return err;







    // validate FrameOwnerProperties.colorScheme
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 24, color_scheme$.ColorScheme);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameOwnerProperties.preferredColorScheme
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 28, preferred_color_scheme$.PreferredColorScheme);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameOwnerProperties.encodedSize = codec.kStructHeaderSize + 32;

  FrameOwnerProperties.decode = function(decoder) {
    var packed;
    var val = new FrameOwnerProperties();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStruct(codec.String);
    val.scrollbarMode =
        decoder.decodeStruct(new codec.Enum(scrollbar_mode$.ScrollbarMode));
    val.marginWidth =
        decoder.decodeStruct(codec.Int32);
    val.marginHeight =
        decoder.decodeStruct(codec.Int32);
    packed = decoder.readUint8();
    val.allowFullscreen = (packed >> 0) & 1 ? true : false;
    val.allowPaymentRequest = (packed >> 1) & 1 ? true : false;
    val.isDisplayNone = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.colorScheme =
        decoder.decodeStruct(new codec.Enum(color_scheme$.ColorScheme));
    val.preferredColorScheme =
        decoder.decodeStruct(new codec.Enum(preferred_color_scheme$.PreferredColorScheme));
    return val;
  };

  FrameOwnerProperties.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameOwnerProperties.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStruct(codec.Int32, val.scrollbarMode);
    encoder.encodeStruct(codec.Int32, val.marginWidth);
    encoder.encodeStruct(codec.Int32, val.marginHeight);
    packed = 0;
    packed |= (val.allowFullscreen & 1) << 0
    packed |= (val.allowPaymentRequest & 1) << 1
    packed |= (val.isDisplayNone & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.colorScheme);
    encoder.encodeStruct(codec.Int32, val.preferredColorScheme);
  };
  exports.FrameOwnerProperties = FrameOwnerProperties;
})();