// third_party/blink/public/mojom/frame/frame.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/frame/frame.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/frame/frame.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/frame/frame.mojom-blink-forward.h"  // IWYU pragma: export
#include "cc/mojom/browser_controls_state.mojom-blink.h"
#include "cc/mojom/browser_controls_offset_tag_modifications.mojom-blink.h"
#include "mojo/public/mojom/base/byte_string.mojom-blink.h"
#include "mojo/public/mojom/base/shared_memory.mojom-blink.h"
#include "mojo/public/mojom/base/string16.mojom-blink.h"
#include "mojo/public/mojom/base/text_direction.mojom-blink.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-blink.h"
#include "mojo/public/mojom/base/values.mojom-blink.h"
#include "services/network/public/mojom/content_security_policy.mojom-blink.h"
#include "services/network/public/mojom/cross_origin_opener_policy.mojom-blink-forward.h"
#include "services/network/public/mojom/fetch_api.mojom-blink-forward.h"
#include "services/network/public/mojom/load_timing_info.mojom-blink-forward.h"
#include "services/network/public/mojom/network_types.mojom-blink.h"
#include "services/network/public/mojom/source_location.mojom-blink-forward.h"
#include "services/network/public/mojom/storage_access_api.mojom-blink.h"
#include "services/network/public/mojom/url_loader_completion_status.mojom-blink.h"
#include "services/network/public/mojom/attribution.mojom-blink-forward.h"
#include "services/viz/public/mojom/compositing/offset_tag.mojom-blink-forward.h"
#include "skia/public/mojom/bitmap.mojom-blink.h"
#include "skia/public/mojom/skcolor.mojom-blink.h"
#include "skia/public/mojom/skcolor4f.mojom-blink.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/blob/blob_url_store.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/choosers/popup_menu.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/close_watcher/close_listener.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/confidence_level.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/context_menu/context_menu.mojom-blink.h"
#include "third_party/blink/public/mojom/navigation/navigation_params.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/css/preferred_color_scheme.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/devtools/console_message.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/devtools/devtools_agent.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/devtools/inspector_issue.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/dom_storage/storage_area.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/drag/drag.mojom-blink.h"
#include "third_party/blink/public/mojom/favicon/favicon_url.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/fenced_frame/fenced_frame.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/fenced_frame/fenced_frame_config.mojom-blink.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/frame/blocked_navigation_types.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/frame/frame_owner_properties.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/frame/frame_policy.mojom-blink.h"
#include "third_party/blink/public/mojom/frame/frame_replication_state.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/frame/fullscreen.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/frame/lifecycle.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/frame/media_player_action.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/frame/remote_frame.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/frame/reporting_observer.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/frame/sudden_termination_disabler_type.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/frame/text_autosizer_page_info.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/frame/user_activation_notification_type.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/frame/user_activation_update_types.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/frame/view_transition_state.mojom-blink.h"
#include "third_party/blink/public/mojom/input/focus_type.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/input/scroll_direction.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/loader/referrer.mojom-blink.h"
#include "third_party/blink/public/mojom/loader/keep_alive_handle_factory.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/messaging/delegated_capability.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/messaging/task_attribution_id.mojom-blink.h"
#include "third_party/blink/public/mojom/messaging/transferable_message.mojom-blink.h"
#include "third_party/blink/public/mojom/navigation/navigation_api_history_entry_arrays.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/opengraph/metadata.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/page/draggable_region.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/page/widget.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/security_context/insecure_request_policy.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/timing/resource_timing.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-blink.h"
#include "third_party/blink/public/mojom/use_counter/metrics/web_feature.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/widget/platform_widget.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/window_features/window_features.mojom-blink-forward.h"
#include "ui/base/ime/mojom/virtual_keyboard_types.mojom-blink-forward.h"
#include "ui/base/mojom/window_open_disposition.mojom-blink-forward.h"
#include "ui/events/mojom/scroll_granularity.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"
#include "ui/gfx/image/mojom/image.mojom-blink-forward.h"
#include "ui/gfx/range/mojom/range.mojom-blink.h"
#include "url/mojom/origin.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"
#include "ui/base/mojom/attributed_string.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/frame/frame_owner_element_type_mojom_traits.h"
#include "third_party/blink/renderer/core/core_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class LocalFrameHostProxy;

template <typename ImplRefTraits>
class LocalFrameHostStub;

class LocalFrameHostRequestValidator;
class LocalFrameHostResponseValidator;


class CORE_EXPORT LocalFrameHost
    : public LocalFrameHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.LocalFrameHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    39, 
    40, 
    41, 
    42, 
    81, 
    82
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = LocalFrameHostInterfaceBase;
  using Proxy_ = LocalFrameHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = LocalFrameHostStub<ImplRefTraits>;

  using RequestValidator_ = LocalFrameHostRequestValidator;
  using ResponseValidator_ = LocalFrameHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kEnterFullscreenMinVersion = 0,
    kExitFullscreenMinVersion = 0,
    kFullscreenStateChangedMinVersion = 0,
    kRegisterProtocolHandlerMinVersion = 0,
    kUnregisterProtocolHandlerMinVersion = 0,
    kDidDisplayInsecureContentMinVersion = 0,
    kDidContainInsecureFormActionMinVersion = 0,
    kMainDocumentElementAvailableMinVersion = 0,
    kSetNeedsOcclusionTrackingMinVersion = 0,
    kSetVirtualKeyboardModeMinVersion = 0,
    kVisibilityChangedMinVersion = 0,
    kDidChangeThemeColorMinVersion = 0,
    kDidChangeBackgroundColorMinVersion = 0,
    kDidFailLoadWithErrorMinVersion = 0,
    kDidFocusFrameMinVersion = 0,
    kDidCallFocusMinVersion = 0,
    kEnforceInsecureRequestPolicyMinVersion = 0,
    kEnforceInsecureNavigationsSetMinVersion = 0,
    kSuddenTerminationDisablerChangedMinVersion = 0,
    kHadStickyUserActivationBeforeNavigationChangedMinVersion = 0,
    kScrollRectToVisibleInParentFrameMinVersion = 0,
    kBubbleLogicalScrollInParentFrameMinVersion = 0,
    kStartLoadingForAsyncNavigationApiCommitMinVersion = 0,
    kDidBlockNavigationMinVersion = 0,
    kDidChangeLoadProgressMinVersion = 0,
    kDidFinishLoadMinVersion = 0,
    kDispatchLoadMinVersion = 0,
    kGoToEntryAtOffsetMinVersion = 0,
    kNavigateToNavigationApiKeyMinVersion = 0,
    kNavigateEventHandlerPresenceChangedMinVersion = 0,
    kUpdateTitleMinVersion = 0,
    kUpdateApplicationTitleMinVersion = 0,
    kUpdateUserActivationStateMinVersion = 0,
    kDidConsumeHistoryUserActivationMinVersion = 0,
    kHandleAccessibilityFindInPageResultMinVersion = 0,
    kHandleAccessibilityFindInPageTerminationMinVersion = 0,
    kDocumentOnLoadCompletedMinVersion = 0,
    kForwardResourceTimingToParentMinVersion = 0,
    kDidDispatchDOMContentLoadedEventMinVersion = 0,
    kRunModalAlertDialogMinVersion = 0,
    kRunModalConfirmDialogMinVersion = 0,
    kRunModalPromptDialogMinVersion = 0,
    kRunBeforeUnloadConfirmMinVersion = 0,
    kUpdateFaviconURLMinVersion = 0,
    kDownloadURLMinVersion = 0,
    kFocusedElementChangedMinVersion = 0,
    kTextSelectionChangedMinVersion = 0,
    kShowPopupMenuMinVersion = 0,
    kCreateNewPopupWidgetMinVersion = 0,
    kShowContextMenuMinVersion = 0,
    kDidLoadResourceFromMemoryCacheMinVersion = 0,
    kDidChangeFrameOwnerPropertiesMinVersion = 0,
    kDidChangeOpenerMinVersion = 0,
    kDidChangeFramePolicyMinVersion = 0,
    kDidChangeIframeAttributesMinVersion = 0,
    kCapturePaintPreviewOfSubframeMinVersion = 0,
    kSetCloseListenerMinVersion = 0,
    kDetachMinVersion = 0,
    kGetKeepAliveHandleFactoryMinVersion = 0,
    kDidAddMessageToConsoleMinVersion = 0,
    kFrameSizeChangedMinVersion = 0,
    kDidInferColorSchemeMinVersion = 0,
    kDidChangeSrcDocMinVersion = 0,
    kReceivedDelegatedCapabilityMinVersion = 0,
    kSendFencedFrameReportingBeaconMinVersion = 0,
    kSendFencedFrameReportingBeaconToCustomURLMinVersion = 0,
    kDisableUntrustedNetworkInFencedFrameMinVersion = 0,
    kExemptUrlFromNetworkRevocationForTestingMinVersion = 0,
    kSendLegacyTechEventMinVersion = 0,
    kSetFencedFrameAutomaticBeaconReportEventDataMinVersion = 0,
    kSendPrivateAggregationRequestsForFencedFrameEventMinVersion = 0,
    kCreateFencedFrameMinVersion = 0,
    kForwardFencedFrameEventAndUserActivationToEmbedderMinVersion = 0,
    kOnViewTransitionOptInChangedMinVersion = 0,
    kStartDraggingMinVersion = 0,
    kIssueKeepAliveHandleMinVersion = 0,
    kNotifyStorageAccessedMinVersion = 0,
    kRecordWindowProxyUsageMetricsMinVersion = 0,
    kNotifyDocumentInteractiveMinVersion = 0,
    kSetStorageAccessApiStatusMinVersion = 0,
    kInitializeCrashReportStorageMinVersion = 0,
    kSetCrashReportStorageKeyMinVersion = 0,
    kRemoveCrashReportStorageKeyMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct EnterFullscreen_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExitFullscreen_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FullscreenStateChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RegisterProtocolHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UnregisterProtocolHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidDisplayInsecureContent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidContainInsecureFormAction_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MainDocumentElementAvailable_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetNeedsOcclusionTracking_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetVirtualKeyboardMode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct VisibilityChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidChangeThemeColor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidChangeBackgroundColor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidFailLoadWithError_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidFocusFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidCallFocus_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnforceInsecureRequestPolicy_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnforceInsecureNavigationsSet_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SuddenTerminationDisablerChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HadStickyUserActivationBeforeNavigationChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ScrollRectToVisibleInParentFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BubbleLogicalScrollInParentFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StartLoadingForAsyncNavigationApiCommit_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidBlockNavigation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidChangeLoadProgress_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidFinishLoad_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchLoad_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GoToEntryAtOffset_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NavigateToNavigationApiKey_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NavigateEventHandlerPresenceChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateTitle_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateApplicationTitle_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateUserActivationState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidConsumeHistoryUserActivation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HandleAccessibilityFindInPageResult_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HandleAccessibilityFindInPageTermination_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DocumentOnLoadCompleted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ForwardResourceTimingToParent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidDispatchDOMContentLoadedEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RunModalAlertDialog_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RunModalConfirmDialog_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RunModalPromptDialog_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RunBeforeUnloadConfirm_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateFaviconURL_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DownloadURL_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FocusedElementChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TextSelectionChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowPopupMenu_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateNewPopupWidget_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowContextMenu_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidLoadResourceFromMemoryCache_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidChangeFrameOwnerProperties_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidChangeOpener_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidChangeFramePolicy_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidChangeIframeAttributes_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CapturePaintPreviewOfSubframe_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetCloseListener_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Detach_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetKeepAliveHandleFactory_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidAddMessageToConsole_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FrameSizeChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidInferColorScheme_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidChangeSrcDoc_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReceivedDelegatedCapability_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SendFencedFrameReportingBeacon_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SendFencedFrameReportingBeaconToCustomURL_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DisableUntrustedNetworkInFencedFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExemptUrlFromNetworkRevocationForTesting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SendLegacyTechEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetFencedFrameAutomaticBeaconReportEventData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SendPrivateAggregationRequestsForFencedFrameEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateFencedFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ForwardFencedFrameEventAndUserActivationToEmbedder_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnViewTransitionOptInChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StartDragging_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IssueKeepAliveHandle_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyStorageAccessed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RecordWindowProxyUsageMetrics_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyDocumentInteractive_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetStorageAccessApiStatus_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct InitializeCrashReportStorage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetCrashReportStorageKey_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoveCrashReportStorageKey_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~LocalFrameHost() = default;

  using EnterFullscreenCallback = base::OnceCallback<void(bool)>;
  using EnterFullscreenMojoCallback = base::OnceCallback<void(bool)>;

  virtual void EnterFullscreen(::blink::mojom::blink::FullscreenOptionsPtr options, EnterFullscreenCallback callback) = 0;

  virtual void ExitFullscreen() = 0;

  virtual void FullscreenStateChanged(bool is_fullscreen, ::blink::mojom::blink::FullscreenOptionsPtr options) = 0;

  virtual void RegisterProtocolHandler(const ::blink::String& scheme, const ::blink::KURL& url, bool user_gesture) = 0;

  virtual void UnregisterProtocolHandler(const ::blink::String& scheme, const ::blink::KURL& url, bool user_gesture) = 0;

  virtual void DidDisplayInsecureContent() = 0;

  virtual void DidContainInsecureFormAction() = 0;

  virtual void MainDocumentElementAvailable(bool uses_temporary_zoom_level) = 0;

  virtual void SetNeedsOcclusionTracking(bool needs_tracking) = 0;

  virtual void SetVirtualKeyboardMode(::ui::mojom::blink::VirtualKeyboardMode type) = 0;

  virtual void VisibilityChanged(::blink::mojom::blink::FrameVisibility visibility) = 0;

  virtual void DidChangeThemeColor(std::optional<::SkColor> theme_color) = 0;

  virtual void DidChangeBackgroundColor(const ::SkColor4f& background_color, bool color_adjust) = 0;

  virtual void DidFailLoadWithError(const ::blink::KURL& url, int32_t error_code) = 0;

  virtual void DidFocusFrame() = 0;

  virtual void DidCallFocus() = 0;

  virtual void EnforceInsecureRequestPolicy(::blink::mojom::blink::InsecureRequestPolicy policy_bitmap) = 0;

  virtual void EnforceInsecureNavigationsSet(const ::blink::Vector<uint32_t>& set) = 0;

  virtual void SuddenTerminationDisablerChanged(bool present, ::blink::mojom::blink::SuddenTerminationDisablerType disabler_type) = 0;

  virtual void HadStickyUserActivationBeforeNavigationChanged(bool has_gesture) = 0;

  virtual void ScrollRectToVisibleInParentFrame(const ::gfx::RectF& rect_to_scroll, ::blink::mojom::blink::ScrollIntoViewParamsPtr params) = 0;

  virtual void BubbleLogicalScrollInParentFrame(::blink::mojom::blink::ScrollDirection direction, ::ui::ScrollGranularity granularity) = 0;

  virtual void StartLoadingForAsyncNavigationApiCommit() = 0;

  virtual void DidBlockNavigation(const ::blink::KURL& blocked_url, ::blink::mojom::blink::NavigationBlockedReason reason) = 0;

  virtual void DidChangeLoadProgress(double load_progress) = 0;

  virtual void DidFinishLoad(const ::blink::KURL& validated_url) = 0;

  virtual void DispatchLoad() = 0;

  virtual void GoToEntryAtOffset(int32_t offset, bool has_user_gesture, ::base::TimeTicks actual_navigation_start, std::optional<::blink::scheduler::TaskAttributionId> soft_navigation_heuristics_task_id) = 0;

  virtual void NavigateToNavigationApiKey(const ::blink::String& key, bool has_user_gesture, ::base::TimeTicks actual_navigation_start, std::optional<::blink::scheduler::TaskAttributionId> soft_navigation_heuristics_task_id) = 0;

  virtual void NavigateEventHandlerPresenceChanged(bool present) = 0;

  virtual void UpdateTitle(const ::blink::String& title, ::base::i18n::TextDirection title_direction) = 0;

  virtual void UpdateApplicationTitle(const ::blink::String& application_title) = 0;

  virtual void UpdateUserActivationState(::blink::mojom::blink::UserActivationUpdateType update_type, ::blink::mojom::blink::UserActivationNotificationType notification_type) = 0;

  virtual void DidConsumeHistoryUserActivation() = 0;

  virtual void HandleAccessibilityFindInPageResult(FindInPageResultAXParamsPtr params) = 0;

  virtual void HandleAccessibilityFindInPageTermination() = 0;

  virtual void DocumentOnLoadCompleted() = 0;

  virtual void ForwardResourceTimingToParent(::blink::mojom::blink::ResourceTimingInfoPtr timing) = 0;

  virtual void DidDispatchDOMContentLoadedEvent() = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool RunModalAlertDialog(const ::blink::String& alert_message, bool disable_third_party_subframe_suppresion);
  using RunModalAlertDialogCallback = base::OnceCallback<void()>;
  using RunModalAlertDialogMojoCallback = base::OnceCallback<void()>;

  virtual void RunModalAlertDialog(const ::blink::String& alert_message, bool disable_third_party_subframe_suppresion, RunModalAlertDialogCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool RunModalConfirmDialog(const ::blink::String& alert_message, bool disable_third_party_subframe_suppresion, bool* out_success);
  using RunModalConfirmDialogCallback = base::OnceCallback<void(bool)>;
  using RunModalConfirmDialogMojoCallback = base::OnceCallback<void(bool)>;

  virtual void RunModalConfirmDialog(const ::blink::String& alert_message, bool disable_third_party_subframe_suppresion, RunModalConfirmDialogCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool RunModalPromptDialog(const ::blink::String& alert_message, const ::blink::String& default_value, bool disable_third_party_subframe_suppresion, bool* out_success, ::blink::String* out_result);
  using RunModalPromptDialogCallback = base::OnceCallback<void(bool, const ::blink::String&)>;
  using RunModalPromptDialogMojoCallback = base::OnceCallback<void(bool, const ::blink::String&)>;

  virtual void RunModalPromptDialog(const ::blink::String& alert_message, const ::blink::String& default_value, bool disable_third_party_subframe_suppresion, RunModalPromptDialogCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool RunBeforeUnloadConfirm(bool is_reload, bool* out_success);
  using RunBeforeUnloadConfirmCallback = base::OnceCallback<void(bool)>;
  using RunBeforeUnloadConfirmMojoCallback = base::OnceCallback<void(bool)>;

  virtual void RunBeforeUnloadConfirm(bool is_reload, RunBeforeUnloadConfirmCallback callback) = 0;

  virtual void UpdateFaviconURL(::blink::Vector<::blink::mojom::blink::FaviconURLPtr> favicon_urls) = 0;

  virtual void DownloadURL(DownloadURLParamsPtr params) = 0;

  virtual void FocusedElementChanged(bool is_editable_element, bool is_richly_editable_element, const ::gfx::Rect& bounds_in_frame_widget, ::blink::mojom::blink::FocusType focus_type) = 0;

  virtual void TextSelectionChanged(const ::blink::String& text, uint32_t offset, const ::gfx::Range& range) = 0;

  virtual void ShowPopupMenu(::mojo::PendingRemote<::blink::mojom::blink::PopupMenuClient> popup_client, const ::gfx::Rect& bounds, double font_size, int32_t selected_item, ::blink::Vector<::blink::mojom::blink::MenuItemPtr> menu_items, bool right_aligned, bool allow_multiple_selection) = 0;

  virtual void CreateNewPopupWidget(::mojo::PendingAssociatedReceiver<::blink::mojom::blink::PopupWidgetHost> popup_host, ::mojo::PendingAssociatedReceiver<::blink::mojom::blink::WidgetHost> blink_widget_host, ::mojo::PendingAssociatedRemote<::blink::mojom::blink::Widget> blink_widget) = 0;

  virtual void ShowContextMenu(::mojo::PendingAssociatedRemote<::blink::mojom::blink::ContextMenuClient> client, const ::blink::UntrustworthyContextMenuParams& params) = 0;

  virtual void DidLoadResourceFromMemoryCache(const ::blink::KURL& url, const ::blink::String& http_method, const ::blink::String& mime_type, ::network::mojom::blink::RequestDestination request_destination, bool include_credentials) = 0;

  virtual void DidChangeFrameOwnerProperties(const ::blink::FrameToken& child_frame_token, ::blink::mojom::blink::FrameOwnerPropertiesPtr frame_owner_properties) = 0;

  virtual void DidChangeOpener(const std::optional<::blink::LocalFrameToken>& opener_frame) = 0;

  virtual void DidChangeFramePolicy(const ::blink::FrameToken& child_frame_token, const ::blink::FramePolicy& frame_policy) = 0;

  virtual void DidChangeIframeAttributes(const ::blink::FrameToken& child_frame_token, IframeAttributesPtr attributes) = 0;

  virtual void CapturePaintPreviewOfSubframe(const ::gfx::Rect& clip_rect, const ::base::UnguessableToken& guid) = 0;

  virtual void SetCloseListener(::mojo::PendingRemote<::blink::mojom::blink::CloseListener> listener) = 0;

  virtual void Detach() = 0;

  virtual void GetKeepAliveHandleFactory(::mojo::PendingReceiver<::blink::mojom::blink::KeepAliveHandleFactory> factory) = 0;

  virtual void DidAddMessageToConsole(::blink::mojom::blink::ConsoleMessageLevel log_level, const ::blink::String& msg, uint32_t line_number, const ::blink::String& source_id, const ::blink::String& untrusted_stack_trace) = 0;

  virtual void FrameSizeChanged(const ::gfx::Size& size) = 0;

  virtual void DidInferColorScheme(::blink::mojom::blink::PreferredColorScheme color_scheme) = 0;

  virtual void DidChangeSrcDoc(const ::blink::FrameToken& child_frame_token, const ::blink::String& srcdoc_value) = 0;

  virtual void ReceivedDelegatedCapability(::blink::mojom::blink::DelegatedCapability delegated_capability) = 0;

  virtual void SendFencedFrameReportingBeacon(const ::blink::String& event_data, const ::blink::String& event_type, const ::blink::Vector<::blink::FencedFrame::ReportingDestination>& destinations, bool cross_origin_exposed) = 0;

  virtual void SendFencedFrameReportingBeaconToCustomURL(const ::blink::KURL& destination_url, bool cross_origin_exposed) = 0;

  using DisableUntrustedNetworkInFencedFrameCallback = base::OnceCallback<void()>;
  using DisableUntrustedNetworkInFencedFrameMojoCallback = base::OnceCallback<void()>;

  virtual void DisableUntrustedNetworkInFencedFrame(DisableUntrustedNetworkInFencedFrameCallback callback) = 0;

  using ExemptUrlFromNetworkRevocationForTestingCallback = base::OnceCallback<void()>;
  using ExemptUrlFromNetworkRevocationForTestingMojoCallback = base::OnceCallback<void()>;

  virtual void ExemptUrlFromNetworkRevocationForTesting(const ::blink::KURL& exempted_url, ExemptUrlFromNetworkRevocationForTestingCallback callback) = 0;

  virtual void SendLegacyTechEvent(const ::blink::String& type, LegacyTechEventCodeLocationPtr code_location) = 0;

  virtual void SetFencedFrameAutomaticBeaconReportEventData(::blink::mojom::blink::AutomaticBeaconType event_type, const ::blink::String& event_data, const ::blink::Vector<::blink::FencedFrame::ReportingDestination>& destinations, bool once, bool cross_origin_exposed) = 0;

  virtual void SendPrivateAggregationRequestsForFencedFrameEvent(const ::blink::String& event_type) = 0;

  virtual void CreateFencedFrame(::mojo::PendingAssociatedReceiver<::blink::mojom::blink::FencedFrameOwnerHost> fenced_frame, ::blink::mojom::blink::RemoteFrameInterfacesFromRendererPtr remote_frame_interfaces, const ::blink::RemoteFrameToken& frame_token, const ::base::UnguessableToken& devtools_frame_token) = 0;

  virtual void ForwardFencedFrameEventAndUserActivationToEmbedder(const ::blink::String& event_type) = 0;

  virtual void OnViewTransitionOptInChanged(ViewTransitionSameOriginOptIn view_transition_opt_in) = 0;

  virtual void StartDragging(const ::blink::WebDragData& drag_data, ::blink::DragOperationsMask operations_allowed, const ::SkBitmap& image, const ::gfx::Vector2d& cursor_offset_in_dip, const ::gfx::Rect& drag_obj_rect_in_dip, ::blink::mojom::blink::DragEventSourceInfoPtr event_info) = 0;

  virtual void IssueKeepAliveHandle(::mojo::PendingReceiver<::blink::mojom::blink::NavigationStateKeepAliveHandle> receiver) = 0;

  virtual void NotifyStorageAccessed(StorageTypeAccessed storageType, bool blocked) = 0;

  virtual void RecordWindowProxyUsageMetrics(const ::blink::FrameToken& target_frame_token, WindowProxyAccessType access_type) = 0;

  virtual void NotifyDocumentInteractive() = 0;

  virtual void SetStorageAccessApiStatus(::net::StorageAccessApiStatus status) = 0;

  using InitializeCrashReportStorageCallback = base::OnceCallback<void()>;
  using InitializeCrashReportStorageMojoCallback = base::OnceCallback<void()>;

  virtual void InitializeCrashReportStorage(uint64_t length, InitializeCrashReportStorageCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool SetCrashReportStorageKey(const ::blink::String& key, const ::blink::String& value);
  using SetCrashReportStorageKeyCallback = base::OnceCallback<void()>;
  using SetCrashReportStorageKeyMojoCallback = base::OnceCallback<void()>;

  virtual void SetCrashReportStorageKey(const ::blink::String& key, const ::blink::String& value, SetCrashReportStorageKeyCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool RemoveCrashReportStorageKey(const ::blink::String& key);
  using RemoveCrashReportStorageKeyCallback = base::OnceCallback<void()>;
  using RemoveCrashReportStorageKeyMojoCallback = base::OnceCallback<void()>;

  virtual void RemoveCrashReportStorageKey(const ::blink::String& key, RemoveCrashReportStorageKeyCallback callback) = 0;
};

class NonAssociatedLocalFrameHostProxy;

template <typename ImplRefTraits>
class NonAssociatedLocalFrameHostStub;

class NonAssociatedLocalFrameHostRequestValidator;


class CORE_EXPORT NonAssociatedLocalFrameHost
    : public NonAssociatedLocalFrameHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.NonAssociatedLocalFrameHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = NonAssociatedLocalFrameHostInterfaceBase;
  using Proxy_ = NonAssociatedLocalFrameHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = NonAssociatedLocalFrameHostStub<ImplRefTraits>;

  using RequestValidator_ = NonAssociatedLocalFrameHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kMaybeStartOutermostMainFrameNavigationMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct MaybeStartOutermostMainFrameNavigation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~NonAssociatedLocalFrameHost() = default;

  virtual void MaybeStartOutermostMainFrameNavigation(const ::blink::Vector<::blink::KURL>& urls) = 0;
};

class LocalFrameProxy;

template <typename ImplRefTraits>
class LocalFrameStub;

class LocalFrameRequestValidator;
class LocalFrameResponseValidator;


class CORE_EXPORT LocalFrame
    : public LocalFrameInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.LocalFrame";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = LocalFrameInterfaceBase;
  using Proxy_ = LocalFrameProxy;

  template <typename ImplRefTraits>
  using Stub_ = LocalFrameStub<ImplRefTraits>;

  using RequestValidator_ = LocalFrameRequestValidator;
  using ResponseValidator_ = LocalFrameResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetTextSurroundingSelectionMinVersion = 0,
    kSendInterventionReportMinVersion = 0,
    kSetFrameOwnerPropertiesMinVersion = 0,
    kNotifyUserActivationMinVersion = 0,
    kNotifyVirtualKeyboardOverlayRectMinVersion = 0,
    kShowInterestInElementMinVersion = 0,
    kAddMessageToConsoleMinVersion = 0,
    kSwapInImmediatelyMinVersion = 0,
    kCheckCompletedMinVersion = 0,
    kStopLoadingMinVersion = 0,
    kCollapseMinVersion = 0,
    kEnableViewSourceModeMinVersion = 0,
    kFocusMinVersion = 0,
    kClearFocusedElementMinVersion = 0,
    kCopyImageAtMinVersion = 0,
    kSaveImageAtMinVersion = 0,
    kReportBlinkFeatureUsageMinVersion = 0,
    kRenderFallbackContentMinVersion = 0,
    kBeforeUnloadMinVersion = 0,
    kMediaPlayerActionAtMinVersion = 0,
    kRequestVideoFrameAtWithBoundsHintMinVersion = 0,
    kPluginActionAtMinVersion = 0,
    kAdvanceFocusInFrameMinVersion = 0,
    kAdvanceFocusForIMEMinVersion = 0,
    kReportContentSecurityPolicyViolationMinVersion = 0,
    kDidUpdateFramePolicyMinVersion = 0,
    kOnFrameVisibilityChangedMinVersion = 0,
    kPostMessageEventMinVersion = 0,
    kJavaScriptMethodExecuteRequestMinVersion = 0,
    kJavaScriptExecuteRequestMinVersion = 0,
    kJavaScriptExecuteRequestForTestsMinVersion = 0,
    kJavaScriptExecuteRequestInIsolatedWorldMinVersion = 0,
    kJavaScriptAwaitPromiseInIsolatedWorldMinVersion = 0,
    kGetCharacterIndexAtPointMinVersion = 0,
    kGetFirstRectForRangeMinVersion = 0,
    kGetStringForRangeMinVersion = 0,
    kBindReportingObserverMinVersion = 0,
    kUpdateOpenerMinVersion = 0,
    kGetSavableResourceLinksMinVersion = 0,
    kMixedContentFoundMinVersion = 0,
    kBindDevToolsAgentMinVersion = 0,
    kExtractAnnotatedTextMinVersion = 0,
    kExtractSerializedDomMinVersion = 0,
    kExtractSerializedDomElementInfoMinVersion = 0,
    kHandleRendererDebugURLMinVersion = 0,
    kGetCanonicalUrlForSharingMinVersion = 0,
    kGetOpenGraphMetadataMinVersion = 0,
    kSetNavigationApiHistoryEntriesForRestoreMinVersion = 0,
    kUpdatePrerenderURLMinVersion = 0,
    kNotifyNavigationApiOfDisposedEntriesMinVersion = 0,
    kTraverseCancelledMinVersion = 0,
    kDispatchNavigateEventForCrossDocumentTraversalMinVersion = 0,
    kSnapshotDocumentForViewTransitionMinVersion = 0,
    kNotifyViewTransitionAbortedToOldDocumentMinVersion = 0,
    kDispatchPageSwapMinVersion = 0,
    kAddResourceTimingEntryForFailedSubframeNavigationMinVersion = 0,
    kGetScrollPositionMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetTextSurroundingSelection_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SendInterventionReport_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetFrameOwnerProperties_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyUserActivation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyVirtualKeyboardOverlayRect_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowInterestInElement_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddMessageToConsole_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SwapInImmediately_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CheckCompleted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StopLoading_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Collapse_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnableViewSourceMode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Focus_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearFocusedElement_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CopyImageAt_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SaveImageAt_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReportBlinkFeatureUsage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RenderFallbackContent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BeforeUnload_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MediaPlayerActionAt_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestVideoFrameAtWithBoundsHint_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PluginActionAt_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AdvanceFocusInFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AdvanceFocusForIME_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReportContentSecurityPolicyViolation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidUpdateFramePolicy_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnFrameVisibilityChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PostMessageEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct JavaScriptMethodExecuteRequest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct JavaScriptExecuteRequest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct JavaScriptExecuteRequestForTests_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct JavaScriptExecuteRequestInIsolatedWorld_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct JavaScriptAwaitPromiseInIsolatedWorld_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetCharacterIndexAtPoint_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetFirstRectForRange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetStringForRange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindReportingObserver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateOpener_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetSavableResourceLinks_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MixedContentFound_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindDevToolsAgent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExtractAnnotatedText_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExtractSerializedDom_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExtractSerializedDomElementInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HandleRendererDebugURL_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetCanonicalUrlForSharing_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetOpenGraphMetadata_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetNavigationApiHistoryEntriesForRestore_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdatePrerenderURL_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyNavigationApiOfDisposedEntries_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TraverseCancelled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchNavigateEventForCrossDocumentTraversal_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SnapshotDocumentForViewTransition_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyViewTransitionAbortedToOldDocument_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchPageSwap_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddResourceTimingEntryForFailedSubframeNavigation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetScrollPosition_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~LocalFrame() = default;

  using GetTextSurroundingSelectionCallback = base::OnceCallback<void(const ::blink::String&, uint32_t, uint32_t)>;
  using GetTextSurroundingSelectionMojoCallback = base::OnceCallback<void(const ::blink::String&, uint32_t, uint32_t)>;

  virtual void GetTextSurroundingSelection(uint32_t max_length, GetTextSurroundingSelectionCallback callback) = 0;

  virtual void SendInterventionReport(const ::blink::String& id, const ::blink::String& message, const std::optional<::blink::FrameToken>& child_frame_token) = 0;

  virtual void SetFrameOwnerProperties(::blink::mojom::blink::FrameOwnerPropertiesPtr properties) = 0;

  virtual void NotifyUserActivation(::blink::mojom::blink::UserActivationNotificationType notification_type) = 0;

  virtual void NotifyVirtualKeyboardOverlayRect(const ::gfx::Rect& keyboard_rect) = 0;

  virtual void ShowInterestInElement(int32_t nodeID) = 0;

  virtual void AddMessageToConsole(::blink::mojom::blink::ConsoleMessageLevel level, const ::blink::String& message, bool discard_duplicates) = 0;

  virtual void SwapInImmediately() = 0;

  virtual void CheckCompleted() = 0;

  virtual void StopLoading() = 0;

  virtual void Collapse(bool collapsed) = 0;

  virtual void EnableViewSourceMode() = 0;

  virtual void Focus() = 0;

  virtual void ClearFocusedElement() = 0;

  virtual void CopyImageAt(const ::gfx::Point& window_point) = 0;

  virtual void SaveImageAt(const ::gfx::Point& window_point) = 0;

  virtual void ReportBlinkFeatureUsage(const ::blink::Vector<::blink::mojom::blink::WebFeature>& features) = 0;

  virtual void RenderFallbackContent() = 0;

  using BeforeUnloadCallback = base::OnceCallback<void(bool, ::base::TimeTicks, ::base::TimeTicks)>;
  using BeforeUnloadMojoCallback = base::OnceCallback<void(bool, ::base::TimeTicks, ::base::TimeTicks)>;

  virtual void BeforeUnload(bool is_reload, BeforeUnloadCallback callback) = 0;

  virtual void MediaPlayerActionAt(const ::gfx::Point& location, ::blink::mojom::blink::MediaPlayerActionPtr action) = 0;

  using RequestVideoFrameAtWithBoundsHintCallback = base::OnceCallback<void(const ::SkBitmap&, const ::gfx::Rect&)>;
  using RequestVideoFrameAtWithBoundsHintMojoCallback = base::OnceCallback<void(const ::SkBitmap&, const ::gfx::Rect&)>;

  virtual void RequestVideoFrameAtWithBoundsHint(const ::gfx::Point& location, const ::gfx::Size& max_size, int32_t max_area, RequestVideoFrameAtWithBoundsHintCallback callback) = 0;

  virtual void PluginActionAt(const ::gfx::Point& location, PluginActionType action) = 0;

  virtual void AdvanceFocusInFrame(::blink::mojom::blink::FocusType focus_type, const std::optional<::blink::RemoteFrameToken>& source_frame_token) = 0;

  virtual void AdvanceFocusForIME(::blink::mojom::blink::FocusType focus_type) = 0;

  virtual void ReportContentSecurityPolicyViolation(::network::mojom::blink::CSPViolationPtr violation) = 0;

  virtual void DidUpdateFramePolicy(const ::blink::FramePolicy& frame_policy) = 0;

  virtual void OnFrameVisibilityChanged(::blink::mojom::blink::FrameVisibility visibility) = 0;

  virtual void PostMessageEvent(const std::optional<::blink::RemoteFrameToken>& source_frame_token, const ::scoped_refptr<const ::blink::SecurityOrigin>& source_origin, const ::scoped_refptr<const ::blink::SecurityOrigin>& target_origin, ::blink::BlinkTransferableMessage message) = 0;

  using JavaScriptMethodExecuteRequestCallback = base::OnceCallback<void(::base::Value)>;
  using JavaScriptMethodExecuteRequestMojoCallback = base::OnceCallback<void(::base::Value)>;

  virtual void JavaScriptMethodExecuteRequest(const ::blink::String& object_name, const ::blink::String& method_name, ::base::Value::List arguments, bool wants_result, JavaScriptMethodExecuteRequestCallback callback) = 0;

  using JavaScriptExecuteRequestCallback = base::OnceCallback<void(::base::Value)>;
  using JavaScriptExecuteRequestMojoCallback = base::OnceCallback<void(::base::Value)>;

  virtual void JavaScriptExecuteRequest(const ::blink::String& javascript, bool wants_result, JavaScriptExecuteRequestCallback callback) = 0;

  using JavaScriptExecuteRequestForTestsCallback = base::OnceCallback<void(JavaScriptExecutionResultType, ::base::Value)>;
  using JavaScriptExecuteRequestForTestsMojoCallback = base::OnceCallback<void(JavaScriptExecutionResultType, ::base::Value)>;

  virtual void JavaScriptExecuteRequestForTests(const ::blink::String& javascript, bool has_user_gesture, bool resolve_promises, bool honor_js_content_settings, int32_t world_id, JavaScriptExecuteRequestForTestsCallback callback) = 0;

  using JavaScriptExecuteRequestInIsolatedWorldCallback = base::OnceCallback<void(::base::Value)>;
  using JavaScriptExecuteRequestInIsolatedWorldMojoCallback = base::OnceCallback<void(::base::Value)>;

  virtual void JavaScriptExecuteRequestInIsolatedWorld(const ::blink::String& javascript, bool wants_result, int32_t world_id, JavaScriptExecuteRequestInIsolatedWorldCallback callback) = 0;

  using JavaScriptAwaitPromiseInIsolatedWorldCallback = base::OnceCallback<void(::base::Value)>;
  using JavaScriptAwaitPromiseInIsolatedWorldMojoCallback = base::OnceCallback<void(::base::Value)>;

  virtual void JavaScriptAwaitPromiseInIsolatedWorld(const ::blink::String& javascript, int32_t world_id, JavaScriptAwaitPromiseInIsolatedWorldCallback callback) = 0;

  virtual void GetCharacterIndexAtPoint(const ::gfx::Point& location) = 0;

  virtual void GetFirstRectForRange(const ::gfx::Range& range) = 0;

  using GetStringForRangeCallback = base::OnceCallback<void(::ui::mojom::blink::AttributedStringPtr, const ::gfx::Point&)>;
  using GetStringForRangeMojoCallback = base::OnceCallback<void(::ui::mojom::blink::AttributedStringPtr, const ::gfx::Point&)>;

  virtual void GetStringForRange(const ::gfx::Range& range, GetStringForRangeCallback callback) = 0;

  virtual void BindReportingObserver(::mojo::PendingReceiver<::blink::mojom::blink::ReportingObserver> receiver) = 0;

  virtual void UpdateOpener(const std::optional<::blink::FrameToken>& opener_frame_token) = 0;

  using GetSavableResourceLinksCallback = base::OnceCallback<void(GetSavableResourceLinksReplyPtr)>;
  using GetSavableResourceLinksMojoCallback = base::OnceCallback<void(GetSavableResourceLinksReplyPtr)>;

  virtual void GetSavableResourceLinks(GetSavableResourceLinksCallback callback) = 0;

  virtual void MixedContentFound(const ::blink::KURL& main_resource_url, const ::blink::KURL& mixed_content_url, ::blink::mojom::blink::RequestContextType request_context, bool was_allowed, const ::blink::KURL& url_before_redirects, bool had_redirect, ::network::mojom::blink::SourceLocationPtr source_location) = 0;

  virtual void BindDevToolsAgent(::mojo::PendingAssociatedRemote<::blink::mojom::blink::DevToolsAgentHost> agent_host, ::mojo::PendingAssociatedReceiver<::blink::mojom::blink::DevToolsAgent> agent) = 0;

  using ExtractAnnotatedTextCallback = base::OnceCallback<void(const ::blink::String&)>;
  using ExtractAnnotatedTextMojoCallback = base::OnceCallback<void(const ::blink::String&)>;

  virtual void ExtractAnnotatedText(uint64_t char_count_goal, ExtractAnnotatedTextCallback callback) = 0;

  using ExtractSerializedDomCallback = base::OnceCallback<void(const ::blink::String&)>;
  using ExtractSerializedDomMojoCallback = base::OnceCallback<void(const ::blink::String&)>;

  virtual void ExtractSerializedDom(ExtractSerializedDomCallback callback) = 0;

  using ExtractSerializedDomElementInfoCallback = base::OnceCallback<void(SerializedDomElementInfoPtr)>;
  using ExtractSerializedDomElementInfoMojoCallback = base::OnceCallback<void(SerializedDomElementInfoPtr)>;

  virtual void ExtractSerializedDomElementInfo(const ::blink::String& id, ExtractSerializedDomElementInfoCallback callback) = 0;

  virtual void HandleRendererDebugURL(const ::blink::KURL& url) = 0;

  using GetCanonicalUrlForSharingCallback = base::OnceCallback<void(const std::optional<::blink::KURL>&)>;
  using GetCanonicalUrlForSharingMojoCallback = base::OnceCallback<void(const std::optional<::blink::KURL>&)>;

  virtual void GetCanonicalUrlForSharing(GetCanonicalUrlForSharingCallback callback) = 0;

  using GetOpenGraphMetadataCallback = base::OnceCallback<void(::blink::mojom::blink::OpenGraphMetadataPtr)>;
  using GetOpenGraphMetadataMojoCallback = base::OnceCallback<void(::blink::mojom::blink::OpenGraphMetadataPtr)>;

  virtual void GetOpenGraphMetadata(GetOpenGraphMetadataCallback callback) = 0;

  virtual void SetNavigationApiHistoryEntriesForRestore(::blink::mojom::blink::NavigationApiHistoryEntryArraysPtr entry_arrays, NavigationApiEntryRestoreReason restore_reason) = 0;

  using UpdatePrerenderURLCallback = base::OnceCallback<void()>;
  using UpdatePrerenderURLMojoCallback = base::OnceCallback<void()>;

  virtual void UpdatePrerenderURL(const ::blink::KURL& matched_url, UpdatePrerenderURLCallback callback) = 0;

  virtual void NotifyNavigationApiOfDisposedEntries(const ::blink::Vector<::blink::String>& keys) = 0;

  virtual void TraverseCancelled(const ::blink::String& navigation_api_key, TraverseCancelledReason reason) = 0;

  virtual void DispatchNavigateEventForCrossDocumentTraversal(const ::blink::KURL& url, const std::string& page_state, bool is_browser_initiated) = 0;

  using SnapshotDocumentForViewTransitionCallback = base::OnceCallback<void(const ::blink::ViewTransitionState&)>;
  using SnapshotDocumentForViewTransitionMojoCallback = base::OnceCallback<void(const ::blink::ViewTransitionState&)>;

  virtual void SnapshotDocumentForViewTransition(const ::blink::ViewTransitionToken& transition_token, ::blink::mojom::blink::PageSwapEventParamsPtr page_swap_event_params, SnapshotDocumentForViewTransitionCallback callback) = 0;

  virtual void NotifyViewTransitionAbortedToOldDocument() = 0;

  virtual void DispatchPageSwap(::blink::mojom::blink::PageSwapEventParamsPtr page_swap_event_params) = 0;

  virtual void AddResourceTimingEntryForFailedSubframeNavigation(const ::blink::FrameToken& subframe_token, const ::blink::KURL& initial_url, ::base::TimeTicks start_time, ::base::TimeTicks redirect_time, ::base::TimeTicks request_start, ::base::TimeTicks response_start, uint32_t response_code, const ::blink::String& mime_type, ::network::mojom::blink::LoadTimingInfoPtr load_timing_info, ::net::HttpConnectionInfo connection_info, const ::blink::String& alpn_negotiated_protocol, bool is_secure_transport, bool is_validated, const ::blink::String& normalized_server_timing, const ::network::URLLoaderCompletionStatus& completion_status) = 0;

  using GetScrollPositionCallback = base::OnceCallback<void(const ::gfx::Point&)>;
  using GetScrollPositionMojoCallback = base::OnceCallback<void(const ::gfx::Point&)>;

  virtual void GetScrollPosition(GetScrollPositionCallback callback) = 0;
};

class LocalMainFrameProxy;

template <typename ImplRefTraits>
class LocalMainFrameStub;

class LocalMainFrameRequestValidator;
class LocalMainFrameResponseValidator;


class CORE_EXPORT LocalMainFrame
    : public LocalMainFrameInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.LocalMainFrame";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = LocalMainFrameInterfaceBase;
  using Proxy_ = LocalMainFrameProxy;

  template <typename ImplRefTraits>
  using Stub_ = LocalMainFrameStub<ImplRefTraits>;

  using RequestValidator_ = LocalMainFrameRequestValidator;
  using ResponseValidator_ = LocalMainFrameResponseValidator;
  enum MethodMinVersions : uint32_t {
    kAnimateDoubleTapZoomMinVersion = 0,
    kSetScaleFactorMinVersion = 0,
    kClosePageMinVersion = 0,
    kGetFullPageSizeMinVersion = 0,
    kSetInitialFocusMinVersion = 0,
    kEnablePreferredSizeChangedModeMinVersion = 0,
    kZoomToFindInPageRectMinVersion = 0,
    kInstallCoopAccessMonitorMinVersion = 0,
    kUpdateBrowserControlsStateMinVersion = 0,
    kSetV8CompileHintsMinVersion = 0,
    kDiscardMinVersion = 0,
    kFinalizeNavigationConfidenceMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AnimateDoubleTapZoom_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetScaleFactor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClosePage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetFullPageSize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetInitialFocus_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnablePreferredSizeChangedMode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ZoomToFindInPageRect_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct InstallCoopAccessMonitor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateBrowserControlsState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetV8CompileHints_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Discard_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FinalizeNavigationConfidence_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~LocalMainFrame() = default;

  virtual void AnimateDoubleTapZoom(const ::gfx::Point& point, const ::gfx::Rect& rect) = 0;

  virtual void SetScaleFactor(float scale) = 0;

  using ClosePageCallback = base::OnceCallback<void()>;
  using ClosePageMojoCallback = base::OnceCallback<void()>;

  virtual void ClosePage(ClosePageCallback callback) = 0;

  using GetFullPageSizeCallback = base::OnceCallback<void(const ::gfx::Size&)>;
  using GetFullPageSizeMojoCallback = base::OnceCallback<void(const ::gfx::Size&)>;

  virtual void GetFullPageSize(GetFullPageSizeCallback callback) = 0;

  virtual void SetInitialFocus(bool reverse) = 0;

  virtual void EnablePreferredSizeChangedMode() = 0;

  virtual void ZoomToFindInPageRect(const ::gfx::Rect& rect_in_root_frame) = 0;

  virtual void InstallCoopAccessMonitor(const ::blink::FrameToken& accessed_window, ::network::mojom::blink::CrossOriginOpenerPolicyReporterParamsPtr coop_reporter_info) = 0;

  virtual void UpdateBrowserControlsState(::cc::BrowserControlsState constraints, ::cc::BrowserControlsState current, bool animate, const std::optional<::cc::BrowserControlsOffsetTagModifications>& offset_tag_modifications) = 0;

  virtual void SetV8CompileHints(::base::ReadOnlySharedMemoryRegion data) = 0;

  using DiscardCallback = base::OnceCallback<void()>;
  using DiscardMojoCallback = base::OnceCallback<void()>;

  virtual void Discard(DiscardCallback callback) = 0;

  virtual void FinalizeNavigationConfidence(double randomized_trigger_rate, ::blink::mojom::blink::ConfidenceLevel confidence) = 0;
};

class LocalMainFrameHostProxy;

template <typename ImplRefTraits>
class LocalMainFrameHostStub;

class LocalMainFrameHostRequestValidator;
class LocalMainFrameHostResponseValidator;


class CORE_EXPORT LocalMainFrameHost
    : public LocalMainFrameHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.LocalMainFrameHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = LocalMainFrameHostInterfaceBase;
  using Proxy_ = LocalMainFrameHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = LocalMainFrameHostStub<ImplRefTraits>;

  using RequestValidator_ = LocalMainFrameHostRequestValidator;
  using ResponseValidator_ = LocalMainFrameHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kScaleFactorChangedMinVersion = 0,
    kContentsPreferredSizeChangedMinVersion = 0,
    kTextAutosizerPageInfoChangedMinVersion = 0,
    kFocusPageMinVersion = 0,
    kTakeFocusMinVersion = 0,
    kUpdateTargetURLMinVersion = 0,
    kRequestCloseMinVersion = 0,
    kShowCreatedWindowMinVersion = 0,
    kSetWindowRectMinVersion = 0,
    kDidFirstVisuallyNonEmptyPaintMinVersion = 0,
    kDidAccessInitialMainDocumentMinVersion = 0,
    kMaximizeMinVersion = 0,
    kMinimizeMinVersion = 0,
    kRestoreMinVersion = 0,
    kSetResizableMinVersion = 0,
    kDraggableRegionsChangedMinVersion = 0,
    kOnFirstContentfulPaintMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ScaleFactorChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ContentsPreferredSizeChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TextAutosizerPageInfoChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FocusPage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TakeFocus_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateTargetURL_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestClose_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowCreatedWindow_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetWindowRect_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidFirstVisuallyNonEmptyPaint_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidAccessInitialMainDocument_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Maximize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Minimize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Restore_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetResizable_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DraggableRegionsChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnFirstContentfulPaint_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~LocalMainFrameHost() = default;

  virtual void ScaleFactorChanged(float scale) = 0;

  virtual void ContentsPreferredSizeChanged(const ::gfx::Size& pref_size) = 0;

  virtual void TextAutosizerPageInfoChanged(::blink::mojom::blink::TextAutosizerPageInfoPtr page_info) = 0;

  virtual void FocusPage() = 0;

  virtual void TakeFocus(bool reverse) = 0;

  using UpdateTargetURLCallback = base::OnceCallback<void()>;
  using UpdateTargetURLMojoCallback = base::OnceCallback<void()>;

  virtual void UpdateTargetURL(const ::blink::KURL& url, UpdateTargetURLCallback callback) = 0;

  virtual void RequestClose() = 0;

  using ShowCreatedWindowCallback = base::OnceCallback<void()>;
  using ShowCreatedWindowMojoCallback = base::OnceCallback<void()>;

  virtual void ShowCreatedWindow(const ::blink::LocalFrameToken& opener_frame_token, ::ui::mojom::blink::WindowOpenDisposition disposition, ::blink::mojom::blink::WindowFeaturesPtr window_features, bool opened_by_user_gesture, ShowCreatedWindowCallback callback) = 0;

  using SetWindowRectCallback = base::OnceCallback<void()>;
  using SetWindowRectMojoCallback = base::OnceCallback<void()>;

  virtual void SetWindowRect(const ::gfx::Rect& bounds, SetWindowRectCallback callback) = 0;

  virtual void DidFirstVisuallyNonEmptyPaint() = 0;

  virtual void DidAccessInitialMainDocument() = 0;

  virtual void Maximize() = 0;

  virtual void Minimize() = 0;

  virtual void Restore() = 0;

  virtual void SetResizable(bool resizable) = 0;

  virtual void DraggableRegionsChanged(::blink::Vector<::blink::mojom::blink::DraggableRegionPtr> regions) = 0;

  virtual void OnFirstContentfulPaint(::base::TimeDelta duration) = 0;
};



class CORE_EXPORT LocalFrameHostProxy
    : public LocalFrameHost {
 public:
  using InterfaceType = LocalFrameHost;

  explicit LocalFrameHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void EnterFullscreen(::blink::mojom::blink::FullscreenOptionsPtr options, EnterFullscreenCallback callback) final;
  
  void ExitFullscreen() final;
  
  void FullscreenStateChanged(bool is_fullscreen, ::blink::mojom::blink::FullscreenOptionsPtr options) final;
  
  void RegisterProtocolHandler(const ::blink::String& scheme, const ::blink::KURL& url, bool user_gesture) final;
  
  void UnregisterProtocolHandler(const ::blink::String& scheme, const ::blink::KURL& url, bool user_gesture) final;
  
  void DidDisplayInsecureContent() final;
  
  void DidContainInsecureFormAction() final;
  
  void MainDocumentElementAvailable(bool uses_temporary_zoom_level) final;
  
  void SetNeedsOcclusionTracking(bool needs_tracking) final;
  
  void SetVirtualKeyboardMode(::ui::mojom::blink::VirtualKeyboardMode type) final;
  
  void VisibilityChanged(::blink::mojom::blink::FrameVisibility visibility) final;
  
  void DidChangeThemeColor(std::optional<::SkColor> theme_color) final;
  
  void DidChangeBackgroundColor(const ::SkColor4f& background_color, bool color_adjust) final;
  
  void DidFailLoadWithError(const ::blink::KURL& url, int32_t error_code) final;
  
  void DidFocusFrame() final;
  
  void DidCallFocus() final;
  
  void EnforceInsecureRequestPolicy(::blink::mojom::blink::InsecureRequestPolicy policy_bitmap) final;
  
  void EnforceInsecureNavigationsSet(const ::blink::Vector<uint32_t>& set) final;
  
  void SuddenTerminationDisablerChanged(bool present, ::blink::mojom::blink::SuddenTerminationDisablerType disabler_type) final;
  
  void HadStickyUserActivationBeforeNavigationChanged(bool has_gesture) final;
  
  void ScrollRectToVisibleInParentFrame(const ::gfx::RectF& rect_to_scroll, ::blink::mojom::blink::ScrollIntoViewParamsPtr params) final;
  
  void BubbleLogicalScrollInParentFrame(::blink::mojom::blink::ScrollDirection direction, ::ui::ScrollGranularity granularity) final;
  
  void StartLoadingForAsyncNavigationApiCommit() final;
  
  void DidBlockNavigation(const ::blink::KURL& blocked_url, ::blink::mojom::blink::NavigationBlockedReason reason) final;
  
  void DidChangeLoadProgress(double load_progress) final;
  
  void DidFinishLoad(const ::blink::KURL& validated_url) final;
  
  void DispatchLoad() final;
  
  void GoToEntryAtOffset(int32_t offset, bool has_user_gesture, ::base::TimeTicks actual_navigation_start, std::optional<::blink::scheduler::TaskAttributionId> soft_navigation_heuristics_task_id) final;
  
  void NavigateToNavigationApiKey(const ::blink::String& key, bool has_user_gesture, ::base::TimeTicks actual_navigation_start, std::optional<::blink::scheduler::TaskAttributionId> soft_navigation_heuristics_task_id) final;
  
  void NavigateEventHandlerPresenceChanged(bool present) final;
  
  void UpdateTitle(const ::blink::String& title, ::base::i18n::TextDirection title_direction) final;
  
  void UpdateApplicationTitle(const ::blink::String& application_title) final;
  
  void UpdateUserActivationState(::blink::mojom::blink::UserActivationUpdateType update_type, ::blink::mojom::blink::UserActivationNotificationType notification_type) final;
  
  void DidConsumeHistoryUserActivation() final;
  
  void HandleAccessibilityFindInPageResult(FindInPageResultAXParamsPtr params) final;
  
  void HandleAccessibilityFindInPageTermination() final;
  
  void DocumentOnLoadCompleted() final;
  
  void ForwardResourceTimingToParent(::blink::mojom::blink::ResourceTimingInfoPtr timing) final;
  
  void DidDispatchDOMContentLoadedEvent() final;
  
  bool RunModalAlertDialog(const ::blink::String& alert_message, bool disable_third_party_subframe_suppresion) final;
  
  void RunModalAlertDialog(const ::blink::String& alert_message, bool disable_third_party_subframe_suppresion, RunModalAlertDialogCallback callback) final;
  
  bool RunModalConfirmDialog(const ::blink::String& alert_message, bool disable_third_party_subframe_suppresion, bool* out_success) final;
  
  void RunModalConfirmDialog(const ::blink::String& alert_message, bool disable_third_party_subframe_suppresion, RunModalConfirmDialogCallback callback) final;
  
  bool RunModalPromptDialog(const ::blink::String& alert_message, const ::blink::String& default_value, bool disable_third_party_subframe_suppresion, bool* out_success, ::blink::String* out_result) final;
  
  void RunModalPromptDialog(const ::blink::String& alert_message, const ::blink::String& default_value, bool disable_third_party_subframe_suppresion, RunModalPromptDialogCallback callback) final;
  
  bool RunBeforeUnloadConfirm(bool is_reload, bool* out_success) final;
  
  void RunBeforeUnloadConfirm(bool is_reload, RunBeforeUnloadConfirmCallback callback) final;
  
  void UpdateFaviconURL(::blink::Vector<::blink::mojom::blink::FaviconURLPtr> favicon_urls) final;
  
  void DownloadURL(DownloadURLParamsPtr params) final;
  
  void FocusedElementChanged(bool is_editable_element, bool is_richly_editable_element, const ::gfx::Rect& bounds_in_frame_widget, ::blink::mojom::blink::FocusType focus_type) final;
  
  void TextSelectionChanged(const ::blink::String& text, uint32_t offset, const ::gfx::Range& range) final;
  
  void ShowPopupMenu(::mojo::PendingRemote<::blink::mojom::blink::PopupMenuClient> popup_client, const ::gfx::Rect& bounds, double font_size, int32_t selected_item, ::blink::Vector<::blink::mojom::blink::MenuItemPtr> menu_items, bool right_aligned, bool allow_multiple_selection) final;
  
  void CreateNewPopupWidget(::mojo::PendingAssociatedReceiver<::blink::mojom::blink::PopupWidgetHost> popup_host, ::mojo::PendingAssociatedReceiver<::blink::mojom::blink::WidgetHost> blink_widget_host, ::mojo::PendingAssociatedRemote<::blink::mojom::blink::Widget> blink_widget) final;
  
  void ShowContextMenu(::mojo::PendingAssociatedRemote<::blink::mojom::blink::ContextMenuClient> client, const ::blink::UntrustworthyContextMenuParams& params) final;
  
  void DidLoadResourceFromMemoryCache(const ::blink::KURL& url, const ::blink::String& http_method, const ::blink::String& mime_type, ::network::mojom::blink::RequestDestination request_destination, bool include_credentials) final;
  
  void DidChangeFrameOwnerProperties(const ::blink::FrameToken& child_frame_token, ::blink::mojom::blink::FrameOwnerPropertiesPtr frame_owner_properties) final;
  
  void DidChangeOpener(const std::optional<::blink::LocalFrameToken>& opener_frame) final;
  
  void DidChangeFramePolicy(const ::blink::FrameToken& child_frame_token, const ::blink::FramePolicy& frame_policy) final;
  
  void DidChangeIframeAttributes(const ::blink::FrameToken& child_frame_token, IframeAttributesPtr attributes) final;
  
  void CapturePaintPreviewOfSubframe(const ::gfx::Rect& clip_rect, const ::base::UnguessableToken& guid) final;
  
  void SetCloseListener(::mojo::PendingRemote<::blink::mojom::blink::CloseListener> listener) final;
  
  void Detach() final;
  
  void GetKeepAliveHandleFactory(::mojo::PendingReceiver<::blink::mojom::blink::KeepAliveHandleFactory> factory) final;
  
  void DidAddMessageToConsole(::blink::mojom::blink::ConsoleMessageLevel log_level, const ::blink::String& msg, uint32_t line_number, const ::blink::String& source_id, const ::blink::String& untrusted_stack_trace) final;
  
  void FrameSizeChanged(const ::gfx::Size& size) final;
  
  void DidInferColorScheme(::blink::mojom::blink::PreferredColorScheme color_scheme) final;
  
  void DidChangeSrcDoc(const ::blink::FrameToken& child_frame_token, const ::blink::String& srcdoc_value) final;
  
  void ReceivedDelegatedCapability(::blink::mojom::blink::DelegatedCapability delegated_capability) final;
  
  void SendFencedFrameReportingBeacon(const ::blink::String& event_data, const ::blink::String& event_type, const ::blink::Vector<::blink::FencedFrame::ReportingDestination>& destinations, bool cross_origin_exposed) final;
  
  void SendFencedFrameReportingBeaconToCustomURL(const ::blink::KURL& destination_url, bool cross_origin_exposed) final;
  
  void DisableUntrustedNetworkInFencedFrame(DisableUntrustedNetworkInFencedFrameCallback callback) final;
  
  void ExemptUrlFromNetworkRevocationForTesting(const ::blink::KURL& exempted_url, ExemptUrlFromNetworkRevocationForTestingCallback callback) final;
  
  void SendLegacyTechEvent(const ::blink::String& type, LegacyTechEventCodeLocationPtr code_location) final;
  
  void SetFencedFrameAutomaticBeaconReportEventData(::blink::mojom::blink::AutomaticBeaconType event_type, const ::blink::String& event_data, const ::blink::Vector<::blink::FencedFrame::ReportingDestination>& destinations, bool once, bool cross_origin_exposed) final;
  
  void SendPrivateAggregationRequestsForFencedFrameEvent(const ::blink::String& event_type) final;
  
  void CreateFencedFrame(::mojo::PendingAssociatedReceiver<::blink::mojom::blink::FencedFrameOwnerHost> fenced_frame, ::blink::mojom::blink::RemoteFrameInterfacesFromRendererPtr remote_frame_interfaces, const ::blink::RemoteFrameToken& frame_token, const ::base::UnguessableToken& devtools_frame_token) final;
  
  void ForwardFencedFrameEventAndUserActivationToEmbedder(const ::blink::String& event_type) final;
  
  void OnViewTransitionOptInChanged(ViewTransitionSameOriginOptIn view_transition_opt_in) final;
  
  void StartDragging(const ::blink::WebDragData& drag_data, ::blink::DragOperationsMask operations_allowed, const ::SkBitmap& image, const ::gfx::Vector2d& cursor_offset_in_dip, const ::gfx::Rect& drag_obj_rect_in_dip, ::blink::mojom::blink::DragEventSourceInfoPtr event_info) final;
  
  void IssueKeepAliveHandle(::mojo::PendingReceiver<::blink::mojom::blink::NavigationStateKeepAliveHandle> receiver) final;
  
  void NotifyStorageAccessed(StorageTypeAccessed storageType, bool blocked) final;
  
  void RecordWindowProxyUsageMetrics(const ::blink::FrameToken& target_frame_token, WindowProxyAccessType access_type) final;
  
  void NotifyDocumentInteractive() final;
  
  void SetStorageAccessApiStatus(::net::StorageAccessApiStatus status) final;
  
  void InitializeCrashReportStorage(uint64_t length, InitializeCrashReportStorageCallback callback) final;
  
  bool SetCrashReportStorageKey(const ::blink::String& key, const ::blink::String& value) final;
  
  void SetCrashReportStorageKey(const ::blink::String& key, const ::blink::String& value, SetCrashReportStorageKeyCallback callback) final;
  
  bool RemoveCrashReportStorageKey(const ::blink::String& key) final;
  
  void RemoveCrashReportStorageKey(const ::blink::String& key, RemoveCrashReportStorageKeyCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class CORE_EXPORT NonAssociatedLocalFrameHostProxy
    : public NonAssociatedLocalFrameHost {
 public:
  using InterfaceType = NonAssociatedLocalFrameHost;

  explicit NonAssociatedLocalFrameHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void MaybeStartOutermostMainFrameNavigation(const ::blink::Vector<::blink::KURL>& urls) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class CORE_EXPORT LocalFrameProxy
    : public LocalFrame {
 public:
  using InterfaceType = LocalFrame;

  explicit LocalFrameProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetTextSurroundingSelection(uint32_t max_length, GetTextSurroundingSelectionCallback callback) final;
  
  void SendInterventionReport(const ::blink::String& id, const ::blink::String& message, const std::optional<::blink::FrameToken>& child_frame_token) final;
  
  void SetFrameOwnerProperties(::blink::mojom::blink::FrameOwnerPropertiesPtr properties) final;
  
  void NotifyUserActivation(::blink::mojom::blink::UserActivationNotificationType notification_type) final;
  
  void NotifyVirtualKeyboardOverlayRect(const ::gfx::Rect& keyboard_rect) final;
  
  void ShowInterestInElement(int32_t nodeID) final;
  
  void AddMessageToConsole(::blink::mojom::blink::ConsoleMessageLevel level, const ::blink::String& message, bool discard_duplicates) final;
  
  void SwapInImmediately() final;
  
  void CheckCompleted() final;
  
  void StopLoading() final;
  
  void Collapse(bool collapsed) final;
  
  void EnableViewSourceMode() final;
  
  void Focus() final;
  
  void ClearFocusedElement() final;
  
  void CopyImageAt(const ::gfx::Point& window_point) final;
  
  void SaveImageAt(const ::gfx::Point& window_point) final;
  
  void ReportBlinkFeatureUsage(const ::blink::Vector<::blink::mojom::blink::WebFeature>& features) final;
  
  void RenderFallbackContent() final;
  
  void BeforeUnload(bool is_reload, BeforeUnloadCallback callback) final;
  
  void MediaPlayerActionAt(const ::gfx::Point& location, ::blink::mojom::blink::MediaPlayerActionPtr action) final;
  
  void RequestVideoFrameAtWithBoundsHint(const ::gfx::Point& location, const ::gfx::Size& max_size, int32_t max_area, RequestVideoFrameAtWithBoundsHintCallback callback) final;
  
  void PluginActionAt(const ::gfx::Point& location, PluginActionType action) final;
  
  void AdvanceFocusInFrame(::blink::mojom::blink::FocusType focus_type, const std::optional<::blink::RemoteFrameToken>& source_frame_token) final;
  
  void AdvanceFocusForIME(::blink::mojom::blink::FocusType focus_type) final;
  
  void ReportContentSecurityPolicyViolation(::network::mojom::blink::CSPViolationPtr violation) final;
  
  void DidUpdateFramePolicy(const ::blink::FramePolicy& frame_policy) final;
  
  void OnFrameVisibilityChanged(::blink::mojom::blink::FrameVisibility visibility) final;
  
  void PostMessageEvent(const std::optional<::blink::RemoteFrameToken>& source_frame_token, const ::scoped_refptr<const ::blink::SecurityOrigin>& source_origin, const ::scoped_refptr<const ::blink::SecurityOrigin>& target_origin, ::blink::BlinkTransferableMessage message) final;
  
  void JavaScriptMethodExecuteRequest(const ::blink::String& object_name, const ::blink::String& method_name, ::base::Value::List arguments, bool wants_result, JavaScriptMethodExecuteRequestCallback callback) final;
  
  void JavaScriptExecuteRequest(const ::blink::String& javascript, bool wants_result, JavaScriptExecuteRequestCallback callback) final;
  
  void JavaScriptExecuteRequestForTests(const ::blink::String& javascript, bool has_user_gesture, bool resolve_promises, bool honor_js_content_settings, int32_t world_id, JavaScriptExecuteRequestForTestsCallback callback) final;
  
  void JavaScriptExecuteRequestInIsolatedWorld(const ::blink::String& javascript, bool wants_result, int32_t world_id, JavaScriptExecuteRequestInIsolatedWorldCallback callback) final;
  
  void JavaScriptAwaitPromiseInIsolatedWorld(const ::blink::String& javascript, int32_t world_id, JavaScriptAwaitPromiseInIsolatedWorldCallback callback) final;
  
  void GetCharacterIndexAtPoint(const ::gfx::Point& location) final;
  
  void GetFirstRectForRange(const ::gfx::Range& range) final;
  
  void GetStringForRange(const ::gfx::Range& range, GetStringForRangeCallback callback) final;
  
  void BindReportingObserver(::mojo::PendingReceiver<::blink::mojom::blink::ReportingObserver> receiver) final;
  
  void UpdateOpener(const std::optional<::blink::FrameToken>& opener_frame_token) final;
  
  void GetSavableResourceLinks(GetSavableResourceLinksCallback callback) final;
  
  void MixedContentFound(const ::blink::KURL& main_resource_url, const ::blink::KURL& mixed_content_url, ::blink::mojom::blink::RequestContextType request_context, bool was_allowed, const ::blink::KURL& url_before_redirects, bool had_redirect, ::network::mojom::blink::SourceLocationPtr source_location) final;
  
  void BindDevToolsAgent(::mojo::PendingAssociatedRemote<::blink::mojom::blink::DevToolsAgentHost> agent_host, ::mojo::PendingAssociatedReceiver<::blink::mojom::blink::DevToolsAgent> agent) final;
  
  void ExtractAnnotatedText(uint64_t char_count_goal, ExtractAnnotatedTextCallback callback) final;
  
  void ExtractSerializedDom(ExtractSerializedDomCallback callback) final;
  
  void ExtractSerializedDomElementInfo(const ::blink::String& id, ExtractSerializedDomElementInfoCallback callback) final;
  
  void HandleRendererDebugURL(const ::blink::KURL& url) final;
  
  void GetCanonicalUrlForSharing(GetCanonicalUrlForSharingCallback callback) final;
  
  void GetOpenGraphMetadata(GetOpenGraphMetadataCallback callback) final;
  
  void SetNavigationApiHistoryEntriesForRestore(::blink::mojom::blink::NavigationApiHistoryEntryArraysPtr entry_arrays, NavigationApiEntryRestoreReason restore_reason) final;
  
  void UpdatePrerenderURL(const ::blink::KURL& matched_url, UpdatePrerenderURLCallback callback) final;
  
  void NotifyNavigationApiOfDisposedEntries(const ::blink::Vector<::blink::String>& keys) final;
  
  void TraverseCancelled(const ::blink::String& navigation_api_key, TraverseCancelledReason reason) final;
  
  void DispatchNavigateEventForCrossDocumentTraversal(const ::blink::KURL& url, const std::string& page_state, bool is_browser_initiated) final;
  
  void SnapshotDocumentForViewTransition(const ::blink::ViewTransitionToken& transition_token, ::blink::mojom::blink::PageSwapEventParamsPtr page_swap_event_params, SnapshotDocumentForViewTransitionCallback callback) final;
  
  void NotifyViewTransitionAbortedToOldDocument() final;
  
  void DispatchPageSwap(::blink::mojom::blink::PageSwapEventParamsPtr page_swap_event_params) final;
  
  void AddResourceTimingEntryForFailedSubframeNavigation(const ::blink::FrameToken& subframe_token, const ::blink::KURL& initial_url, ::base::TimeTicks start_time, ::base::TimeTicks redirect_time, ::base::TimeTicks request_start, ::base::TimeTicks response_start, uint32_t response_code, const ::blink::String& mime_type, ::network::mojom::blink::LoadTimingInfoPtr load_timing_info, ::net::HttpConnectionInfo connection_info, const ::blink::String& alpn_negotiated_protocol, bool is_secure_transport, bool is_validated, const ::blink::String& normalized_server_timing, const ::network::URLLoaderCompletionStatus& completion_status) final;
  
  void GetScrollPosition(GetScrollPositionCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class CORE_EXPORT LocalMainFrameProxy
    : public LocalMainFrame {
 public:
  using InterfaceType = LocalMainFrame;

  explicit LocalMainFrameProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AnimateDoubleTapZoom(const ::gfx::Point& point, const ::gfx::Rect& rect) final;
  
  void SetScaleFactor(float scale) final;
  
  void ClosePage(ClosePageCallback callback) final;
  
  void GetFullPageSize(GetFullPageSizeCallback callback) final;
  
  void SetInitialFocus(bool reverse) final;
  
  void EnablePreferredSizeChangedMode() final;
  
  void ZoomToFindInPageRect(const ::gfx::Rect& rect_in_root_frame) final;
  
  void InstallCoopAccessMonitor(const ::blink::FrameToken& accessed_window, ::network::mojom::blink::CrossOriginOpenerPolicyReporterParamsPtr coop_reporter_info) final;
  
  void UpdateBrowserControlsState(::cc::BrowserControlsState constraints, ::cc::BrowserControlsState current, bool animate, const std::optional<::cc::BrowserControlsOffsetTagModifications>& offset_tag_modifications) final;
  
  void SetV8CompileHints(::base::ReadOnlySharedMemoryRegion data) final;
  
  void Discard(DiscardCallback callback) final;
  
  void FinalizeNavigationConfidence(double randomized_trigger_rate, ::blink::mojom::blink::ConfidenceLevel confidence) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class CORE_EXPORT LocalMainFrameHostProxy
    : public LocalMainFrameHost {
 public:
  using InterfaceType = LocalMainFrameHost;

  explicit LocalMainFrameHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ScaleFactorChanged(float scale) final;
  
  void ContentsPreferredSizeChanged(const ::gfx::Size& pref_size) final;
  
  void TextAutosizerPageInfoChanged(::blink::mojom::blink::TextAutosizerPageInfoPtr page_info) final;
  
  void FocusPage() final;
  
  void TakeFocus(bool reverse) final;
  
  void UpdateTargetURL(const ::blink::KURL& url, UpdateTargetURLCallback callback) final;
  
  void RequestClose() final;
  
  void ShowCreatedWindow(const ::blink::LocalFrameToken& opener_frame_token, ::ui::mojom::blink::WindowOpenDisposition disposition, ::blink::mojom::blink::WindowFeaturesPtr window_features, bool opened_by_user_gesture, ShowCreatedWindowCallback callback) final;
  
  void SetWindowRect(const ::gfx::Rect& bounds, SetWindowRectCallback callback) final;
  
  void DidFirstVisuallyNonEmptyPaint() final;
  
  void DidAccessInitialMainDocument() final;
  
  void Maximize() final;
  
  void Minimize() final;
  
  void Restore() final;
  
  void SetResizable(bool resizable) final;
  
  void DraggableRegionsChanged(::blink::Vector<::blink::mojom::blink::DraggableRegionPtr> regions) final;
  
  void OnFirstContentfulPaint(::base::TimeDelta duration) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CORE_EXPORT LocalFrameHostStubDispatch {
 public:
  static bool Accept(LocalFrameHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      LocalFrameHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<LocalFrameHost>>
class LocalFrameHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  LocalFrameHostStub() = default;
  ~LocalFrameHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LocalFrameHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LocalFrameHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CORE_EXPORT NonAssociatedLocalFrameHostStubDispatch {
 public:
  static bool Accept(NonAssociatedLocalFrameHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NonAssociatedLocalFrameHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NonAssociatedLocalFrameHost>>
class NonAssociatedLocalFrameHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NonAssociatedLocalFrameHostStub() = default;
  ~NonAssociatedLocalFrameHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NonAssociatedLocalFrameHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NonAssociatedLocalFrameHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CORE_EXPORT LocalFrameStubDispatch {
 public:
  static bool Accept(LocalFrame* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      LocalFrame* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<LocalFrame>>
class LocalFrameStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  LocalFrameStub() = default;
  ~LocalFrameStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LocalFrameStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LocalFrameStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CORE_EXPORT LocalMainFrameStubDispatch {
 public:
  static bool Accept(LocalMainFrame* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      LocalMainFrame* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<LocalMainFrame>>
class LocalMainFrameStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  LocalMainFrameStub() = default;
  ~LocalMainFrameStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LocalMainFrameStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LocalMainFrameStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CORE_EXPORT LocalMainFrameHostStubDispatch {
 public:
  static bool Accept(LocalMainFrameHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      LocalMainFrameHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<LocalMainFrameHost>>
class LocalMainFrameHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  LocalMainFrameHostStub() = default;
  ~LocalMainFrameHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LocalMainFrameHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LocalMainFrameHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CORE_EXPORT LocalFrameHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CORE_EXPORT NonAssociatedLocalFrameHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CORE_EXPORT LocalFrameRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CORE_EXPORT LocalMainFrameRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CORE_EXPORT LocalMainFrameHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CORE_EXPORT LocalFrameHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CORE_EXPORT LocalFrameResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CORE_EXPORT LocalMainFrameResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CORE_EXPORT LocalMainFrameHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};











class CORE_EXPORT LegacyTechEventCodeLocation {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LegacyTechEventCodeLocation, T>::value>;
  using DataView = LegacyTechEventCodeLocationDataView;
  using Data_ = internal::LegacyTechEventCodeLocation_Data;

  template <typename... Args>
  static LegacyTechEventCodeLocationPtr New(Args&&... args) {
    return LegacyTechEventCodeLocationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LegacyTechEventCodeLocationPtr From(const U& u) {
    return mojo::TypeConverter<LegacyTechEventCodeLocationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LegacyTechEventCodeLocation>::Convert(*this);
  }


  LegacyTechEventCodeLocation();

  LegacyTechEventCodeLocation(
      const ::blink::String& filename,
      uint64_t line,
      uint64_t column);


  ~LegacyTechEventCodeLocation();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LegacyTechEventCodeLocationPtr>
  LegacyTechEventCodeLocationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LegacyTechEventCodeLocation::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LegacyTechEventCodeLocation::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LegacyTechEventCodeLocation::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LegacyTechEventCodeLocation::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LegacyTechEventCodeLocation::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LegacyTechEventCodeLocation::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LegacyTechEventCodeLocation_UnserializedMessageContext<
            UserType, LegacyTechEventCodeLocation::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LegacyTechEventCodeLocation::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LegacyTechEventCodeLocation::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LegacyTechEventCodeLocation_UnserializedMessageContext<
            UserType, LegacyTechEventCodeLocation::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LegacyTechEventCodeLocation::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String filename;
  
  uint64_t line;
  
  uint64_t column;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LegacyTechEventCodeLocation::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LegacyTechEventCodeLocation::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LegacyTechEventCodeLocation::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LegacyTechEventCodeLocation::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class CORE_EXPORT SavableSubframe {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SavableSubframe, T>::value>;
  using DataView = SavableSubframeDataView;
  using Data_ = internal::SavableSubframe_Data;

  template <typename... Args>
  static SavableSubframePtr New(Args&&... args) {
    return SavableSubframePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SavableSubframePtr From(const U& u) {
    return mojo::TypeConverter<SavableSubframePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SavableSubframe>::Convert(*this);
  }


  SavableSubframe();

  SavableSubframe(
      const ::blink::KURL& original_url,
      const ::blink::FrameToken& subframe_token);


  ~SavableSubframe();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SavableSubframePtr>
  SavableSubframePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SavableSubframe::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SavableSubframe::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SavableSubframe::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SavableSubframe::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SavableSubframe::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SavableSubframe::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SavableSubframe_UnserializedMessageContext<
            UserType, SavableSubframe::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SavableSubframe::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SavableSubframe::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SavableSubframe_UnserializedMessageContext<
            UserType, SavableSubframe::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SavableSubframe::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::KURL original_url;
  
  ::blink::FrameToken subframe_token;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SavableSubframe::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SavableSubframe::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SavableSubframe::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SavableSubframe::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CORE_EXPORT GetSavableResourceLinksReply {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GetSavableResourceLinksReply, T>::value>;
  using DataView = GetSavableResourceLinksReplyDataView;
  using Data_ = internal::GetSavableResourceLinksReply_Data;

  template <typename... Args>
  static GetSavableResourceLinksReplyPtr New(Args&&... args) {
    return GetSavableResourceLinksReplyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GetSavableResourceLinksReplyPtr From(const U& u) {
    return mojo::TypeConverter<GetSavableResourceLinksReplyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GetSavableResourceLinksReply>::Convert(*this);
  }


  GetSavableResourceLinksReply();

  GetSavableResourceLinksReply(
      ::blink::Vector<::blink::KURL> resources_list,
      ::blink::mojom::blink::ReferrerPtr referrer,
      ::blink::Vector<SavableSubframePtr> subframes);

GetSavableResourceLinksReply(const GetSavableResourceLinksReply&) = delete;
GetSavableResourceLinksReply& operator=(const GetSavableResourceLinksReply&) = delete;

  ~GetSavableResourceLinksReply();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GetSavableResourceLinksReplyPtr>
  GetSavableResourceLinksReplyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GetSavableResourceLinksReply::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GetSavableResourceLinksReply::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GetSavableResourceLinksReply::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GetSavableResourceLinksReply::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GetSavableResourceLinksReply::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GetSavableResourceLinksReply::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GetSavableResourceLinksReply_UnserializedMessageContext<
            UserType, GetSavableResourceLinksReply::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GetSavableResourceLinksReply::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GetSavableResourceLinksReply::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GetSavableResourceLinksReply_UnserializedMessageContext<
            UserType, GetSavableResourceLinksReply::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GetSavableResourceLinksReply::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<::blink::KURL> resources_list;
  
  ::blink::mojom::blink::ReferrerPtr referrer;
  
  ::blink::Vector<SavableSubframePtr> subframes;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GetSavableResourceLinksReply::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GetSavableResourceLinksReply::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GetSavableResourceLinksReply::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GetSavableResourceLinksReply::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CORE_EXPORT FindInPageResultAXParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FindInPageResultAXParams, T>::value>;
  using DataView = FindInPageResultAXParamsDataView;
  using Data_ = internal::FindInPageResultAXParams_Data;

  template <typename... Args>
  static FindInPageResultAXParamsPtr New(Args&&... args) {
    return FindInPageResultAXParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FindInPageResultAXParamsPtr From(const U& u) {
    return mojo::TypeConverter<FindInPageResultAXParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FindInPageResultAXParams>::Convert(*this);
  }


  FindInPageResultAXParams();

  FindInPageResultAXParams(
      int32_t request_id,
      int32_t match_index,
      int32_t start_id,
      int32_t start_offset,
      int32_t end_id,
      int32_t end_offset);


  ~FindInPageResultAXParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FindInPageResultAXParamsPtr>
  FindInPageResultAXParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FindInPageResultAXParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FindInPageResultAXParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FindInPageResultAXParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FindInPageResultAXParams::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FindInPageResultAXParams::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FindInPageResultAXParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FindInPageResultAXParams_UnserializedMessageContext<
            UserType, FindInPageResultAXParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FindInPageResultAXParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FindInPageResultAXParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FindInPageResultAXParams_UnserializedMessageContext<
            UserType, FindInPageResultAXParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FindInPageResultAXParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t request_id;
  
  int32_t match_index;
  
  int32_t start_id;
  
  int32_t start_offset;
  
  int32_t end_id;
  
  int32_t end_offset;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FindInPageResultAXParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FindInPageResultAXParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FindInPageResultAXParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FindInPageResultAXParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CORE_EXPORT SerializedDomElementInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SerializedDomElementInfo, T>::value>;
  using DataView = SerializedDomElementInfoDataView;
  using Data_ = internal::SerializedDomElementInfo_Data;

  template <typename... Args>
  static SerializedDomElementInfoPtr New(Args&&... args) {
    return SerializedDomElementInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SerializedDomElementInfoPtr From(const U& u) {
    return mojo::TypeConverter<SerializedDomElementInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SerializedDomElementInfo>::Convert(*this);
  }


  SerializedDomElementInfo();

  SerializedDomElementInfo(
      const ::blink::String& tag,
      const ::blink::String& selector,
      const std::optional<::gfx::Rect>& visible_bounds,
      const std::optional<::gfx::Point>& click_point);


  ~SerializedDomElementInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SerializedDomElementInfoPtr>
  SerializedDomElementInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SerializedDomElementInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SerializedDomElementInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SerializedDomElementInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SerializedDomElementInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SerializedDomElementInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SerializedDomElementInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SerializedDomElementInfo_UnserializedMessageContext<
            UserType, SerializedDomElementInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SerializedDomElementInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SerializedDomElementInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SerializedDomElementInfo_UnserializedMessageContext<
            UserType, SerializedDomElementInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SerializedDomElementInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String tag;
  
  ::blink::String selector;
  
  std::optional<::gfx::Rect> visible_bounds;
  
  std::optional<::gfx::Point> click_point;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SerializedDomElementInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SerializedDomElementInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SerializedDomElementInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SerializedDomElementInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CORE_EXPORT DownloadURLParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DownloadURLParams, T>::value>;
  using DataView = DownloadURLParamsDataView;
  using Data_ = internal::DownloadURLParams_Data;

  template <typename... Args>
  static DownloadURLParamsPtr New(Args&&... args) {
    return DownloadURLParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DownloadURLParamsPtr From(const U& u) {
    return mojo::TypeConverter<DownloadURLParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DownloadURLParams>::Convert(*this);
  }


  DownloadURLParams();

  DownloadURLParams(
      const ::blink::KURL& url,
      ::blink::mojom::blink::ReferrerPtr referrer,
      const ::scoped_refptr<const ::blink::SecurityOrigin>& initiator_origin,
      const ::blink::String& suggested_name,
      ::network::mojom::blink::RedirectMode cross_origin_redirects,
      ::mojo::PendingRemote<::blink::mojom::blink::BlobURLToken> blob_url_token,
      ::mojo::PendingRemote<::blink::mojom::blink::Blob> data_url_blob,
      bool is_context_menu_save,
      bool has_user_gesture);

DownloadURLParams(const DownloadURLParams&) = delete;
DownloadURLParams& operator=(const DownloadURLParams&) = delete;

  ~DownloadURLParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DownloadURLParamsPtr>
  DownloadURLParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DownloadURLParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DownloadURLParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DownloadURLParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DownloadURLParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DownloadURLParams_UnserializedMessageContext<
            UserType, DownloadURLParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DownloadURLParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DownloadURLParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DownloadURLParams_UnserializedMessageContext<
            UserType, DownloadURLParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DownloadURLParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::KURL url;
  
  ::blink::mojom::blink::ReferrerPtr referrer;
  
  ::scoped_refptr<const ::blink::SecurityOrigin> initiator_origin;
  
  ::blink::String suggested_name;
  
  ::network::mojom::blink::RedirectMode cross_origin_redirects;
  
  ::mojo::PendingRemote<::blink::mojom::blink::BlobURLToken> blob_url_token;
  
  ::mojo::PendingRemote<::blink::mojom::blink::Blob> data_url_blob;
  
  bool is_context_menu_save;
  
  bool has_user_gesture;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DownloadURLParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DownloadURLParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DownloadURLParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DownloadURLParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CORE_EXPORT IframeAttributes {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IframeAttributes, T>::value>;
  using DataView = IframeAttributesDataView;
  using Data_ = internal::IframeAttributes_Data;

  template <typename... Args>
  static IframeAttributesPtr New(Args&&... args) {
    return IframeAttributesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IframeAttributesPtr From(const U& u) {
    return mojo::TypeConverter<IframeAttributesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IframeAttributes>::Convert(*this);
  }


  IframeAttributes();

  IframeAttributes(
      ::network::mojom::blink::ContentSecurityPolicyPtr parsed_csp_attribute,
      bool credentialless,
      bool browsing_topics,
      bool ad_auction_headers,
      bool shared_storage_writable_opted_in,
      const ::blink::String& id,
      const ::blink::String& name,
      const ::blink::String& src);

IframeAttributes(const IframeAttributes&) = delete;
IframeAttributes& operator=(const IframeAttributes&) = delete;

  ~IframeAttributes();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IframeAttributesPtr>
  IframeAttributesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IframeAttributes::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IframeAttributes::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IframeAttributes::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IframeAttributes::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IframeAttributes::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IframeAttributes::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IframeAttributes_UnserializedMessageContext<
            UserType, IframeAttributes::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IframeAttributes::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IframeAttributes::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IframeAttributes_UnserializedMessageContext<
            UserType, IframeAttributes::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IframeAttributes::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::network::mojom::blink::ContentSecurityPolicyPtr parsed_csp_attribute;
  
  bool credentialless;
  
  bool browsing_topics;
  
  bool ad_auction_headers;
  
  bool shared_storage_writable_opted_in;
  
  ::blink::String id;
  
  ::blink::String name;
  
  ::blink::String src;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IframeAttributes::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IframeAttributes::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IframeAttributes::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IframeAttributes::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
SavableSubframePtr SavableSubframe::Clone() const {
  return New(
      mojo::Clone(original_url),
      mojo::Clone(subframe_token)
  );
}

template <typename T, SavableSubframe::EnableIfSame<T>*>
bool SavableSubframe::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->original_url, other_struct.original_url))
    return false;
  if (!mojo::Equals(this->subframe_token, other_struct.subframe_token))
    return false;
  return true;
}

template <typename T, SavableSubframe::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.original_url < rhs.original_url)
    return true;
  if (rhs.original_url < lhs.original_url)
    return false;
  if (lhs.subframe_token < rhs.subframe_token)
    return true;
  if (rhs.subframe_token < lhs.subframe_token)
    return false;
  return false;
}
template <typename StructPtrType>
GetSavableResourceLinksReplyPtr GetSavableResourceLinksReply::Clone() const {
  return New(
      mojo::Clone(resources_list),
      mojo::Clone(referrer),
      mojo::Clone(subframes)
  );
}

template <typename T, GetSavableResourceLinksReply::EnableIfSame<T>*>
bool GetSavableResourceLinksReply::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->resources_list, other_struct.resources_list))
    return false;
  if (!mojo::Equals(this->referrer, other_struct.referrer))
    return false;
  if (!mojo::Equals(this->subframes, other_struct.subframes))
    return false;
  return true;
}

template <typename T, GetSavableResourceLinksReply::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.resources_list < rhs.resources_list)
    return true;
  if (rhs.resources_list < lhs.resources_list)
    return false;
  if (lhs.referrer < rhs.referrer)
    return true;
  if (rhs.referrer < lhs.referrer)
    return false;
  if (lhs.subframes < rhs.subframes)
    return true;
  if (rhs.subframes < lhs.subframes)
    return false;
  return false;
}
template <typename StructPtrType>
FindInPageResultAXParamsPtr FindInPageResultAXParams::Clone() const {
  return New(
      mojo::Clone(request_id),
      mojo::Clone(match_index),
      mojo::Clone(start_id),
      mojo::Clone(start_offset),
      mojo::Clone(end_id),
      mojo::Clone(end_offset)
  );
}

template <typename T, FindInPageResultAXParams::EnableIfSame<T>*>
bool FindInPageResultAXParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->request_id, other_struct.request_id))
    return false;
  if (!mojo::Equals(this->match_index, other_struct.match_index))
    return false;
  if (!mojo::Equals(this->start_id, other_struct.start_id))
    return false;
  if (!mojo::Equals(this->start_offset, other_struct.start_offset))
    return false;
  if (!mojo::Equals(this->end_id, other_struct.end_id))
    return false;
  if (!mojo::Equals(this->end_offset, other_struct.end_offset))
    return false;
  return true;
}

template <typename T, FindInPageResultAXParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.request_id < rhs.request_id)
    return true;
  if (rhs.request_id < lhs.request_id)
    return false;
  if (lhs.match_index < rhs.match_index)
    return true;
  if (rhs.match_index < lhs.match_index)
    return false;
  if (lhs.start_id < rhs.start_id)
    return true;
  if (rhs.start_id < lhs.start_id)
    return false;
  if (lhs.start_offset < rhs.start_offset)
    return true;
  if (rhs.start_offset < lhs.start_offset)
    return false;
  if (lhs.end_id < rhs.end_id)
    return true;
  if (rhs.end_id < lhs.end_id)
    return false;
  if (lhs.end_offset < rhs.end_offset)
    return true;
  if (rhs.end_offset < lhs.end_offset)
    return false;
  return false;
}
template <typename StructPtrType>
SerializedDomElementInfoPtr SerializedDomElementInfo::Clone() const {
  return New(
      mojo::Clone(tag),
      mojo::Clone(selector),
      mojo::Clone(visible_bounds),
      mojo::Clone(click_point)
  );
}

template <typename T, SerializedDomElementInfo::EnableIfSame<T>*>
bool SerializedDomElementInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->tag, other_struct.tag))
    return false;
  if (!mojo::Equals(this->selector, other_struct.selector))
    return false;
  if (!mojo::Equals(this->visible_bounds, other_struct.visible_bounds))
    return false;
  if (!mojo::Equals(this->click_point, other_struct.click_point))
    return false;
  return true;
}

template <typename T, SerializedDomElementInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.tag < rhs.tag)
    return true;
  if (rhs.tag < lhs.tag)
    return false;
  if (lhs.selector < rhs.selector)
    return true;
  if (rhs.selector < lhs.selector)
    return false;
  if (lhs.visible_bounds < rhs.visible_bounds)
    return true;
  if (rhs.visible_bounds < lhs.visible_bounds)
    return false;
  if (lhs.click_point < rhs.click_point)
    return true;
  if (rhs.click_point < lhs.click_point)
    return false;
  return false;
}
template <typename StructPtrType>
DownloadURLParamsPtr DownloadURLParams::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(referrer),
      mojo::Clone(initiator_origin),
      mojo::Clone(suggested_name),
      mojo::Clone(cross_origin_redirects),
      mojo::Clone(blob_url_token),
      mojo::Clone(data_url_blob),
      mojo::Clone(is_context_menu_save),
      mojo::Clone(has_user_gesture)
  );
}

template <typename T, DownloadURLParams::EnableIfSame<T>*>
bool DownloadURLParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->referrer, other_struct.referrer))
    return false;
  if (!mojo::Equals(this->initiator_origin, other_struct.initiator_origin))
    return false;
  if (!mojo::Equals(this->suggested_name, other_struct.suggested_name))
    return false;
  if (!mojo::Equals(this->cross_origin_redirects, other_struct.cross_origin_redirects))
    return false;
  if (!mojo::Equals(this->blob_url_token, other_struct.blob_url_token))
    return false;
  if (!mojo::Equals(this->data_url_blob, other_struct.data_url_blob))
    return false;
  if (!mojo::Equals(this->is_context_menu_save, other_struct.is_context_menu_save))
    return false;
  if (!mojo::Equals(this->has_user_gesture, other_struct.has_user_gesture))
    return false;
  return true;
}

template <typename T, DownloadURLParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.referrer < rhs.referrer)
    return true;
  if (rhs.referrer < lhs.referrer)
    return false;
  if (lhs.initiator_origin < rhs.initiator_origin)
    return true;
  if (rhs.initiator_origin < lhs.initiator_origin)
    return false;
  if (lhs.suggested_name < rhs.suggested_name)
    return true;
  if (rhs.suggested_name < lhs.suggested_name)
    return false;
  if (lhs.cross_origin_redirects < rhs.cross_origin_redirects)
    return true;
  if (rhs.cross_origin_redirects < lhs.cross_origin_redirects)
    return false;
  if (lhs.blob_url_token < rhs.blob_url_token)
    return true;
  if (rhs.blob_url_token < lhs.blob_url_token)
    return false;
  if (lhs.data_url_blob < rhs.data_url_blob)
    return true;
  if (rhs.data_url_blob < lhs.data_url_blob)
    return false;
  if (lhs.is_context_menu_save < rhs.is_context_menu_save)
    return true;
  if (rhs.is_context_menu_save < lhs.is_context_menu_save)
    return false;
  if (lhs.has_user_gesture < rhs.has_user_gesture)
    return true;
  if (rhs.has_user_gesture < lhs.has_user_gesture)
    return false;
  return false;
}
template <typename StructPtrType>
IframeAttributesPtr IframeAttributes::Clone() const {
  return New(
      mojo::Clone(parsed_csp_attribute),
      mojo::Clone(credentialless),
      mojo::Clone(browsing_topics),
      mojo::Clone(ad_auction_headers),
      mojo::Clone(shared_storage_writable_opted_in),
      mojo::Clone(id),
      mojo::Clone(name),
      mojo::Clone(src)
  );
}

template <typename T, IframeAttributes::EnableIfSame<T>*>
bool IframeAttributes::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->parsed_csp_attribute, other_struct.parsed_csp_attribute))
    return false;
  if (!mojo::Equals(this->credentialless, other_struct.credentialless))
    return false;
  if (!mojo::Equals(this->browsing_topics, other_struct.browsing_topics))
    return false;
  if (!mojo::Equals(this->ad_auction_headers, other_struct.ad_auction_headers))
    return false;
  if (!mojo::Equals(this->shared_storage_writable_opted_in, other_struct.shared_storage_writable_opted_in))
    return false;
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->src, other_struct.src))
    return false;
  return true;
}

template <typename T, IframeAttributes::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.parsed_csp_attribute < rhs.parsed_csp_attribute)
    return true;
  if (rhs.parsed_csp_attribute < lhs.parsed_csp_attribute)
    return false;
  if (lhs.credentialless < rhs.credentialless)
    return true;
  if (rhs.credentialless < lhs.credentialless)
    return false;
  if (lhs.browsing_topics < rhs.browsing_topics)
    return true;
  if (rhs.browsing_topics < lhs.browsing_topics)
    return false;
  if (lhs.ad_auction_headers < rhs.ad_auction_headers)
    return true;
  if (rhs.ad_auction_headers < lhs.ad_auction_headers)
    return false;
  if (lhs.shared_storage_writable_opted_in < rhs.shared_storage_writable_opted_in)
    return true;
  if (rhs.shared_storage_writable_opted_in < lhs.shared_storage_writable_opted_in)
    return false;
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.src < rhs.src)
    return true;
  if (rhs.src < lhs.src)
    return false;
  return false;
}
template <typename StructPtrType>
LegacyTechEventCodeLocationPtr LegacyTechEventCodeLocation::Clone() const {
  return New(
      mojo::Clone(filename),
      mojo::Clone(line),
      mojo::Clone(column)
  );
}

template <typename T, LegacyTechEventCodeLocation::EnableIfSame<T>*>
bool LegacyTechEventCodeLocation::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->filename, other_struct.filename))
    return false;
  if (!mojo::Equals(this->line, other_struct.line))
    return false;
  if (!mojo::Equals(this->column, other_struct.column))
    return false;
  return true;
}

template <typename T, LegacyTechEventCodeLocation::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.filename < rhs.filename)
    return true;
  if (rhs.filename < lhs.filename)
    return false;
  if (lhs.line < rhs.line)
    return true;
  if (rhs.line < lhs.line)
    return false;
  if (lhs.column < rhs.column)
    return true;
  if (rhs.column < lhs.column)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct CORE_EXPORT StructTraits<::blink::mojom::blink::SavableSubframe::DataView,
                                         ::blink::mojom::blink::SavableSubframePtr> {
  static bool IsNull(const ::blink::mojom::blink::SavableSubframePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::SavableSubframePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::SavableSubframe::original_url)& original_url(
      const ::blink::mojom::blink::SavableSubframePtr& input) {
    return input->original_url;
  }

  static const decltype(::blink::mojom::blink::SavableSubframe::subframe_token)& subframe_token(
      const ::blink::mojom::blink::SavableSubframePtr& input) {
    return input->subframe_token;
  }

  static bool Read(::blink::mojom::blink::SavableSubframe::DataView input, ::blink::mojom::blink::SavableSubframePtr* output);
};


template <>
struct CORE_EXPORT StructTraits<::blink::mojom::blink::GetSavableResourceLinksReply::DataView,
                                         ::blink::mojom::blink::GetSavableResourceLinksReplyPtr> {
  static bool IsNull(const ::blink::mojom::blink::GetSavableResourceLinksReplyPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::GetSavableResourceLinksReplyPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::GetSavableResourceLinksReply::resources_list)& resources_list(
      const ::blink::mojom::blink::GetSavableResourceLinksReplyPtr& input) {
    return input->resources_list;
  }

  static const decltype(::blink::mojom::blink::GetSavableResourceLinksReply::referrer)& referrer(
      const ::blink::mojom::blink::GetSavableResourceLinksReplyPtr& input) {
    return input->referrer;
  }

  static const decltype(::blink::mojom::blink::GetSavableResourceLinksReply::subframes)& subframes(
      const ::blink::mojom::blink::GetSavableResourceLinksReplyPtr& input) {
    return input->subframes;
  }

  static bool Read(::blink::mojom::blink::GetSavableResourceLinksReply::DataView input, ::blink::mojom::blink::GetSavableResourceLinksReplyPtr* output);
};


template <>
struct CORE_EXPORT StructTraits<::blink::mojom::blink::FindInPageResultAXParams::DataView,
                                         ::blink::mojom::blink::FindInPageResultAXParamsPtr> {
  static bool IsNull(const ::blink::mojom::blink::FindInPageResultAXParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::FindInPageResultAXParamsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::FindInPageResultAXParams::request_id) request_id(
      const ::blink::mojom::blink::FindInPageResultAXParamsPtr& input) {
    return input->request_id;
  }

  static decltype(::blink::mojom::blink::FindInPageResultAXParams::match_index) match_index(
      const ::blink::mojom::blink::FindInPageResultAXParamsPtr& input) {
    return input->match_index;
  }

  static decltype(::blink::mojom::blink::FindInPageResultAXParams::start_id) start_id(
      const ::blink::mojom::blink::FindInPageResultAXParamsPtr& input) {
    return input->start_id;
  }

  static decltype(::blink::mojom::blink::FindInPageResultAXParams::start_offset) start_offset(
      const ::blink::mojom::blink::FindInPageResultAXParamsPtr& input) {
    return input->start_offset;
  }

  static decltype(::blink::mojom::blink::FindInPageResultAXParams::end_id) end_id(
      const ::blink::mojom::blink::FindInPageResultAXParamsPtr& input) {
    return input->end_id;
  }

  static decltype(::blink::mojom::blink::FindInPageResultAXParams::end_offset) end_offset(
      const ::blink::mojom::blink::FindInPageResultAXParamsPtr& input) {
    return input->end_offset;
  }

  static bool Read(::blink::mojom::blink::FindInPageResultAXParams::DataView input, ::blink::mojom::blink::FindInPageResultAXParamsPtr* output);
};


template <>
struct CORE_EXPORT StructTraits<::blink::mojom::blink::SerializedDomElementInfo::DataView,
                                         ::blink::mojom::blink::SerializedDomElementInfoPtr> {
  static bool IsNull(const ::blink::mojom::blink::SerializedDomElementInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::SerializedDomElementInfoPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::SerializedDomElementInfo::tag)& tag(
      const ::blink::mojom::blink::SerializedDomElementInfoPtr& input) {
    return input->tag;
  }

  static const decltype(::blink::mojom::blink::SerializedDomElementInfo::selector)& selector(
      const ::blink::mojom::blink::SerializedDomElementInfoPtr& input) {
    return input->selector;
  }

  static const decltype(::blink::mojom::blink::SerializedDomElementInfo::visible_bounds)& visible_bounds(
      const ::blink::mojom::blink::SerializedDomElementInfoPtr& input) {
    return input->visible_bounds;
  }

  static const decltype(::blink::mojom::blink::SerializedDomElementInfo::click_point)& click_point(
      const ::blink::mojom::blink::SerializedDomElementInfoPtr& input) {
    return input->click_point;
  }

  static bool Read(::blink::mojom::blink::SerializedDomElementInfo::DataView input, ::blink::mojom::blink::SerializedDomElementInfoPtr* output);
};


template <>
struct CORE_EXPORT StructTraits<::blink::mojom::blink::DownloadURLParams::DataView,
                                         ::blink::mojom::blink::DownloadURLParamsPtr> {
  static bool IsNull(const ::blink::mojom::blink::DownloadURLParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::DownloadURLParamsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::DownloadURLParams::url)& url(
      const ::blink::mojom::blink::DownloadURLParamsPtr& input) {
    return input->url;
  }

  static const decltype(::blink::mojom::blink::DownloadURLParams::referrer)& referrer(
      const ::blink::mojom::blink::DownloadURLParamsPtr& input) {
    return input->referrer;
  }

  static const decltype(::blink::mojom::blink::DownloadURLParams::initiator_origin)& initiator_origin(
      const ::blink::mojom::blink::DownloadURLParamsPtr& input) {
    return input->initiator_origin;
  }

  static const decltype(::blink::mojom::blink::DownloadURLParams::suggested_name)& suggested_name(
      const ::blink::mojom::blink::DownloadURLParamsPtr& input) {
    return input->suggested_name;
  }

  static decltype(::blink::mojom::blink::DownloadURLParams::cross_origin_redirects) cross_origin_redirects(
      const ::blink::mojom::blink::DownloadURLParamsPtr& input) {
    return input->cross_origin_redirects;
  }

  static  decltype(::blink::mojom::blink::DownloadURLParams::blob_url_token)& blob_url_token(
       ::blink::mojom::blink::DownloadURLParamsPtr& input) {
    return input->blob_url_token;
  }

  static  decltype(::blink::mojom::blink::DownloadURLParams::data_url_blob)& data_url_blob(
       ::blink::mojom::blink::DownloadURLParamsPtr& input) {
    return input->data_url_blob;
  }

  static decltype(::blink::mojom::blink::DownloadURLParams::is_context_menu_save) is_context_menu_save(
      const ::blink::mojom::blink::DownloadURLParamsPtr& input) {
    return input->is_context_menu_save;
  }

  static decltype(::blink::mojom::blink::DownloadURLParams::has_user_gesture) has_user_gesture(
      const ::blink::mojom::blink::DownloadURLParamsPtr& input) {
    return input->has_user_gesture;
  }

  static bool Read(::blink::mojom::blink::DownloadURLParams::DataView input, ::blink::mojom::blink::DownloadURLParamsPtr* output);
};


template <>
struct CORE_EXPORT StructTraits<::blink::mojom::blink::IframeAttributes::DataView,
                                         ::blink::mojom::blink::IframeAttributesPtr> {
  static bool IsNull(const ::blink::mojom::blink::IframeAttributesPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::IframeAttributesPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::IframeAttributes::parsed_csp_attribute)& parsed_csp_attribute(
      const ::blink::mojom::blink::IframeAttributesPtr& input) {
    return input->parsed_csp_attribute;
  }

  static decltype(::blink::mojom::blink::IframeAttributes::credentialless) credentialless(
      const ::blink::mojom::blink::IframeAttributesPtr& input) {
    return input->credentialless;
  }

  static decltype(::blink::mojom::blink::IframeAttributes::browsing_topics) browsing_topics(
      const ::blink::mojom::blink::IframeAttributesPtr& input) {
    return input->browsing_topics;
  }

  static decltype(::blink::mojom::blink::IframeAttributes::ad_auction_headers) ad_auction_headers(
      const ::blink::mojom::blink::IframeAttributesPtr& input) {
    return input->ad_auction_headers;
  }

  static decltype(::blink::mojom::blink::IframeAttributes::shared_storage_writable_opted_in) shared_storage_writable_opted_in(
      const ::blink::mojom::blink::IframeAttributesPtr& input) {
    return input->shared_storage_writable_opted_in;
  }

  static const decltype(::blink::mojom::blink::IframeAttributes::id)& id(
      const ::blink::mojom::blink::IframeAttributesPtr& input) {
    return input->id;
  }

  static const decltype(::blink::mojom::blink::IframeAttributes::name)& name(
      const ::blink::mojom::blink::IframeAttributesPtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::blink::IframeAttributes::src)& src(
      const ::blink::mojom::blink::IframeAttributesPtr& input) {
    return input->src;
  }

  static bool Read(::blink::mojom::blink::IframeAttributes::DataView input, ::blink::mojom::blink::IframeAttributesPtr* output);
};


template <>
struct CORE_EXPORT StructTraits<::blink::mojom::blink::LegacyTechEventCodeLocation::DataView,
                                         ::blink::mojom::blink::LegacyTechEventCodeLocationPtr> {
  static bool IsNull(const ::blink::mojom::blink::LegacyTechEventCodeLocationPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::LegacyTechEventCodeLocationPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::LegacyTechEventCodeLocation::filename)& filename(
      const ::blink::mojom::blink::LegacyTechEventCodeLocationPtr& input) {
    return input->filename;
  }

  static decltype(::blink::mojom::blink::LegacyTechEventCodeLocation::line) line(
      const ::blink::mojom::blink::LegacyTechEventCodeLocationPtr& input) {
    return input->line;
  }

  static decltype(::blink::mojom::blink::LegacyTechEventCodeLocation::column) column(
      const ::blink::mojom::blink::LegacyTechEventCodeLocationPtr& input) {
    return input->column;
  }

  static bool Read(::blink::mojom::blink::LegacyTechEventCodeLocation::DataView input, ::blink::mojom::blink::LegacyTechEventCodeLocationPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_MOJOM_BLINK_H_