// third_party/blink/public/mojom/frame/find_in_page.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/frame/find_in_page.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/frame/find_in_page.mojom-params-data.h"
#include "third_party/blink/public/mojom/frame/find_in_page.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/frame/find_in_page.mojom-import-headers.h"
#include "third_party/blink/public/mojom/frame/find_in_page.mojom-test-utils.h"


namespace blink::mojom {
FindOptions::FindOptions()
    : forward(true),
      match_case(false),
      new_session(true),
      find_match(true),
      force(false),
      run_synchronously_for_testing(false) {}

FindOptions::FindOptions(
    bool forward_in,
    bool match_case_in,
    bool new_session_in,
    bool find_match_in,
    bool force_in,
    bool run_synchronously_for_testing_in)
    : forward(std::move(forward_in)),
      match_case(std::move(match_case_in)),
      new_session(std::move(new_session_in)),
      find_match(std::move(find_match_in)),
      force(std::move(force_in)),
      run_synchronously_for_testing(std::move(run_synchronously_for_testing_in)) {}

FindOptions::~FindOptions() = default;
size_t FindOptions::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->forward);
  seed = mojo::internal::Hash(seed, this->match_case);
  seed = mojo::internal::Hash(seed, this->new_session);
  seed = mojo::internal::Hash(seed, this->find_match);
  seed = mojo::internal::Hash(seed, this->force);
  seed = mojo::internal::Hash(seed, this->run_synchronously_for_testing);
  return seed;
}

void FindOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "forward"), this->forward,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "match_case"), this->match_case,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "new_session"), this->new_session,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "find_match"), this->find_match,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "force"), this->force,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "run_synchronously_for_testing"), this->run_synchronously_for_testing,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FindOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

FindInPage::IPCStableHashFunction FindInPage::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FindInPage>(message.name())) {
    case messages::FindInPage::kFind: {
      return &FindInPage::Find_Sym::IPCStableHash;
    }
    case messages::FindInPage::kStopFinding: {
      return &FindInPage::StopFinding_Sym::IPCStableHash;
    }
    case messages::FindInPage::kClearActiveFindMatch: {
      return &FindInPage::ClearActiveFindMatch_Sym::IPCStableHash;
    }
    case messages::FindInPage::kSetClient: {
      return &FindInPage::SetClient_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FindInPage::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FindInPage>(message.name())) {
      case messages::FindInPage::kFind:
            return "Receive blink::mojom::FindInPage::Find";
      case messages::FindInPage::kStopFinding:
            return "Receive blink::mojom::FindInPage::StopFinding";
      case messages::FindInPage::kClearActiveFindMatch:
            return "Receive blink::mojom::FindInPage::ClearActiveFindMatch";
      case messages::FindInPage::kSetClient:
            return "Receive blink::mojom::FindInPage::SetClient";
    }
  } else {
    switch (static_cast<messages::FindInPage>(message.name())) {
      case messages::FindInPage::kFind:
            return "Receive reply blink::mojom::FindInPage::Find";
      case messages::FindInPage::kStopFinding:
            return "Receive reply blink::mojom::FindInPage::StopFinding";
      case messages::FindInPage::kClearActiveFindMatch:
            return "Receive reply blink::mojom::FindInPage::ClearActiveFindMatch";
      case messages::FindInPage::kSetClient:
            return "Receive reply blink::mojom::FindInPage::SetClient";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FindInPage::Find_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd801306e;  // IPCStableHash for blink::mojom::FindInPage::Find
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FindInPage::StopFinding_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x71669205;  // IPCStableHash for blink::mojom::FindInPage::StopFinding
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FindInPage::ClearActiveFindMatch_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x558c6151;  // IPCStableHash for blink::mojom::FindInPage::ClearActiveFindMatch
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FindInPage::SetClient_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf9b0ec95;  // IPCStableHash for blink::mojom::FindInPage::SetClient
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

FindInPageProxy::FindInPageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FindInPageProxy::Find(
    int32_t in_request_id, const std::string& in_search_text, FindOptionsPtr in_options) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FindInPage::Find", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("search_text"), in_search_text,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type FindOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FindInPage::kFind), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FindInPage_Find_Params_Data> params(
          message);
  params.Allocate();

  params->request_id = in_request_id;
  mojo::internal::MessageFragment<
      typename decltype(params->search_text)::BaseType> search_text_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_search_text,
    search_text_fragment);

  params->search_text.Set(
      search_text_fragment.is_null() ? nullptr : search_text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->search_text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null search_text in FindInPage.Find request");
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FindOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in FindInPage.Find request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FindInPage::Name_);
  message.set_method_name("Find");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FindInPageProxy::StopFinding(
    StopFindAction in_action) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FindInPage::StopFinding", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("action"), in_action,
                        "<value of type StopFindAction>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FindInPage::kStopFinding), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FindInPage_StopFinding_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::StopFindAction>(
    in_action,
    &params->action);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FindInPage::Name_);
  message.set_method_name("StopFinding");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FindInPageProxy::ClearActiveFindMatch(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::FindInPage::ClearActiveFindMatch");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FindInPage::kClearActiveFindMatch), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FindInPage_ClearActiveFindMatch_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FindInPage::Name_);
  message.set_method_name("ClearActiveFindMatch");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FindInPageProxy::SetClient(
    ::mojo::PendingRemote<FindInPageClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FindInPage::SetClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<FindInPageClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FindInPage::kSetClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FindInPage_SetClient_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FindInPageClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in FindInPage.SetClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FindInPage::Name_);
  message.set_method_name("SetClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool FindInPageStubDispatch::Accept(
    FindInPage* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FindInPage>(message->header()->name)) {
    case messages::FindInPage::kFind: {
      DCHECK(message->is_serialized());
      internal::FindInPage_Find_Params_Data* params =
          reinterpret_cast<internal::FindInPage_Find_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FindInPage.0
      bool success = true;
      int32_t p_request_id{};
      std::string p_search_text{};
      FindOptionsPtr p_options{};
      FindInPage_Find_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_request_id = input_data_view.request_id();
      if (success && !input_data_view.ReadSearchText(&p_search_text))
        success = false;
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FindInPage::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Find(        
        std::move(p_request_id), 
        std::move(p_search_text), 
        std::move(p_options));
      return true;
    }
    case messages::FindInPage::kStopFinding: {
      DCHECK(message->is_serialized());
      internal::FindInPage_StopFinding_Params_Data* params =
          reinterpret_cast<internal::FindInPage_StopFinding_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FindInPage.1
      bool success = true;
      StopFindAction p_action{};
      FindInPage_StopFinding_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAction(&p_action))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FindInPage::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopFinding(        
        std::move(p_action));
      return true;
    }
    case messages::FindInPage::kClearActiveFindMatch: {
      DCHECK(message->is_serialized());
      internal::FindInPage_ClearActiveFindMatch_Params_Data* params =
          reinterpret_cast<internal::FindInPage_ClearActiveFindMatch_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FindInPage.2
      bool success = true;
      FindInPage_ClearActiveFindMatch_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FindInPage::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearActiveFindMatch(        );
      return true;
    }
    case messages::FindInPage::kSetClient: {
      DCHECK(message->is_serialized());
      internal::FindInPage_SetClient_Params_Data* params =
          reinterpret_cast<internal::FindInPage_SetClient_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FindInPage.3
      bool success = true;
      ::mojo::PendingRemote<FindInPageClient> p_client{};
      FindInPage_SetClient_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FindInPage::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetClient(        
        std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool FindInPageStubDispatch::AcceptWithResponder(
    FindInPage* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FindInPage>(message->header()->name)) {
    case messages::FindInPage::kFind: {
      break;
    }
    case messages::FindInPage::kStopFinding: {
      break;
    }
    case messages::FindInPage::kClearActiveFindMatch: {
      break;
    }
    case messages::FindInPage::kSetClient: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFindInPageValidationInfo[] = {
    { &internal::FindInPage_Find_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FindInPage_StopFinding_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FindInPage_ClearActiveFindMatch_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FindInPage_SetClient_Params_Data::Validate,
     nullptr /* no response */},
};

bool FindInPageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::FindInPage::Name_,
    kFindInPageValidationInfo);
}

// The declaration includes the definition on other builds.

FindInPageClient::IPCStableHashFunction FindInPageClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FindInPageClient>(message.name())) {
    case messages::FindInPageClient::kSetNumberOfMatches: {
      return &FindInPageClient::SetNumberOfMatches_Sym::IPCStableHash;
    }
    case messages::FindInPageClient::kSetActiveMatch: {
      return &FindInPageClient::SetActiveMatch_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FindInPageClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FindInPageClient>(message.name())) {
      case messages::FindInPageClient::kSetNumberOfMatches:
            return "Receive blink::mojom::FindInPageClient::SetNumberOfMatches";
      case messages::FindInPageClient::kSetActiveMatch:
            return "Receive blink::mojom::FindInPageClient::SetActiveMatch";
    }
  } else {
    switch (static_cast<messages::FindInPageClient>(message.name())) {
      case messages::FindInPageClient::kSetNumberOfMatches:
            return "Receive reply blink::mojom::FindInPageClient::SetNumberOfMatches";
      case messages::FindInPageClient::kSetActiveMatch:
            return "Receive reply blink::mojom::FindInPageClient::SetActiveMatch";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FindInPageClient::SetNumberOfMatches_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc05bd256;  // IPCStableHash for blink::mojom::FindInPageClient::SetNumberOfMatches
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FindInPageClient::SetActiveMatch_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x009c55fa;  // IPCStableHash for blink::mojom::FindInPageClient::SetActiveMatch
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

FindInPageClientProxy::FindInPageClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FindInPageClientProxy::SetNumberOfMatches(
    int32_t in_request_id, uint32_t in_number_of_matches, FindMatchUpdateType in_update_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FindInPageClient::SetNumberOfMatches", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("number_of_matches"), in_number_of_matches,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("update_type"), in_update_type,
                        "<value of type FindMatchUpdateType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FindInPageClient::kSetNumberOfMatches), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FindInPageClient_SetNumberOfMatches_Params_Data> params(
          message);
  params.Allocate();

  params->request_id = in_request_id;

  params->number_of_matches = in_number_of_matches;

  
  mojo::internal::Serialize<::blink::mojom::FindMatchUpdateType>(
    in_update_type,
    &params->update_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FindInPageClient::Name_);
  message.set_method_name("SetNumberOfMatches");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FindInPageClientProxy::SetActiveMatch(
    int32_t in_request_id, const ::gfx::Rect& in_active_match_rect, int32_t in_active_match_ordinal, FindMatchUpdateType in_update_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FindInPageClient::SetActiveMatch", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("active_match_rect"), in_active_match_rect,
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("active_match_ordinal"), in_active_match_ordinal,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("update_type"), in_update_type,
                        "<value of type FindMatchUpdateType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FindInPageClient::kSetActiveMatch), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FindInPageClient_SetActiveMatch_Params_Data> params(
          message);
  params.Allocate();

  params->request_id = in_request_id;
  mojo::internal::MessageFragment<
      typename decltype(params->active_match_rect)::BaseType> active_match_rect_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_active_match_rect,
    active_match_rect_fragment);

  params->active_match_rect.Set(
      active_match_rect_fragment.is_null() ? nullptr : active_match_rect_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->active_match_rect.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null active_match_rect in FindInPageClient.SetActiveMatch request");

  params->active_match_ordinal = in_active_match_ordinal;

  
  mojo::internal::Serialize<::blink::mojom::FindMatchUpdateType>(
    in_update_type,
    &params->update_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FindInPageClient::Name_);
  message.set_method_name("SetActiveMatch");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool FindInPageClientStubDispatch::Accept(
    FindInPageClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FindInPageClient>(message->header()->name)) {
    case messages::FindInPageClient::kSetNumberOfMatches: {
      DCHECK(message->is_serialized());
      internal::FindInPageClient_SetNumberOfMatches_Params_Data* params =
          reinterpret_cast<internal::FindInPageClient_SetNumberOfMatches_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FindInPageClient.0
      bool success = true;
      int32_t p_request_id{};
      uint32_t p_number_of_matches{};
      FindMatchUpdateType p_update_type{};
      FindInPageClient_SetNumberOfMatches_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_request_id = input_data_view.request_id();
      if (success)
        p_number_of_matches = input_data_view.number_of_matches();
      if (success && !input_data_view.ReadUpdateType(&p_update_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FindInPageClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetNumberOfMatches(        
        std::move(p_request_id), 
        std::move(p_number_of_matches), 
        std::move(p_update_type));
      return true;
    }
    case messages::FindInPageClient::kSetActiveMatch: {
      DCHECK(message->is_serialized());
      internal::FindInPageClient_SetActiveMatch_Params_Data* params =
          reinterpret_cast<internal::FindInPageClient_SetActiveMatch_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FindInPageClient.1
      bool success = true;
      int32_t p_request_id{};
      ::gfx::Rect p_active_match_rect{};
      int32_t p_active_match_ordinal{};
      FindMatchUpdateType p_update_type{};
      FindInPageClient_SetActiveMatch_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_request_id = input_data_view.request_id();
      if (success && !input_data_view.ReadActiveMatchRect(&p_active_match_rect))
        success = false;
      if (success)
        p_active_match_ordinal = input_data_view.active_match_ordinal();
      if (success && !input_data_view.ReadUpdateType(&p_update_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FindInPageClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetActiveMatch(        
        std::move(p_request_id), 
        std::move(p_active_match_rect), 
        std::move(p_active_match_ordinal), 
        std::move(p_update_type));
      return true;
    }
  }
  return false;
}

// static
bool FindInPageClientStubDispatch::AcceptWithResponder(
    FindInPageClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FindInPageClient>(message->header()->name)) {
    case messages::FindInPageClient::kSetNumberOfMatches: {
      break;
    }
    case messages::FindInPageClient::kSetActiveMatch: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFindInPageClientValidationInfo[] = {
    { &internal::FindInPageClient_SetNumberOfMatches_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FindInPageClient_SetActiveMatch_Params_Data::Validate,
     nullptr /* no response */},
};

bool FindInPageClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::FindInPageClient::Name_,
    kFindInPageClientValidationInfo);
}



}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::FindOptions::DataView, ::blink::mojom::FindOptionsPtr>::Read(
    ::blink::mojom::FindOptions::DataView input,
    ::blink::mojom::FindOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::FindOptionsPtr result(::blink::mojom::FindOptions::New());
  
      if (success)
        result->forward = input.forward();
      if (success)
        result->match_case = input.match_case();
      if (success)
        result->new_session = input.new_session();
      if (success)
        result->find_match = input.find_match();
      if (success)
        result->force = input.force();
      if (success)
        result->run_synchronously_for_testing = input.run_synchronously_for_testing();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void FindInPageInterceptorForTesting::Find(int32_t request_id, const std::string& search_text, FindOptionsPtr options) {
  GetForwardingInterface()->Find(
    std::move(request_id)
    , 
    std::move(search_text)
    , 
    std::move(options)
    );
}
void FindInPageInterceptorForTesting::StopFinding(StopFindAction action) {
  GetForwardingInterface()->StopFinding(
    std::move(action)
    );
}
void FindInPageInterceptorForTesting::ClearActiveFindMatch() {
  GetForwardingInterface()->ClearActiveFindMatch();
}
void FindInPageInterceptorForTesting::SetClient(::mojo::PendingRemote<FindInPageClient> client) {
  GetForwardingInterface()->SetClient(
    std::move(client)
    );
}
FindInPageAsyncWaiter::FindInPageAsyncWaiter(
    FindInPage* proxy) : proxy_(proxy) {}

FindInPageAsyncWaiter::~FindInPageAsyncWaiter() = default;





void FindInPageClientInterceptorForTesting::SetNumberOfMatches(int32_t request_id, uint32_t number_of_matches, FindMatchUpdateType update_type) {
  GetForwardingInterface()->SetNumberOfMatches(
    std::move(request_id)
    , 
    std::move(number_of_matches)
    , 
    std::move(update_type)
    );
}
void FindInPageClientInterceptorForTesting::SetActiveMatch(int32_t request_id, const ::gfx::Rect& active_match_rect, int32_t active_match_ordinal, FindMatchUpdateType update_type) {
  GetForwardingInterface()->SetActiveMatch(
    std::move(request_id)
    , 
    std::move(active_match_rect)
    , 
    std::move(active_match_ordinal)
    , 
    std::move(update_type)
    );
}
FindInPageClientAsyncWaiter::FindInPageClientAsyncWaiter(
    FindInPageClient* proxy) : proxy_(proxy) {}

FindInPageClientAsyncWaiter::~FindInPageClientAsyncWaiter() = default;







}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif