// third_party/blink/public/mojom/frame/back_forward_cache_controller.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/frame/back_forward_cache_controller.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var script_source_location$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/script_source_location.mojom', '../script_source_location.mojom.js');
  }
  var renderer_eviction_reason$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/navigation/renderer_eviction_reason.mojom', '../navigation/renderer_eviction_reason.mojom.js');
  }
  var web_scheduler_tracked_feature$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/scheduler/web_scheduler_tracked_feature.mojom', '../scheduler/web_scheduler_tracked_feature.mojom.js');
  }



  function BlockingDetails(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BlockingDetails.prototype.initDefaults_ = function() {
    this.feature = 0;
    this.source = null;
  };
  BlockingDetails.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BlockingDetails.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BlockingDetails.feature
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, web_scheduler_tracked_feature$.WebSchedulerTrackedFeature);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BlockingDetails.source
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, script_source_location$.ScriptSourceLocation, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BlockingDetails.encodedSize = codec.kStructHeaderSize + 16;

  BlockingDetails.decode = function(decoder) {
    var packed;
    var val = new BlockingDetails();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.feature =
        decoder.decodeStruct(new codec.Enum(web_scheduler_tracked_feature$.WebSchedulerTrackedFeature));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.source =
        decoder.decodeStructPointer(script_source_location$.ScriptSourceLocation);
    return val;
  };

  BlockingDetails.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BlockingDetails.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.feature);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(script_source_location$.ScriptSourceLocation, val.source);
  };
  function BackForwardCacheControllerHost_EvictFromBackForwardCache_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BackForwardCacheControllerHost_EvictFromBackForwardCache_Params.prototype.initDefaults_ = function() {
    this.reason = 0;
    this.source = null;
  };
  BackForwardCacheControllerHost_EvictFromBackForwardCache_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BackForwardCacheControllerHost_EvictFromBackForwardCache_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BackForwardCacheControllerHost_EvictFromBackForwardCache_Params.reason
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, renderer_eviction_reason$.RendererEvictionReason);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BackForwardCacheControllerHost_EvictFromBackForwardCache_Params.source
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, script_source_location$.ScriptSourceLocation, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BackForwardCacheControllerHost_EvictFromBackForwardCache_Params.encodedSize = codec.kStructHeaderSize + 16;

  BackForwardCacheControllerHost_EvictFromBackForwardCache_Params.decode = function(decoder) {
    var packed;
    var val = new BackForwardCacheControllerHost_EvictFromBackForwardCache_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.reason =
        decoder.decodeStruct(new codec.Enum(renderer_eviction_reason$.RendererEvictionReason));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.source =
        decoder.decodeStructPointer(script_source_location$.ScriptSourceLocation);
    return val;
  };

  BackForwardCacheControllerHost_EvictFromBackForwardCache_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BackForwardCacheControllerHost_EvictFromBackForwardCache_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.reason);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(script_source_location$.ScriptSourceLocation, val.source);
  };
  function BackForwardCacheControllerHost_DidChangeBackForwardCacheDisablingFeatures_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BackForwardCacheControllerHost_DidChangeBackForwardCacheDisablingFeatures_Params.prototype.initDefaults_ = function() {
    this.details = null;
  };
  BackForwardCacheControllerHost_DidChangeBackForwardCacheDisablingFeatures_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BackForwardCacheControllerHost_DidChangeBackForwardCacheDisablingFeatures_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BackForwardCacheControllerHost_DidChangeBackForwardCacheDisablingFeatures_Params.details
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(BlockingDetails), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BackForwardCacheControllerHost_DidChangeBackForwardCacheDisablingFeatures_Params.encodedSize = codec.kStructHeaderSize + 8;

  BackForwardCacheControllerHost_DidChangeBackForwardCacheDisablingFeatures_Params.decode = function(decoder) {
    var packed;
    var val = new BackForwardCacheControllerHost_DidChangeBackForwardCacheDisablingFeatures_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.details =
        decoder.decodeArrayPointer(new codec.PointerTo(BlockingDetails));
    return val;
  };

  BackForwardCacheControllerHost_DidChangeBackForwardCacheDisablingFeatures_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BackForwardCacheControllerHost_DidChangeBackForwardCacheDisablingFeatures_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(BlockingDetails), val.details);
  };
  var kBackForwardCacheControllerHost_EvictFromBackForwardCache_Name = 0;
  var kBackForwardCacheControllerHost_DidChangeBackForwardCacheDisablingFeatures_Name = 1;

  function BackForwardCacheControllerHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(BackForwardCacheControllerHost,
                                                   handleOrPtrInfo);
  }

  function BackForwardCacheControllerHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        BackForwardCacheControllerHost, associatedInterfacePtrInfo);
  }

  BackForwardCacheControllerHostAssociatedPtr.prototype =
      Object.create(BackForwardCacheControllerHostPtr.prototype);
  BackForwardCacheControllerHostAssociatedPtr.prototype.constructor =
      BackForwardCacheControllerHostAssociatedPtr;

  function BackForwardCacheControllerHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  BackForwardCacheControllerHostPtr.prototype.evictFromBackForwardCache = function() {
    return BackForwardCacheControllerHostProxy.prototype.evictFromBackForwardCache
        .apply(this.ptr.getProxy(), arguments);
  };

  BackForwardCacheControllerHostProxy.prototype.evictFromBackForwardCache = function(reason, source) {
    var params_ = new BackForwardCacheControllerHost_EvictFromBackForwardCache_Params();
    params_.reason = reason;
    params_.source = source;
    var builder = new codec.MessageV0Builder(
        kBackForwardCacheControllerHost_EvictFromBackForwardCache_Name,
        codec.align(BackForwardCacheControllerHost_EvictFromBackForwardCache_Params.encodedSize));
    builder.encodeStruct(BackForwardCacheControllerHost_EvictFromBackForwardCache_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  BackForwardCacheControllerHostPtr.prototype.didChangeBackForwardCacheDisablingFeatures = function() {
    return BackForwardCacheControllerHostProxy.prototype.didChangeBackForwardCacheDisablingFeatures
        .apply(this.ptr.getProxy(), arguments);
  };

  BackForwardCacheControllerHostProxy.prototype.didChangeBackForwardCacheDisablingFeatures = function(details) {
    var params_ = new BackForwardCacheControllerHost_DidChangeBackForwardCacheDisablingFeatures_Params();
    params_.details = details;
    var builder = new codec.MessageV0Builder(
        kBackForwardCacheControllerHost_DidChangeBackForwardCacheDisablingFeatures_Name,
        codec.align(BackForwardCacheControllerHost_DidChangeBackForwardCacheDisablingFeatures_Params.encodedSize));
    builder.encodeStruct(BackForwardCacheControllerHost_DidChangeBackForwardCacheDisablingFeatures_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function BackForwardCacheControllerHostStub(delegate) {
    this.delegate_ = delegate;
  }
  BackForwardCacheControllerHostStub.prototype.evictFromBackForwardCache = function(reason, source) {
    return this.delegate_ && this.delegate_.evictFromBackForwardCache && this.delegate_.evictFromBackForwardCache(reason, source);
  }
  BackForwardCacheControllerHostStub.prototype.didChangeBackForwardCacheDisablingFeatures = function(details) {
    return this.delegate_ && this.delegate_.didChangeBackForwardCacheDisablingFeatures && this.delegate_.didChangeBackForwardCacheDisablingFeatures(details);
  }

  BackForwardCacheControllerHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kBackForwardCacheControllerHost_EvictFromBackForwardCache_Name:
      var params = reader.decodeStruct(BackForwardCacheControllerHost_EvictFromBackForwardCache_Params);
      this.evictFromBackForwardCache(params.reason, params.source);
      return true;
    case kBackForwardCacheControllerHost_DidChangeBackForwardCacheDisablingFeatures_Name:
      var params = reader.decodeStruct(BackForwardCacheControllerHost_DidChangeBackForwardCacheDisablingFeatures_Params);
      this.didChangeBackForwardCacheDisablingFeatures(params.details);
      return true;
    default:
      return false;
    }
  };

  BackForwardCacheControllerHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateBackForwardCacheControllerHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kBackForwardCacheControllerHost_EvictFromBackForwardCache_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = BackForwardCacheControllerHost_EvictFromBackForwardCache_Params;
      break;
      case kBackForwardCacheControllerHost_DidChangeBackForwardCacheDisablingFeatures_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = BackForwardCacheControllerHost_DidChangeBackForwardCacheDisablingFeatures_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateBackForwardCacheControllerHostResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var BackForwardCacheControllerHost = {
    name: 'blink.mojom.BackForwardCacheControllerHost',
    kVersion: 0,
    ptrClass: BackForwardCacheControllerHostPtr,
    proxyClass: BackForwardCacheControllerHostProxy,
    stubClass: BackForwardCacheControllerHostStub,
    validateRequest: validateBackForwardCacheControllerHostRequest,
    validateResponse: null,
  };
  BackForwardCacheControllerHostStub.prototype.validator = validateBackForwardCacheControllerHostRequest;
  BackForwardCacheControllerHostProxy.prototype.validator = null;
  exports.BlockingDetails = BlockingDetails;
  exports.BackForwardCacheControllerHost = BackForwardCacheControllerHost;
  exports.BackForwardCacheControllerHostPtr = BackForwardCacheControllerHostPtr;
  exports.BackForwardCacheControllerHostAssociatedPtr = BackForwardCacheControllerHostAssociatedPtr;
})();