// third_party/blink/public/mojom/file_system_access/file_system_access_transfer_token.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/file_system_access/file_system_access_transfer_token.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }



  function FileSystemAccessTransferToken_GetInternalID_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessTransferToken_GetInternalID_Params.prototype.initDefaults_ = function() {
  };
  FileSystemAccessTransferToken_GetInternalID_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessTransferToken_GetInternalID_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessTransferToken_GetInternalID_Params.encodedSize = codec.kStructHeaderSize + 0;

  FileSystemAccessTransferToken_GetInternalID_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessTransferToken_GetInternalID_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FileSystemAccessTransferToken_GetInternalID_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessTransferToken_GetInternalID_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function FileSystemAccessTransferToken_GetInternalID_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessTransferToken_GetInternalID_ResponseParams.prototype.initDefaults_ = function() {
    this.id = null;
  };
  FileSystemAccessTransferToken_GetInternalID_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessTransferToken_GetInternalID_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessTransferToken_GetInternalID_ResponseParams.id
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessTransferToken_GetInternalID_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessTransferToken_GetInternalID_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessTransferToken_GetInternalID_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  FileSystemAccessTransferToken_GetInternalID_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessTransferToken_GetInternalID_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.id);
  };
  function FileSystemAccessTransferToken_Clone_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessTransferToken_Clone_Params.prototype.initDefaults_ = function() {
    this.tokenClone = new bindings.InterfaceRequest();
  };
  FileSystemAccessTransferToken_Clone_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessTransferToken_Clone_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessTransferToken_Clone_Params.tokenClone
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessTransferToken_Clone_Params.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessTransferToken_Clone_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessTransferToken_Clone_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.tokenClone =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FileSystemAccessTransferToken_Clone_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessTransferToken_Clone_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.tokenClone);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kFileSystemAccessTransferToken_GetInternalID_Name = 0;
  var kFileSystemAccessTransferToken_Clone_Name = 1;

  function FileSystemAccessTransferTokenPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(FileSystemAccessTransferToken,
                                                   handleOrPtrInfo);
  }

  function FileSystemAccessTransferTokenAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        FileSystemAccessTransferToken, associatedInterfacePtrInfo);
  }

  FileSystemAccessTransferTokenAssociatedPtr.prototype =
      Object.create(FileSystemAccessTransferTokenPtr.prototype);
  FileSystemAccessTransferTokenAssociatedPtr.prototype.constructor =
      FileSystemAccessTransferTokenAssociatedPtr;

  function FileSystemAccessTransferTokenProxy(receiver) {
    this.receiver_ = receiver;
  }
  FileSystemAccessTransferTokenPtr.prototype.getInternalID = function() {
    return FileSystemAccessTransferTokenProxy.prototype.getInternalID
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessTransferTokenProxy.prototype.getInternalID = function() {
    var params_ = new FileSystemAccessTransferToken_GetInternalID_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFileSystemAccessTransferToken_GetInternalID_Name,
          codec.align(FileSystemAccessTransferToken_GetInternalID_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FileSystemAccessTransferToken_GetInternalID_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FileSystemAccessTransferToken_GetInternalID_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FileSystemAccessTransferTokenPtr.prototype.clone = function() {
    return FileSystemAccessTransferTokenProxy.prototype.clone
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessTransferTokenProxy.prototype.clone = function(tokenClone) {
    var params_ = new FileSystemAccessTransferToken_Clone_Params();
    params_.tokenClone = tokenClone;
    var builder = new codec.MessageV0Builder(
        kFileSystemAccessTransferToken_Clone_Name,
        codec.align(FileSystemAccessTransferToken_Clone_Params.encodedSize));
    builder.encodeStruct(FileSystemAccessTransferToken_Clone_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function FileSystemAccessTransferTokenStub(delegate) {
    this.delegate_ = delegate;
  }
  FileSystemAccessTransferTokenStub.prototype.getInternalID = function() {
    return this.delegate_ && this.delegate_.getInternalID && this.delegate_.getInternalID();
  }
  FileSystemAccessTransferTokenStub.prototype.clone = function(tokenClone) {
    return this.delegate_ && this.delegate_.clone && this.delegate_.clone(tokenClone);
  }

  FileSystemAccessTransferTokenStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFileSystemAccessTransferToken_Clone_Name:
      var params = reader.decodeStruct(FileSystemAccessTransferToken_Clone_Params);
      this.clone(params.tokenClone);
      return true;
    default:
      return false;
    }
  };

  FileSystemAccessTransferTokenStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFileSystemAccessTransferToken_GetInternalID_Name:
      var params = reader.decodeStruct(FileSystemAccessTransferToken_GetInternalID_Params);
      this.getInternalID().then(function(response) {
        var responseParams =
            new FileSystemAccessTransferToken_GetInternalID_ResponseParams();
        responseParams.id = response.id;
        var builder = new codec.MessageV1Builder(
            kFileSystemAccessTransferToken_GetInternalID_Name,
            codec.align(FileSystemAccessTransferToken_GetInternalID_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FileSystemAccessTransferToken_GetInternalID_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateFileSystemAccessTransferTokenRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kFileSystemAccessTransferToken_GetInternalID_Name:
        if (message.expectsResponse())
          paramsClass = FileSystemAccessTransferToken_GetInternalID_Params;
      break;
      case kFileSystemAccessTransferToken_Clone_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FileSystemAccessTransferToken_Clone_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateFileSystemAccessTransferTokenResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kFileSystemAccessTransferToken_GetInternalID_Name:
        if (message.isResponse())
          paramsClass = FileSystemAccessTransferToken_GetInternalID_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var FileSystemAccessTransferToken = {
    name: 'blink.mojom.FileSystemAccessTransferToken',
    kVersion: 0,
    ptrClass: FileSystemAccessTransferTokenPtr,
    proxyClass: FileSystemAccessTransferTokenProxy,
    stubClass: FileSystemAccessTransferTokenStub,
    validateRequest: validateFileSystemAccessTransferTokenRequest,
    validateResponse: validateFileSystemAccessTransferTokenResponse,
  };
  FileSystemAccessTransferTokenStub.prototype.validator = validateFileSystemAccessTransferTokenRequest;
  FileSystemAccessTransferTokenProxy.prototype.validator = validateFileSystemAccessTransferTokenResponse;
  exports.FileSystemAccessTransferToken = FileSystemAccessTransferToken;
  exports.FileSystemAccessTransferTokenPtr = FileSystemAccessTransferTokenPtr;
  exports.FileSystemAccessTransferTokenAssociatedPtr = FileSystemAccessTransferTokenAssociatedPtr;
})();