// third_party/blink/public/mojom/file_system_access/file_system_access_observer_host.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('blink.mojom.FileSystemAccessObserver');
goog.require('blink.mojom.FileSystemAccessTransferToken');
goog.require('blink.mojom.FileSystemAccessError');






goog.provide('blink.mojom.FileSystemAccessObserverHost');
goog.provide('blink.mojom.FileSystemAccessObserverHostReceiver');
goog.provide('blink.mojom.FileSystemAccessObserverHostCallbackRouter');
goog.provide('blink.mojom.FileSystemAccessObserverHostInterface');
goog.provide('blink.mojom.FileSystemAccessObserverHostRemote');
goog.provide('blink.mojom.FileSystemAccessObserverHostPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.FileSystemAccessObserverHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.FileSystemAccessObserverHost.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.FileSystemAccessObserverHostInterface = class {
  
  /**
   * @param { !blink.mojom.FileSystemAccessTransferTokenRemote } token
   * @param { !boolean } isRecursive
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        observerReceiver: ?blink.mojom.FileSystemAccessObserverPendingReceiver,
   *  }>}
   */

  observe(token, isRecursive) {}
  
  /**
   * @param { !blink.mojom.FileSystemAccessTransferTokenRemote } token
   */

  unobserve(token) {}
};

/**
 * @export
 * @implements { blink.mojom.FileSystemAccessObserverHostInterface }
 */
blink.mojom.FileSystemAccessObserverHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.FileSystemAccessObserverHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.FileSystemAccessObserverHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.FileSystemAccessObserverHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.FileSystemAccessTransferTokenRemote } token
   * @param { !boolean } isRecursive
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        observerReceiver: ?blink.mojom.FileSystemAccessObserverPendingReceiver,
   *  }>}
   */

  observe(
      token,
      isRecursive) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.FileSystemAccessObserverHost_Observe_ParamsSpec.$,
        blink.mojom.FileSystemAccessObserverHost_Observe_ResponseParamsSpec.$,
        [
          token,
          isRecursive
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FileSystemAccessTransferTokenRemote } token
   */

  unobserve(
      token) {
    this.proxy.sendMessage(
        1,
        blink.mojom.FileSystemAccessObserverHost_Unobserve_ParamsSpec.$,
        null,
        [
          token
        ],
        false);
  }
};

/**
 * An object which receives request messages for the FileSystemAccessObserverHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.FileSystemAccessObserverHostReceiver = class {
  /**
   * @param {!blink.mojom.FileSystemAccessObserverHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.FileSystemAccessObserverHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.FileSystemAccessObserverHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FileSystemAccessObserverHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FileSystemAccessObserverHost_Observe_ParamsSpec.$,
        blink.mojom.FileSystemAccessObserverHost_Observe_ResponseParamsSpec.$,
        impl.observe.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FileSystemAccessObserverHost_Unobserve_ParamsSpec.$,
        null,
        impl.unobserve.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.FileSystemAccessObserverHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FileSystemAccessObserverHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.FileSystemAccessObserverHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.FileSystemAccessObserverHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the FileSystemAccessObserverHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.FileSystemAccessObserverHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.FileSystemAccessObserverHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FileSystemAccessObserverHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.observe =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FileSystemAccessObserverHost_Observe_ParamsSpec.$,
        blink.mojom.FileSystemAccessObserverHost_Observe_ResponseParamsSpec.$,
        this.observe.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.unobserve =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FileSystemAccessObserverHost_Unobserve_ParamsSpec.$,
        null,
        this.unobserve.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.FileSystemAccessObserverHost_Observe_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessObserverHost_Observe_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessObserverHost_Observe_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessObserverHost_Observe_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessObserverHost_Unobserve_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessObserverHost_Unobserve_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.FileSystemAccessObserverHost_Observe_ParamsSpec.$,
    'FileSystemAccessObserverHost_Observe_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.FileSystemAccessTransferTokenRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isRecursive', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FileSystemAccessObserverHost_Observe_Params');

/** @record */
blink.mojom.FileSystemAccessObserverHost_Observe_Params = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessTransferTokenRemote } */
    this.token;
    /** @export { !boolean } */
    this.isRecursive;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessObserverHost_Observe_ResponseParamsSpec.$,
    'FileSystemAccessObserverHost_Observe_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.FileSystemAccessErrorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'observerReceiver', 8,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.FileSystemAccessObserverPendingReceiver),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FileSystemAccessObserverHost_Observe_ResponseParams');

/** @record */
blink.mojom.FileSystemAccessObserverHost_Observe_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessError } */
    this.result;
    /** @export { (blink.mojom.FileSystemAccessObserverPendingReceiver|undefined) } */
    this.observerReceiver;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessObserverHost_Unobserve_ParamsSpec.$,
    'FileSystemAccessObserverHost_Unobserve_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.FileSystemAccessTransferTokenRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessObserverHost_Unobserve_Params');

/** @record */
blink.mojom.FileSystemAccessObserverHost_Unobserve_Params = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessTransferTokenRemote } */
    this.token;
  }
};

