// third_party/blink/public/mojom/file_system_access/file_system_access_manager.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('blink.mojom.FileSystemAccessPermissionMode');
goog.require('blink.mojom.FileSystemAccessDataTransferToken');
goog.require('blink.mojom.FileSystemAccessDirectoryHandle');
goog.require('blink.mojom.FileSystemAccessFileHandle');
goog.require('blink.mojom.FileSystemAccessObserverHost');
goog.require('blink.mojom.FileSystemAccessTransferToken');
goog.require('blink.mojom.FileSystemAccessEntry');
goog.require('blink.mojom.FileSystemAccessError');
goog.require('mojoBase.mojom.String16');




goog.provide('blink.mojom.WellKnownDirectory');
goog.provide('blink.mojom.WellKnownDirectorySpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.WellKnownDirectorySpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.WellKnownDirectory = {
  
  kDirDesktop: 0,
  kDirDocuments: 1,
  kDirDownloads: 2,
  kDirMusic: 3,
  kDirPictures: 4,
  kDirVideos: 5,
  MIN_VALUE: 0,
  MAX_VALUE: 5,
};



goog.provide('blink.mojom.FileSystemAccessManager');
goog.provide('blink.mojom.FileSystemAccessManagerReceiver');
goog.provide('blink.mojom.FileSystemAccessManagerCallbackRouter');
goog.provide('blink.mojom.FileSystemAccessManagerInterface');
goog.provide('blink.mojom.FileSystemAccessManagerRemote');
goog.provide('blink.mojom.FileSystemAccessManagerPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.FileSystemAccessManagerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.FileSystemAccessManager.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.FileSystemAccessManagerInterface = class {
  
  /**
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        directory: ?blink.mojom.FileSystemAccessDirectoryHandleRemote,
   *  }>}
   */

  getSandboxedFileSystem() {}
  
  /**
   * @param { !Array<!string> } directoryPathComponents
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        directory: ?blink.mojom.FileSystemAccessDirectoryHandleRemote,
   *  }>}
   */

  getSandboxedFileSystemForDevtools(directoryPathComponents) {}
  
  /**
   * @param { !blink.mojom.FilePickerOptions } options
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        entries: !Array<!blink.mojom.FileSystemAccessEntry>,
   *  }>}
   */

  chooseEntries(options) {}
  
  /**
   * @param { !blink.mojom.FileSystemAccessTransferTokenRemote } token
   * @param { !blink.mojom.FileSystemAccessFileHandlePendingReceiver } fileHandle
   */

  getFileHandleFromToken(token, fileHandle) {}
  
  /**
   * @param { !blink.mojom.FileSystemAccessTransferTokenRemote } token
   * @param { !blink.mojom.FileSystemAccessDirectoryHandlePendingReceiver } directoryHandle
   */

  getDirectoryHandleFromToken(token, directoryHandle) {}
  
  /**
   * @param { !blink.mojom.FileSystemAccessDataTransferTokenRemote } token
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        entry: ?blink.mojom.FileSystemAccessEntry,
   *  }>}
   */

  getEntryFromDataTransferToken(token) {}
  
  /**
   * @param { !blink.mojom.FileSystemAccessObserverHostPendingReceiver } observerHost
   */

  bindObserverHost(observerHost) {}
};

/**
 * @export
 * @implements { blink.mojom.FileSystemAccessManagerInterface }
 */
blink.mojom.FileSystemAccessManagerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.FileSystemAccessManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.FileSystemAccessManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.FileSystemAccessManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        directory: ?blink.mojom.FileSystemAccessDirectoryHandleRemote,
   *  }>}
   */

  getSandboxedFileSystem() {
    return this.proxy.sendMessage(
        0,
        blink.mojom.FileSystemAccessManager_GetSandboxedFileSystem_ParamsSpec.$,
        blink.mojom.FileSystemAccessManager_GetSandboxedFileSystem_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !Array<!string> } directoryPathComponents
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        directory: ?blink.mojom.FileSystemAccessDirectoryHandleRemote,
   *  }>}
   */

  getSandboxedFileSystemForDevtools(
      directoryPathComponents) {
    return this.proxy.sendMessage(
        1,
        blink.mojom.FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ParamsSpec.$,
        blink.mojom.FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParamsSpec.$,
        [
          directoryPathComponents
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FilePickerOptions } options
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        entries: !Array<!blink.mojom.FileSystemAccessEntry>,
   *  }>}
   */

  chooseEntries(
      options) {
    return this.proxy.sendMessage(
        2,
        blink.mojom.FileSystemAccessManager_ChooseEntries_ParamsSpec.$,
        blink.mojom.FileSystemAccessManager_ChooseEntries_ResponseParamsSpec.$,
        [
          options
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FileSystemAccessTransferTokenRemote } token
   * @param { !blink.mojom.FileSystemAccessFileHandlePendingReceiver } fileHandle
   */

  getFileHandleFromToken(
      token,
      fileHandle) {
    this.proxy.sendMessage(
        3,
        blink.mojom.FileSystemAccessManager_GetFileHandleFromToken_ParamsSpec.$,
        null,
        [
          token,
          fileHandle
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FileSystemAccessTransferTokenRemote } token
   * @param { !blink.mojom.FileSystemAccessDirectoryHandlePendingReceiver } directoryHandle
   */

  getDirectoryHandleFromToken(
      token,
      directoryHandle) {
    this.proxy.sendMessage(
        4,
        blink.mojom.FileSystemAccessManager_GetDirectoryHandleFromToken_ParamsSpec.$,
        null,
        [
          token,
          directoryHandle
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FileSystemAccessDataTransferTokenRemote } token
   * @return {!Promise<{
        result: !blink.mojom.FileSystemAccessError,
        entry: ?blink.mojom.FileSystemAccessEntry,
   *  }>}
   */

  getEntryFromDataTransferToken(
      token) {
    return this.proxy.sendMessage(
        5,
        blink.mojom.FileSystemAccessManager_GetEntryFromDataTransferToken_ParamsSpec.$,
        blink.mojom.FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParamsSpec.$,
        [
          token
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FileSystemAccessObserverHostPendingReceiver } observerHost
   */

  bindObserverHost(
      observerHost) {
    this.proxy.sendMessage(
        6,
        blink.mojom.FileSystemAccessManager_BindObserverHost_ParamsSpec.$,
        null,
        [
          observerHost
        ],
        false);
  }
};

/**
 * An object which receives request messages for the FileSystemAccessManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.FileSystemAccessManagerReceiver = class {
  /**
   * @param {!blink.mojom.FileSystemAccessManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.FileSystemAccessManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.FileSystemAccessManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FileSystemAccessManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FileSystemAccessManager_GetSandboxedFileSystem_ParamsSpec.$,
        blink.mojom.FileSystemAccessManager_GetSandboxedFileSystem_ResponseParamsSpec.$,
        impl.getSandboxedFileSystem.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ParamsSpec.$,
        blink.mojom.FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParamsSpec.$,
        impl.getSandboxedFileSystemForDevtools.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.FileSystemAccessManager_ChooseEntries_ParamsSpec.$,
        blink.mojom.FileSystemAccessManager_ChooseEntries_ResponseParamsSpec.$,
        impl.chooseEntries.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.FileSystemAccessManager_GetFileHandleFromToken_ParamsSpec.$,
        null,
        impl.getFileHandleFromToken.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.FileSystemAccessManager_GetDirectoryHandleFromToken_ParamsSpec.$,
        null,
        impl.getDirectoryHandleFromToken.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.FileSystemAccessManager_GetEntryFromDataTransferToken_ParamsSpec.$,
        blink.mojom.FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParamsSpec.$,
        impl.getEntryFromDataTransferToken.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        blink.mojom.FileSystemAccessManager_BindObserverHost_ParamsSpec.$,
        null,
        impl.bindObserverHost.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.FileSystemAccessManager = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FileSystemAccessManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.FileSystemAccessManagerRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.FileSystemAccessManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the FileSystemAccessManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.FileSystemAccessManagerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.FileSystemAccessManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FileSystemAccessManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getSandboxedFileSystem =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FileSystemAccessManager_GetSandboxedFileSystem_ParamsSpec.$,
        blink.mojom.FileSystemAccessManager_GetSandboxedFileSystem_ResponseParamsSpec.$,
        this.getSandboxedFileSystem.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getSandboxedFileSystemForDevtools =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ParamsSpec.$,
        blink.mojom.FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParamsSpec.$,
        this.getSandboxedFileSystemForDevtools.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.chooseEntries =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.FileSystemAccessManager_ChooseEntries_ParamsSpec.$,
        blink.mojom.FileSystemAccessManager_ChooseEntries_ResponseParamsSpec.$,
        this.chooseEntries.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getFileHandleFromToken =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.FileSystemAccessManager_GetFileHandleFromToken_ParamsSpec.$,
        null,
        this.getFileHandleFromToken.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDirectoryHandleFromToken =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.FileSystemAccessManager_GetDirectoryHandleFromToken_ParamsSpec.$,
        null,
        this.getDirectoryHandleFromToken.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getEntryFromDataTransferToken =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.FileSystemAccessManager_GetEntryFromDataTransferToken_ParamsSpec.$,
        blink.mojom.FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParamsSpec.$,
        this.getEntryFromDataTransferToken.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindObserverHost =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        blink.mojom.FileSystemAccessManager_BindObserverHost_ParamsSpec.$,
        null,
        this.bindObserverHost.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.ChooseFileSystemEntryAcceptsOptionSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ChooseFileSystemEntryAcceptsOptionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.AcceptsTypesInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AcceptsTypesInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.OpenFilePickerOptionsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.OpenFilePickerOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.SaveFilePickerOptionsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SaveFilePickerOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.DirectoryPickerOptionsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DirectoryPickerOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FilePickerOptionsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FilePickerOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessManager_GetSandboxedFileSystem_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessManager_GetSandboxedFileSystem_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessManager_GetSandboxedFileSystem_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessManager_GetSandboxedFileSystem_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessManager_ChooseEntries_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessManager_ChooseEntries_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessManager_ChooseEntries_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessManager_ChooseEntries_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessManager_GetFileHandleFromToken_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessManager_GetFileHandleFromToken_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessManager_GetDirectoryHandleFromToken_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessManager_GetDirectoryHandleFromToken_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessManager_GetEntryFromDataTransferToken_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessManager_GetEntryFromDataTransferToken_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessManager_BindObserverHost_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessManager_BindObserverHost_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.TypeSpecificFilePickerOptionsUnionSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.TypeSpecificFilePickerOptionsUnionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FilePickerStartInOptionsUnionSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.FilePickerStartInOptionsUnionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.ChooseFileSystemEntryAcceptsOptionSpec.$,
    'ChooseFileSystemEntryAcceptsOption',
    [
      mojo.internal.StructField(
        'description', 0,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mimeTypes', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'extensions', 16,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.ChooseFileSystemEntryAcceptsOption');

/** @record */
blink.mojom.ChooseFileSystemEntryAcceptsOption = class {
  constructor() {
    /** @export { !mojoBase.mojom.String16 } */
    this.description;
    /** @export { !Array<!string> } */
    this.mimeTypes;
    /** @export { !Array<!string> } */
    this.extensions;
  }
};



mojo.internal.Struct(
    blink.mojom.AcceptsTypesInfoSpec.$,
    'AcceptsTypesInfo',
    [
      mojo.internal.StructField(
        'accepts', 0,
        0,
        mojo.internal.Array(blink.mojom.ChooseFileSystemEntryAcceptsOptionSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'includeAcceptsAll', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.AcceptsTypesInfo');

/** @record */
blink.mojom.AcceptsTypesInfo = class {
  constructor() {
    /** @export { !Array<!blink.mojom.ChooseFileSystemEntryAcceptsOption> } */
    this.accepts;
    /** @export { !boolean } */
    this.includeAcceptsAll;
  }
};



mojo.internal.Struct(
    blink.mojom.OpenFilePickerOptionsSpec.$,
    'OpenFilePickerOptions',
    [
      mojo.internal.StructField(
        'acceptsTypesInfo', 0,
        0,
        blink.mojom.AcceptsTypesInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'canSelectMultipleFiles', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.OpenFilePickerOptions');

/** @record */
blink.mojom.OpenFilePickerOptions = class {
  constructor() {
    /** @export { !blink.mojom.AcceptsTypesInfo } */
    this.acceptsTypesInfo;
    /** @export { !boolean } */
    this.canSelectMultipleFiles;
  }
};



mojo.internal.Struct(
    blink.mojom.SaveFilePickerOptionsSpec.$,
    'SaveFilePickerOptions',
    [
      mojo.internal.StructField(
        'acceptsTypesInfo', 0,
        0,
        blink.mojom.AcceptsTypesInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'suggestedName', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.SaveFilePickerOptions');

/** @record */
blink.mojom.SaveFilePickerOptions = class {
  constructor() {
    /** @export { !blink.mojom.AcceptsTypesInfo } */
    this.acceptsTypesInfo;
    /** @export { !string } */
    this.suggestedName;
  }
};



mojo.internal.Struct(
    blink.mojom.DirectoryPickerOptionsSpec.$,
    'DirectoryPickerOptions',
    [
      mojo.internal.StructField(
        'permissionMode', 0,
        0,
        blink.mojom.FileSystemAccessPermissionModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.DirectoryPickerOptions');

/** @record */
blink.mojom.DirectoryPickerOptions = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessPermissionMode } */
    this.permissionMode;
  }
};



mojo.internal.Struct(
    blink.mojom.FilePickerOptionsSpec.$,
    'FilePickerOptions',
    [
      mojo.internal.StructField(
        'typeSpecificOptions', 0,
        0,
        blink.mojom.TypeSpecificFilePickerOptionsUnionSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'startingDirectoryId', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'startInOptions', 24,
        0,
        blink.mojom.FilePickerStartInOptionsUnionSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('blink.mojom.FilePickerOptions');

/** @record */
blink.mojom.FilePickerOptions = class {
  constructor() {
    /** @export { !blink.mojom.TypeSpecificFilePickerOptionsUnion } */
    this.typeSpecificOptions;
    /** @export { !string } */
    this.startingDirectoryId;
    /** @export { (blink.mojom.FilePickerStartInOptionsUnion|undefined) } */
    this.startInOptions;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessManager_GetSandboxedFileSystem_ParamsSpec.$,
    'FileSystemAccessManager_GetSandboxedFileSystem_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.FileSystemAccessManager_GetSandboxedFileSystem_Params');

/** @record */
blink.mojom.FileSystemAccessManager_GetSandboxedFileSystem_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessManager_GetSandboxedFileSystem_ResponseParamsSpec.$,
    'FileSystemAccessManager_GetSandboxedFileSystem_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.FileSystemAccessErrorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'directory', 8,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.FileSystemAccessDirectoryHandleRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FileSystemAccessManager_GetSandboxedFileSystem_ResponseParams');

/** @record */
blink.mojom.FileSystemAccessManager_GetSandboxedFileSystem_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessError } */
    this.result;
    /** @export { (blink.mojom.FileSystemAccessDirectoryHandleRemote|undefined) } */
    this.directory;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ParamsSpec.$,
    'FileSystemAccessManager_GetSandboxedFileSystemForDevtools_Params',
    [
      mojo.internal.StructField(
        'directoryPathComponents', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessManager_GetSandboxedFileSystemForDevtools_Params');

/** @record */
blink.mojom.FileSystemAccessManager_GetSandboxedFileSystemForDevtools_Params = class {
  constructor() {
    /** @export { !Array<!string> } */
    this.directoryPathComponents;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParamsSpec.$,
    'FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.FileSystemAccessErrorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'directory', 8,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.FileSystemAccessDirectoryHandleRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParams');

/** @record */
blink.mojom.FileSystemAccessManager_GetSandboxedFileSystemForDevtools_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessError } */
    this.result;
    /** @export { (blink.mojom.FileSystemAccessDirectoryHandleRemote|undefined) } */
    this.directory;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessManager_ChooseEntries_ParamsSpec.$,
    'FileSystemAccessManager_ChooseEntries_Params',
    [
      mojo.internal.StructField(
        'options', 0,
        0,
        blink.mojom.FilePickerOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessManager_ChooseEntries_Params');

/** @record */
blink.mojom.FileSystemAccessManager_ChooseEntries_Params = class {
  constructor() {
    /** @export { !blink.mojom.FilePickerOptions } */
    this.options;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessManager_ChooseEntries_ResponseParamsSpec.$,
    'FileSystemAccessManager_ChooseEntries_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.FileSystemAccessErrorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'entries', 8,
        0,
        mojo.internal.Array(blink.mojom.FileSystemAccessEntrySpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FileSystemAccessManager_ChooseEntries_ResponseParams');

/** @record */
blink.mojom.FileSystemAccessManager_ChooseEntries_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessError } */
    this.result;
    /** @export { !Array<!blink.mojom.FileSystemAccessEntry> } */
    this.entries;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessManager_GetFileHandleFromToken_ParamsSpec.$,
    'FileSystemAccessManager_GetFileHandleFromToken_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.FileSystemAccessTransferTokenRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fileHandle', 8,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.FileSystemAccessFileHandlePendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FileSystemAccessManager_GetFileHandleFromToken_Params');

/** @record */
blink.mojom.FileSystemAccessManager_GetFileHandleFromToken_Params = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessTransferTokenRemote } */
    this.token;
    /** @export { !blink.mojom.FileSystemAccessFileHandlePendingReceiver } */
    this.fileHandle;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessManager_GetDirectoryHandleFromToken_ParamsSpec.$,
    'FileSystemAccessManager_GetDirectoryHandleFromToken_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.FileSystemAccessTransferTokenRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'directoryHandle', 8,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.FileSystemAccessDirectoryHandlePendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FileSystemAccessManager_GetDirectoryHandleFromToken_Params');

/** @record */
blink.mojom.FileSystemAccessManager_GetDirectoryHandleFromToken_Params = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessTransferTokenRemote } */
    this.token;
    /** @export { !blink.mojom.FileSystemAccessDirectoryHandlePendingReceiver } */
    this.directoryHandle;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessManager_GetEntryFromDataTransferToken_ParamsSpec.$,
    'FileSystemAccessManager_GetEntryFromDataTransferToken_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.FileSystemAccessDataTransferTokenRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessManager_GetEntryFromDataTransferToken_Params');

/** @record */
blink.mojom.FileSystemAccessManager_GetEntryFromDataTransferToken_Params = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessDataTransferTokenRemote } */
    this.token;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParamsSpec.$,
    'FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.FileSystemAccessErrorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'entry', 8,
        0,
        blink.mojom.FileSystemAccessEntrySpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParams');

/** @record */
blink.mojom.FileSystemAccessManager_GetEntryFromDataTransferToken_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessError } */
    this.result;
    /** @export { (blink.mojom.FileSystemAccessEntry|undefined) } */
    this.entry;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessManager_BindObserverHost_ParamsSpec.$,
    'FileSystemAccessManager_BindObserverHost_Params',
    [
      mojo.internal.StructField(
        'observerHost', 0,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.FileSystemAccessObserverHostPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessManager_BindObserverHost_Params');

/** @record */
blink.mojom.FileSystemAccessManager_BindObserverHost_Params = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessObserverHostPendingReceiver } */
    this.observerHost;
  }
};

goog.provide('blink.mojom.TypeSpecificFilePickerOptionsUnion');


mojo.internal.Union(
    blink.mojom.TypeSpecificFilePickerOptionsUnionSpec.$, 'TypeSpecificFilePickerOptionsUnion',
    {
      'openFilePickerOptions': {
        'ordinal': 0,
        'type': blink.mojom.OpenFilePickerOptionsSpec.$,
      },
      'saveFilePickerOptions': {
        'ordinal': 1,
        'type': blink.mojom.SaveFilePickerOptionsSpec.$,
      },
      'directoryPickerOptions': {
        'ordinal': 2,
        'type': blink.mojom.DirectoryPickerOptionsSpec.$,
      },
    });

/**
 * @typedef { {
 *   openFilePickerOptions: (!blink.mojom.OpenFilePickerOptions|undefined),
 *   saveFilePickerOptions: (!blink.mojom.SaveFilePickerOptions|undefined),
 *   directoryPickerOptions: (!blink.mojom.DirectoryPickerOptions|undefined),
 * } }
 */
blink.mojom.TypeSpecificFilePickerOptionsUnion;
goog.provide('blink.mojom.FilePickerStartInOptionsUnion');


mojo.internal.Union(
    blink.mojom.FilePickerStartInOptionsUnionSpec.$, 'FilePickerStartInOptionsUnion',
    {
      'wellKnownDirectory': {
        'ordinal': 0,
        'type': blink.mojom.WellKnownDirectorySpec.$,
      },
      'directoryToken': {
        'ordinal': 1,
        'type': mojo.internal.InterfaceProxy(blink.mojom.FileSystemAccessTransferTokenRemote),
      },
    });

/**
 * @typedef { {
 *   wellKnownDirectory: (!blink.mojom.WellKnownDirectory|undefined),
 *   directoryToken: (!blink.mojom.FileSystemAccessTransferTokenRemote|undefined),
 * } }
 */
blink.mojom.FilePickerStartInOptionsUnion;
