// third_party/blink/public/mojom/file_system_access/file_system_access_file_writer.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_FILE_WRITER_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_FILE_WRITER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_writer.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_writer.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_writer.mojom-blink-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/file_system_access/file_system_access_error.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class FileSystemAccessFileWriterProxy;

template <typename ImplRefTraits>
class FileSystemAccessFileWriterStub;

class FileSystemAccessFileWriterRequestValidator;
class FileSystemAccessFileWriterResponseValidator;


class PLATFORM_EXPORT FileSystemAccessFileWriter
    : public FileSystemAccessFileWriterInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.FileSystemAccessFileWriter";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FileSystemAccessFileWriterInterfaceBase;
  using Proxy_ = FileSystemAccessFileWriterProxy;

  template <typename ImplRefTraits>
  using Stub_ = FileSystemAccessFileWriterStub<ImplRefTraits>;

  using RequestValidator_ = FileSystemAccessFileWriterRequestValidator;
  using ResponseValidator_ = FileSystemAccessFileWriterResponseValidator;
  enum MethodMinVersions : uint32_t {
    kWriteMinVersion = 0,
    kTruncateMinVersion = 0,
    kCloseMinVersion = 0,
    kAbortMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Write_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Truncate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Close_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Abort_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FileSystemAccessFileWriter() = default;

  using WriteCallback = base::OnceCallback<void(::blink::mojom::blink::FileSystemAccessErrorPtr, uint64_t)>;
  using WriteMojoCallback = base::OnceCallback<void(::blink::mojom::blink::FileSystemAccessErrorPtr, uint64_t)>;

  virtual void Write(uint64_t offset, ::mojo::ScopedDataPipeConsumerHandle stream, WriteCallback callback) = 0;

  using TruncateCallback = base::OnceCallback<void(::blink::mojom::blink::FileSystemAccessErrorPtr)>;
  using TruncateMojoCallback = base::OnceCallback<void(::blink::mojom::blink::FileSystemAccessErrorPtr)>;

  virtual void Truncate(uint64_t length, TruncateCallback callback) = 0;

  using CloseCallback = base::OnceCallback<void(::blink::mojom::blink::FileSystemAccessErrorPtr)>;
  using CloseMojoCallback = base::OnceCallback<void(::blink::mojom::blink::FileSystemAccessErrorPtr)>;

  virtual void Close(CloseCallback callback) = 0;

  using AbortCallback = base::OnceCallback<void(::blink::mojom::blink::FileSystemAccessErrorPtr)>;
  using AbortMojoCallback = base::OnceCallback<void(::blink::mojom::blink::FileSystemAccessErrorPtr)>;

  virtual void Abort(AbortCallback callback) = 0;
};



class PLATFORM_EXPORT FileSystemAccessFileWriterProxy
    : public FileSystemAccessFileWriter {
 public:
  using InterfaceType = FileSystemAccessFileWriter;

  explicit FileSystemAccessFileWriterProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Write(uint64_t offset, ::mojo::ScopedDataPipeConsumerHandle stream, WriteCallback callback) final;
  
  void Truncate(uint64_t length, TruncateCallback callback) final;
  
  void Close(CloseCallback callback) final;
  
  void Abort(AbortCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT FileSystemAccessFileWriterStubDispatch {
 public:
  static bool Accept(FileSystemAccessFileWriter* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FileSystemAccessFileWriter* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FileSystemAccessFileWriter>>
class FileSystemAccessFileWriterStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FileSystemAccessFileWriterStub() = default;
  ~FileSystemAccessFileWriterStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FileSystemAccessFileWriterStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FileSystemAccessFileWriterStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT FileSystemAccessFileWriterRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT FileSystemAccessFileWriterResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // blink::mojom::blink

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_FILE_WRITER_MOJOM_BLINK_H_