// third_party/blink/public/mojom/file_system_access/file_system_access_file_handle.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/file_system_access/file_system_access_file_handle.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var file_info$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/file_info.mojom', '../../../../../mojo/public/mojom/base/file_info.mojom.js');
  }
  var file$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/file.mojom', '../../../../../mojo/public/mojom/base/file.mojom.js');
  }
  var blob$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/blob/blob.mojom', '../blob/blob.mojom.js');
  }
  var serialized_blob$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/blob/serialized_blob.mojom', '../blob/serialized_blob.mojom.js');
  }
  var file_system_access_access_handle_host$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/file_system_access/file_system_access_access_handle_host.mojom', 'file_system_access_access_handle_host.mojom.js');
  }
  var file_system_access_file_modification_host$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/file_system_access/file_system_access_file_modification_host.mojom', 'file_system_access_file_modification_host.mojom.js');
  }
  var file_system_access_cloud_identifier$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/file_system_access/file_system_access_cloud_identifier.mojom', 'file_system_access_cloud_identifier.mojom.js');
  }
  var file_system_access_error$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/file_system_access/file_system_access_error.mojom', 'file_system_access_error.mojom.js');
  }
  var file_system_access_file_delegate_host$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/file_system_access/file_system_access_file_delegate_host.mojom', 'file_system_access_file_delegate_host.mojom.js');
  }
  var file_system_access_file_writer$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/file_system_access/file_system_access_file_writer.mojom', 'file_system_access_file_writer.mojom.js');
  }
  var file_system_access_transfer_token$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/file_system_access/file_system_access_transfer_token.mojom', 'file_system_access_transfer_token.mojom.js');
  }
  var file_system_access_permission_mode$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/file_system_access/file_system_access_permission_mode.mojom', 'file_system_access_permission_mode.mojom.js');
  }
  var permission_status$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/permissions/permission_status.mojom', '../permissions/permission_status.mojom.js');
  }


  var FileSystemAccessAccessHandleLockMode = {};
  FileSystemAccessAccessHandleLockMode.kReadwrite = 0;
  FileSystemAccessAccessHandleLockMode.kReadOnly = 1;
  FileSystemAccessAccessHandleLockMode.kReadwriteUnsafe = 2;
  FileSystemAccessAccessHandleLockMode.MIN_VALUE = 0;
  FileSystemAccessAccessHandleLockMode.MAX_VALUE = 2;

  FileSystemAccessAccessHandleLockMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  FileSystemAccessAccessHandleLockMode.toKnownEnumValue = function(value) {
    return value;
  };

  FileSystemAccessAccessHandleLockMode.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var FileSystemAccessWritableFileStreamLockMode = {};
  FileSystemAccessWritableFileStreamLockMode.kExclusive = 0;
  FileSystemAccessWritableFileStreamLockMode.kSiloed = 1;
  FileSystemAccessWritableFileStreamLockMode.MIN_VALUE = 0;
  FileSystemAccessWritableFileStreamLockMode.MAX_VALUE = 1;

  FileSystemAccessWritableFileStreamLockMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  FileSystemAccessWritableFileStreamLockMode.toKnownEnumValue = function(value) {
    return value;
  };

  FileSystemAccessWritableFileStreamLockMode.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function FileSystemAccessRegularFile(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessRegularFile.prototype.initDefaults_ = function() {
    this.osFile = null;
    this.fileSize = 0;
    this.fileModificationHost = new file_system_access_file_modification_host$.FileSystemAccessFileModificationHostPtr();
  };
  FileSystemAccessRegularFile.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessRegularFile.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessRegularFile.osFile
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file$.File, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate FileSystemAccessRegularFile.fileModificationHost
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessRegularFile.encodedSize = codec.kStructHeaderSize + 24;

  FileSystemAccessRegularFile.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessRegularFile();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.osFile =
        decoder.decodeStructPointer(file$.File);
    val.fileSize =
        decoder.decodeStruct(codec.Int64);
    val.fileModificationHost =
        decoder.decodeStruct(new codec.Interface(file_system_access_file_modification_host$.FileSystemAccessFileModificationHostPtr));
    return val;
  };

  FileSystemAccessRegularFile.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessRegularFile.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file$.File, val.osFile);
    encoder.encodeStruct(codec.Int64, val.fileSize);
    encoder.encodeStruct(new codec.Interface(file_system_access_file_modification_host$.FileSystemAccessFileModificationHostPtr), val.fileModificationHost);
  };
  function FileSystemAccessFileHandle_GetPermissionStatus_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileHandle_GetPermissionStatus_Params.prototype.initDefaults_ = function() {
    this.mode = 0;
  };
  FileSystemAccessFileHandle_GetPermissionStatus_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileHandle_GetPermissionStatus_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessFileHandle_GetPermissionStatus_Params.mode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, file_system_access_permission_mode$.FileSystemAccessPermissionMode);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessFileHandle_GetPermissionStatus_Params.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessFileHandle_GetPermissionStatus_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileHandle_GetPermissionStatus_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.mode =
        decoder.decodeStruct(new codec.Enum(file_system_access_permission_mode$.FileSystemAccessPermissionMode));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FileSystemAccessFileHandle_GetPermissionStatus_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileHandle_GetPermissionStatus_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.mode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FileSystemAccessFileHandle_GetPermissionStatus_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileHandle_GetPermissionStatus_ResponseParams.prototype.initDefaults_ = function() {
    this.status = 0;
  };
  FileSystemAccessFileHandle_GetPermissionStatus_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileHandle_GetPermissionStatus_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessFileHandle_GetPermissionStatus_ResponseParams.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, permission_status$.PermissionStatus);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessFileHandle_GetPermissionStatus_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessFileHandle_GetPermissionStatus_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileHandle_GetPermissionStatus_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(permission_status$.PermissionStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FileSystemAccessFileHandle_GetPermissionStatus_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileHandle_GetPermissionStatus_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FileSystemAccessFileHandle_RequestPermission_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileHandle_RequestPermission_Params.prototype.initDefaults_ = function() {
    this.mode = 0;
  };
  FileSystemAccessFileHandle_RequestPermission_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileHandle_RequestPermission_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessFileHandle_RequestPermission_Params.mode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, file_system_access_permission_mode$.FileSystemAccessPermissionMode);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessFileHandle_RequestPermission_Params.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessFileHandle_RequestPermission_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileHandle_RequestPermission_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.mode =
        decoder.decodeStruct(new codec.Enum(file_system_access_permission_mode$.FileSystemAccessPermissionMode));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FileSystemAccessFileHandle_RequestPermission_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileHandle_RequestPermission_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.mode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FileSystemAccessFileHandle_RequestPermission_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileHandle_RequestPermission_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
    this.status = 0;
  };
  FileSystemAccessFileHandle_RequestPermission_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileHandle_RequestPermission_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessFileHandle_RequestPermission_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_system_access_error$.FileSystemAccessError, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessFileHandle_RequestPermission_ResponseParams.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, permission_status$.PermissionStatus);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessFileHandle_RequestPermission_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  FileSystemAccessFileHandle_RequestPermission_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileHandle_RequestPermission_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(file_system_access_error$.FileSystemAccessError);
    val.status =
        decoder.decodeStruct(new codec.Enum(permission_status$.PermissionStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FileSystemAccessFileHandle_RequestPermission_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileHandle_RequestPermission_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_system_access_error$.FileSystemAccessError, val.result);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FileSystemAccessFileHandle_AsBlob_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileHandle_AsBlob_Params.prototype.initDefaults_ = function() {
  };
  FileSystemAccessFileHandle_AsBlob_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileHandle_AsBlob_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessFileHandle_AsBlob_Params.encodedSize = codec.kStructHeaderSize + 0;

  FileSystemAccessFileHandle_AsBlob_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileHandle_AsBlob_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FileSystemAccessFileHandle_AsBlob_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileHandle_AsBlob_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function FileSystemAccessFileHandle_AsBlob_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileHandle_AsBlob_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
    this.info = null;
    this.blob = null;
  };
  FileSystemAccessFileHandle_AsBlob_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileHandle_AsBlob_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessFileHandle_AsBlob_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_system_access_error$.FileSystemAccessError, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessFileHandle_AsBlob_ResponseParams.info
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, file_info$.FileInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessFileHandle_AsBlob_ResponseParams.blob
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, serialized_blob$.SerializedBlob, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessFileHandle_AsBlob_ResponseParams.encodedSize = codec.kStructHeaderSize + 24;

  FileSystemAccessFileHandle_AsBlob_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileHandle_AsBlob_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(file_system_access_error$.FileSystemAccessError);
    val.info =
        decoder.decodeStructPointer(file_info$.FileInfo);
    val.blob =
        decoder.decodeStructPointer(serialized_blob$.SerializedBlob);
    return val;
  };

  FileSystemAccessFileHandle_AsBlob_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileHandle_AsBlob_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_system_access_error$.FileSystemAccessError, val.result);
    encoder.encodeStructPointer(file_info$.FileInfo, val.info);
    encoder.encodeStructPointer(serialized_blob$.SerializedBlob, val.blob);
  };
  function FileSystemAccessFileHandle_CreateFileWriter_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileHandle_CreateFileWriter_Params.prototype.initDefaults_ = function() {
    this.keepExistingData = false;
    this.autoClose = false;
    this.mode = 0;
  };
  FileSystemAccessFileHandle_CreateFileWriter_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileHandle_CreateFileWriter_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate FileSystemAccessFileHandle_CreateFileWriter_Params.mode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, FileSystemAccessWritableFileStreamLockMode);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessFileHandle_CreateFileWriter_Params.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessFileHandle_CreateFileWriter_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileHandle_CreateFileWriter_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.keepExistingData = (packed >> 0) & 1 ? true : false;
    val.autoClose = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.mode =
        decoder.decodeStruct(new codec.Enum(FileSystemAccessWritableFileStreamLockMode));
    return val;
  };

  FileSystemAccessFileHandle_CreateFileWriter_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileHandle_CreateFileWriter_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.keepExistingData & 1) << 0
    packed |= (val.autoClose & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.mode);
  };
  function FileSystemAccessFileHandle_CreateFileWriter_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileHandle_CreateFileWriter_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
    this.writer = new file_system_access_file_writer$.FileSystemAccessFileWriterPtr();
  };
  FileSystemAccessFileHandle_CreateFileWriter_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileHandle_CreateFileWriter_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessFileHandle_CreateFileWriter_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_system_access_error$.FileSystemAccessError, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessFileHandle_CreateFileWriter_ResponseParams.writer
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 8, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessFileHandle_CreateFileWriter_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  FileSystemAccessFileHandle_CreateFileWriter_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileHandle_CreateFileWriter_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(file_system_access_error$.FileSystemAccessError);
    val.writer =
        decoder.decodeStruct(new codec.NullableInterface(file_system_access_file_writer$.FileSystemAccessFileWriterPtr));
    return val;
  };

  FileSystemAccessFileHandle_CreateFileWriter_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileHandle_CreateFileWriter_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_system_access_error$.FileSystemAccessError, val.result);
    encoder.encodeStruct(new codec.NullableInterface(file_system_access_file_writer$.FileSystemAccessFileWriterPtr), val.writer);
  };
  function FileSystemAccessFileHandle_Rename_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileHandle_Rename_Params.prototype.initDefaults_ = function() {
    this.newEntryName = null;
  };
  FileSystemAccessFileHandle_Rename_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileHandle_Rename_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessFileHandle_Rename_Params.newEntryName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessFileHandle_Rename_Params.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessFileHandle_Rename_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileHandle_Rename_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.newEntryName =
        decoder.decodeStruct(codec.String);
    return val;
  };

  FileSystemAccessFileHandle_Rename_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileHandle_Rename_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.newEntryName);
  };
  function FileSystemAccessFileHandle_Rename_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileHandle_Rename_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  FileSystemAccessFileHandle_Rename_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileHandle_Rename_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessFileHandle_Rename_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_system_access_error$.FileSystemAccessError, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessFileHandle_Rename_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessFileHandle_Rename_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileHandle_Rename_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(file_system_access_error$.FileSystemAccessError);
    return val;
  };

  FileSystemAccessFileHandle_Rename_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileHandle_Rename_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_system_access_error$.FileSystemAccessError, val.result);
  };
  function FileSystemAccessFileHandle_Move_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileHandle_Move_Params.prototype.initDefaults_ = function() {
    this.destinationDirectory = new file_system_access_transfer_token$.FileSystemAccessTransferTokenPtr();
    this.newEntryName = null;
  };
  FileSystemAccessFileHandle_Move_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileHandle_Move_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessFileHandle_Move_Params.destinationDirectory
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessFileHandle_Move_Params.newEntryName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessFileHandle_Move_Params.encodedSize = codec.kStructHeaderSize + 16;

  FileSystemAccessFileHandle_Move_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileHandle_Move_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.destinationDirectory =
        decoder.decodeStruct(new codec.Interface(file_system_access_transfer_token$.FileSystemAccessTransferTokenPtr));
    val.newEntryName =
        decoder.decodeStruct(codec.String);
    return val;
  };

  FileSystemAccessFileHandle_Move_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileHandle_Move_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(file_system_access_transfer_token$.FileSystemAccessTransferTokenPtr), val.destinationDirectory);
    encoder.encodeStruct(codec.String, val.newEntryName);
  };
  function FileSystemAccessFileHandle_Move_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileHandle_Move_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  FileSystemAccessFileHandle_Move_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileHandle_Move_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessFileHandle_Move_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_system_access_error$.FileSystemAccessError, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessFileHandle_Move_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessFileHandle_Move_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileHandle_Move_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(file_system_access_error$.FileSystemAccessError);
    return val;
  };

  FileSystemAccessFileHandle_Move_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileHandle_Move_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_system_access_error$.FileSystemAccessError, val.result);
  };
  function FileSystemAccessFileHandle_Remove_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileHandle_Remove_Params.prototype.initDefaults_ = function() {
  };
  FileSystemAccessFileHandle_Remove_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileHandle_Remove_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessFileHandle_Remove_Params.encodedSize = codec.kStructHeaderSize + 0;

  FileSystemAccessFileHandle_Remove_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileHandle_Remove_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FileSystemAccessFileHandle_Remove_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileHandle_Remove_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function FileSystemAccessFileHandle_Remove_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileHandle_Remove_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  FileSystemAccessFileHandle_Remove_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileHandle_Remove_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessFileHandle_Remove_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_system_access_error$.FileSystemAccessError, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessFileHandle_Remove_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessFileHandle_Remove_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileHandle_Remove_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(file_system_access_error$.FileSystemAccessError);
    return val;
  };

  FileSystemAccessFileHandle_Remove_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileHandle_Remove_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_system_access_error$.FileSystemAccessError, val.result);
  };
  function FileSystemAccessFileHandle_OpenAccessHandle_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileHandle_OpenAccessHandle_Params.prototype.initDefaults_ = function() {
    this.mode = 0;
  };
  FileSystemAccessFileHandle_OpenAccessHandle_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileHandle_OpenAccessHandle_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessFileHandle_OpenAccessHandle_Params.mode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, FileSystemAccessAccessHandleLockMode);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessFileHandle_OpenAccessHandle_Params.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessFileHandle_OpenAccessHandle_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileHandle_OpenAccessHandle_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.mode =
        decoder.decodeStruct(new codec.Enum(FileSystemAccessAccessHandleLockMode));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FileSystemAccessFileHandle_OpenAccessHandle_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileHandle_OpenAccessHandle_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.mode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FileSystemAccessFileHandle_OpenAccessHandle_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileHandle_OpenAccessHandle_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
    this.file = null;
    this.accessHandleHost = new file_system_access_access_handle_host$.FileSystemAccessAccessHandleHostPtr();
  };
  FileSystemAccessFileHandle_OpenAccessHandle_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileHandle_OpenAccessHandle_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessFileHandle_OpenAccessHandle_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_system_access_error$.FileSystemAccessError, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessFileHandle_OpenAccessHandle_ResponseParams.file
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 8, FileSystemAccessAccessHandleFile, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessFileHandle_OpenAccessHandle_ResponseParams.accessHandleHost
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 24, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessFileHandle_OpenAccessHandle_ResponseParams.encodedSize = codec.kStructHeaderSize + 32;

  FileSystemAccessFileHandle_OpenAccessHandle_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileHandle_OpenAccessHandle_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(file_system_access_error$.FileSystemAccessError);
    val.file =
        decoder.decodeStruct(FileSystemAccessAccessHandleFile);
    val.accessHandleHost =
        decoder.decodeStruct(new codec.NullableInterface(file_system_access_access_handle_host$.FileSystemAccessAccessHandleHostPtr));
    return val;
  };

  FileSystemAccessFileHandle_OpenAccessHandle_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileHandle_OpenAccessHandle_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_system_access_error$.FileSystemAccessError, val.result);
    encoder.encodeStruct(FileSystemAccessAccessHandleFile, val.file);
    encoder.encodeStruct(new codec.NullableInterface(file_system_access_access_handle_host$.FileSystemAccessAccessHandleHostPtr), val.accessHandleHost);
  };
  function FileSystemAccessFileHandle_IsSameEntry_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileHandle_IsSameEntry_Params.prototype.initDefaults_ = function() {
    this.other = new file_system_access_transfer_token$.FileSystemAccessTransferTokenPtr();
  };
  FileSystemAccessFileHandle_IsSameEntry_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileHandle_IsSameEntry_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessFileHandle_IsSameEntry_Params.other
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessFileHandle_IsSameEntry_Params.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessFileHandle_IsSameEntry_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileHandle_IsSameEntry_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.other =
        decoder.decodeStruct(new codec.Interface(file_system_access_transfer_token$.FileSystemAccessTransferTokenPtr));
    return val;
  };

  FileSystemAccessFileHandle_IsSameEntry_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileHandle_IsSameEntry_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(file_system_access_transfer_token$.FileSystemAccessTransferTokenPtr), val.other);
  };
  function FileSystemAccessFileHandle_IsSameEntry_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileHandle_IsSameEntry_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
    this.isSame = false;
  };
  FileSystemAccessFileHandle_IsSameEntry_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileHandle_IsSameEntry_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessFileHandle_IsSameEntry_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_system_access_error$.FileSystemAccessError, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  FileSystemAccessFileHandle_IsSameEntry_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  FileSystemAccessFileHandle_IsSameEntry_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileHandle_IsSameEntry_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(file_system_access_error$.FileSystemAccessError);
    packed = decoder.readUint8();
    val.isSame = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FileSystemAccessFileHandle_IsSameEntry_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileHandle_IsSameEntry_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_system_access_error$.FileSystemAccessError, val.result);
    packed = 0;
    packed |= (val.isSame & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FileSystemAccessFileHandle_Transfer_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileHandle_Transfer_Params.prototype.initDefaults_ = function() {
    this.token = new bindings.InterfaceRequest();
  };
  FileSystemAccessFileHandle_Transfer_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileHandle_Transfer_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessFileHandle_Transfer_Params.token
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessFileHandle_Transfer_Params.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessFileHandle_Transfer_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileHandle_Transfer_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.token =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FileSystemAccessFileHandle_Transfer_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileHandle_Transfer_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.token);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FileSystemAccessFileHandle_GetUniqueId_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileHandle_GetUniqueId_Params.prototype.initDefaults_ = function() {
  };
  FileSystemAccessFileHandle_GetUniqueId_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileHandle_GetUniqueId_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessFileHandle_GetUniqueId_Params.encodedSize = codec.kStructHeaderSize + 0;

  FileSystemAccessFileHandle_GetUniqueId_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileHandle_GetUniqueId_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FileSystemAccessFileHandle_GetUniqueId_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileHandle_GetUniqueId_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function FileSystemAccessFileHandle_GetUniqueId_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileHandle_GetUniqueId_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
    this.id = null;
  };
  FileSystemAccessFileHandle_GetUniqueId_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileHandle_GetUniqueId_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessFileHandle_GetUniqueId_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_system_access_error$.FileSystemAccessError, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessFileHandle_GetUniqueId_ResponseParams.id
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessFileHandle_GetUniqueId_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  FileSystemAccessFileHandle_GetUniqueId_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileHandle_GetUniqueId_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(file_system_access_error$.FileSystemAccessError);
    val.id =
        decoder.decodeStruct(codec.String);
    return val;
  };

  FileSystemAccessFileHandle_GetUniqueId_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileHandle_GetUniqueId_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_system_access_error$.FileSystemAccessError, val.result);
    encoder.encodeStruct(codec.String, val.id);
  };
  function FileSystemAccessFileHandle_GetCloudIdentifiers_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileHandle_GetCloudIdentifiers_Params.prototype.initDefaults_ = function() {
  };
  FileSystemAccessFileHandle_GetCloudIdentifiers_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileHandle_GetCloudIdentifiers_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessFileHandle_GetCloudIdentifiers_Params.encodedSize = codec.kStructHeaderSize + 0;

  FileSystemAccessFileHandle_GetCloudIdentifiers_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileHandle_GetCloudIdentifiers_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FileSystemAccessFileHandle_GetCloudIdentifiers_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileHandle_GetCloudIdentifiers_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
    this.cloudIdentifiers = null;
  };
  FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_system_access_error$.FileSystemAccessError, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParams.cloudIdentifiers
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(file_system_access_cloud_identifier$.FileSystemAccessCloudIdentifier), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(file_system_access_error$.FileSystemAccessError);
    val.cloudIdentifiers =
        decoder.decodeArrayPointer(new codec.PointerTo(file_system_access_cloud_identifier$.FileSystemAccessCloudIdentifier));
    return val;
  };

  FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_system_access_error$.FileSystemAccessError, val.result);
    encoder.encodeArrayPointer(new codec.PointerTo(file_system_access_cloud_identifier$.FileSystemAccessCloudIdentifier), val.cloudIdentifiers);
  };

  function FileSystemAccessAccessHandleFile(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  FileSystemAccessAccessHandleFile.Tags = {
    regularFile: 0,
    incognitoFileDelegate: 1,
  };

  FileSystemAccessAccessHandleFile.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  FileSystemAccessAccessHandleFile.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "regularFile",
        "incognitoFileDelegate",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a FileSystemAccessAccessHandleFile member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(FileSystemAccessAccessHandleFile.prototype, "regularFile", {
    get: function() {
      if (this.$tag != FileSystemAccessAccessHandleFile.Tags.regularFile) {
        throw new ReferenceError(
            "FileSystemAccessAccessHandleFile.regularFile is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = FileSystemAccessAccessHandleFile.Tags.regularFile;
      this.$data = value;
    }
  });
  Object.defineProperty(FileSystemAccessAccessHandleFile.prototype, "incognitoFileDelegate", {
    get: function() {
      if (this.$tag != FileSystemAccessAccessHandleFile.Tags.incognitoFileDelegate) {
        throw new ReferenceError(
            "FileSystemAccessAccessHandleFile.incognitoFileDelegate is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = FileSystemAccessAccessHandleFile.Tags.incognitoFileDelegate;
      this.$data = value;
    }
  });


    FileSystemAccessAccessHandleFile.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case FileSystemAccessAccessHandleFile.Tags.regularFile:
          encoder.encodeStructPointer(FileSystemAccessRegularFile, val.regularFile);
          break;
        case FileSystemAccessAccessHandleFile.Tags.incognitoFileDelegate:
          encoder.encodeStruct(new codec.Interface(file_system_access_file_delegate_host$.FileSystemAccessFileDelegateHostPtr), val.incognitoFileDelegate);
          break;
      }
      encoder.align();
    };


    FileSystemAccessAccessHandleFile.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new FileSystemAccessAccessHandleFile();
      var tag = decoder.readUint32();
      switch (tag) {
        case FileSystemAccessAccessHandleFile.Tags.regularFile:
          result.regularFile = decoder.decodeStructPointer(FileSystemAccessRegularFile);
          break;
        case FileSystemAccessAccessHandleFile.Tags.incognitoFileDelegate:
          result.incognitoFileDelegate = decoder.decodeStruct(new codec.Interface(file_system_access_file_delegate_host$.FileSystemAccessFileDelegateHostPtr));
          break;
      }
      decoder.align();

      return result;
    };


    FileSystemAccessAccessHandleFile.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case FileSystemAccessAccessHandleFile.Tags.regularFile:
          

    // validate FileSystemAccessAccessHandleFile.regularFile
    err = messageValidator.validateStructPointer(data_offset, FileSystemAccessRegularFile, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case FileSystemAccessAccessHandleFile.Tags.incognitoFileDelegate:
          

    // validate FileSystemAccessAccessHandleFile.incognitoFileDelegate
    err = messageValidator.validateInterface(data_offset, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  FileSystemAccessAccessHandleFile.encodedSize = 16;
  var kFileSystemAccessFileHandle_GetPermissionStatus_Name = 0;
  var kFileSystemAccessFileHandle_RequestPermission_Name = 1;
  var kFileSystemAccessFileHandle_AsBlob_Name = 2;
  var kFileSystemAccessFileHandle_CreateFileWriter_Name = 3;
  var kFileSystemAccessFileHandle_Rename_Name = 4;
  var kFileSystemAccessFileHandle_Move_Name = 5;
  var kFileSystemAccessFileHandle_Remove_Name = 6;
  var kFileSystemAccessFileHandle_OpenAccessHandle_Name = 7;
  var kFileSystemAccessFileHandle_IsSameEntry_Name = 8;
  var kFileSystemAccessFileHandle_Transfer_Name = 9;
  var kFileSystemAccessFileHandle_GetUniqueId_Name = 10;
  var kFileSystemAccessFileHandle_GetCloudIdentifiers_Name = 11;

  function FileSystemAccessFileHandlePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(FileSystemAccessFileHandle,
                                                   handleOrPtrInfo);
  }

  function FileSystemAccessFileHandleAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        FileSystemAccessFileHandle, associatedInterfacePtrInfo);
  }

  FileSystemAccessFileHandleAssociatedPtr.prototype =
      Object.create(FileSystemAccessFileHandlePtr.prototype);
  FileSystemAccessFileHandleAssociatedPtr.prototype.constructor =
      FileSystemAccessFileHandleAssociatedPtr;

  function FileSystemAccessFileHandleProxy(receiver) {
    this.receiver_ = receiver;
  }
  FileSystemAccessFileHandlePtr.prototype.getPermissionStatus = function() {
    return FileSystemAccessFileHandleProxy.prototype.getPermissionStatus
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessFileHandleProxy.prototype.getPermissionStatus = function(mode) {
    var params_ = new FileSystemAccessFileHandle_GetPermissionStatus_Params();
    params_.mode = mode;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFileSystemAccessFileHandle_GetPermissionStatus_Name,
          codec.align(FileSystemAccessFileHandle_GetPermissionStatus_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FileSystemAccessFileHandle_GetPermissionStatus_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FileSystemAccessFileHandle_GetPermissionStatus_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FileSystemAccessFileHandlePtr.prototype.requestPermission = function() {
    return FileSystemAccessFileHandleProxy.prototype.requestPermission
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessFileHandleProxy.prototype.requestPermission = function(mode) {
    var params_ = new FileSystemAccessFileHandle_RequestPermission_Params();
    params_.mode = mode;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFileSystemAccessFileHandle_RequestPermission_Name,
          codec.align(FileSystemAccessFileHandle_RequestPermission_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FileSystemAccessFileHandle_RequestPermission_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FileSystemAccessFileHandle_RequestPermission_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FileSystemAccessFileHandlePtr.prototype.asBlob = function() {
    return FileSystemAccessFileHandleProxy.prototype.asBlob
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessFileHandleProxy.prototype.asBlob = function() {
    var params_ = new FileSystemAccessFileHandle_AsBlob_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFileSystemAccessFileHandle_AsBlob_Name,
          codec.align(FileSystemAccessFileHandle_AsBlob_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FileSystemAccessFileHandle_AsBlob_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FileSystemAccessFileHandle_AsBlob_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FileSystemAccessFileHandlePtr.prototype.createFileWriter = function() {
    return FileSystemAccessFileHandleProxy.prototype.createFileWriter
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessFileHandleProxy.prototype.createFileWriter = function(keepExistingData, autoClose, mode) {
    var params_ = new FileSystemAccessFileHandle_CreateFileWriter_Params();
    params_.keepExistingData = keepExistingData;
    params_.autoClose = autoClose;
    params_.mode = mode;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFileSystemAccessFileHandle_CreateFileWriter_Name,
          codec.align(FileSystemAccessFileHandle_CreateFileWriter_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FileSystemAccessFileHandle_CreateFileWriter_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FileSystemAccessFileHandle_CreateFileWriter_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FileSystemAccessFileHandlePtr.prototype.rename = function() {
    return FileSystemAccessFileHandleProxy.prototype.rename
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessFileHandleProxy.prototype.rename = function(newEntryName) {
    var params_ = new FileSystemAccessFileHandle_Rename_Params();
    params_.newEntryName = newEntryName;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFileSystemAccessFileHandle_Rename_Name,
          codec.align(FileSystemAccessFileHandle_Rename_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FileSystemAccessFileHandle_Rename_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FileSystemAccessFileHandle_Rename_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FileSystemAccessFileHandlePtr.prototype.move = function() {
    return FileSystemAccessFileHandleProxy.prototype.move
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessFileHandleProxy.prototype.move = function(destinationDirectory, newEntryName) {
    var params_ = new FileSystemAccessFileHandle_Move_Params();
    params_.destinationDirectory = destinationDirectory;
    params_.newEntryName = newEntryName;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFileSystemAccessFileHandle_Move_Name,
          codec.align(FileSystemAccessFileHandle_Move_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FileSystemAccessFileHandle_Move_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FileSystemAccessFileHandle_Move_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FileSystemAccessFileHandlePtr.prototype.remove = function() {
    return FileSystemAccessFileHandleProxy.prototype.remove
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessFileHandleProxy.prototype.remove = function() {
    var params_ = new FileSystemAccessFileHandle_Remove_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFileSystemAccessFileHandle_Remove_Name,
          codec.align(FileSystemAccessFileHandle_Remove_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FileSystemAccessFileHandle_Remove_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FileSystemAccessFileHandle_Remove_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FileSystemAccessFileHandlePtr.prototype.openAccessHandle = function() {
    return FileSystemAccessFileHandleProxy.prototype.openAccessHandle
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessFileHandleProxy.prototype.openAccessHandle = function(mode) {
    var params_ = new FileSystemAccessFileHandle_OpenAccessHandle_Params();
    params_.mode = mode;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFileSystemAccessFileHandle_OpenAccessHandle_Name,
          codec.align(FileSystemAccessFileHandle_OpenAccessHandle_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FileSystemAccessFileHandle_OpenAccessHandle_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FileSystemAccessFileHandle_OpenAccessHandle_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FileSystemAccessFileHandlePtr.prototype.isSameEntry = function() {
    return FileSystemAccessFileHandleProxy.prototype.isSameEntry
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessFileHandleProxy.prototype.isSameEntry = function(other) {
    var params_ = new FileSystemAccessFileHandle_IsSameEntry_Params();
    params_.other = other;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFileSystemAccessFileHandle_IsSameEntry_Name,
          codec.align(FileSystemAccessFileHandle_IsSameEntry_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FileSystemAccessFileHandle_IsSameEntry_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FileSystemAccessFileHandle_IsSameEntry_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FileSystemAccessFileHandlePtr.prototype.transfer = function() {
    return FileSystemAccessFileHandleProxy.prototype.transfer
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessFileHandleProxy.prototype.transfer = function(token) {
    var params_ = new FileSystemAccessFileHandle_Transfer_Params();
    params_.token = token;
    var builder = new codec.MessageV0Builder(
        kFileSystemAccessFileHandle_Transfer_Name,
        codec.align(FileSystemAccessFileHandle_Transfer_Params.encodedSize));
    builder.encodeStruct(FileSystemAccessFileHandle_Transfer_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FileSystemAccessFileHandlePtr.prototype.getUniqueId = function() {
    return FileSystemAccessFileHandleProxy.prototype.getUniqueId
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessFileHandleProxy.prototype.getUniqueId = function() {
    var params_ = new FileSystemAccessFileHandle_GetUniqueId_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFileSystemAccessFileHandle_GetUniqueId_Name,
          codec.align(FileSystemAccessFileHandle_GetUniqueId_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FileSystemAccessFileHandle_GetUniqueId_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FileSystemAccessFileHandle_GetUniqueId_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FileSystemAccessFileHandlePtr.prototype.getCloudIdentifiers = function() {
    return FileSystemAccessFileHandleProxy.prototype.getCloudIdentifiers
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessFileHandleProxy.prototype.getCloudIdentifiers = function() {
    var params_ = new FileSystemAccessFileHandle_GetCloudIdentifiers_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFileSystemAccessFileHandle_GetCloudIdentifiers_Name,
          codec.align(FileSystemAccessFileHandle_GetCloudIdentifiers_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FileSystemAccessFileHandle_GetCloudIdentifiers_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function FileSystemAccessFileHandleStub(delegate) {
    this.delegate_ = delegate;
  }
  FileSystemAccessFileHandleStub.prototype.getPermissionStatus = function(mode) {
    return this.delegate_ && this.delegate_.getPermissionStatus && this.delegate_.getPermissionStatus(mode);
  }
  FileSystemAccessFileHandleStub.prototype.requestPermission = function(mode) {
    return this.delegate_ && this.delegate_.requestPermission && this.delegate_.requestPermission(mode);
  }
  FileSystemAccessFileHandleStub.prototype.asBlob = function() {
    return this.delegate_ && this.delegate_.asBlob && this.delegate_.asBlob();
  }
  FileSystemAccessFileHandleStub.prototype.createFileWriter = function(keepExistingData, autoClose, mode) {
    return this.delegate_ && this.delegate_.createFileWriter && this.delegate_.createFileWriter(keepExistingData, autoClose, mode);
  }
  FileSystemAccessFileHandleStub.prototype.rename = function(newEntryName) {
    return this.delegate_ && this.delegate_.rename && this.delegate_.rename(newEntryName);
  }
  FileSystemAccessFileHandleStub.prototype.move = function(destinationDirectory, newEntryName) {
    return this.delegate_ && this.delegate_.move && this.delegate_.move(destinationDirectory, newEntryName);
  }
  FileSystemAccessFileHandleStub.prototype.remove = function() {
    return this.delegate_ && this.delegate_.remove && this.delegate_.remove();
  }
  FileSystemAccessFileHandleStub.prototype.openAccessHandle = function(mode) {
    return this.delegate_ && this.delegate_.openAccessHandle && this.delegate_.openAccessHandle(mode);
  }
  FileSystemAccessFileHandleStub.prototype.isSameEntry = function(other) {
    return this.delegate_ && this.delegate_.isSameEntry && this.delegate_.isSameEntry(other);
  }
  FileSystemAccessFileHandleStub.prototype.transfer = function(token) {
    return this.delegate_ && this.delegate_.transfer && this.delegate_.transfer(token);
  }
  FileSystemAccessFileHandleStub.prototype.getUniqueId = function() {
    return this.delegate_ && this.delegate_.getUniqueId && this.delegate_.getUniqueId();
  }
  FileSystemAccessFileHandleStub.prototype.getCloudIdentifiers = function() {
    return this.delegate_ && this.delegate_.getCloudIdentifiers && this.delegate_.getCloudIdentifiers();
  }

  FileSystemAccessFileHandleStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFileSystemAccessFileHandle_Transfer_Name:
      var params = reader.decodeStruct(FileSystemAccessFileHandle_Transfer_Params);
      this.transfer(params.token);
      return true;
    default:
      return false;
    }
  };

  FileSystemAccessFileHandleStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFileSystemAccessFileHandle_GetPermissionStatus_Name:
      var params = reader.decodeStruct(FileSystemAccessFileHandle_GetPermissionStatus_Params);
      this.getPermissionStatus(params.mode).then(function(response) {
        var responseParams =
            new FileSystemAccessFileHandle_GetPermissionStatus_ResponseParams();
        responseParams.status = response.status;
        var builder = new codec.MessageV1Builder(
            kFileSystemAccessFileHandle_GetPermissionStatus_Name,
            codec.align(FileSystemAccessFileHandle_GetPermissionStatus_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FileSystemAccessFileHandle_GetPermissionStatus_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFileSystemAccessFileHandle_RequestPermission_Name:
      var params = reader.decodeStruct(FileSystemAccessFileHandle_RequestPermission_Params);
      this.requestPermission(params.mode).then(function(response) {
        var responseParams =
            new FileSystemAccessFileHandle_RequestPermission_ResponseParams();
        responseParams.result = response.result;
        responseParams.status = response.status;
        var builder = new codec.MessageV1Builder(
            kFileSystemAccessFileHandle_RequestPermission_Name,
            codec.align(FileSystemAccessFileHandle_RequestPermission_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FileSystemAccessFileHandle_RequestPermission_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFileSystemAccessFileHandle_AsBlob_Name:
      var params = reader.decodeStruct(FileSystemAccessFileHandle_AsBlob_Params);
      this.asBlob().then(function(response) {
        var responseParams =
            new FileSystemAccessFileHandle_AsBlob_ResponseParams();
        responseParams.result = response.result;
        responseParams.info = response.info;
        responseParams.blob = response.blob;
        var builder = new codec.MessageV1Builder(
            kFileSystemAccessFileHandle_AsBlob_Name,
            codec.align(FileSystemAccessFileHandle_AsBlob_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FileSystemAccessFileHandle_AsBlob_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFileSystemAccessFileHandle_CreateFileWriter_Name:
      var params = reader.decodeStruct(FileSystemAccessFileHandle_CreateFileWriter_Params);
      this.createFileWriter(params.keepExistingData, params.autoClose, params.mode).then(function(response) {
        var responseParams =
            new FileSystemAccessFileHandle_CreateFileWriter_ResponseParams();
        responseParams.result = response.result;
        responseParams.writer = response.writer;
        var builder = new codec.MessageV1Builder(
            kFileSystemAccessFileHandle_CreateFileWriter_Name,
            codec.align(FileSystemAccessFileHandle_CreateFileWriter_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FileSystemAccessFileHandle_CreateFileWriter_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFileSystemAccessFileHandle_Rename_Name:
      var params = reader.decodeStruct(FileSystemAccessFileHandle_Rename_Params);
      this.rename(params.newEntryName).then(function(response) {
        var responseParams =
            new FileSystemAccessFileHandle_Rename_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kFileSystemAccessFileHandle_Rename_Name,
            codec.align(FileSystemAccessFileHandle_Rename_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FileSystemAccessFileHandle_Rename_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFileSystemAccessFileHandle_Move_Name:
      var params = reader.decodeStruct(FileSystemAccessFileHandle_Move_Params);
      this.move(params.destinationDirectory, params.newEntryName).then(function(response) {
        var responseParams =
            new FileSystemAccessFileHandle_Move_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kFileSystemAccessFileHandle_Move_Name,
            codec.align(FileSystemAccessFileHandle_Move_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FileSystemAccessFileHandle_Move_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFileSystemAccessFileHandle_Remove_Name:
      var params = reader.decodeStruct(FileSystemAccessFileHandle_Remove_Params);
      this.remove().then(function(response) {
        var responseParams =
            new FileSystemAccessFileHandle_Remove_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kFileSystemAccessFileHandle_Remove_Name,
            codec.align(FileSystemAccessFileHandle_Remove_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FileSystemAccessFileHandle_Remove_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFileSystemAccessFileHandle_OpenAccessHandle_Name:
      var params = reader.decodeStruct(FileSystemAccessFileHandle_OpenAccessHandle_Params);
      this.openAccessHandle(params.mode).then(function(response) {
        var responseParams =
            new FileSystemAccessFileHandle_OpenAccessHandle_ResponseParams();
        responseParams.result = response.result;
        responseParams.file = response.file;
        responseParams.accessHandleHost = response.accessHandleHost;
        var builder = new codec.MessageV1Builder(
            kFileSystemAccessFileHandle_OpenAccessHandle_Name,
            codec.align(FileSystemAccessFileHandle_OpenAccessHandle_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FileSystemAccessFileHandle_OpenAccessHandle_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFileSystemAccessFileHandle_IsSameEntry_Name:
      var params = reader.decodeStruct(FileSystemAccessFileHandle_IsSameEntry_Params);
      this.isSameEntry(params.other).then(function(response) {
        var responseParams =
            new FileSystemAccessFileHandle_IsSameEntry_ResponseParams();
        responseParams.result = response.result;
        responseParams.isSame = response.isSame;
        var builder = new codec.MessageV1Builder(
            kFileSystemAccessFileHandle_IsSameEntry_Name,
            codec.align(FileSystemAccessFileHandle_IsSameEntry_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FileSystemAccessFileHandle_IsSameEntry_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFileSystemAccessFileHandle_GetUniqueId_Name:
      var params = reader.decodeStruct(FileSystemAccessFileHandle_GetUniqueId_Params);
      this.getUniqueId().then(function(response) {
        var responseParams =
            new FileSystemAccessFileHandle_GetUniqueId_ResponseParams();
        responseParams.result = response.result;
        responseParams.id = response.id;
        var builder = new codec.MessageV1Builder(
            kFileSystemAccessFileHandle_GetUniqueId_Name,
            codec.align(FileSystemAccessFileHandle_GetUniqueId_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FileSystemAccessFileHandle_GetUniqueId_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFileSystemAccessFileHandle_GetCloudIdentifiers_Name:
      var params = reader.decodeStruct(FileSystemAccessFileHandle_GetCloudIdentifiers_Params);
      this.getCloudIdentifiers().then(function(response) {
        var responseParams =
            new FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParams();
        responseParams.result = response.result;
        responseParams.cloudIdentifiers = response.cloudIdentifiers;
        var builder = new codec.MessageV1Builder(
            kFileSystemAccessFileHandle_GetCloudIdentifiers_Name,
            codec.align(FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateFileSystemAccessFileHandleRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kFileSystemAccessFileHandle_GetPermissionStatus_Name:
        if (message.expectsResponse())
          paramsClass = FileSystemAccessFileHandle_GetPermissionStatus_Params;
      break;
      case kFileSystemAccessFileHandle_RequestPermission_Name:
        if (message.expectsResponse())
          paramsClass = FileSystemAccessFileHandle_RequestPermission_Params;
      break;
      case kFileSystemAccessFileHandle_AsBlob_Name:
        if (message.expectsResponse())
          paramsClass = FileSystemAccessFileHandle_AsBlob_Params;
      break;
      case kFileSystemAccessFileHandle_CreateFileWriter_Name:
        if (message.expectsResponse())
          paramsClass = FileSystemAccessFileHandle_CreateFileWriter_Params;
      break;
      case kFileSystemAccessFileHandle_Rename_Name:
        if (message.expectsResponse())
          paramsClass = FileSystemAccessFileHandle_Rename_Params;
      break;
      case kFileSystemAccessFileHandle_Move_Name:
        if (message.expectsResponse())
          paramsClass = FileSystemAccessFileHandle_Move_Params;
      break;
      case kFileSystemAccessFileHandle_Remove_Name:
        if (message.expectsResponse())
          paramsClass = FileSystemAccessFileHandle_Remove_Params;
      break;
      case kFileSystemAccessFileHandle_OpenAccessHandle_Name:
        if (message.expectsResponse())
          paramsClass = FileSystemAccessFileHandle_OpenAccessHandle_Params;
      break;
      case kFileSystemAccessFileHandle_IsSameEntry_Name:
        if (message.expectsResponse())
          paramsClass = FileSystemAccessFileHandle_IsSameEntry_Params;
      break;
      case kFileSystemAccessFileHandle_Transfer_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FileSystemAccessFileHandle_Transfer_Params;
      break;
      case kFileSystemAccessFileHandle_GetUniqueId_Name:
        if (message.expectsResponse())
          paramsClass = FileSystemAccessFileHandle_GetUniqueId_Params;
      break;
      case kFileSystemAccessFileHandle_GetCloudIdentifiers_Name:
        if (message.expectsResponse())
          paramsClass = FileSystemAccessFileHandle_GetCloudIdentifiers_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateFileSystemAccessFileHandleResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kFileSystemAccessFileHandle_GetPermissionStatus_Name:
        if (message.isResponse())
          paramsClass = FileSystemAccessFileHandle_GetPermissionStatus_ResponseParams;
        break;
      case kFileSystemAccessFileHandle_RequestPermission_Name:
        if (message.isResponse())
          paramsClass = FileSystemAccessFileHandle_RequestPermission_ResponseParams;
        break;
      case kFileSystemAccessFileHandle_AsBlob_Name:
        if (message.isResponse())
          paramsClass = FileSystemAccessFileHandle_AsBlob_ResponseParams;
        break;
      case kFileSystemAccessFileHandle_CreateFileWriter_Name:
        if (message.isResponse())
          paramsClass = FileSystemAccessFileHandle_CreateFileWriter_ResponseParams;
        break;
      case kFileSystemAccessFileHandle_Rename_Name:
        if (message.isResponse())
          paramsClass = FileSystemAccessFileHandle_Rename_ResponseParams;
        break;
      case kFileSystemAccessFileHandle_Move_Name:
        if (message.isResponse())
          paramsClass = FileSystemAccessFileHandle_Move_ResponseParams;
        break;
      case kFileSystemAccessFileHandle_Remove_Name:
        if (message.isResponse())
          paramsClass = FileSystemAccessFileHandle_Remove_ResponseParams;
        break;
      case kFileSystemAccessFileHandle_OpenAccessHandle_Name:
        if (message.isResponse())
          paramsClass = FileSystemAccessFileHandle_OpenAccessHandle_ResponseParams;
        break;
      case kFileSystemAccessFileHandle_IsSameEntry_Name:
        if (message.isResponse())
          paramsClass = FileSystemAccessFileHandle_IsSameEntry_ResponseParams;
        break;
      case kFileSystemAccessFileHandle_GetUniqueId_Name:
        if (message.isResponse())
          paramsClass = FileSystemAccessFileHandle_GetUniqueId_ResponseParams;
        break;
      case kFileSystemAccessFileHandle_GetCloudIdentifiers_Name:
        if (message.isResponse())
          paramsClass = FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var FileSystemAccessFileHandle = {
    name: 'blink.mojom.FileSystemAccessFileHandle',
    kVersion: 0,
    ptrClass: FileSystemAccessFileHandlePtr,
    proxyClass: FileSystemAccessFileHandleProxy,
    stubClass: FileSystemAccessFileHandleStub,
    validateRequest: validateFileSystemAccessFileHandleRequest,
    validateResponse: validateFileSystemAccessFileHandleResponse,
  };
  FileSystemAccessFileHandleStub.prototype.validator = validateFileSystemAccessFileHandleRequest;
  FileSystemAccessFileHandleProxy.prototype.validator = validateFileSystemAccessFileHandleResponse;
  exports.FileSystemAccessAccessHandleLockMode = FileSystemAccessAccessHandleLockMode;
  exports.FileSystemAccessWritableFileStreamLockMode = FileSystemAccessWritableFileStreamLockMode;
  exports.FileSystemAccessRegularFile = FileSystemAccessRegularFile;
  exports.FileSystemAccessAccessHandleFile = FileSystemAccessAccessHandleFile;
  exports.FileSystemAccessFileHandle = FileSystemAccessFileHandle;
  exports.FileSystemAccessFileHandlePtr = FileSystemAccessFileHandlePtr;
  exports.FileSystemAccessFileHandleAssociatedPtr = FileSystemAccessFileHandleAssociatedPtr;
})();