// third_party/blink/public/mojom/fenced_frame/fenced_frame.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/fenced_frame/fenced_frame.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var string16$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/string16.mojom', '../../../../../mojo/public/mojom/base/string16.mojom.js');
  }
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var frame_policy$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/frame/frame_policy.mojom', '../frame/frame_policy.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }



  function FencedFrameOwnerHost_Navigate_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FencedFrameOwnerHost_Navigate_Params.prototype.initDefaults_ = function() {
    this.url = null;
    this.navigationStartTime = null;
    this.embedderSharedStorageContext = null;
  };
  FencedFrameOwnerHost_Navigate_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FencedFrameOwnerHost_Navigate_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FencedFrameOwnerHost_Navigate_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FencedFrameOwnerHost_Navigate_Params.navigationStartTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FencedFrameOwnerHost_Navigate_Params.embedderSharedStorageContext
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, string16$.String16, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FencedFrameOwnerHost_Navigate_Params.encodedSize = codec.kStructHeaderSize + 24;

  FencedFrameOwnerHost_Navigate_Params.decode = function(decoder) {
    var packed;
    var val = new FencedFrameOwnerHost_Navigate_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.navigationStartTime =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.embedderSharedStorageContext =
        decoder.decodeStructPointer(string16$.String16);
    return val;
  };

  FencedFrameOwnerHost_Navigate_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FencedFrameOwnerHost_Navigate_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStructPointer(time$.TimeTicks, val.navigationStartTime);
    encoder.encodeStructPointer(string16$.String16, val.embedderSharedStorageContext);
  };
  function FencedFrameOwnerHost_DidChangeFramePolicy_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FencedFrameOwnerHost_DidChangeFramePolicy_Params.prototype.initDefaults_ = function() {
    this.framePolicy = null;
  };
  FencedFrameOwnerHost_DidChangeFramePolicy_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FencedFrameOwnerHost_DidChangeFramePolicy_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FencedFrameOwnerHost_DidChangeFramePolicy_Params.framePolicy
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, frame_policy$.FramePolicy, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FencedFrameOwnerHost_DidChangeFramePolicy_Params.encodedSize = codec.kStructHeaderSize + 8;

  FencedFrameOwnerHost_DidChangeFramePolicy_Params.decode = function(decoder) {
    var packed;
    var val = new FencedFrameOwnerHost_DidChangeFramePolicy_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.framePolicy =
        decoder.decodeStructPointer(frame_policy$.FramePolicy);
    return val;
  };

  FencedFrameOwnerHost_DidChangeFramePolicy_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FencedFrameOwnerHost_DidChangeFramePolicy_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(frame_policy$.FramePolicy, val.framePolicy);
  };
  var kFencedFrameOwnerHost_Navigate_Name = 0;
  var kFencedFrameOwnerHost_DidChangeFramePolicy_Name = 1;

  function FencedFrameOwnerHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(FencedFrameOwnerHost,
                                                   handleOrPtrInfo);
  }

  function FencedFrameOwnerHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        FencedFrameOwnerHost, associatedInterfacePtrInfo);
  }

  FencedFrameOwnerHostAssociatedPtr.prototype =
      Object.create(FencedFrameOwnerHostPtr.prototype);
  FencedFrameOwnerHostAssociatedPtr.prototype.constructor =
      FencedFrameOwnerHostAssociatedPtr;

  function FencedFrameOwnerHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  FencedFrameOwnerHostPtr.prototype.navigate = function() {
    return FencedFrameOwnerHostProxy.prototype.navigate
        .apply(this.ptr.getProxy(), arguments);
  };

  FencedFrameOwnerHostProxy.prototype.navigate = function(url, navigationStartTime, embedderSharedStorageContext) {
    var params_ = new FencedFrameOwnerHost_Navigate_Params();
    params_.url = url;
    params_.navigationStartTime = navigationStartTime;
    params_.embedderSharedStorageContext = embedderSharedStorageContext;
    var builder = new codec.MessageV0Builder(
        kFencedFrameOwnerHost_Navigate_Name,
        codec.align(FencedFrameOwnerHost_Navigate_Params.encodedSize));
    builder.encodeStruct(FencedFrameOwnerHost_Navigate_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FencedFrameOwnerHostPtr.prototype.didChangeFramePolicy = function() {
    return FencedFrameOwnerHostProxy.prototype.didChangeFramePolicy
        .apply(this.ptr.getProxy(), arguments);
  };

  FencedFrameOwnerHostProxy.prototype.didChangeFramePolicy = function(framePolicy) {
    var params_ = new FencedFrameOwnerHost_DidChangeFramePolicy_Params();
    params_.framePolicy = framePolicy;
    var builder = new codec.MessageV0Builder(
        kFencedFrameOwnerHost_DidChangeFramePolicy_Name,
        codec.align(FencedFrameOwnerHost_DidChangeFramePolicy_Params.encodedSize));
    builder.encodeStruct(FencedFrameOwnerHost_DidChangeFramePolicy_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function FencedFrameOwnerHostStub(delegate) {
    this.delegate_ = delegate;
  }
  FencedFrameOwnerHostStub.prototype.navigate = function(url, navigationStartTime, embedderSharedStorageContext) {
    return this.delegate_ && this.delegate_.navigate && this.delegate_.navigate(url, navigationStartTime, embedderSharedStorageContext);
  }
  FencedFrameOwnerHostStub.prototype.didChangeFramePolicy = function(framePolicy) {
    return this.delegate_ && this.delegate_.didChangeFramePolicy && this.delegate_.didChangeFramePolicy(framePolicy);
  }

  FencedFrameOwnerHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFencedFrameOwnerHost_Navigate_Name:
      var params = reader.decodeStruct(FencedFrameOwnerHost_Navigate_Params);
      this.navigate(params.url, params.navigationStartTime, params.embedderSharedStorageContext);
      return true;
    case kFencedFrameOwnerHost_DidChangeFramePolicy_Name:
      var params = reader.decodeStruct(FencedFrameOwnerHost_DidChangeFramePolicy_Params);
      this.didChangeFramePolicy(params.framePolicy);
      return true;
    default:
      return false;
    }
  };

  FencedFrameOwnerHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateFencedFrameOwnerHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kFencedFrameOwnerHost_Navigate_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FencedFrameOwnerHost_Navigate_Params;
      break;
      case kFencedFrameOwnerHost_DidChangeFramePolicy_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FencedFrameOwnerHost_DidChangeFramePolicy_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateFencedFrameOwnerHostResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var FencedFrameOwnerHost = {
    name: 'blink.mojom.FencedFrameOwnerHost',
    kVersion: 0,
    ptrClass: FencedFrameOwnerHostPtr,
    proxyClass: FencedFrameOwnerHostProxy,
    stubClass: FencedFrameOwnerHostStub,
    validateRequest: validateFencedFrameOwnerHostRequest,
    validateResponse: null,
  };
  FencedFrameOwnerHostStub.prototype.validator = validateFencedFrameOwnerHostRequest;
  FencedFrameOwnerHostProxy.prototype.validator = null;
  exports.FencedFrameOwnerHost = FencedFrameOwnerHost;
  exports.FencedFrameOwnerHostPtr = FencedFrameOwnerHostPtr;
  exports.FencedFrameOwnerHostAssociatedPtr = FencedFrameOwnerHostAssociatedPtr;
})();