// third_party/blink/public/mojom/drag/drag.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/drag/drag.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/drag/drag.mojom-params-data.h"
#include "third_party/blink/public/mojom/drag/drag.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/drag/drag.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/drag/drag.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
AllowedDragOperations::AllowedDragOperations()
    : allow_copy(),
      allow_link(),
      allow_move() {}

AllowedDragOperations::AllowedDragOperations(
    bool allow_copy_in,
    bool allow_link_in,
    bool allow_move_in)
    : allow_copy(std::move(allow_copy_in)),
      allow_link(std::move(allow_link_in)),
      allow_move(std::move(allow_move_in)) {}

AllowedDragOperations::~AllowedDragOperations() = default;

void AllowedDragOperations::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_copy"), this->allow_copy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_link"), this->allow_link,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_move"), this->allow_move,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AllowedDragOperations::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DragItemString::DragItemString()
    : string_type(),
      string_data(),
      title(),
      base_url() {}

DragItemString::DragItemString(
    const ::blink::String& string_type_in,
    const ::blink::String& string_data_in,
    const ::blink::String& title_in,
    const std::optional<::blink::KURL>& base_url_in)
    : string_type(std::move(string_type_in)),
      string_data(std::move(string_data_in)),
      title(std::move(title_in)),
      base_url(std::move(base_url_in)) {}

DragItemString::~DragItemString() = default;

void DragItemString::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "string_type"), this->string_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "string_data"), this->string_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "base_url"), this->base_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::KURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DragItemString::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DragItemBinary::DragItemBinary()
    : data(),
      is_image_accessible(),
      source_url(),
      filename_extension(),
      content_disposition() {}

DragItemBinary::DragItemBinary(
    ::mojo_base::BigBuffer data_in,
    bool is_image_accessible_in,
    const ::blink::KURL& source_url_in,
    const ::base::FilePath& filename_extension_in,
    const ::blink::String& content_disposition_in)
    : data(std::move(data_in)),
      is_image_accessible(std::move(is_image_accessible_in)),
      source_url(std::move(source_url_in)),
      filename_extension(std::move(filename_extension_in)),
      content_disposition(std::move(content_disposition_in)) {}

DragItemBinary::~DragItemBinary() = default;

void DragItemBinary::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo_base::BigBuffer>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_image_accessible"), this->is_image_accessible,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_url"), this->source_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::KURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "filename_extension"), this->filename_extension,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::FilePath&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "content_disposition"), this->content_disposition,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DragItemBinary::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DragItemFileSystemFile::DragItemFileSystemFile()
    : url(),
      size(),
      file_system_id(),
      serialized_blob() {}

DragItemFileSystemFile::DragItemFileSystemFile(
    const ::blink::KURL& url_in,
    int64_t size_in,
    const ::blink::String& file_system_id_in,
    const ::scoped_refptr<::blink::BlobDataHandle>& serialized_blob_in)
    : url(std::move(url_in)),
      size(std::move(size_in)),
      file_system_id(std::move(file_system_id_in)),
      serialized_blob(std::move(serialized_blob_in)) {}

DragItemFileSystemFile::~DragItemFileSystemFile() = default;

void DragItemFileSystemFile::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::KURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size"), this->size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_system_id"), this->file_system_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "serialized_blob"), this->serialized_blob,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::scoped_refptr<::blink::BlobDataHandle>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DragItemFileSystemFile::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DragData::DragData()
    : items(),
      file_system_id(),
      force_default_action(),
      referrer_policy(::network::mojom::blink::ReferrerPolicy::kDefault) {}

DragData::DragData(
    ::blink::Vector<DragItemPtr> items_in,
    const ::blink::String& file_system_id_in,
    bool force_default_action_in,
    ::network::mojom::blink::ReferrerPolicy referrer_policy_in)
    : items(std::move(items_in)),
      file_system_id(std::move(file_system_id_in)),
      force_default_action(std::move(force_default_action_in)),
      referrer_policy(std::move(referrer_policy_in)) {}

DragData::~DragData() = default;

void DragData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "items"), this->items,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<DragItemPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_system_id"), this->file_system_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "force_default_action"), this->force_default_action,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "referrer_policy"), this->referrer_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::ReferrerPolicy>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DragData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DragEventSourceInfo::DragEventSourceInfo()
    : location(),
      source() {}

DragEventSourceInfo::DragEventSourceInfo(
    const ::gfx::Point& location_in,
    ::ui::mojom::blink::DragEventSource source_in)
    : location(std::move(location_in)),
      source(std::move(source_in)) {}

DragEventSourceInfo::~DragEventSourceInfo() = default;

void DragEventSourceInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "location"), this->location,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Point&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source"), this->source,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ui::mojom::blink::DragEventSource>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DragEventSourceInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DragItemPtr
DragItem::NewString(
    DragItemStringPtr value) {
  return DragItemPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kString)>,
      std::move(value));
}

DragItemPtr
DragItem::NewFile(
    ::blink::mojom::blink::DataTransferFilePtr value) {
  return DragItemPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFile)>,
      std::move(value));
}

DragItemPtr
DragItem::NewBinary(
    DragItemBinaryPtr value) {
  return DragItemPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kBinary)>,
      std::move(value));
}

DragItemPtr
DragItem::NewFileSystemFile(
    DragItemFileSystemFilePtr value) {
  return DragItemPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFileSystemFile)>,
      std::move(value));
}

DragItem::DragItem(
    std::in_place_index_t<static_cast<size_t>(Tag::kString)>,
    DragItemStringPtr value)
    : tag_(Tag::kString),
      data_(std::in_place_index<static_cast<size_t>(Tag::kString)>,
            std::move(value)) {}

DragItem::DragItem(
    std::in_place_index_t<static_cast<size_t>(Tag::kFile)>,
    ::blink::mojom::blink::DataTransferFilePtr value)
    : tag_(Tag::kFile),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFile)>,
            std::move(value)) {}

DragItem::DragItem(
    std::in_place_index_t<static_cast<size_t>(Tag::kBinary)>,
    DragItemBinaryPtr value)
    : tag_(Tag::kBinary),
      data_(std::in_place_index<static_cast<size_t>(Tag::kBinary)>,
            std::move(value)) {}

DragItem::DragItem(
    std::in_place_index_t<static_cast<size_t>(Tag::kFileSystemFile)>,
    DragItemFileSystemFilePtr value)
    : tag_(Tag::kFileSystemFile),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFileSystemFile)>,
            std::move(value)) {}
DragItem::~DragItem() {
  DestroyActive();
}

void DragItem::set_string(DragItemStringPtr string) {
  if (tag_ == Tag::kString) {
    data_.string = std::move(string);
  } else {
    DestroyActive();
    tag_ = Tag::kString;
    new (&data_.string) DragItemStringPtr(
        std::move(string));
  }
}

void DragItem::set_file(::blink::mojom::blink::DataTransferFilePtr file) {
  if (tag_ == Tag::kFile) {
    data_.file = std::move(file);
  } else {
    DestroyActive();
    tag_ = Tag::kFile;
    new (&data_.file) ::blink::mojom::blink::DataTransferFilePtr(
        std::move(file));
  }
}

void DragItem::set_binary(DragItemBinaryPtr binary) {
  if (tag_ == Tag::kBinary) {
    data_.binary = std::move(binary);
  } else {
    DestroyActive();
    tag_ = Tag::kBinary;
    new (&data_.binary) DragItemBinaryPtr(
        std::move(binary));
  }
}

void DragItem::set_file_system_file(DragItemFileSystemFilePtr file_system_file) {
  if (tag_ == Tag::kFileSystemFile) {
    data_.file_system_file = std::move(file_system_file);
  } else {
    DestroyActive();
    tag_ = Tag::kFileSystemFile;
    new (&data_.file_system_file) DragItemFileSystemFilePtr(
        std::move(file_system_file));
  }
}


DragItem::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kString)>,
    DragItemStringPtr value)
    : string(std::move(value)) {}

DragItem::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFile)>,
    ::blink::mojom::blink::DataTransferFilePtr value)
    : file(std::move(value)) {}

DragItem::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kBinary)>,
    DragItemBinaryPtr value)
    : binary(std::move(value)) {}

DragItem::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFileSystemFile)>,
    DragItemFileSystemFilePtr value)
    : file_system_file(std::move(value)) {}

void DragItem::DestroyActive() {
  switch (tag_) {

    case Tag::kString:
      std::destroy_at(&data_.string);
      break;
    case Tag::kFile:
      std::destroy_at(&data_.file);
      break;
    case Tag::kBinary:
      std::destroy_at(&data_.binary);
      break;
    case Tag::kFileSystemFile:
      std::destroy_at(&data_.file_system_file);
      break;
  }
}

bool DragItem::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::AllowedDragOperations::DataView, ::blink::mojom::blink::AllowedDragOperationsPtr>::Read(
    ::blink::mojom::blink::AllowedDragOperations::DataView input,
    ::blink::mojom::blink::AllowedDragOperationsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::AllowedDragOperationsPtr result(::blink::mojom::blink::AllowedDragOperations::New());
  
      if (success)
        result->allow_copy = input.allow_copy();
      if (success)
        result->allow_link = input.allow_link();
      if (success)
        result->allow_move = input.allow_move();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::DragItemString::DataView, ::blink::mojom::blink::DragItemStringPtr>::Read(
    ::blink::mojom::blink::DragItemString::DataView input,
    ::blink::mojom::blink::DragItemStringPtr* output) {
  bool success = true;
  ::blink::mojom::blink::DragItemStringPtr result(::blink::mojom::blink::DragItemString::New());
  
      if (success && !input.ReadStringType(&result->string_type))
        success = false;
      if (success && !input.ReadStringData(&result->string_data))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadBaseUrl(&result->base_url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::DragItemBinary::DataView, ::blink::mojom::blink::DragItemBinaryPtr>::Read(
    ::blink::mojom::blink::DragItemBinary::DataView input,
    ::blink::mojom::blink::DragItemBinaryPtr* output) {
  bool success = true;
  ::blink::mojom::blink::DragItemBinaryPtr result(::blink::mojom::blink::DragItemBinary::New());
  
      if (success && !input.ReadData(&result->data))
        success = false;
      if (success)
        result->is_image_accessible = input.is_image_accessible();
      if (success && !input.ReadSourceUrl(&result->source_url))
        success = false;
      if (success && !input.ReadFilenameExtension(&result->filename_extension))
        success = false;
      if (success && !input.ReadContentDisposition(&result->content_disposition))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::DragItemFileSystemFile::DataView, ::blink::mojom::blink::DragItemFileSystemFilePtr>::Read(
    ::blink::mojom::blink::DragItemFileSystemFile::DataView input,
    ::blink::mojom::blink::DragItemFileSystemFilePtr* output) {
  bool success = true;
  ::blink::mojom::blink::DragItemFileSystemFilePtr result(::blink::mojom::blink::DragItemFileSystemFile::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success)
        result->size = input.size();
      if (success && !input.ReadFileSystemId(&result->file_system_id))
        success = false;
      if (success && !input.ReadSerializedBlob(&result->serialized_blob))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::DragData::DataView, ::blink::mojom::blink::DragDataPtr>::Read(
    ::blink::mojom::blink::DragData::DataView input,
    ::blink::mojom::blink::DragDataPtr* output) {
  bool success = true;
  ::blink::mojom::blink::DragDataPtr result(::blink::mojom::blink::DragData::New());
  
      if (success && !input.ReadItems(&result->items))
        success = false;
      if (success && !input.ReadFileSystemId(&result->file_system_id))
        success = false;
      if (success)
        result->force_default_action = input.force_default_action();
      if (success && !input.ReadReferrerPolicy(&result->referrer_policy))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::DragEventSourceInfo::DataView, ::blink::mojom::blink::DragEventSourceInfoPtr>::Read(
    ::blink::mojom::blink::DragEventSourceInfo::DataView input,
    ::blink::mojom::blink::DragEventSourceInfoPtr* output) {
  bool success = true;
  ::blink::mojom::blink::DragEventSourceInfoPtr result(::blink::mojom::blink::DragEventSourceInfo::New());
  
      if (success && !input.ReadLocation(&result->location))
        success = false;
      if (success && !input.ReadSource(&result->source))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::blink::DragItem::DataView, ::blink::mojom::blink::DragItemPtr>::Read(
    ::blink::mojom::blink::DragItem::DataView input,
    ::blink::mojom::blink::DragItemPtr* output) {
  using UnionType = ::blink::mojom::blink::DragItem;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kString: {
      ::blink::mojom::blink::DragItemStringPtr result_string{};
      if (!input.ReadString(&result_string))
        return false;

      *output = UnionType::NewString(
          std::move(result_string));
      break;
    }
    case Tag::kFile: {
      ::blink::mojom::blink::DataTransferFilePtr result_file{};
      if (!input.ReadFile(&result_file))
        return false;

      *output = UnionType::NewFile(
          std::move(result_file));
      break;
    }
    case Tag::kBinary: {
      ::blink::mojom::blink::DragItemBinaryPtr result_binary{};
      if (!input.ReadBinary(&result_binary))
        return false;

      *output = UnionType::NewBinary(
          std::move(result_binary));
      break;
    }
    case Tag::kFileSystemFile: {
      ::blink::mojom::blink::DragItemFileSystemFilePtr result_file_system_file{};
      if (!input.ReadFileSystemFile(&result_file_system_file))
        return false;

      *output = UnionType::NewFileSystemFile(
          std::move(result_file_system_file));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {




}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif