// third_party/blink/public/mojom/dom_storage/dom_storage.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  StorageKey as blink_mojom_StorageKey,
  StorageKeySpec as blink_mojom_StorageKeySpec
} from '../storage_key/storage_key.mojom.m.js';

import {
  LocalFrameToken as blink_mojom_LocalFrameToken,
  LocalFrameTokenSpec as blink_mojom_LocalFrameTokenSpec
} from '../tokens/tokens.mojom.m.js';

import {
  SessionStorageNamespaceRemote as blink_mojom_SessionStorageNamespaceRemote,
  SessionStorageNamespacePendingReceiver as blink_mojom_SessionStorageNamespacePendingReceiver
} from './session_storage_namespace.mojom.m.js';

import {
  StorageAreaRemote as blink_mojom_StorageAreaRemote,
  StorageAreaPendingReceiver as blink_mojom_StorageAreaPendingReceiver
} from './storage_area.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class DomStorageProviderPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.DomStorageProvider', scope);
  }
}

/** @interface */
export class DomStorageProviderInterface {
  
  /**
   * @param { !DomStoragePendingReceiver } receiver
   * @param { !DomStorageClientRemote } client
   */

  bindDomStorage(receiver, client) {}
}

/**
 * @implements { DomStorageProviderInterface }
 */
export class DomStorageProviderRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!DomStorageProviderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          DomStorageProviderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!DomStorageProviderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !DomStoragePendingReceiver } receiver
   * @param { !DomStorageClientRemote } client
   */

  bindDomStorage(
      receiver,
      client) {
    this.proxy.sendMessage(
        0,
        DomStorageProvider_BindDomStorage_ParamsSpec.$,
        null,
        [
          receiver,
          client
        ],
        false);
  }
}

/**
 * An object which receives request messages for the DomStorageProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DomStorageProviderReceiver {
  /**
   * @param {!DomStorageProviderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!DomStorageProviderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        DomStorageProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DomStorageProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        DomStorageProvider_BindDomStorage_ParamsSpec.$,
        null,
        impl.bindDomStorage.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class DomStorageProvider {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.DomStorageProvider";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!DomStorageProviderRemote}
   */
  static getRemote() {
    let remote = new DomStorageProviderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the DomStorageProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DomStorageProviderCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      DomStorageProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DomStorageProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindDomStorage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        DomStorageProvider_BindDomStorage_ParamsSpec.$,
        null,
        this.bindDomStorage.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class DomStoragePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.DomStorage', scope);
  }
}

/** @interface */
export class DomStorageInterface {
  
  /**
   * @param { !blink_mojom_StorageKey } storageKey
   * @param { !blink_mojom_LocalFrameToken } localFrameToken
   * @param { !blink_mojom_StorageAreaPendingReceiver } area
   */

  openLocalStorage(storageKey, localFrameToken, area) {}
  
  /**
   * @param { !string } namespaceId
   * @param { !blink_mojom_SessionStorageNamespacePendingReceiver } receiver
   */

  bindSessionStorageNamespace(namespaceId, receiver) {}
  
  /**
   * @param { !blink_mojom_StorageKey } storageKey
   * @param { !blink_mojom_LocalFrameToken } localFrameToken
   * @param { !string } namespaceId
   * @param { !blink_mojom_StorageAreaPendingReceiver } sessionNamespace
   */

  bindSessionStorageArea(storageKey, localFrameToken, namespaceId, sessionNamespace) {}
}

/**
 * @implements { DomStorageInterface }
 */
export class DomStorageRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!DomStoragePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          DomStoragePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!DomStoragePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_StorageKey } storageKey
   * @param { !blink_mojom_LocalFrameToken } localFrameToken
   * @param { !blink_mojom_StorageAreaPendingReceiver } area
   */

  openLocalStorage(
      storageKey,
      localFrameToken,
      area) {
    this.proxy.sendMessage(
        0,
        DomStorage_OpenLocalStorage_ParamsSpec.$,
        null,
        [
          storageKey,
          localFrameToken,
          area
        ],
        false);
  }

  
  /**
   * @param { !string } namespaceId
   * @param { !blink_mojom_SessionStorageNamespacePendingReceiver } receiver
   */

  bindSessionStorageNamespace(
      namespaceId,
      receiver) {
    this.proxy.sendMessage(
        1,
        DomStorage_BindSessionStorageNamespace_ParamsSpec.$,
        null,
        [
          namespaceId,
          receiver
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_StorageKey } storageKey
   * @param { !blink_mojom_LocalFrameToken } localFrameToken
   * @param { !string } namespaceId
   * @param { !blink_mojom_StorageAreaPendingReceiver } sessionNamespace
   */

  bindSessionStorageArea(
      storageKey,
      localFrameToken,
      namespaceId,
      sessionNamespace) {
    this.proxy.sendMessage(
        2,
        DomStorage_BindSessionStorageArea_ParamsSpec.$,
        null,
        [
          storageKey,
          localFrameToken,
          namespaceId,
          sessionNamespace
        ],
        false);
  }
}

/**
 * An object which receives request messages for the DomStorage
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DomStorageReceiver {
  /**
   * @param {!DomStorageInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!DomStorageRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        DomStorageRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DomStorageRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        DomStorage_OpenLocalStorage_ParamsSpec.$,
        null,
        impl.openLocalStorage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        DomStorage_BindSessionStorageNamespace_ParamsSpec.$,
        null,
        impl.bindSessionStorageNamespace.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        DomStorage_BindSessionStorageArea_ParamsSpec.$,
        null,
        impl.bindSessionStorageArea.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class DomStorage {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.DomStorage";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!DomStorageRemote}
   */
  static getRemote() {
    let remote = new DomStorageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the DomStorage
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DomStorageCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      DomStorageRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DomStorageRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openLocalStorage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        DomStorage_OpenLocalStorage_ParamsSpec.$,
        null,
        this.openLocalStorage.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindSessionStorageNamespace =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        DomStorage_BindSessionStorageNamespace_ParamsSpec.$,
        null,
        this.bindSessionStorageNamespace.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindSessionStorageArea =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        DomStorage_BindSessionStorageArea_ParamsSpec.$,
        null,
        this.bindSessionStorageArea.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class DomStorageClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.DomStorageClient', scope);
  }
}

/** @interface */
export class DomStorageClientInterface {
  
  /**
   */

  resetSessionStorageConnections() {}
  
  /**
   */

  resetLocalStorageConnections() {}
}

/**
 * @implements { DomStorageClientInterface }
 */
export class DomStorageClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!DomStorageClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          DomStorageClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!DomStorageClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  resetSessionStorageConnections() {
    this.proxy.sendMessage(
        0,
        DomStorageClient_ResetSessionStorageConnections_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  resetLocalStorageConnections() {
    this.proxy.sendMessage(
        1,
        DomStorageClient_ResetLocalStorageConnections_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the DomStorageClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DomStorageClientReceiver {
  /**
   * @param {!DomStorageClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!DomStorageClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        DomStorageClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DomStorageClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        DomStorageClient_ResetSessionStorageConnections_ParamsSpec.$,
        null,
        impl.resetSessionStorageConnections.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        DomStorageClient_ResetLocalStorageConnections_ParamsSpec.$,
        null,
        impl.resetLocalStorageConnections.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class DomStorageClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.DomStorageClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!DomStorageClientRemote}
   */
  static getRemote() {
    let remote = new DomStorageClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the DomStorageClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DomStorageClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      DomStorageClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DomStorageClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resetSessionStorageConnections =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        DomStorageClient_ResetSessionStorageConnections_ParamsSpec.$,
        null,
        this.resetSessionStorageConnections.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resetLocalStorageConnections =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        DomStorageClient_ResetLocalStorageConnections_ParamsSpec.$,
        null,
        this.resetLocalStorageConnections.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DomStorageProvider_BindDomStorage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DomStorage_OpenLocalStorage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DomStorage_BindSessionStorageNamespace_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DomStorage_BindSessionStorageArea_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DomStorageClient_ResetSessionStorageConnections_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DomStorageClient_ResetLocalStorageConnections_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    DomStorageProvider_BindDomStorage_ParamsSpec.$,
    'DomStorageProvider_BindDomStorage_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(DomStoragePendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'client', 4,
        0,
        mojo.internal.InterfaceProxy(DomStorageClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class DomStorageProvider_BindDomStorage_Params {
  constructor() {
    /** @type { !DomStoragePendingReceiver } */
    this.receiver;
    /** @type { !DomStorageClientRemote } */
    this.client;
  }
}



mojo.internal.Struct(
    DomStorage_OpenLocalStorage_ParamsSpec.$,
    'DomStorage_OpenLocalStorage_Params',
    [
      mojo.internal.StructField(
        'storageKey', 0,
        0,
        blink_mojom_StorageKeySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'localFrameToken', 8,
        0,
        blink_mojom_LocalFrameTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'area', 16,
        0,
        mojo.internal.InterfaceRequest(blink_mojom_StorageAreaPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class DomStorage_OpenLocalStorage_Params {
  constructor() {
    /** @type { !blink_mojom_StorageKey } */
    this.storageKey;
    /** @type { !blink_mojom_LocalFrameToken } */
    this.localFrameToken;
    /** @type { !blink_mojom_StorageAreaPendingReceiver } */
    this.area;
  }
}



mojo.internal.Struct(
    DomStorage_BindSessionStorageNamespace_ParamsSpec.$,
    'DomStorage_BindSessionStorageNamespace_Params',
    [
      mojo.internal.StructField(
        'namespaceId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'receiver', 8,
        0,
        mojo.internal.InterfaceRequest(blink_mojom_SessionStorageNamespacePendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class DomStorage_BindSessionStorageNamespace_Params {
  constructor() {
    /** @type { !string } */
    this.namespaceId;
    /** @type { !blink_mojom_SessionStorageNamespacePendingReceiver } */
    this.receiver;
  }
}



mojo.internal.Struct(
    DomStorage_BindSessionStorageArea_ParamsSpec.$,
    'DomStorage_BindSessionStorageArea_Params',
    [
      mojo.internal.StructField(
        'storageKey', 0,
        0,
        blink_mojom_StorageKeySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'localFrameToken', 8,
        0,
        blink_mojom_LocalFrameTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'namespaceId', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sessionNamespace', 24,
        0,
        mojo.internal.InterfaceRequest(blink_mojom_StorageAreaPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class DomStorage_BindSessionStorageArea_Params {
  constructor() {
    /** @type { !blink_mojom_StorageKey } */
    this.storageKey;
    /** @type { !blink_mojom_LocalFrameToken } */
    this.localFrameToken;
    /** @type { !string } */
    this.namespaceId;
    /** @type { !blink_mojom_StorageAreaPendingReceiver } */
    this.sessionNamespace;
  }
}



mojo.internal.Struct(
    DomStorageClient_ResetSessionStorageConnections_ParamsSpec.$,
    'DomStorageClient_ResetSessionStorageConnections_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class DomStorageClient_ResetSessionStorageConnections_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    DomStorageClient_ResetLocalStorageConnections_ParamsSpec.$,
    'DomStorageClient_ResetLocalStorageConnections_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class DomStorageClient_ResetLocalStorageConnections_Params {
  constructor() {
  }
}

