// third_party/blink/public/mojom/digital_goods/digital_goods.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  BillingResponseCode as payments_mojom_BillingResponseCode,
  BillingResponseCodeSpec as payments_mojom_BillingResponseCodeSpec,
  CreateDigitalGoodsResponseCode as payments_mojom_CreateDigitalGoodsResponseCode,
  CreateDigitalGoodsResponseCodeSpec as payments_mojom_CreateDigitalGoodsResponseCodeSpec,
  ItemDetails as payments_mojom_ItemDetails,
  ItemDetailsSpec as payments_mojom_ItemDetailsSpec,
  PurchaseReference as payments_mojom_PurchaseReference,
  PurchaseReferenceSpec as payments_mojom_PurchaseReferenceSpec
} from '../../../../../components/digital_goods/mojom/digital_goods.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class DigitalGoodsPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'payments.mojom.DigitalGoods', scope);
  }
}

/** @interface */
export class DigitalGoodsInterface {
  
  /**
   * @param { !Array<!string> } itemIds
   * @return {!Promise<{
        code: !payments_mojom_BillingResponseCode,
        itemDetailsList: !Array<!payments_mojom_ItemDetails>,
   *  }>}
   */

  getDetails(itemIds) {}
  
  /**
   * @return {!Promise<{
        code: !payments_mojom_BillingResponseCode,
        purchaseReferenceList: !Array<!payments_mojom_PurchaseReference>,
   *  }>}
   */

  listPurchases() {}
  
  /**
   * @return {!Promise<{
        code: !payments_mojom_BillingResponseCode,
        purchaseReferenceList: !Array<!payments_mojom_PurchaseReference>,
   *  }>}
   */

  listPurchaseHistory() {}
  
  /**
   * @param { !string } purchaseToken
   * @return {!Promise<{
        code: !payments_mojom_BillingResponseCode,
   *  }>}
   */

  consume(purchaseToken) {}
}

/**
 * @implements { DigitalGoodsInterface }
 */
export class DigitalGoodsRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!DigitalGoodsPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          DigitalGoodsPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!DigitalGoodsPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!string> } itemIds
   * @return {!Promise<{
        code: !payments_mojom_BillingResponseCode,
        itemDetailsList: !Array<!payments_mojom_ItemDetails>,
   *  }>}
   */

  getDetails(
      itemIds) {
    return this.proxy.sendMessage(
        0,
        DigitalGoods_GetDetails_ParamsSpec.$,
        DigitalGoods_GetDetails_ResponseParamsSpec.$,
        [
          itemIds
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        code: !payments_mojom_BillingResponseCode,
        purchaseReferenceList: !Array<!payments_mojom_PurchaseReference>,
   *  }>}
   */

  listPurchases() {
    return this.proxy.sendMessage(
        1,
        DigitalGoods_ListPurchases_ParamsSpec.$,
        DigitalGoods_ListPurchases_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        code: !payments_mojom_BillingResponseCode,
        purchaseReferenceList: !Array<!payments_mojom_PurchaseReference>,
   *  }>}
   */

  listPurchaseHistory() {
    return this.proxy.sendMessage(
        2,
        DigitalGoods_ListPurchaseHistory_ParamsSpec.$,
        DigitalGoods_ListPurchaseHistory_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } purchaseToken
   * @return {!Promise<{
        code: !payments_mojom_BillingResponseCode,
   *  }>}
   */

  consume(
      purchaseToken) {
    return this.proxy.sendMessage(
        3,
        DigitalGoods_Consume_ParamsSpec.$,
        DigitalGoods_Consume_ResponseParamsSpec.$,
        [
          purchaseToken
        ],
        false);
  }
}

/**
 * An object which receives request messages for the DigitalGoods
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DigitalGoodsReceiver {
  /**
   * @param {!DigitalGoodsInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!DigitalGoodsRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        DigitalGoodsRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DigitalGoodsRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        DigitalGoods_GetDetails_ParamsSpec.$,
        DigitalGoods_GetDetails_ResponseParamsSpec.$,
        impl.getDetails.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        DigitalGoods_ListPurchases_ParamsSpec.$,
        DigitalGoods_ListPurchases_ResponseParamsSpec.$,
        impl.listPurchases.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        DigitalGoods_ListPurchaseHistory_ParamsSpec.$,
        DigitalGoods_ListPurchaseHistory_ResponseParamsSpec.$,
        impl.listPurchaseHistory.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        DigitalGoods_Consume_ParamsSpec.$,
        DigitalGoods_Consume_ResponseParamsSpec.$,
        impl.consume.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class DigitalGoods {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "payments.mojom.DigitalGoods";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!DigitalGoodsRemote}
   */
  static getRemote() {
    let remote = new DigitalGoodsRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the DigitalGoods
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DigitalGoodsCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      DigitalGoodsRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DigitalGoodsRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDetails =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        DigitalGoods_GetDetails_ParamsSpec.$,
        DigitalGoods_GetDetails_ResponseParamsSpec.$,
        this.getDetails.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.listPurchases =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        DigitalGoods_ListPurchases_ParamsSpec.$,
        DigitalGoods_ListPurchases_ResponseParamsSpec.$,
        this.listPurchases.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.listPurchaseHistory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        DigitalGoods_ListPurchaseHistory_ParamsSpec.$,
        DigitalGoods_ListPurchaseHistory_ResponseParamsSpec.$,
        this.listPurchaseHistory.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.consume =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        DigitalGoods_Consume_ParamsSpec.$,
        DigitalGoods_Consume_ResponseParamsSpec.$,
        this.consume.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class DigitalGoodsFactoryPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'payments.mojom.DigitalGoodsFactory', scope);
  }
}

/** @interface */
export class DigitalGoodsFactoryInterface {
  
  /**
   * @param { !string } paymentMethod
   * @return {!Promise<{
        code: !payments_mojom_CreateDigitalGoodsResponseCode,
        digitalGoods: ?DigitalGoodsRemote,
   *  }>}
   */

  createDigitalGoods(paymentMethod) {}
}

/**
 * @implements { DigitalGoodsFactoryInterface }
 */
export class DigitalGoodsFactoryRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!DigitalGoodsFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          DigitalGoodsFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!DigitalGoodsFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } paymentMethod
   * @return {!Promise<{
        code: !payments_mojom_CreateDigitalGoodsResponseCode,
        digitalGoods: ?DigitalGoodsRemote,
   *  }>}
   */

  createDigitalGoods(
      paymentMethod) {
    return this.proxy.sendMessage(
        0,
        DigitalGoodsFactory_CreateDigitalGoods_ParamsSpec.$,
        DigitalGoodsFactory_CreateDigitalGoods_ResponseParamsSpec.$,
        [
          paymentMethod
        ],
        false);
  }
}

/**
 * An object which receives request messages for the DigitalGoodsFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DigitalGoodsFactoryReceiver {
  /**
   * @param {!DigitalGoodsFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!DigitalGoodsFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        DigitalGoodsFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DigitalGoodsFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        DigitalGoodsFactory_CreateDigitalGoods_ParamsSpec.$,
        DigitalGoodsFactory_CreateDigitalGoods_ResponseParamsSpec.$,
        impl.createDigitalGoods.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class DigitalGoodsFactory {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "payments.mojom.DigitalGoodsFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!DigitalGoodsFactoryRemote}
   */
  static getRemote() {
    let remote = new DigitalGoodsFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the DigitalGoodsFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DigitalGoodsFactoryCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      DigitalGoodsFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DigitalGoodsFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createDigitalGoods =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        DigitalGoodsFactory_CreateDigitalGoods_ParamsSpec.$,
        DigitalGoodsFactory_CreateDigitalGoods_ResponseParamsSpec.$,
        this.createDigitalGoods.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DigitalGoods_GetDetails_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DigitalGoods_GetDetails_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DigitalGoods_ListPurchases_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DigitalGoods_ListPurchases_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DigitalGoods_ListPurchaseHistory_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DigitalGoods_ListPurchaseHistory_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DigitalGoods_Consume_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DigitalGoods_Consume_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DigitalGoodsFactory_CreateDigitalGoods_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DigitalGoodsFactory_CreateDigitalGoods_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    DigitalGoods_GetDetails_ParamsSpec.$,
    'DigitalGoods_GetDetails_Params',
    [
      mojo.internal.StructField(
        'itemIds', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DigitalGoods_GetDetails_Params {
  constructor() {
    /** @type { !Array<!string> } */
    this.itemIds;
  }
}



mojo.internal.Struct(
    DigitalGoods_GetDetails_ResponseParamsSpec.$,
    'DigitalGoods_GetDetails_ResponseParams',
    [
      mojo.internal.StructField(
        'code', 0,
        0,
        payments_mojom_BillingResponseCodeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'itemDetailsList', 8,
        0,
        mojo.internal.Array(payments_mojom_ItemDetailsSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class DigitalGoods_GetDetails_ResponseParams {
  constructor() {
    /** @type { !payments_mojom_BillingResponseCode } */
    this.code;
    /** @type { !Array<!payments_mojom_ItemDetails> } */
    this.itemDetailsList;
  }
}



mojo.internal.Struct(
    DigitalGoods_ListPurchases_ParamsSpec.$,
    'DigitalGoods_ListPurchases_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class DigitalGoods_ListPurchases_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    DigitalGoods_ListPurchases_ResponseParamsSpec.$,
    'DigitalGoods_ListPurchases_ResponseParams',
    [
      mojo.internal.StructField(
        'code', 0,
        0,
        payments_mojom_BillingResponseCodeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'purchaseReferenceList', 8,
        0,
        mojo.internal.Array(payments_mojom_PurchaseReferenceSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class DigitalGoods_ListPurchases_ResponseParams {
  constructor() {
    /** @type { !payments_mojom_BillingResponseCode } */
    this.code;
    /** @type { !Array<!payments_mojom_PurchaseReference> } */
    this.purchaseReferenceList;
  }
}



mojo.internal.Struct(
    DigitalGoods_ListPurchaseHistory_ParamsSpec.$,
    'DigitalGoods_ListPurchaseHistory_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class DigitalGoods_ListPurchaseHistory_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    DigitalGoods_ListPurchaseHistory_ResponseParamsSpec.$,
    'DigitalGoods_ListPurchaseHistory_ResponseParams',
    [
      mojo.internal.StructField(
        'code', 0,
        0,
        payments_mojom_BillingResponseCodeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'purchaseReferenceList', 8,
        0,
        mojo.internal.Array(payments_mojom_PurchaseReferenceSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class DigitalGoods_ListPurchaseHistory_ResponseParams {
  constructor() {
    /** @type { !payments_mojom_BillingResponseCode } */
    this.code;
    /** @type { !Array<!payments_mojom_PurchaseReference> } */
    this.purchaseReferenceList;
  }
}



mojo.internal.Struct(
    DigitalGoods_Consume_ParamsSpec.$,
    'DigitalGoods_Consume_Params',
    [
      mojo.internal.StructField(
        'purchaseToken', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DigitalGoods_Consume_Params {
  constructor() {
    /** @type { !string } */
    this.purchaseToken;
  }
}



mojo.internal.Struct(
    DigitalGoods_Consume_ResponseParamsSpec.$,
    'DigitalGoods_Consume_ResponseParams',
    [
      mojo.internal.StructField(
        'code', 0,
        0,
        payments_mojom_BillingResponseCodeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DigitalGoods_Consume_ResponseParams {
  constructor() {
    /** @type { !payments_mojom_BillingResponseCode } */
    this.code;
  }
}



mojo.internal.Struct(
    DigitalGoodsFactory_CreateDigitalGoods_ParamsSpec.$,
    'DigitalGoodsFactory_CreateDigitalGoods_Params',
    [
      mojo.internal.StructField(
        'paymentMethod', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DigitalGoodsFactory_CreateDigitalGoods_Params {
  constructor() {
    /** @type { !string } */
    this.paymentMethod;
  }
}



mojo.internal.Struct(
    DigitalGoodsFactory_CreateDigitalGoods_ResponseParamsSpec.$,
    'DigitalGoodsFactory_CreateDigitalGoods_ResponseParams',
    [
      mojo.internal.StructField(
        'code', 0,
        0,
        payments_mojom_CreateDigitalGoodsResponseCodeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'digitalGoods', 4,
        0,
        mojo.internal.InterfaceProxy(DigitalGoodsRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class DigitalGoodsFactory_CreateDigitalGoods_ResponseParams {
  constructor() {
    /** @type { !payments_mojom_CreateDigitalGoodsResponseCode } */
    this.code;
    /** @type { (DigitalGoodsRemote|undefined) } */
    this.digitalGoods;
  }
}

