// third_party/blink/public/mojom/devtools/inspector_issue.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_DEVTOOLS_INSPECTOR_ISSUE_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_DEVTOOLS_INSPECTOR_ISSUE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/devtools/inspector_issue.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/devtools/inspector_issue.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/devtools/inspector_issue.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/unguessable_token.mojom-blink.h"
#include "services/network/public/mojom/blocked_by_response_reason.mojom-blink-forward.h"
#include "services/network/public/mojom/cookie_manager.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-blink-forward.h"
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {





class PLATFORM_EXPORT AffectedCookie {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AffectedCookie, T>::value>;
  using DataView = AffectedCookieDataView;
  using Data_ = internal::AffectedCookie_Data;

  template <typename... Args>
  static AffectedCookiePtr New(Args&&... args) {
    return AffectedCookiePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AffectedCookiePtr From(const U& u) {
    return mojo::TypeConverter<AffectedCookiePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AffectedCookie>::Convert(*this);
  }


  AffectedCookie();

  AffectedCookie(
      const ::blink::String& name,
      const ::blink::String& path,
      const ::blink::String& domain);


  ~AffectedCookie();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AffectedCookiePtr>
  AffectedCookiePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AffectedCookie::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AffectedCookie::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AffectedCookie::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AffectedCookie::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AffectedCookie::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AffectedCookie::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AffectedCookie_UnserializedMessageContext<
            UserType, AffectedCookie::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AffectedCookie::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AffectedCookie::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AffectedCookie_UnserializedMessageContext<
            UserType, AffectedCookie::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AffectedCookie::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String name;
  
  ::blink::String path;
  
  ::blink::String domain;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AffectedCookie::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AffectedCookie::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AffectedCookie::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AffectedCookie::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AffectedRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AffectedRequest, T>::value>;
  using DataView = AffectedRequestDataView;
  using Data_ = internal::AffectedRequest_Data;

  template <typename... Args>
  static AffectedRequestPtr New(Args&&... args) {
    return AffectedRequestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AffectedRequestPtr From(const U& u) {
    return mojo::TypeConverter<AffectedRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AffectedRequest>::Convert(*this);
  }


  AffectedRequest();

  AffectedRequest(
      const ::blink::String& request_id,
      const ::blink::String& url);


  ~AffectedRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AffectedRequestPtr>
  AffectedRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AffectedRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AffectedRequest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AffectedRequest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AffectedRequest::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AffectedRequest::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AffectedRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AffectedRequest_UnserializedMessageContext<
            UserType, AffectedRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AffectedRequest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AffectedRequest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AffectedRequest_UnserializedMessageContext<
            UserType, AffectedRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AffectedRequest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String request_id;
  
  ::blink::String url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AffectedRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AffectedRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AffectedRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AffectedRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AffectedFrame {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AffectedFrame, T>::value>;
  using DataView = AffectedFrameDataView;
  using Data_ = internal::AffectedFrame_Data;

  template <typename... Args>
  static AffectedFramePtr New(Args&&... args) {
    return AffectedFramePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AffectedFramePtr From(const U& u) {
    return mojo::TypeConverter<AffectedFramePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AffectedFrame>::Convert(*this);
  }


  AffectedFrame();

  explicit AffectedFrame(
      const ::blink::String& frame_id);


  ~AffectedFrame();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AffectedFramePtr>
  AffectedFramePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AffectedFrame::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AffectedFrame::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AffectedFrame::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AffectedFrame::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AffectedFrame::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AffectedFrame::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AffectedFrame_UnserializedMessageContext<
            UserType, AffectedFrame::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AffectedFrame::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AffectedFrame::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AffectedFrame_UnserializedMessageContext<
            UserType, AffectedFrame::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AffectedFrame::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String frame_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AffectedFrame::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AffectedFrame::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AffectedFrame::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AffectedFrame::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AffectedLocation {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AffectedLocation, T>::value>;
  using DataView = AffectedLocationDataView;
  using Data_ = internal::AffectedLocation_Data;

  template <typename... Args>
  static AffectedLocationPtr New(Args&&... args) {
    return AffectedLocationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AffectedLocationPtr From(const U& u) {
    return mojo::TypeConverter<AffectedLocationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AffectedLocation>::Convert(*this);
  }


  AffectedLocation();

  AffectedLocation(
      const ::blink::String& script_id,
      const ::blink::String& url,
      uint32_t line,
      uint32_t column);


  ~AffectedLocation();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AffectedLocationPtr>
  AffectedLocationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AffectedLocation::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AffectedLocation::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AffectedLocation::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AffectedLocation::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AffectedLocation::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AffectedLocation::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AffectedLocation_UnserializedMessageContext<
            UserType, AffectedLocation::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AffectedLocation::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AffectedLocation::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AffectedLocation_UnserializedMessageContext<
            UserType, AffectedLocation::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AffectedLocation::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String script_id;
  
  ::blink::String url;
  
  uint32_t line;
  
  uint32_t column;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AffectedLocation::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AffectedLocation::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AffectedLocation::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AffectedLocation::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}













class PLATFORM_EXPORT FederatedAuthRequestIssueDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FederatedAuthRequestIssueDetails, T>::value>;
  using DataView = FederatedAuthRequestIssueDetailsDataView;
  using Data_ = internal::FederatedAuthRequestIssueDetails_Data;

  template <typename... Args>
  static FederatedAuthRequestIssueDetailsPtr New(Args&&... args) {
    return FederatedAuthRequestIssueDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FederatedAuthRequestIssueDetailsPtr From(const U& u) {
    return mojo::TypeConverter<FederatedAuthRequestIssueDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FederatedAuthRequestIssueDetails>::Convert(*this);
  }


  FederatedAuthRequestIssueDetails();

  explicit FederatedAuthRequestIssueDetails(
      FederatedAuthRequestResult status);


  ~FederatedAuthRequestIssueDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FederatedAuthRequestIssueDetailsPtr>
  FederatedAuthRequestIssueDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FederatedAuthRequestIssueDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FederatedAuthRequestIssueDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FederatedAuthRequestIssueDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FederatedAuthRequestIssueDetails::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FederatedAuthRequestIssueDetails::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FederatedAuthRequestIssueDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FederatedAuthRequestIssueDetails_UnserializedMessageContext<
            UserType, FederatedAuthRequestIssueDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FederatedAuthRequestIssueDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FederatedAuthRequestIssueDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FederatedAuthRequestIssueDetails_UnserializedMessageContext<
            UserType, FederatedAuthRequestIssueDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FederatedAuthRequestIssueDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  FederatedAuthRequestResult status;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FederatedAuthRequestIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FederatedAuthRequestIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FederatedAuthRequestIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FederatedAuthRequestIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT FederatedAuthUserInfoRequestIssueDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FederatedAuthUserInfoRequestIssueDetails, T>::value>;
  using DataView = FederatedAuthUserInfoRequestIssueDetailsDataView;
  using Data_ = internal::FederatedAuthUserInfoRequestIssueDetails_Data;

  template <typename... Args>
  static FederatedAuthUserInfoRequestIssueDetailsPtr New(Args&&... args) {
    return FederatedAuthUserInfoRequestIssueDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FederatedAuthUserInfoRequestIssueDetailsPtr From(const U& u) {
    return mojo::TypeConverter<FederatedAuthUserInfoRequestIssueDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FederatedAuthUserInfoRequestIssueDetails>::Convert(*this);
  }


  FederatedAuthUserInfoRequestIssueDetails();

  explicit FederatedAuthUserInfoRequestIssueDetails(
      FederatedAuthUserInfoRequestResult status);


  ~FederatedAuthUserInfoRequestIssueDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FederatedAuthUserInfoRequestIssueDetailsPtr>
  FederatedAuthUserInfoRequestIssueDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FederatedAuthUserInfoRequestIssueDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FederatedAuthUserInfoRequestIssueDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FederatedAuthUserInfoRequestIssueDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FederatedAuthUserInfoRequestIssueDetails::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FederatedAuthUserInfoRequestIssueDetails::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FederatedAuthUserInfoRequestIssueDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FederatedAuthUserInfoRequestIssueDetails_UnserializedMessageContext<
            UserType, FederatedAuthUserInfoRequestIssueDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FederatedAuthUserInfoRequestIssueDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FederatedAuthUserInfoRequestIssueDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FederatedAuthUserInfoRequestIssueDetails_UnserializedMessageContext<
            UserType, FederatedAuthUserInfoRequestIssueDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FederatedAuthUserInfoRequestIssueDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  FederatedAuthUserInfoRequestResult status;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FederatedAuthUserInfoRequestIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FederatedAuthUserInfoRequestIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FederatedAuthUserInfoRequestIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FederatedAuthUserInfoRequestIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class PLATFORM_EXPORT GenericIssueDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GenericIssueDetails, T>::value>;
  using DataView = GenericIssueDetailsDataView;
  using Data_ = internal::GenericIssueDetails_Data;

  template <typename... Args>
  static GenericIssueDetailsPtr New(Args&&... args) {
    return GenericIssueDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GenericIssueDetailsPtr From(const U& u) {
    return mojo::TypeConverter<GenericIssueDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GenericIssueDetails>::Convert(*this);
  }


  GenericIssueDetails();

  GenericIssueDetails(
      GenericIssueErrorType error_type,
      const ::blink::String& frame_id,
      int32_t violating_node_id,
      const ::blink::String& violating_node_attribute);


  ~GenericIssueDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GenericIssueDetailsPtr>
  GenericIssueDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GenericIssueDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GenericIssueDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GenericIssueDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GenericIssueDetails::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GenericIssueDetails::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GenericIssueDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GenericIssueDetails_UnserializedMessageContext<
            UserType, GenericIssueDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GenericIssueDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GenericIssueDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GenericIssueDetails_UnserializedMessageContext<
            UserType, GenericIssueDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GenericIssueDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  GenericIssueErrorType error_type;
  
  ::blink::String frame_id;
  
  int32_t violating_node_id;
  
  ::blink::String violating_node_attribute;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GenericIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GenericIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GenericIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GenericIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}















class PLATFORM_EXPORT BlockedByResponseIssueDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BlockedByResponseIssueDetails, T>::value>;
  using DataView = BlockedByResponseIssueDetailsDataView;
  using Data_ = internal::BlockedByResponseIssueDetails_Data;

  template <typename... Args>
  static BlockedByResponseIssueDetailsPtr New(Args&&... args) {
    return BlockedByResponseIssueDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BlockedByResponseIssueDetailsPtr From(const U& u) {
    return mojo::TypeConverter<BlockedByResponseIssueDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BlockedByResponseIssueDetails>::Convert(*this);
  }


  BlockedByResponseIssueDetails();

  BlockedByResponseIssueDetails(
      AffectedRequestPtr request,
      AffectedFramePtr parentFrame,
      AffectedFramePtr blockedFrame,
      ::network::mojom::blink::BlockedByResponseReason reason);

BlockedByResponseIssueDetails(const BlockedByResponseIssueDetails&) = delete;
BlockedByResponseIssueDetails& operator=(const BlockedByResponseIssueDetails&) = delete;

  ~BlockedByResponseIssueDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BlockedByResponseIssueDetailsPtr>
  BlockedByResponseIssueDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BlockedByResponseIssueDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BlockedByResponseIssueDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BlockedByResponseIssueDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BlockedByResponseIssueDetails::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BlockedByResponseIssueDetails::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BlockedByResponseIssueDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BlockedByResponseIssueDetails_UnserializedMessageContext<
            UserType, BlockedByResponseIssueDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BlockedByResponseIssueDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BlockedByResponseIssueDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BlockedByResponseIssueDetails_UnserializedMessageContext<
            UserType, BlockedByResponseIssueDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BlockedByResponseIssueDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  AffectedRequestPtr request;
  
  AffectedFramePtr parentFrame;
  
  AffectedFramePtr blockedFrame;
  
  ::network::mojom::blink::BlockedByResponseReason reason;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BlockedByResponseIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BlockedByResponseIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BlockedByResponseIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BlockedByResponseIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT HeavyAdIssueDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HeavyAdIssueDetails, T>::value>;
  using DataView = HeavyAdIssueDetailsDataView;
  using Data_ = internal::HeavyAdIssueDetails_Data;

  template <typename... Args>
  static HeavyAdIssueDetailsPtr New(Args&&... args) {
    return HeavyAdIssueDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HeavyAdIssueDetailsPtr From(const U& u) {
    return mojo::TypeConverter<HeavyAdIssueDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HeavyAdIssueDetails>::Convert(*this);
  }


  HeavyAdIssueDetails();

  HeavyAdIssueDetails(
      HeavyAdResolutionStatus resolution,
      HeavyAdReason reason,
      AffectedFramePtr frame);

HeavyAdIssueDetails(const HeavyAdIssueDetails&) = delete;
HeavyAdIssueDetails& operator=(const HeavyAdIssueDetails&) = delete;

  ~HeavyAdIssueDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HeavyAdIssueDetailsPtr>
  HeavyAdIssueDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HeavyAdIssueDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HeavyAdIssueDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HeavyAdIssueDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HeavyAdIssueDetails::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HeavyAdIssueDetails::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HeavyAdIssueDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HeavyAdIssueDetails_UnserializedMessageContext<
            UserType, HeavyAdIssueDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HeavyAdIssueDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HeavyAdIssueDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HeavyAdIssueDetails_UnserializedMessageContext<
            UserType, HeavyAdIssueDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HeavyAdIssueDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  HeavyAdResolutionStatus resolution;
  
  HeavyAdReason reason;
  
  AffectedFramePtr frame;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HeavyAdIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HeavyAdIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HeavyAdIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HeavyAdIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AttributionReportingIssueDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AttributionReportingIssueDetails, T>::value>;
  using DataView = AttributionReportingIssueDetailsDataView;
  using Data_ = internal::AttributionReportingIssueDetails_Data;

  template <typename... Args>
  static AttributionReportingIssueDetailsPtr New(Args&&... args) {
    return AttributionReportingIssueDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AttributionReportingIssueDetailsPtr From(const U& u) {
    return mojo::TypeConverter<AttributionReportingIssueDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AttributionReportingIssueDetails>::Convert(*this);
  }


  AttributionReportingIssueDetails();

  AttributionReportingIssueDetails(
      AttributionReportingIssueType violation_type,
      AffectedRequestPtr request,
      const ::blink::String& invalid_parameter);

AttributionReportingIssueDetails(const AttributionReportingIssueDetails&) = delete;
AttributionReportingIssueDetails& operator=(const AttributionReportingIssueDetails&) = delete;

  ~AttributionReportingIssueDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AttributionReportingIssueDetailsPtr>
  AttributionReportingIssueDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AttributionReportingIssueDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AttributionReportingIssueDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AttributionReportingIssueDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AttributionReportingIssueDetails::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AttributionReportingIssueDetails::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AttributionReportingIssueDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AttributionReportingIssueDetails_UnserializedMessageContext<
            UserType, AttributionReportingIssueDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AttributionReportingIssueDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AttributionReportingIssueDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AttributionReportingIssueDetails_UnserializedMessageContext<
            UserType, AttributionReportingIssueDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AttributionReportingIssueDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  AttributionReportingIssueType violation_type;
  
  AffectedRequestPtr request;
  
  ::blink::String invalid_parameter;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AttributionReportingIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AttributionReportingIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AttributionReportingIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AttributionReportingIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT MixedContentIssueDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MixedContentIssueDetails, T>::value>;
  using DataView = MixedContentIssueDetailsDataView;
  using Data_ = internal::MixedContentIssueDetails_Data;

  template <typename... Args>
  static MixedContentIssueDetailsPtr New(Args&&... args) {
    return MixedContentIssueDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MixedContentIssueDetailsPtr From(const U& u) {
    return mojo::TypeConverter<MixedContentIssueDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MixedContentIssueDetails>::Convert(*this);
  }


  MixedContentIssueDetails();

  MixedContentIssueDetails(
      ::blink::mojom::blink::RequestContextType request_context,
      MixedContentResolutionStatus resolution_status,
      const ::blink::String& insecure_url,
      const ::blink::String& main_resource_url,
      AffectedRequestPtr request,
      AffectedFramePtr frame);

MixedContentIssueDetails(const MixedContentIssueDetails&) = delete;
MixedContentIssueDetails& operator=(const MixedContentIssueDetails&) = delete;

  ~MixedContentIssueDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MixedContentIssueDetailsPtr>
  MixedContentIssueDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MixedContentIssueDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MixedContentIssueDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MixedContentIssueDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MixedContentIssueDetails::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MixedContentIssueDetails::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MixedContentIssueDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MixedContentIssueDetails_UnserializedMessageContext<
            UserType, MixedContentIssueDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MixedContentIssueDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MixedContentIssueDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MixedContentIssueDetails_UnserializedMessageContext<
            UserType, MixedContentIssueDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MixedContentIssueDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::mojom::blink::RequestContextType request_context;
  
  MixedContentResolutionStatus resolution_status;
  
  ::blink::String insecure_url;
  
  ::blink::String main_resource_url;
  
  AffectedRequestPtr request;
  
  AffectedFramePtr frame;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MixedContentIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MixedContentIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MixedContentIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MixedContentIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT ContentSecurityPolicyIssueDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ContentSecurityPolicyIssueDetails, T>::value>;
  using DataView = ContentSecurityPolicyIssueDetailsDataView;
  using Data_ = internal::ContentSecurityPolicyIssueDetails_Data;

  template <typename... Args>
  static ContentSecurityPolicyIssueDetailsPtr New(Args&&... args) {
    return ContentSecurityPolicyIssueDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ContentSecurityPolicyIssueDetailsPtr From(const U& u) {
    return mojo::TypeConverter<ContentSecurityPolicyIssueDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ContentSecurityPolicyIssueDetails>::Convert(*this);
  }


  ContentSecurityPolicyIssueDetails();

  ContentSecurityPolicyIssueDetails(
      const std::optional<::blink::KURL>& blocked_url,
      const ::blink::String& violated_directive,
      bool is_report_only,
      ContentSecurityPolicyViolationType content_security_policy_violation_type,
      AffectedFramePtr frame_ancestor,
      AffectedLocationPtr affected_location,
      int32_t violating_node_id);

ContentSecurityPolicyIssueDetails(const ContentSecurityPolicyIssueDetails&) = delete;
ContentSecurityPolicyIssueDetails& operator=(const ContentSecurityPolicyIssueDetails&) = delete;

  ~ContentSecurityPolicyIssueDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ContentSecurityPolicyIssueDetailsPtr>
  ContentSecurityPolicyIssueDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ContentSecurityPolicyIssueDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ContentSecurityPolicyIssueDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ContentSecurityPolicyIssueDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ContentSecurityPolicyIssueDetails::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ContentSecurityPolicyIssueDetails::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ContentSecurityPolicyIssueDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ContentSecurityPolicyIssueDetails_UnserializedMessageContext<
            UserType, ContentSecurityPolicyIssueDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ContentSecurityPolicyIssueDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ContentSecurityPolicyIssueDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ContentSecurityPolicyIssueDetails_UnserializedMessageContext<
            UserType, ContentSecurityPolicyIssueDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ContentSecurityPolicyIssueDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::blink::KURL> blocked_url;
  
  ::blink::String violated_directive;
  
  bool is_report_only;
  
  ContentSecurityPolicyViolationType content_security_policy_violation_type;
  
  AffectedFramePtr frame_ancestor;
  
  AffectedLocationPtr affected_location;
  
  int32_t violating_node_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ContentSecurityPolicyIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ContentSecurityPolicyIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ContentSecurityPolicyIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ContentSecurityPolicyIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT CookieIssueDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CookieIssueDetails, T>::value>;
  using DataView = CookieIssueDetailsDataView;
  using Data_ = internal::CookieIssueDetails_Data;

  template <typename... Args>
  static CookieIssueDetailsPtr New(Args&&... args) {
    return CookieIssueDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CookieIssueDetailsPtr From(const U& u) {
    return mojo::TypeConverter<CookieIssueDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CookieIssueDetails>::Convert(*this);
  }


  CookieIssueDetails();

  CookieIssueDetails(
      AffectedCookiePtr cookie,
      ::blink::Vector<CookieExclusionReason> exclusion_reason,
      ::blink::Vector<CookieWarningReason> warning_reason,
      CookieOperation operation,
      const std::optional<::blink::KURL>& site_for_cookies,
      const std::optional<::blink::KURL>& cookie_url,
      AffectedRequestPtr request);

CookieIssueDetails(const CookieIssueDetails&) = delete;
CookieIssueDetails& operator=(const CookieIssueDetails&) = delete;

  ~CookieIssueDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CookieIssueDetailsPtr>
  CookieIssueDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CookieIssueDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CookieIssueDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CookieIssueDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieIssueDetails::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieIssueDetails::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CookieIssueDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CookieIssueDetails_UnserializedMessageContext<
            UserType, CookieIssueDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CookieIssueDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CookieIssueDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CookieIssueDetails_UnserializedMessageContext<
            UserType, CookieIssueDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CookieIssueDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  AffectedCookiePtr cookie;
  
  ::blink::Vector<CookieExclusionReason> exclusion_reason;
  
  ::blink::Vector<CookieWarningReason> warning_reason;
  
  CookieOperation operation;
  
  std::optional<::blink::KURL> site_for_cookies;
  
  std::optional<::blink::KURL> cookie_url;
  
  AffectedRequestPtr request;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CookieIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CookieIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CookieIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CookieIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT SharedArrayBufferIssueDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SharedArrayBufferIssueDetails, T>::value>;
  using DataView = SharedArrayBufferIssueDetailsDataView;
  using Data_ = internal::SharedArrayBufferIssueDetails_Data;

  template <typename... Args>
  static SharedArrayBufferIssueDetailsPtr New(Args&&... args) {
    return SharedArrayBufferIssueDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SharedArrayBufferIssueDetailsPtr From(const U& u) {
    return mojo::TypeConverter<SharedArrayBufferIssueDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SharedArrayBufferIssueDetails>::Convert(*this);
  }


  SharedArrayBufferIssueDetails();

  SharedArrayBufferIssueDetails(
      AffectedLocationPtr affected_location,
      bool is_warning,
      SharedArrayBufferIssueType type);

SharedArrayBufferIssueDetails(const SharedArrayBufferIssueDetails&) = delete;
SharedArrayBufferIssueDetails& operator=(const SharedArrayBufferIssueDetails&) = delete;

  ~SharedArrayBufferIssueDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SharedArrayBufferIssueDetailsPtr>
  SharedArrayBufferIssueDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SharedArrayBufferIssueDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SharedArrayBufferIssueDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SharedArrayBufferIssueDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedArrayBufferIssueDetails::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedArrayBufferIssueDetails::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SharedArrayBufferIssueDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SharedArrayBufferIssueDetails_UnserializedMessageContext<
            UserType, SharedArrayBufferIssueDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SharedArrayBufferIssueDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SharedArrayBufferIssueDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SharedArrayBufferIssueDetails_UnserializedMessageContext<
            UserType, SharedArrayBufferIssueDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SharedArrayBufferIssueDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  AffectedLocationPtr affected_location;
  
  bool is_warning;
  
  SharedArrayBufferIssueType type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SharedArrayBufferIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SharedArrayBufferIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SharedArrayBufferIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SharedArrayBufferIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT LowTextContrastIssue {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LowTextContrastIssue, T>::value>;
  using DataView = LowTextContrastIssueDataView;
  using Data_ = internal::LowTextContrastIssue_Data;

  template <typename... Args>
  static LowTextContrastIssuePtr New(Args&&... args) {
    return LowTextContrastIssuePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LowTextContrastIssuePtr From(const U& u) {
    return mojo::TypeConverter<LowTextContrastIssuePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LowTextContrastIssue>::Convert(*this);
  }


  LowTextContrastIssue();

  LowTextContrastIssue(
      int32_t violating_node_id,
      const ::blink::String& violating_node_selector,
      float contrast_ratio,
      float threshold_aa,
      float threshold_aaa,
      const ::blink::String& font_size,
      const ::blink::String& font_weight);


  ~LowTextContrastIssue();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LowTextContrastIssuePtr>
  LowTextContrastIssuePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LowTextContrastIssue::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LowTextContrastIssue::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LowTextContrastIssue::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LowTextContrastIssue::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LowTextContrastIssue::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LowTextContrastIssue::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LowTextContrastIssue_UnserializedMessageContext<
            UserType, LowTextContrastIssue::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LowTextContrastIssue::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LowTextContrastIssue::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LowTextContrastIssue_UnserializedMessageContext<
            UserType, LowTextContrastIssue::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LowTextContrastIssue::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t violating_node_id;
  
  ::blink::String violating_node_selector;
  
  float contrast_ratio;
  
  float threshold_aa;
  
  float threshold_aaa;
  
  ::blink::String font_size;
  
  ::blink::String font_weight;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LowTextContrastIssue::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LowTextContrastIssue::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LowTextContrastIssue::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LowTextContrastIssue::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class PLATFORM_EXPORT BounceTrackingIssueDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BounceTrackingIssueDetails, T>::value>;
  using DataView = BounceTrackingIssueDetailsDataView;
  using Data_ = internal::BounceTrackingIssueDetails_Data;

  template <typename... Args>
  static BounceTrackingIssueDetailsPtr New(Args&&... args) {
    return BounceTrackingIssueDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BounceTrackingIssueDetailsPtr From(const U& u) {
    return mojo::TypeConverter<BounceTrackingIssueDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BounceTrackingIssueDetails>::Convert(*this);
  }


  BounceTrackingIssueDetails();

  explicit BounceTrackingIssueDetails(
      ::blink::Vector<::blink::String> tracking_sites);


  ~BounceTrackingIssueDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BounceTrackingIssueDetailsPtr>
  BounceTrackingIssueDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BounceTrackingIssueDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BounceTrackingIssueDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BounceTrackingIssueDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BounceTrackingIssueDetails::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BounceTrackingIssueDetails::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BounceTrackingIssueDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BounceTrackingIssueDetails_UnserializedMessageContext<
            UserType, BounceTrackingIssueDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BounceTrackingIssueDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BounceTrackingIssueDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BounceTrackingIssueDetails_UnserializedMessageContext<
            UserType, BounceTrackingIssueDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BounceTrackingIssueDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<::blink::String> tracking_sites;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BounceTrackingIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BounceTrackingIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BounceTrackingIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BounceTrackingIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT PartitioningBlobURLIssueDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PartitioningBlobURLIssueDetails, T>::value>;
  using DataView = PartitioningBlobURLIssueDetailsDataView;
  using Data_ = internal::PartitioningBlobURLIssueDetails_Data;

  template <typename... Args>
  static PartitioningBlobURLIssueDetailsPtr New(Args&&... args) {
    return PartitioningBlobURLIssueDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PartitioningBlobURLIssueDetailsPtr From(const U& u) {
    return mojo::TypeConverter<PartitioningBlobURLIssueDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PartitioningBlobURLIssueDetails>::Convert(*this);
  }


  PartitioningBlobURLIssueDetails();

  PartitioningBlobURLIssueDetails(
      const ::blink::KURL& url,
      PartitioningBlobURLInfo partitioning_blob_url_info);


  ~PartitioningBlobURLIssueDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PartitioningBlobURLIssueDetailsPtr>
  PartitioningBlobURLIssueDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PartitioningBlobURLIssueDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PartitioningBlobURLIssueDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PartitioningBlobURLIssueDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PartitioningBlobURLIssueDetails::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PartitioningBlobURLIssueDetails::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PartitioningBlobURLIssueDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PartitioningBlobURLIssueDetails_UnserializedMessageContext<
            UserType, PartitioningBlobURLIssueDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PartitioningBlobURLIssueDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PartitioningBlobURLIssueDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PartitioningBlobURLIssueDetails_UnserializedMessageContext<
            UserType, PartitioningBlobURLIssueDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PartitioningBlobURLIssueDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::KURL url;
  
  PartitioningBlobURLInfo partitioning_blob_url_info;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PartitioningBlobURLIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PartitioningBlobURLIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PartitioningBlobURLIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PartitioningBlobURLIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT CookieDeprecationMetadataIssueDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CookieDeprecationMetadataIssueDetails, T>::value>;
  using DataView = CookieDeprecationMetadataIssueDetailsDataView;
  using Data_ = internal::CookieDeprecationMetadataIssueDetails_Data;

  template <typename... Args>
  static CookieDeprecationMetadataIssueDetailsPtr New(Args&&... args) {
    return CookieDeprecationMetadataIssueDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CookieDeprecationMetadataIssueDetailsPtr From(const U& u) {
    return mojo::TypeConverter<CookieDeprecationMetadataIssueDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CookieDeprecationMetadataIssueDetails>::Convert(*this);
  }


  CookieDeprecationMetadataIssueDetails();

  CookieDeprecationMetadataIssueDetails(
      ::blink::Vector<::blink::String> allowed_sites,
      uint32_t opt_out_percentage,
      bool is_opt_out_top_level,
      CookieOperation operation);


  ~CookieDeprecationMetadataIssueDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CookieDeprecationMetadataIssueDetailsPtr>
  CookieDeprecationMetadataIssueDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CookieDeprecationMetadataIssueDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CookieDeprecationMetadataIssueDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CookieDeprecationMetadataIssueDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieDeprecationMetadataIssueDetails::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieDeprecationMetadataIssueDetails::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CookieDeprecationMetadataIssueDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CookieDeprecationMetadataIssueDetails_UnserializedMessageContext<
            UserType, CookieDeprecationMetadataIssueDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CookieDeprecationMetadataIssueDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CookieDeprecationMetadataIssueDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CookieDeprecationMetadataIssueDetails_UnserializedMessageContext<
            UserType, CookieDeprecationMetadataIssueDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CookieDeprecationMetadataIssueDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<::blink::String> allowed_sites;
  
  uint32_t opt_out_percentage;
  
  bool is_opt_out_top_level;
  
  CookieOperation operation;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CookieDeprecationMetadataIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CookieDeprecationMetadataIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CookieDeprecationMetadataIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CookieDeprecationMetadataIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class PLATFORM_EXPORT DeprecationIssueDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DeprecationIssueDetails, T>::value>;
  using DataView = DeprecationIssueDetailsDataView;
  using Data_ = internal::DeprecationIssueDetails_Data;

  template <typename... Args>
  static DeprecationIssueDetailsPtr New(Args&&... args) {
    return DeprecationIssueDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DeprecationIssueDetailsPtr From(const U& u) {
    return mojo::TypeConverter<DeprecationIssueDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DeprecationIssueDetails>::Convert(*this);
  }


  DeprecationIssueDetails();

  DeprecationIssueDetails(
      DeprecationIssueType type,
      AffectedLocationPtr affected_location);

DeprecationIssueDetails(const DeprecationIssueDetails&) = delete;
DeprecationIssueDetails& operator=(const DeprecationIssueDetails&) = delete;

  ~DeprecationIssueDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DeprecationIssueDetailsPtr>
  DeprecationIssueDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DeprecationIssueDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DeprecationIssueDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DeprecationIssueDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DeprecationIssueDetails::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DeprecationIssueDetails::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DeprecationIssueDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DeprecationIssueDetails_UnserializedMessageContext<
            UserType, DeprecationIssueDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DeprecationIssueDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DeprecationIssueDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DeprecationIssueDetails_UnserializedMessageContext<
            UserType, DeprecationIssueDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DeprecationIssueDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  DeprecationIssueType type;
  
  AffectedLocationPtr affected_location;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DeprecationIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DeprecationIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DeprecationIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DeprecationIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT UserReidentificationIssueDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UserReidentificationIssueDetails, T>::value>;
  using DataView = UserReidentificationIssueDetailsDataView;
  using Data_ = internal::UserReidentificationIssueDetails_Data;

  template <typename... Args>
  static UserReidentificationIssueDetailsPtr New(Args&&... args) {
    return UserReidentificationIssueDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UserReidentificationIssueDetailsPtr From(const U& u) {
    return mojo::TypeConverter<UserReidentificationIssueDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UserReidentificationIssueDetails>::Convert(*this);
  }


  UserReidentificationIssueDetails();

  UserReidentificationIssueDetails(
      UserReidentificationIssueType type,
      AffectedRequestPtr request,
      AffectedLocationPtr sourceCodeLocation);

UserReidentificationIssueDetails(const UserReidentificationIssueDetails&) = delete;
UserReidentificationIssueDetails& operator=(const UserReidentificationIssueDetails&) = delete;

  ~UserReidentificationIssueDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UserReidentificationIssueDetailsPtr>
  UserReidentificationIssueDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UserReidentificationIssueDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UserReidentificationIssueDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UserReidentificationIssueDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UserReidentificationIssueDetails::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UserReidentificationIssueDetails::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UserReidentificationIssueDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UserReidentificationIssueDetails_UnserializedMessageContext<
            UserType, UserReidentificationIssueDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UserReidentificationIssueDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UserReidentificationIssueDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UserReidentificationIssueDetails_UnserializedMessageContext<
            UserType, UserReidentificationIssueDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UserReidentificationIssueDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  UserReidentificationIssueType type;
  
  AffectedRequestPtr request;
  
  AffectedLocationPtr sourceCodeLocation;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UserReidentificationIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UserReidentificationIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UserReidentificationIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UserReidentificationIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT InspectorIssueDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<InspectorIssueDetails, T>::value>;
  using DataView = InspectorIssueDetailsDataView;
  using Data_ = internal::InspectorIssueDetails_Data;

  template <typename... Args>
  static InspectorIssueDetailsPtr New(Args&&... args) {
    return InspectorIssueDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static InspectorIssueDetailsPtr From(const U& u) {
    return mojo::TypeConverter<InspectorIssueDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, InspectorIssueDetails>::Convert(*this);
  }


  InspectorIssueDetails();

  InspectorIssueDetails(
      CookieIssueDetailsPtr cookie_issue_details,
      MixedContentIssueDetailsPtr mixed_content_issue_details,
      BlockedByResponseIssueDetailsPtr blocked_by_response_issue_details,
      ContentSecurityPolicyIssueDetailsPtr csp_issue_details,
      SharedArrayBufferIssueDetailsPtr sab_issue_details,
      HeavyAdIssueDetailsPtr heavy_ad_issue_details,
      AttributionReportingIssueDetailsPtr attribution_reporting_issue_details,
      LowTextContrastIssuePtr low_text_contrast_details,
      FederatedAuthRequestIssueDetailsPtr federated_auth_request_details,
      BounceTrackingIssueDetailsPtr bounce_tracking_issue_details,
      PartitioningBlobURLIssueDetailsPtr partitioning_blob_url_issue_details,
      CookieDeprecationMetadataIssueDetailsPtr cookie_deprecation_metadata_issue_details,
      GenericIssueDetailsPtr generic_issue_details,
      DeprecationIssueDetailsPtr deprecation_issue_details,
      FederatedAuthUserInfoRequestIssueDetailsPtr federated_auth_user_info_request_details,
      UserReidentificationIssueDetailsPtr user_reidentification_issue_details,
      const std::optional<::base::UnguessableToken>& issue_id);

InspectorIssueDetails(const InspectorIssueDetails&) = delete;
InspectorIssueDetails& operator=(const InspectorIssueDetails&) = delete;

  ~InspectorIssueDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = InspectorIssueDetailsPtr>
  InspectorIssueDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, InspectorIssueDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, InspectorIssueDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, InspectorIssueDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InspectorIssueDetails::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InspectorIssueDetails::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        InspectorIssueDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::InspectorIssueDetails_UnserializedMessageContext<
            UserType, InspectorIssueDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<InspectorIssueDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return InspectorIssueDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::InspectorIssueDetails_UnserializedMessageContext<
            UserType, InspectorIssueDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<InspectorIssueDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  CookieIssueDetailsPtr cookie_issue_details;
  
  MixedContentIssueDetailsPtr mixed_content_issue_details;
  
  BlockedByResponseIssueDetailsPtr blocked_by_response_issue_details;
  
  ContentSecurityPolicyIssueDetailsPtr csp_issue_details;
  
  SharedArrayBufferIssueDetailsPtr sab_issue_details;
  
  HeavyAdIssueDetailsPtr heavy_ad_issue_details;
  
  AttributionReportingIssueDetailsPtr attribution_reporting_issue_details;
  
  LowTextContrastIssuePtr low_text_contrast_details;
  
  FederatedAuthRequestIssueDetailsPtr federated_auth_request_details;
  
  BounceTrackingIssueDetailsPtr bounce_tracking_issue_details;
  
  PartitioningBlobURLIssueDetailsPtr partitioning_blob_url_issue_details;
  
  CookieDeprecationMetadataIssueDetailsPtr cookie_deprecation_metadata_issue_details;
  
  GenericIssueDetailsPtr generic_issue_details;
  
  DeprecationIssueDetailsPtr deprecation_issue_details;
  
  FederatedAuthUserInfoRequestIssueDetailsPtr federated_auth_user_info_request_details;
  
  UserReidentificationIssueDetailsPtr user_reidentification_issue_details;
  
  std::optional<::base::UnguessableToken> issue_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, InspectorIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, InspectorIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, InspectorIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, InspectorIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT InspectorIssueInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<InspectorIssueInfo, T>::value>;
  using DataView = InspectorIssueInfoDataView;
  using Data_ = internal::InspectorIssueInfo_Data;

  template <typename... Args>
  static InspectorIssueInfoPtr New(Args&&... args) {
    return InspectorIssueInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static InspectorIssueInfoPtr From(const U& u) {
    return mojo::TypeConverter<InspectorIssueInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, InspectorIssueInfo>::Convert(*this);
  }


  InspectorIssueInfo();

  InspectorIssueInfo(
      InspectorIssueCode code,
      InspectorIssueDetailsPtr details);

InspectorIssueInfo(const InspectorIssueInfo&) = delete;
InspectorIssueInfo& operator=(const InspectorIssueInfo&) = delete;

  ~InspectorIssueInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = InspectorIssueInfoPtr>
  InspectorIssueInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, InspectorIssueInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, InspectorIssueInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, InspectorIssueInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InspectorIssueInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InspectorIssueInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        InspectorIssueInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::InspectorIssueInfo_UnserializedMessageContext<
            UserType, InspectorIssueInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<InspectorIssueInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return InspectorIssueInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::InspectorIssueInfo_UnserializedMessageContext<
            UserType, InspectorIssueInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<InspectorIssueInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  InspectorIssueCode code;
  
  InspectorIssueDetailsPtr details;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, InspectorIssueInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, InspectorIssueInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, InspectorIssueInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, InspectorIssueInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AffectedCookiePtr AffectedCookie::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(path),
      mojo::Clone(domain)
  );
}

template <typename T, AffectedCookie::EnableIfSame<T>*>
bool AffectedCookie::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->path, other_struct.path))
    return false;
  if (!mojo::Equals(this->domain, other_struct.domain))
    return false;
  return true;
}

template <typename T, AffectedCookie::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.path < rhs.path)
    return true;
  if (rhs.path < lhs.path)
    return false;
  if (lhs.domain < rhs.domain)
    return true;
  if (rhs.domain < lhs.domain)
    return false;
  return false;
}
template <typename StructPtrType>
AffectedRequestPtr AffectedRequest::Clone() const {
  return New(
      mojo::Clone(request_id),
      mojo::Clone(url)
  );
}

template <typename T, AffectedRequest::EnableIfSame<T>*>
bool AffectedRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->request_id, other_struct.request_id))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  return true;
}

template <typename T, AffectedRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.request_id < rhs.request_id)
    return true;
  if (rhs.request_id < lhs.request_id)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  return false;
}
template <typename StructPtrType>
AffectedFramePtr AffectedFrame::Clone() const {
  return New(
      mojo::Clone(frame_id)
  );
}

template <typename T, AffectedFrame::EnableIfSame<T>*>
bool AffectedFrame::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->frame_id, other_struct.frame_id))
    return false;
  return true;
}

template <typename T, AffectedFrame::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.frame_id < rhs.frame_id)
    return true;
  if (rhs.frame_id < lhs.frame_id)
    return false;
  return false;
}
template <typename StructPtrType>
AffectedLocationPtr AffectedLocation::Clone() const {
  return New(
      mojo::Clone(script_id),
      mojo::Clone(url),
      mojo::Clone(line),
      mojo::Clone(column)
  );
}

template <typename T, AffectedLocation::EnableIfSame<T>*>
bool AffectedLocation::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->script_id, other_struct.script_id))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->line, other_struct.line))
    return false;
  if (!mojo::Equals(this->column, other_struct.column))
    return false;
  return true;
}

template <typename T, AffectedLocation::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.script_id < rhs.script_id)
    return true;
  if (rhs.script_id < lhs.script_id)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.line < rhs.line)
    return true;
  if (rhs.line < lhs.line)
    return false;
  if (lhs.column < rhs.column)
    return true;
  if (rhs.column < lhs.column)
    return false;
  return false;
}
template <typename StructPtrType>
BlockedByResponseIssueDetailsPtr BlockedByResponseIssueDetails::Clone() const {
  return New(
      mojo::Clone(request),
      mojo::Clone(parentFrame),
      mojo::Clone(blockedFrame),
      mojo::Clone(reason)
  );
}

template <typename T, BlockedByResponseIssueDetails::EnableIfSame<T>*>
bool BlockedByResponseIssueDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->request, other_struct.request))
    return false;
  if (!mojo::Equals(this->parentFrame, other_struct.parentFrame))
    return false;
  if (!mojo::Equals(this->blockedFrame, other_struct.blockedFrame))
    return false;
  if (!mojo::Equals(this->reason, other_struct.reason))
    return false;
  return true;
}

template <typename T, BlockedByResponseIssueDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.request < rhs.request)
    return true;
  if (rhs.request < lhs.request)
    return false;
  if (lhs.parentFrame < rhs.parentFrame)
    return true;
  if (rhs.parentFrame < lhs.parentFrame)
    return false;
  if (lhs.blockedFrame < rhs.blockedFrame)
    return true;
  if (rhs.blockedFrame < lhs.blockedFrame)
    return false;
  if (lhs.reason < rhs.reason)
    return true;
  if (rhs.reason < lhs.reason)
    return false;
  return false;
}
template <typename StructPtrType>
HeavyAdIssueDetailsPtr HeavyAdIssueDetails::Clone() const {
  return New(
      mojo::Clone(resolution),
      mojo::Clone(reason),
      mojo::Clone(frame)
  );
}

template <typename T, HeavyAdIssueDetails::EnableIfSame<T>*>
bool HeavyAdIssueDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->resolution, other_struct.resolution))
    return false;
  if (!mojo::Equals(this->reason, other_struct.reason))
    return false;
  if (!mojo::Equals(this->frame, other_struct.frame))
    return false;
  return true;
}

template <typename T, HeavyAdIssueDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.resolution < rhs.resolution)
    return true;
  if (rhs.resolution < lhs.resolution)
    return false;
  if (lhs.reason < rhs.reason)
    return true;
  if (rhs.reason < lhs.reason)
    return false;
  if (lhs.frame < rhs.frame)
    return true;
  if (rhs.frame < lhs.frame)
    return false;
  return false;
}
template <typename StructPtrType>
AttributionReportingIssueDetailsPtr AttributionReportingIssueDetails::Clone() const {
  return New(
      mojo::Clone(violation_type),
      mojo::Clone(request),
      mojo::Clone(invalid_parameter)
  );
}

template <typename T, AttributionReportingIssueDetails::EnableIfSame<T>*>
bool AttributionReportingIssueDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->violation_type, other_struct.violation_type))
    return false;
  if (!mojo::Equals(this->request, other_struct.request))
    return false;
  if (!mojo::Equals(this->invalid_parameter, other_struct.invalid_parameter))
    return false;
  return true;
}

template <typename T, AttributionReportingIssueDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.violation_type < rhs.violation_type)
    return true;
  if (rhs.violation_type < lhs.violation_type)
    return false;
  if (lhs.request < rhs.request)
    return true;
  if (rhs.request < lhs.request)
    return false;
  if (lhs.invalid_parameter < rhs.invalid_parameter)
    return true;
  if (rhs.invalid_parameter < lhs.invalid_parameter)
    return false;
  return false;
}
template <typename StructPtrType>
MixedContentIssueDetailsPtr MixedContentIssueDetails::Clone() const {
  return New(
      mojo::Clone(request_context),
      mojo::Clone(resolution_status),
      mojo::Clone(insecure_url),
      mojo::Clone(main_resource_url),
      mojo::Clone(request),
      mojo::Clone(frame)
  );
}

template <typename T, MixedContentIssueDetails::EnableIfSame<T>*>
bool MixedContentIssueDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->request_context, other_struct.request_context))
    return false;
  if (!mojo::Equals(this->resolution_status, other_struct.resolution_status))
    return false;
  if (!mojo::Equals(this->insecure_url, other_struct.insecure_url))
    return false;
  if (!mojo::Equals(this->main_resource_url, other_struct.main_resource_url))
    return false;
  if (!mojo::Equals(this->request, other_struct.request))
    return false;
  if (!mojo::Equals(this->frame, other_struct.frame))
    return false;
  return true;
}

template <typename T, MixedContentIssueDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.request_context < rhs.request_context)
    return true;
  if (rhs.request_context < lhs.request_context)
    return false;
  if (lhs.resolution_status < rhs.resolution_status)
    return true;
  if (rhs.resolution_status < lhs.resolution_status)
    return false;
  if (lhs.insecure_url < rhs.insecure_url)
    return true;
  if (rhs.insecure_url < lhs.insecure_url)
    return false;
  if (lhs.main_resource_url < rhs.main_resource_url)
    return true;
  if (rhs.main_resource_url < lhs.main_resource_url)
    return false;
  if (lhs.request < rhs.request)
    return true;
  if (rhs.request < lhs.request)
    return false;
  if (lhs.frame < rhs.frame)
    return true;
  if (rhs.frame < lhs.frame)
    return false;
  return false;
}
template <typename StructPtrType>
ContentSecurityPolicyIssueDetailsPtr ContentSecurityPolicyIssueDetails::Clone() const {
  return New(
      mojo::Clone(blocked_url),
      mojo::Clone(violated_directive),
      mojo::Clone(is_report_only),
      mojo::Clone(content_security_policy_violation_type),
      mojo::Clone(frame_ancestor),
      mojo::Clone(affected_location),
      mojo::Clone(violating_node_id)
  );
}

template <typename T, ContentSecurityPolicyIssueDetails::EnableIfSame<T>*>
bool ContentSecurityPolicyIssueDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->blocked_url, other_struct.blocked_url))
    return false;
  if (!mojo::Equals(this->violated_directive, other_struct.violated_directive))
    return false;
  if (!mojo::Equals(this->is_report_only, other_struct.is_report_only))
    return false;
  if (!mojo::Equals(this->content_security_policy_violation_type, other_struct.content_security_policy_violation_type))
    return false;
  if (!mojo::Equals(this->frame_ancestor, other_struct.frame_ancestor))
    return false;
  if (!mojo::Equals(this->affected_location, other_struct.affected_location))
    return false;
  if (!mojo::Equals(this->violating_node_id, other_struct.violating_node_id))
    return false;
  return true;
}

template <typename T, ContentSecurityPolicyIssueDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.blocked_url < rhs.blocked_url)
    return true;
  if (rhs.blocked_url < lhs.blocked_url)
    return false;
  if (lhs.violated_directive < rhs.violated_directive)
    return true;
  if (rhs.violated_directive < lhs.violated_directive)
    return false;
  if (lhs.is_report_only < rhs.is_report_only)
    return true;
  if (rhs.is_report_only < lhs.is_report_only)
    return false;
  if (lhs.content_security_policy_violation_type < rhs.content_security_policy_violation_type)
    return true;
  if (rhs.content_security_policy_violation_type < lhs.content_security_policy_violation_type)
    return false;
  if (lhs.frame_ancestor < rhs.frame_ancestor)
    return true;
  if (rhs.frame_ancestor < lhs.frame_ancestor)
    return false;
  if (lhs.affected_location < rhs.affected_location)
    return true;
  if (rhs.affected_location < lhs.affected_location)
    return false;
  if (lhs.violating_node_id < rhs.violating_node_id)
    return true;
  if (rhs.violating_node_id < lhs.violating_node_id)
    return false;
  return false;
}
template <typename StructPtrType>
CookieIssueDetailsPtr CookieIssueDetails::Clone() const {
  return New(
      mojo::Clone(cookie),
      mojo::Clone(exclusion_reason),
      mojo::Clone(warning_reason),
      mojo::Clone(operation),
      mojo::Clone(site_for_cookies),
      mojo::Clone(cookie_url),
      mojo::Clone(request)
  );
}

template <typename T, CookieIssueDetails::EnableIfSame<T>*>
bool CookieIssueDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->cookie, other_struct.cookie))
    return false;
  if (!mojo::Equals(this->exclusion_reason, other_struct.exclusion_reason))
    return false;
  if (!mojo::Equals(this->warning_reason, other_struct.warning_reason))
    return false;
  if (!mojo::Equals(this->operation, other_struct.operation))
    return false;
  if (!mojo::Equals(this->site_for_cookies, other_struct.site_for_cookies))
    return false;
  if (!mojo::Equals(this->cookie_url, other_struct.cookie_url))
    return false;
  if (!mojo::Equals(this->request, other_struct.request))
    return false;
  return true;
}

template <typename T, CookieIssueDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.cookie < rhs.cookie)
    return true;
  if (rhs.cookie < lhs.cookie)
    return false;
  if (lhs.exclusion_reason < rhs.exclusion_reason)
    return true;
  if (rhs.exclusion_reason < lhs.exclusion_reason)
    return false;
  if (lhs.warning_reason < rhs.warning_reason)
    return true;
  if (rhs.warning_reason < lhs.warning_reason)
    return false;
  if (lhs.operation < rhs.operation)
    return true;
  if (rhs.operation < lhs.operation)
    return false;
  if (lhs.site_for_cookies < rhs.site_for_cookies)
    return true;
  if (rhs.site_for_cookies < lhs.site_for_cookies)
    return false;
  if (lhs.cookie_url < rhs.cookie_url)
    return true;
  if (rhs.cookie_url < lhs.cookie_url)
    return false;
  if (lhs.request < rhs.request)
    return true;
  if (rhs.request < lhs.request)
    return false;
  return false;
}
template <typename StructPtrType>
SharedArrayBufferIssueDetailsPtr SharedArrayBufferIssueDetails::Clone() const {
  return New(
      mojo::Clone(affected_location),
      mojo::Clone(is_warning),
      mojo::Clone(type)
  );
}

template <typename T, SharedArrayBufferIssueDetails::EnableIfSame<T>*>
bool SharedArrayBufferIssueDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->affected_location, other_struct.affected_location))
    return false;
  if (!mojo::Equals(this->is_warning, other_struct.is_warning))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  return true;
}

template <typename T, SharedArrayBufferIssueDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.affected_location < rhs.affected_location)
    return true;
  if (rhs.affected_location < lhs.affected_location)
    return false;
  if (lhs.is_warning < rhs.is_warning)
    return true;
  if (rhs.is_warning < lhs.is_warning)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  return false;
}
template <typename StructPtrType>
LowTextContrastIssuePtr LowTextContrastIssue::Clone() const {
  return New(
      mojo::Clone(violating_node_id),
      mojo::Clone(violating_node_selector),
      mojo::Clone(contrast_ratio),
      mojo::Clone(threshold_aa),
      mojo::Clone(threshold_aaa),
      mojo::Clone(font_size),
      mojo::Clone(font_weight)
  );
}

template <typename T, LowTextContrastIssue::EnableIfSame<T>*>
bool LowTextContrastIssue::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->violating_node_id, other_struct.violating_node_id))
    return false;
  if (!mojo::Equals(this->violating_node_selector, other_struct.violating_node_selector))
    return false;
  if (!mojo::Equals(this->contrast_ratio, other_struct.contrast_ratio))
    return false;
  if (!mojo::Equals(this->threshold_aa, other_struct.threshold_aa))
    return false;
  if (!mojo::Equals(this->threshold_aaa, other_struct.threshold_aaa))
    return false;
  if (!mojo::Equals(this->font_size, other_struct.font_size))
    return false;
  if (!mojo::Equals(this->font_weight, other_struct.font_weight))
    return false;
  return true;
}

template <typename T, LowTextContrastIssue::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.violating_node_id < rhs.violating_node_id)
    return true;
  if (rhs.violating_node_id < lhs.violating_node_id)
    return false;
  if (lhs.violating_node_selector < rhs.violating_node_selector)
    return true;
  if (rhs.violating_node_selector < lhs.violating_node_selector)
    return false;
  if (lhs.contrast_ratio < rhs.contrast_ratio)
    return true;
  if (rhs.contrast_ratio < lhs.contrast_ratio)
    return false;
  if (lhs.threshold_aa < rhs.threshold_aa)
    return true;
  if (rhs.threshold_aa < lhs.threshold_aa)
    return false;
  if (lhs.threshold_aaa < rhs.threshold_aaa)
    return true;
  if (rhs.threshold_aaa < lhs.threshold_aaa)
    return false;
  if (lhs.font_size < rhs.font_size)
    return true;
  if (rhs.font_size < lhs.font_size)
    return false;
  if (lhs.font_weight < rhs.font_weight)
    return true;
  if (rhs.font_weight < lhs.font_weight)
    return false;
  return false;
}
template <typename StructPtrType>
FederatedAuthRequestIssueDetailsPtr FederatedAuthRequestIssueDetails::Clone() const {
  return New(
      mojo::Clone(status)
  );
}

template <typename T, FederatedAuthRequestIssueDetails::EnableIfSame<T>*>
bool FederatedAuthRequestIssueDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->status, other_struct.status))
    return false;
  return true;
}

template <typename T, FederatedAuthRequestIssueDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.status < rhs.status)
    return true;
  if (rhs.status < lhs.status)
    return false;
  return false;
}
template <typename StructPtrType>
FederatedAuthUserInfoRequestIssueDetailsPtr FederatedAuthUserInfoRequestIssueDetails::Clone() const {
  return New(
      mojo::Clone(status)
  );
}

template <typename T, FederatedAuthUserInfoRequestIssueDetails::EnableIfSame<T>*>
bool FederatedAuthUserInfoRequestIssueDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->status, other_struct.status))
    return false;
  return true;
}

template <typename T, FederatedAuthUserInfoRequestIssueDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.status < rhs.status)
    return true;
  if (rhs.status < lhs.status)
    return false;
  return false;
}
template <typename StructPtrType>
BounceTrackingIssueDetailsPtr BounceTrackingIssueDetails::Clone() const {
  return New(
      mojo::Clone(tracking_sites)
  );
}

template <typename T, BounceTrackingIssueDetails::EnableIfSame<T>*>
bool BounceTrackingIssueDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->tracking_sites, other_struct.tracking_sites))
    return false;
  return true;
}

template <typename T, BounceTrackingIssueDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.tracking_sites < rhs.tracking_sites)
    return true;
  if (rhs.tracking_sites < lhs.tracking_sites)
    return false;
  return false;
}
template <typename StructPtrType>
PartitioningBlobURLIssueDetailsPtr PartitioningBlobURLIssueDetails::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(partitioning_blob_url_info)
  );
}

template <typename T, PartitioningBlobURLIssueDetails::EnableIfSame<T>*>
bool PartitioningBlobURLIssueDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->partitioning_blob_url_info, other_struct.partitioning_blob_url_info))
    return false;
  return true;
}

template <typename T, PartitioningBlobURLIssueDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.partitioning_blob_url_info < rhs.partitioning_blob_url_info)
    return true;
  if (rhs.partitioning_blob_url_info < lhs.partitioning_blob_url_info)
    return false;
  return false;
}
template <typename StructPtrType>
CookieDeprecationMetadataIssueDetailsPtr CookieDeprecationMetadataIssueDetails::Clone() const {
  return New(
      mojo::Clone(allowed_sites),
      mojo::Clone(opt_out_percentage),
      mojo::Clone(is_opt_out_top_level),
      mojo::Clone(operation)
  );
}

template <typename T, CookieDeprecationMetadataIssueDetails::EnableIfSame<T>*>
bool CookieDeprecationMetadataIssueDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->allowed_sites, other_struct.allowed_sites))
    return false;
  if (!mojo::Equals(this->opt_out_percentage, other_struct.opt_out_percentage))
    return false;
  if (!mojo::Equals(this->is_opt_out_top_level, other_struct.is_opt_out_top_level))
    return false;
  if (!mojo::Equals(this->operation, other_struct.operation))
    return false;
  return true;
}

template <typename T, CookieDeprecationMetadataIssueDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.allowed_sites < rhs.allowed_sites)
    return true;
  if (rhs.allowed_sites < lhs.allowed_sites)
    return false;
  if (lhs.opt_out_percentage < rhs.opt_out_percentage)
    return true;
  if (rhs.opt_out_percentage < lhs.opt_out_percentage)
    return false;
  if (lhs.is_opt_out_top_level < rhs.is_opt_out_top_level)
    return true;
  if (rhs.is_opt_out_top_level < lhs.is_opt_out_top_level)
    return false;
  if (lhs.operation < rhs.operation)
    return true;
  if (rhs.operation < lhs.operation)
    return false;
  return false;
}
template <typename StructPtrType>
GenericIssueDetailsPtr GenericIssueDetails::Clone() const {
  return New(
      mojo::Clone(error_type),
      mojo::Clone(frame_id),
      mojo::Clone(violating_node_id),
      mojo::Clone(violating_node_attribute)
  );
}

template <typename T, GenericIssueDetails::EnableIfSame<T>*>
bool GenericIssueDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->error_type, other_struct.error_type))
    return false;
  if (!mojo::Equals(this->frame_id, other_struct.frame_id))
    return false;
  if (!mojo::Equals(this->violating_node_id, other_struct.violating_node_id))
    return false;
  if (!mojo::Equals(this->violating_node_attribute, other_struct.violating_node_attribute))
    return false;
  return true;
}

template <typename T, GenericIssueDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.error_type < rhs.error_type)
    return true;
  if (rhs.error_type < lhs.error_type)
    return false;
  if (lhs.frame_id < rhs.frame_id)
    return true;
  if (rhs.frame_id < lhs.frame_id)
    return false;
  if (lhs.violating_node_id < rhs.violating_node_id)
    return true;
  if (rhs.violating_node_id < lhs.violating_node_id)
    return false;
  if (lhs.violating_node_attribute < rhs.violating_node_attribute)
    return true;
  if (rhs.violating_node_attribute < lhs.violating_node_attribute)
    return false;
  return false;
}
template <typename StructPtrType>
DeprecationIssueDetailsPtr DeprecationIssueDetails::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(affected_location)
  );
}

template <typename T, DeprecationIssueDetails::EnableIfSame<T>*>
bool DeprecationIssueDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->affected_location, other_struct.affected_location))
    return false;
  return true;
}

template <typename T, DeprecationIssueDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.affected_location < rhs.affected_location)
    return true;
  if (rhs.affected_location < lhs.affected_location)
    return false;
  return false;
}
template <typename StructPtrType>
UserReidentificationIssueDetailsPtr UserReidentificationIssueDetails::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(request),
      mojo::Clone(sourceCodeLocation)
  );
}

template <typename T, UserReidentificationIssueDetails::EnableIfSame<T>*>
bool UserReidentificationIssueDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->request, other_struct.request))
    return false;
  if (!mojo::Equals(this->sourceCodeLocation, other_struct.sourceCodeLocation))
    return false;
  return true;
}

template <typename T, UserReidentificationIssueDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.request < rhs.request)
    return true;
  if (rhs.request < lhs.request)
    return false;
  if (lhs.sourceCodeLocation < rhs.sourceCodeLocation)
    return true;
  if (rhs.sourceCodeLocation < lhs.sourceCodeLocation)
    return false;
  return false;
}
template <typename StructPtrType>
InspectorIssueDetailsPtr InspectorIssueDetails::Clone() const {
  return New(
      mojo::Clone(cookie_issue_details),
      mojo::Clone(mixed_content_issue_details),
      mojo::Clone(blocked_by_response_issue_details),
      mojo::Clone(csp_issue_details),
      mojo::Clone(sab_issue_details),
      mojo::Clone(heavy_ad_issue_details),
      mojo::Clone(attribution_reporting_issue_details),
      mojo::Clone(low_text_contrast_details),
      mojo::Clone(federated_auth_request_details),
      mojo::Clone(bounce_tracking_issue_details),
      mojo::Clone(partitioning_blob_url_issue_details),
      mojo::Clone(cookie_deprecation_metadata_issue_details),
      mojo::Clone(generic_issue_details),
      mojo::Clone(deprecation_issue_details),
      mojo::Clone(federated_auth_user_info_request_details),
      mojo::Clone(user_reidentification_issue_details),
      mojo::Clone(issue_id)
  );
}

template <typename T, InspectorIssueDetails::EnableIfSame<T>*>
bool InspectorIssueDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->cookie_issue_details, other_struct.cookie_issue_details))
    return false;
  if (!mojo::Equals(this->mixed_content_issue_details, other_struct.mixed_content_issue_details))
    return false;
  if (!mojo::Equals(this->blocked_by_response_issue_details, other_struct.blocked_by_response_issue_details))
    return false;
  if (!mojo::Equals(this->csp_issue_details, other_struct.csp_issue_details))
    return false;
  if (!mojo::Equals(this->sab_issue_details, other_struct.sab_issue_details))
    return false;
  if (!mojo::Equals(this->heavy_ad_issue_details, other_struct.heavy_ad_issue_details))
    return false;
  if (!mojo::Equals(this->attribution_reporting_issue_details, other_struct.attribution_reporting_issue_details))
    return false;
  if (!mojo::Equals(this->low_text_contrast_details, other_struct.low_text_contrast_details))
    return false;
  if (!mojo::Equals(this->federated_auth_request_details, other_struct.federated_auth_request_details))
    return false;
  if (!mojo::Equals(this->bounce_tracking_issue_details, other_struct.bounce_tracking_issue_details))
    return false;
  if (!mojo::Equals(this->partitioning_blob_url_issue_details, other_struct.partitioning_blob_url_issue_details))
    return false;
  if (!mojo::Equals(this->cookie_deprecation_metadata_issue_details, other_struct.cookie_deprecation_metadata_issue_details))
    return false;
  if (!mojo::Equals(this->generic_issue_details, other_struct.generic_issue_details))
    return false;
  if (!mojo::Equals(this->deprecation_issue_details, other_struct.deprecation_issue_details))
    return false;
  if (!mojo::Equals(this->federated_auth_user_info_request_details, other_struct.federated_auth_user_info_request_details))
    return false;
  if (!mojo::Equals(this->user_reidentification_issue_details, other_struct.user_reidentification_issue_details))
    return false;
  if (!mojo::Equals(this->issue_id, other_struct.issue_id))
    return false;
  return true;
}

template <typename T, InspectorIssueDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.cookie_issue_details < rhs.cookie_issue_details)
    return true;
  if (rhs.cookie_issue_details < lhs.cookie_issue_details)
    return false;
  if (lhs.mixed_content_issue_details < rhs.mixed_content_issue_details)
    return true;
  if (rhs.mixed_content_issue_details < lhs.mixed_content_issue_details)
    return false;
  if (lhs.blocked_by_response_issue_details < rhs.blocked_by_response_issue_details)
    return true;
  if (rhs.blocked_by_response_issue_details < lhs.blocked_by_response_issue_details)
    return false;
  if (lhs.csp_issue_details < rhs.csp_issue_details)
    return true;
  if (rhs.csp_issue_details < lhs.csp_issue_details)
    return false;
  if (lhs.sab_issue_details < rhs.sab_issue_details)
    return true;
  if (rhs.sab_issue_details < lhs.sab_issue_details)
    return false;
  if (lhs.heavy_ad_issue_details < rhs.heavy_ad_issue_details)
    return true;
  if (rhs.heavy_ad_issue_details < lhs.heavy_ad_issue_details)
    return false;
  if (lhs.attribution_reporting_issue_details < rhs.attribution_reporting_issue_details)
    return true;
  if (rhs.attribution_reporting_issue_details < lhs.attribution_reporting_issue_details)
    return false;
  if (lhs.low_text_contrast_details < rhs.low_text_contrast_details)
    return true;
  if (rhs.low_text_contrast_details < lhs.low_text_contrast_details)
    return false;
  if (lhs.federated_auth_request_details < rhs.federated_auth_request_details)
    return true;
  if (rhs.federated_auth_request_details < lhs.federated_auth_request_details)
    return false;
  if (lhs.bounce_tracking_issue_details < rhs.bounce_tracking_issue_details)
    return true;
  if (rhs.bounce_tracking_issue_details < lhs.bounce_tracking_issue_details)
    return false;
  if (lhs.partitioning_blob_url_issue_details < rhs.partitioning_blob_url_issue_details)
    return true;
  if (rhs.partitioning_blob_url_issue_details < lhs.partitioning_blob_url_issue_details)
    return false;
  if (lhs.cookie_deprecation_metadata_issue_details < rhs.cookie_deprecation_metadata_issue_details)
    return true;
  if (rhs.cookie_deprecation_metadata_issue_details < lhs.cookie_deprecation_metadata_issue_details)
    return false;
  if (lhs.generic_issue_details < rhs.generic_issue_details)
    return true;
  if (rhs.generic_issue_details < lhs.generic_issue_details)
    return false;
  if (lhs.deprecation_issue_details < rhs.deprecation_issue_details)
    return true;
  if (rhs.deprecation_issue_details < lhs.deprecation_issue_details)
    return false;
  if (lhs.federated_auth_user_info_request_details < rhs.federated_auth_user_info_request_details)
    return true;
  if (rhs.federated_auth_user_info_request_details < lhs.federated_auth_user_info_request_details)
    return false;
  if (lhs.user_reidentification_issue_details < rhs.user_reidentification_issue_details)
    return true;
  if (rhs.user_reidentification_issue_details < lhs.user_reidentification_issue_details)
    return false;
  if (lhs.issue_id < rhs.issue_id)
    return true;
  if (rhs.issue_id < lhs.issue_id)
    return false;
  return false;
}
template <typename StructPtrType>
InspectorIssueInfoPtr InspectorIssueInfo::Clone() const {
  return New(
      mojo::Clone(code),
      mojo::Clone(details)
  );
}

template <typename T, InspectorIssueInfo::EnableIfSame<T>*>
bool InspectorIssueInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->code, other_struct.code))
    return false;
  if (!mojo::Equals(this->details, other_struct.details))
    return false;
  return true;
}

template <typename T, InspectorIssueInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.code < rhs.code)
    return true;
  if (rhs.code < lhs.code)
    return false;
  if (lhs.details < rhs.details)
    return true;
  if (rhs.details < lhs.details)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AffectedCookie::DataView,
                                         ::blink::mojom::blink::AffectedCookiePtr> {
  static bool IsNull(const ::blink::mojom::blink::AffectedCookiePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AffectedCookiePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AffectedCookie::name)& name(
      const ::blink::mojom::blink::AffectedCookiePtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::blink::AffectedCookie::path)& path(
      const ::blink::mojom::blink::AffectedCookiePtr& input) {
    return input->path;
  }

  static const decltype(::blink::mojom::blink::AffectedCookie::domain)& domain(
      const ::blink::mojom::blink::AffectedCookiePtr& input) {
    return input->domain;
  }

  static bool Read(::blink::mojom::blink::AffectedCookie::DataView input, ::blink::mojom::blink::AffectedCookiePtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AffectedRequest::DataView,
                                         ::blink::mojom::blink::AffectedRequestPtr> {
  static bool IsNull(const ::blink::mojom::blink::AffectedRequestPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AffectedRequestPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AffectedRequest::request_id)& request_id(
      const ::blink::mojom::blink::AffectedRequestPtr& input) {
    return input->request_id;
  }

  static const decltype(::blink::mojom::blink::AffectedRequest::url)& url(
      const ::blink::mojom::blink::AffectedRequestPtr& input) {
    return input->url;
  }

  static bool Read(::blink::mojom::blink::AffectedRequest::DataView input, ::blink::mojom::blink::AffectedRequestPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AffectedFrame::DataView,
                                         ::blink::mojom::blink::AffectedFramePtr> {
  static bool IsNull(const ::blink::mojom::blink::AffectedFramePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AffectedFramePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AffectedFrame::frame_id)& frame_id(
      const ::blink::mojom::blink::AffectedFramePtr& input) {
    return input->frame_id;
  }

  static bool Read(::blink::mojom::blink::AffectedFrame::DataView input, ::blink::mojom::blink::AffectedFramePtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AffectedLocation::DataView,
                                         ::blink::mojom::blink::AffectedLocationPtr> {
  static bool IsNull(const ::blink::mojom::blink::AffectedLocationPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AffectedLocationPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AffectedLocation::script_id)& script_id(
      const ::blink::mojom::blink::AffectedLocationPtr& input) {
    return input->script_id;
  }

  static const decltype(::blink::mojom::blink::AffectedLocation::url)& url(
      const ::blink::mojom::blink::AffectedLocationPtr& input) {
    return input->url;
  }

  static decltype(::blink::mojom::blink::AffectedLocation::line) line(
      const ::blink::mojom::blink::AffectedLocationPtr& input) {
    return input->line;
  }

  static decltype(::blink::mojom::blink::AffectedLocation::column) column(
      const ::blink::mojom::blink::AffectedLocationPtr& input) {
    return input->column;
  }

  static bool Read(::blink::mojom::blink::AffectedLocation::DataView input, ::blink::mojom::blink::AffectedLocationPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::BlockedByResponseIssueDetails::DataView,
                                         ::blink::mojom::blink::BlockedByResponseIssueDetailsPtr> {
  static bool IsNull(const ::blink::mojom::blink::BlockedByResponseIssueDetailsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::BlockedByResponseIssueDetailsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::BlockedByResponseIssueDetails::request)& request(
      const ::blink::mojom::blink::BlockedByResponseIssueDetailsPtr& input) {
    return input->request;
  }

  static const decltype(::blink::mojom::blink::BlockedByResponseIssueDetails::parentFrame)& parentFrame(
      const ::blink::mojom::blink::BlockedByResponseIssueDetailsPtr& input) {
    return input->parentFrame;
  }

  static const decltype(::blink::mojom::blink::BlockedByResponseIssueDetails::blockedFrame)& blockedFrame(
      const ::blink::mojom::blink::BlockedByResponseIssueDetailsPtr& input) {
    return input->blockedFrame;
  }

  static decltype(::blink::mojom::blink::BlockedByResponseIssueDetails::reason) reason(
      const ::blink::mojom::blink::BlockedByResponseIssueDetailsPtr& input) {
    return input->reason;
  }

  static bool Read(::blink::mojom::blink::BlockedByResponseIssueDetails::DataView input, ::blink::mojom::blink::BlockedByResponseIssueDetailsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::HeavyAdIssueDetails::DataView,
                                         ::blink::mojom::blink::HeavyAdIssueDetailsPtr> {
  static bool IsNull(const ::blink::mojom::blink::HeavyAdIssueDetailsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::HeavyAdIssueDetailsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::HeavyAdIssueDetails::resolution) resolution(
      const ::blink::mojom::blink::HeavyAdIssueDetailsPtr& input) {
    return input->resolution;
  }

  static decltype(::blink::mojom::blink::HeavyAdIssueDetails::reason) reason(
      const ::blink::mojom::blink::HeavyAdIssueDetailsPtr& input) {
    return input->reason;
  }

  static const decltype(::blink::mojom::blink::HeavyAdIssueDetails::frame)& frame(
      const ::blink::mojom::blink::HeavyAdIssueDetailsPtr& input) {
    return input->frame;
  }

  static bool Read(::blink::mojom::blink::HeavyAdIssueDetails::DataView input, ::blink::mojom::blink::HeavyAdIssueDetailsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AttributionReportingIssueDetails::DataView,
                                         ::blink::mojom::blink::AttributionReportingIssueDetailsPtr> {
  static bool IsNull(const ::blink::mojom::blink::AttributionReportingIssueDetailsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AttributionReportingIssueDetailsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::AttributionReportingIssueDetails::violation_type) violation_type(
      const ::blink::mojom::blink::AttributionReportingIssueDetailsPtr& input) {
    return input->violation_type;
  }

  static const decltype(::blink::mojom::blink::AttributionReportingIssueDetails::request)& request(
      const ::blink::mojom::blink::AttributionReportingIssueDetailsPtr& input) {
    return input->request;
  }

  static const decltype(::blink::mojom::blink::AttributionReportingIssueDetails::invalid_parameter)& invalid_parameter(
      const ::blink::mojom::blink::AttributionReportingIssueDetailsPtr& input) {
    return input->invalid_parameter;
  }

  static bool Read(::blink::mojom::blink::AttributionReportingIssueDetails::DataView input, ::blink::mojom::blink::AttributionReportingIssueDetailsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::MixedContentIssueDetails::DataView,
                                         ::blink::mojom::blink::MixedContentIssueDetailsPtr> {
  static bool IsNull(const ::blink::mojom::blink::MixedContentIssueDetailsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::MixedContentIssueDetailsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::MixedContentIssueDetails::request_context) request_context(
      const ::blink::mojom::blink::MixedContentIssueDetailsPtr& input) {
    return input->request_context;
  }

  static decltype(::blink::mojom::blink::MixedContentIssueDetails::resolution_status) resolution_status(
      const ::blink::mojom::blink::MixedContentIssueDetailsPtr& input) {
    return input->resolution_status;
  }

  static const decltype(::blink::mojom::blink::MixedContentIssueDetails::insecure_url)& insecure_url(
      const ::blink::mojom::blink::MixedContentIssueDetailsPtr& input) {
    return input->insecure_url;
  }

  static const decltype(::blink::mojom::blink::MixedContentIssueDetails::main_resource_url)& main_resource_url(
      const ::blink::mojom::blink::MixedContentIssueDetailsPtr& input) {
    return input->main_resource_url;
  }

  static const decltype(::blink::mojom::blink::MixedContentIssueDetails::request)& request(
      const ::blink::mojom::blink::MixedContentIssueDetailsPtr& input) {
    return input->request;
  }

  static const decltype(::blink::mojom::blink::MixedContentIssueDetails::frame)& frame(
      const ::blink::mojom::blink::MixedContentIssueDetailsPtr& input) {
    return input->frame;
  }

  static bool Read(::blink::mojom::blink::MixedContentIssueDetails::DataView input, ::blink::mojom::blink::MixedContentIssueDetailsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::ContentSecurityPolicyIssueDetails::DataView,
                                         ::blink::mojom::blink::ContentSecurityPolicyIssueDetailsPtr> {
  static bool IsNull(const ::blink::mojom::blink::ContentSecurityPolicyIssueDetailsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::ContentSecurityPolicyIssueDetailsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::ContentSecurityPolicyIssueDetails::blocked_url)& blocked_url(
      const ::blink::mojom::blink::ContentSecurityPolicyIssueDetailsPtr& input) {
    return input->blocked_url;
  }

  static const decltype(::blink::mojom::blink::ContentSecurityPolicyIssueDetails::violated_directive)& violated_directive(
      const ::blink::mojom::blink::ContentSecurityPolicyIssueDetailsPtr& input) {
    return input->violated_directive;
  }

  static decltype(::blink::mojom::blink::ContentSecurityPolicyIssueDetails::is_report_only) is_report_only(
      const ::blink::mojom::blink::ContentSecurityPolicyIssueDetailsPtr& input) {
    return input->is_report_only;
  }

  static decltype(::blink::mojom::blink::ContentSecurityPolicyIssueDetails::content_security_policy_violation_type) content_security_policy_violation_type(
      const ::blink::mojom::blink::ContentSecurityPolicyIssueDetailsPtr& input) {
    return input->content_security_policy_violation_type;
  }

  static const decltype(::blink::mojom::blink::ContentSecurityPolicyIssueDetails::frame_ancestor)& frame_ancestor(
      const ::blink::mojom::blink::ContentSecurityPolicyIssueDetailsPtr& input) {
    return input->frame_ancestor;
  }

  static const decltype(::blink::mojom::blink::ContentSecurityPolicyIssueDetails::affected_location)& affected_location(
      const ::blink::mojom::blink::ContentSecurityPolicyIssueDetailsPtr& input) {
    return input->affected_location;
  }

  static decltype(::blink::mojom::blink::ContentSecurityPolicyIssueDetails::violating_node_id) violating_node_id(
      const ::blink::mojom::blink::ContentSecurityPolicyIssueDetailsPtr& input) {
    return input->violating_node_id;
  }

  static bool Read(::blink::mojom::blink::ContentSecurityPolicyIssueDetails::DataView input, ::blink::mojom::blink::ContentSecurityPolicyIssueDetailsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::CookieIssueDetails::DataView,
                                         ::blink::mojom::blink::CookieIssueDetailsPtr> {
  static bool IsNull(const ::blink::mojom::blink::CookieIssueDetailsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::CookieIssueDetailsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::CookieIssueDetails::cookie)& cookie(
      const ::blink::mojom::blink::CookieIssueDetailsPtr& input) {
    return input->cookie;
  }

  static const decltype(::blink::mojom::blink::CookieIssueDetails::exclusion_reason)& exclusion_reason(
      const ::blink::mojom::blink::CookieIssueDetailsPtr& input) {
    return input->exclusion_reason;
  }

  static const decltype(::blink::mojom::blink::CookieIssueDetails::warning_reason)& warning_reason(
      const ::blink::mojom::blink::CookieIssueDetailsPtr& input) {
    return input->warning_reason;
  }

  static decltype(::blink::mojom::blink::CookieIssueDetails::operation) operation(
      const ::blink::mojom::blink::CookieIssueDetailsPtr& input) {
    return input->operation;
  }

  static const decltype(::blink::mojom::blink::CookieIssueDetails::site_for_cookies)& site_for_cookies(
      const ::blink::mojom::blink::CookieIssueDetailsPtr& input) {
    return input->site_for_cookies;
  }

  static const decltype(::blink::mojom::blink::CookieIssueDetails::cookie_url)& cookie_url(
      const ::blink::mojom::blink::CookieIssueDetailsPtr& input) {
    return input->cookie_url;
  }

  static const decltype(::blink::mojom::blink::CookieIssueDetails::request)& request(
      const ::blink::mojom::blink::CookieIssueDetailsPtr& input) {
    return input->request;
  }

  static bool Read(::blink::mojom::blink::CookieIssueDetails::DataView input, ::blink::mojom::blink::CookieIssueDetailsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::SharedArrayBufferIssueDetails::DataView,
                                         ::blink::mojom::blink::SharedArrayBufferIssueDetailsPtr> {
  static bool IsNull(const ::blink::mojom::blink::SharedArrayBufferIssueDetailsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::SharedArrayBufferIssueDetailsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::SharedArrayBufferIssueDetails::affected_location)& affected_location(
      const ::blink::mojom::blink::SharedArrayBufferIssueDetailsPtr& input) {
    return input->affected_location;
  }

  static decltype(::blink::mojom::blink::SharedArrayBufferIssueDetails::is_warning) is_warning(
      const ::blink::mojom::blink::SharedArrayBufferIssueDetailsPtr& input) {
    return input->is_warning;
  }

  static decltype(::blink::mojom::blink::SharedArrayBufferIssueDetails::type) type(
      const ::blink::mojom::blink::SharedArrayBufferIssueDetailsPtr& input) {
    return input->type;
  }

  static bool Read(::blink::mojom::blink::SharedArrayBufferIssueDetails::DataView input, ::blink::mojom::blink::SharedArrayBufferIssueDetailsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::LowTextContrastIssue::DataView,
                                         ::blink::mojom::blink::LowTextContrastIssuePtr> {
  static bool IsNull(const ::blink::mojom::blink::LowTextContrastIssuePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::LowTextContrastIssuePtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::LowTextContrastIssue::violating_node_id) violating_node_id(
      const ::blink::mojom::blink::LowTextContrastIssuePtr& input) {
    return input->violating_node_id;
  }

  static const decltype(::blink::mojom::blink::LowTextContrastIssue::violating_node_selector)& violating_node_selector(
      const ::blink::mojom::blink::LowTextContrastIssuePtr& input) {
    return input->violating_node_selector;
  }

  static decltype(::blink::mojom::blink::LowTextContrastIssue::contrast_ratio) contrast_ratio(
      const ::blink::mojom::blink::LowTextContrastIssuePtr& input) {
    return input->contrast_ratio;
  }

  static decltype(::blink::mojom::blink::LowTextContrastIssue::threshold_aa) threshold_aa(
      const ::blink::mojom::blink::LowTextContrastIssuePtr& input) {
    return input->threshold_aa;
  }

  static decltype(::blink::mojom::blink::LowTextContrastIssue::threshold_aaa) threshold_aaa(
      const ::blink::mojom::blink::LowTextContrastIssuePtr& input) {
    return input->threshold_aaa;
  }

  static const decltype(::blink::mojom::blink::LowTextContrastIssue::font_size)& font_size(
      const ::blink::mojom::blink::LowTextContrastIssuePtr& input) {
    return input->font_size;
  }

  static const decltype(::blink::mojom::blink::LowTextContrastIssue::font_weight)& font_weight(
      const ::blink::mojom::blink::LowTextContrastIssuePtr& input) {
    return input->font_weight;
  }

  static bool Read(::blink::mojom::blink::LowTextContrastIssue::DataView input, ::blink::mojom::blink::LowTextContrastIssuePtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::FederatedAuthRequestIssueDetails::DataView,
                                         ::blink::mojom::blink::FederatedAuthRequestIssueDetailsPtr> {
  static bool IsNull(const ::blink::mojom::blink::FederatedAuthRequestIssueDetailsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::FederatedAuthRequestIssueDetailsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::FederatedAuthRequestIssueDetails::status) status(
      const ::blink::mojom::blink::FederatedAuthRequestIssueDetailsPtr& input) {
    return input->status;
  }

  static bool Read(::blink::mojom::blink::FederatedAuthRequestIssueDetails::DataView input, ::blink::mojom::blink::FederatedAuthRequestIssueDetailsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::FederatedAuthUserInfoRequestIssueDetails::DataView,
                                         ::blink::mojom::blink::FederatedAuthUserInfoRequestIssueDetailsPtr> {
  static bool IsNull(const ::blink::mojom::blink::FederatedAuthUserInfoRequestIssueDetailsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::FederatedAuthUserInfoRequestIssueDetailsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::FederatedAuthUserInfoRequestIssueDetails::status) status(
      const ::blink::mojom::blink::FederatedAuthUserInfoRequestIssueDetailsPtr& input) {
    return input->status;
  }

  static bool Read(::blink::mojom::blink::FederatedAuthUserInfoRequestIssueDetails::DataView input, ::blink::mojom::blink::FederatedAuthUserInfoRequestIssueDetailsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::BounceTrackingIssueDetails::DataView,
                                         ::blink::mojom::blink::BounceTrackingIssueDetailsPtr> {
  static bool IsNull(const ::blink::mojom::blink::BounceTrackingIssueDetailsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::BounceTrackingIssueDetailsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::BounceTrackingIssueDetails::tracking_sites)& tracking_sites(
      const ::blink::mojom::blink::BounceTrackingIssueDetailsPtr& input) {
    return input->tracking_sites;
  }

  static bool Read(::blink::mojom::blink::BounceTrackingIssueDetails::DataView input, ::blink::mojom::blink::BounceTrackingIssueDetailsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::PartitioningBlobURLIssueDetails::DataView,
                                         ::blink::mojom::blink::PartitioningBlobURLIssueDetailsPtr> {
  static bool IsNull(const ::blink::mojom::blink::PartitioningBlobURLIssueDetailsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::PartitioningBlobURLIssueDetailsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::PartitioningBlobURLIssueDetails::url)& url(
      const ::blink::mojom::blink::PartitioningBlobURLIssueDetailsPtr& input) {
    return input->url;
  }

  static decltype(::blink::mojom::blink::PartitioningBlobURLIssueDetails::partitioning_blob_url_info) partitioning_blob_url_info(
      const ::blink::mojom::blink::PartitioningBlobURLIssueDetailsPtr& input) {
    return input->partitioning_blob_url_info;
  }

  static bool Read(::blink::mojom::blink::PartitioningBlobURLIssueDetails::DataView input, ::blink::mojom::blink::PartitioningBlobURLIssueDetailsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::CookieDeprecationMetadataIssueDetails::DataView,
                                         ::blink::mojom::blink::CookieDeprecationMetadataIssueDetailsPtr> {
  static bool IsNull(const ::blink::mojom::blink::CookieDeprecationMetadataIssueDetailsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::CookieDeprecationMetadataIssueDetailsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::CookieDeprecationMetadataIssueDetails::allowed_sites)& allowed_sites(
      const ::blink::mojom::blink::CookieDeprecationMetadataIssueDetailsPtr& input) {
    return input->allowed_sites;
  }

  static decltype(::blink::mojom::blink::CookieDeprecationMetadataIssueDetails::opt_out_percentage) opt_out_percentage(
      const ::blink::mojom::blink::CookieDeprecationMetadataIssueDetailsPtr& input) {
    return input->opt_out_percentage;
  }

  static decltype(::blink::mojom::blink::CookieDeprecationMetadataIssueDetails::is_opt_out_top_level) is_opt_out_top_level(
      const ::blink::mojom::blink::CookieDeprecationMetadataIssueDetailsPtr& input) {
    return input->is_opt_out_top_level;
  }

  static decltype(::blink::mojom::blink::CookieDeprecationMetadataIssueDetails::operation) operation(
      const ::blink::mojom::blink::CookieDeprecationMetadataIssueDetailsPtr& input) {
    return input->operation;
  }

  static bool Read(::blink::mojom::blink::CookieDeprecationMetadataIssueDetails::DataView input, ::blink::mojom::blink::CookieDeprecationMetadataIssueDetailsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::GenericIssueDetails::DataView,
                                         ::blink::mojom::blink::GenericIssueDetailsPtr> {
  static bool IsNull(const ::blink::mojom::blink::GenericIssueDetailsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::GenericIssueDetailsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::GenericIssueDetails::error_type) error_type(
      const ::blink::mojom::blink::GenericIssueDetailsPtr& input) {
    return input->error_type;
  }

  static const decltype(::blink::mojom::blink::GenericIssueDetails::frame_id)& frame_id(
      const ::blink::mojom::blink::GenericIssueDetailsPtr& input) {
    return input->frame_id;
  }

  static decltype(::blink::mojom::blink::GenericIssueDetails::violating_node_id) violating_node_id(
      const ::blink::mojom::blink::GenericIssueDetailsPtr& input) {
    return input->violating_node_id;
  }

  static const decltype(::blink::mojom::blink::GenericIssueDetails::violating_node_attribute)& violating_node_attribute(
      const ::blink::mojom::blink::GenericIssueDetailsPtr& input) {
    return input->violating_node_attribute;
  }

  static bool Read(::blink::mojom::blink::GenericIssueDetails::DataView input, ::blink::mojom::blink::GenericIssueDetailsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::DeprecationIssueDetails::DataView,
                                         ::blink::mojom::blink::DeprecationIssueDetailsPtr> {
  static bool IsNull(const ::blink::mojom::blink::DeprecationIssueDetailsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::DeprecationIssueDetailsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::DeprecationIssueDetails::type) type(
      const ::blink::mojom::blink::DeprecationIssueDetailsPtr& input) {
    return input->type;
  }

  static const decltype(::blink::mojom::blink::DeprecationIssueDetails::affected_location)& affected_location(
      const ::blink::mojom::blink::DeprecationIssueDetailsPtr& input) {
    return input->affected_location;
  }

  static bool Read(::blink::mojom::blink::DeprecationIssueDetails::DataView input, ::blink::mojom::blink::DeprecationIssueDetailsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::UserReidentificationIssueDetails::DataView,
                                         ::blink::mojom::blink::UserReidentificationIssueDetailsPtr> {
  static bool IsNull(const ::blink::mojom::blink::UserReidentificationIssueDetailsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::UserReidentificationIssueDetailsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::UserReidentificationIssueDetails::type) type(
      const ::blink::mojom::blink::UserReidentificationIssueDetailsPtr& input) {
    return input->type;
  }

  static const decltype(::blink::mojom::blink::UserReidentificationIssueDetails::request)& request(
      const ::blink::mojom::blink::UserReidentificationIssueDetailsPtr& input) {
    return input->request;
  }

  static const decltype(::blink::mojom::blink::UserReidentificationIssueDetails::sourceCodeLocation)& sourceCodeLocation(
      const ::blink::mojom::blink::UserReidentificationIssueDetailsPtr& input) {
    return input->sourceCodeLocation;
  }

  static bool Read(::blink::mojom::blink::UserReidentificationIssueDetails::DataView input, ::blink::mojom::blink::UserReidentificationIssueDetailsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::InspectorIssueDetails::DataView,
                                         ::blink::mojom::blink::InspectorIssueDetailsPtr> {
  static bool IsNull(const ::blink::mojom::blink::InspectorIssueDetailsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::InspectorIssueDetailsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::InspectorIssueDetails::cookie_issue_details)& cookie_issue_details(
      const ::blink::mojom::blink::InspectorIssueDetailsPtr& input) {
    return input->cookie_issue_details;
  }

  static const decltype(::blink::mojom::blink::InspectorIssueDetails::mixed_content_issue_details)& mixed_content_issue_details(
      const ::blink::mojom::blink::InspectorIssueDetailsPtr& input) {
    return input->mixed_content_issue_details;
  }

  static const decltype(::blink::mojom::blink::InspectorIssueDetails::blocked_by_response_issue_details)& blocked_by_response_issue_details(
      const ::blink::mojom::blink::InspectorIssueDetailsPtr& input) {
    return input->blocked_by_response_issue_details;
  }

  static const decltype(::blink::mojom::blink::InspectorIssueDetails::csp_issue_details)& csp_issue_details(
      const ::blink::mojom::blink::InspectorIssueDetailsPtr& input) {
    return input->csp_issue_details;
  }

  static const decltype(::blink::mojom::blink::InspectorIssueDetails::sab_issue_details)& sab_issue_details(
      const ::blink::mojom::blink::InspectorIssueDetailsPtr& input) {
    return input->sab_issue_details;
  }

  static const decltype(::blink::mojom::blink::InspectorIssueDetails::heavy_ad_issue_details)& heavy_ad_issue_details(
      const ::blink::mojom::blink::InspectorIssueDetailsPtr& input) {
    return input->heavy_ad_issue_details;
  }

  static const decltype(::blink::mojom::blink::InspectorIssueDetails::attribution_reporting_issue_details)& attribution_reporting_issue_details(
      const ::blink::mojom::blink::InspectorIssueDetailsPtr& input) {
    return input->attribution_reporting_issue_details;
  }

  static const decltype(::blink::mojom::blink::InspectorIssueDetails::low_text_contrast_details)& low_text_contrast_details(
      const ::blink::mojom::blink::InspectorIssueDetailsPtr& input) {
    return input->low_text_contrast_details;
  }

  static const decltype(::blink::mojom::blink::InspectorIssueDetails::federated_auth_request_details)& federated_auth_request_details(
      const ::blink::mojom::blink::InspectorIssueDetailsPtr& input) {
    return input->federated_auth_request_details;
  }

  static const decltype(::blink::mojom::blink::InspectorIssueDetails::bounce_tracking_issue_details)& bounce_tracking_issue_details(
      const ::blink::mojom::blink::InspectorIssueDetailsPtr& input) {
    return input->bounce_tracking_issue_details;
  }

  static const decltype(::blink::mojom::blink::InspectorIssueDetails::partitioning_blob_url_issue_details)& partitioning_blob_url_issue_details(
      const ::blink::mojom::blink::InspectorIssueDetailsPtr& input) {
    return input->partitioning_blob_url_issue_details;
  }

  static const decltype(::blink::mojom::blink::InspectorIssueDetails::cookie_deprecation_metadata_issue_details)& cookie_deprecation_metadata_issue_details(
      const ::blink::mojom::blink::InspectorIssueDetailsPtr& input) {
    return input->cookie_deprecation_metadata_issue_details;
  }

  static const decltype(::blink::mojom::blink::InspectorIssueDetails::generic_issue_details)& generic_issue_details(
      const ::blink::mojom::blink::InspectorIssueDetailsPtr& input) {
    return input->generic_issue_details;
  }

  static const decltype(::blink::mojom::blink::InspectorIssueDetails::deprecation_issue_details)& deprecation_issue_details(
      const ::blink::mojom::blink::InspectorIssueDetailsPtr& input) {
    return input->deprecation_issue_details;
  }

  static const decltype(::blink::mojom::blink::InspectorIssueDetails::federated_auth_user_info_request_details)& federated_auth_user_info_request_details(
      const ::blink::mojom::blink::InspectorIssueDetailsPtr& input) {
    return input->federated_auth_user_info_request_details;
  }

  static const decltype(::blink::mojom::blink::InspectorIssueDetails::user_reidentification_issue_details)& user_reidentification_issue_details(
      const ::blink::mojom::blink::InspectorIssueDetailsPtr& input) {
    return input->user_reidentification_issue_details;
  }

  static const decltype(::blink::mojom::blink::InspectorIssueDetails::issue_id)& issue_id(
      const ::blink::mojom::blink::InspectorIssueDetailsPtr& input) {
    return input->issue_id;
  }

  static bool Read(::blink::mojom::blink::InspectorIssueDetails::DataView input, ::blink::mojom::blink::InspectorIssueDetailsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::InspectorIssueInfo::DataView,
                                         ::blink::mojom::blink::InspectorIssueInfoPtr> {
  static bool IsNull(const ::blink::mojom::blink::InspectorIssueInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::InspectorIssueInfoPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::InspectorIssueInfo::code) code(
      const ::blink::mojom::blink::InspectorIssueInfoPtr& input) {
    return input->code;
  }

  static const decltype(::blink::mojom::blink::InspectorIssueInfo::details)& details(
      const ::blink::mojom::blink::InspectorIssueInfoPtr& input) {
    return input->details;
  }

  static bool Read(::blink::mojom::blink::InspectorIssueInfo::DataView input, ::blink::mojom::blink::InspectorIssueInfoPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_DEVTOOLS_INSPECTOR_ISSUE_MOJOM_BLINK_H_