// third_party/blink/public/mojom/device/device.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');







goog.provide('blink.mojom.ManagedConfigurationObserver');
goog.provide('blink.mojom.ManagedConfigurationObserverReceiver');
goog.provide('blink.mojom.ManagedConfigurationObserverCallbackRouter');
goog.provide('blink.mojom.ManagedConfigurationObserverInterface');
goog.provide('blink.mojom.ManagedConfigurationObserverRemote');
goog.provide('blink.mojom.ManagedConfigurationObserverPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.ManagedConfigurationObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.ManagedConfigurationObserver.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.ManagedConfigurationObserverInterface = class {
  
  /**
   */

  onConfigurationChanged() {}
};

/**
 * @export
 * @implements { blink.mojom.ManagedConfigurationObserverInterface }
 */
blink.mojom.ManagedConfigurationObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.ManagedConfigurationObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.ManagedConfigurationObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.ManagedConfigurationObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  onConfigurationChanged() {
    this.proxy.sendMessage(
        0,
        blink.mojom.ManagedConfigurationObserver_OnConfigurationChanged_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ManagedConfigurationObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.ManagedConfigurationObserverReceiver = class {
  /**
   * @param {!blink.mojom.ManagedConfigurationObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.ManagedConfigurationObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.ManagedConfigurationObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ManagedConfigurationObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ManagedConfigurationObserver_OnConfigurationChanged_ParamsSpec.$,
        null,
        impl.onConfigurationChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.ManagedConfigurationObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ManagedConfigurationObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.ManagedConfigurationObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.ManagedConfigurationObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ManagedConfigurationObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.ManagedConfigurationObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.ManagedConfigurationObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ManagedConfigurationObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onConfigurationChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ManagedConfigurationObserver_OnConfigurationChanged_ParamsSpec.$,
        null,
        this.onConfigurationChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.DeviceAPIService');
goog.provide('blink.mojom.DeviceAPIServiceReceiver');
goog.provide('blink.mojom.DeviceAPIServiceCallbackRouter');
goog.provide('blink.mojom.DeviceAPIServiceInterface');
goog.provide('blink.mojom.DeviceAPIServiceRemote');
goog.provide('blink.mojom.DeviceAPIServicePendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.DeviceAPIServicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.DeviceAPIService.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.DeviceAPIServiceInterface = class {
  
  /**
   * @return {!Promise<{
        result: !blink.mojom.DeviceAttributeResult,
   *  }>}
   */

  getDirectoryId() {}
  
  /**
   * @return {!Promise<{
        result: !blink.mojom.DeviceAttributeResult,
   *  }>}
   */

  getHostname() {}
  
  /**
   * @return {!Promise<{
        result: !blink.mojom.DeviceAttributeResult,
   *  }>}
   */

  getSerialNumber() {}
  
  /**
   * @return {!Promise<{
        result: !blink.mojom.DeviceAttributeResult,
   *  }>}
   */

  getAnnotatedAssetId() {}
  
  /**
   * @return {!Promise<{
        result: !blink.mojom.DeviceAttributeResult,
   *  }>}
   */

  getAnnotatedLocation() {}
};

/**
 * @export
 * @implements { blink.mojom.DeviceAPIServiceInterface }
 */
blink.mojom.DeviceAPIServiceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.DeviceAPIServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.DeviceAPIServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.DeviceAPIServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        result: !blink.mojom.DeviceAttributeResult,
   *  }>}
   */

  getDirectoryId() {
    return this.proxy.sendMessage(
        0,
        blink.mojom.DeviceAPIService_GetDirectoryId_ParamsSpec.$,
        blink.mojom.DeviceAPIService_GetDirectoryId_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !blink.mojom.DeviceAttributeResult,
   *  }>}
   */

  getHostname() {
    return this.proxy.sendMessage(
        1,
        blink.mojom.DeviceAPIService_GetHostname_ParamsSpec.$,
        blink.mojom.DeviceAPIService_GetHostname_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !blink.mojom.DeviceAttributeResult,
   *  }>}
   */

  getSerialNumber() {
    return this.proxy.sendMessage(
        2,
        blink.mojom.DeviceAPIService_GetSerialNumber_ParamsSpec.$,
        blink.mojom.DeviceAPIService_GetSerialNumber_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !blink.mojom.DeviceAttributeResult,
   *  }>}
   */

  getAnnotatedAssetId() {
    return this.proxy.sendMessage(
        3,
        blink.mojom.DeviceAPIService_GetAnnotatedAssetId_ParamsSpec.$,
        blink.mojom.DeviceAPIService_GetAnnotatedAssetId_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !blink.mojom.DeviceAttributeResult,
   *  }>}
   */

  getAnnotatedLocation() {
    return this.proxy.sendMessage(
        4,
        blink.mojom.DeviceAPIService_GetAnnotatedLocation_ParamsSpec.$,
        blink.mojom.DeviceAPIService_GetAnnotatedLocation_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the DeviceAPIService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.DeviceAPIServiceReceiver = class {
  /**
   * @param {!blink.mojom.DeviceAPIServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.DeviceAPIServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.DeviceAPIServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.DeviceAPIServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.DeviceAPIService_GetDirectoryId_ParamsSpec.$,
        blink.mojom.DeviceAPIService_GetDirectoryId_ResponseParamsSpec.$,
        impl.getDirectoryId.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.DeviceAPIService_GetHostname_ParamsSpec.$,
        blink.mojom.DeviceAPIService_GetHostname_ResponseParamsSpec.$,
        impl.getHostname.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.DeviceAPIService_GetSerialNumber_ParamsSpec.$,
        blink.mojom.DeviceAPIService_GetSerialNumber_ResponseParamsSpec.$,
        impl.getSerialNumber.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.DeviceAPIService_GetAnnotatedAssetId_ParamsSpec.$,
        blink.mojom.DeviceAPIService_GetAnnotatedAssetId_ResponseParamsSpec.$,
        impl.getAnnotatedAssetId.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.DeviceAPIService_GetAnnotatedLocation_ParamsSpec.$,
        blink.mojom.DeviceAPIService_GetAnnotatedLocation_ResponseParamsSpec.$,
        impl.getAnnotatedLocation.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.DeviceAPIService = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.DeviceAPIService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.DeviceAPIServiceRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.DeviceAPIServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the DeviceAPIService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.DeviceAPIServiceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.DeviceAPIServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.DeviceAPIServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDirectoryId =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.DeviceAPIService_GetDirectoryId_ParamsSpec.$,
        blink.mojom.DeviceAPIService_GetDirectoryId_ResponseParamsSpec.$,
        this.getDirectoryId.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getHostname =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.DeviceAPIService_GetHostname_ParamsSpec.$,
        blink.mojom.DeviceAPIService_GetHostname_ResponseParamsSpec.$,
        this.getHostname.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getSerialNumber =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.DeviceAPIService_GetSerialNumber_ParamsSpec.$,
        blink.mojom.DeviceAPIService_GetSerialNumber_ResponseParamsSpec.$,
        this.getSerialNumber.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getAnnotatedAssetId =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.DeviceAPIService_GetAnnotatedAssetId_ParamsSpec.$,
        blink.mojom.DeviceAPIService_GetAnnotatedAssetId_ResponseParamsSpec.$,
        this.getAnnotatedAssetId.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getAnnotatedLocation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.DeviceAPIService_GetAnnotatedLocation_ParamsSpec.$,
        blink.mojom.DeviceAPIService_GetAnnotatedLocation_ResponseParamsSpec.$,
        this.getAnnotatedLocation.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.ManagedConfigurationService');
goog.provide('blink.mojom.ManagedConfigurationServiceReceiver');
goog.provide('blink.mojom.ManagedConfigurationServiceCallbackRouter');
goog.provide('blink.mojom.ManagedConfigurationServiceInterface');
goog.provide('blink.mojom.ManagedConfigurationServiceRemote');
goog.provide('blink.mojom.ManagedConfigurationServicePendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.ManagedConfigurationServicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.ManagedConfigurationService.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.ManagedConfigurationServiceInterface = class {
  
  /**
   * @param { !Array<!string> } keys
   * @return {!Promise<{
        configurations: ?Object<!string, !string>,
   *  }>}
   */

  getManagedConfiguration(keys) {}
  
  /**
   * @param { !blink.mojom.ManagedConfigurationObserverRemote } observer
   */

  subscribeToManagedConfiguration(observer) {}
};

/**
 * @export
 * @implements { blink.mojom.ManagedConfigurationServiceInterface }
 */
blink.mojom.ManagedConfigurationServiceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.ManagedConfigurationServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.ManagedConfigurationServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.ManagedConfigurationServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!string> } keys
   * @return {!Promise<{
        configurations: ?Object<!string, !string>,
   *  }>}
   */

  getManagedConfiguration(
      keys) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.ManagedConfigurationService_GetManagedConfiguration_ParamsSpec.$,
        blink.mojom.ManagedConfigurationService_GetManagedConfiguration_ResponseParamsSpec.$,
        [
          keys
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.ManagedConfigurationObserverRemote } observer
   */

  subscribeToManagedConfiguration(
      observer) {
    this.proxy.sendMessage(
        1,
        blink.mojom.ManagedConfigurationService_SubscribeToManagedConfiguration_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ManagedConfigurationService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.ManagedConfigurationServiceReceiver = class {
  /**
   * @param {!blink.mojom.ManagedConfigurationServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.ManagedConfigurationServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.ManagedConfigurationServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ManagedConfigurationServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ManagedConfigurationService_GetManagedConfiguration_ParamsSpec.$,
        blink.mojom.ManagedConfigurationService_GetManagedConfiguration_ResponseParamsSpec.$,
        impl.getManagedConfiguration.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.ManagedConfigurationService_SubscribeToManagedConfiguration_ParamsSpec.$,
        null,
        impl.subscribeToManagedConfiguration.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.ManagedConfigurationService = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ManagedConfigurationService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.ManagedConfigurationServiceRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.ManagedConfigurationServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ManagedConfigurationService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.ManagedConfigurationServiceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.ManagedConfigurationServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ManagedConfigurationServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getManagedConfiguration =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ManagedConfigurationService_GetManagedConfiguration_ParamsSpec.$,
        blink.mojom.ManagedConfigurationService_GetManagedConfiguration_ResponseParamsSpec.$,
        this.getManagedConfiguration.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.subscribeToManagedConfiguration =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.ManagedConfigurationService_SubscribeToManagedConfiguration_ParamsSpec.$,
        null,
        this.subscribeToManagedConfiguration.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.ManagedConfigurationObserver_OnConfigurationChanged_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ManagedConfigurationObserver_OnConfigurationChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.DeviceAPIService_GetDirectoryId_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DeviceAPIService_GetDirectoryId_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.DeviceAPIService_GetDirectoryId_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DeviceAPIService_GetDirectoryId_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.DeviceAPIService_GetHostname_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DeviceAPIService_GetHostname_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.DeviceAPIService_GetHostname_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DeviceAPIService_GetHostname_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.DeviceAPIService_GetSerialNumber_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DeviceAPIService_GetSerialNumber_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.DeviceAPIService_GetSerialNumber_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DeviceAPIService_GetSerialNumber_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.DeviceAPIService_GetAnnotatedAssetId_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DeviceAPIService_GetAnnotatedAssetId_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.DeviceAPIService_GetAnnotatedAssetId_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DeviceAPIService_GetAnnotatedAssetId_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.DeviceAPIService_GetAnnotatedLocation_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DeviceAPIService_GetAnnotatedLocation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.DeviceAPIService_GetAnnotatedLocation_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DeviceAPIService_GetAnnotatedLocation_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ManagedConfigurationService_GetManagedConfiguration_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ManagedConfigurationService_GetManagedConfiguration_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ManagedConfigurationService_GetManagedConfiguration_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ManagedConfigurationService_GetManagedConfiguration_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.ManagedConfigurationService_SubscribeToManagedConfiguration_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ManagedConfigurationService_SubscribeToManagedConfiguration_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.DeviceAttributeResultSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.DeviceAttributeResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.ManagedConfigurationObserver_OnConfigurationChanged_ParamsSpec.$,
    'ManagedConfigurationObserver_OnConfigurationChanged_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.ManagedConfigurationObserver_OnConfigurationChanged_Params');

/** @record */
blink.mojom.ManagedConfigurationObserver_OnConfigurationChanged_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.DeviceAPIService_GetDirectoryId_ParamsSpec.$,
    'DeviceAPIService_GetDirectoryId_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.DeviceAPIService_GetDirectoryId_Params');

/** @record */
blink.mojom.DeviceAPIService_GetDirectoryId_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.DeviceAPIService_GetDirectoryId_ResponseParamsSpec.$,
    'DeviceAPIService_GetDirectoryId_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.DeviceAttributeResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.DeviceAPIService_GetDirectoryId_ResponseParams');

/** @record */
blink.mojom.DeviceAPIService_GetDirectoryId_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.DeviceAttributeResult } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.DeviceAPIService_GetHostname_ParamsSpec.$,
    'DeviceAPIService_GetHostname_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.DeviceAPIService_GetHostname_Params');

/** @record */
blink.mojom.DeviceAPIService_GetHostname_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.DeviceAPIService_GetHostname_ResponseParamsSpec.$,
    'DeviceAPIService_GetHostname_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.DeviceAttributeResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.DeviceAPIService_GetHostname_ResponseParams');

/** @record */
blink.mojom.DeviceAPIService_GetHostname_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.DeviceAttributeResult } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.DeviceAPIService_GetSerialNumber_ParamsSpec.$,
    'DeviceAPIService_GetSerialNumber_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.DeviceAPIService_GetSerialNumber_Params');

/** @record */
blink.mojom.DeviceAPIService_GetSerialNumber_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.DeviceAPIService_GetSerialNumber_ResponseParamsSpec.$,
    'DeviceAPIService_GetSerialNumber_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.DeviceAttributeResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.DeviceAPIService_GetSerialNumber_ResponseParams');

/** @record */
blink.mojom.DeviceAPIService_GetSerialNumber_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.DeviceAttributeResult } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.DeviceAPIService_GetAnnotatedAssetId_ParamsSpec.$,
    'DeviceAPIService_GetAnnotatedAssetId_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.DeviceAPIService_GetAnnotatedAssetId_Params');

/** @record */
blink.mojom.DeviceAPIService_GetAnnotatedAssetId_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.DeviceAPIService_GetAnnotatedAssetId_ResponseParamsSpec.$,
    'DeviceAPIService_GetAnnotatedAssetId_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.DeviceAttributeResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.DeviceAPIService_GetAnnotatedAssetId_ResponseParams');

/** @record */
blink.mojom.DeviceAPIService_GetAnnotatedAssetId_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.DeviceAttributeResult } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.DeviceAPIService_GetAnnotatedLocation_ParamsSpec.$,
    'DeviceAPIService_GetAnnotatedLocation_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.DeviceAPIService_GetAnnotatedLocation_Params');

/** @record */
blink.mojom.DeviceAPIService_GetAnnotatedLocation_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.DeviceAPIService_GetAnnotatedLocation_ResponseParamsSpec.$,
    'DeviceAPIService_GetAnnotatedLocation_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.DeviceAttributeResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.DeviceAPIService_GetAnnotatedLocation_ResponseParams');

/** @record */
blink.mojom.DeviceAPIService_GetAnnotatedLocation_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.DeviceAttributeResult } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.ManagedConfigurationService_GetManagedConfiguration_ParamsSpec.$,
    'ManagedConfigurationService_GetManagedConfiguration_Params',
    [
      mojo.internal.StructField(
        'keys', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ManagedConfigurationService_GetManagedConfiguration_Params');

/** @record */
blink.mojom.ManagedConfigurationService_GetManagedConfiguration_Params = class {
  constructor() {
    /** @export { !Array<!string> } */
    this.keys;
  }
};



mojo.internal.Struct(
    blink.mojom.ManagedConfigurationService_GetManagedConfiguration_ResponseParamsSpec.$,
    'ManagedConfigurationService_GetManagedConfiguration_ResponseParams',
    [
      mojo.internal.StructField(
        'configurations', 0,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.String, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ManagedConfigurationService_GetManagedConfiguration_ResponseParams');

/** @record */
blink.mojom.ManagedConfigurationService_GetManagedConfiguration_ResponseParams = class {
  constructor() {
    /** @export { (Object<!string, !string>|undefined) } */
    this.configurations;
  }
};



mojo.internal.Struct(
    blink.mojom.ManagedConfigurationService_SubscribeToManagedConfiguration_ParamsSpec.$,
    'ManagedConfigurationService_SubscribeToManagedConfiguration_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.ManagedConfigurationObserverRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.ManagedConfigurationService_SubscribeToManagedConfiguration_Params');

/** @record */
blink.mojom.ManagedConfigurationService_SubscribeToManagedConfiguration_Params = class {
  constructor() {
    /** @export { !blink.mojom.ManagedConfigurationObserverRemote } */
    this.observer;
  }
};

goog.provide('blink.mojom.DeviceAttributeResult');


mojo.internal.Union(
    blink.mojom.DeviceAttributeResultSpec.$, 'DeviceAttributeResult',
    {
      'errorMessage': {
        'ordinal': 0,
        'type': mojo.internal.String,
      },
      'attribute': {
        'ordinal': 1,
        'type': mojo.internal.String,
        'nullable': true,
      },
    });

/**
 * @typedef { {
 *   errorMessage: (!string|undefined),
 *   attribute: (?string|undefined),
 * } }
 */
blink.mojom.DeviceAttributeResult;
