// third_party/blink/public/mojom/credentialmanagement/credential_manager.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  String16 as mojoBase_mojom_String16,
  String16Spec as mojoBase_mojom_String16Spec
} from '../../../../../mojo/public/mojom/base/string16.mojom.m.js';

import {
  SchemeHostPort as url_mojom_SchemeHostPort,
  SchemeHostPortSpec as url_mojom_SchemeHostPortSpec
} from '../../../../../url/mojom/scheme_host_port.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CredentialTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CredentialType = {
  
  EMPTY: 0,
  PASSWORD: 1,
  FEDERATED: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CredentialMediationRequirementSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CredentialMediationRequirement = {
  
  kSilent: 0,
  kOptional: 1,
  kRequired: 2,
  kConditional: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CredentialManagerErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CredentialManagerError = {
  
  SUCCESS: 0,
  PENDING_REQUEST: 1,
  PASSWORD_STORE_UNAVAILABLE: 2,
  UNKNOWN: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class CredentialManagerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.CredentialManager', scope);
  }
}

/** @interface */
export class CredentialManagerInterface {
  
  /**
   * @param { !CredentialInfo } credential
   * @return {!Promise}
   */

  store(credential) {}
  
  /**
   * @return {!Promise}
   */

  preventSilentAccess() {}
  
  /**
   * @param { !CredentialMediationRequirement } mediation
   * @param { !boolean } includePasswords
   * @param { !Array<!url_mojom_Url> } federations
   * @return {!Promise<{
        error: !CredentialManagerError,
        credential: ?CredentialInfo,
   *  }>}
   */

  get(mediation, includePasswords, federations) {}
}

/**
 * @implements { CredentialManagerInterface }
 */
export class CredentialManagerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!CredentialManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CredentialManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!CredentialManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !CredentialInfo } credential
   * @return {!Promise}
   */

  store(
      credential) {
    return this.proxy.sendMessage(
        0,
        CredentialManager_Store_ParamsSpec.$,
        CredentialManager_Store_ResponseParamsSpec.$,
        [
          credential
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  preventSilentAccess() {
    return this.proxy.sendMessage(
        1,
        CredentialManager_PreventSilentAccess_ParamsSpec.$,
        CredentialManager_PreventSilentAccess_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !CredentialMediationRequirement } mediation
   * @param { !boolean } includePasswords
   * @param { !Array<!url_mojom_Url> } federations
   * @return {!Promise<{
        error: !CredentialManagerError,
        credential: ?CredentialInfo,
   *  }>}
   */

  get(
      mediation,
      includePasswords,
      federations) {
    return this.proxy.sendMessage(
        2,
        CredentialManager_Get_ParamsSpec.$,
        CredentialManager_Get_ResponseParamsSpec.$,
        [
          mediation,
          includePasswords,
          federations
        ],
        false);
  }
}

/**
 * An object which receives request messages for the CredentialManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CredentialManagerReceiver {
  /**
   * @param {!CredentialManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!CredentialManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CredentialManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CredentialManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CredentialManager_Store_ParamsSpec.$,
        CredentialManager_Store_ResponseParamsSpec.$,
        impl.store.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        CredentialManager_PreventSilentAccess_ParamsSpec.$,
        CredentialManager_PreventSilentAccess_ResponseParamsSpec.$,
        impl.preventSilentAccess.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        CredentialManager_Get_ParamsSpec.$,
        CredentialManager_Get_ResponseParamsSpec.$,
        impl.get.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CredentialManager {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.CredentialManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!CredentialManagerRemote}
   */
  static getRemote() {
    let remote = new CredentialManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the CredentialManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CredentialManagerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CredentialManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CredentialManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.store =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CredentialManager_Store_ParamsSpec.$,
        CredentialManager_Store_ResponseParamsSpec.$,
        this.store.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.preventSilentAccess =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        CredentialManager_PreventSilentAccess_ParamsSpec.$,
        CredentialManager_PreventSilentAccess_ResponseParamsSpec.$,
        this.preventSilentAccess.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.get =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        CredentialManager_Get_ParamsSpec.$,
        CredentialManager_Get_ResponseParamsSpec.$,
        this.get.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CredentialInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CredentialManager_Store_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CredentialManager_Store_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CredentialManager_PreventSilentAccess_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CredentialManager_PreventSilentAccess_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CredentialManager_Get_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CredentialManager_Get_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    CredentialInfoSpec.$,
    'CredentialInfo',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        CredentialTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'id', 8,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'name', 16,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'icon', 24,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'password', 32,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'federation', 40,
        0,
        url_mojom_SchemeHostPortSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class CredentialInfo {
  constructor() {
    /** @type { !CredentialType } */
    this.type;
    /** @type { (mojoBase_mojom_String16|undefined) } */
    this.id;
    /** @type { (mojoBase_mojom_String16|undefined) } */
    this.name;
    /** @type { !url_mojom_Url } */
    this.icon;
    /** @type { (mojoBase_mojom_String16|undefined) } */
    this.password;
    /** @type { !url_mojom_SchemeHostPort } */
    this.federation;
  }
}



mojo.internal.Struct(
    CredentialManager_Store_ParamsSpec.$,
    'CredentialManager_Store_Params',
    [
      mojo.internal.StructField(
        'credential', 0,
        0,
        CredentialInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CredentialManager_Store_Params {
  constructor() {
    /** @type { !CredentialInfo } */
    this.credential;
  }
}



mojo.internal.Struct(
    CredentialManager_Store_ResponseParamsSpec.$,
    'CredentialManager_Store_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class CredentialManager_Store_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    CredentialManager_PreventSilentAccess_ParamsSpec.$,
    'CredentialManager_PreventSilentAccess_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class CredentialManager_PreventSilentAccess_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    CredentialManager_PreventSilentAccess_ResponseParamsSpec.$,
    'CredentialManager_PreventSilentAccess_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class CredentialManager_PreventSilentAccess_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    CredentialManager_Get_ParamsSpec.$,
    'CredentialManager_Get_Params',
    [
      mojo.internal.StructField(
        'mediation', 0,
        0,
        CredentialMediationRequirementSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'includePasswords', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'federations', 8,
        0,
        mojo.internal.Array(url_mojom_UrlSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CredentialManager_Get_Params {
  constructor() {
    /** @type { !CredentialMediationRequirement } */
    this.mediation;
    /** @type { !boolean } */
    this.includePasswords;
    /** @type { !Array<!url_mojom_Url> } */
    this.federations;
  }
}



mojo.internal.Struct(
    CredentialManager_Get_ResponseParamsSpec.$,
    'CredentialManager_Get_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        CredentialManagerErrorSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'credential', 8,
        0,
        CredentialInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CredentialManager_Get_ResponseParams {
  constructor() {
    /** @type { !CredentialManagerError } */
    this.error;
    /** @type { (CredentialInfo|undefined) } */
    this.credential;
  }
}

