// third_party/blink/public/mojom/cookie_store/cookie_store.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.CookieStorePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.CookieStore.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.CookieStoreInterface }
 */
blink.mojom.CookieStoreRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.CookieStorePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.CookieStorePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.CookieStorePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @param { !Array<!blink.mojom.CookieChangeSubscription> } subscription
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  addSubscriptions(
      serviceWorkerRegistrationId,
      subscription) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.CookieStore_AddSubscriptions_ParamsSpec.$,
        blink.mojom.CookieStore_AddSubscriptions_ResponseParamsSpec.$,
        [
          serviceWorkerRegistrationId,
          subscription
        ],
        false);
  }

  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @param { !Array<!blink.mojom.CookieChangeSubscription> } subscription
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  removeSubscriptions(
      serviceWorkerRegistrationId,
      subscription) {
    return this.proxy.sendMessage(
        1,
        blink.mojom.CookieStore_RemoveSubscriptions_ParamsSpec.$,
        blink.mojom.CookieStore_RemoveSubscriptions_ResponseParamsSpec.$,
        [
          serviceWorkerRegistrationId,
          subscription
        ],
        false);
  }

  
  /**
   * @param { !bigint } serviceWorkerRegistrationId
   * @return {!Promise<{
        subscriptions: !Array<!blink.mojom.CookieChangeSubscription>,
        success: !boolean,
   *  }>}
   */

  getSubscriptions(
      serviceWorkerRegistrationId) {
    return this.proxy.sendMessage(
        2,
        blink.mojom.CookieStore_GetSubscriptions_ParamsSpec.$,
        blink.mojom.CookieStore_GetSubscriptions_ResponseParamsSpec.$,
        [
          serviceWorkerRegistrationId
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CookieStore
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.CookieStoreReceiver = class {
  /**
   * @param {!blink.mojom.CookieStoreInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.CookieStoreRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.CookieStoreRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.CookieStoreRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.CookieStore_AddSubscriptions_ParamsSpec.$,
        blink.mojom.CookieStore_AddSubscriptions_ResponseParamsSpec.$,
        impl.addSubscriptions.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.CookieStore_RemoveSubscriptions_ParamsSpec.$,
        blink.mojom.CookieStore_RemoveSubscriptions_ResponseParamsSpec.$,
        impl.removeSubscriptions.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.CookieStore_GetSubscriptions_ParamsSpec.$,
        blink.mojom.CookieStore_GetSubscriptions_ResponseParamsSpec.$,
        impl.getSubscriptions.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.CookieStore = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.CookieStore";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.CookieStoreRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.CookieStoreRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the CookieStore
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.CookieStoreCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.CookieStoreRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.CookieStoreRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addSubscriptions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.CookieStore_AddSubscriptions_ParamsSpec.$,
        blink.mojom.CookieStore_AddSubscriptions_ResponseParamsSpec.$,
        this.addSubscriptions.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.removeSubscriptions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.CookieStore_RemoveSubscriptions_ParamsSpec.$,
        blink.mojom.CookieStore_RemoveSubscriptions_ResponseParamsSpec.$,
        this.removeSubscriptions.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getSubscriptions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.CookieStore_GetSubscriptions_ParamsSpec.$,
        blink.mojom.CookieStore_GetSubscriptions_ResponseParamsSpec.$,
        this.getSubscriptions.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CookieChangeSubscriptionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CookieStore_AddSubscriptions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CookieStore_AddSubscriptions_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CookieStore_RemoveSubscriptions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CookieStore_RemoveSubscriptions_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CookieStore_GetSubscriptions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.CookieStore_GetSubscriptions_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.CookieChangeSubscriptionSpec.$,
    'CookieChangeSubscription',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'matchType', 8,
        0,
        network.mojom.CookieMatchTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'name', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.CookieChangeSubscription = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !network.mojom.CookieMatchType } */
    this.matchType;
    /** @export { !string } */
    this.name;
  }
};



mojo.internal.Struct(
    blink.mojom.CookieStore_AddSubscriptions_ParamsSpec.$,
    'CookieStore_AddSubscriptions_Params',
    [
      mojo.internal.StructField(
        'serviceWorkerRegistrationId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'subscription', 8,
        0,
        mojo.internal.Array(blink.mojom.CookieChangeSubscriptionSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.CookieStore_AddSubscriptions_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.serviceWorkerRegistrationId;
    /** @export { !Array<!blink.mojom.CookieChangeSubscription> } */
    this.subscription;
  }
};



mojo.internal.Struct(
    blink.mojom.CookieStore_AddSubscriptions_ResponseParamsSpec.$,
    'CookieStore_AddSubscriptions_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.CookieStore_AddSubscriptions_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    blink.mojom.CookieStore_RemoveSubscriptions_ParamsSpec.$,
    'CookieStore_RemoveSubscriptions_Params',
    [
      mojo.internal.StructField(
        'serviceWorkerRegistrationId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'subscription', 8,
        0,
        mojo.internal.Array(blink.mojom.CookieChangeSubscriptionSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.CookieStore_RemoveSubscriptions_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.serviceWorkerRegistrationId;
    /** @export { !Array<!blink.mojom.CookieChangeSubscription> } */
    this.subscription;
  }
};



mojo.internal.Struct(
    blink.mojom.CookieStore_RemoveSubscriptions_ResponseParamsSpec.$,
    'CookieStore_RemoveSubscriptions_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.CookieStore_RemoveSubscriptions_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    blink.mojom.CookieStore_GetSubscriptions_ParamsSpec.$,
    'CookieStore_GetSubscriptions_Params',
    [
      mojo.internal.StructField(
        'serviceWorkerRegistrationId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.CookieStore_GetSubscriptions_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.serviceWorkerRegistrationId;
  }
};



mojo.internal.Struct(
    blink.mojom.CookieStore_GetSubscriptions_ResponseParamsSpec.$,
    'CookieStore_GetSubscriptions_ResponseParams',
    [
      mojo.internal.StructField(
        'subscriptions', 0,
        0,
        mojo.internal.Array(blink.mojom.CookieChangeSubscriptionSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'success', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.CookieStore_GetSubscriptions_ResponseParams = class {
  constructor() {
    /** @export { !Array<!blink.mojom.CookieChangeSubscription> } */
    this.subscriptions;
    /** @export { !boolean } */
    this.success;
  }
};

