// third_party/blink/public/mojom/context_menu/context_menu.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTEXT_MENU_CONTEXT_MENU_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTEXT_MENU_CONTEXT_MENU_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/context_menu/context_menu.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/context_menu/context_menu.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/context_menu/context_menu.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom-blink.h"
#include "services/network/public/mojom/referrer_policy.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/annotation/annotation.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/conversions/conversions.mojom-blink.h"
#include "third_party/blink/public/mojom/forms/form_control_type.mojom-blink-forward.h"
#include "ui/base/mojom/menu_source_type.mojom-blink-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/context_menu_data/context_menu_mojom_traits.h"
#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class ContextMenuClientProxy;

template <typename ImplRefTraits>
class ContextMenuClientStub;

class ContextMenuClientRequestValidator;


class PLATFORM_EXPORT ContextMenuClient
    : public ContextMenuClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.ContextMenuClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ContextMenuClientInterfaceBase;
  using Proxy_ = ContextMenuClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = ContextMenuClientStub<ImplRefTraits>;

  using RequestValidator_ = ContextMenuClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCustomContextMenuActionMinVersion = 0,
    kContextMenuClosedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CustomContextMenuAction_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ContextMenuClosed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ContextMenuClient() = default;

  virtual void CustomContextMenuAction(uint32_t action) = 0;

  virtual void ContextMenuClosed(const ::blink::KURL& link_followed, const std::optional<::blink::Impression>& impression) = 0;
};



class PLATFORM_EXPORT ContextMenuClientProxy
    : public ContextMenuClient {
 public:
  using InterfaceType = ContextMenuClient;

  explicit ContextMenuClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CustomContextMenuAction(uint32_t action) final;
  
  void ContextMenuClosed(const ::blink::KURL& link_followed, const std::optional<::blink::Impression>& impression) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT ContextMenuClientStubDispatch {
 public:
  static bool Accept(ContextMenuClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ContextMenuClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ContextMenuClient>>
class ContextMenuClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ContextMenuClientStub() = default;
  ~ContextMenuClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ContextMenuClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ContextMenuClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT ContextMenuClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class PLATFORM_EXPORT Accelerator {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Accelerator, T>::value>;
  using DataView = AcceleratorDataView;
  using Data_ = internal::Accelerator_Data;

  template <typename... Args>
  static AcceleratorPtr New(Args&&... args) {
    return AcceleratorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AcceleratorPtr From(const U& u) {
    return mojo::TypeConverter<AcceleratorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Accelerator>::Convert(*this);
  }


  Accelerator();

  Accelerator(
      uint16_t key_code,
      int32_t modifiers);


  ~Accelerator();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AcceleratorPtr>
  AcceleratorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Accelerator::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Accelerator::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Accelerator::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Accelerator::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Accelerator::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Accelerator::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Accelerator_UnserializedMessageContext<
            UserType, Accelerator::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Accelerator::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Accelerator::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Accelerator_UnserializedMessageContext<
            UserType, Accelerator::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Accelerator::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint16_t key_code;
  
  int32_t modifiers;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Accelerator::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Accelerator::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Accelerator::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Accelerator::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT FormRendererId {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FormRendererId, T>::value>;
  using DataView = FormRendererIdDataView;
  using Data_ = internal::FormRendererId_Data;

  template <typename... Args>
  static FormRendererIdPtr New(Args&&... args) {
    return FormRendererIdPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FormRendererIdPtr From(const U& u) {
    return mojo::TypeConverter<FormRendererIdPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FormRendererId>::Convert(*this);
  }


  FormRendererId();

  explicit FormRendererId(
      uint64_t id);


  ~FormRendererId();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FormRendererIdPtr>
  FormRendererIdPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FormRendererId::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FormRendererId::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FormRendererId::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FormRendererId::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FormRendererId::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FormRendererId::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FormRendererId_UnserializedMessageContext<
            UserType, FormRendererId::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FormRendererId::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FormRendererId::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FormRendererId_UnserializedMessageContext<
            UserType, FormRendererId::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FormRendererId::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FormRendererId::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FormRendererId::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FormRendererId::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FormRendererId::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT FieldRendererId {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FieldRendererId, T>::value>;
  using DataView = FieldRendererIdDataView;
  using Data_ = internal::FieldRendererId_Data;

  template <typename... Args>
  static FieldRendererIdPtr New(Args&&... args) {
    return FieldRendererIdPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FieldRendererIdPtr From(const U& u) {
    return mojo::TypeConverter<FieldRendererIdPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FieldRendererId>::Convert(*this);
  }


  FieldRendererId();

  explicit FieldRendererId(
      uint64_t id);


  ~FieldRendererId();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FieldRendererIdPtr>
  FieldRendererIdPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FieldRendererId::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FieldRendererId::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FieldRendererId::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FieldRendererId::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FieldRendererId::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FieldRendererId::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FieldRendererId_UnserializedMessageContext<
            UserType, FieldRendererId::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FieldRendererId::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FieldRendererId::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FieldRendererId_UnserializedMessageContext<
            UserType, FieldRendererId::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FieldRendererId::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FieldRendererId::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FieldRendererId::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FieldRendererId::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FieldRendererId::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}












class PLATFORM_EXPORT CustomContextMenuItem {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CustomContextMenuItem, T>::value>;
  using DataView = CustomContextMenuItemDataView;
  using Data_ = internal::CustomContextMenuItem_Data;

  template <typename... Args>
  static CustomContextMenuItemPtr New(Args&&... args) {
    return CustomContextMenuItemPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CustomContextMenuItemPtr From(const U& u) {
    return mojo::TypeConverter<CustomContextMenuItemPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CustomContextMenuItem>::Convert(*this);
  }


  CustomContextMenuItem();

  CustomContextMenuItem(
      const ::blink::String& label,
      AcceleratorPtr accelerator,
      const ::blink::String& icon,
      const ::blink::String& tool_tip,
      CustomContextMenuItemType type,
      int32_t action,
      const ::blink::String& feature_name,
      bool is_experimental_feature,
      bool rtl,
      bool has_directional_override,
      bool enabled,
      bool checked,
      bool force_show_accelerator_for_item,
      ::blink::Vector<CustomContextMenuItemPtr> submenu);

CustomContextMenuItem(const CustomContextMenuItem&) = delete;
CustomContextMenuItem& operator=(const CustomContextMenuItem&) = delete;

  ~CustomContextMenuItem();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CustomContextMenuItemPtr>
  CustomContextMenuItemPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CustomContextMenuItem::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CustomContextMenuItem::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CustomContextMenuItem::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CustomContextMenuItem::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CustomContextMenuItem::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CustomContextMenuItem::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CustomContextMenuItem_UnserializedMessageContext<
            UserType, CustomContextMenuItem::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CustomContextMenuItem::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CustomContextMenuItem::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CustomContextMenuItem_UnserializedMessageContext<
            UserType, CustomContextMenuItem::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CustomContextMenuItem::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String label;
  
  AcceleratorPtr accelerator;
  
  ::blink::String icon;
  
  ::blink::String tool_tip;
  
  CustomContextMenuItemType type;
  
  int32_t action;
  
  ::blink::String feature_name;
  
  bool is_experimental_feature;
  
  bool rtl;
  
  bool has_directional_override;
  
  bool enabled;
  
  bool checked;
  
  bool force_show_accelerator_for_item;
  
  ::blink::Vector<CustomContextMenuItemPtr> submenu;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CustomContextMenuItem::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CustomContextMenuItem::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CustomContextMenuItem::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CustomContextMenuItem::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT UntrustworthyContextMenuParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UntrustworthyContextMenuParams, T>::value>;
  using DataView = UntrustworthyContextMenuParamsDataView;
  using Data_ = internal::UntrustworthyContextMenuParams_Data;

  template <typename... Args>
  static UntrustworthyContextMenuParamsPtr New(Args&&... args) {
    return UntrustworthyContextMenuParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UntrustworthyContextMenuParamsPtr From(const U& u) {
    return mojo::TypeConverter<UntrustworthyContextMenuParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UntrustworthyContextMenuParams>::Convert(*this);
  }


  UntrustworthyContextMenuParams();

  UntrustworthyContextMenuParams(
      ContextMenuDataMediaType media_type,
      int32_t x,
      int32_t y,
      const ::blink::KURL& link_url,
      const ::blink::String& link_text,
      const std::optional<::blink::Impression>& impression,
      const ::blink::KURL& unfiltered_link_url,
      const ::blink::KURL& src_url,
      bool has_image_contents,
      bool is_image_media_plugin_document,
      int32_t media_flags,
      const ::blink::String& selection_text,
      const ::blink::String& title_text,
      const ::blink::String& alt_text,
      const ::blink::String& suggested_filename,
      const ::blink::String& misspelled_word,
      ::blink::Vector<::blink::String> dictionary_suggestions,
      bool spellcheck_enabled,
      bool is_editable,
      int32_t writing_direction_default,
      int32_t writing_direction_left_to_right,
      int32_t writing_direction_right_to_left,
      int32_t edit_flags,
      const ::blink::String& frame_charset,
      ::network::mojom::blink::ReferrerPolicy referrer_policy,
      const ::blink::KURL& link_followed,
      ::blink::Vector<CustomContextMenuItemPtr> custom_items,
      ::ui::mojom::blink::MenuSourceType source_type,
      const ::gfx::Rect& selection_rect,
      int32_t selection_start_offset,
      std::optional<::blink::mojom::blink::AnnotationType> annotation_type,
      bool opened_from_interest_for,
      int32_t interest_for_node_id,
      std::optional<::blink::mojom::blink::FormControlType> form_control_type,
      bool is_content_editable_for_autofill,
      FieldRendererIdPtr field_renderer_id,
      FormRendererIdPtr form_renderer_id);

UntrustworthyContextMenuParams(const UntrustworthyContextMenuParams&) = delete;
UntrustworthyContextMenuParams& operator=(const UntrustworthyContextMenuParams&) = delete;

  ~UntrustworthyContextMenuParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UntrustworthyContextMenuParamsPtr>
  UntrustworthyContextMenuParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UntrustworthyContextMenuParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UntrustworthyContextMenuParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UntrustworthyContextMenuParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UntrustworthyContextMenuParams::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UntrustworthyContextMenuParams::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UntrustworthyContextMenuParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UntrustworthyContextMenuParams_UnserializedMessageContext<
            UserType, UntrustworthyContextMenuParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UntrustworthyContextMenuParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UntrustworthyContextMenuParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UntrustworthyContextMenuParams_UnserializedMessageContext<
            UserType, UntrustworthyContextMenuParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UntrustworthyContextMenuParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ContextMenuDataMediaType media_type;
  
  int32_t x;
  
  int32_t y;
  
  ::blink::KURL link_url;
  
  ::blink::String link_text;
  
  std::optional<::blink::Impression> impression;
  
  ::blink::KURL unfiltered_link_url;
  
  ::blink::KURL src_url;
  
  bool has_image_contents;
  
  bool is_image_media_plugin_document;
  
  int32_t media_flags;
  
  ::blink::String selection_text;
  
  ::blink::String title_text;
  
  ::blink::String alt_text;
  
  ::blink::String suggested_filename;
  
  ::blink::String misspelled_word;
  
  ::blink::Vector<::blink::String> dictionary_suggestions;
  
  bool spellcheck_enabled;
  
  bool is_editable;
  
  int32_t writing_direction_default;
  
  int32_t writing_direction_left_to_right;
  
  int32_t writing_direction_right_to_left;
  
  int32_t edit_flags;
  
  ::blink::String frame_charset;
  
  ::network::mojom::blink::ReferrerPolicy referrer_policy;
  
  ::blink::KURL link_followed;
  
  ::blink::Vector<CustomContextMenuItemPtr> custom_items;
  
  ::ui::mojom::blink::MenuSourceType source_type;
  
  ::gfx::Rect selection_rect;
  
  int32_t selection_start_offset;
  
  std::optional<::blink::mojom::blink::AnnotationType> annotation_type;
  
  bool opened_from_interest_for;
  
  int32_t interest_for_node_id;
  
  std::optional<::blink::mojom::blink::FormControlType> form_control_type;
  
  bool is_content_editable_for_autofill;
  
  FieldRendererIdPtr field_renderer_id;
  
  FormRendererIdPtr form_renderer_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UntrustworthyContextMenuParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UntrustworthyContextMenuParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UntrustworthyContextMenuParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UntrustworthyContextMenuParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AcceleratorPtr Accelerator::Clone() const {
  return New(
      mojo::Clone(key_code),
      mojo::Clone(modifiers)
  );
}

template <typename T, Accelerator::EnableIfSame<T>*>
bool Accelerator::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->key_code, other_struct.key_code))
    return false;
  if (!mojo::Equals(this->modifiers, other_struct.modifiers))
    return false;
  return true;
}

template <typename T, Accelerator::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.key_code < rhs.key_code)
    return true;
  if (rhs.key_code < lhs.key_code)
    return false;
  if (lhs.modifiers < rhs.modifiers)
    return true;
  if (rhs.modifiers < lhs.modifiers)
    return false;
  return false;
}
template <typename StructPtrType>
FormRendererIdPtr FormRendererId::Clone() const {
  return New(
      mojo::Clone(id)
  );
}

template <typename T, FormRendererId::EnableIfSame<T>*>
bool FormRendererId::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  return true;
}

template <typename T, FormRendererId::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  return false;
}
template <typename StructPtrType>
FieldRendererIdPtr FieldRendererId::Clone() const {
  return New(
      mojo::Clone(id)
  );
}

template <typename T, FieldRendererId::EnableIfSame<T>*>
bool FieldRendererId::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  return true;
}

template <typename T, FieldRendererId::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  return false;
}
template <typename StructPtrType>
CustomContextMenuItemPtr CustomContextMenuItem::Clone() const {
  return New(
      mojo::Clone(label),
      mojo::Clone(accelerator),
      mojo::Clone(icon),
      mojo::Clone(tool_tip),
      mojo::Clone(type),
      mojo::Clone(action),
      mojo::Clone(feature_name),
      mojo::Clone(is_experimental_feature),
      mojo::Clone(rtl),
      mojo::Clone(has_directional_override),
      mojo::Clone(enabled),
      mojo::Clone(checked),
      mojo::Clone(force_show_accelerator_for_item),
      mojo::Clone(submenu)
  );
}

template <typename T, CustomContextMenuItem::EnableIfSame<T>*>
bool CustomContextMenuItem::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->label, other_struct.label))
    return false;
  if (!mojo::Equals(this->accelerator, other_struct.accelerator))
    return false;
  if (!mojo::Equals(this->icon, other_struct.icon))
    return false;
  if (!mojo::Equals(this->tool_tip, other_struct.tool_tip))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->action, other_struct.action))
    return false;
  if (!mojo::Equals(this->feature_name, other_struct.feature_name))
    return false;
  if (!mojo::Equals(this->is_experimental_feature, other_struct.is_experimental_feature))
    return false;
  if (!mojo::Equals(this->rtl, other_struct.rtl))
    return false;
  if (!mojo::Equals(this->has_directional_override, other_struct.has_directional_override))
    return false;
  if (!mojo::Equals(this->enabled, other_struct.enabled))
    return false;
  if (!mojo::Equals(this->checked, other_struct.checked))
    return false;
  if (!mojo::Equals(this->force_show_accelerator_for_item, other_struct.force_show_accelerator_for_item))
    return false;
  if (!mojo::Equals(this->submenu, other_struct.submenu))
    return false;
  return true;
}

template <typename T, CustomContextMenuItem::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.label < rhs.label)
    return true;
  if (rhs.label < lhs.label)
    return false;
  if (lhs.accelerator < rhs.accelerator)
    return true;
  if (rhs.accelerator < lhs.accelerator)
    return false;
  if (lhs.icon < rhs.icon)
    return true;
  if (rhs.icon < lhs.icon)
    return false;
  if (lhs.tool_tip < rhs.tool_tip)
    return true;
  if (rhs.tool_tip < lhs.tool_tip)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.action < rhs.action)
    return true;
  if (rhs.action < lhs.action)
    return false;
  if (lhs.feature_name < rhs.feature_name)
    return true;
  if (rhs.feature_name < lhs.feature_name)
    return false;
  if (lhs.is_experimental_feature < rhs.is_experimental_feature)
    return true;
  if (rhs.is_experimental_feature < lhs.is_experimental_feature)
    return false;
  if (lhs.rtl < rhs.rtl)
    return true;
  if (rhs.rtl < lhs.rtl)
    return false;
  if (lhs.has_directional_override < rhs.has_directional_override)
    return true;
  if (rhs.has_directional_override < lhs.has_directional_override)
    return false;
  if (lhs.enabled < rhs.enabled)
    return true;
  if (rhs.enabled < lhs.enabled)
    return false;
  if (lhs.checked < rhs.checked)
    return true;
  if (rhs.checked < lhs.checked)
    return false;
  if (lhs.force_show_accelerator_for_item < rhs.force_show_accelerator_for_item)
    return true;
  if (rhs.force_show_accelerator_for_item < lhs.force_show_accelerator_for_item)
    return false;
  if (lhs.submenu < rhs.submenu)
    return true;
  if (rhs.submenu < lhs.submenu)
    return false;
  return false;
}
template <typename StructPtrType>
UntrustworthyContextMenuParamsPtr UntrustworthyContextMenuParams::Clone() const {
  return New(
      mojo::Clone(media_type),
      mojo::Clone(x),
      mojo::Clone(y),
      mojo::Clone(link_url),
      mojo::Clone(link_text),
      mojo::Clone(impression),
      mojo::Clone(unfiltered_link_url),
      mojo::Clone(src_url),
      mojo::Clone(has_image_contents),
      mojo::Clone(is_image_media_plugin_document),
      mojo::Clone(media_flags),
      mojo::Clone(selection_text),
      mojo::Clone(title_text),
      mojo::Clone(alt_text),
      mojo::Clone(suggested_filename),
      mojo::Clone(misspelled_word),
      mojo::Clone(dictionary_suggestions),
      mojo::Clone(spellcheck_enabled),
      mojo::Clone(is_editable),
      mojo::Clone(writing_direction_default),
      mojo::Clone(writing_direction_left_to_right),
      mojo::Clone(writing_direction_right_to_left),
      mojo::Clone(edit_flags),
      mojo::Clone(frame_charset),
      mojo::Clone(referrer_policy),
      mojo::Clone(link_followed),
      mojo::Clone(custom_items),
      mojo::Clone(source_type),
      mojo::Clone(selection_rect),
      mojo::Clone(selection_start_offset),
      mojo::Clone(annotation_type),
      mojo::Clone(opened_from_interest_for),
      mojo::Clone(interest_for_node_id),
      mojo::Clone(form_control_type),
      mojo::Clone(is_content_editable_for_autofill),
      mojo::Clone(field_renderer_id),
      mojo::Clone(form_renderer_id)
  );
}

template <typename T, UntrustworthyContextMenuParams::EnableIfSame<T>*>
bool UntrustworthyContextMenuParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->media_type, other_struct.media_type))
    return false;
  if (!mojo::Equals(this->x, other_struct.x))
    return false;
  if (!mojo::Equals(this->y, other_struct.y))
    return false;
  if (!mojo::Equals(this->link_url, other_struct.link_url))
    return false;
  if (!mojo::Equals(this->link_text, other_struct.link_text))
    return false;
  if (!mojo::Equals(this->impression, other_struct.impression))
    return false;
  if (!mojo::Equals(this->unfiltered_link_url, other_struct.unfiltered_link_url))
    return false;
  if (!mojo::Equals(this->src_url, other_struct.src_url))
    return false;
  if (!mojo::Equals(this->has_image_contents, other_struct.has_image_contents))
    return false;
  if (!mojo::Equals(this->is_image_media_plugin_document, other_struct.is_image_media_plugin_document))
    return false;
  if (!mojo::Equals(this->media_flags, other_struct.media_flags))
    return false;
  if (!mojo::Equals(this->selection_text, other_struct.selection_text))
    return false;
  if (!mojo::Equals(this->title_text, other_struct.title_text))
    return false;
  if (!mojo::Equals(this->alt_text, other_struct.alt_text))
    return false;
  if (!mojo::Equals(this->suggested_filename, other_struct.suggested_filename))
    return false;
  if (!mojo::Equals(this->misspelled_word, other_struct.misspelled_word))
    return false;
  if (!mojo::Equals(this->dictionary_suggestions, other_struct.dictionary_suggestions))
    return false;
  if (!mojo::Equals(this->spellcheck_enabled, other_struct.spellcheck_enabled))
    return false;
  if (!mojo::Equals(this->is_editable, other_struct.is_editable))
    return false;
  if (!mojo::Equals(this->writing_direction_default, other_struct.writing_direction_default))
    return false;
  if (!mojo::Equals(this->writing_direction_left_to_right, other_struct.writing_direction_left_to_right))
    return false;
  if (!mojo::Equals(this->writing_direction_right_to_left, other_struct.writing_direction_right_to_left))
    return false;
  if (!mojo::Equals(this->edit_flags, other_struct.edit_flags))
    return false;
  if (!mojo::Equals(this->frame_charset, other_struct.frame_charset))
    return false;
  if (!mojo::Equals(this->referrer_policy, other_struct.referrer_policy))
    return false;
  if (!mojo::Equals(this->link_followed, other_struct.link_followed))
    return false;
  if (!mojo::Equals(this->custom_items, other_struct.custom_items))
    return false;
  if (!mojo::Equals(this->source_type, other_struct.source_type))
    return false;
  if (!mojo::Equals(this->selection_rect, other_struct.selection_rect))
    return false;
  if (!mojo::Equals(this->selection_start_offset, other_struct.selection_start_offset))
    return false;
  if (!mojo::Equals(this->annotation_type, other_struct.annotation_type))
    return false;
  if (!mojo::Equals(this->opened_from_interest_for, other_struct.opened_from_interest_for))
    return false;
  if (!mojo::Equals(this->interest_for_node_id, other_struct.interest_for_node_id))
    return false;
  if (!mojo::Equals(this->form_control_type, other_struct.form_control_type))
    return false;
  if (!mojo::Equals(this->is_content_editable_for_autofill, other_struct.is_content_editable_for_autofill))
    return false;
  if (!mojo::Equals(this->field_renderer_id, other_struct.field_renderer_id))
    return false;
  if (!mojo::Equals(this->form_renderer_id, other_struct.form_renderer_id))
    return false;
  return true;
}

template <typename T, UntrustworthyContextMenuParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.media_type < rhs.media_type)
    return true;
  if (rhs.media_type < lhs.media_type)
    return false;
  if (lhs.x < rhs.x)
    return true;
  if (rhs.x < lhs.x)
    return false;
  if (lhs.y < rhs.y)
    return true;
  if (rhs.y < lhs.y)
    return false;
  if (lhs.link_url < rhs.link_url)
    return true;
  if (rhs.link_url < lhs.link_url)
    return false;
  if (lhs.link_text < rhs.link_text)
    return true;
  if (rhs.link_text < lhs.link_text)
    return false;
  if (lhs.impression < rhs.impression)
    return true;
  if (rhs.impression < lhs.impression)
    return false;
  if (lhs.unfiltered_link_url < rhs.unfiltered_link_url)
    return true;
  if (rhs.unfiltered_link_url < lhs.unfiltered_link_url)
    return false;
  if (lhs.src_url < rhs.src_url)
    return true;
  if (rhs.src_url < lhs.src_url)
    return false;
  if (lhs.has_image_contents < rhs.has_image_contents)
    return true;
  if (rhs.has_image_contents < lhs.has_image_contents)
    return false;
  if (lhs.is_image_media_plugin_document < rhs.is_image_media_plugin_document)
    return true;
  if (rhs.is_image_media_plugin_document < lhs.is_image_media_plugin_document)
    return false;
  if (lhs.media_flags < rhs.media_flags)
    return true;
  if (rhs.media_flags < lhs.media_flags)
    return false;
  if (lhs.selection_text < rhs.selection_text)
    return true;
  if (rhs.selection_text < lhs.selection_text)
    return false;
  if (lhs.title_text < rhs.title_text)
    return true;
  if (rhs.title_text < lhs.title_text)
    return false;
  if (lhs.alt_text < rhs.alt_text)
    return true;
  if (rhs.alt_text < lhs.alt_text)
    return false;
  if (lhs.suggested_filename < rhs.suggested_filename)
    return true;
  if (rhs.suggested_filename < lhs.suggested_filename)
    return false;
  if (lhs.misspelled_word < rhs.misspelled_word)
    return true;
  if (rhs.misspelled_word < lhs.misspelled_word)
    return false;
  if (lhs.dictionary_suggestions < rhs.dictionary_suggestions)
    return true;
  if (rhs.dictionary_suggestions < lhs.dictionary_suggestions)
    return false;
  if (lhs.spellcheck_enabled < rhs.spellcheck_enabled)
    return true;
  if (rhs.spellcheck_enabled < lhs.spellcheck_enabled)
    return false;
  if (lhs.is_editable < rhs.is_editable)
    return true;
  if (rhs.is_editable < lhs.is_editable)
    return false;
  if (lhs.writing_direction_default < rhs.writing_direction_default)
    return true;
  if (rhs.writing_direction_default < lhs.writing_direction_default)
    return false;
  if (lhs.writing_direction_left_to_right < rhs.writing_direction_left_to_right)
    return true;
  if (rhs.writing_direction_left_to_right < lhs.writing_direction_left_to_right)
    return false;
  if (lhs.writing_direction_right_to_left < rhs.writing_direction_right_to_left)
    return true;
  if (rhs.writing_direction_right_to_left < lhs.writing_direction_right_to_left)
    return false;
  if (lhs.edit_flags < rhs.edit_flags)
    return true;
  if (rhs.edit_flags < lhs.edit_flags)
    return false;
  if (lhs.frame_charset < rhs.frame_charset)
    return true;
  if (rhs.frame_charset < lhs.frame_charset)
    return false;
  if (lhs.referrer_policy < rhs.referrer_policy)
    return true;
  if (rhs.referrer_policy < lhs.referrer_policy)
    return false;
  if (lhs.link_followed < rhs.link_followed)
    return true;
  if (rhs.link_followed < lhs.link_followed)
    return false;
  if (lhs.custom_items < rhs.custom_items)
    return true;
  if (rhs.custom_items < lhs.custom_items)
    return false;
  if (lhs.source_type < rhs.source_type)
    return true;
  if (rhs.source_type < lhs.source_type)
    return false;
  if (lhs.selection_rect < rhs.selection_rect)
    return true;
  if (rhs.selection_rect < lhs.selection_rect)
    return false;
  if (lhs.selection_start_offset < rhs.selection_start_offset)
    return true;
  if (rhs.selection_start_offset < lhs.selection_start_offset)
    return false;
  if (lhs.annotation_type < rhs.annotation_type)
    return true;
  if (rhs.annotation_type < lhs.annotation_type)
    return false;
  if (lhs.opened_from_interest_for < rhs.opened_from_interest_for)
    return true;
  if (rhs.opened_from_interest_for < lhs.opened_from_interest_for)
    return false;
  if (lhs.interest_for_node_id < rhs.interest_for_node_id)
    return true;
  if (rhs.interest_for_node_id < lhs.interest_for_node_id)
    return false;
  if (lhs.form_control_type < rhs.form_control_type)
    return true;
  if (rhs.form_control_type < lhs.form_control_type)
    return false;
  if (lhs.is_content_editable_for_autofill < rhs.is_content_editable_for_autofill)
    return true;
  if (rhs.is_content_editable_for_autofill < lhs.is_content_editable_for_autofill)
    return false;
  if (lhs.field_renderer_id < rhs.field_renderer_id)
    return true;
  if (rhs.field_renderer_id < lhs.field_renderer_id)
    return false;
  if (lhs.form_renderer_id < rhs.form_renderer_id)
    return true;
  if (rhs.form_renderer_id < lhs.form_renderer_id)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::Accelerator::DataView,
                                         ::blink::mojom::blink::AcceleratorPtr> {
  static bool IsNull(const ::blink::mojom::blink::AcceleratorPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AcceleratorPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::Accelerator::key_code) key_code(
      const ::blink::mojom::blink::AcceleratorPtr& input) {
    return input->key_code;
  }

  static decltype(::blink::mojom::blink::Accelerator::modifiers) modifiers(
      const ::blink::mojom::blink::AcceleratorPtr& input) {
    return input->modifiers;
  }

  static bool Read(::blink::mojom::blink::Accelerator::DataView input, ::blink::mojom::blink::AcceleratorPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::FormRendererId::DataView,
                                         ::blink::mojom::blink::FormRendererIdPtr> {
  static bool IsNull(const ::blink::mojom::blink::FormRendererIdPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::FormRendererIdPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::FormRendererId::id) id(
      const ::blink::mojom::blink::FormRendererIdPtr& input) {
    return input->id;
  }

  static bool Read(::blink::mojom::blink::FormRendererId::DataView input, ::blink::mojom::blink::FormRendererIdPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::FieldRendererId::DataView,
                                         ::blink::mojom::blink::FieldRendererIdPtr> {
  static bool IsNull(const ::blink::mojom::blink::FieldRendererIdPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::FieldRendererIdPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::FieldRendererId::id) id(
      const ::blink::mojom::blink::FieldRendererIdPtr& input) {
    return input->id;
  }

  static bool Read(::blink::mojom::blink::FieldRendererId::DataView input, ::blink::mojom::blink::FieldRendererIdPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::CustomContextMenuItem::DataView,
                                         ::blink::mojom::blink::CustomContextMenuItemPtr> {
  static bool IsNull(const ::blink::mojom::blink::CustomContextMenuItemPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::CustomContextMenuItemPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::CustomContextMenuItem::label)& label(
      const ::blink::mojom::blink::CustomContextMenuItemPtr& input) {
    return input->label;
  }

  static const decltype(::blink::mojom::blink::CustomContextMenuItem::accelerator)& accelerator(
      const ::blink::mojom::blink::CustomContextMenuItemPtr& input) {
    return input->accelerator;
  }

  static const decltype(::blink::mojom::blink::CustomContextMenuItem::icon)& icon(
      const ::blink::mojom::blink::CustomContextMenuItemPtr& input) {
    return input->icon;
  }

  static const decltype(::blink::mojom::blink::CustomContextMenuItem::tool_tip)& tool_tip(
      const ::blink::mojom::blink::CustomContextMenuItemPtr& input) {
    return input->tool_tip;
  }

  static decltype(::blink::mojom::blink::CustomContextMenuItem::type) type(
      const ::blink::mojom::blink::CustomContextMenuItemPtr& input) {
    return input->type;
  }

  static decltype(::blink::mojom::blink::CustomContextMenuItem::action) action(
      const ::blink::mojom::blink::CustomContextMenuItemPtr& input) {
    return input->action;
  }

  static const decltype(::blink::mojom::blink::CustomContextMenuItem::feature_name)& feature_name(
      const ::blink::mojom::blink::CustomContextMenuItemPtr& input) {
    return input->feature_name;
  }

  static decltype(::blink::mojom::blink::CustomContextMenuItem::is_experimental_feature) is_experimental_feature(
      const ::blink::mojom::blink::CustomContextMenuItemPtr& input) {
    return input->is_experimental_feature;
  }

  static decltype(::blink::mojom::blink::CustomContextMenuItem::rtl) rtl(
      const ::blink::mojom::blink::CustomContextMenuItemPtr& input) {
    return input->rtl;
  }

  static decltype(::blink::mojom::blink::CustomContextMenuItem::has_directional_override) has_directional_override(
      const ::blink::mojom::blink::CustomContextMenuItemPtr& input) {
    return input->has_directional_override;
  }

  static decltype(::blink::mojom::blink::CustomContextMenuItem::enabled) enabled(
      const ::blink::mojom::blink::CustomContextMenuItemPtr& input) {
    return input->enabled;
  }

  static decltype(::blink::mojom::blink::CustomContextMenuItem::checked) checked(
      const ::blink::mojom::blink::CustomContextMenuItemPtr& input) {
    return input->checked;
  }

  static decltype(::blink::mojom::blink::CustomContextMenuItem::force_show_accelerator_for_item) force_show_accelerator_for_item(
      const ::blink::mojom::blink::CustomContextMenuItemPtr& input) {
    return input->force_show_accelerator_for_item;
  }

  static const decltype(::blink::mojom::blink::CustomContextMenuItem::submenu)& submenu(
      const ::blink::mojom::blink::CustomContextMenuItemPtr& input) {
    return input->submenu;
  }

  static bool Read(::blink::mojom::blink::CustomContextMenuItem::DataView input, ::blink::mojom::blink::CustomContextMenuItemPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::UntrustworthyContextMenuParams::DataView,
                                         ::blink::mojom::blink::UntrustworthyContextMenuParamsPtr> {
  static bool IsNull(const ::blink::mojom::blink::UntrustworthyContextMenuParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::UntrustworthyContextMenuParamsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::UntrustworthyContextMenuParams::media_type) media_type(
      const ::blink::mojom::blink::UntrustworthyContextMenuParamsPtr& input) {
    return input->media_type;
  }

  static decltype(::blink::mojom::blink::UntrustworthyContextMenuParams::x) x(
      const ::blink::mojom::blink::UntrustworthyContextMenuParamsPtr& input) {
    return input->x;
  }

  static decltype(::blink::mojom::blink::UntrustworthyContextMenuParams::y) y(
      const ::blink::mojom::blink::UntrustworthyContextMenuParamsPtr& input) {
    return input->y;
  }

  static const decltype(::blink::mojom::blink::UntrustworthyContextMenuParams::link_url)& link_url(
      const ::blink::mojom::blink::UntrustworthyContextMenuParamsPtr& input) {
    return input->link_url;
  }

  static const decltype(::blink::mojom::blink::UntrustworthyContextMenuParams::link_text)& link_text(
      const ::blink::mojom::blink::UntrustworthyContextMenuParamsPtr& input) {
    return input->link_text;
  }

  static const decltype(::blink::mojom::blink::UntrustworthyContextMenuParams::impression)& impression(
      const ::blink::mojom::blink::UntrustworthyContextMenuParamsPtr& input) {
    return input->impression;
  }

  static const decltype(::blink::mojom::blink::UntrustworthyContextMenuParams::unfiltered_link_url)& unfiltered_link_url(
      const ::blink::mojom::blink::UntrustworthyContextMenuParamsPtr& input) {
    return input->unfiltered_link_url;
  }

  static const decltype(::blink::mojom::blink::UntrustworthyContextMenuParams::src_url)& src_url(
      const ::blink::mojom::blink::UntrustworthyContextMenuParamsPtr& input) {
    return input->src_url;
  }

  static decltype(::blink::mojom::blink::UntrustworthyContextMenuParams::has_image_contents) has_image_contents(
      const ::blink::mojom::blink::UntrustworthyContextMenuParamsPtr& input) {
    return input->has_image_contents;
  }

  static decltype(::blink::mojom::blink::UntrustworthyContextMenuParams::is_image_media_plugin_document) is_image_media_plugin_document(
      const ::blink::mojom::blink::UntrustworthyContextMenuParamsPtr& input) {
    return input->is_image_media_plugin_document;
  }

  static decltype(::blink::mojom::blink::UntrustworthyContextMenuParams::media_flags) media_flags(
      const ::blink::mojom::blink::UntrustworthyContextMenuParamsPtr& input) {
    return input->media_flags;
  }

  static const decltype(::blink::mojom::blink::UntrustworthyContextMenuParams::selection_text)& selection_text(
      const ::blink::mojom::blink::UntrustworthyContextMenuParamsPtr& input) {
    return input->selection_text;
  }

  static const decltype(::blink::mojom::blink::UntrustworthyContextMenuParams::title_text)& title_text(
      const ::blink::mojom::blink::UntrustworthyContextMenuParamsPtr& input) {
    return input->title_text;
  }

  static const decltype(::blink::mojom::blink::UntrustworthyContextMenuParams::alt_text)& alt_text(
      const ::blink::mojom::blink::UntrustworthyContextMenuParamsPtr& input) {
    return input->alt_text;
  }

  static const decltype(::blink::mojom::blink::UntrustworthyContextMenuParams::suggested_filename)& suggested_filename(
      const ::blink::mojom::blink::UntrustworthyContextMenuParamsPtr& input) {
    return input->suggested_filename;
  }

  static const decltype(::blink::mojom::blink::UntrustworthyContextMenuParams::misspelled_word)& misspelled_word(
      const ::blink::mojom::blink::UntrustworthyContextMenuParamsPtr& input) {
    return input->misspelled_word;
  }

  static const decltype(::blink::mojom::blink::UntrustworthyContextMenuParams::dictionary_suggestions)& dictionary_suggestions(
      const ::blink::mojom::blink::UntrustworthyContextMenuParamsPtr& input) {
    return input->dictionary_suggestions;
  }

  static decltype(::blink::mojom::blink::UntrustworthyContextMenuParams::spellcheck_enabled) spellcheck_enabled(
      const ::blink::mojom::blink::UntrustworthyContextMenuParamsPtr& input) {
    return input->spellcheck_enabled;
  }

  static decltype(::blink::mojom::blink::UntrustworthyContextMenuParams::is_editable) is_editable(
      const ::blink::mojom::blink::UntrustworthyContextMenuParamsPtr& input) {
    return input->is_editable;
  }

  static decltype(::blink::mojom::blink::UntrustworthyContextMenuParams::writing_direction_default) writing_direction_default(
      const ::blink::mojom::blink::UntrustworthyContextMenuParamsPtr& input) {
    return input->writing_direction_default;
  }

  static decltype(::blink::mojom::blink::UntrustworthyContextMenuParams::writing_direction_left_to_right) writing_direction_left_to_right(
      const ::blink::mojom::blink::UntrustworthyContextMenuParamsPtr& input) {
    return input->writing_direction_left_to_right;
  }

  static decltype(::blink::mojom::blink::UntrustworthyContextMenuParams::writing_direction_right_to_left) writing_direction_right_to_left(
      const ::blink::mojom::blink::UntrustworthyContextMenuParamsPtr& input) {
    return input->writing_direction_right_to_left;
  }

  static decltype(::blink::mojom::blink::UntrustworthyContextMenuParams::edit_flags) edit_flags(
      const ::blink::mojom::blink::UntrustworthyContextMenuParamsPtr& input) {
    return input->edit_flags;
  }

  static const decltype(::blink::mojom::blink::UntrustworthyContextMenuParams::frame_charset)& frame_charset(
      const ::blink::mojom::blink::UntrustworthyContextMenuParamsPtr& input) {
    return input->frame_charset;
  }

  static decltype(::blink::mojom::blink::UntrustworthyContextMenuParams::referrer_policy) referrer_policy(
      const ::blink::mojom::blink::UntrustworthyContextMenuParamsPtr& input) {
    return input->referrer_policy;
  }

  static const decltype(::blink::mojom::blink::UntrustworthyContextMenuParams::link_followed)& link_followed(
      const ::blink::mojom::blink::UntrustworthyContextMenuParamsPtr& input) {
    return input->link_followed;
  }

  static const decltype(::blink::mojom::blink::UntrustworthyContextMenuParams::custom_items)& custom_items(
      const ::blink::mojom::blink::UntrustworthyContextMenuParamsPtr& input) {
    return input->custom_items;
  }

  static decltype(::blink::mojom::blink::UntrustworthyContextMenuParams::source_type) source_type(
      const ::blink::mojom::blink::UntrustworthyContextMenuParamsPtr& input) {
    return input->source_type;
  }

  static const decltype(::blink::mojom::blink::UntrustworthyContextMenuParams::selection_rect)& selection_rect(
      const ::blink::mojom::blink::UntrustworthyContextMenuParamsPtr& input) {
    return input->selection_rect;
  }

  static decltype(::blink::mojom::blink::UntrustworthyContextMenuParams::selection_start_offset) selection_start_offset(
      const ::blink::mojom::blink::UntrustworthyContextMenuParamsPtr& input) {
    return input->selection_start_offset;
  }

  static decltype(::blink::mojom::blink::UntrustworthyContextMenuParams::annotation_type) annotation_type(
      const ::blink::mojom::blink::UntrustworthyContextMenuParamsPtr& input) {
    return input->annotation_type;
  }

  static decltype(::blink::mojom::blink::UntrustworthyContextMenuParams::opened_from_interest_for) opened_from_interest_for(
      const ::blink::mojom::blink::UntrustworthyContextMenuParamsPtr& input) {
    return input->opened_from_interest_for;
  }

  static decltype(::blink::mojom::blink::UntrustworthyContextMenuParams::interest_for_node_id) interest_for_node_id(
      const ::blink::mojom::blink::UntrustworthyContextMenuParamsPtr& input) {
    return input->interest_for_node_id;
  }

  static decltype(::blink::mojom::blink::UntrustworthyContextMenuParams::form_control_type) form_control_type(
      const ::blink::mojom::blink::UntrustworthyContextMenuParamsPtr& input) {
    return input->form_control_type;
  }

  static decltype(::blink::mojom::blink::UntrustworthyContextMenuParams::is_content_editable_for_autofill) is_content_editable_for_autofill(
      const ::blink::mojom::blink::UntrustworthyContextMenuParamsPtr& input) {
    return input->is_content_editable_for_autofill;
  }

  static const decltype(::blink::mojom::blink::UntrustworthyContextMenuParams::field_renderer_id)& field_renderer_id(
      const ::blink::mojom::blink::UntrustworthyContextMenuParamsPtr& input) {
    return input->field_renderer_id;
  }

  static const decltype(::blink::mojom::blink::UntrustworthyContextMenuParams::form_renderer_id)& form_renderer_id(
      const ::blink::mojom::blink::UntrustworthyContextMenuParamsPtr& input) {
    return input->form_renderer_id;
  }

  static bool Read(::blink::mojom::blink::UntrustworthyContextMenuParams::DataView input, ::blink::mojom::blink::UntrustworthyContextMenuParamsPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTEXT_MENU_CONTEXT_MENU_MOJOM_BLINK_H_