// third_party/blink/public/mojom/content_extraction/inner_text.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/content_extraction/inner_text.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var tokens$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/tokens/tokens.mojom', '../tokens/tokens.mojom.js');
  }


  var NodeLocationType = {};
  NodeLocationType.kStart = 0;
  NodeLocationType.MIN_VALUE = 0;
  NodeLocationType.MAX_VALUE = 0;

  NodeLocationType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
      return true;
    }
    return false;
  };

  NodeLocationType.toKnownEnumValue = function(value) {
    return value;
  };

  NodeLocationType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function InnerTextFrame(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InnerTextFrame.prototype.initDefaults_ = function() {
    this.token = null;
    this.segments = null;
  };
  InnerTextFrame.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InnerTextFrame.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InnerTextFrame.token
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, tokens$.LocalFrameToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InnerTextFrame.segments
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 16, InnerTextSegment, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InnerTextFrame.encodedSize = codec.kStructHeaderSize + 16;

  InnerTextFrame.decode = function(decoder) {
    var packed;
    var val = new InnerTextFrame();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.token =
        decoder.decodeStructPointer(tokens$.LocalFrameToken);
    val.segments =
        decoder.decodeArrayPointer(InnerTextSegment);
    return val;
  };

  InnerTextFrame.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InnerTextFrame.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(tokens$.LocalFrameToken, val.token);
    encoder.encodeArrayPointer(InnerTextSegment, val.segments);
  };
  function InnerTextParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InnerTextParams.prototype.initDefaults_ = function() {
    this.node_id_$flag = false;
    this.max_words_per_aggregate_passage_$flag = false;
    this.greedily_aggregate_sibling_nodes_$flag = false;
    this.greedily_aggregate_sibling_nodes_$value = false;
    this.min_words_per_passage_$flag = false;
    this.node_id_$value = 0;
    this.max_words_per_aggregate_passage_$value = 0;
    this.maxPassages = 0;
    this.min_words_per_passage_$value = 0;
  };
  InnerTextParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InnerTextParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;










    return validator.validationError.NONE;
  };

  InnerTextParams.encodedSize = codec.kStructHeaderSize + 24;

  InnerTextParams.decode = function(decoder) {
    var packed;
    var val = new InnerTextParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.node_id_$flag = (packed >> 0) & 1 ? true : false;
    val.max_words_per_aggregate_passage_$flag = (packed >> 1) & 1 ? true : false;
    val.greedily_aggregate_sibling_nodes_$flag = (packed >> 2) & 1 ? true : false;
    val.greedily_aggregate_sibling_nodes_$value = (packed >> 3) & 1 ? true : false;
    val.min_words_per_passage_$flag = (packed >> 4) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.node_id_$value =
        decoder.decodeStruct(codec.Int32);
    val.max_words_per_aggregate_passage_$value =
        decoder.decodeStruct(codec.Uint32);
    val.maxPassages =
        decoder.decodeStruct(codec.Uint32);
    val.min_words_per_passage_$value =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  InnerTextParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InnerTextParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.node_id_$flag & 1) << 0
    packed |= (val.max_words_per_aggregate_passage_$flag & 1) << 1
    packed |= (val.greedily_aggregate_sibling_nodes_$flag & 1) << 2
    packed |= (val.greedily_aggregate_sibling_nodes_$value & 1) << 3
    packed |= (val.min_words_per_passage_$flag & 1) << 4
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.node_id_$value);
    encoder.encodeStruct(codec.Uint32, val.max_words_per_aggregate_passage_$value);
    encoder.encodeStruct(codec.Uint32, val.maxPassages);
    encoder.encodeStruct(codec.Uint32, val.min_words_per_passage_$value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function InnerTextAgent_GetInnerText_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InnerTextAgent_GetInnerText_Params.prototype.initDefaults_ = function() {
    this.params = null;
  };
  InnerTextAgent_GetInnerText_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InnerTextAgent_GetInnerText_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InnerTextAgent_GetInnerText_Params.params
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, InnerTextParams, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InnerTextAgent_GetInnerText_Params.encodedSize = codec.kStructHeaderSize + 8;

  InnerTextAgent_GetInnerText_Params.decode = function(decoder) {
    var packed;
    var val = new InnerTextAgent_GetInnerText_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.params =
        decoder.decodeStructPointer(InnerTextParams);
    return val;
  };

  InnerTextAgent_GetInnerText_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InnerTextAgent_GetInnerText_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(InnerTextParams, val.params);
  };
  function InnerTextAgent_GetInnerText_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InnerTextAgent_GetInnerText_ResponseParams.prototype.initDefaults_ = function() {
    this.frame = null;
  };
  InnerTextAgent_GetInnerText_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InnerTextAgent_GetInnerText_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InnerTextAgent_GetInnerText_ResponseParams.frame
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, InnerTextFrame, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InnerTextAgent_GetInnerText_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  InnerTextAgent_GetInnerText_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new InnerTextAgent_GetInnerText_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.frame =
        decoder.decodeStructPointer(InnerTextFrame);
    return val;
  };

  InnerTextAgent_GetInnerText_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InnerTextAgent_GetInnerText_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(InnerTextFrame, val.frame);
  };

  function InnerTextSegment(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  InnerTextSegment.Tags = {
    nodeLocation: 0,
    text: 1,
    frame: 2,
  };

  InnerTextSegment.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  InnerTextSegment.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "nodeLocation",
        "text",
        "frame",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a InnerTextSegment member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(InnerTextSegment.prototype, "nodeLocation", {
    get: function() {
      if (this.$tag != InnerTextSegment.Tags.nodeLocation) {
        throw new ReferenceError(
            "InnerTextSegment.nodeLocation is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = InnerTextSegment.Tags.nodeLocation;
      this.$data = value;
    }
  });
  Object.defineProperty(InnerTextSegment.prototype, "text", {
    get: function() {
      if (this.$tag != InnerTextSegment.Tags.text) {
        throw new ReferenceError(
            "InnerTextSegment.text is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = InnerTextSegment.Tags.text;
      this.$data = value;
    }
  });
  Object.defineProperty(InnerTextSegment.prototype, "frame", {
    get: function() {
      if (this.$tag != InnerTextSegment.Tags.frame) {
        throw new ReferenceError(
            "InnerTextSegment.frame is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = InnerTextSegment.Tags.frame;
      this.$data = value;
    }
  });


    InnerTextSegment.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case InnerTextSegment.Tags.nodeLocation:
          encoder.encodeStruct(codec.Int32, val.nodeLocation);
          break;
        case InnerTextSegment.Tags.text:
          encoder.encodeStruct(codec.String, val.text);
          break;
        case InnerTextSegment.Tags.frame:
          encoder.encodeStructPointer(InnerTextFrame, val.frame);
          break;
      }
      encoder.align();
    };


    InnerTextSegment.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new InnerTextSegment();
      var tag = decoder.readUint32();
      switch (tag) {
        case InnerTextSegment.Tags.nodeLocation:
          result.nodeLocation = decoder.decodeStruct(new codec.Enum(NodeLocationType));
          break;
        case InnerTextSegment.Tags.text:
          result.text = decoder.decodeStruct(codec.String);
          break;
        case InnerTextSegment.Tags.frame:
          result.frame = decoder.decodeStructPointer(InnerTextFrame);
          break;
      }
      decoder.align();

      return result;
    };


    InnerTextSegment.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case InnerTextSegment.Tags.nodeLocation:
          

    // validate InnerTextSegment.nodeLocation
    err = messageValidator.validateEnum(data_offset, NodeLocationType);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case InnerTextSegment.Tags.text:
          

    // validate InnerTextSegment.text
    err = messageValidator.validateStringPointer(data_offset, false)
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case InnerTextSegment.Tags.frame:
          

    // validate InnerTextSegment.frame
    err = messageValidator.validateStructPointer(data_offset, InnerTextFrame, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  InnerTextSegment.encodedSize = 16;
  var kInnerTextAgent_GetInnerText_Name = 0;

  function InnerTextAgentPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(InnerTextAgent,
                                                   handleOrPtrInfo);
  }

  function InnerTextAgentAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        InnerTextAgent, associatedInterfacePtrInfo);
  }

  InnerTextAgentAssociatedPtr.prototype =
      Object.create(InnerTextAgentPtr.prototype);
  InnerTextAgentAssociatedPtr.prototype.constructor =
      InnerTextAgentAssociatedPtr;

  function InnerTextAgentProxy(receiver) {
    this.receiver_ = receiver;
  }
  InnerTextAgentPtr.prototype.getInnerText = function() {
    return InnerTextAgentProxy.prototype.getInnerText
        .apply(this.ptr.getProxy(), arguments);
  };

  InnerTextAgentProxy.prototype.getInnerText = function(params) {
    var params_ = new InnerTextAgent_GetInnerText_Params();
    params_.params = params;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kInnerTextAgent_GetInnerText_Name,
          codec.align(InnerTextAgent_GetInnerText_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(InnerTextAgent_GetInnerText_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(InnerTextAgent_GetInnerText_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function InnerTextAgentStub(delegate) {
    this.delegate_ = delegate;
  }
  InnerTextAgentStub.prototype.getInnerText = function(params) {
    return this.delegate_ && this.delegate_.getInnerText && this.delegate_.getInnerText(params);
  }

  InnerTextAgentStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  InnerTextAgentStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kInnerTextAgent_GetInnerText_Name:
      var params = reader.decodeStruct(InnerTextAgent_GetInnerText_Params);
      this.getInnerText(params.params).then(function(response) {
        var responseParams =
            new InnerTextAgent_GetInnerText_ResponseParams();
        responseParams.frame = response.frame;
        var builder = new codec.MessageV1Builder(
            kInnerTextAgent_GetInnerText_Name,
            codec.align(InnerTextAgent_GetInnerText_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(InnerTextAgent_GetInnerText_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateInnerTextAgentRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kInnerTextAgent_GetInnerText_Name:
        if (message.expectsResponse())
          paramsClass = InnerTextAgent_GetInnerText_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateInnerTextAgentResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kInnerTextAgent_GetInnerText_Name:
        if (message.isResponse())
          paramsClass = InnerTextAgent_GetInnerText_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var InnerTextAgent = {
    name: 'blink.mojom.InnerTextAgent',
    kVersion: 0,
    ptrClass: InnerTextAgentPtr,
    proxyClass: InnerTextAgentProxy,
    stubClass: InnerTextAgentStub,
    validateRequest: validateInnerTextAgentRequest,
    validateResponse: validateInnerTextAgentResponse,
  };
  InnerTextAgentStub.prototype.validator = validateInnerTextAgentRequest;
  InnerTextAgentProxy.prototype.validator = validateInnerTextAgentResponse;
  exports.NodeLocationType = NodeLocationType;
  exports.InnerTextFrame = InnerTextFrame;
  exports.InnerTextParams = InnerTextParams;
  exports.InnerTextSegment = InnerTextSegment;
  exports.InnerTextAgent = InnerTextAgent;
  exports.InnerTextAgentPtr = InnerTextAgentPtr;
  exports.InnerTextAgentAssociatedPtr = InnerTextAgentAssociatedPtr;
})();