// third_party/blink/public/mojom/content_extraction/inner_text.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_EXTRACTION_INNER_TEXT_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_EXTRACTION_INNER_TEXT_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/content_extraction/inner_text.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"


namespace blink::mojom {
class InnerTextFrameDataView;

class InnerTextParamsDataView;

class InnerTextSegmentDataView;


}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::InnerTextFrameDataView> {
  using Data = ::blink::mojom::internal::InnerTextFrame_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::InnerTextParamsDataView> {
  using Data = ::blink::mojom::internal::InnerTextParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::InnerTextSegmentDataView> {
  using Data = ::blink::mojom::internal::InnerTextSegment_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class NodeLocationType : int32_t {
  
  kStart = 0,
  kMinValue = 0,
  kMaxValue = 0,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, NodeLocationType value);
inline bool IsKnownEnumValue(NodeLocationType value) {
  return internal::NodeLocationType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class InnerTextAgentInterfaceBase {};

using InnerTextAgentPtrDataView =
    mojo::InterfacePtrDataView<InnerTextAgentInterfaceBase>;
using InnerTextAgentRequestDataView =
    mojo::InterfaceRequestDataView<InnerTextAgentInterfaceBase>;
using InnerTextAgentAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<InnerTextAgentInterfaceBase>;
using InnerTextAgentAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<InnerTextAgentInterfaceBase>;


class InnerTextFrameDataView {
 public:
  InnerTextFrameDataView() = default;

  InnerTextFrameDataView(
      internal::InnerTextFrame_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTokenDataView(
      ::blink::mojom::LocalFrameTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadToken(UserType* output) {
    
    auto* pointer = data_->token.Get();
    return mojo::internal::Deserialize<::blink::mojom::LocalFrameTokenDataView>(
        pointer, output, message_);
  }
  inline void GetSegmentsDataView(
      mojo::ArrayDataView<InnerTextSegmentDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSegments(UserType* output) {
    
    auto* pointer = data_->segments.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::InnerTextSegmentDataView>>(
        pointer, output, message_);
  }
 private:
  internal::InnerTextFrame_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class InnerTextParamsDataView {
 public:
  InnerTextParamsDataView() = default;

  InnerTextParamsDataView(
      internal::InnerTextParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  std::optional<int32_t> node_id() const {

    return data_->node_id_$flag
        ? std::make_optional(data_->node_id_$value)
        : std::nullopt;
  }
  std::optional<uint32_t> max_words_per_aggregate_passage() const {

    return data_->max_words_per_aggregate_passage_$flag
        ? std::make_optional(data_->max_words_per_aggregate_passage_$value)
        : std::nullopt;
  }
  std::optional<bool> greedily_aggregate_sibling_nodes() const {

    return data_->greedily_aggregate_sibling_nodes_$flag
        ? std::make_optional(!!data_->greedily_aggregate_sibling_nodes_$value)
        : std::nullopt;
  }
  uint32_t max_passages() const {
    return data_->max_passages;
  }
  std::optional<uint32_t> min_words_per_passage() const {

    return data_->min_words_per_passage_$flag
        ? std::make_optional(data_->min_words_per_passage_$value)
        : std::nullopt;
  }
 private:
  internal::InnerTextParams_Data* data_ = nullptr;
};


class InnerTextSegmentDataView {
 public:
  using Tag = internal::InnerTextSegment_Data::InnerTextSegment_Tag;

  InnerTextSegmentDataView() = default;

  InnerTextSegmentDataView(
      internal::InnerTextSegment_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_node_location() const { return data_->tag == Tag::kNodeLocation; }
  template <typename UserType>
  [[nodiscard]] bool ReadNodeLocation(UserType* output) const {
    CHECK(is_node_location());
    return mojo::internal::Deserialize<::blink::mojom::NodeLocationType>(
        data_->data.f_node_location, output);
  }
  NodeLocationType node_location() const {
    CHECK(is_node_location());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::NodeLocationType>(data_->data.f_node_location));
  }
  bool is_text() const { return data_->tag == Tag::kText; }
  inline void GetTextDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadText(UserType* output) const {
    
    CHECK(is_text());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_text.Get(), output, message_);
  }
  bool is_frame() const { return data_->tag == Tag::kFrame; }
  inline void GetFrameDataView(
      InnerTextFrameDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFrame(UserType* output) const {
    
    CHECK(is_frame());
    return mojo::internal::Deserialize<::blink::mojom::InnerTextFrameDataView>(
        data_->data.f_frame.Get(), output, message_);
  }

 private:
  internal::InnerTextSegment_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_EXTRACTION_INNER_TEXT_MOJOM_DATA_VIEW_H_