// third_party/blink/public/mojom/clipboard/clipboard.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/clipboard/clipboard.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var big_buffer$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/big_buffer.mojom', '../../../../../mojo/public/mojom/base/big_buffer.mojom.js');
  }
  var big_string$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/big_string.mojom', '../../../../../mojo/public/mojom/base/big_string.mojom.js');
  }
  var int128$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/int128.mojom', '../../../../../mojo/public/mojom/base/int128.mojom.js');
  }
  var string16$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/string16.mojom', '../../../../../mojo/public/mojom/base/string16.mojom.js');
  }
  var bitmap$ =
      mojo.internal.exposeNamespace('skia.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'skia/public/mojom/bitmap.mojom', '../../../../../skia/public/mojom/bitmap.mojom.js');
  }
  var data_transfer$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/data_transfer/data_transfer.mojom', '../data_transfer/data_transfer.mojom.js');
  }
  var tokens$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/tokens/tokens.mojom', '../tokens/tokens.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }


  var ClipboardFormat = {};
  ClipboardFormat.kPlaintext = 0;
  ClipboardFormat.kHtml = 1;
  ClipboardFormat.kSmartPaste = 2;
  ClipboardFormat.kBookmark = 3;
  ClipboardFormat.MIN_VALUE = 0;
  ClipboardFormat.MAX_VALUE = 3;

  ClipboardFormat.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  ClipboardFormat.toKnownEnumValue = function(value) {
    return value;
  };

  ClipboardFormat.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var ClipboardBuffer = {};
  ClipboardBuffer.kStandard = 0;
  ClipboardBuffer.kSelection = 1;
  ClipboardBuffer.MIN_VALUE = 0;
  ClipboardBuffer.MAX_VALUE = 1;

  ClipboardBuffer.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  ClipboardBuffer.toKnownEnumValue = function(value) {
    return value;
  };

  ClipboardBuffer.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var PlatformClipboardPermissionState = {};
  PlatformClipboardPermissionState.kAllow = 0;
  PlatformClipboardPermissionState.kAsk = 1;
  PlatformClipboardPermissionState.kDeny = 2;
  PlatformClipboardPermissionState.MIN_VALUE = 0;
  PlatformClipboardPermissionState.MAX_VALUE = 2;

  PlatformClipboardPermissionState.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  PlatformClipboardPermissionState.toKnownEnumValue = function(value) {
    return value;
  };

  PlatformClipboardPermissionState.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function ClipboardFiles(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardFiles.prototype.initDefaults_ = function() {
    this.files = null;
    this.fileSystemId = null;
  };
  ClipboardFiles.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardFiles.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClipboardFiles.files
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(data_transfer$.DataTransferFile), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClipboardFiles.fileSystemId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClipboardFiles.encodedSize = codec.kStructHeaderSize + 16;

  ClipboardFiles.decode = function(decoder) {
    var packed;
    var val = new ClipboardFiles();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.files =
        decoder.decodeArrayPointer(new codec.PointerTo(data_transfer$.DataTransferFile));
    val.fileSystemId =
        decoder.decodeStruct(codec.String);
    return val;
  };

  ClipboardFiles.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardFiles.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(data_transfer$.DataTransferFile), val.files);
    encoder.encodeStruct(codec.String, val.fileSystemId);
  };
  function ClipboardListener_OnClipboardDataChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardListener_OnClipboardDataChanged_Params.prototype.initDefaults_ = function() {
  };
  ClipboardListener_OnClipboardDataChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardListener_OnClipboardDataChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClipboardListener_OnClipboardDataChanged_Params.encodedSize = codec.kStructHeaderSize + 0;

  ClipboardListener_OnClipboardDataChanged_Params.decode = function(decoder) {
    var packed;
    var val = new ClipboardListener_OnClipboardDataChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ClipboardListener_OnClipboardDataChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardListener_OnClipboardDataChanged_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function ClipboardHost_GetSequenceNumber_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_GetSequenceNumber_Params.prototype.initDefaults_ = function() {
    this.buffer = 0;
  };
  ClipboardHost_GetSequenceNumber_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_GetSequenceNumber_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClipboardHost_GetSequenceNumber_Params.buffer
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, ClipboardBuffer);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClipboardHost_GetSequenceNumber_Params.encodedSize = codec.kStructHeaderSize + 8;

  ClipboardHost_GetSequenceNumber_Params.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_GetSequenceNumber_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.buffer =
        decoder.decodeStruct(new codec.Enum(ClipboardBuffer));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ClipboardHost_GetSequenceNumber_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_GetSequenceNumber_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.buffer);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ClipboardHost_GetSequenceNumber_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_GetSequenceNumber_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  ClipboardHost_GetSequenceNumber_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_GetSequenceNumber_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClipboardHost_GetSequenceNumber_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, int128$.Uint128, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClipboardHost_GetSequenceNumber_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ClipboardHost_GetSequenceNumber_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_GetSequenceNumber_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(int128$.Uint128);
    return val;
  };

  ClipboardHost_GetSequenceNumber_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_GetSequenceNumber_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(int128$.Uint128, val.result);
  };
  function ClipboardHost_IsFormatAvailable_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_IsFormatAvailable_Params.prototype.initDefaults_ = function() {
    this.format = 0;
    this.buffer = 0;
  };
  ClipboardHost_IsFormatAvailable_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_IsFormatAvailable_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClipboardHost_IsFormatAvailable_Params.format
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, ClipboardFormat);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClipboardHost_IsFormatAvailable_Params.buffer
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, ClipboardBuffer);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClipboardHost_IsFormatAvailable_Params.encodedSize = codec.kStructHeaderSize + 8;

  ClipboardHost_IsFormatAvailable_Params.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_IsFormatAvailable_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.format =
        decoder.decodeStruct(new codec.Enum(ClipboardFormat));
    val.buffer =
        decoder.decodeStruct(new codec.Enum(ClipboardBuffer));
    return val;
  };

  ClipboardHost_IsFormatAvailable_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_IsFormatAvailable_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.format);
    encoder.encodeStruct(codec.Int32, val.buffer);
  };
  function ClipboardHost_IsFormatAvailable_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_IsFormatAvailable_ResponseParams.prototype.initDefaults_ = function() {
    this.result = false;
  };
  ClipboardHost_IsFormatAvailable_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_IsFormatAvailable_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ClipboardHost_IsFormatAvailable_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ClipboardHost_IsFormatAvailable_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_IsFormatAvailable_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.result = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ClipboardHost_IsFormatAvailable_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_IsFormatAvailable_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.result & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ClipboardHost_ReadAvailableTypes_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_ReadAvailableTypes_Params.prototype.initDefaults_ = function() {
    this.buffer = 0;
  };
  ClipboardHost_ReadAvailableTypes_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_ReadAvailableTypes_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClipboardHost_ReadAvailableTypes_Params.buffer
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, ClipboardBuffer);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClipboardHost_ReadAvailableTypes_Params.encodedSize = codec.kStructHeaderSize + 8;

  ClipboardHost_ReadAvailableTypes_Params.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_ReadAvailableTypes_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.buffer =
        decoder.decodeStruct(new codec.Enum(ClipboardBuffer));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ClipboardHost_ReadAvailableTypes_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_ReadAvailableTypes_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.buffer);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ClipboardHost_ReadAvailableTypes_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_ReadAvailableTypes_ResponseParams.prototype.initDefaults_ = function() {
    this.types = null;
  };
  ClipboardHost_ReadAvailableTypes_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_ReadAvailableTypes_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClipboardHost_ReadAvailableTypes_ResponseParams.types
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(string16$.String16), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClipboardHost_ReadAvailableTypes_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ClipboardHost_ReadAvailableTypes_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_ReadAvailableTypes_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.types =
        decoder.decodeArrayPointer(new codec.PointerTo(string16$.String16));
    return val;
  };

  ClipboardHost_ReadAvailableTypes_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_ReadAvailableTypes_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(string16$.String16), val.types);
  };
  function ClipboardHost_ReadText_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_ReadText_Params.prototype.initDefaults_ = function() {
    this.buffer = 0;
  };
  ClipboardHost_ReadText_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_ReadText_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClipboardHost_ReadText_Params.buffer
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, ClipboardBuffer);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClipboardHost_ReadText_Params.encodedSize = codec.kStructHeaderSize + 8;

  ClipboardHost_ReadText_Params.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_ReadText_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.buffer =
        decoder.decodeStruct(new codec.Enum(ClipboardBuffer));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ClipboardHost_ReadText_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_ReadText_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.buffer);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ClipboardHost_ReadText_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_ReadText_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  ClipboardHost_ReadText_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_ReadText_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClipboardHost_ReadText_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.BigString16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClipboardHost_ReadText_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ClipboardHost_ReadText_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_ReadText_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(string16$.BigString16);
    return val;
  };

  ClipboardHost_ReadText_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_ReadText_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.BigString16, val.result);
  };
  function ClipboardHost_ReadHtml_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_ReadHtml_Params.prototype.initDefaults_ = function() {
    this.buffer = 0;
  };
  ClipboardHost_ReadHtml_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_ReadHtml_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClipboardHost_ReadHtml_Params.buffer
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, ClipboardBuffer);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClipboardHost_ReadHtml_Params.encodedSize = codec.kStructHeaderSize + 8;

  ClipboardHost_ReadHtml_Params.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_ReadHtml_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.buffer =
        decoder.decodeStruct(new codec.Enum(ClipboardBuffer));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ClipboardHost_ReadHtml_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_ReadHtml_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.buffer);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ClipboardHost_ReadHtml_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_ReadHtml_ResponseParams.prototype.initDefaults_ = function() {
    this.markup = null;
    this.url = null;
    this.fragmentStart = 0;
    this.fragmentEnd = 0;
  };
  ClipboardHost_ReadHtml_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_ReadHtml_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClipboardHost_ReadHtml_ResponseParams.markup
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.BigString16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClipboardHost_ReadHtml_ResponseParams.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ClipboardHost_ReadHtml_ResponseParams.encodedSize = codec.kStructHeaderSize + 24;

  ClipboardHost_ReadHtml_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_ReadHtml_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.markup =
        decoder.decodeStructPointer(string16$.BigString16);
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.fragmentStart =
        decoder.decodeStruct(codec.Uint32);
    val.fragmentEnd =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  ClipboardHost_ReadHtml_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_ReadHtml_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.BigString16, val.markup);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStruct(codec.Uint32, val.fragmentStart);
    encoder.encodeStruct(codec.Uint32, val.fragmentEnd);
  };
  function ClipboardHost_ReadSvg_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_ReadSvg_Params.prototype.initDefaults_ = function() {
    this.buffer = 0;
  };
  ClipboardHost_ReadSvg_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_ReadSvg_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClipboardHost_ReadSvg_Params.buffer
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, ClipboardBuffer);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClipboardHost_ReadSvg_Params.encodedSize = codec.kStructHeaderSize + 8;

  ClipboardHost_ReadSvg_Params.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_ReadSvg_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.buffer =
        decoder.decodeStruct(new codec.Enum(ClipboardBuffer));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ClipboardHost_ReadSvg_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_ReadSvg_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.buffer);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ClipboardHost_ReadSvg_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_ReadSvg_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  ClipboardHost_ReadSvg_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_ReadSvg_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClipboardHost_ReadSvg_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.BigString16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClipboardHost_ReadSvg_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ClipboardHost_ReadSvg_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_ReadSvg_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(string16$.BigString16);
    return val;
  };

  ClipboardHost_ReadSvg_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_ReadSvg_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.BigString16, val.result);
  };
  function ClipboardHost_ReadRtf_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_ReadRtf_Params.prototype.initDefaults_ = function() {
    this.buffer = 0;
  };
  ClipboardHost_ReadRtf_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_ReadRtf_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClipboardHost_ReadRtf_Params.buffer
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, ClipboardBuffer);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClipboardHost_ReadRtf_Params.encodedSize = codec.kStructHeaderSize + 8;

  ClipboardHost_ReadRtf_Params.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_ReadRtf_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.buffer =
        decoder.decodeStruct(new codec.Enum(ClipboardBuffer));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ClipboardHost_ReadRtf_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_ReadRtf_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.buffer);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ClipboardHost_ReadRtf_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_ReadRtf_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  ClipboardHost_ReadRtf_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_ReadRtf_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClipboardHost_ReadRtf_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, big_string$.BigString, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClipboardHost_ReadRtf_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ClipboardHost_ReadRtf_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_ReadRtf_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(big_string$.BigString);
    return val;
  };

  ClipboardHost_ReadRtf_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_ReadRtf_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(big_string$.BigString, val.result);
  };
  function ClipboardHost_ReadPng_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_ReadPng_Params.prototype.initDefaults_ = function() {
    this.buffer = 0;
  };
  ClipboardHost_ReadPng_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_ReadPng_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClipboardHost_ReadPng_Params.buffer
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, ClipboardBuffer);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClipboardHost_ReadPng_Params.encodedSize = codec.kStructHeaderSize + 8;

  ClipboardHost_ReadPng_Params.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_ReadPng_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.buffer =
        decoder.decodeStruct(new codec.Enum(ClipboardBuffer));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ClipboardHost_ReadPng_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_ReadPng_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.buffer);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ClipboardHost_ReadPng_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_ReadPng_ResponseParams.prototype.initDefaults_ = function() {
    this.png = null;
  };
  ClipboardHost_ReadPng_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_ReadPng_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClipboardHost_ReadPng_ResponseParams.png
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, big_buffer$.BigBuffer, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClipboardHost_ReadPng_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  ClipboardHost_ReadPng_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_ReadPng_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.png =
        decoder.decodeStruct(big_buffer$.BigBuffer);
    return val;
  };

  ClipboardHost_ReadPng_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_ReadPng_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(big_buffer$.BigBuffer, val.png);
  };
  function ClipboardHost_ReadFiles_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_ReadFiles_Params.prototype.initDefaults_ = function() {
    this.buffer = 0;
  };
  ClipboardHost_ReadFiles_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_ReadFiles_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClipboardHost_ReadFiles_Params.buffer
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, ClipboardBuffer);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClipboardHost_ReadFiles_Params.encodedSize = codec.kStructHeaderSize + 8;

  ClipboardHost_ReadFiles_Params.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_ReadFiles_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.buffer =
        decoder.decodeStruct(new codec.Enum(ClipboardBuffer));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ClipboardHost_ReadFiles_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_ReadFiles_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.buffer);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ClipboardHost_ReadFiles_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_ReadFiles_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  ClipboardHost_ReadFiles_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_ReadFiles_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClipboardHost_ReadFiles_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ClipboardFiles, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClipboardHost_ReadFiles_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ClipboardHost_ReadFiles_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_ReadFiles_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(ClipboardFiles);
    return val;
  };

  ClipboardHost_ReadFiles_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_ReadFiles_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ClipboardFiles, val.result);
  };
  function ClipboardHost_ReadDataTransferCustomData_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_ReadDataTransferCustomData_Params.prototype.initDefaults_ = function() {
    this.buffer = 0;
    this.type = null;
  };
  ClipboardHost_ReadDataTransferCustomData_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_ReadDataTransferCustomData_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClipboardHost_ReadDataTransferCustomData_Params.buffer
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, ClipboardBuffer);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClipboardHost_ReadDataTransferCustomData_Params.type
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClipboardHost_ReadDataTransferCustomData_Params.encodedSize = codec.kStructHeaderSize + 16;

  ClipboardHost_ReadDataTransferCustomData_Params.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_ReadDataTransferCustomData_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.buffer =
        decoder.decodeStruct(new codec.Enum(ClipboardBuffer));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.type =
        decoder.decodeStructPointer(string16$.String16);
    return val;
  };

  ClipboardHost_ReadDataTransferCustomData_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_ReadDataTransferCustomData_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.buffer);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(string16$.String16, val.type);
  };
  function ClipboardHost_ReadDataTransferCustomData_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_ReadDataTransferCustomData_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  ClipboardHost_ReadDataTransferCustomData_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_ReadDataTransferCustomData_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClipboardHost_ReadDataTransferCustomData_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.BigString16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClipboardHost_ReadDataTransferCustomData_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ClipboardHost_ReadDataTransferCustomData_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_ReadDataTransferCustomData_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(string16$.BigString16);
    return val;
  };

  ClipboardHost_ReadDataTransferCustomData_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_ReadDataTransferCustomData_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.BigString16, val.result);
  };
  function ClipboardHost_ReadAvailableCustomAndStandardFormats_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_ReadAvailableCustomAndStandardFormats_Params.prototype.initDefaults_ = function() {
  };
  ClipboardHost_ReadAvailableCustomAndStandardFormats_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_ReadAvailableCustomAndStandardFormats_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClipboardHost_ReadAvailableCustomAndStandardFormats_Params.encodedSize = codec.kStructHeaderSize + 0;

  ClipboardHost_ReadAvailableCustomAndStandardFormats_Params.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_ReadAvailableCustomAndStandardFormats_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ClipboardHost_ReadAvailableCustomAndStandardFormats_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_ReadAvailableCustomAndStandardFormats_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParams.prototype.initDefaults_ = function() {
    this.formatTypes = null;
  };
  ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParams.formatTypes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(string16$.String16), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.formatTypes =
        decoder.decodeArrayPointer(new codec.PointerTo(string16$.String16));
    return val;
  };

  ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(string16$.String16), val.formatTypes);
  };
  function ClipboardHost_ReadUnsanitizedCustomFormat_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_ReadUnsanitizedCustomFormat_Params.prototype.initDefaults_ = function() {
    this.format = null;
  };
  ClipboardHost_ReadUnsanitizedCustomFormat_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_ReadUnsanitizedCustomFormat_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClipboardHost_ReadUnsanitizedCustomFormat_Params.format
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClipboardHost_ReadUnsanitizedCustomFormat_Params.encodedSize = codec.kStructHeaderSize + 8;

  ClipboardHost_ReadUnsanitizedCustomFormat_Params.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_ReadUnsanitizedCustomFormat_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.format =
        decoder.decodeStructPointer(string16$.String16);
    return val;
  };

  ClipboardHost_ReadUnsanitizedCustomFormat_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_ReadUnsanitizedCustomFormat_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.String16, val.format);
  };
  function ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParams.prototype.initDefaults_ = function() {
    this.data = null;
  };
  ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParams.data
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, big_buffer$.BigBuffer, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.data =
        decoder.decodeStruct(big_buffer$.BigBuffer);
    return val;
  };

  ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(big_buffer$.BigBuffer, val.data);
  };
  function ClipboardHost_WriteText_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_WriteText_Params.prototype.initDefaults_ = function() {
    this.text = null;
  };
  ClipboardHost_WriteText_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_WriteText_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClipboardHost_WriteText_Params.text
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.BigString16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClipboardHost_WriteText_Params.encodedSize = codec.kStructHeaderSize + 8;

  ClipboardHost_WriteText_Params.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_WriteText_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.text =
        decoder.decodeStructPointer(string16$.BigString16);
    return val;
  };

  ClipboardHost_WriteText_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_WriteText_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.BigString16, val.text);
  };
  function ClipboardHost_WriteHtml_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_WriteHtml_Params.prototype.initDefaults_ = function() {
    this.markup = null;
    this.url = null;
  };
  ClipboardHost_WriteHtml_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_WriteHtml_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClipboardHost_WriteHtml_Params.markup
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.BigString16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClipboardHost_WriteHtml_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClipboardHost_WriteHtml_Params.encodedSize = codec.kStructHeaderSize + 16;

  ClipboardHost_WriteHtml_Params.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_WriteHtml_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.markup =
        decoder.decodeStructPointer(string16$.BigString16);
    val.url =
        decoder.decodeStructPointer(url$.Url);
    return val;
  };

  ClipboardHost_WriteHtml_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_WriteHtml_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.BigString16, val.markup);
    encoder.encodeStructPointer(url$.Url, val.url);
  };
  function ClipboardHost_WriteSvg_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_WriteSvg_Params.prototype.initDefaults_ = function() {
    this.markup = null;
  };
  ClipboardHost_WriteSvg_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_WriteSvg_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClipboardHost_WriteSvg_Params.markup
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.BigString16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClipboardHost_WriteSvg_Params.encodedSize = codec.kStructHeaderSize + 8;

  ClipboardHost_WriteSvg_Params.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_WriteSvg_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.markup =
        decoder.decodeStructPointer(string16$.BigString16);
    return val;
  };

  ClipboardHost_WriteSvg_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_WriteSvg_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.BigString16, val.markup);
  };
  function ClipboardHost_WriteSmartPasteMarker_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_WriteSmartPasteMarker_Params.prototype.initDefaults_ = function() {
  };
  ClipboardHost_WriteSmartPasteMarker_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_WriteSmartPasteMarker_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClipboardHost_WriteSmartPasteMarker_Params.encodedSize = codec.kStructHeaderSize + 0;

  ClipboardHost_WriteSmartPasteMarker_Params.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_WriteSmartPasteMarker_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ClipboardHost_WriteSmartPasteMarker_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_WriteSmartPasteMarker_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function ClipboardHost_WriteDataTransferCustomData_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_WriteDataTransferCustomData_Params.prototype.initDefaults_ = function() {
    this.data = null;
  };
  ClipboardHost_WriteDataTransferCustomData_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_WriteDataTransferCustomData_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClipboardHost_WriteDataTransferCustomData_Params.data
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, false, new codec.PointerTo(string16$.String16), new codec.PointerTo(string16$.BigString16), false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClipboardHost_WriteDataTransferCustomData_Params.encodedSize = codec.kStructHeaderSize + 8;

  ClipboardHost_WriteDataTransferCustomData_Params.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_WriteDataTransferCustomData_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.data =
        decoder.decodeMapPointer(new codec.PointerTo(string16$.String16), new codec.PointerTo(string16$.BigString16));
    return val;
  };

  ClipboardHost_WriteDataTransferCustomData_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_WriteDataTransferCustomData_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(new codec.PointerTo(string16$.String16), new codec.PointerTo(string16$.BigString16), val.data);
  };
  function ClipboardHost_WriteBookmark_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_WriteBookmark_Params.prototype.initDefaults_ = function() {
    this.url = null;
    this.title = null;
  };
  ClipboardHost_WriteBookmark_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_WriteBookmark_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClipboardHost_WriteBookmark_Params.url
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClipboardHost_WriteBookmark_Params.title
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClipboardHost_WriteBookmark_Params.encodedSize = codec.kStructHeaderSize + 16;

  ClipboardHost_WriteBookmark_Params.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_WriteBookmark_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStruct(codec.String);
    val.title =
        decoder.decodeStructPointer(string16$.String16);
    return val;
  };

  ClipboardHost_WriteBookmark_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_WriteBookmark_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.url);
    encoder.encodeStructPointer(string16$.String16, val.title);
  };
  function ClipboardHost_WriteImage_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_WriteImage_Params.prototype.initDefaults_ = function() {
    this.image = null;
  };
  ClipboardHost_WriteImage_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_WriteImage_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClipboardHost_WriteImage_Params.image
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, bitmap$.BitmapN32, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClipboardHost_WriteImage_Params.encodedSize = codec.kStructHeaderSize + 8;

  ClipboardHost_WriteImage_Params.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_WriteImage_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.image =
        decoder.decodeStructPointer(bitmap$.BitmapN32);
    return val;
  };

  ClipboardHost_WriteImage_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_WriteImage_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(bitmap$.BitmapN32, val.image);
  };
  function ClipboardHost_WriteUnsanitizedCustomFormat_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_WriteUnsanitizedCustomFormat_Params.prototype.initDefaults_ = function() {
    this.format = null;
    this.data = null;
  };
  ClipboardHost_WriteUnsanitizedCustomFormat_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_WriteUnsanitizedCustomFormat_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClipboardHost_WriteUnsanitizedCustomFormat_Params.format
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClipboardHost_WriteUnsanitizedCustomFormat_Params.data
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 8, big_buffer$.BigBuffer, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClipboardHost_WriteUnsanitizedCustomFormat_Params.encodedSize = codec.kStructHeaderSize + 24;

  ClipboardHost_WriteUnsanitizedCustomFormat_Params.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_WriteUnsanitizedCustomFormat_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.format =
        decoder.decodeStructPointer(string16$.String16);
    val.data =
        decoder.decodeStruct(big_buffer$.BigBuffer);
    return val;
  };

  ClipboardHost_WriteUnsanitizedCustomFormat_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_WriteUnsanitizedCustomFormat_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.String16, val.format);
    encoder.encodeStruct(big_buffer$.BigBuffer, val.data);
  };
  function ClipboardHost_CommitWrite_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_CommitWrite_Params.prototype.initDefaults_ = function() {
  };
  ClipboardHost_CommitWrite_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_CommitWrite_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClipboardHost_CommitWrite_Params.encodedSize = codec.kStructHeaderSize + 0;

  ClipboardHost_CommitWrite_Params.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_CommitWrite_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ClipboardHost_CommitWrite_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_CommitWrite_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function ClipboardHost_BeginCopyWithCompletion_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_BeginCopyWithCompletion_Params.prototype.initDefaults_ = function() {
    this.token = 0;
  };
  ClipboardHost_BeginCopyWithCompletion_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_BeginCopyWithCompletion_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ClipboardHost_BeginCopyWithCompletion_Params.encodedSize = codec.kStructHeaderSize + 8;

  ClipboardHost_BeginCopyWithCompletion_Params.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_BeginCopyWithCompletion_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.token =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ClipboardHost_BeginCopyWithCompletion_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_BeginCopyWithCompletion_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.token);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ClipboardHost_EndCopyWithCompletion_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_EndCopyWithCompletion_Params.prototype.initDefaults_ = function() {
    this.token = 0;
  };
  ClipboardHost_EndCopyWithCompletion_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_EndCopyWithCompletion_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ClipboardHost_EndCopyWithCompletion_Params.encodedSize = codec.kStructHeaderSize + 8;

  ClipboardHost_EndCopyWithCompletion_Params.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_EndCopyWithCompletion_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.token =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ClipboardHost_EndCopyWithCompletion_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_EndCopyWithCompletion_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.token);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ClipboardHost_EndCopyWithCompletion_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_EndCopyWithCompletion_ResponseParams.prototype.initDefaults_ = function() {
    this.token = 0;
  };
  ClipboardHost_EndCopyWithCompletion_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_EndCopyWithCompletion_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ClipboardHost_EndCopyWithCompletion_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ClipboardHost_EndCopyWithCompletion_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_EndCopyWithCompletion_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.token =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ClipboardHost_EndCopyWithCompletion_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_EndCopyWithCompletion_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.token);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ClipboardHost_BeginPasteWithCompletion_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_BeginPasteWithCompletion_Params.prototype.initDefaults_ = function() {
    this.token = 0;
  };
  ClipboardHost_BeginPasteWithCompletion_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_BeginPasteWithCompletion_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ClipboardHost_BeginPasteWithCompletion_Params.encodedSize = codec.kStructHeaderSize + 8;

  ClipboardHost_BeginPasteWithCompletion_Params.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_BeginPasteWithCompletion_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.token =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ClipboardHost_BeginPasteWithCompletion_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_BeginPasteWithCompletion_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.token);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ClipboardHost_EndPasteWithCompletion_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_EndPasteWithCompletion_Params.prototype.initDefaults_ = function() {
    this.token = 0;
  };
  ClipboardHost_EndPasteWithCompletion_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_EndPasteWithCompletion_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ClipboardHost_EndPasteWithCompletion_Params.encodedSize = codec.kStructHeaderSize + 8;

  ClipboardHost_EndPasteWithCompletion_Params.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_EndPasteWithCompletion_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.token =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ClipboardHost_EndPasteWithCompletion_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_EndPasteWithCompletion_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.token);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ClipboardHost_EndPasteWithCompletion_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_EndPasteWithCompletion_ResponseParams.prototype.initDefaults_ = function() {
    this.token = 0;
  };
  ClipboardHost_EndPasteWithCompletion_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_EndPasteWithCompletion_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ClipboardHost_EndPasteWithCompletion_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ClipboardHost_EndPasteWithCompletion_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_EndPasteWithCompletion_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.token =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ClipboardHost_EndPasteWithCompletion_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_EndPasteWithCompletion_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.token);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ClipboardHost_WriteStringToFindPboard_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_WriteStringToFindPboard_Params.prototype.initDefaults_ = function() {
    this.text = null;
  };
  ClipboardHost_WriteStringToFindPboard_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_WriteStringToFindPboard_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClipboardHost_WriteStringToFindPboard_Params.text
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClipboardHost_WriteStringToFindPboard_Params.encodedSize = codec.kStructHeaderSize + 8;

  ClipboardHost_WriteStringToFindPboard_Params.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_WriteStringToFindPboard_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.text =
        decoder.decodeStructPointer(string16$.String16);
    return val;
  };

  ClipboardHost_WriteStringToFindPboard_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_WriteStringToFindPboard_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.String16, val.text);
  };
  function ClipboardHost_GetPlatformPermissionState_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_GetPlatformPermissionState_Params.prototype.initDefaults_ = function() {
  };
  ClipboardHost_GetPlatformPermissionState_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_GetPlatformPermissionState_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClipboardHost_GetPlatformPermissionState_Params.encodedSize = codec.kStructHeaderSize + 0;

  ClipboardHost_GetPlatformPermissionState_Params.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_GetPlatformPermissionState_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ClipboardHost_GetPlatformPermissionState_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_GetPlatformPermissionState_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function ClipboardHost_GetPlatformPermissionState_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_GetPlatformPermissionState_ResponseParams.prototype.initDefaults_ = function() {
    this.state = 0;
  };
  ClipboardHost_GetPlatformPermissionState_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_GetPlatformPermissionState_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClipboardHost_GetPlatformPermissionState_ResponseParams.state
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, PlatformClipboardPermissionState);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClipboardHost_GetPlatformPermissionState_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ClipboardHost_GetPlatformPermissionState_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_GetPlatformPermissionState_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.state =
        decoder.decodeStruct(new codec.Enum(PlatformClipboardPermissionState));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ClipboardHost_GetPlatformPermissionState_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_GetPlatformPermissionState_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.state);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ClipboardHost_RegisterClipboardListener_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ClipboardHost_RegisterClipboardListener_Params.prototype.initDefaults_ = function() {
    this.listener = new ClipboardListenerPtr();
  };
  ClipboardHost_RegisterClipboardListener_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ClipboardHost_RegisterClipboardListener_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ClipboardHost_RegisterClipboardListener_Params.listener
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ClipboardHost_RegisterClipboardListener_Params.encodedSize = codec.kStructHeaderSize + 8;

  ClipboardHost_RegisterClipboardListener_Params.decode = function(decoder) {
    var packed;
    var val = new ClipboardHost_RegisterClipboardListener_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.listener =
        decoder.decodeStruct(new codec.Interface(ClipboardListenerPtr));
    return val;
  };

  ClipboardHost_RegisterClipboardListener_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ClipboardHost_RegisterClipboardListener_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(ClipboardListenerPtr), val.listener);
  };
  var kClipboardListener_OnClipboardDataChanged_Name = 0;

  function ClipboardListenerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(ClipboardListener,
                                                   handleOrPtrInfo);
  }

  function ClipboardListenerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        ClipboardListener, associatedInterfacePtrInfo);
  }

  ClipboardListenerAssociatedPtr.prototype =
      Object.create(ClipboardListenerPtr.prototype);
  ClipboardListenerAssociatedPtr.prototype.constructor =
      ClipboardListenerAssociatedPtr;

  function ClipboardListenerProxy(receiver) {
    this.receiver_ = receiver;
  }
  ClipboardListenerPtr.prototype.onClipboardDataChanged = function() {
    return ClipboardListenerProxy.prototype.onClipboardDataChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  ClipboardListenerProxy.prototype.onClipboardDataChanged = function() {
    var params_ = new ClipboardListener_OnClipboardDataChanged_Params();
    var builder = new codec.MessageV0Builder(
        kClipboardListener_OnClipboardDataChanged_Name,
        codec.align(ClipboardListener_OnClipboardDataChanged_Params.encodedSize));
    builder.encodeStruct(ClipboardListener_OnClipboardDataChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function ClipboardListenerStub(delegate) {
    this.delegate_ = delegate;
  }
  ClipboardListenerStub.prototype.onClipboardDataChanged = function() {
    return this.delegate_ && this.delegate_.onClipboardDataChanged && this.delegate_.onClipboardDataChanged();
  }

  ClipboardListenerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kClipboardListener_OnClipboardDataChanged_Name:
      var params = reader.decodeStruct(ClipboardListener_OnClipboardDataChanged_Params);
      this.onClipboardDataChanged();
      return true;
    default:
      return false;
    }
  };

  ClipboardListenerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateClipboardListenerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kClipboardListener_OnClipboardDataChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ClipboardListener_OnClipboardDataChanged_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateClipboardListenerResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var ClipboardListener = {
    name: 'blink.mojom.ClipboardListener',
    kVersion: 0,
    ptrClass: ClipboardListenerPtr,
    proxyClass: ClipboardListenerProxy,
    stubClass: ClipboardListenerStub,
    validateRequest: validateClipboardListenerRequest,
    validateResponse: null,
  };
  ClipboardListenerStub.prototype.validator = validateClipboardListenerRequest;
  ClipboardListenerProxy.prototype.validator = null;
  var kClipboardHost_GetSequenceNumber_Name = 0;
  var kClipboardHost_IsFormatAvailable_Name = 1;
  var kClipboardHost_ReadAvailableTypes_Name = 2;
  var kClipboardHost_ReadText_Name = 3;
  var kClipboardHost_ReadHtml_Name = 4;
  var kClipboardHost_ReadSvg_Name = 5;
  var kClipboardHost_ReadRtf_Name = 6;
  var kClipboardHost_ReadPng_Name = 7;
  var kClipboardHost_ReadFiles_Name = 8;
  var kClipboardHost_ReadDataTransferCustomData_Name = 9;
  var kClipboardHost_ReadAvailableCustomAndStandardFormats_Name = 10;
  var kClipboardHost_ReadUnsanitizedCustomFormat_Name = 11;
  var kClipboardHost_WriteText_Name = 12;
  var kClipboardHost_WriteHtml_Name = 13;
  var kClipboardHost_WriteSvg_Name = 14;
  var kClipboardHost_WriteSmartPasteMarker_Name = 15;
  var kClipboardHost_WriteDataTransferCustomData_Name = 16;
  var kClipboardHost_WriteBookmark_Name = 17;
  var kClipboardHost_WriteImage_Name = 18;
  var kClipboardHost_WriteUnsanitizedCustomFormat_Name = 19;
  var kClipboardHost_CommitWrite_Name = 20;
  var kClipboardHost_BeginCopyWithCompletion_Name = 21;
  var kClipboardHost_EndCopyWithCompletion_Name = 22;
  var kClipboardHost_BeginPasteWithCompletion_Name = 23;
  var kClipboardHost_EndPasteWithCompletion_Name = 24;
  var kClipboardHost_WriteStringToFindPboard_Name = 25;
  var kClipboardHost_GetPlatformPermissionState_Name = 26;
  var kClipboardHost_RegisterClipboardListener_Name = 27;

  function ClipboardHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(ClipboardHost,
                                                   handleOrPtrInfo);
  }

  function ClipboardHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        ClipboardHost, associatedInterfacePtrInfo);
  }

  ClipboardHostAssociatedPtr.prototype =
      Object.create(ClipboardHostPtr.prototype);
  ClipboardHostAssociatedPtr.prototype.constructor =
      ClipboardHostAssociatedPtr;

  function ClipboardHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  ClipboardHostPtr.prototype.getSequenceNumber = function() {
    return ClipboardHostProxy.prototype.getSequenceNumber
        .apply(this.ptr.getProxy(), arguments);
  };

  ClipboardHostProxy.prototype.getSequenceNumber = function(buffer) {
    var params_ = new ClipboardHost_GetSequenceNumber_Params();
    params_.buffer = buffer;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kClipboardHost_GetSequenceNumber_Name,
          codec.align(ClipboardHost_GetSequenceNumber_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ClipboardHost_GetSequenceNumber_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ClipboardHost_GetSequenceNumber_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ClipboardHostPtr.prototype.isFormatAvailable = function() {
    return ClipboardHostProxy.prototype.isFormatAvailable
        .apply(this.ptr.getProxy(), arguments);
  };

  ClipboardHostProxy.prototype.isFormatAvailable = function(format, buffer) {
    var params_ = new ClipboardHost_IsFormatAvailable_Params();
    params_.format = format;
    params_.buffer = buffer;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kClipboardHost_IsFormatAvailable_Name,
          codec.align(ClipboardHost_IsFormatAvailable_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ClipboardHost_IsFormatAvailable_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ClipboardHost_IsFormatAvailable_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ClipboardHostPtr.prototype.readAvailableTypes = function() {
    return ClipboardHostProxy.prototype.readAvailableTypes
        .apply(this.ptr.getProxy(), arguments);
  };

  ClipboardHostProxy.prototype.readAvailableTypes = function(buffer) {
    var params_ = new ClipboardHost_ReadAvailableTypes_Params();
    params_.buffer = buffer;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kClipboardHost_ReadAvailableTypes_Name,
          codec.align(ClipboardHost_ReadAvailableTypes_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ClipboardHost_ReadAvailableTypes_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ClipboardHost_ReadAvailableTypes_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ClipboardHostPtr.prototype.readText = function() {
    return ClipboardHostProxy.prototype.readText
        .apply(this.ptr.getProxy(), arguments);
  };

  ClipboardHostProxy.prototype.readText = function(buffer) {
    var params_ = new ClipboardHost_ReadText_Params();
    params_.buffer = buffer;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kClipboardHost_ReadText_Name,
          codec.align(ClipboardHost_ReadText_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ClipboardHost_ReadText_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ClipboardHost_ReadText_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ClipboardHostPtr.prototype.readHtml = function() {
    return ClipboardHostProxy.prototype.readHtml
        .apply(this.ptr.getProxy(), arguments);
  };

  ClipboardHostProxy.prototype.readHtml = function(buffer) {
    var params_ = new ClipboardHost_ReadHtml_Params();
    params_.buffer = buffer;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kClipboardHost_ReadHtml_Name,
          codec.align(ClipboardHost_ReadHtml_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ClipboardHost_ReadHtml_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ClipboardHost_ReadHtml_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ClipboardHostPtr.prototype.readSvg = function() {
    return ClipboardHostProxy.prototype.readSvg
        .apply(this.ptr.getProxy(), arguments);
  };

  ClipboardHostProxy.prototype.readSvg = function(buffer) {
    var params_ = new ClipboardHost_ReadSvg_Params();
    params_.buffer = buffer;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kClipboardHost_ReadSvg_Name,
          codec.align(ClipboardHost_ReadSvg_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ClipboardHost_ReadSvg_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ClipboardHost_ReadSvg_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ClipboardHostPtr.prototype.readRtf = function() {
    return ClipboardHostProxy.prototype.readRtf
        .apply(this.ptr.getProxy(), arguments);
  };

  ClipboardHostProxy.prototype.readRtf = function(buffer) {
    var params_ = new ClipboardHost_ReadRtf_Params();
    params_.buffer = buffer;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kClipboardHost_ReadRtf_Name,
          codec.align(ClipboardHost_ReadRtf_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ClipboardHost_ReadRtf_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ClipboardHost_ReadRtf_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ClipboardHostPtr.prototype.readPng = function() {
    return ClipboardHostProxy.prototype.readPng
        .apply(this.ptr.getProxy(), arguments);
  };

  ClipboardHostProxy.prototype.readPng = function(buffer) {
    var params_ = new ClipboardHost_ReadPng_Params();
    params_.buffer = buffer;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kClipboardHost_ReadPng_Name,
          codec.align(ClipboardHost_ReadPng_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ClipboardHost_ReadPng_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ClipboardHost_ReadPng_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ClipboardHostPtr.prototype.readFiles = function() {
    return ClipboardHostProxy.prototype.readFiles
        .apply(this.ptr.getProxy(), arguments);
  };

  ClipboardHostProxy.prototype.readFiles = function(buffer) {
    var params_ = new ClipboardHost_ReadFiles_Params();
    params_.buffer = buffer;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kClipboardHost_ReadFiles_Name,
          codec.align(ClipboardHost_ReadFiles_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ClipboardHost_ReadFiles_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ClipboardHost_ReadFiles_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ClipboardHostPtr.prototype.readDataTransferCustomData = function() {
    return ClipboardHostProxy.prototype.readDataTransferCustomData
        .apply(this.ptr.getProxy(), arguments);
  };

  ClipboardHostProxy.prototype.readDataTransferCustomData = function(buffer, type) {
    var params_ = new ClipboardHost_ReadDataTransferCustomData_Params();
    params_.buffer = buffer;
    params_.type = type;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kClipboardHost_ReadDataTransferCustomData_Name,
          codec.align(ClipboardHost_ReadDataTransferCustomData_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ClipboardHost_ReadDataTransferCustomData_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ClipboardHost_ReadDataTransferCustomData_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ClipboardHostPtr.prototype.readAvailableCustomAndStandardFormats = function() {
    return ClipboardHostProxy.prototype.readAvailableCustomAndStandardFormats
        .apply(this.ptr.getProxy(), arguments);
  };

  ClipboardHostProxy.prototype.readAvailableCustomAndStandardFormats = function() {
    var params_ = new ClipboardHost_ReadAvailableCustomAndStandardFormats_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kClipboardHost_ReadAvailableCustomAndStandardFormats_Name,
          codec.align(ClipboardHost_ReadAvailableCustomAndStandardFormats_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ClipboardHost_ReadAvailableCustomAndStandardFormats_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ClipboardHostPtr.prototype.readUnsanitizedCustomFormat = function() {
    return ClipboardHostProxy.prototype.readUnsanitizedCustomFormat
        .apply(this.ptr.getProxy(), arguments);
  };

  ClipboardHostProxy.prototype.readUnsanitizedCustomFormat = function(format) {
    var params_ = new ClipboardHost_ReadUnsanitizedCustomFormat_Params();
    params_.format = format;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kClipboardHost_ReadUnsanitizedCustomFormat_Name,
          codec.align(ClipboardHost_ReadUnsanitizedCustomFormat_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ClipboardHost_ReadUnsanitizedCustomFormat_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ClipboardHostPtr.prototype.writeText = function() {
    return ClipboardHostProxy.prototype.writeText
        .apply(this.ptr.getProxy(), arguments);
  };

  ClipboardHostProxy.prototype.writeText = function(text) {
    var params_ = new ClipboardHost_WriteText_Params();
    params_.text = text;
    var builder = new codec.MessageV0Builder(
        kClipboardHost_WriteText_Name,
        codec.align(ClipboardHost_WriteText_Params.encodedSize));
    builder.encodeStruct(ClipboardHost_WriteText_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ClipboardHostPtr.prototype.writeHtml = function() {
    return ClipboardHostProxy.prototype.writeHtml
        .apply(this.ptr.getProxy(), arguments);
  };

  ClipboardHostProxy.prototype.writeHtml = function(markup, url) {
    var params_ = new ClipboardHost_WriteHtml_Params();
    params_.markup = markup;
    params_.url = url;
    var builder = new codec.MessageV0Builder(
        kClipboardHost_WriteHtml_Name,
        codec.align(ClipboardHost_WriteHtml_Params.encodedSize));
    builder.encodeStruct(ClipboardHost_WriteHtml_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ClipboardHostPtr.prototype.writeSvg = function() {
    return ClipboardHostProxy.prototype.writeSvg
        .apply(this.ptr.getProxy(), arguments);
  };

  ClipboardHostProxy.prototype.writeSvg = function(markup) {
    var params_ = new ClipboardHost_WriteSvg_Params();
    params_.markup = markup;
    var builder = new codec.MessageV0Builder(
        kClipboardHost_WriteSvg_Name,
        codec.align(ClipboardHost_WriteSvg_Params.encodedSize));
    builder.encodeStruct(ClipboardHost_WriteSvg_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ClipboardHostPtr.prototype.writeSmartPasteMarker = function() {
    return ClipboardHostProxy.prototype.writeSmartPasteMarker
        .apply(this.ptr.getProxy(), arguments);
  };

  ClipboardHostProxy.prototype.writeSmartPasteMarker = function() {
    var params_ = new ClipboardHost_WriteSmartPasteMarker_Params();
    var builder = new codec.MessageV0Builder(
        kClipboardHost_WriteSmartPasteMarker_Name,
        codec.align(ClipboardHost_WriteSmartPasteMarker_Params.encodedSize));
    builder.encodeStruct(ClipboardHost_WriteSmartPasteMarker_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ClipboardHostPtr.prototype.writeDataTransferCustomData = function() {
    return ClipboardHostProxy.prototype.writeDataTransferCustomData
        .apply(this.ptr.getProxy(), arguments);
  };

  ClipboardHostProxy.prototype.writeDataTransferCustomData = function(data) {
    var params_ = new ClipboardHost_WriteDataTransferCustomData_Params();
    params_.data = data;
    var builder = new codec.MessageV0Builder(
        kClipboardHost_WriteDataTransferCustomData_Name,
        codec.align(ClipboardHost_WriteDataTransferCustomData_Params.encodedSize));
    builder.encodeStruct(ClipboardHost_WriteDataTransferCustomData_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ClipboardHostPtr.prototype.writeBookmark = function() {
    return ClipboardHostProxy.prototype.writeBookmark
        .apply(this.ptr.getProxy(), arguments);
  };

  ClipboardHostProxy.prototype.writeBookmark = function(url, title) {
    var params_ = new ClipboardHost_WriteBookmark_Params();
    params_.url = url;
    params_.title = title;
    var builder = new codec.MessageV0Builder(
        kClipboardHost_WriteBookmark_Name,
        codec.align(ClipboardHost_WriteBookmark_Params.encodedSize));
    builder.encodeStruct(ClipboardHost_WriteBookmark_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ClipboardHostPtr.prototype.writeImage = function() {
    return ClipboardHostProxy.prototype.writeImage
        .apply(this.ptr.getProxy(), arguments);
  };

  ClipboardHostProxy.prototype.writeImage = function(image) {
    var params_ = new ClipboardHost_WriteImage_Params();
    params_.image = image;
    var builder = new codec.MessageV0Builder(
        kClipboardHost_WriteImage_Name,
        codec.align(ClipboardHost_WriteImage_Params.encodedSize));
    builder.encodeStruct(ClipboardHost_WriteImage_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ClipboardHostPtr.prototype.writeUnsanitizedCustomFormat = function() {
    return ClipboardHostProxy.prototype.writeUnsanitizedCustomFormat
        .apply(this.ptr.getProxy(), arguments);
  };

  ClipboardHostProxy.prototype.writeUnsanitizedCustomFormat = function(format, data) {
    var params_ = new ClipboardHost_WriteUnsanitizedCustomFormat_Params();
    params_.format = format;
    params_.data = data;
    var builder = new codec.MessageV0Builder(
        kClipboardHost_WriteUnsanitizedCustomFormat_Name,
        codec.align(ClipboardHost_WriteUnsanitizedCustomFormat_Params.encodedSize));
    builder.encodeStruct(ClipboardHost_WriteUnsanitizedCustomFormat_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ClipboardHostPtr.prototype.commitWrite = function() {
    return ClipboardHostProxy.prototype.commitWrite
        .apply(this.ptr.getProxy(), arguments);
  };

  ClipboardHostProxy.prototype.commitWrite = function() {
    var params_ = new ClipboardHost_CommitWrite_Params();
    var builder = new codec.MessageV0Builder(
        kClipboardHost_CommitWrite_Name,
        codec.align(ClipboardHost_CommitWrite_Params.encodedSize));
    builder.encodeStruct(ClipboardHost_CommitWrite_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ClipboardHostPtr.prototype.beginCopyWithCompletion = function() {
    return ClipboardHostProxy.prototype.beginCopyWithCompletion
        .apply(this.ptr.getProxy(), arguments);
  };

  ClipboardHostProxy.prototype.beginCopyWithCompletion = function(token) {
    var params_ = new ClipboardHost_BeginCopyWithCompletion_Params();
    params_.token = token;
    var builder = new codec.MessageV0Builder(
        kClipboardHost_BeginCopyWithCompletion_Name,
        codec.align(ClipboardHost_BeginCopyWithCompletion_Params.encodedSize));
    builder.encodeStruct(ClipboardHost_BeginCopyWithCompletion_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ClipboardHostPtr.prototype.endCopyWithCompletion = function() {
    return ClipboardHostProxy.prototype.endCopyWithCompletion
        .apply(this.ptr.getProxy(), arguments);
  };

  ClipboardHostProxy.prototype.endCopyWithCompletion = function(token) {
    var params_ = new ClipboardHost_EndCopyWithCompletion_Params();
    params_.token = token;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kClipboardHost_EndCopyWithCompletion_Name,
          codec.align(ClipboardHost_EndCopyWithCompletion_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ClipboardHost_EndCopyWithCompletion_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ClipboardHost_EndCopyWithCompletion_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ClipboardHostPtr.prototype.beginPasteWithCompletion = function() {
    return ClipboardHostProxy.prototype.beginPasteWithCompletion
        .apply(this.ptr.getProxy(), arguments);
  };

  ClipboardHostProxy.prototype.beginPasteWithCompletion = function(token) {
    var params_ = new ClipboardHost_BeginPasteWithCompletion_Params();
    params_.token = token;
    var builder = new codec.MessageV0Builder(
        kClipboardHost_BeginPasteWithCompletion_Name,
        codec.align(ClipboardHost_BeginPasteWithCompletion_Params.encodedSize));
    builder.encodeStruct(ClipboardHost_BeginPasteWithCompletion_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ClipboardHostPtr.prototype.endPasteWithCompletion = function() {
    return ClipboardHostProxy.prototype.endPasteWithCompletion
        .apply(this.ptr.getProxy(), arguments);
  };

  ClipboardHostProxy.prototype.endPasteWithCompletion = function(token) {
    var params_ = new ClipboardHost_EndPasteWithCompletion_Params();
    params_.token = token;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kClipboardHost_EndPasteWithCompletion_Name,
          codec.align(ClipboardHost_EndPasteWithCompletion_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ClipboardHost_EndPasteWithCompletion_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ClipboardHost_EndPasteWithCompletion_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ClipboardHostPtr.prototype.writeStringToFindPboard = function() {
    return ClipboardHostProxy.prototype.writeStringToFindPboard
        .apply(this.ptr.getProxy(), arguments);
  };

  ClipboardHostProxy.prototype.writeStringToFindPboard = function(text) {
    var params_ = new ClipboardHost_WriteStringToFindPboard_Params();
    params_.text = text;
    var builder = new codec.MessageV0Builder(
        kClipboardHost_WriteStringToFindPboard_Name,
        codec.align(ClipboardHost_WriteStringToFindPboard_Params.encodedSize));
    builder.encodeStruct(ClipboardHost_WriteStringToFindPboard_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ClipboardHostPtr.prototype.getPlatformPermissionState = function() {
    return ClipboardHostProxy.prototype.getPlatformPermissionState
        .apply(this.ptr.getProxy(), arguments);
  };

  ClipboardHostProxy.prototype.getPlatformPermissionState = function() {
    var params_ = new ClipboardHost_GetPlatformPermissionState_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kClipboardHost_GetPlatformPermissionState_Name,
          codec.align(ClipboardHost_GetPlatformPermissionState_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ClipboardHost_GetPlatformPermissionState_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ClipboardHost_GetPlatformPermissionState_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ClipboardHostPtr.prototype.registerClipboardListener = function() {
    return ClipboardHostProxy.prototype.registerClipboardListener
        .apply(this.ptr.getProxy(), arguments);
  };

  ClipboardHostProxy.prototype.registerClipboardListener = function(listener) {
    var params_ = new ClipboardHost_RegisterClipboardListener_Params();
    params_.listener = listener;
    var builder = new codec.MessageV0Builder(
        kClipboardHost_RegisterClipboardListener_Name,
        codec.align(ClipboardHost_RegisterClipboardListener_Params.encodedSize));
    builder.encodeStruct(ClipboardHost_RegisterClipboardListener_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function ClipboardHostStub(delegate) {
    this.delegate_ = delegate;
  }
  ClipboardHostStub.prototype.getSequenceNumber = function(buffer) {
    return this.delegate_ && this.delegate_.getSequenceNumber && this.delegate_.getSequenceNumber(buffer);
  }
  ClipboardHostStub.prototype.isFormatAvailable = function(format, buffer) {
    return this.delegate_ && this.delegate_.isFormatAvailable && this.delegate_.isFormatAvailable(format, buffer);
  }
  ClipboardHostStub.prototype.readAvailableTypes = function(buffer) {
    return this.delegate_ && this.delegate_.readAvailableTypes && this.delegate_.readAvailableTypes(buffer);
  }
  ClipboardHostStub.prototype.readText = function(buffer) {
    return this.delegate_ && this.delegate_.readText && this.delegate_.readText(buffer);
  }
  ClipboardHostStub.prototype.readHtml = function(buffer) {
    return this.delegate_ && this.delegate_.readHtml && this.delegate_.readHtml(buffer);
  }
  ClipboardHostStub.prototype.readSvg = function(buffer) {
    return this.delegate_ && this.delegate_.readSvg && this.delegate_.readSvg(buffer);
  }
  ClipboardHostStub.prototype.readRtf = function(buffer) {
    return this.delegate_ && this.delegate_.readRtf && this.delegate_.readRtf(buffer);
  }
  ClipboardHostStub.prototype.readPng = function(buffer) {
    return this.delegate_ && this.delegate_.readPng && this.delegate_.readPng(buffer);
  }
  ClipboardHostStub.prototype.readFiles = function(buffer) {
    return this.delegate_ && this.delegate_.readFiles && this.delegate_.readFiles(buffer);
  }
  ClipboardHostStub.prototype.readDataTransferCustomData = function(buffer, type) {
    return this.delegate_ && this.delegate_.readDataTransferCustomData && this.delegate_.readDataTransferCustomData(buffer, type);
  }
  ClipboardHostStub.prototype.readAvailableCustomAndStandardFormats = function() {
    return this.delegate_ && this.delegate_.readAvailableCustomAndStandardFormats && this.delegate_.readAvailableCustomAndStandardFormats();
  }
  ClipboardHostStub.prototype.readUnsanitizedCustomFormat = function(format) {
    return this.delegate_ && this.delegate_.readUnsanitizedCustomFormat && this.delegate_.readUnsanitizedCustomFormat(format);
  }
  ClipboardHostStub.prototype.writeText = function(text) {
    return this.delegate_ && this.delegate_.writeText && this.delegate_.writeText(text);
  }
  ClipboardHostStub.prototype.writeHtml = function(markup, url) {
    return this.delegate_ && this.delegate_.writeHtml && this.delegate_.writeHtml(markup, url);
  }
  ClipboardHostStub.prototype.writeSvg = function(markup) {
    return this.delegate_ && this.delegate_.writeSvg && this.delegate_.writeSvg(markup);
  }
  ClipboardHostStub.prototype.writeSmartPasteMarker = function() {
    return this.delegate_ && this.delegate_.writeSmartPasteMarker && this.delegate_.writeSmartPasteMarker();
  }
  ClipboardHostStub.prototype.writeDataTransferCustomData = function(data) {
    return this.delegate_ && this.delegate_.writeDataTransferCustomData && this.delegate_.writeDataTransferCustomData(data);
  }
  ClipboardHostStub.prototype.writeBookmark = function(url, title) {
    return this.delegate_ && this.delegate_.writeBookmark && this.delegate_.writeBookmark(url, title);
  }
  ClipboardHostStub.prototype.writeImage = function(image) {
    return this.delegate_ && this.delegate_.writeImage && this.delegate_.writeImage(image);
  }
  ClipboardHostStub.prototype.writeUnsanitizedCustomFormat = function(format, data) {
    return this.delegate_ && this.delegate_.writeUnsanitizedCustomFormat && this.delegate_.writeUnsanitizedCustomFormat(format, data);
  }
  ClipboardHostStub.prototype.commitWrite = function() {
    return this.delegate_ && this.delegate_.commitWrite && this.delegate_.commitWrite();
  }
  ClipboardHostStub.prototype.beginCopyWithCompletion = function(token) {
    return this.delegate_ && this.delegate_.beginCopyWithCompletion && this.delegate_.beginCopyWithCompletion(token);
  }
  ClipboardHostStub.prototype.endCopyWithCompletion = function(token) {
    return this.delegate_ && this.delegate_.endCopyWithCompletion && this.delegate_.endCopyWithCompletion(token);
  }
  ClipboardHostStub.prototype.beginPasteWithCompletion = function(token) {
    return this.delegate_ && this.delegate_.beginPasteWithCompletion && this.delegate_.beginPasteWithCompletion(token);
  }
  ClipboardHostStub.prototype.endPasteWithCompletion = function(token) {
    return this.delegate_ && this.delegate_.endPasteWithCompletion && this.delegate_.endPasteWithCompletion(token);
  }
  ClipboardHostStub.prototype.writeStringToFindPboard = function(text) {
    return this.delegate_ && this.delegate_.writeStringToFindPboard && this.delegate_.writeStringToFindPboard(text);
  }
  ClipboardHostStub.prototype.getPlatformPermissionState = function() {
    return this.delegate_ && this.delegate_.getPlatformPermissionState && this.delegate_.getPlatformPermissionState();
  }
  ClipboardHostStub.prototype.registerClipboardListener = function(listener) {
    return this.delegate_ && this.delegate_.registerClipboardListener && this.delegate_.registerClipboardListener(listener);
  }

  ClipboardHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kClipboardHost_WriteText_Name:
      var params = reader.decodeStruct(ClipboardHost_WriteText_Params);
      this.writeText(params.text);
      return true;
    case kClipboardHost_WriteHtml_Name:
      var params = reader.decodeStruct(ClipboardHost_WriteHtml_Params);
      this.writeHtml(params.markup, params.url);
      return true;
    case kClipboardHost_WriteSvg_Name:
      var params = reader.decodeStruct(ClipboardHost_WriteSvg_Params);
      this.writeSvg(params.markup);
      return true;
    case kClipboardHost_WriteSmartPasteMarker_Name:
      var params = reader.decodeStruct(ClipboardHost_WriteSmartPasteMarker_Params);
      this.writeSmartPasteMarker();
      return true;
    case kClipboardHost_WriteDataTransferCustomData_Name:
      var params = reader.decodeStruct(ClipboardHost_WriteDataTransferCustomData_Params);
      this.writeDataTransferCustomData(params.data);
      return true;
    case kClipboardHost_WriteBookmark_Name:
      var params = reader.decodeStruct(ClipboardHost_WriteBookmark_Params);
      this.writeBookmark(params.url, params.title);
      return true;
    case kClipboardHost_WriteImage_Name:
      var params = reader.decodeStruct(ClipboardHost_WriteImage_Params);
      this.writeImage(params.image);
      return true;
    case kClipboardHost_WriteUnsanitizedCustomFormat_Name:
      var params = reader.decodeStruct(ClipboardHost_WriteUnsanitizedCustomFormat_Params);
      this.writeUnsanitizedCustomFormat(params.format, params.data);
      return true;
    case kClipboardHost_CommitWrite_Name:
      var params = reader.decodeStruct(ClipboardHost_CommitWrite_Params);
      this.commitWrite();
      return true;
    case kClipboardHost_BeginCopyWithCompletion_Name:
      var params = reader.decodeStruct(ClipboardHost_BeginCopyWithCompletion_Params);
      this.beginCopyWithCompletion(params.token);
      return true;
    case kClipboardHost_BeginPasteWithCompletion_Name:
      var params = reader.decodeStruct(ClipboardHost_BeginPasteWithCompletion_Params);
      this.beginPasteWithCompletion(params.token);
      return true;
    case kClipboardHost_WriteStringToFindPboard_Name:
      var params = reader.decodeStruct(ClipboardHost_WriteStringToFindPboard_Params);
      this.writeStringToFindPboard(params.text);
      return true;
    case kClipboardHost_RegisterClipboardListener_Name:
      var params = reader.decodeStruct(ClipboardHost_RegisterClipboardListener_Params);
      this.registerClipboardListener(params.listener);
      return true;
    default:
      return false;
    }
  };

  ClipboardHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kClipboardHost_GetSequenceNumber_Name:
      var params = reader.decodeStruct(ClipboardHost_GetSequenceNumber_Params);
      this.getSequenceNumber(params.buffer).then(function(response) {
        var responseParams =
            new ClipboardHost_GetSequenceNumber_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kClipboardHost_GetSequenceNumber_Name,
            codec.align(ClipboardHost_GetSequenceNumber_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ClipboardHost_GetSequenceNumber_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kClipboardHost_IsFormatAvailable_Name:
      var params = reader.decodeStruct(ClipboardHost_IsFormatAvailable_Params);
      this.isFormatAvailable(params.format, params.buffer).then(function(response) {
        var responseParams =
            new ClipboardHost_IsFormatAvailable_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kClipboardHost_IsFormatAvailable_Name,
            codec.align(ClipboardHost_IsFormatAvailable_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ClipboardHost_IsFormatAvailable_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kClipboardHost_ReadAvailableTypes_Name:
      var params = reader.decodeStruct(ClipboardHost_ReadAvailableTypes_Params);
      this.readAvailableTypes(params.buffer).then(function(response) {
        var responseParams =
            new ClipboardHost_ReadAvailableTypes_ResponseParams();
        responseParams.types = response.types;
        var builder = new codec.MessageV1Builder(
            kClipboardHost_ReadAvailableTypes_Name,
            codec.align(ClipboardHost_ReadAvailableTypes_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ClipboardHost_ReadAvailableTypes_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kClipboardHost_ReadText_Name:
      var params = reader.decodeStruct(ClipboardHost_ReadText_Params);
      this.readText(params.buffer).then(function(response) {
        var responseParams =
            new ClipboardHost_ReadText_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kClipboardHost_ReadText_Name,
            codec.align(ClipboardHost_ReadText_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ClipboardHost_ReadText_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kClipboardHost_ReadHtml_Name:
      var params = reader.decodeStruct(ClipboardHost_ReadHtml_Params);
      this.readHtml(params.buffer).then(function(response) {
        var responseParams =
            new ClipboardHost_ReadHtml_ResponseParams();
        responseParams.markup = response.markup;
        responseParams.url = response.url;
        responseParams.fragmentStart = response.fragmentStart;
        responseParams.fragmentEnd = response.fragmentEnd;
        var builder = new codec.MessageV1Builder(
            kClipboardHost_ReadHtml_Name,
            codec.align(ClipboardHost_ReadHtml_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ClipboardHost_ReadHtml_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kClipboardHost_ReadSvg_Name:
      var params = reader.decodeStruct(ClipboardHost_ReadSvg_Params);
      this.readSvg(params.buffer).then(function(response) {
        var responseParams =
            new ClipboardHost_ReadSvg_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kClipboardHost_ReadSvg_Name,
            codec.align(ClipboardHost_ReadSvg_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ClipboardHost_ReadSvg_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kClipboardHost_ReadRtf_Name:
      var params = reader.decodeStruct(ClipboardHost_ReadRtf_Params);
      this.readRtf(params.buffer).then(function(response) {
        var responseParams =
            new ClipboardHost_ReadRtf_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kClipboardHost_ReadRtf_Name,
            codec.align(ClipboardHost_ReadRtf_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ClipboardHost_ReadRtf_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kClipboardHost_ReadPng_Name:
      var params = reader.decodeStruct(ClipboardHost_ReadPng_Params);
      this.readPng(params.buffer).then(function(response) {
        var responseParams =
            new ClipboardHost_ReadPng_ResponseParams();
        responseParams.png = response.png;
        var builder = new codec.MessageV1Builder(
            kClipboardHost_ReadPng_Name,
            codec.align(ClipboardHost_ReadPng_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ClipboardHost_ReadPng_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kClipboardHost_ReadFiles_Name:
      var params = reader.decodeStruct(ClipboardHost_ReadFiles_Params);
      this.readFiles(params.buffer).then(function(response) {
        var responseParams =
            new ClipboardHost_ReadFiles_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kClipboardHost_ReadFiles_Name,
            codec.align(ClipboardHost_ReadFiles_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ClipboardHost_ReadFiles_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kClipboardHost_ReadDataTransferCustomData_Name:
      var params = reader.decodeStruct(ClipboardHost_ReadDataTransferCustomData_Params);
      this.readDataTransferCustomData(params.buffer, params.type).then(function(response) {
        var responseParams =
            new ClipboardHost_ReadDataTransferCustomData_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kClipboardHost_ReadDataTransferCustomData_Name,
            codec.align(ClipboardHost_ReadDataTransferCustomData_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ClipboardHost_ReadDataTransferCustomData_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kClipboardHost_ReadAvailableCustomAndStandardFormats_Name:
      var params = reader.decodeStruct(ClipboardHost_ReadAvailableCustomAndStandardFormats_Params);
      this.readAvailableCustomAndStandardFormats().then(function(response) {
        var responseParams =
            new ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParams();
        responseParams.formatTypes = response.formatTypes;
        var builder = new codec.MessageV1Builder(
            kClipboardHost_ReadAvailableCustomAndStandardFormats_Name,
            codec.align(ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kClipboardHost_ReadUnsanitizedCustomFormat_Name:
      var params = reader.decodeStruct(ClipboardHost_ReadUnsanitizedCustomFormat_Params);
      this.readUnsanitizedCustomFormat(params.format).then(function(response) {
        var responseParams =
            new ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParams();
        responseParams.data = response.data;
        var builder = new codec.MessageV1Builder(
            kClipboardHost_ReadUnsanitizedCustomFormat_Name,
            codec.align(ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kClipboardHost_EndCopyWithCompletion_Name:
      var params = reader.decodeStruct(ClipboardHost_EndCopyWithCompletion_Params);
      this.endCopyWithCompletion(params.token).then(function(response) {
        var responseParams =
            new ClipboardHost_EndCopyWithCompletion_ResponseParams();
        responseParams.token = response.token;
        var builder = new codec.MessageV1Builder(
            kClipboardHost_EndCopyWithCompletion_Name,
            codec.align(ClipboardHost_EndCopyWithCompletion_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ClipboardHost_EndCopyWithCompletion_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kClipboardHost_EndPasteWithCompletion_Name:
      var params = reader.decodeStruct(ClipboardHost_EndPasteWithCompletion_Params);
      this.endPasteWithCompletion(params.token).then(function(response) {
        var responseParams =
            new ClipboardHost_EndPasteWithCompletion_ResponseParams();
        responseParams.token = response.token;
        var builder = new codec.MessageV1Builder(
            kClipboardHost_EndPasteWithCompletion_Name,
            codec.align(ClipboardHost_EndPasteWithCompletion_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ClipboardHost_EndPasteWithCompletion_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kClipboardHost_GetPlatformPermissionState_Name:
      var params = reader.decodeStruct(ClipboardHost_GetPlatformPermissionState_Params);
      this.getPlatformPermissionState().then(function(response) {
        var responseParams =
            new ClipboardHost_GetPlatformPermissionState_ResponseParams();
        responseParams.state = response.state;
        var builder = new codec.MessageV1Builder(
            kClipboardHost_GetPlatformPermissionState_Name,
            codec.align(ClipboardHost_GetPlatformPermissionState_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ClipboardHost_GetPlatformPermissionState_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateClipboardHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kClipboardHost_GetSequenceNumber_Name:
        if (message.expectsResponse())
          paramsClass = ClipboardHost_GetSequenceNumber_Params;
      break;
      case kClipboardHost_IsFormatAvailable_Name:
        if (message.expectsResponse())
          paramsClass = ClipboardHost_IsFormatAvailable_Params;
      break;
      case kClipboardHost_ReadAvailableTypes_Name:
        if (message.expectsResponse())
          paramsClass = ClipboardHost_ReadAvailableTypes_Params;
      break;
      case kClipboardHost_ReadText_Name:
        if (message.expectsResponse())
          paramsClass = ClipboardHost_ReadText_Params;
      break;
      case kClipboardHost_ReadHtml_Name:
        if (message.expectsResponse())
          paramsClass = ClipboardHost_ReadHtml_Params;
      break;
      case kClipboardHost_ReadSvg_Name:
        if (message.expectsResponse())
          paramsClass = ClipboardHost_ReadSvg_Params;
      break;
      case kClipboardHost_ReadRtf_Name:
        if (message.expectsResponse())
          paramsClass = ClipboardHost_ReadRtf_Params;
      break;
      case kClipboardHost_ReadPng_Name:
        if (message.expectsResponse())
          paramsClass = ClipboardHost_ReadPng_Params;
      break;
      case kClipboardHost_ReadFiles_Name:
        if (message.expectsResponse())
          paramsClass = ClipboardHost_ReadFiles_Params;
      break;
      case kClipboardHost_ReadDataTransferCustomData_Name:
        if (message.expectsResponse())
          paramsClass = ClipboardHost_ReadDataTransferCustomData_Params;
      break;
      case kClipboardHost_ReadAvailableCustomAndStandardFormats_Name:
        if (message.expectsResponse())
          paramsClass = ClipboardHost_ReadAvailableCustomAndStandardFormats_Params;
      break;
      case kClipboardHost_ReadUnsanitizedCustomFormat_Name:
        if (message.expectsResponse())
          paramsClass = ClipboardHost_ReadUnsanitizedCustomFormat_Params;
      break;
      case kClipboardHost_WriteText_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ClipboardHost_WriteText_Params;
      break;
      case kClipboardHost_WriteHtml_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ClipboardHost_WriteHtml_Params;
      break;
      case kClipboardHost_WriteSvg_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ClipboardHost_WriteSvg_Params;
      break;
      case kClipboardHost_WriteSmartPasteMarker_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ClipboardHost_WriteSmartPasteMarker_Params;
      break;
      case kClipboardHost_WriteDataTransferCustomData_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ClipboardHost_WriteDataTransferCustomData_Params;
      break;
      case kClipboardHost_WriteBookmark_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ClipboardHost_WriteBookmark_Params;
      break;
      case kClipboardHost_WriteImage_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ClipboardHost_WriteImage_Params;
      break;
      case kClipboardHost_WriteUnsanitizedCustomFormat_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ClipboardHost_WriteUnsanitizedCustomFormat_Params;
      break;
      case kClipboardHost_CommitWrite_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ClipboardHost_CommitWrite_Params;
      break;
      case kClipboardHost_BeginCopyWithCompletion_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ClipboardHost_BeginCopyWithCompletion_Params;
      break;
      case kClipboardHost_EndCopyWithCompletion_Name:
        if (message.expectsResponse())
          paramsClass = ClipboardHost_EndCopyWithCompletion_Params;
      break;
      case kClipboardHost_BeginPasteWithCompletion_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ClipboardHost_BeginPasteWithCompletion_Params;
      break;
      case kClipboardHost_EndPasteWithCompletion_Name:
        if (message.expectsResponse())
          paramsClass = ClipboardHost_EndPasteWithCompletion_Params;
      break;
      case kClipboardHost_WriteStringToFindPboard_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ClipboardHost_WriteStringToFindPboard_Params;
      break;
      case kClipboardHost_GetPlatformPermissionState_Name:
        if (message.expectsResponse())
          paramsClass = ClipboardHost_GetPlatformPermissionState_Params;
      break;
      case kClipboardHost_RegisterClipboardListener_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ClipboardHost_RegisterClipboardListener_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateClipboardHostResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kClipboardHost_GetSequenceNumber_Name:
        if (message.isResponse())
          paramsClass = ClipboardHost_GetSequenceNumber_ResponseParams;
        break;
      case kClipboardHost_IsFormatAvailable_Name:
        if (message.isResponse())
          paramsClass = ClipboardHost_IsFormatAvailable_ResponseParams;
        break;
      case kClipboardHost_ReadAvailableTypes_Name:
        if (message.isResponse())
          paramsClass = ClipboardHost_ReadAvailableTypes_ResponseParams;
        break;
      case kClipboardHost_ReadText_Name:
        if (message.isResponse())
          paramsClass = ClipboardHost_ReadText_ResponseParams;
        break;
      case kClipboardHost_ReadHtml_Name:
        if (message.isResponse())
          paramsClass = ClipboardHost_ReadHtml_ResponseParams;
        break;
      case kClipboardHost_ReadSvg_Name:
        if (message.isResponse())
          paramsClass = ClipboardHost_ReadSvg_ResponseParams;
        break;
      case kClipboardHost_ReadRtf_Name:
        if (message.isResponse())
          paramsClass = ClipboardHost_ReadRtf_ResponseParams;
        break;
      case kClipboardHost_ReadPng_Name:
        if (message.isResponse())
          paramsClass = ClipboardHost_ReadPng_ResponseParams;
        break;
      case kClipboardHost_ReadFiles_Name:
        if (message.isResponse())
          paramsClass = ClipboardHost_ReadFiles_ResponseParams;
        break;
      case kClipboardHost_ReadDataTransferCustomData_Name:
        if (message.isResponse())
          paramsClass = ClipboardHost_ReadDataTransferCustomData_ResponseParams;
        break;
      case kClipboardHost_ReadAvailableCustomAndStandardFormats_Name:
        if (message.isResponse())
          paramsClass = ClipboardHost_ReadAvailableCustomAndStandardFormats_ResponseParams;
        break;
      case kClipboardHost_ReadUnsanitizedCustomFormat_Name:
        if (message.isResponse())
          paramsClass = ClipboardHost_ReadUnsanitizedCustomFormat_ResponseParams;
        break;
      case kClipboardHost_EndCopyWithCompletion_Name:
        if (message.isResponse())
          paramsClass = ClipboardHost_EndCopyWithCompletion_ResponseParams;
        break;
      case kClipboardHost_EndPasteWithCompletion_Name:
        if (message.isResponse())
          paramsClass = ClipboardHost_EndPasteWithCompletion_ResponseParams;
        break;
      case kClipboardHost_GetPlatformPermissionState_Name:
        if (message.isResponse())
          paramsClass = ClipboardHost_GetPlatformPermissionState_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var ClipboardHost = {
    name: 'blink.mojom.ClipboardHost',
    kVersion: 0,
    ptrClass: ClipboardHostPtr,
    proxyClass: ClipboardHostProxy,
    stubClass: ClipboardHostStub,
    validateRequest: validateClipboardHostRequest,
    validateResponse: validateClipboardHostResponse,
  };
  ClipboardHost.MAX_FORMAT_SIZE = 1024,
  ClipboardHost.MAX_DATA_SIZE = 1073741824,
  ClipboardHostStub.prototype.validator = validateClipboardHostRequest;
  ClipboardHostProxy.prototype.validator = validateClipboardHostResponse;
  exports.ClipboardFormat = ClipboardFormat;
  exports.ClipboardBuffer = ClipboardBuffer;
  exports.PlatformClipboardPermissionState = PlatformClipboardPermissionState;
  exports.ClipboardFiles = ClipboardFiles;
  exports.ClipboardListener = ClipboardListener;
  exports.ClipboardListenerPtr = ClipboardListenerPtr;
  exports.ClipboardListenerAssociatedPtr = ClipboardListenerAssociatedPtr;
  exports.ClipboardHost = ClipboardHost;
  exports.ClipboardHostPtr = ClipboardHostPtr;
  exports.ClipboardHostAssociatedPtr = ClipboardHostAssociatedPtr;
})();