// third_party/blink/public/mojom/clipboard/clipboard.mojom-blink-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CLIPBOARD_CLIPBOARD_MOJOM_BLINK_TEST_UTILS_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CLIPBOARD_CLIPBOARD_MOJOM_BLINK_TEST_UTILS_H_

#include "third_party/blink/public/mojom/clipboard/clipboard.mojom-blink.h"
#include "third_party/blink/renderer/platform/platform_export.h"


namespace blink::mojom::blink {


class PLATFORM_EXPORT ClipboardListenerInterceptorForTesting : public ClipboardListener {
  virtual ClipboardListener* GetForwardingInterface() = 0;
  void OnClipboardDataChanged() override;
};
class PLATFORM_EXPORT ClipboardListenerAsyncWaiter {
 public:
  explicit ClipboardListenerAsyncWaiter(ClipboardListener* proxy);

  ClipboardListenerAsyncWaiter(const ClipboardListenerAsyncWaiter&) = delete;
  ClipboardListenerAsyncWaiter& operator=(const ClipboardListenerAsyncWaiter&) = delete;

  ~ClipboardListenerAsyncWaiter();

 private:
  ClipboardListener* const proxy_;
};


class PLATFORM_EXPORT ClipboardHostInterceptorForTesting : public ClipboardHost {
  virtual ClipboardHost* GetForwardingInterface() = 0;
  void GetSequenceNumber(ClipboardBuffer buffer, GetSequenceNumberCallback callback) override;
  void IsFormatAvailable(ClipboardFormat format, ClipboardBuffer buffer, IsFormatAvailableCallback callback) override;
  void ReadAvailableTypes(ClipboardBuffer buffer, ReadAvailableTypesCallback callback) override;
  void ReadText(ClipboardBuffer buffer, ReadTextCallback callback) override;
  void ReadHtml(ClipboardBuffer buffer, ReadHtmlCallback callback) override;
  void ReadSvg(ClipboardBuffer buffer, ReadSvgCallback callback) override;
  void ReadRtf(ClipboardBuffer buffer, ReadRtfCallback callback) override;
  void ReadPng(ClipboardBuffer buffer, ReadPngCallback callback) override;
  void ReadFiles(ClipboardBuffer buffer, ReadFilesCallback callback) override;
  void ReadDataTransferCustomData(ClipboardBuffer buffer, const ::blink::String& type, ReadDataTransferCustomDataCallback callback) override;
  void ReadAvailableCustomAndStandardFormats(ReadAvailableCustomAndStandardFormatsCallback callback) override;
  void ReadUnsanitizedCustomFormat(const ::blink::String& format, ReadUnsanitizedCustomFormatCallback callback) override;
  void WriteText(const ::blink::String& text) override;
  void WriteHtml(const ::blink::String& markup, const ::blink::KURL& url) override;
  void WriteSvg(const ::blink::String& markup) override;
  void WriteSmartPasteMarker() override;
  void WriteDataTransferCustomData(const ::blink::HashMap<::blink::String, ::blink::String>& data) override;
  void WriteBookmark(const ::blink::String& url, const ::blink::String& title) override;
  void WriteImage(const ::SkBitmap& image) override;
  void WriteUnsanitizedCustomFormat(const ::blink::String& format, ::mojo_base::BigBuffer data) override;
  void CommitWrite() override;
  void BeginCopyWithCompletion(int32_t token) override;
  void EndCopyWithCompletion(int32_t token, EndCopyWithCompletionCallback callback) override;
  void BeginPasteWithCompletion(int32_t token) override;
  void EndPasteWithCompletion(int32_t token, EndPasteWithCompletionCallback callback) override;
  void WriteStringToFindPboard(const ::blink::String& text) override;
  void GetPlatformPermissionState(GetPlatformPermissionStateCallback callback) override;
  void RegisterClipboardListener(::mojo::PendingRemote<ClipboardListener> listener) override;
};
class PLATFORM_EXPORT ClipboardHostAsyncWaiter {
 public:
  explicit ClipboardHostAsyncWaiter(ClipboardHost* proxy);

  ClipboardHostAsyncWaiter(const ClipboardHostAsyncWaiter&) = delete;
  ClipboardHostAsyncWaiter& operator=(const ClipboardHostAsyncWaiter&) = delete;

  ~ClipboardHostAsyncWaiter();
  void GetSequenceNumber(
      ClipboardBuffer buffer, ::absl::uint128* out_result);
  ::absl::uint128 GetSequenceNumber(ClipboardBuffer buffer);
  void IsFormatAvailable(
      ClipboardFormat format, ClipboardBuffer buffer, bool* out_result);
  bool IsFormatAvailable(ClipboardFormat format, ClipboardBuffer buffer);
  void ReadAvailableTypes(
      ClipboardBuffer buffer, ::blink::Vector<::blink::String>* out_types);
  ::blink::Vector<::blink::String> ReadAvailableTypes(ClipboardBuffer buffer);
  void ReadText(
      ClipboardBuffer buffer, ::blink::String* out_result);
  ::blink::String ReadText(ClipboardBuffer buffer);
  void ReadHtml(
      ClipboardBuffer buffer, ::blink::String* out_markup, ::blink::KURL* out_url, uint32_t* out_fragment_start, uint32_t* out_fragment_end);
  
  void ReadSvg(
      ClipboardBuffer buffer, ::blink::String* out_result);
  ::blink::String ReadSvg(ClipboardBuffer buffer);
  void ReadRtf(
      ClipboardBuffer buffer, ::blink::String* out_result);
  ::blink::String ReadRtf(ClipboardBuffer buffer);
  void ReadPng(
      ClipboardBuffer buffer, ::mojo_base::BigBuffer* out_png);
  ::mojo_base::BigBuffer ReadPng(ClipboardBuffer buffer);
  void ReadFiles(
      ClipboardBuffer buffer, ClipboardFilesPtr* out_result);
  ClipboardFilesPtr ReadFiles(ClipboardBuffer buffer);
  void ReadDataTransferCustomData(
      ClipboardBuffer buffer, const ::blink::String& type, ::blink::String* out_result);
  ::blink::String ReadDataTransferCustomData(ClipboardBuffer buffer, const ::blink::String& type);
  void ReadAvailableCustomAndStandardFormats(
      ::blink::Vector<::blink::String>* out_format_types);
  ::blink::Vector<::blink::String> ReadAvailableCustomAndStandardFormats();
  void ReadUnsanitizedCustomFormat(
      const ::blink::String& format, ::mojo_base::BigBuffer* out_data);
  ::mojo_base::BigBuffer ReadUnsanitizedCustomFormat(const ::blink::String& format);
  void EndCopyWithCompletion(
      int32_t token, int32_t* out_token);
  int32_t EndCopyWithCompletion(int32_t token);
  void EndPasteWithCompletion(
      int32_t token, int32_t* out_token);
  int32_t EndPasteWithCompletion(int32_t token);
  void GetPlatformPermissionState(
      PlatformClipboardPermissionState* out_state);
  PlatformClipboardPermissionState GetPlatformPermissionState();

 private:
  ClipboardHost* const proxy_;
};




}  // blink::mojom::blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CLIPBOARD_CLIPBOARD_MOJOM_BLINK_TEST_UTILS_H_