// third_party/blink/public/mojom/choosers/file_chooser.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.FileChooserPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.FileChooser.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.FileChooserInterface }
 */
blink.mojom.FileChooserRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.FileChooserPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.FileChooserPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.FileChooserPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.FileChooserParams } params
   * @return {!Promise<{
        result: ?blink.mojom.FileChooserResult,
   *  }>}
   */

  openFileChooser(
      params) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.FileChooser_OpenFileChooser_ParamsSpec.$,
        blink.mojom.FileChooser_OpenFileChooser_ResponseParamsSpec.$,
        [
          params
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.FilePath } directoryPath
   * @return {!Promise<{
        result: ?blink.mojom.FileChooserResult,
   *  }>}
   */

  enumerateChosenDirectory(
      directoryPath) {
    return this.proxy.sendMessage(
        1,
        blink.mojom.FileChooser_EnumerateChosenDirectory_ParamsSpec.$,
        blink.mojom.FileChooser_EnumerateChosenDirectory_ResponseParamsSpec.$,
        [
          directoryPath
        ],
        false);
  }
};

/**
 * An object which receives request messages for the FileChooser
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.FileChooserReceiver = class {
  /**
   * @param {!blink.mojom.FileChooserInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.FileChooserRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.FileChooserRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FileChooserRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FileChooser_OpenFileChooser_ParamsSpec.$,
        blink.mojom.FileChooser_OpenFileChooser_ResponseParamsSpec.$,
        impl.openFileChooser.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FileChooser_EnumerateChosenDirectory_ParamsSpec.$,
        blink.mojom.FileChooser_EnumerateChosenDirectory_ResponseParamsSpec.$,
        impl.enumerateChosenDirectory.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.FileChooser = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FileChooser";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.FileChooserRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.FileChooserRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the FileChooser
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.FileChooserCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.FileChooserRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FileChooserRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openFileChooser =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FileChooser_OpenFileChooser_ParamsSpec.$,
        blink.mojom.FileChooser_OpenFileChooser_ResponseParamsSpec.$,
        this.openFileChooser.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enumerateChosenDirectory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FileChooser_EnumerateChosenDirectory_ParamsSpec.$,
        blink.mojom.FileChooser_EnumerateChosenDirectory_ResponseParamsSpec.$,
        this.enumerateChosenDirectory.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileChooserParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.NativeFileInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemFileInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileChooserResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileChooser_OpenFileChooser_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileChooser_OpenFileChooser_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileChooser_EnumerateChosenDirectory_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileChooser_EnumerateChosenDirectory_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
blink.mojom.FileChooserFileInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.FileChooserParamsSpec.ModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.FileChooserParams_Mode = {
  
  kOpen: 0,
  kOpenMultiple: 1,
  kUploadFolder: 2,
  kOpenDirectory: 3,
  kSave: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};


mojo.internal.Struct(
    blink.mojom.FileChooserParamsSpec.$,
    'FileChooserParams',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        blink.mojom.FileChooserParamsSpec.ModeSpec.$,
        blink.mojom.FileChooserParams_Mode.kOpen,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'title', 8,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'defaultFileName', 16,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'selectedFiles', 24,
        0,
        mojo.internal.Array(mojoBase.mojom.FilePathSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'acceptTypes', 32,
        0,
        mojo.internal.Array(mojoBase.mojom.String16Spec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'needLocalPath', 4,
        0,
        mojo.internal.Bool,
        true,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'useMediaCapture', 4,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'openWritable', 4,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requestor', 40,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);





/** @record */
blink.mojom.FileChooserParams = class {
  constructor() {
    /** @export { !blink.mojom.FileChooserParams_Mode } */
    this.mode;
    /** @export { !mojoBase.mojom.String16 } */
    this.title;
    /** @export { !mojoBase.mojom.FilePath } */
    this.defaultFileName;
    /** @export { !Array<!mojoBase.mojom.FilePath> } */
    this.selectedFiles;
    /** @export { !Array<!mojoBase.mojom.String16> } */
    this.acceptTypes;
    /** @export { !boolean } */
    this.needLocalPath;
    /** @export { !boolean } */
    this.useMediaCapture;
    /** @export { !boolean } */
    this.openWritable;
    /** @export { !url.mojom.Url } */
    this.requestor;
  }
};



mojo.internal.Struct(
    blink.mojom.NativeFileInfoSpec.$,
    'NativeFileInfo',
    [
      mojo.internal.StructField(
        'filePath', 0,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'displayName', 8,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'baseSubdirs', 16,
        0,
        mojo.internal.Array(mojoBase.mojom.String16Spec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.NativeFileInfo = class {
  constructor() {
    /** @export { !mojoBase.mojom.FilePath } */
    this.filePath;
    /** @export { !mojoBase.mojom.String16 } */
    this.displayName;
    /** @export { !Array<!mojoBase.mojom.String16> } */
    this.baseSubdirs;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemFileInfoSpec.$,
    'FileSystemFileInfo',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'modificationTime', 8,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'length', 16,
        0,
        mojo.internal.Int64,
        BigInt('0'),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.FileSystemFileInfo = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !mojoBase.mojom.Time } */
    this.modificationTime;
    /** @export { !bigint } */
    this.length;
  }
};



mojo.internal.Struct(
    blink.mojom.FileChooserResultSpec.$,
    'FileChooserResult',
    [
      mojo.internal.StructField(
        'files', 0,
        0,
        mojo.internal.Array(blink.mojom.FileChooserFileInfoSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'baseDirectory', 8,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.FileChooserResult = class {
  constructor() {
    /** @export { !Array<!blink.mojom.FileChooserFileInfo> } */
    this.files;
    /** @export { !mojoBase.mojom.FilePath } */
    this.baseDirectory;
  }
};



mojo.internal.Struct(
    blink.mojom.FileChooser_OpenFileChooser_ParamsSpec.$,
    'FileChooser_OpenFileChooser_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        blink.mojom.FileChooserParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.FileChooser_OpenFileChooser_Params = class {
  constructor() {
    /** @export { !blink.mojom.FileChooserParams } */
    this.params;
  }
};



mojo.internal.Struct(
    blink.mojom.FileChooser_OpenFileChooser_ResponseParamsSpec.$,
    'FileChooser_OpenFileChooser_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.FileChooserResultSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.FileChooser_OpenFileChooser_ResponseParams = class {
  constructor() {
    /** @export { (blink.mojom.FileChooserResult|undefined) } */
    this.result;
  }
};



mojo.internal.Struct(
    blink.mojom.FileChooser_EnumerateChosenDirectory_ParamsSpec.$,
    'FileChooser_EnumerateChosenDirectory_Params',
    [
      mojo.internal.StructField(
        'directoryPath', 0,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.FileChooser_EnumerateChosenDirectory_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.FilePath } */
    this.directoryPath;
  }
};



mojo.internal.Struct(
    blink.mojom.FileChooser_EnumerateChosenDirectory_ResponseParamsSpec.$,
    'FileChooser_EnumerateChosenDirectory_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.FileChooserResultSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.FileChooser_EnumerateChosenDirectory_ResponseParams = class {
  constructor() {
    /** @export { (blink.mojom.FileChooserResult|undefined) } */
    this.result;
  }
};



mojo.internal.Union(
    blink.mojom.FileChooserFileInfoSpec.$, 'FileChooserFileInfo',
    {
      'nativeFile': {
        'ordinal': 0,
        'type': blink.mojom.NativeFileInfoSpec.$,
      },
      'fileSystem': {
        'ordinal': 1,
        'type': blink.mojom.FileSystemFileInfoSpec.$,
      },
    });

/**
 * @typedef { {
 *   nativeFile: (!blink.mojom.NativeFileInfo|undefined),
 *   fileSystem: (!blink.mojom.FileSystemFileInfo|undefined),
 * } }
 */
blink.mojom.FileChooserFileInfo;
