// third_party/blink/public/mojom/choosers/date_time_chooser.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  String16 as mojoBase_mojom_String16,
  String16Spec as mojoBase_mojom_String16Spec
} from '../../../../../mojo/public/mojom/base/string16.mojom.m.js';

import {
  TextInputType as ui_mojom_TextInputType,
  TextInputTypeSpec as ui_mojom_TextInputTypeSpec
} from '../../../../../ui/base/ime/mojom/ime_types.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class DateTimeChooserPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.DateTimeChooser', scope);
  }
}

/** @interface */
export class DateTimeChooserInterface {
  
  /**
   * @param { !DateTimeDialogValue } value
   * @return {!Promise<{
        success: !boolean,
        dialogValue: !number,
   *  }>}
   */

  openDateTimeDialog(value) {}
  
  /**
   */

  closeDateTimeDialog() {}
}

/**
 * @implements { DateTimeChooserInterface }
 */
export class DateTimeChooserRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!DateTimeChooserPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          DateTimeChooserPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!DateTimeChooserPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !DateTimeDialogValue } value
   * @return {!Promise<{
        success: !boolean,
        dialogValue: !number,
   *  }>}
   */

  openDateTimeDialog(
      value) {
    return this.proxy.sendMessage(
        0,
        DateTimeChooser_OpenDateTimeDialog_ParamsSpec.$,
        DateTimeChooser_OpenDateTimeDialog_ResponseParamsSpec.$,
        [
          value
        ],
        false);
  }

  
  /**
   */

  closeDateTimeDialog() {
    this.proxy.sendMessage(
        1,
        DateTimeChooser_CloseDateTimeDialog_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the DateTimeChooser
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DateTimeChooserReceiver {
  /**
   * @param {!DateTimeChooserInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!DateTimeChooserRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        DateTimeChooserRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DateTimeChooserRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        DateTimeChooser_OpenDateTimeDialog_ParamsSpec.$,
        DateTimeChooser_OpenDateTimeDialog_ResponseParamsSpec.$,
        impl.openDateTimeDialog.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        DateTimeChooser_CloseDateTimeDialog_ParamsSpec.$,
        null,
        impl.closeDateTimeDialog.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class DateTimeChooser {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.DateTimeChooser";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!DateTimeChooserRemote}
   */
  static getRemote() {
    let remote = new DateTimeChooserRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the DateTimeChooser
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DateTimeChooserCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      DateTimeChooserRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DateTimeChooserRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openDateTimeDialog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        DateTimeChooser_OpenDateTimeDialog_ParamsSpec.$,
        DateTimeChooser_OpenDateTimeDialog_ResponseParamsSpec.$,
        this.openDateTimeDialog.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.closeDateTimeDialog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        DateTimeChooser_CloseDateTimeDialog_ParamsSpec.$,
        null,
        this.closeDateTimeDialog.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DateTimeSuggestionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DateTimeDialogValueSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DateTimeChooser_OpenDateTimeDialog_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DateTimeChooser_OpenDateTimeDialog_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DateTimeChooser_CloseDateTimeDialog_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    DateTimeSuggestionSpec.$,
    'DateTimeSuggestion',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'localizedValue', 8,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'label', 16,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class DateTimeSuggestion {
  constructor() {
    /** @type { !number } */
    this.value;
    /** @type { !mojoBase_mojom_String16 } */
    this.localizedValue;
    /** @type { !mojoBase_mojom_String16 } */
    this.label;
  }
}



mojo.internal.Struct(
    DateTimeDialogValueSpec.$,
    'DateTimeDialogValue',
    [
      mojo.internal.StructField(
        'dialogType', 0,
        0,
        ui_mojom_TextInputTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dialogValue', 8,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'minimum', 16,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maximum', 24,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'step', 32,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'suggestions', 40,
        0,
        mojo.internal.Array(DateTimeSuggestionSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class DateTimeDialogValue {
  constructor() {
    /** @type { !ui_mojom_TextInputType } */
    this.dialogType;
    /** @type { !number } */
    this.dialogValue;
    /** @type { !number } */
    this.minimum;
    /** @type { !number } */
    this.maximum;
    /** @type { !number } */
    this.step;
    /** @type { !Array<!DateTimeSuggestion> } */
    this.suggestions;
  }
}



mojo.internal.Struct(
    DateTimeChooser_OpenDateTimeDialog_ParamsSpec.$,
    'DateTimeChooser_OpenDateTimeDialog_Params',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        DateTimeDialogValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DateTimeChooser_OpenDateTimeDialog_Params {
  constructor() {
    /** @type { !DateTimeDialogValue } */
    this.value;
  }
}



mojo.internal.Struct(
    DateTimeChooser_OpenDateTimeDialog_ResponseParamsSpec.$,
    'DateTimeChooser_OpenDateTimeDialog_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dialogValue', 8,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class DateTimeChooser_OpenDateTimeDialog_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
    /** @type { !number } */
    this.dialogValue;
  }
}



mojo.internal.Struct(
    DateTimeChooser_CloseDateTimeDialog_ParamsSpec.$,
    'DateTimeChooser_CloseDateTimeDialog_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class DateTimeChooser_CloseDateTimeDialog_Params {
  constructor() {
  }
}

